# EDQM PDF characteristics: Intended Site - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EDQM PDF characteristics: Intended Site**

## ValueSet: EDQM PDF characteristics: Intended Site 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/edqm-ISI | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:edqm-ISI |

 
EDQM Pharmaceutical dose forms characteristics: Intended Site 

 **References** 

* [Pharmaceutical dose form - IntendedSite](StructureDefinition-intended-site.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "edqm-ISI",
  "url" : "http://who-umc.org/idmp/ValueSet/edqm-ISI",
  "version" : "0.1.0",
  "name" : "edqm-ISI",
  "title" : "EDQM PDF characteristics: Intended Site",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "EDQM Pharmaceutical dose forms characteristics: Intended Site",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "concept" : [
          {
            "code" : "ISI-0021",
            "display" : "Auricular"
          },
          {
            "code" : "ISI-0022",
            "display" : "Cutaneous/Transdermal"
          },
          {
            "code" : "ISI-0023",
            "display" : "Dental"
          },
          {
            "code" : "ISI-0024",
            "display" : "Environmental"
          },
          {
            "code" : "ISI-0025",
            "display" : "Extracorporeal"
          },
          {
            "code" : "ISI-0027",
            "display" : "Intrauterine"
          },
          {
            "code" : "ISI-0028",
            "display" : "Intravesical/Urethral"
          },
          {
            "code" : "ISI-0029",
            "display" : "Nasal"
          },
          {
            "code" : "ISI-0030",
            "display" : "Ocular"
          },
          {
            "code" : "ISI-0031",
            "display" : "Oral"
          },
          {
            "code" : "ISI-0032",
            "display" : "Oromucosal"
          },
          {
            "code" : "ISI-0033",
            "display" : "Parenteral"
          },
          {
            "code" : "ISI-0034",
            "display" : "Pulmonary"
          },
          {
            "code" : "ISI-0035",
            "display" : "Rectal"
          },
          {
            "code" : "ISI-0036",
            "display" : "Vaginal"
          },
          {
            "code" : "ISI-0037",
            "display" : "Unknown/Miscellaneous"
          },
          {
            "code" : "ISI-0105",
            "display" : "Endocervical"
          },
          {
            "code" : "ISI-0106",
            "display" : "Gastric"
          },
          {
            "code" : "ISI-0107",
            "display" : "Gastroenteral"
          },
          {
            "code" : "ISI-0108",
            "display" : "Intestinal"
          },
          {
            "code" : "ISI-0109",
            "display" : "Intraperitoneal"
          }
        ]
      }
    ]
  }
}

```
