# EDQM PDF characteristics: Administration Method - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EDQM PDF characteristics: Administration Method**

## ValueSet: EDQM PDF characteristics: Administration Method 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/edqm-AME | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:edqm-AME |

 
EDQM Pharmaceutical dose forms characteristics: Administration Method 

 **References** 

* [Pharmaceutical dose form - AdministrationMethod](StructureDefinition-administration-method.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "edqm-AME",
  "url" : "http://who-umc.org/idmp/ValueSet/edqm-AME",
  "version" : "0.1.0",
  "name" : "edqm-AME",
  "title" : "EDQM PDF characteristics: Administration Method",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "EDQM Pharmaceutical dose forms characteristics: Administration Method",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "concept" : [
          {
            "code" : "AME-0004",
            "display" : "Administration"
          },
          {
            "code" : "AME-0005",
            "display" : "Application"
          },
          {
            "code" : "AME-0006",
            "display" : "Bathing"
          },
          {
            "code" : "AME-0007",
            "display" : "Chewing"
          },
          {
            "code" : "AME-0008",
            "display" : "Gargling"
          },
          {
            "code" : "AME-0010",
            "display" : "Inhalation"
          },
          {
            "code" : "AME-0011",
            "display" : "Injection"
          },
          {
            "code" : "AME-0012",
            "display" : "Insertion"
          },
          {
            "code" : "AME-0013",
            "display" : "Instillation"
          },
          {
            "code" : "AME-0014",
            "display" : "Orodispersion"
          },
          {
            "code" : "AME-0015",
            "display" : "Rinsing/washing"
          },
          {
            "code" : "AME-0017",
            "display" : "Spraying"
          },
          {
            "code" : "AME-0018",
            "display" : "Sucking"
          },
          {
            "code" : "AME-0019",
            "display" : "Swallowing"
          },
          {
            "code" : "AME-0111",
            "display" : "Burning"
          },
          {
            "code" : "AME-0112",
            "display" : "Dialysis"
          },
          {
            "code" : "AME-0113",
            "display" : "Implantation"
          }
        ]
      }
    ]
  }
}

```
