# Substance (METHOTREXATE) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance (METHOTREXATE)**

## Example SubstanceDefinition: Substance (METHOTREXATE)

# Substance definition

| | |
| :--- | :--- |
| Id | GSID23G92UMX93H45 |
| SMILES | CN(Cc1cnc2c(c(N)[nH]c(=N)n2)n1)c3ccc(cc3)C(=O)N[C@@]([H])(CCC(=O)O)C(=O)O |

## Identifier(s)

| | |
| :--- | :--- |
| https://gupri-idmp.who-umc.org/data/substance | GSID23G92UMX93H45 |

## Name(s)

| | | | |
| :--- | :--- | :--- | :--- |
| METHOTREXATE | INN | en | False |
| METHOTREXATE | UMC-SRS | en | True |
| METHOTREXATE | USAN | en | False |

## Other code systems

| | |
| :--- | :--- |
| http://terminology.hl7.org/CodeSystem/CAS | 59-05-2 |
| https://open.fda.gov/data/unii | YL5FZ2Y5U1 |



## Resource Content

```json
{
  "resourceType" : "SubstanceDefinition",
  "id" : "GSID23G92UMX93H45",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2019-08-05T08:23:54.1383883+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
    ]
  },
  "identifier" : [
    {
      "system" : "https://gupri-idmp.who-umc.org/data/substance",
      "value" : "GSID23G92UMX93H45"
    }
  ],
  "status" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/publication-status",
        "code" : "active"
      }
    ],
    "text" : "Active"
  },
  "domain" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-domain",
        "code" : "Human"
      }
    ],
    "text" : "Human use"
  },
  "structure" : {
    "representation" : [
      {
        "representation" : "CN(Cc1cnc2c(c(N)[nH]c(=N)n2)n1)c3ccc(cc3)C(=O)N[C@@]([H])(CCC(=O)O)C(=O)O",
        "format" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/substance-representation-format",
              "code" : "SMILES"
            }
          ],
          "text" : "SMILES"
        }
      }
    ]
  },
  "code" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/CAS",
            "code" : "59-05-2"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "https://open.fda.gov/data/unii",
            "code" : "YL5FZ2Y5U1"
          }
        ]
      }
    }
  ],
  "name" : [
    {
      "name" : "METHOTREXATE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : false,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "INN"
              }
            ],
            "text" : "INN"
          }
        }
      ]
    },
    {
      "name" : "METHOTREXATE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : true,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "UMC-SRS"
              }
            ],
            "text" : "UMC-SRS"
          }
        }
      ]
    },
    {
      "name" : "METHOTREXATE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : false,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "USAN"
              }
            ],
            "text" : "USAN"
          }
        }
      ]
    }
  ]
}

```
