# Pharmaceutical dose form - AdministrationMethod - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pharmaceutical dose form - AdministrationMethod**

## Extension: Pharmaceutical dose form - AdministrationMethod 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/administration-method | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:AME |

This extension is use to display the AdministrationMethod for an AdministrableProductDefinition

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [AdministrableProductDefinition (WHO PhP)](StructureDefinition-AdministrableProductDefinition-who-php.md)
* Examples for this Extension: [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md) and [AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/administration-method)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-administration-method.csv), [Excel](StructureDefinition-administration-method.xlsx), [Schematron](StructureDefinition-administration-method.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "administration-method",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://who-umc.org/idmp/StructureDefinition/administration-method",
  "version" : "0.1.0",
  "name" : "AME",
  "title" : "Pharmaceutical dose form - AdministrationMethod",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This extension is use to display the AdministrationMethod for an AdministrableProductDefinition",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "AdministrableProductDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Pharmaceutical dose form - AdministrationMethod",
        "definition" : "This extension is use to display the AdministrationMethod for an AdministrableProductDefinition"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://who-umc.org/idmp/StructureDefinition/administration-method"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Coding"
          }
        ]
      },
      {
        "id" : "Extension.value[x].system",
        "path" : "Extension.value[x].system",
        "min" : 1,
        "patternUri" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes"
      },
      {
        "id" : "Extension.value[x].code",
        "path" : "Extension.value[x].code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/edqm-AME"
        }
      }
    ]
  }
}

```
