# Subscription for event notifications - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subscription for event notifications**

## Resource Profile: Subscription for event notifications 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/Subscription-IdmpEvent | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:SubscriptionIdmpEvent |

 
Subscription for event notifications 

**Usages:**

* Examples for this Profile: [Demo end point](Subscription-template-generated-by-server-subscription-email.md) and [Demo end point](Subscription-template-generated-by-server-subscription-rest-hook.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/Subscription-IdmpEvent)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Subscription-IdmpEvent.csv), [Excel](StructureDefinition-Subscription-IdmpEvent.xlsx), [Schematron](StructureDefinition-Subscription-IdmpEvent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Subscription-IdmpEvent",
  "url" : "http://who-umc.org/idmp/StructureDefinition/Subscription-IdmpEvent",
  "version" : "0.1.0",
  "name" : "SubscriptionIdmpEvent",
  "title" : "Subscription for event notifications",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "Subscription for event notifications",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Subscription",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Subscription",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Subscription",
        "path" : "Subscription"
      },
      {
        "id" : "Subscription.topic",
        "path" : "Subscription.topic",
        "short" : "Available topics are found at https://idmp.who-umc.org/fhir/SubscriptionTopic"
      },
      {
        "id" : "Subscription.channelType.system",
        "path" : "Subscription.channelType.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/subscription-channel-type"
      },
      {
        "id" : "Subscription.channelType.code",
        "path" : "Subscription.channelType.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/channelType"
        }
      },
      {
        "id" : "Subscription.endpoint",
        "path" : "Subscription.endpoint",
        "min" : 1
      },
      {
        "id" : "Subscription.content",
        "path" : "Subscription.content",
        "short" : "id-only",
        "min" : 1
      }
    ]
  }
}

```
