# MedicinalProductDefinition for publication - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicinalProductDefinition for publication**

## Resource Profile: MedicinalProductDefinition for publication 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:MedicinalProductDefinitionWhoPhP |

 
This profile specifies how the MedicinalProductDefinition is published by the WHO-UMC IDMP FHIR Service representing the WHODrug dictionary 

**Usages:**

* Examples for this Profile: [MedicinalProductDefinition/1266520E021](MedicinalProductDefinition-1266520E021.md) and [MedicinalProductDefinition/1A0661AE2A40](MedicinalProductDefinition-1A0661AE2A40.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/MedicinalProductDefinition-who-php-pub)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicinalProductDefinition-who-php-pub.csv), [Excel](StructureDefinition-MedicinalProductDefinition-who-php-pub.xlsx), [Schematron](StructureDefinition-MedicinalProductDefinition-who-php-pub.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicinalProductDefinition-who-php-pub",
  "url" : "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub",
  "version" : "0.1.0",
  "name" : "MedicinalProductDefinitionWhoPhP",
  "title" : "MedicinalProductDefinition for publication",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the MedicinalProductDefinition is published by the WHO-UMC IDMP FHIR Service representing the WHODrug dictionary",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicinalProductDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicinalProductDefinition",
        "path" : "MedicinalProductDefinition"
      },
      {
        "id" : "MedicinalProductDefinition.id",
        "path" : "MedicinalProductDefinition.id",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.contained",
        "path" : "MedicinalProductDefinition.contained",
        "max" : "2",
        "type" : [
          {
            "code" : "Organization"
          },
          {
            "code" : "RegulatedAuthorization"
          }
        ]
      },
      {
        "id" : "MedicinalProductDefinition.identifier",
        "path" : "MedicinalProductDefinition.identifier",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.identifier.system",
        "path" : "MedicinalProductDefinition.identifier.system",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/mpid-system"
        }
      },
      {
        "id" : "MedicinalProductDefinition.identifier.value",
        "path" : "MedicinalProductDefinition.identifier.value",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.type",
        "path" : "MedicinalProductDefinition.type",
        "short" : "Regulatory type, e.g. Investigational or Authorized."
      },
      {
        "id" : "MedicinalProductDefinition.domain",
        "path" : "MedicinalProductDefinition.domain",
        "short" : "If this medicine applies to human or veterinary uses.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicinal-product-domain"
        }
      },
      {
        "id" : "MedicinalProductDefinition.status",
        "path" : "MedicinalProductDefinition.status",
        "short" : "The status within the lifecycle of this product record."
      },
      {
        "id" : "MedicinalProductDefinition.statusDate",
        "path" : "MedicinalProductDefinition.statusDate",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.description",
        "path" : "MedicinalProductDefinition.description",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.combinedPharmaceuticalDoseForm",
        "path" : "MedicinalProductDefinition.combinedPharmaceuticalDoseForm",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/pharmaceuticalForm"
        }
      },
      {
        "id" : "MedicinalProductDefinition.route",
        "path" : "MedicinalProductDefinition.route",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/routeOfAdministration"
        }
      },
      {
        "id" : "MedicinalProductDefinition.indication",
        "path" : "MedicinalProductDefinition.indication",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.legalStatusOfSupply",
        "path" : "MedicinalProductDefinition.legalStatusOfSupply",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.additionalMonitoringIndicator",
        "path" : "MedicinalProductDefinition.additionalMonitoringIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.specialMeasures",
        "path" : "MedicinalProductDefinition.specialMeasures",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.pediatricUseIndicator",
        "path" : "MedicinalProductDefinition.pediatricUseIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.classification",
        "path" : "MedicinalProductDefinition.classification",
        "short" : "Allows the product to be classified by various systems (e.g. ATC)",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/atcClassification"
        }
      },
      {
        "id" : "MedicinalProductDefinition.marketingStatus",
        "path" : "MedicinalProductDefinition.marketingStatus",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.packagedMedicinalProduct",
        "path" : "MedicinalProductDefinition.packagedMedicinalProduct",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.contact",
        "path" : "MedicinalProductDefinition.contact",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile",
        "max" : "0"
      },
      {
        "id" : "MedicinalProductDefinition.name.productName",
        "path" : "MedicinalProductDefinition.name.productName",
        "short" : "The full product name."
      },
      {
        "id" : "MedicinalProductDefinition.name.type",
        "path" : "MedicinalProductDefinition.name.type",
        "short" : "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary."
      },
      {
        "id" : "MedicinalProductDefinition.name.part.part",
        "path" : "MedicinalProductDefinition.name.part.part",
        "short" : "A fragment of a product name."
      },
      {
        "id" : "MedicinalProductDefinition.name.part.type",
        "path" : "MedicinalProductDefinition.name.part.type",
        "short" : "Type for this part of the name (e.g. strength part)"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage",
        "path" : "MedicinalProductDefinition.name.usage",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country",
        "path" : "MedicinalProductDefinition.name.usage.country",
        "short" : "Country where this name applies"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding",
        "path" : "MedicinalProductDefinition.name.usage.country.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding.system",
        "path" : "MedicinalProductDefinition.name.usage.country.coding.system",
        "patternUri" : "urn:iso:std:iso:3166"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding.code",
        "path" : "MedicinalProductDefinition.name.usage.country.coding.code",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction",
        "short" : "Jurisdiction where this name applies"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction.coding",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction.coding.code",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction.coding.code",
        "min" : 1,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/jurisdiction"
        }
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.language",
        "path" : "MedicinalProductDefinition.name.usage.language",
        "short" : "Language for this name"
      }
    ]
  }
}

```
