# AdministrableProductDefinition (WHO PhP) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrableProductDefinition (WHO PhP)**

## Resource Profile: AdministrableProductDefinition (WHO PhP) 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:AdministrableProductDefinitionWhoPhP |

 
This profile specified how the AdministrableProductDefinition is published by the WHO-UMC IDMP Service 

**Usages:**

* Refer to this Profile: [Ingredient (WHO PhP publish)](StructureDefinition-Ingredient-who-php-publish.md) and [Parent PhP](StructureDefinition-parent-phpid.md)
* Examples for this Profile: [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md), [AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md), [AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md) and [AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010](AdministrableProductDefinition-93FE88350C2E8868F7E8BD220C4E0010.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/AdministrableProductDefinition-who-php)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AdministrableProductDefinition-who-php.csv), [Excel](StructureDefinition-AdministrableProductDefinition-who-php.xlsx), [Schematron](StructureDefinition-AdministrableProductDefinition-who-php.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdministrableProductDefinition-who-php",
  "url" : "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php",
  "version" : "0.1.0",
  "name" : "AdministrableProductDefinitionWhoPhP",
  "title" : "AdministrableProductDefinition (WHO PhP)",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how the AdministrableProductDefinition is published by the WHO-UMC IDMP Service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AdministrableProductDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AdministrableProductDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AdministrableProductDefinition",
        "path" : "AdministrableProductDefinition"
      },
      {
        "id" : "AdministrableProductDefinition.id",
        "path" : "AdministrableProductDefinition.id",
        "short" : "PhPID",
        "definition" : "This is always values with the PhPID",
        "min" : 1
      },
      {
        "id" : "AdministrableProductDefinition.contained",
        "path" : "AdministrableProductDefinition.contained",
        "min" : 1,
        "type" : [
          {
            "code" : "Ingredient",
            "profile" : [
              "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish"
            ]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.extension",
        "path" : "AdministrableProductDefinition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AdministrableProductDefinition.extension:parentPhp",
        "path" : "AdministrableProductDefinition.extension",
        "sliceName" : "parentPhp",
        "min" : 0,
        "max" : "3",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://who-umc.org/idmp/StructureDefinition/parent-phpid"]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.extension:basicDoseForm",
        "path" : "AdministrableProductDefinition.extension",
        "sliceName" : "basicDoseForm",
        "short" : "Basic Dose Form",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://who-umc.org/idmp/StructureDefinition/basic-dose-form"
            ]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.extension:intendedSite",
        "path" : "AdministrableProductDefinition.extension",
        "sliceName" : "intendedSite",
        "short" : "Intended Site",
        "min" : 0,
        "max" : "3",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://who-umc.org/idmp/StructureDefinition/intended-site"]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.extension:releaseCharacteristics",
        "path" : "AdministrableProductDefinition.extension",
        "sliceName" : "releaseCharacteristics",
        "short" : "Release Characteristics",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://who-umc.org/idmp/StructureDefinition/release-characteristics"
            ]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.extension:administrationMethod",
        "path" : "AdministrableProductDefinition.extension",
        "sliceName" : "administrationMethod",
        "short" : "Administration Method",
        "min" : 0,
        "max" : "3",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://who-umc.org/idmp/StructureDefinition/administration-method"
            ]
          }
        ]
      },
      {
        "id" : "AdministrableProductDefinition.identifier",
        "path" : "AdministrableProductDefinition.identifier",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AdministrableProductDefinition.identifier.type",
        "path" : "AdministrableProductDefinition.identifier.type",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-type"
        }
      },
      {
        "id" : "AdministrableProductDefinition.identifier.system",
        "path" : "AdministrableProductDefinition.identifier.system",
        "min" : 1
      },
      {
        "id" : "AdministrableProductDefinition.identifier.value",
        "path" : "AdministrableProductDefinition.identifier.value",
        "min" : 1
      },
      {
        "id" : "AdministrableProductDefinition.status",
        "path" : "AdministrableProductDefinition.status",
        "short" : "draft | active | retired |unknown"
      },
      {
        "id" : "AdministrableProductDefinition.formOf",
        "path" : "AdministrableProductDefinition.formOf",
        "max" : "0"
      },
      {
        "id" : "AdministrableProductDefinition.administrableDoseForm",
        "path" : "AdministrableProductDefinition.administrableDoseForm",
        "max" : "0"
      },
      {
        "id" : "AdministrableProductDefinition.unitOfPresentation",
        "path" : "AdministrableProductDefinition.unitOfPresentation",
        "max" : "0"
      },
      {
        "id" : "AdministrableProductDefinition.producedFrom",
        "path" : "AdministrableProductDefinition.producedFrom",
        "max" : "0"
      },
      {
        "id" : "AdministrableProductDefinition.device",
        "path" : "AdministrableProductDefinition.device",
        "max" : "0"
      }
    ]
  }
}

```
