# Parent PhPID - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Parent PhPID**

## SearchParameter: Parent PhPID (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/SearchParameter/parent-php | *Version*:0.1.0 |
| Draft as of 2025-11-19 | *Computable Name*:parent-php |

 
Search PhPIDs based on 'parent' PhPIDs 

 
Search PhPIDs based on 'parent' PhPIDs to for example find all level 4 PhPIDs for a specific level 2 PhPID 

## parent-php

Parameter `parent-php`:`reference`

Search PhPIDs based on 'parent' PhPIDs

| | |
| :--- | :--- |
| Resource | [AdministrableProductDefinition](http://hl7.org/fhir/R5/administrableproductdefinition.html) |
| Expression | `AdministrableProductDefinition.extension('http://who-umc.org/idmp/StructureDefinition/parent-phpid').value` |
| Processing Mode | Normal |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "parent-php",
  "url" : "http://who-umc.org/idmp/SearchParameter/parent-php",
  "version" : "0.1.0",
  "name" : "parent-php",
  "title" : "Parent PhPID",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "Search PhPIDs based on 'parent' PhPIDs",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "purpose" : "Search PhPIDs based on 'parent' PhPIDs to for example find all level 4 PhPIDs for a specific level 2 PhPID",
  "code" : "parent-php",
  "base" : ["AdministrableProductDefinition"],
  "type" : "reference",
  "expression" : "AdministrableProductDefinition.extension('http://who-umc.org/idmp/StructureDefinition/parent-phpid').value",
  "processingMode" : "normal"
}

```
