# MedicinalProductDefinition (Methotrexaat sandoz) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicinalProductDefinition (Methotrexaat sandoz)**

## Example MedicinalProductDefinition: MedicinalProductDefinition (Methotrexaat sandoz)

# Medicinal Product (Medicinal Product Definition)

| | |
| :--- | :--- |
| Id | 1266520E021 |
| Name | Methotrexaat sandoz |
| Mah | Sandoz |
| Jurisdiction | Netherlands |

## ATC

| | |
| :--- | :--- |
| G02CX | Other gynecologicals |
| L01BA | Folic acid analogues |
| L04AX | Other immunosuppressants |

## Codes

| | | |
| :--- | :--- | :--- |
| http://who-umc.org/idmp/CodeSystem/drugcode | 00113802085 |  |

## PhPIDs

|
|



## Resource Content

```json
{
  "resourceType" : "MedicinalProductDefinition",
  "id" : "1266520E021",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2021-04-12T08:23:54.8389738+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Organization",
      "id" : "sandoz",
      "name" : "Sandoz"
    },
    {
      "resourceType" : "RegulatedAuthorization",
      "id" : "regauth",
      "identifier" : [
        {
          "system" : "http://ema.europa.eu/ema/",
          "value" : "EU/1/20/XXXX"
        }
      ],
      "subject" : [
        {
          "reference" : "#"
        }
      ],
      "holder" : {
        "reference" : "#sandoz"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://gupri-idmp.who-umc.org/data/record",
      "value" : "1266520E021"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-type",
        "code" : "MedicinalProduct"
      }
    ]
  },
  "domain" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-domain",
        "code" : "Human"
      }
    ],
    "text" : "Human use"
  },
  "status" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/publication-status",
        "code" : "active"
      }
    ],
    "text" : "Active"
  },
  "combinedPharmaceuticalDoseForm" : {
    "text" : "TABLETS"
  },
  "classification" : [
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "G02CX"
        }
      ],
      "text" : "Other gynecologicals"
    },
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "L01BA"
        }
      ],
      "text" : "Folic acid analogues"
    },
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "L04AX"
        }
      ],
      "text" : "Other immunosuppressants"
    }
  ],
  "code" : [
    {
      "system" : "http://who-umc.org/idmp/CodeSystem/drugcode",
      "code" : "00113802085"
    }
  ],
  "name" : [
    {
      "productName" : "Methotrexaat sandoz",
      "usage" : [
        {
          "country" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "NLD"
              }
            ]
          },
          "jurisdiction" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "NLD"
              }
            ]
          },
          "language" : {
            "coding" : [
              {
                "system" : "urn:ietf:bcp:47",
                "code" : "nl"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
