# Task input type - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task input type**

## CodeSystem: Task input type 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/CodeSystem/task-input-type | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:TaskInputTypes |
| **Copyright/Legal**: Uppsala Monitoring Centre | |

 
This system lists the available input types for a task 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsGSIDTaskInputTypes](ValueSet-gsid-task-input-type.md)
* [VsPhPIDTaskInputTypes](ValueSet-phpid-task-input-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "task-input-type",
  "url" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
  "version" : "0.1.0",
  "name" : "TaskInputTypes",
  "title" : "Task input type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This system lists the available input types for a task",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "Uppsala Monitoring Centre",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "concept" : [
    {
      "code" : "mpd-request-resource",
      "display" : "Medicinal Product for PhPID request",
      "definition" : "Medicinal Product for PhPID request"
    },
    {
      "code" : "ingredient-request-resource",
      "display" : "Ingredient for PhPID request",
      "definition" : "Ingredient for PhPID request"
    },
    {
      "code" : "organization-request-resource",
      "display" : "Marketing Auth Holder for PhPID request",
      "definition" : "Marketing Auth Holder for PhPID request"
    },
    {
      "code" : "regauth-request-resource",
      "display" : "Regulated Authorization for PhPID request",
      "definition" : "Regulated Authorization for PhPID request"
    },
    {
      "code" : "substance-request-resource",
      "display" : "Data for substance request",
      "definition" : "Data for substance request"
    }
  ]
}

```
