# API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs**

## CapabilityStatement: API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/CapabilityStatement/UMC-IDMP-API | *Version*:0.1.0 |
| Draft as of 2025-04-24 | *Computable Name*:UMC IDMP Request and Publish API |

 
The UMC IDMP API supports management and publishing of PhPIDs and publishing of GSIDs as part of the ISO IDMP standard. It also supports publishing of some other related resources as described in the Implementation Guide 

 [Raw OpenAPI-Swagger Definition file](UMC-IDMP-API.openapi.json) | [Download](UMC-IDMP-API.openapi.json) 

## API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs

* Implementation Guide Version: 0.1.0 
* FHIR Version: 5.0.0 
* Supported Formats: `xml`, `json`
* Published on: 2025-04-24 
* Published by: Uppsala Monitoring Centre 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* https://build.fhir.org/ig/Uppsala-Monitoring-Centre/WHO-UMC-IDMP-Service/

## FHIR RESTful Capabilities

### Mode: server

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Task](#Task1-1) |   | y |  |  | y | y | identifier, status |  |  |  |
| [SubstanceDefinition](#SubstanceDefinition1-2) |   | y |  |  |  |  | _id, identifier, name, code |  |  |  |
| [AdministrableProductDefinition](#AdministrableProductDefinition1-3) |   | y |  |  |  |  | _id, identifier, form-of, form-of:identifier, dose-form, parent-php |  |  |  |
| [MedicinalProductDefinition](#MedicinalProductDefinition1-4) |   | y |  |  |  |  | _id, identifier, name, name-jurisdiction, name-country, product-classification |  |  |  |
| [Ingredient](#Ingredient1-5) |   |  |  |  |  |  | substance-code, strength-presentation-quantity |  |  |  |
| [CapabilityStatement](#CapabilityStatement1-6) |   | y |  |  |  |  |  |  |  |  |
| [SubscriptionTopic](#SubscriptionTopic1-7) |   | y |  |  |  |  | _id, name, url |  |  |  |
| [Subscription](#Subscription1-8) |   | y |  | y | y | y | _id, identifier, name, topic |  |  |  |
| [SubscriptionStatus](#SubscriptionStatus1-9) |   | y |  |  |  |  | _id, identifier, name, topic |  |  |  |
| [ImplementationGuide](#ImplementationGuide1-10) |   | y |  |  |  |  |  |  |  |  |

-------

#### Resource Conformance: supported Task

Core FHIR Resource

[Task](http://hl7.org/fhir/task.html)

Reference Policy

Interaction summary

* Supports `read`, `create`, `delete`.

Search Parameters


 

#### Resource Conformance: supported SubstanceDefinition

Core FHIR Resource

[SubstanceDefinition](http://hl7.org/fhir/substancedefinition.html)

Reference Policy

Interaction summary

* Supports `read`.

Search Parameters


 

#### Resource Conformance: supported AdministrableProductDefinition

Core FHIR Resource

[AdministrableProductDefinition](http://hl7.org/fhir/administrableproductdefinition.html)

Reference Policy

Interaction summary

* Supports `read`.

Search Parameters


 

#### Resource Conformance: supported MedicinalProductDefinition

Core FHIR Resource

[MedicinalProductDefinition](http://hl7.org/fhir/medicinalproductdefinition.html)

Reference Policy

Interaction summary

* Supports `read`.

Search Parameters


 

#### Resource Conformance: supported Ingredient

Core FHIR Resource

[Ingredient](http://hl7.org/fhir/ingredient.html)

Reference Policy

Interaction summary

Documentation
> 

Only available within the scope of an AdministrableProductDefinition


Search Parameters


 

#### Resource Conformance: supported CapabilityStatement

Core FHIR Resource

[CapabilityStatement](http://hl7.org/fhir/capabilitystatement.html)

Reference Policy

Interaction summary

* Supports `read`.

#### Resource Conformance: supported SubscriptionTopic

Core FHIR Resource

[SubscriptionTopic](http://hl7.org/fhir/subscriptiontopic.html)

Reference Policy

Interaction summary

* Supports `read`.

Search Parameters


 

#### Resource Conformance: supported Subscription

Core FHIR Resource

[Subscription](http://hl7.org/fhir/subscription.html)

Reference Policy

Interaction summary

* Supports `read`, `create`, `delete`, `update`.

Search Parameters


 

#### Resource Conformance: supported SubscriptionStatus

Core FHIR Resource

[SubscriptionStatus](http://hl7.org/fhir/subscriptionstatus.html)

Reference Policy

Interaction summary

* Supports `read`.

Search Parameters


 

#### Resource Conformance: supported ImplementationGuide

Core FHIR Resource

[ImplementationGuide](http://hl7.org/fhir/implementationguide.html)

Reference Policy

Interaction summary

* Supports `read`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "UMC-IDMP-API",
  "url" : "http://who-umc.org/idmp/CapabilityStatement/UMC-IDMP-API",
  "version" : "0.1.0",
  "name" : "UMC IDMP Request and Publish API",
  "title" : "API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs",
  "status" : "draft",
  "date" : "2025-04-24",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "The UMC IDMP API supports management and publishing of PhPIDs and publishing of GSIDs as part of the ISO IDMP standard. It also supports publishing of some other related resources as described in the Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "kind" : "capability",
  "software" : {
    "name" : "UMC IDMP Request and Publish API",
    "version" : "0.5.0"
  },
  "fhirVersion" : "5.0.0",
  "format" : ["xml", "json"],
  "implementationGuide" : [
    "https://build.fhir.org/ig/Uppsala-Monitoring-Centre/WHO-UMC-IDMP-Service/"
  ],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "type" : "Task",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "create"
            },
            {
              "code" : "delete"
            }
          ],
          "searchParam" : [
            {
              "name" : "identifier",
              "type" : "string",
              "documentation" : "Task identifier from requester in format 'sendingSystem|localId'"
            },
            {
              "name" : "status",
              "type" : "string",
              "documentation" : "Search Task by status"
            }
          ]
        },
        {
          "type" : "SubstanceDefinition",
          "interaction" : [
            {
              "code" : "read"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "GSID"
            },
            {
              "name" : "identifier",
              "type" : "string",
              "documentation" : "GSID"
            },
            {
              "name" : "name",
              "type" : "string",
              "documentation" : "Name of substance (contains search)"
            },
            {
              "name" : "code",
              "type" : "string",
              "documentation" : "Code from other code system"
            }
          ]
        },
        {
          "type" : "AdministrableProductDefinition",
          "interaction" : [
            {
              "code" : "read"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "PhPID"
            },
            {
              "name" : "identifier",
              "type" : "string",
              "documentation" : "PhPID"
            },
            {
              "name" : "form-of",
              "type" : "string",
              "documentation" : "Find PhPIDs for an internal product ID in the"
            },
            {
              "name" : "form-of:identifier",
              "type" : "string",
              "documentation" : "Find PhPIds for a MPID"
            },
            {
              "name" : "dose-form",
              "type" : "string",
              "documentation" : "Find PhPIDs with a specific dose-form"
            },
            {
              "name" : "parent-php",
              "definition" : "http://who-umc.org/idmp/SearchParameter/parent-php",
              "type" : "reference",
              "documentation" : "Search PhPIDs based on 'parent' PhPIDs"
            }
          ]
        },
        {
          "type" : "MedicinalProductDefinition",
          "interaction" : [
            {
              "code" : "read"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "WHODrug record Id"
            },
            {
              "name" : "identifier",
              "type" : "string",
              "documentation" : "MPID"
            },
            {
              "name" : "name",
              "type" : "string",
              "documentation" : "Product name (contains search)"
            },
            {
              "name" : "name-jurisdiction",
              "type" : "string",
              "documentation" : "Jurisdiction according to urn:iso:std:iso:3166"
            },
            {
              "name" : "name-country",
              "type" : "string",
              "documentation" : "Country according to urn:iso:std:iso:3166"
            },
            {
              "name" : "product-classification",
              "type" : "token",
              "documentation" : "Used to search for products given a PhPID"
            }
          ]
        },
        {
          "type" : "Ingredient",
          "documentation" : "Only available within the scope of an AdministrableProductDefinition",
          "searchParam" : [
            {
              "name" : "substance-code",
              "type" : "string",
              "documentation" : "Find by substance (GSID) code"
            },
            {
              "name" : "strength-presentation-quantity",
              "type" : "token",
              "documentation" : "Search parameter on the format '5.4|http://unitsofmeasure.org|mg'"
            }
          ]
        },
        {
          "type" : "CapabilityStatement",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "type" : "SubscriptionTopic",
          "interaction" : [
            {
              "code" : "read"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "Id of the SubscriptionTopic"
            },
            {
              "name" : "name",
              "type" : "string",
              "documentation" : "Name of the SubscriptionTopic (contains search)"
            },
            {
              "name" : "url",
              "type" : "string",
              "documentation" : "Url of the SubscriptionTopic"
            }
          ]
        },
        {
          "type" : "Subscription",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "create"
            },
            {
              "code" : "delete"
            },
            {
              "code" : "update"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "Id of the Subscription"
            },
            {
              "name" : "identifier",
              "type" : "string"
            },
            {
              "name" : "name",
              "type" : "string",
              "documentation" : "Name of the Subscription (contains search)"
            },
            {
              "name" : "topic",
              "type" : "string",
              "documentation" : "Topic (full url) of the Subscription"
            }
          ]
        },
        {
          "type" : "SubscriptionStatus",
          "interaction" : [
            {
              "code" : "read"
            }
          ],
          "searchParam" : [
            {
              "name" : "_id",
              "type" : "string",
              "documentation" : "Id of the Subscription"
            },
            {
              "name" : "identifier",
              "type" : "string"
            },
            {
              "name" : "name",
              "type" : "string",
              "documentation" : "Name of the Subscription (contains search)"
            },
            {
              "name" : "topic",
              "type" : "string",
              "documentation" : "Topic (full url) of the Subscription"
            }
          ]
        },
        {
          "type" : "ImplementationGuide",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
