# AdministrableProductDefinition level 4 - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrableProductDefinition level 4**

## Example AdministrableProductDefinition: AdministrableProductDefinition level 4

# Pharmaceutical Product (Administrable Product Definition)

| | |
| :--- | :--- |
| Id | 91B3CA582581F57E4092F13AAF476215 |
| Level | 4 |

## Ingredients

| | | |
| :--- | :--- | :--- |
| GSID9XBS2KCF3K1Z1 | METHOTREXATE SODIUM | 2,74 mg |

## Form

| | |
| :--- | :--- |
| Basic dose form | Tablet (0069) |
| Administration method | Swallowing (0019) |
| Intended site | Oral (0031) |
| Release characteristics | Conventional (0047) |

## Parent PhPIDs

| | |
| :--- | :--- |
| 1 | 93FE88350C2E8868F7E8BD220C4E0010 |
| 2 | 8195D4AF1287CCE3442C2F308F61DBBC |
| 3 | 6C4563BB76BE7967594979196EC91CD8 |



## Resource Content

```json
{
  "resourceType" : "AdministrableProductDefinition",
  "id" : "91B3CA582581F57E4092F13AAF476215",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-01-05T08:23:54.0582254+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Ingredient",
      "id" : "d902e87e-ffaa-4f68-8f98-b0d4cac72b90",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish"
        ]
      },
      "status" : "active",
      "for" : [
        {
          "reference" : "#"
        }
      ],
      "role" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/ingredient-role",
            "code" : "100000072072"
          }
        ],
        "text" : "Active"
      },
      "substance" : {
        "code" : {
          "reference" : {
            "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1",
            "identifier" : {
              "system" : "https://gupri-idmp.who-umc.org/data/substance",
              "value" : "GSID9XBS2KCF3K1Z1"
            },
            "display" : "METHOTREXATE SODIUM"
          }
        },
        "strength" : [
          {
            "presentationQuantity" : {
              "value" : 2.74,
              "unit" : "mg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg"
            },
            "textPresentation" : "2,74 mg",
            "referenceStrength" : [
              {
                "substance" : {
                  "reference" : {
                    "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1",
                    "identifier" : {
                      "system" : "https://gupri-idmp.who-umc.org/data/substance",
                      "value" : "GSID9XBS2KCF3K1Z1"
                    },
                    "display" : "METHOTREXATE SODIUM"
                  }
                },
                "strengthQuantity" : {
                  "value" : 2.50,
                  "unit" : "mg",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mg"
                }
              }
            ]
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel1"
              }
            ]
          },
          "system" : "https://gupri-idmp.who-umc.org/data/php",
          "value" : "93FE88350C2E8868F7E8BD220C4E0010"
        }
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel2"
              }
            ]
          },
          "system" : "https://gupri-idmp.who-umc.org/data/php",
          "value" : "8195D4AF1287CCE3442C2F308F61DBBC"
        }
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel3"
              }
            ]
          },
          "system" : "https://gupri-idmp.who-umc.org/data/php",
          "value" : "6C4563BB76BE7967594979196EC91CD8"
        }
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/basic-dose-form",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0069",
        "display" : "Tablet"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/administration-method",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0019",
        "display" : "Swallowing"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/intended-site",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0031",
        "display" : "Oral"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/release-characteristics",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0047",
        "display" : "Conventional"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
            "code" : "PhPIDLevel4"
          }
        ]
      },
      "system" : "https://gupri-idmp.who-umc.org/data/php",
      "value" : "91B3CA582581F57E4092F13AAF476215"
    }
  ],
  "status" : "active",
  "routeOfAdministration" : [
    {
      "code" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    }
  ]
}

```
