# AdministrableProductDefinition level 3 - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrableProductDefinition level 3**

## Example AdministrableProductDefinition: AdministrableProductDefinition level 3

# Pharmaceutical Product (Administrable Product Definition)

| | |
| :--- | :--- |
| Id | 6C4563BB76BE7967594979196EC91CD8 |
| Level | 3 |

## Ingredients

| | | |
| :--- | :--- | :--- |
| GSID9XBS2KCF3K1Z1 | METHOTREXATE SODIUM |  |

## Form

| | |
| :--- | :--- |
| Basic dose form | Tablet (0069) |
| Administration method | Swallowing (0019) |
| Intended site | Oral (0031) |
| Release characteristics | Conventional (0047) |

## Parent PhPIDs

| | |
| :--- | :--- |
| 1 | 93FE88350C2E8868F7E8BD220C4E0010 |



## Resource Content

```json
{
  "resourceType" : "AdministrableProductDefinition",
  "id" : "6C4563BB76BE7967594979196EC91CD8",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2018-05-09T08:23:53.9949174+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Ingredient",
      "id" : "8ce9dfb6-4f4a-427d-9739-610d1e48959a",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish"
        ]
      },
      "status" : "active",
      "for" : [
        {
          "reference" : "#"
        }
      ],
      "role" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/ingredient-role",
            "code" : "100000072072"
          }
        ],
        "text" : "Active"
      },
      "substance" : {
        "code" : {
          "reference" : {
            "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1",
            "identifier" : {
              "system" : "https://gupri-idmp.who-umc.org/data/substance",
              "value" : "GSID9XBS2KCF3K1Z1"
            },
            "display" : "METHOTREXATE SODIUM"
          }
        }
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel1"
              }
            ]
          },
          "system" : "https://gupri-idmp.who-umc.org/data/php",
          "value" : "93FE88350C2E8868F7E8BD220C4E0010"
        }
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/basic-dose-form",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0069",
        "display" : "Tablet"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/administration-method",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0019",
        "display" : "Swallowing"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/intended-site",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0031",
        "display" : "Oral"
      }
    },
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/release-characteristics",
      "valueCoding" : {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "code" : "0047",
        "display" : "Conventional"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
            "code" : "PhPIDLevel3"
          }
        ]
      },
      "system" : "https://gupri-idmp.who-umc.org/data/php",
      "value" : "6C4563BB76BE7967594979196EC91CD8"
    }
  ],
  "status" : "active",
  "routeOfAdministration" : [
    {
      "code" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    }
  ]
}

```
