# 查詢參數 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* **查詢參數**

## 查詢參數

以下為本IG使用到的所有查詢參數(SearchParameter)。

### 對外服務之API

#### 以Profile分類

##### Claim

* [identifier](SearchParameter-Claim-identifier.md)
* [patient](SearchParameter-Claim-patient.md)
* [func-type](SearchParameter-Claim-func-type.md)

##### ClaimResponse

* [created](SearchParameter-ClaimResponse-created.md)
* [disposition](SearchParameter-ClaimResponse-disposition.md)
* [request](SearchParameter-ClaimResponse-request.md)
* [adjudication-reason](SearchParameter-ClaimResponse-adjudication-reason.md)

##### Patient

* [name](SearchParameter-Patient-name.md)
* [identifier](SearchParameter-Patient-identifier.md)

##### Encounter

* [service-type](SearchParameter-Encounter-service-type.md)

#### 以查詢欄位分類

##### 核定註記：ClaimResponse.adjudication-reason

`GET [base]/ClaimResponse?adjudication-reason=[核定註記]`
 例子：
 (1) GET [base]/ClaimResponse?adjudication-reason=1

##### 姓名：ClaimResponse.request + Claim.patient + Patient.name

`GET [base]/ClaimResponse?request.patient.name=[姓名]`
 例子：
 (1) GET [base]/ClaimResponse?request.patient.name=王大明

##### 身分證號：ClaimResponse.request + Claim.patient + Patient.identifier

`GET [base]/ClaimResponse?request.patient.identifier=[身分證號]`
 例子：
 (1) GET [base]/ClaimResponse?request.patient.identifier=A123456789

##### 受理編號：ClaimResponse.request + Claim.identifier

`GET [base]/ClaimResponse?request.identifier=[受理編號]`
 例子：
 (1) GET [base]/ClaimResponse?request.identifier=20240831010109051701

##### 就醫科別：ClaimResponse.request + Claim.func-type + Encounter.service-type

`GET [base]/ClaimResponse?request.func-type.service-type=[就醫科別]`
 例子：
 (1) GET [base]/ClaimResponse?request.func-type.service-type=AJ
 (2) GET [base]/ClaimResponse?request.func-type.service-type=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw|AJ

##### 受理日期：ClaimResponse.created & ClaimResponse.disposition

`GET [base]/ClaimResponse?created={gt|lt|ge|le}[date]{&created={gt|lt|ge|le}[date]}&disposition=已受理` 
 例子：
 (1) GET [base]/ClaimResponse?created=gt2024-08-01&created=lt2024-08-24&disposition=已受理

##### 核定日期：ClaimResponse.created & ClaimResponse.disposition

`GET [base]/ClaimResponse?created={gt|lt|ge|le}[date]{&created={gt|lt|ge|le}[date]}&disposition=審畢結果` 
 例子：
 (1) GET [base]/ClaimResponse?created=gt2024-08-01&created=lt2024-08-24&disposition=審畢結果

### 未對外服務之API

#### Bundle

* [_id](SearchParameter-Bundle-id.md)

