# NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集**

## ValueSet: NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-medication-fda | *Version*:2026-01-05 |
| Active as of 2026-01-05 | *Computable Name*:NHIMedicationFDA |

 
NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集。
此值集所涵蓋代碼量較大會使載入頁面時間較長，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱。 

 **References** 

* [用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-medication-fda",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-medication-fda",
  "version" : "2026-01-05",
  "name" : "NHIMedicationFDA",
  "title" : "NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-05",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集。  \n此值集所涵蓋代碼量較大會使載入頁面時間較長，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱。",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw"
      },
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-device-fda-tw"
      }
    ],
    "exclude" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-device-fda-tw",
        "concept" : [
          {
            "code" : "許可證字號"
          }
        ]
      }
    ]
  }
}

```
