# 評估-ClinicalImpression TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **評估-ClinicalImpression TWPAS**

## Resource Profile: 評估-ClinicalImpression TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:ClinicalImpressionTWPAS |

 
此評估-ClinicalImpression TWPAS Profile說明本IG如何進一步定義FHIR的ClinicalImpression Resource以呈現免疫製劑事前審查之評估（A） 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [門診病歷-Composition OPD TWPAS](StructureDefinition-Composition-opd-twpas.md)
* Examples for this Profile: [ClinicalImpression/cliImp-min](ClinicalImpression-cliImp-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/ClinicalImpression-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ClinicalImpression-twpas.csv), [Excel](StructureDefinition-ClinicalImpression-twpas.xlsx), [Schematron](StructureDefinition-ClinicalImpression-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ClinicalImpression-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas",
  "version" : "1.1.0",
  "name" : "ClinicalImpressionTWPAS",
  "title" : "評估-ClinicalImpression TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此評估-ClinicalImpression TWPAS Profile說明本IG如何進一步定義FHIR的ClinicalImpression Resource以呈現免疫製劑事前審查之評估（A）",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClinicalImpression",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalImpression.meta",
        "path" : "ClinicalImpression.meta",
        "min" : 1
      },
      {
        "id" : "ClinicalImpression.meta.profile",
        "path" : "ClinicalImpression.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas"
      },
      {
        "id" : "ClinicalImpression.subject",
        "path" : "ClinicalImpression.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalImpression.encounter",
        "path" : "ClinicalImpression.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalImpression.summary",
        "path" : "ClinicalImpression.summary",
        "short" : "評估，由醫院自行填寫。",
        "min" : 1
      }
    ]
  }
}

```
