# 癌藥事前審查-Bundle TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **癌藥事前審查-Bundle TWPAS**

## Resource Profile: 癌藥事前審查-Bundle TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:BundleTWPAS |

 
此癌藥事前審查-Bundle TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現癌藥事前審查之內容 

**Usages:**

* Examples for this Profile: [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md), [Bundle/bun-self](Bundle-bun-self.md) and [Bundle/bun-uuid-example](Bundle-bun-uuid-example.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Bundle-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-twpas.csv), [Excel](StructureDefinition-Bundle-twpas.xlsx), [Schematron](StructureDefinition-Bundle-twpas.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWPAS支援的RESTful互動功能的完整清單，請參閱[TWPAS Server能力聲明](CapabilityStatement-CapabilityStatementTWPASServer.md)。

#### 建議應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`_id`](SearchParameter-Bundle-id.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?_id=[id]`
`GET [base]/Bundle/[id]`例子：
(1) GET [base]/Bundle?_id=bun-1
(2) GET [base]/Bundle/bun-1



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas",
  "version" : "1.1.0",
  "name" : "BundleTWPAS",
  "title" : "癌藥事前審查-Bundle TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此癌藥事前審查-Bundle TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現癌藥事前審查之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "applyReason-1",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC009612B5，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P1(自113年12月擴增)、C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC009612B5').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC009612B5').all(programCode.coding.code.matches('C50P1|C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-2",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC010892B5，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P1、C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC010892B5').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC010892B5').all(programCode.coding.code.matches('C50P1|C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-3",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC011112DE，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P1、C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011112DE').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011112DE').all(programCode.coding.code.matches('C50P1|C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-4",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC011162B5，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P1、C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011162B5').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011162B5').all(programCode.coding.code.matches('C50P1|C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-5",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC011362B5，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011362B5').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC011362B5').all(programCode.coding.code.matches('C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-6",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 JC00154261，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C50P1、C50P2、C50R1 或 C16R1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'JC00154261').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'JC00154261').all(programCode.coding.code.matches('C50P1|C50P2|C50R1|C16R1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-7",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01013229，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P001、P011、P012、P031、P041、P061 或 P081",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01013229').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01013229').all(programCode.coding.code.matches('P001|P011|P012|P031|P041|P061|P081'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-8",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01013230，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P001、P011、P012、P031、P041、P052、P061、P081、P101 或 P111",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01013230').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01013230').all(programCode.coding.code.matches('P001|P011|P012|P031|P041|P052|P061|P081|P101|P111'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-9",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01025219，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P001、P031、P081、P011、P012、P013、P014、P041、P042、P082、P131 或 P141",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01025219').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01025219').all(programCode.coding.code.matches('P001|P031|P081|P011|P012|P013|P014|P041|P042|P082|P131|P141'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-10",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01050238，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P011、P012、P013、P021、P041、P042 或 P072",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01050238').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01050238').all(programCode.coding.code.matches('P011|P012|P013|P021|P041|P042|P072'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-11",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01088229，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P015、P021、P072 或 P121",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01088229').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01088229').all(programCode.coding.code.matches('P015|P021|P072|P121'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-12",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01085229，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P043 或 P091",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01085229').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01085229').all(programCode.coding.code.matches('P043|P091'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-13",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC00958229，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P111",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC00958229').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC00958229').all(programCode.coding.code.matches('P111'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-14",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01258235，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P011、P012、P013、P021、P041、P042 或 P072",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01258235').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01258235').all(programCode.coding.code.matches('P011|P012|P013|P021|P041|P042|P072'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-15",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 BC28160100，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 C83N2、C88N3、C82N3 或 C91N1",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'BC28160100').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'BC28160100').all(programCode.coding.code.matches('C83N2|C88N3|C82N3|C91N1'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "applyReason-16",
            "severity" : "error",
            "human" : "若事前審查品項代碼(MedicationRequest.medicationCodeableConcept)為 KC01242235，則給付適應症條件代碼(Claim.item.programCode.coding) 僅可為 P072",
            "expression" : "Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01242235').exists() implies Bundle.entry.resource.item.where(extension.value.ofType(Reference).resolve().medication.coding.code = 'KC01242235').all(programCode.coding.code.matches('P072'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "claimResponse-1",
            "severity" : "error",
            "human" : "若申請案件類別(Claim.priority)為自主審查(#3)時，須填寫核定日期(ClaimResponse.created)、審查結果數量(ClaimResponse.item.adjudication.value)、核定註記(ClaimResponse.item.adjudication.reason)及審查委員身分證號(extension[requestor])。",
            "expression" : "(Bundle.entry.select((resource as Claim).priority.coding.code.matches('3'))) implies (Bundle.entry.select((resource as ClaimResponse).created).exists()) and (Bundle.entry.select((resource as ClaimResponse).item.adjudication.value).exists()) and (Bundle.entry.select((resource as ClaimResponse).item.adjudication.reason).exists()) and (Bundle.entry.select((resource as ClaimResponse).extension.where(url = 'https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claimResponse-requestor')).exists())",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          },
          {
            "key" : "claimResponse-2",
            "severity" : "error",
            "human" : "若申請案件類別(Claim.priority)為自主審查(#3)，且國際疾病分類代碼(Claim.diagnosis.diagnosis)前三碼為C18、C19、C20、C21、C22、C33、C34、C50、C61(五癌)時，則續用註記(Claim.item.modifier:continuation)須為申請再次使用(#2)。",
            "expression" : "(Bundle.entry.resource.ofType(Claim).priority.coding.where(code = '3').exists()) and (Bundle.entry.resource.ofType(Claim).diagnosis.diagnosis.ofType(CodeableConcept).coding.where(code.matches('^(C18|C19|C20|C21|C22|C33|C34|C50|C61)')).exists()) implies (Bundle.entry.resource.ofType(Claim).item.modifier.coding.where(system = 'https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status').code.all($this = '2'))",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
          }
        ]
      },
      {
        "id" : "Bundle.meta",
        "path" : "Bundle.meta",
        "min" : 1
      },
      {
        "id" : "Bundle.meta.profile",
        "path" : "Bundle.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "collection"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "緊急報備日期，YYYY-MM-DDTHH:MM:SS (需包含時區)；若本案件前已緊急報備過，本次為檢送完整資訊申請送件者，由機構將前次緊急報備時所填之申請日期，自填為緊急報備日期。",
        "definition" : "YYYY-MM-DDTHH:MM:SS (需包含時區)；若本案件前已緊急報備過，本次為檢送完整資訊申請送件者，由機構將前次緊急報備時所填之申請日期，自填為緊急報備日期。",
        "comment" : "緊急報備日期，YYYY-MM-DDTHH:MM:SS (需包含時區)；若本案件前已緊急報備過，本次為檢送完整資訊申請送件者，由機構將前次緊急報備時所填之申請日期，自填為緊急報備日期。",
        "example" : [
          {
            "label" : "緊急報備日期",
            "valueDateTime" : "2024-05-30T13:50:58.000+08:00"
          }
        ]
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "closed"
        },
        "min" : 8,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claim",
        "path" : "Bundle.entry",
        "sliceName" : "claim",
        "short" : "事前審查(Claim)",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claim.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Claim",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "short" : "就醫科別",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "short" : "醫師(申請醫師／簽發影像報告醫師／簽發癌症分期報告醫師／檢查報告醫師／簽發檢驗(查)報告醫事人員／評估項目醫事人員)",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "醫事機構",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:diagnosticReportImage",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReportImage",
        "short" : "影像報告",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:diagnosticReportImage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-image-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:imageStudy",
        "path" : "Bundle.entry",
        "sliceName" : "imageStudy",
        "short" : "DICOM影像",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:imageStudy.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ImagingStudy",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:media",
        "path" : "Bundle.entry",
        "sliceName" : "media",
        "short" : "非DICOM影像",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:media.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Media",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationCancerStage",
        "path" : "Bundle.entry",
        "sliceName" : "observationCancerStage",
        "short" : "癌症分期量表",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationCancerStage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-cancer-stage-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:diagnosticReport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReport",
        "short" : "檢查報告",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:diagnosticReport.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationDiagnostic",
        "path" : "Bundle.entry",
        "sliceName" : "observationDiagnostic",
        "short" : "基因資訊",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationDiagnostic.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-diagnostic-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "short" : "檢體",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Specimen",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Specimen-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organizationGen",
        "path" : "Bundle.entry",
        "sliceName" : "organizationGen",
        "short" : "基因檢測機構",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organizationGen.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-genetic-testing-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "short" : "基因報告／治療計畫文件／檢驗(查)附件／病人狀態評估報告",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationLaboratoryResult",
        "path" : "Bundle.entry",
        "sliceName" : "observationLaboratoryResult",
        "short" : "檢驗(查)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationLaboratoryResult.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationPatientAssessment",
        "path" : "Bundle.entry",
        "sliceName" : "observationPatientAssessment",
        "short" : "病人狀態評估",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationPatientAssessment.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-pat-assessment-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:medicationRequestTreat",
        "path" : "Bundle.entry",
        "sliceName" : "medicationRequestTreat",
        "short" : "用藥品項",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:medicationRequestTreat.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:procedure",
        "path" : "Bundle.entry",
        "sliceName" : "procedure",
        "short" : "放射/照光治療",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:procedure.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:substance",
        "path" : "Bundle.entry",
        "sliceName" : "substance",
        "short" : "放射/照光治療總劑量",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:substance.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Substance",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationTreatmentAssessment",
        "path" : "Bundle.entry",
        "sliceName" : "observationTreatmentAssessment",
        "short" : "治療後疾病狀態評估",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationTreatmentAssessment.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-tx-assessment-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:medicationRequestApply",
        "path" : "Bundle.entry",
        "sliceName" : "medicationRequestApply",
        "short" : "事前審查品項",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:medicationRequestApply.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "short" : "健保事前審查計畫",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Coverage",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Coverage-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claimResponse",
        "path" : "Bundle.entry",
        "sliceName" : "claimResponse",
        "short" : "自主審查。若申請案件類別(Claim.priority)為自主審查(#3)時，須填寫。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:claimResponse.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ClaimResponse",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-self-assessment-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organizationOrg",
        "path" : "Bundle.entry",
        "sliceName" : "organizationOrg",
        "short" : "政府機構",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organizationOrg.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:compositionOpd",
        "path" : "Bundle.entry",
        "sliceName" : "compositionOpd",
        "short" : "門診病歷",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:compositionOpd.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Composition-opd-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:encounterOpd",
        "path" : "Bundle.entry",
        "sliceName" : "encounterOpd",
        "short" : "門診病歷",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:encounterOpd.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "short" : "診斷",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationBloodgroup",
        "path" : "Bundle.entry",
        "sliceName" : "observationBloodgroup",
        "short" : "血型",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationBloodgroup.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-blood-group-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:allergyIntolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyIntolerance",
        "short" : "過敏史",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:allergyIntolerance.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationSubjective",
        "path" : "Bundle.entry",
        "sliceName" : "observationSubjective",
        "short" : "主觀描述(S)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationSubjective.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-subjective-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationObjective",
        "path" : "Bundle.entry",
        "sliceName" : "observationObjective",
        "short" : "客觀描述(O)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:observationObjective.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-objective-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:clinicalImpression",
        "path" : "Bundle.entry",
        "sliceName" : "clinicalImpression",
        "short" : "評估(A)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:clinicalImpression.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ClinicalImpression",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:carePlan",
        "path" : "Bundle.entry",
        "sliceName" : "carePlan",
        "short" : "計畫(P)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:carePlan.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "CarePlan",
            "profile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
