# 申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型**

## Logical Model: 申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyImmModel | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:ApplyImmModel |

 
申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型，此邏輯模型為定義免疫製劑事前審查情境下使用的所有資料欄位。
為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-imm.md)進行欄位對應 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/ApplyImmModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ApplyImmModel.csv), [Excel](StructureDefinition-ApplyImmModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ApplyImmModel",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyImmModel",
  "version" : "1.1.0",
  "name" : "ApplyImmModel",
  "title" : "申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型，此邏輯模型為定義免疫製劑事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-imm.html)進行欄位對應",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWPASImmClaim",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-immunologic-agent-twpas",
      "name" : "Mapping to TWPAS Claim Immunologic Aagent"
    },
    {
      "identity" : "TWPASImmPatient",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas",
      "name" : "Mapping to TWPAS Patient"
    },
    {
      "identity" : "TWPASObservationBloodGroup",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-blood-group-twpas",
      "name" : "Mapping to TWPAS ObservationBloodGroupTWPAS"
    },
    {
      "identity" : "TWPASAllergyIntolerance",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas",
      "name" : "Mapping to TWPAS AllergyIntolerance"
    },
    {
      "identity" : "TWPASCompositionOpd",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Composition-opd-twpas",
      "name" : "Mapping to TWPAS Composition OPD"
    },
    {
      "identity" : "TWPASEncounterOpd",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas",
      "name" : "Mapping to TWPAS Encounter OPD"
    },
    {
      "identity" : "TWPASCondition",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas",
      "name" : "Mapping to TWPAS Condition"
    },
    {
      "identity" : "TWPASObservationSubjective",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-subjective-twpas",
      "name" : "Mapping to TWPAS Observation Subjective"
    },
    {
      "identity" : "TWPASObservationObjective",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-objective-twpas",
      "name" : "Mapping to TWPAS Observation Objective"
    },
    {
      "identity" : "TWPASClinicalImpression",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas",
      "name" : "Mapping to TWPAS ClinicalImpression"
    },
    {
      "identity" : "TWPASCarePlan",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas",
      "name" : "Mapping to TWPAS CarePlan"
    },
    {
      "identity" : "TWPASImmDiagnosticReportImage",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-image-twpas",
      "name" : "Mapping to TWPAS DiagnosticReportImage"
    },
    {
      "identity" : "TWPASImmImagingStudy",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas",
      "name" : "Mapping to TWPAS ImagingStudy"
    },
    {
      "identity" : "TWPASImmMedia",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas",
      "name" : "Mapping to TWPAS Media"
    },
    {
      "identity" : "TWPASImmDiagnosticReport",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-twpas",
      "name" : "Mapping to TWPAS DiagnosticReport"
    },
    {
      "identity" : "TWPASImmObservationLaboratoryResult",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas",
      "name" : "Mapping to TWPAS ObservationLaboratoryResult"
    },
    {
      "identity" : "TWPASImmObservationPatientAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-pat-assessment-twpas",
      "name" : "Mapping to TWPAS ObservationPatientAssessment"
    },
    {
      "identity" : "TWPASImmMedicationRequestTreat",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas",
      "name" : "Mapping to TWPAS MedicationRequestTreatTWPAS"
    },
    {
      "identity" : "TWPASImmProcedure",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas",
      "name" : "Mapping to TWPAS Procedure"
    },
    {
      "identity" : "TWPASImmSubstance",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas",
      "name" : "Mapping to TWPAS Substance"
    },
    {
      "identity" : "TWPASImmDocumentReference",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas",
      "name" : "Mapping to TWPAS DocumentReference"
    },
    {
      "identity" : "TWPASImmObservationTreatmentAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-tx-assessment-twpas",
      "name" : "Mapping to TWPAS ObservationTreatmentAssessment"
    },
    {
      "identity" : "TWPASImmMedicationRequestApply",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas",
      "name" : "Mapping to TWPAS MedicationRequestApply"
    },
    {
      "identity" : "TWPASImmClaimResponseSelfAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-self-assessment-twpas",
      "name" : "Mapping to TWPAS ClaimResponse Self Assessment"
    },
    {
      "identity" : "TWPASImmPractitioner",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas",
      "name" : "Mapping to TWPAS Practitioner"
    },
    {
      "identity" : "TWPASImmBundle",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-immunologic-agent-twpas",
      "name" : "Mapping to TWPAS Bundle Immunologic Aagent"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyImmModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ApplyImmModel",
        "path" : "ApplyImmModel",
        "short" : "申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型",
        "definition" : "申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型，此邏輯模型為定義免疫製劑事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-imm.html)進行欄位對應"
      },
      {
        "id" : "ApplyImmModel.hosp",
        "path" : "ApplyImmModel.hosp",
        "short" : "院所資訊",
        "definition" : "院所資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.hospId",
        "path" : "ApplyImmModel.hosp.hospId",
        "short" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "definition" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.provider.reference"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.applType",
        "path" : "ApplyImmModel.hosp.applType",
        "short" : "申報類別",
        "definition" : "申報類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.subType.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.funcType",
        "path" : "ApplyImmModel.hosp.funcType",
        "short" : "就醫科別",
        "definition" : "就醫科別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.extension.where(url = 'https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter').valueReference.reference"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.applPrsnId",
        "path" : "ApplyImmModel.hosp.applPrsnId",
        "short" : "申請醫師身分證號",
        "definition" : "申請醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.enterer.reference"
          },
          {
            "identity" : "TWPASImmPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.applDate",
        "path" : "ApplyImmModel.hosp.applDate",
        "short" : "申請日期，機構自填",
        "definition" : "申請日期，機構自填",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.created"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.immediateDate",
        "path" : "ApplyImmModel.hosp.immediateDate",
        "short" : "緊急報備日期，機構自填",
        "definition" : "緊急報備日期，機構自填",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmBundle",
            "map" : "Bundle.timestamp"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.tmhbType",
        "path" : "ApplyImmModel.hosp.tmhbType",
        "short" : "申請案件類別",
        "definition" : "申請案件類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.priority.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.hosp.oldAcptNo",
        "path" : "ApplyImmModel.hosp.oldAcptNo",
        "short" : "原受理編號",
        "definition" : "原受理編號",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient",
        "path" : "ApplyImmModel.patient",
        "short" : "病人資訊",
        "definition" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.name",
        "path" : "ApplyImmModel.patient.name",
        "short" : "姓名",
        "definition" : "姓名",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmPatient",
            "map" : "Patient.name.text"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.idCard",
        "path" : "ApplyImmModel.patient.idCard",
        "short" : "身分證字號",
        "definition" : "身分證字號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.patient.reference"
          },
          {
            "identity" : "TWPASImmPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'NNxxx').value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.patId",
        "path" : "ApplyImmModel.patient.patId",
        "short" : "病歷號",
        "definition" : "病歷號 (參與醫院必須註冊命名系統)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'MR').value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.birthday",
        "path" : "ApplyImmModel.patient.birthday",
        "short" : "出生日期",
        "definition" : "出生日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmPatient",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.gender",
        "path" : "ApplyImmModel.patient.gender",
        "short" : "病人性別",
        "definition" : "病人性別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmPatient",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.weight",
        "path" : "ApplyImmModel.patient.weight",
        "short" : "病人體重",
        "definition" : "病人體重",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'weight').valueQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.height",
        "path" : "ApplyImmModel.patient.height",
        "short" : "病人身高",
        "definition" : "病人身高",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'height').valueQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.pregnant",
        "path" : "ApplyImmModel.patient.pregnant",
        "short" : "是否懷孕或哺乳",
        "definition" : "是否懷孕或哺乳",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'pregnancyBreastfeedingStatus').valueBoolean"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.blood",
        "path" : "ApplyImmModel.patient.blood",
        "short" : "血型",
        "definition" : "血型",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'bloodgroup').valueReference"
          },
          {
            "identity" : "TWPASObservationBloodGroup",
            "map" : "Observation.value[x]"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.patient.allergy",
        "path" : "ApplyImmModel.patient.allergy",
        "short" : "過敏史",
        "definition" : "過敏史",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'allergy').valueReference"
          },
          {
            "identity" : "TWPASAllergyIntolerance",
            "map" : "AllergyIntolerance.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd",
        "path" : "ApplyImmModel.opd",
        "short" : "門診病歷",
        "definition" : "門診病歷",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'opd').valueReference"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.hospId",
        "path" : "ApplyImmModel.opd.hospId",
        "short" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "definition" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASEncounterOpd",
            "map" : "Encounter.serviceProvider"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.funcDate",
        "path" : "ApplyImmModel.opd.funcDate",
        "short" : "門診日期",
        "definition" : "門診日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASEncounterOpd",
            "map" : "Encounter.period.start"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.funcType",
        "path" : "ApplyImmModel.opd.funcType",
        "short" : "科別",
        "definition" : "科別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASEncounterOpd",
            "map" : "Encounter.serviceType"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.prsnId",
        "path" : "ApplyImmModel.opd.prsnId",
        "short" : "門診醫師身分證號",
        "definition" : "門診醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASEncounterOpd",
            "map" : "Encounter.participant.individual"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.icd10cmCode",
        "path" : "ApplyImmModel.opd.icd10cmCode",
        "short" : "診斷",
        "definition" : "診斷",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASEncounterOpd",
            "map" : "Encounter.diagnosis.condition"
          },
          {
            "identity" : "TWPASCondition",
            "map" : "Condition.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.subjective",
        "path" : "ApplyImmModel.opd.subjective",
        "short" : "主觀描述",
        "definition" : "主觀描述",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASCompositionOpd",
            "map" : "Composition.section[subjective].entry"
          },
          {
            "identity" : "TWPASObservationSubjective",
            "map" : "Observation.value[x]"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.objective",
        "path" : "ApplyImmModel.opd.objective",
        "short" : "客觀描述",
        "definition" : "客觀描述",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASCompositionOpd",
            "map" : "Composition.section[subjective].entry"
          },
          {
            "identity" : "TWPASObservationObjective",
            "map" : "Observation.value[x]"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.assessment",
        "path" : "ApplyImmModel.opd.assessment",
        "short" : "評估",
        "definition" : "評估",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASCompositionOpd",
            "map" : "Composition.section[subjective].entry"
          },
          {
            "identity" : "TWPASClinicalImpression",
            "map" : "ClinicalImpression.summary"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.opd.plan",
        "path" : "ApplyImmModel.opd.plan",
        "short" : "計畫",
        "definition" : "計畫",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASCompositionOpd",
            "map" : "Composition.section[subjective].entry"
          },
          {
            "identity" : "TWPASCarePlan",
            "map" : "CarePlan.description"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis",
        "path" : "ApplyImmModel.diagnosis",
        "short" : "疾病資訊",
        "definition" : "疾病資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.icd10cmCode",
        "path" : "ApplyImmModel.diagnosis.icd10cmCode",
        "short" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "definition" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.diagnosis.diagnosisCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.diagDate",
        "path" : "ApplyImmModel.diagnosis.diagDate",
        "short" : "診斷日期，sequence=1必填",
        "definition" : "YYYYMMDD，西元年月日，民國前為負數，sequence=1時為必填",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.diagnosis.extension.where(url = 'http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate').valueDate"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.diagCurrentStatus",
        "path" : "ApplyImmModel.diagnosis.diagCurrentStatus",
        "short" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原事前審查之申請理由。",
        "definition" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原事前審查之申請理由。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.diagnosis.type.text"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.medrec",
        "path" : "ApplyImmModel.diagnosis.medrec",
        "short" : "病歷資料（非屬影像報告檢查驗報告部分）",
        "definition" : "病歷資料（非屬影像報告檢查驗報告部分）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'medicalRecord').valueReference.reference"
          },
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.medrecTitle",
        "path" : "ApplyImmModel.diagnosis.medrecTitle",
        "short" : "病歷資料名稱",
        "definition" : "病歷資料名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy",
        "path" : "ApplyImmModel.diagnosis.imageStudy",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgItem",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgItem",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'imagingReport').valueReference.reference"
          },
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgResult",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgResult",
        "short" : "影像報告結果",
        "definition" : "影像報告結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.conclusion"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgBodySite",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgBodySite",
        "short" : "影像檢查的身體部位",
        "definition" : "影像檢查的身體部位",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.code.text"
          },
          {
            "identity" : "TWPASImmImagingStudy",
            "map" : "ImagingStudy.series.bodySite.code"
          },
          {
            "identity" : "TWPASImmMedia",
            "map" : "Media.bodySite.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgDate",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgDate",
        "short" : "影像報告日期",
        "definition" : "影像報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgDicom",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgDicom",
        "short" : "DICOM影像",
        "definition" : "DICOM影像",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.imagingStudy.reference"
          },
          {
            "identity" : "TWPASImmImagingStudy",
            "map" : "ImagingStudy.series.instance.uid"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgNonDicom",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgNonDicom",
        "short" : "非DICOM影像",
        "definition" : "非DICOM影像",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.media.link.reference"
          },
          {
            "identity" : "TWPASImmMedia",
            "map" : "Media.contnet.url"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.imageStudy.imgInterpreter",
        "path" : "ApplyImmModel.diagnosis.imageStudy.imgInterpreter",
        "short" : "簽發影像報告醫師身分證號",
        "definition" : "簽發影像報告醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReportImage",
            "map" : "DiagnosticReport.performer.reference"
          },
          {
            "identity" : "TWPASImmPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport",
        "path" : "ApplyImmModel.diagnosis.examinationReport",
        "short" : "檢查報告",
        "definition" : "檢查報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportType",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportType",
        "short" : "報告類型",
        "definition" : "報告類型。當LOINC無法具體描述檢體種類（例如：`47526-9`時），請填寫及補充說明檢體種類。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.speType",
        "path" : "ApplyImmModel.diagnosis.examinationReport.speType",
        "short" : "檢體種類",
        "definition" : "檢體種類",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.code.text"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportResult",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportResult",
        "short" : "檢查報告結果",
        "definition" : "檢查報告結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultString",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultString",
        "short" : "檢查報告結果（文數字）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.conclusion"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultPdf",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultPdf",
        "short" : "檢查報告結果（檔案路徑）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'examinationReport').valueReference.reference"
          },
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.presentedForm.url"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultPdfTitle",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportResult.reportResultPdfTitle",
        "short" : "檢查報告名稱",
        "definition" : "檢查報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.presentedForm.title"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportDate",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportDate",
        "short" : "報告日期",
        "definition" : "報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.diagnosis.examinationReport.reportPerformer",
        "path" : "ApplyImmModel.diagnosis.examinationReport.reportPerformer",
        "short" : "檢查報告醫師身分證號",
        "definition" : "檢查報告醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDiagnosticReport",
            "map" : "DiagnosticReport.performer.reference"
          },
          {
            "identity" : "TWPASImmPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate",
        "path" : "ApplyImmModel.evaluate",
        "short" : "評估資訊",
        "definition" : "評估資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests",
        "path" : "ApplyImmModel.evaluate.tests",
        "short" : "檢驗(查)",
        "definition" : "檢驗(查)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspect",
        "path" : "ApplyImmModel.evaluate.tests.inspect",
        "short" : "檢驗(查)名稱或套組代碼",
        "definition" : "檢驗(查)名稱或套組代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'tests').valueReference.reference"
          },
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectResultTxt",
        "path" : "ApplyImmModel.evaluate.tests.inspectResultTxt",
        "short" : "檢驗(查)結果判讀",
        "definition" : "檢驗(查)結果判讀",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.interpretation.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectResult[x]",
        "path" : "ApplyImmModel.evaluate.tests.inspectResult[x]",
        "short" : "檢驗(查)結果",
        "definition" : "檢驗(查)結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.consultValueLower",
        "path" : "ApplyImmModel.evaluate.tests.consultValueLower",
        "short" : "檢驗(查)結果之參考範圍下限",
        "definition" : "檢驗(查)結果之參考範圍下限",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.referenceRange.low.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.consultValueMax",
        "path" : "ApplyImmModel.evaluate.tests.consultValueMax",
        "short" : "檢驗(查)結果之參考範圍上限",
        "definition" : "檢驗(查)結果之參考範圍上限",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.referenceRange.high.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.consultValueCat",
        "path" : "ApplyImmModel.evaluate.tests.consultValueCat",
        "short" : "檢驗(查)結果之參考範圍類型",
        "definition" : "檢驗(查)結果之參考範圍類型",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.referenceRange.type.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.consultValueDesc",
        "path" : "ApplyImmModel.evaluate.tests.consultValueDesc",
        "short" : "檢驗(查)結果之參考範圍說明",
        "definition" : "檢驗(查)結果之參考範圍說明",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.referenceRange.text"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectSet",
        "path" : "ApplyImmModel.evaluate.tests.inspectSet",
        "short" : "套組中的的檢驗",
        "definition" : "套組中的的檢驗",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Observation"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.component"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.caseTime",
        "path" : "ApplyImmModel.evaluate.tests.caseTime",
        "short" : "檢驗(查)報告日期",
        "definition" : "檢驗(查)報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectPdf",
        "path" : "ApplyImmModel.evaluate.tests.inspectPdf",
        "short" : "檢驗(查)附件（檔案路徑）",
        "definition" : "檢驗(查)附件（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.derivedFrom.reference"
          },
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectPdfTitle",
        "path" : "ApplyImmModel.evaluate.tests.inspectPdfTitle",
        "short" : "檢驗(查)附件名稱",
        "definition" : "檢驗(查)附件名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.tests.inspectPerformer",
        "path" : "ApplyImmModel.evaluate.tests.inspectPerformer",
        "short" : "簽發檢驗(查)報告醫事人員身分證號",
        "definition" : "簽發檢驗(查)報告醫事人員身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationLaboratoryResult",
            "map" : "Observation.performer.reference"
          },
          {
            "identity" : "TWPASImmPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment",
        "path" : "ApplyImmModel.evaluate.patientAssessment",
        "short" : "病人狀態評估",
        "definition" : "病人狀態評估",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAst",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAst",
        "short" : "病人狀態評估項目代碼",
        "definition" : "病人狀態評估項目代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'patientAssessment').valueReference.reference"
          },
          {
            "identity" : "TWPASImmObservationPatientAssessment",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAstResult",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAstResult",
        "short" : "病人狀態評估結果",
        "definition" : "病人狀態評估結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationPatientAssessment",
            "map" : "Observation.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAstDate",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAstDate",
        "short" : "病人狀態評估日期",
        "definition" : "病人狀態評估日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationPatientAssessment",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAstPdf",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAstPdf",
        "short" : "病人狀態評估報告（檔案路徑）",
        "definition" : "病人狀態評估報告（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAstPdfTitle",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAstPdfTitle",
        "short" : "病人狀態評估報告名稱",
        "definition" : "病人狀態評估報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.evaluate.patientAssessment.patAstPerformer",
        "path" : "ApplyImmModel.evaluate.patientAssessment.patAstPerformer",
        "short" : "評估項目醫事人員身分證號",
        "definition" : "評估項目醫事人員身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationPatientAssessment",
            "map" : "Observation.performer.reference"
          },
          {
            "identity" : "TWPASImmPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat",
        "path" : "ApplyImmModel.treat",
        "short" : "治療資訊",
        "definition" : "治療資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest",
        "path" : "ApplyImmModel.treat.medicationRequest",
        "short" : "用藥品項",
        "definition" : "用藥品項",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.drugType",
        "path" : "ApplyImmModel.treat.medicationRequest.drugType",
        "short" : "自費註記",
        "definition" : "自費註記",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.category.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.drugStatus",
        "path" : "ApplyImmModel.treat.medicationRequest.drugStatus",
        "short" : "藥物使用狀態",
        "definition" : "藥物使用狀態",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.status"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.drugCode",
        "path" : "ApplyImmModel.treat.medicationRequest.drugCode",
        "short" : "藥品代碼",
        "definition" : "藥品代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'medicationRequest').valueReference.reference"
          },
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.medicationCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.drugFre",
        "path" : "ApplyImmModel.treat.medicationRequest.drugFre",
        "short" : "藥品使用頻率及服用時間",
        "definition" : "藥品使用頻率及服用時間",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.code.text"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.drugRoute",
        "path" : "ApplyImmModel.treat.medicationRequest.drugRoute",
        "short" : "給藥途徑／作用部位",
        "definition" : "給藥途徑／作用部位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.route"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.dose",
        "path" : "ApplyImmModel.treat.medicationRequest.dose",
        "short" : "藥物每次處方劑量",
        "definition" : "藥物每次處方劑量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.doseUnit",
        "path" : "ApplyImmModel.treat.medicationRequest.doseUnit",
        "short" : "藥物每次處方劑量單位",
        "definition" : "藥物每次處方劑量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.sDate",
        "path" : "ApplyImmModel.treat.medicationRequest.sDate",
        "short" : "藥物處方起始日期",
        "definition" : "藥物處方起始日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.boundsPeriod.start"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.eDate",
        "path" : "ApplyImmModel.treat.medicationRequest.eDate",
        "short" : "藥物處方終止日期",
        "definition" : "藥物處方終止日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.boundsPeriod.end"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.medicationRequest.eReason",
        "path" : "ApplyImmModel.treat.medicationRequest.eReason",
        "short" : "藥物處方終止原因",
        "definition" : "藥物處方終止原因",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestTreat",
            "map" : "MedicationRequest.statusReason"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy",
        "path" : "ApplyImmModel.treat.radiotherapy",
        "short" : "放射/照光治療",
        "definition" : "放射/照光治療",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy.rt",
        "path" : "ApplyImmModel.treat.radiotherapy.rt",
        "short" : "放射/照光治療項目",
        "definition" : "放射/照光治療項目",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'radiotherapy').valueReference.reference"
          },
          {
            "identity" : "TWPASImmProcedure",
            "map" : "Procedure.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy.rtStatus",
        "path" : "ApplyImmModel.treat.radiotherapy.rtStatus",
        "short" : "放射/照光治療狀態",
        "definition" : "放射/照光治療狀態",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmProcedure",
            "map" : "Procedure.status"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy.realInspectTime",
        "path" : "ApplyImmModel.treat.radiotherapy.realInspectTime",
        "short" : "放射/照光治療日期",
        "definition" : "放射/照光治療日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmProcedure",
            "map" : "Procedure.performedDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy.rtDose",
        "path" : "ApplyImmModel.treat.radiotherapy.rtDose",
        "short" : "放射/照光治療總劑量",
        "definition" : "放射/照光治療總劑量",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmProcedure",
            "map" : "Procedure.usedReference.reference"
          },
          {
            "identity" : "TWPASImmSubstance",
            "map" : "Substance.ingredient.quantity.numerator.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.radiotherapy.rtUnit",
        "path" : "ApplyImmModel.treat.radiotherapy.rtUnit",
        "short" : "放射/照光治療總劑量單位",
        "definition" : "放射/照光治療總劑量單位",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmSubstance",
            "map" : "Substance.ingredient.quantity.numerator.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.opCode",
        "path" : "ApplyImmModel.treat.opCode",
        "short" : "手術(或其他處置)項目",
        "definition" : "手術(或其他處置)項目",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.procedure.procedureCodeableConcept.coding"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.opDate",
        "path" : "ApplyImmModel.treat.opDate",
        "short" : "手術(或其他處置)日期",
        "definition" : "手術(或其他處置)日期",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.procedure.date"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.carePlanDocument",
        "path" : "ApplyImmModel.treat.carePlanDocument",
        "short" : "治療計畫文件（檔案路徑）",
        "definition" : "治療計畫文件（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'carePlanDocument').valueReference.reference"
          },
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.treat.carePlanDocumentTitle",
        "path" : "ApplyImmModel.treat.carePlanDocumentTitle",
        "short" : "治療計畫文件名稱",
        "definition" : "治療計畫文件名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.result",
        "path" : "ApplyImmModel.result",
        "short" : "結果資訊",
        "definition" : "結果資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.result.txAst",
        "path" : "ApplyImmModel.result.txAst",
        "short" : "治療後疾病狀態評估項目",
        "definition" : "治療後疾病狀態評估項目",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'treatmentAssessment').valueReference.reference"
          },
          {
            "identity" : "TWPASImmObservationTreatmentAssessment",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.result.txAstResult",
        "path" : "ApplyImmModel.result.txAstResult",
        "short" : "治療後疾病狀態評估結果",
        "definition" : "治療後疾病狀態評估結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationTreatmentAssessment",
            "map" : "Observation.valueString"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.result.txAstDate",
        "path" : "ApplyImmModel.result.txAstDate",
        "short" : "治療後疾病狀態評估日期",
        "definition" : "治療後疾病狀態評估日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmObservationTreatmentAssessment",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply",
        "path" : "ApplyImmModel.apply",
        "short" : "申請項目",
        "definition" : "申請項目",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.continuation",
        "path" : "ApplyImmModel.apply.continuation",
        "short" : "續用註記",
        "definition" : "續用註記",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.modifier.where(coding.system = 'https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status').coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.lot",
        "path" : "ApplyImmModel.apply.lot",
        "short" : "用藥線別",
        "definition" : "用藥線別",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.modifier.where(coding.system = 'https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy').coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.orderType",
        "path" : "ApplyImmModel.apply.orderType",
        "short" : "醫令類別",
        "definition" : "醫令類別",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.productOrService.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.cancerDrugType",
        "path" : "ApplyImmModel.apply.cancerDrugType",
        "short" : "事前審查品項代碼",
        "definition" : "事前審查品項代碼",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.extension.where(url = 'https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService').valueReference.reference"
          },
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.medicationCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applyReason",
        "path" : "ApplyImmModel.apply.applyReason",
        "short" : "給付適應症條件",
        "definition" : "給付適應症條件",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.programCode"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applySide",
        "path" : "ApplyImmModel.apply.applySide",
        "short" : "申請部位",
        "definition" : "申請部位",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.bodySite"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applQty",
        "path" : "ApplyImmModel.apply.applQty",
        "short" : "事前審查申請數量",
        "definition" : "事前審查申請數量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.quantity.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applQtyUnit",
        "path" : "ApplyImmModel.apply.applQtyUnit",
        "short" : "事前審查申請數量單位",
        "definition" : "事前審查申請數量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaim",
            "map" : "Claim.item.quantity.code"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applDrugFre",
        "path" : "ApplyImmModel.apply.applDrugFre",
        "short" : "事前審查藥品使用頻率及服用時間",
        "definition" : "事前審查藥品使用頻率及服用時間",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.code.coding"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applDrugRoute",
        "path" : "ApplyImmModel.apply.applDrugRoute",
        "short" : "給藥途徑／作用部位",
        "definition" : "給藥途徑／作用部位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.route"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applDosage",
        "path" : "ApplyImmModel.apply.applDosage",
        "short" : "事前審查藥品每次處方劑量",
        "definition" : "事前審查藥品每次處方劑量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applDosageUnit",
        "path" : "ApplyImmModel.apply.applDosageUnit",
        "short" : "事前審查藥品每次處方劑量單位",
        "definition" : "事前審查藥品每次處方劑量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].unit"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.useSdate",
        "path" : "ApplyImmModel.apply.useSdate",
        "short" : "事前審查藥物預定處方起始日期",
        "definition" : "事前審查藥物預定處方起始日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].start"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.useEdate",
        "path" : "ApplyImmModel.apply.useEdate",
        "short" : "事前審查藥物預定處方終止日期",
        "definition" : "事前審查藥物預定處方終止日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].end"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.applDrugCycle",
        "path" : "ApplyImmModel.apply.applDrugCycle",
        "short" : "事前審查藥品療程／週期數",
        "definition" : "事前審查藥品療程／週期數",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.count"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.approver",
        "path" : "ApplyImmModel.apply.approver",
        "short" : "審查委員身分證號",
        "definition" : "審查委員身分證號",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaimResponseSelfAssessment",
            "map" : "ClaimResponse.extension:requestor"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.approveDate",
        "path" : "ApplyImmModel.apply.approveDate",
        "short" : "核定日期",
        "definition" : "核定日期",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaimResponseSelfAssessment",
            "map" : "ClaimResponse.created"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.approveComment",
        "path" : "ApplyImmModel.apply.approveComment",
        "short" : "受理審查案件核定註記",
        "definition" : "受理審查案件核定註記",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.adjudication.reason"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.approveNum",
        "path" : "ApplyImmModel.apply.approveNum",
        "short" : "審查結果數量",
        "definition" : "審查結果數量",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.adjudication.value"
          }
        ]
      },
      {
        "id" : "ApplyImmModel.apply.acceptanceStatus",
        "path" : "ApplyImmModel.apply.acceptanceStatus",
        "short" : "個別醫令核定註記",
        "definition" : "個別醫令核定註記",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASImmClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.detail.adjudication.reason"
          }
        ]
      }
    ]
  }
}

```
