# 過敏史-AllergyIntolerance TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **過敏史-AllergyIntolerance TWPAS**

## Resource Profile: 過敏史-AllergyIntolerance TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:AllergyIntoleranceTWPAS |

 
此過敏史-AllergyIntolerance TWPAS Profile說明本IG如何進一步定義臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile以呈現免疫製劑事前審查之過敏史 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) and [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
* Examples for this Profile: [AllergyIntolerance/all-min](AllergyIntolerance-all-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/AllergyIntolerance-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AllergyIntolerance-twpas.csv), [Excel](StructureDefinition-AllergyIntolerance-twpas.xlsx), [Schematron](StructureDefinition-AllergyIntolerance-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AllergyIntolerance-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas",
  "version" : "1.1.0",
  "name" : "AllergyIntoleranceTWPAS",
  "title" : "過敏史-AllergyIntolerance TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此過敏史-AllergyIntolerance TWPAS Profile說明本IG如何進一步定義臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile以呈現免疫製劑事前審查之過敏史",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.meta",
        "path" : "AllergyIntolerance.meta",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.meta.profile",
        "path" : "AllergyIntolerance.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas"
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "short" : "過敏史，由醫院自行填寫。"
      },
      {
        "id" : "AllergyIntolerance.patient",
        "path" : "AllergyIntolerance.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
