# 用藥品項 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **用藥品項**

## Example MedicationRequest: 用藥品項

Profile：[用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)

**藥物使用狀態**：completed

**藥物處方終止原因**：Try another treatment first ([MedicationRequest Status Reason Codes](https://hl7.org/fhir/R4/codesystem-medicationrequest-status-reason.html)#altchoice)

**意圖**：Order ([medicationRequest Intent](http://hl7.org/fhir/CodeSystem/medicationrequest-intent)#order)

**自費註記**：健保 ([NHI-藥物類型](CodeSystem-nhi-drug-category.md)#nhi)

**藥品代碼**：ANTI-CUGH SYRUP 60ML ([NHI-健保事前審查-用藥品項值集](CodeSystem-nhi-medication.md)#A000755151)

**病人**：[Patient/pat-min](Patient-pat-min.md) ""

**藥品使用頻率及服用時間**：1W3D

**藥物每次處方劑量(單位)**：4 (tablets ([Common UCUM units](https://hl7.org/fhir/R4/valueset-ucum-common.html)#{tbl}))

**藥物處方起始日期**：2024-05-01

**藥物處方終止日期**：2024-05-07

**給藥途徑／作用部位**：Oral use ([SNOMED CT + 臺灣健保署給藥途徑值集](http://snomed.info/sct/)#26643006)



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "medReq-treat",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas"
    ]
  },
  "status" : "completed",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
        "code" : "altchoice"
      }
    ]
  },
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-drug-category",
          "code" : "nhi"
        }
      ]
    }
  ],
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
        "code" : "A000755151"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-min"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2024-05-01",
            "end" : "2024-05-07"
          }
        },
        "code" : {
          "text" : "1W3D"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 4,
            "unit" : "tablets",
            "system" : "http://unitsofmeasure.org",
            "code" : "{tbl}"
          }
        }
      ]
    }
  ]
}

```
