# TWPAS ImplementationGuide Resource - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* **TWPAS ImplementationGuide Resource**

## TWPAS ImplementationGuide Resource

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ImplementationGuide/tw.gov.mohw.nhi.pas | *Version*:1.1.0 |
| *NPM package name*: tw.gov.mohw.nhi.pas | *Computable Name*:TWPAS |

* [XML](ImplementationGuide-tw.gov.mohw.nhi.pas.xml)
* [JSON](ImplementationGuide-tw.gov.mohw.nhi.pas.json)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (tw.gov.mohw.nhi.pas.r4)](package.r4.tgz) and [R4B (tw.gov.mohw.nhi.pas.r4b)](package.r4b.tgz) are available. 

#### IG Dependencies

This IG Contains the following dependencies on other IGs.




















#### Global Profiles

*There are no Global profiles defined*

#### Copyrights

This publication includes IP covered under the following statements.

* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.1.0/CodeSystem-v3-ucum.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 16 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Claim/cla-1](Claim-cla-1.md),[Claim/cla-3](Claim-cla-3.md),[Claim/cla-imm](Claim-cla-imm.md),[ClaimImmTWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md),[ClaimTWPAS](StructureDefinition-Claim-twpas.md),[MedicationRequest/medReq-apply](MedicationRequest-medReq-apply.md),[MedicationRequest/medReq-apply-2](MedicationRequest-medReq-apply-2.md),[MedicationRequest/medReq-treat](MedicationRequest-medReq-treat.md),[MedicationRequestApplyTWPAS](StructureDefinition-MedicationRequest-apply-twpas.md),[MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md),[Observation/obs-lab-min](Observation-obs-lab-min.md),[Substance/sub-min](Substance-sub-min.md)and[SubstanceTWPAS](StructureDefinition-Substance-twpas.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [AcquisitionModality](ValueSet-dicom-cid-29-AcquisitionModality.md), [Bundle/bun-1](Bundle-bun-1.md)...Show 6 more,[Bundle/bun-3](Bundle-bun-3.md),[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[ImagingStudy/imaStu-min](ImagingStudy-imaStu-min.md)and[ImagingStudyTWPAS](StructureDefinition-ImagingStudy-twpas.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.1.0/CodeSystem-v3-loinc.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 34 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Composition/opd](Composition-opd.md),[CompositionOpdTWPAS](StructureDefinition-Composition-opd-twpas.md),[Condition/con-comorbidity](Condition-con-comorbidity.md),[Condition/con-diagnosis](Condition-con-diagnosis.md),[ConditionTWPAS](StructureDefinition-Condition-twpas.md),[DNAChangeType](ValueSet-dna-change-type.md),[DiagnosticReport/diaRep-ima-loinc](DiagnosticReport-diaRep-ima-loinc.md),[DiagnosticReport/diaRep-min](DiagnosticReport-diaRep-min.md),[DiagnosticReport/inline-2-diaRep-ima-loinc](DiagnosticReport-inline-2-diaRep-ima-loinc.md),[DiagnosticReport/inline-diaRep-ima-loinc](DiagnosticReport-inline-diaRep-ima-loinc.md),[DiagnosticReportImageTWPAS](StructureDefinition-DiagnosticReport-image-twpas.md),[DiagnosticReportTWPAS](StructureDefinition-DiagnosticReport-twpas.md),[GeneTestCode](ValueSet-gene-test-code.md),[ImagingReport](ValueSet-imaging-report.md),[Observation/obs-blood-group](Observation-obs-blood-group.md),[Observation/obs-diagnostic-min](Observation-obs-diagnostic-min.md),[Observation/obs-lab-cbc](Observation-obs-lab-cbc.md),[Observation/obs-lab-min](Observation-obs-lab-min.md),[Observation/obs-objective](Observation-obs-objective.md),[Observation/obs-pat-nyha](Observation-obs-pat-nyha.md),[Observation/obs-subjective](Observation-obs-subjective.md),[ObservationDiagnosticTWPAS](StructureDefinition-Observation-diagnostic-twpas.md),[ObservationLaboratoryResultTWPAS](StructureDefinition-Observation-laboratory-result-twpas.md),[ObservationObjectiveTWPAS](StructureDefinition-Observation-objective-twpas.md),[ObservationPatientAssessmentTWPAS](StructureDefinition-Observation-pat-assessment-twpas.md),[ObservationSubjectiveTWPAS](StructureDefinition-Observation-subjective-twpas.md),[PatAst](ValueSet-pat-ast.md),[ReportType](ValueSet-report-type.md),[Specimen/spe-min](Specimen-spe-min.md),[SpecimenTWPAS](StructureDefinition-Specimen-twpas.md)and[SpecimenType](ValueSet-specime-type.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 27 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[CancerStage](ValueSet-cancer-stage.md),[Encounter/enc-opd](Encounter-enc-opd.md),[EncounterOpdTWPAS](StructureDefinition-Encounter-opd-twpas.md),[EncounterTWPAS](StructureDefinition-Encounter-twpas.md),[ImagingStudy/imaStu-min](ImagingStudy-imaStu-min.md),[ImagingStudyTWPAS](StructureDefinition-ImagingStudy-twpas.md),[Media/med-min](Media-med-min.md),[MediaTWPAS](StructureDefinition-Media-twpas.md),[MedicationRequest/medReq-apply](MedicationRequest-medReq-apply.md),[MedicationRequest/medReq-apply-2](MedicationRequest-medReq-apply-2.md),[MedicationRequest/medReq-treat](MedicationRequest-medReq-treat.md),[MedicationRequestApplyTWPAS](StructureDefinition-MedicationRequest-apply-twpas.md),[MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md),[Observation/obs-blood-group](Observation-obs-blood-group.md),[Observation/obs-cancer-cns](Observation-obs-cancer-cns.md),[Observation/obs-cancer-figo](Observation-obs-cancer-figo.md),[Observation/obs-cancer-tnm](Observation-obs-cancer-tnm.md),[Observation/obs-pat-ctcae](Observation-obs-pat-ctcae.md),[ObservationBloodGroupTWPAS](StructureDefinition-Observation-blood-group-twpas.md),[ObservationCancerStageTWPAS](StructureDefinition-Observation-cancer-stage-twpas.md),[ObservationPatientAssessmentTWPAS](StructureDefinition-Observation-pat-assessment-twpas.md),[PatAst](ValueSet-pat-ast.md),[SNOMEDCTBodySite](ValueSet-sct-body-site.md)and[TWPCSMedicationPathSCT](ValueSet-medication-path-sct-tw.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/7.0.1/CodeSystem-adjudication.html): [Bundle/bun-response](Bundle-bun-response.md), [Bundle/bun-self](Bundle-bun-self.md), [Bundle/bun-uuid-example](Bundle-bun-uuid-example.md), [ClaimResponse/claim-response-example](ClaimResponse-claim-response-example.md) and [ClaimResponse/self-assessment-example](ClaimResponse-self-assessment-example.md)
* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/all-min](AllergyIntolerance-all-min.md) and [Bundle/bun-imm](Bundle-bun-imm.md)
* [Claim Type Codes](http://terminology.hl7.org/7.0.1/CodeSystem-claim-type.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 13 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-response](Bundle-bun-response.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Claim/cla-1](Claim-cla-1.md),[Claim/cla-3](Claim-cla-3.md),[Claim/cla-imm](Claim-cla-imm.md),[ClaimImmTWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md),[ClaimResponse/claim-response-example](ClaimResponse-claim-response-example.md),[ClaimResponse/self-assessment-example](ClaimResponse-self-assessment-example.md),[ClaimResponseSelfAssessmentTWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md),[ClaimResponseTWPAS](StructureDefinition-ClaimResponse-twpas.md)and[ClaimTWPAS](StructureDefinition-Claim-twpas.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Bundle/bun-imm](Bundle-bun-imm.md), [Condition/con-comorbidity](Condition-con-comorbidity.md), [Condition/con-diagnosis](Condition-con-diagnosis.md) and [ConditionTWPAS](StructureDefinition-Condition-twpas.md)
* [MedicationRequest Status Reason Codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationrequest-status-reason.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 4 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md)and[MedicationRequest/medReq-treat](MedicationRequest-medReq-treat.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/bun-imm](Bundle-bun-imm.md), [Observation/obs-objective](Observation-obs-objective.md), [Observation/obs-subjective](Observation-obs-subjective.md), [ObservationObjectiveTWPAS](StructureDefinition-Observation-objective-twpas.md) and [ObservationSubjectiveTWPAS](StructureDefinition-Observation-subjective-twpas.md)
* [Operation Outcome Codes](http://terminology.hl7.org/7.0.1/CodeSystem-operation-outcome.html): [OperationOutcome/error-example](OperationOutcome-error-example.md)
* [Organization type](http://terminology.hl7.org/7.0.1/CodeSystem-organization-type.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 5 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[臺北市立聯合醫院](Organization-org-hosp-example.md)and[衛生福利部中央健康保險署](Organization-org-nhi.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 8 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[ClaimResponseRequestor](StructureDefinition-extension-claimResponse-requestor.md),[Patient/pat-min](Patient-pat-min.md),[Patient/pat-resident](Patient-pat-resident.md),[Practitioner/pra-min](Practitioner-pra-min.md)and[臺北市立聯合醫院](Organization-org-hosp-example.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 7 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Encounter/enc-min](Encounter-enc-min.md),[Encounter/enc-opd](Encounter-enc-opd.md),[EncounterOpdTWPAS](StructureDefinition-Encounter-opd-twpas.md)and[EncounterTWPAS](StructureDefinition-Encounter-twpas.md)
* [GTSAbbreviation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-GTSAbbreviation.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-imm](Bundle-bun-imm.md)...Show 6 more,[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[MedicationRequest/medReq-apply](MedicationRequest-medReq-apply.md),[MedicationRequestApplyTWPAS](StructureDefinition-MedicationRequest-apply-twpas.md),[MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)and[NHIMedicationFrequencyHL7](ValueSet-medication-frequency-hl7-nhi.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 5 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Observation/obs-diagnostic-min](Observation-obs-diagnostic-min.md)and[Observation/obs-lab-min](Observation-obs-lab-min.md)
* [Orderable Drug Form](http://terminology.hl7.org/7.0.1/CodeSystem-v3-orderableDrugForm.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 4 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md)and[MedicationRequest/medReq-apply-2](MedicationRequest-medReq-apply-2.md)


* World Health Organization (WHO)

* [臺灣健保署2014年中文版ICD-10-CM](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-icd-10-cm-2014-tw.html): [ClaimImmTWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) and [ClaimTWPAS](StructureDefinition-Claim-twpas.md)
* [臺灣健保署2014年中文版ICD-10-PCS](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-icd-10-pcs-2014-tw.html): [ClaimImmTWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [ClaimTWPAS](StructureDefinition-Claim-twpas.md)...Show 5 more,[DiagnosticReportImageTWPAS](StructureDefinition-DiagnosticReport-image-twpas.md),[ICD10PCSImage](ValueSet-icd-10-pcs-2014-image.md),[ICD10PCSRadiotherapy](ValueSet-icd-10-pcs-2014-radiotherapy.md),[ProcedureTWPAS](StructureDefinition-Procedure-twpas.md)and[SubstanceTWPAS](StructureDefinition-Substance-twpas.md)


* 衛生福利部中央健康保險署

* [臺灣健保署就醫科別](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-medical-consultation-department-nhi-tw.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 4 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md)and[Encounter/enc-min](Encounter-enc-min.md)
* [臺灣健保署醫療服務給付項目](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-medical-service-payment-tw.html): [ClaimImmTWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [ClaimTWPAS](StructureDefinition-Claim-twpas.md) and [NHIMedicalServicePayment](ValueSet-nhi-medical-service-payment.md)
* [臺灣健保署給藥途徑](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-medication-path-tw.html): [MedicationRequestApplyTWPAS](StructureDefinition-MedicationRequest-apply-twpas.md), [MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md) and [TWPCSMedicationPathSCT](ValueSet-medication-path-sct-tw.md)


* 衛生福利部資訊處

* [臺灣衛福部資訊處照護計畫類別](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-careplan-category-tw.html): [Bundle/bun-imm](Bundle-bun-imm.md), [CarePlan/careplan-min](CarePlan-careplan-min.md) and [CarePlanTWPAS](StructureDefinition-CarePlan-twpas.md)
* [臺灣衛福部資訊處識別碼類型](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-v2-0203.html): [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md)...Show 4 more,[Bundle/bun-imm](Bundle-bun-imm.md),[Bundle/bun-self](Bundle-bun-self.md),[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md)and[衛生福利部中央健康保險署](Organization-org-nhi.md)


* 衛生福利部食品藥物管理署

* [臺灣食藥署醫療器材許可證](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-medication-device-fda-tw.html): [MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md) and [NHIMedicationFDA](ValueSet-nhi-medication-fda.md)
* [臺灣食藥署藥品許可證](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/CodeSystem-medication-fda-tw.html): [MedicationRequestTreatTWPAS](StructureDefinition-MedicationRequest-treat-twpas.md) and [NHIMedicationFDA](ValueSet-nhi-medication-fda.md)


