# 門診病歷-Encounter - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **門診病歷-Encounter**

## Example Encounter: 門診病歷-Encounter

Profile: [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**serviceType**: Family practice (qualifier value)

**subject**: [王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))](Patient-pat-min.md)

### Participants

| | |
| :--- | :--- |
| - | **Individual** |
| * | [Practitioner: identifier = National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code,Medical License number](Practitioner-pra-min.md) |

**period**: 2025-11-11 --> (ongoing)

> **diagnosis****condition**:[Condition M17.11](Condition-con-diagnosis.md)**rank**: 1

> **diagnosis****condition**:[Condition I10](Condition-con-comorbidity.md)**rank**: 2

**serviceProvider**: [Organization 臺北市立聯合醫院](Organization-org-hosp-example.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "enc-opd",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB"
  },
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "419772000"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-min"
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "Practitioner/pra-min"
      }
    }
  ],
  "period" : {
    "start" : "2025-11-11"
  },
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/con-diagnosis"
      },
      "rank" : 1
    },
    {
      "condition" : {
        "reference" : "Condition/con-comorbidity"
      },
      "rank" : 2
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/org-hosp-example"
  }
}

```
