# Artifacts Summary - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md) | 臺灣健保事前審查實作指引(TWPAS IG)伺服端(Server)之能力聲明 |
| [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) | 臺灣健保事前審查實作指引(TWPAS IG)用戶端(Client)之能力聲明 |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [Bundle-id](SearchParameter-Bundle-id.md) | 事前審查(Bundle)的邏輯性ID |
| [Claim-func-type](SearchParameter-Claim-func-type.md) | 事前審查(Claim)的就醫科別(extension: encounter) |
| [Claim-identifier](SearchParameter-Claim-identifier.md) | 事前審查(Claim)的受理編號(identifier) |
| [Claim-patient](SearchParameter-Claim-patient.md) | 事前審查(Claim)的病人資訊(patient) |
| [ClaimResponse-adjudication-reason](SearchParameter-ClaimResponse-adjudication-reason.md) | 事前審查回覆(ClaimResponse)的核定註記(item.adjudication.reason) |
| [ClaimResponse-created](SearchParameter-ClaimResponse-created.md) | 事前審查回覆(ClaimResponse)的受理日期或核定日期(Claim) |
| [ClaimResponse-disposition](SearchParameter-ClaimResponse-disposition.md) | 事前審查回覆(ClaimResponse)的案件受理狀態(disposition) |
| [ClaimResponse-request](SearchParameter-ClaimResponse-request.md) | 事前審查回覆(ClaimResponse)關聯的事前審查(Claim) |
| [Encounter-service-type](SearchParameter-Encounter-service-type.md) | 就醫科別(serviceType) |
| [Patient-identifier](SearchParameter-Patient-identifier.md) | 病人的身分證號(identifier) |
| [Patient-name](SearchParameter-Patient-name.md) | 病人的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。 |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [回覆(Response)事前審查之資料模型](StructureDefinition-ResponseModel.md) | 回覆(Response)事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.md#癌藥事前審查回覆之bundle架構bundle-response)進行欄位對應 |
| [申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型](StructureDefinition-ApplyImmModel.md) | 申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型，此邏輯模型為定義免疫製劑事前審查情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-imm.md)進行欄位對應 |
| [申請(Apply)癌症用藥癌藥事前審查之資料模型](StructureDefinition-ApplyModel.md) | 申請(Apply)癌症用藥癌藥事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.md)進行欄位對應 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md) | 此DICOM影像-ImagingStudy TWPAS Profile說明本IG如何進一步定義臺灣核心-影像檢查(TW Core ImagingStudy) Profile以呈現事前審查中疾病資訊之影像報告的影像檢查的身體部位及DICOM影像 |
| [主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md) | 此主觀描述-Observation Subjective TWPAS Profile說明本IG如何進一步定義臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment） Profile以呈現免疫製劑事前審查之主觀描述（S） |
| [事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md) | 此事前審查品項-MedicationRequest Apply TWPAS Profile說明本IG如何進一步定義臺灣核心-藥品請求(TW Core MedicationRequest) Profile以呈現事前審查中申請項目之事前審查品項 |
| [事前審查回覆-Bundle Response TWPAS](StructureDefinition-Bundle-response-twpas.md) | 此事前審查回覆-Bundle Response TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現回覆事前審查之內容 |
| [事前審查回覆-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md) | 此事前審查回覆-ClaimResponse TWPAS Profile說明本IG如何進一步定義FHIR的ClaimResponse Resource以呈現事前審查回覆之內容 |
| [健保事前審查計畫-Coverage TWPAS](StructureDefinition-Coverage-twpas.md) | 此健保事前審查計畫-Coverage TWPAS Profile說明本IG如何進一步定義FHIR的Coverage Resource以呈現事前審查之健保事前審查計畫 |
| [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) | 此免疫製劑事前審查-Bundle Immunologic Aagent TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現免疫製劑事前審查之內容 |
| [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) | 此免疫製劑事前審查-Claim Immunologic Aagent TWPAS Profile說明本IG如何進一步定義FHIR的Claim Resource以呈現免疫製劑事前審查之內容 |
| [基因檢測機構-Organization Genetic Testing TWPAS](StructureDefinition-Organization-genetic-testing-twpas.md) | 此基因檢測機構-Organization Genetic Testing TWPAS Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現事前審查之基因檢測機構基本資料 |
| [基因檢測檢體-Specimen TWPAS](StructureDefinition-Specimen-twpas.md) | 此基因檢測檢體-Specimen TWPAS Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現事前審查中基因資訊之檢測檢體相關內容 |
| [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md) | 此基因資訊-Observation Diagnostic TWPAS Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現事前審查之基因資訊 |
| [客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md) | 此客觀描述-Observation Objective TWPAS Profile說明本IG如何進一步定義臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment） Profile以呈現免疫製劑事前審查之客觀描述（O） |
| [就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md) | 此就醫科別-Encounter TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現事前審查中院所資訊之就醫科別 |
| [影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md) | 此影像報告-DiagnosticReport Image TWPAS Profile說明本IG如何進一步定義臺灣核心-診斷報告(TW Core DiagnosticReport) Profile以呈現事前審查之影像報告 |
| [放射/照光治療-Procedure TWPAS](StructureDefinition-Procedure-twpas.md) | 此放射/照光治療-Procedure TWPAS Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現事前審查中治療資訊之「放射治療」及「照光治療」等相關資訊 |
| [放射/照光治療總劑量-Substance TWPAS](StructureDefinition-Substance-twpas.md) | 此放射/照光治療總劑量-Substance TWPAS Profile說明本IG如何進一步定義FHIR的Substance Resource以呈現事前審查中治療資訊之「放射治療」及「照光治療」總劑量 |
| [文件參照-DocumentReference TWPAS](StructureDefinition-DocumentReference-twpas.md) | 此文件參照-DocumentReference TWPAS Profile說明本IG如何進一步定義臺灣核心-文件參照(TW Core DocumentReference) Profile以呈現事前審查之治療計畫文件及基因報告 |
| [檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md) | 此檢查報告-DiagnosticReport TWPAS Profile說明本IG如何進一步定義臺灣核心-診斷報告(TW Core DiagnosticReport) Profile以呈現事前審查中疾病資訊之檢查報告 |
| [檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md) | 此檢驗檢查-Observation Laboratory Result TWPAS Profile說明本IG如何進一步定義臺灣核心-檢驗檢查(TW Core Observation Laboratory Result) Profile以呈現事前審查中評估資訊之檢驗(查)相關資料 |
| [治療後疾病狀態評估-Observation Treatment Assessment TWPAS](StructureDefinition-Observation-tx-assessment-twpas.md) | 此治療後疾病狀態評估-Observation Treatment Assessment TWPAS Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現事前審查中結果資訊之治療後疾病狀態評估 |
| [用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md) | 此用藥品項-MedicationRequest Treat TWPAS Profile說明本IG如何進一步定義臺灣核心-藥品請求(TW Core MedicationRequest) Profile以呈現事前審查中治療資訊之用藥品項 |
| [病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md) | 此病人狀態評估-Observation Patient Assessment TWPAS Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現事前審查中評估資訊之病人狀態評估 |
| [病人資訊-Patient TWPAS](StructureDefinition-Patient-twpas.md) | 此病人資訊-Patient TWPAS Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現事前審查之病人基本資料 |
| [癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md) | 此癌症分期量表-Observation Cancer Stage TWPAS Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現事前審查中疾病資訊之癌症分期量表相關資料 |
| [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md) | 此癌藥事前審查-Bundle TWPAS Profile說明本IG如何進一步定義資料交換基本單位(TW Core Bundle) Profile以呈現癌藥事前審查之內容 |
| [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md) | 此癌藥事前審查-Claim TWPAS Profile說明本IG如何進一步定義FHIR的Claim Resource以呈現癌藥事前審查之內容 |
| [系統回應訊息-OperationOutcome TWPAS](StructureDefinition-Operationoutcome-twpas.md) | 此系統回應訊-OperationOutcome TWPAS Profile說明本IG如何進一步定義FHIR的OperationOutcome Resource以呈現系統回應訊息之內容 |
| [自主審查-ClaimResponse Self Assessment TWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md) | 此自主審查-ClaimResponse TWPAS Profile說明本IG如何進一步定義FHIR的ClaimResponse Resource以呈現自主審查之內容。現行開放自主事前審查項目僅有心臟及肝臟移植，若醫院要自主事前審查需向健保署申請，通過後，健保署會於署內系統維護，具有此資格之院所才可填報自主審查。 |
| [血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md) | 此血型-Observation Blood Group TWPAS Profile說明本IG如何進一步定義臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result） Profile以呈現免疫製劑事前審查之血型資訊 |
| [計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md) | 此計畫-CarePlan TWPAS Profile說明本IG如何進一步定義臺灣核心-照護計畫（TW Core CarePlan） Profile以呈現免疫製劑事前審查之計畫（P） |
| [診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md) | 此診斷-Condition TWPAS Profile說明本IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition）Profile以呈現免疫製劑事前審查之診斷 |
| [評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md) | 此評估-ClinicalImpression TWPAS Profile說明本IG如何進一步定義FHIR的ClinicalImpression Resource以呈現免疫製劑事前審查之評估（A） |
| [過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md) | 此過敏史-AllergyIntolerance TWPAS Profile說明本IG如何進一步定義臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）Profile以呈現免疫製劑事前審查之過敏史 |
| [醫事人員-Practitioner TWPAS](StructureDefinition-Practitioner-twpas.md) | 此醫事人員-Practitioner TWPAS Profile說明本IG如何進一步定義臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile以呈現事前審查之申請醫師、簽發影像報告醫師、簽發癌症分期報告醫師、檢查報告醫師、簽發檢驗(查)報告醫事人員、評估項目醫事人員及免疫製劑事前審查之門診醫師基本資料 |
| [醫事機構-Organization TWPAS](StructureDefinition-Organization-twpas.md) | 此醫事機構-Organization TWPAS Profile說明本IG如何進一步定義臺灣核心-機構(TW Core Organization) Profile以呈現事前審查之醫事機構基本資料 |
| [門診病歷-Composition OPD TWPAS](StructureDefinition-Composition-opd-twpas.md) | 此門診病歷-Composition OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-臨床文件架構（TW Core Composition） Profile以呈現免疫製劑事前審查 |
| [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md) | 此門診病歷-Encounter OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現免疫製劑事前審查中門診病歷之醫事機構、門診日期、科別、門診醫師 |
| [非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md) | 此非DICOM影像-Media TWPAS Profile說明本IG如何進一步定義臺灣核心-多媒體(TW Core Media) Profile以呈現事前審查中疾病資訊之影像報告的非DICOM影像 |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ClaimEncounter](StructureDefinition-extension-claim-encounter.md) | 就醫科別 |
| [ClaimResponseRequestor](StructureDefinition-extension-claimResponse-requestor.md) | 審查委員身分證號 |
| [RequestedService](StructureDefinition-extension-requestedService.md) | 事前審查品項 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HL7 TimingAbbreviation + NHI-健保事前審查-藥品使用頻率值集](ValueSet-medication-frequency-hl7-nhi.md) | HL7 TimingAbbreviation + NHI-健保事前審查-藥品使用頻率值集。為配合專案時程，使用暫時性代碼系統，日後將統一使用TW Core IG的臺灣健保署藥品使用頻率。代碼對應請參照[臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medication-frequency-tw.html) |
| [HL7-AcquisitionModality值集](ValueSet-dicom-cid-29-AcquisitionModality.md) | 原值集因總會工具問題無法正常顯示，故先自建值集。 |
| [HL7-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md) | HL7-非DICOM影像MimeType值集 |
| [LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集](ValueSet-pat-ast.md) | LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集 |
| [LOINC-健保事前審查-基因檢測代碼值集](ValueSet-gene-test-code.md) | LOINC-健保事前審查-基因檢測代碼值集 |
| [LOINC-健保事前審查-基因檢測檢體類型值集](ValueSet-specime-type.md) | LOINC-健保事前審查-基因檢測檢體類型值集 |
| [LOINC-健保事前審查-基因突變類型值集](ValueSet-dna-change-type.md) | LOINC-健保事前審查-基因突變類型值集 |
| [LOINC-健保事前審查-報告類型值集](ValueSet-report-type.md) | LOINC-健保事前審查-報告類型值集 |
| [LOINC-健保事前審查-影像報告值集](ValueSet-imaging-report.md) | LOINC-健保事前審查-影像報告值集 |
| [NCI-健保事前審查-FIGO癌症分期量表結果值集](ValueSet-cancer-stage-score.md) | NCI-健保事前審查-FIGO癌症分期量表結果值集 |
| [NHI-健保事前審查-個別醫令核定註記值集](ValueSet-nhi-approve-item-comment.md) | NHI-健保事前審查-個別醫令核定註記值集 |
| [NHI-健保事前審查-受理審查案件核定註記值集](ValueSet-nhi-approve-claim-comment.md) | NHI-健保事前審查-受理審查案件核定註記值集 |
| [NHI-健保事前審查-文件類型值集](ValueSet-nhi-pdf-type.md) | NHI-健保事前審查-文件類型值集 |
| [NHI-健保事前審查-案件受理狀態值集](ValueSet-nhi-acceptance-status.md) | NHI-健保事前審查-案件受理狀態值集 |
| [NHI-健保事前審查-治療後疾病狀態評估項目值集](ValueSet-nhi-tx-ast.md) | NHI-健保事前審查-治療後疾病狀態評估項目值集 |
| [NHI-健保事前審查-特約醫事機構值集](ValueSet-nhi-organization.md) | NHI-健保事前審查-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保事前審查-用藥品項值集](ValueSet-nhi-medication.md) | NHI-健保事前審查-用藥品項值集。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。 |
| [NHI-健保事前審查-用藥線別值集](ValueSet-nhi-line-of-therapy.md) | NHI-健保事前審查-用藥線別值集 |
| [NHI-健保事前審查-申報類別值集](ValueSet-nhi-apply-type.md) | NHI-健保事前審查-申報類別值集 |
| [NHI-健保事前審查-申請案件類別值集](ValueSet-nhi-tmhb-type.md) | NHI-健保事前審查-申請案件類別值集 |
| [NHI-健保事前審查-申請部位值集](ValueSet-nhi-apply-side.md) | NHI-健保事前審查-申請部位值集 |
| [NHI-健保事前審查-給付適應症值集](ValueSet-nhi-apply-reason.md) | NHI-健保事前審查-給付適應症值集 |
| [NHI-健保事前審查-續用註記值集](ValueSet-nhi-continuation-status.md) | NHI-健保事前審查-續用註記值集 |
| [NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集](ValueSet-nhi-medication-fda.md) | NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集。此值集所涵蓋代碼量較大會使載入頁面時間較長，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱。 |
| [NHI-健保事前審查-藥物類型值集](ValueSet-nhi-drug-category.md) | NHI-健保事前審查-藥物類型值集 |
| [NHI-健保事前審查-補充資訊類別值集](ValueSet-nhi-supporting-info-type.md) | NHI-健保事前審查-補充資訊類別值集 |
| [NHI-健保事前審查-身體部位值集](ValueSet-nhi-body-site.md) | NHI-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)。 |
| [NHI-健保事前審查-醫令類別值集](ValueSet-nhi-order-type.md) | NHI-健保事前審查-醫令類別值集 |
| [NHI-健保事前審查-醫療服務給付項目值集](ValueSet-nhi-medical-service-payment.md) | NHI-健保事前審查-醫療服務給付項目值集 |
| [NHI-臺灣健保署2014年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2014-image.md) | NHI-臺灣健保署2014年中文版ICD 10 PCS-影像報告值集 |
| [NHI-臺灣健保署2014年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2014-radiotherapy.md) | NHI-臺灣健保署2014年中文版ICD 10 PCS-放射/照光治療項目值集 |
| [NHI-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md) | NHI-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集 |
| [NHI-臺灣健保署2023年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2023-radiotherapy.md) | NHI-臺灣健保署2023年中文版ICD 10 PCS-放射/照光治療項目值集 |
| [SCT + NCI-健保事前審查-癌症分期量表項目值集](ValueSet-cancer-stage.md) | SCT + NCI-健保事前審查-癌症分期量表項目值集 |
| [SNOMED CT + 臺灣健保署-健保事前審查-給藥途徑值集](ValueSet-medication-path-sct-tw.md) | SNOMED CT + 臺灣健保署-健保事前審查-給藥途徑值集。 代碼對應請參照[臺灣健保署給藥途徑代碼對應SNOMED CT](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medication-path-tw.html)此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。 |
| [SNOMEDCT-健保事前審查-身體部位值集](ValueSet-sct-body-site.md) | SNOMEDCT-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)。 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [INCa-健保事前審查-基因突變類型](CodeSystem-inca-osiris.md) | INCa-健保事前審查-基因突變類型，資料所屬單位：Institut National du Cancer (INCa)，參照至：https://github.com/InstitutNationalduCancer/OSIRIS。 |
| [NCI 健保事前審查-Thesaurus](CodeSystem-nci-thesaurus.md) | NCI 健保事前審查-Thesaurus，參照至http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl代碼出版日期：2022-10-13。 |
| [NHI-健保事前審查-文件類型](CodeSystem-nhi-pdf-type.md) | 臺灣衛生福利部中央健康保險署「文件類型」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md) | 臺灣衛生福利部中央健康保險署「核定註記」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-案件受理狀態](CodeSystem-nhi-acceptance-status.md) | 臺灣衛生福利部中央健康保險署「案件受理狀態」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-治療後疾病狀態評估項目](CodeSystem-nhi-tx-ast.md) | 臺灣衛生福利部中央健康保險署「治療後疾病狀態評估項目」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-特約醫事機構](CodeSystem-organization-identifier-tw.md) | 臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保事前審查-用藥品項](CodeSystem-nhi-medication.md) | NHI-健保事前審查-用藥品項，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年4月查詢檔(帶走所有壓縮檔114.4.2更新)」。代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，相關代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。 |
| [NHI-健保事前審查-用藥線別](CodeSystem-nhi-line-of-therapy.md) | 臺灣衛生福利部中央健康保險署「用藥線別」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-申報類別](CodeSystem-nhi-apply-type.md) | 臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-申請案件類別](CodeSystem-nhi-tmhb-type.md) | 臺灣衛生福利部中央健康保險署「申請案件類別」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-申請部位](CodeSystem-nhi-apply-side.md) | 臺灣衛生福利部中央健康保險署「申請部位」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-病人狀態評估項目](CodeSystem-nhi-pat-ast.md) | 臺灣衛生福利部中央健康保險署「病人狀態評估項目」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-給付適應症](CodeSystem-nhi-apply-reason.md) | 臺灣衛生福利部中央健康保險署「給付適應症」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-續用註記](CodeSystem-nhi-continuation-status.md) | 臺灣衛生福利部中央健康保險署「續用註記」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md) | NHI-健保事前審查-藥品使用頻率，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「藥品使用頻率（2022/8/2版本）」。代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [NHI-健保事前審查-藥物類型](CodeSystem-nhi-drug-category.md) | 臺灣衛生福利部中央健康保險署「藥物類型」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-補充資訊類別](CodeSystem-nhi-supporting-info-type.md) | 臺灣衛生福利部中央健康保險署「補充資訊類別」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-身體部位](CodeSystem-nhi-body-site.md) | 臺灣衛生福利部中央健康保險署「身體部位」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |
| [NHI-健保事前審查-醫令類別](CodeSystem-nhi-order-type.md) | 臺灣衛生福利部中央健康保險署「醫令類別」代碼，代碼出版日期：2026-01-05；資料所屬單位：臺灣衛生福利部中央健康保險署。 |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [健保事前審查-臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md) | 此對應表為臺灣健保署身體部位代碼對應SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [健保事前審查-臺灣健保署醫療服務給付項目對應LOINC](ConceptMap-nhi-loinc.md) | 此對應表為臺灣健保署醫療服務給付項目對應LOINC，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [主觀描述(S)](Observation-obs-subjective.md) | 依據主觀描述-Observation Subjective TWPAS Profile呈現主觀描述之範例 |
| [事前審查-申復、有共病](Bundle-bun-3.md) | 依據癌藥事前審查-Bundle TWPAS Profile呈現癌藥事前審查之範例 |
| [事前審查-申復、有共病](Claim-cla-3.md) | 依據癌藥事前審查-Claim TWPAS Profile呈現事前審查之範例 |
| [事前審查-自主審查](Bundle-bun-self.md) | 依據癌藥事前審查-Bundle TWPAS Profile呈現癌藥事前審查之自主審查範例 |
| [事前審查-自主審查、多份影像報告（UUID）](Bundle-bun-uuid-example.md) | 依據癌藥事前審查-Bundle TWPAS Profile呈現癌藥事前審查之自主審查範例 |
| [事前審查-送核、套組檢驗、多事前審查癌藥品項](Bundle-bun-1.md) | 依據癌藥事前審查-Bundle TWPAS Profile呈現癌藥事前審查之範例 |
| [事前審查-送核、套組檢驗、多事前審查癌藥品項](Claim-cla-1.md) | 依據癌藥事前審查-Claim TWPAS Profile呈現事前審查之範例，含兩筆檢驗(查) |
| [事前審查品項-多用法](MedicationRequest-medReq-apply.md) | 依據事前審查品項-MedicationRequest Apply TWPAS Profile呈現事前審查品項之範例 |
| [事前審查品項-給付適應症特定代碼](MedicationRequest-medReq-apply-2.md) | 依據事前審查品項-MedicationRequest Apply TWPAS Profile呈現特定事前審查品項代碼之範例 |
| [事前審查回覆](Bundle-bun-response.md) | 依據事前審查回覆-Bundle Response TWPAS Profile呈現事前審查回覆之範例 |
| [事前審查回覆](ClaimResponse-claim-response-example.md) | 依據事前審查回覆-ClaimResponse TWPAS Profile呈現事前審查回覆之範例 |
| [健保事前審查計畫](Coverage-cov-min.md) | 依據健保事前審查計畫-Coverage TWPAS Profile呈現健保事前審查計畫之範例 |
| [免疫製劑事前審查](Bundle-bun-imm.md) | 依據免疫製劑事前審查-Bundle Immunologic Aagent TWPAS Profile呈現免疫製劑事前審查之範例 |
| [免疫製劑事前審查](Claim-cla-imm.md) | 依據免疫製劑事前審查-Claim Immunologic Aagent TWPAS Profile呈現免疫製劑事前審查 |
| [基因報告](DocumentReference-doc-gene-min.md) | 依據文件參照-DocumentReference TWPAS Profile呈現基因報告之範例 |
| [基因檢測機構](Organization-org-gene-example.md) | 依據基因檢測機構-Organization Genetic Testing TWPAS Profile呈現基因檢測機構之範例 |
| [基因檢測檢體](Specimen-spe-min.md) | 依據基因檢測檢體-Specimen TWPAS Profile呈現基因檢測檢體之範例 |
| [基因資訊](Observation-obs-diagnostic-min.md) | 依據基因資訊-Observation Diagnostic TWPAS Profile呈現基因資訊之範例 |
| [客觀描述(O)](Observation-obs-objective.md) | 依據客觀描述-Observation Objective TWPAS Profile呈現客觀描述之範例 |
| [就醫科別](Encounter-enc-min.md) | 依據就醫科別-Encounter TWPAS Profile呈現就醫科別之範例 |
| [影像](ImagingStudy-imaStu-min.md) | 依據DICOM影像-ImagingStudy TWPAS Profile呈現影像之範例 |
| [影像報告](DiagnosticReport-diaRep-ima-min.md) | 依據影像報告-DiagnosticReport Image TWPAS Profile呈現影像報告之範例 |
| [影像報告-使用LOINC代碼](DiagnosticReport-diaRep-ima-loinc.md) | 依據影像報告-DiagnosticReport Image TWPAS Profile呈現外院報告無法對應ICD-10-PCS之影像報告之範例 |
| [影像報告-使用LOINC代碼](DiagnosticReport-inline-2-diaRep-ima-loinc.md) | 依據影像報告-DiagnosticReport Image TWPAS Profile呈現外院報告無法對應ICD-10-PCS之影像報告之範例 |
| [影像報告-使用LOINC代碼](DiagnosticReport-inline-diaRep-ima-loinc.md) | 依據影像報告-DiagnosticReport Image TWPAS Profile呈現外院報告無法對應ICD-10-PCS之影像報告之範例 |
| [放射/照光治療](Procedure-pro-min.md) | 依據放射/照光治療-Procedure TWPAS Profile呈現放射/照光治療之範例 |
| [放射/照光治療總劑量](Substance-sub-min.md) | 依據放射/照光治療總劑量-Substance TWPAS Profile呈現放射/照光治療之範例 |
| [檢查報告](DiagnosticReport-diaRep-min.md) | 依據檢查報告-DiagnosticReport TWPAS Profile呈現檢查報告之範例 |
| [檢驗(查)附件](DocumentReference-doc-test-min.md) | 依據文件參照-DocumentReference TWPAS Profile呈現檢驗(查)附件之範例 |
| [檢驗檢查-單項](Observation-obs-lab-min.md) | 依據檢驗檢查-Observation Laboratory Result TWPAS Profile呈現單項檢驗檢查之範例 |
| [檢驗檢查-套組(全套血液檢查)](Observation-obs-lab-cbc.md) | 依據檢驗檢查-Observation Laboratory Result TWPAS Profile呈現套組檢驗檢查之範例 |
| [治療後疾病狀態評估](Observation-obs-tx-min.md) | 依據治療後疾病狀態評估-Observation Treatment Assessment TWPAS Profile呈現治療後疾病狀態評估之範例 |
| [治療計畫文件](DocumentReference-doc-careplan-min.md) | 依據文件參照-DocumentReference TWPAS Profile呈現治療計畫文件之範例 |
| [用藥品項](MedicationRequest-medReq-treat.md) | 依據用藥品項-MedicationRequest Treat TWPAS Profile呈現用藥品項之範例 |
| [病人狀態評估-CTCAE](Observation-obs-pat-ctcae.md) | 依據病人狀態評估-Observation Patient Assessment TWPAS Profile呈現病人狀態評估(CTCAE)之範例 |
| [病人狀態評估-NYHA](Observation-obs-pat-nyha.md) | 依據病人狀態評估-Observation Patient Assessment TWPAS Profile呈現病人狀態評估(NYHA)之範例 |
| [病人狀態評估-PDAI](Observation-obs-pat-pdai.md) | 依據病人狀態評估-Observation Patient Assessment TWPAS Profile呈現病人狀態評估(PDAI)之範例 |
| [病人狀態評估報告](DocumentReference-doc-patientAssessment-min.md) | 依據文件參照-DocumentReference TWPAS Profile呈現病人狀態評估報告之範例 |
| [病人資訊](Patient-pat-min.md) | 依據病人資訊-Patient TWPAS Profile呈現病人資訊之範例 |
| [病人資訊-使用居留證號](Patient-pat-resident.md) | 依據病人資訊-Patient TWPAS Profile呈現病人資訊之範例 |
| [病歷資料](DocumentReference-doc-medicalRecord-min.md) | 依據文件參照-DocumentReference TWPAS Profile呈現病歷資料之範例 |
| [癌症分期量表-CNS](Observation-obs-cancer-cns.md) | 依據癌症分期量表-Observation Cancer Stage TWPAS Profile呈現癌症分期量表WHO CNS之範例 |
| [癌症分期量表-FIGO](Observation-obs-cancer-figo.md) | 依據癌症分期量表-Observation Cancer Stage TWPAS Profile呈現癌症分期量表FIGO之範例 |
| [癌症分期量表-TNM](Observation-obs-cancer-tnm.md) | 依據癌症分期量表-Observation Cancer Stage TWPAS Profile呈現癌症分期量表之TNM範例 |
| [系統回應錯誤訊息](OperationOutcome-error-example.md) | 依據系統回應訊息-OperationOutcome TWPAS Profile呈現使用錯誤語法查詢系統時之回應範例 |
| [自主審查](ClaimResponse-self-assessment-example.md) | 依據自主審查-ClaimResponse Self Assessment TWPAS Profile呈現自主審查之範例 |
| [血型](Observation-obs-blood-group.md) | 依據血型-Observation Blood Group TWPAS Profile呈現血型之範例 |
| [衛生福利部中央健康保險署](Organization-org-nhi.md) | 依據臺灣核心-政府機構（TW Core Organization Government）Profile呈現衛生福利部中央健康保險署 |
| [計畫(P)](CarePlan-careplan-min.md) | 依據計畫-CarePlan TWPAS Profile呈現計畫之範例 |
| [診斷-主要疾病](Condition-con-diagnosis.md) | 依據診斷-Condition TWPAS Profile呈現診斷(主要疾病)之範例 |
| [診斷-共病](Condition-con-comorbidity.md) | 依據診斷-Condition TWPAS Profile呈現診斷(共病)之範例 |
| [評估(A)](ClinicalImpression-cliImp-min.md) | 依據評估-ClinicalImpression TWPAS Profile呈現評估之範例 |
| [過敏史](AllergyIntolerance-all-min.md) | 依據過敏史-AllergyIntolerance TWPAS Profile呈現過敏史之範例 |
| [醫事人員](Practitioner-pra-min.md) | 依據醫事人員-Practitioner TWPAS Profile呈現醫事人員之範例 |
| [醫事機構](Organization-org-hosp-example.md) | 依據機構-Organization TWPAS Profile呈現醫事機構之範例 |
| [門診病歷-Composition](Composition-opd.md) | 依據門診病歷-Composition OPD TWPAS Profile呈現門診病歷 |
| [門診病歷-Encounter](Encounter-enc-opd.md) | 依據門診病歷-Encounter OPD TWPAS Profile呈現門診病歷之範例 |
| [非DICOM影像](Media-med-min.md) | 依據非DICOM影像-Media TWPAS Profile呈現非DICOM影像之範例 |

