# HL7-非DICOM影像MimeType值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7-非DICOM影像MimeType值集**

## ValueSet: HL7-非DICOM影像MimeType值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/media-mimetypes | *Version*:1.1.0 |
| Active as of 2026-01-05 | *Computable Name*:MediaMimeTypes |

 
HL7-非DICOM影像MimeType值集 

 **References** 

* [非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "media-mimetypes",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/media-mimetypes",
  "version" : "1.1.0",
  "name" : "MediaMimeTypes",
  "title" : "HL7-非DICOM影像MimeType值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-05",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "HL7-非DICOM影像MimeType值集",
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:bcp:13",
        "concept" : [
          {
            "code" : "image/jpeg"
          },
          {
            "code" : "image/jpg"
          },
          {
            "code" : "image/bmp"
          },
          {
            "code" : "video/mpeg"
          },
          {
            "code" : "video/mpg"
          },
          {
            "code" : "video/mp4"
          }
        ]
      }
    ]
  }
}

```
