# ClaimEncounter - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ClaimEncounter**

## Extension: ClaimEncounter 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:ClaimEncounter |

就醫科別

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) and [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
* Examples for this Extension: [Bundle/bun-1](Bundle-bun-1.md), [Bundle/bun-3](Bundle-bun-3.md), [Bundle/bun-imm](Bundle-bun-imm.md), [Bundle/bun-self](Bundle-bun-self.md)...Show 4 more,[Bundle/bun-uuid-example](Bundle-bun-uuid-example.md),[Claim/cla-1](Claim-cla-1.md),[Claim/cla-3](Claim-cla-3.md)and[Claim/cla-imm](Claim-cla-imm.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/extension-claim-encounter)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-extension-claim-encounter.csv), [Excel](StructureDefinition-extension-claim-encounter.xlsx), [Schematron](StructureDefinition-extension-claim-encounter.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "extension-claim-encounter",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter",
  "version" : "1.1.0",
  "name" : "ClaimEncounter",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "就醫科別",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Claim"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "就醫科別"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
