# 放射/照光治療-Procedure TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **放射/照光治療-Procedure TWPAS**

## Resource Profile: 放射/照光治療-Procedure TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:ProcedureTWPAS |

 
此放射/照光治療-Procedure TWPAS Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現事前審查中治療資訊之「放射治療」及「照光治療」等相關資訊 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) and [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
* Examples for this Profile: [Procedure/pro-min](Procedure-pro-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Procedure-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure-twpas.csv), [Excel](StructureDefinition-Procedure-twpas.xlsx), [Schematron](StructureDefinition-Procedure-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas",
  "version" : "1.1.0",
  "name" : "ProcedureTWPAS",
  "title" : "放射/照光治療-Procedure TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此放射/照光治療-Procedure TWPAS Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現事前審查中治療資訊之「放射治療」及「照光治療」等相關資訊",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.meta",
        "path" : "Procedure.meta",
        "min" : 1
      },
      {
        "id" : "Procedure.meta.profile",
        "path" : "Procedure.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas"
      },
      {
        "id" : "Procedure.status",
        "path" : "Procedure.status",
        "short" : "放射/照光治療狀態"
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "short" : "放射/照光治療項目。ICD-10-PCS。",
        "binding" : {
          "strength" : "preferred",
          "description" : "最新參考代碼清單請參考[此檔案](https://www.nhi.gov.tw/ch/dl-75853-85b695304c2c447a94a55a3788019ccf-1.ods)。",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/icd-10-pcs-2023-radiotherapy"
        }
      },
      {
        "id" : "Procedure.code.coding",
        "path" : "Procedure.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2023Radiotherapy",
        "path" : "Procedure.code.coding",
        "sliceName" : "ICD10PCS2023Radiotherapy",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "最新參考代碼清單請參考[此檔案](https://www.nhi.gov.tw/ch/dl-75853-85b695304c2c447a94a55a3788019ccf-1.ods)。",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/icd-10-pcs-2023-radiotherapy"
        }
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2023Radiotherapy.system",
        "path" : "Procedure.code.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2023Radiotherapy.code",
        "path" : "Procedure.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2014Radiotherapy",
        "path" : "Procedure.code.coding",
        "sliceName" : "ICD10PCS2014Radiotherapy",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "最新參考代碼清單請參考[此檔案](https://www.nhi.gov.tw/ch/dl-75853-85b695304c2c447a94a55a3788019ccf-1.ods)。",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/icd-10-pcs-2014-radiotherapy"
        }
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2014Radiotherapy.system",
        "path" : "Procedure.code.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2014-tw",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code.coding:ICD10PCS2014Radiotherapy.code",
        "path" : "Procedure.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "short" : "放射/照光治療日期，YYYY-MM-DD。",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.usedReference",
        "path" : "Procedure.usedReference",
        "short" : "放射/照光治療總劑量，整個放射/照光治療療程之劑量。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
