# 醫事人員-Practitioner TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **醫事人員-Practitioner TWPAS**

## Resource Profile: 醫事人員-Practitioner TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:PractitionerTWPAS |

 
此醫事人員-Practitioner TWPAS Profile說明本IG如何進一步定義臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile以呈現事前審查之申請醫師、簽發影像報告醫師、簽發癌症分期報告醫師、檢查報告醫師、簽發檢驗(查)報告醫事人員、評估項目醫事人員及免疫製劑事前審查之門診醫師基本資料 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md), [門診病歷-Composition OPD TWPAS](StructureDefinition-Composition-opd-twpas.md), [影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md)...Show 5 more,[檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md),[門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md),[癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md),[檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md)and[病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)
* Examples for this Profile: [Practitioner/pra-min](Practitioner-pra-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Practitioner-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Practitioner-twpas.csv), [Excel](StructureDefinition-Practitioner-twpas.xlsx), [Schematron](StructureDefinition-Practitioner-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Practitioner-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas",
  "version" : "1.1.0",
  "name" : "PractitionerTWPAS",
  "title" : "醫事人員-Practitioner TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此醫事人員-Practitioner TWPAS Profile說明本IG如何進一步定義臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile以呈現事前審查之申請醫師、簽發影像報告醫師、簽發癌症分期報告醫師、檢查報告醫師、簽發檢驗(查)報告醫事人員、評估項目醫事人員及免疫製劑事前審查之門診醫師基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/emr/StructureDefinition/TWCorePractitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner.meta",
        "path" : "Practitioner.meta",
        "min" : 1
      },
      {
        "id" : "Practitioner.meta.profile",
        "path" : "Practitioner.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type.coding.code"
            },
            {
              "type" : "value",
              "path" : "type.coding.system"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "2"
      },
      {
        "id" : "Practitioner.identifier:idCardNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "idCardNumber",
        "short" : "醫師身分證號"
      },
      {
        "id" : "Practitioner.identifier:idCardNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "身分證號的命名空間（namespace），請固定填「http://www.moi.gov.tw」。"
      },
      {
        "id" : "Practitioner.identifier:passportNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "passportNumber",
        "max" : "0"
      },
      {
        "id" : "Practitioner.identifier:residentNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "residentNumber",
        "short" : "醫師居留證號碼"
      },
      {
        "id" : "Practitioner.identifier:residentNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "居留證號碼的命名空間（namespace），請固定填「http://www.immigration.gov.tw」。"
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber",
        "path" : "Practitioner.identifier",
        "sliceName" : "medicalLicenseNumber",
        "short" : "醫師證號"
      },
      {
        "id" : "Practitioner.identifier:medicalLicenseNumber.system",
        "path" : "Practitioner.identifier.system",
        "short" : "醫師證號的命名空間（namespace），請固定填「https://dep.mohw.gov.tw/DOMA」。",
        "patternUri" : "https://dep.mohw.gov.tw/DOMA"
      }
    ]
  }
}

```
