# 門診病歷-Encounter OPD TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **門診病歷-Encounter OPD TWPAS**

## Resource Profile: 門診病歷-Encounter OPD TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:EncounterOpdTWPAS |

 
此門診病歷-Encounter OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現免疫製劑事前審查中門診病歷之醫事機構、門診日期、科別、門診醫師 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md), [評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md), [門診病歷-Composition OPD TWPAS](StructureDefinition-Composition-opd-twpas.md), [客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md) and [主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md)
* Examples for this Profile: [Encounter/enc-opd](Encounter-enc-opd.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Encounter-opd-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Encounter-opd-twpas.csv), [Excel](StructureDefinition-Encounter-opd-twpas.xlsx), [Schematron](StructureDefinition-Encounter-opd-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter-opd-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas",
  "version" : "1.1.0",
  "name" : "EncounterOpdTWPAS",
  "title" : "門診病歷-Encounter OPD TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此門診病歷-Encounter OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-就醫事件(TW Core Encounter) Profile以呈現免疫製劑事前審查中門診病歷之醫事機構、門診日期、科別、門診醫師",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "constraint" : [
          {
            "key" : "rank-1",
            "severity" : "error",
            "human" : "diagnosis.rank一定會有一個「1」，且只能出現一次。",
            "expression" : "diagnosis.where(rank = 1).count() = 1",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
          }
        ]
      },
      {
        "id" : "Encounter.meta",
        "path" : "Encounter.meta",
        "min" : 1
      },
      {
        "id" : "Encounter.meta.profile",
        "path" : "Encounter.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "就醫現況。【因FHIR設計而需必填】",
        "patternCode" : "finished"
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "short" : "就醫分類。【因FHIR設計而需必填】",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB"
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "科別，完整代碼對應表請參照就醫科別對應表。",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "description" : "完整代碼對應表請參照[就醫科別對應表](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ValueSet-medical-department-sct-tw.html#%E5%B0%B1%E9%86%AB%E7%A7%91%E5%88%A5%E5%B0%8D%E6%87%89%E8%A1%A8)。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw"
        }
      },
      {
        "id" : "Encounter.serviceType.coding",
        "path" : "Encounter.serviceType.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.serviceType.coding.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalDepartmentSCT",
        "short" : "對應至SNOMED CT之就醫科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalConsultationDepartment",
        "short" : "無法對應至SNOMED CT之臺灣健保署就醫科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalTreatmentDepartment",
        "short" : "無法對應至SNOMED CT之臺灣健保署診療科別"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment.code",
        "path" : "Encounter.serviceType.coding.code",
        "min" : 1
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "short" : "門診醫師",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "min" : 1
      },
      {
        "id" : "Encounter.period.start",
        "path" : "Encounter.period.start",
        "short" : "門診日期，YYYY-MM-DD，西元年月日。",
        "min" : 1
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "min" : 1
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "short" : "診斷",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis.rank",
        "path" : "Encounter.diagnosis.rank",
        "short" : "rank=1時為主要疾病；rank>=2代表共病。",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "short" : "醫事機構代碼，必須存在於醫事機構基本資料檔內。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
