# 門診病歷-Composition OPD TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **門診病歷-Composition OPD TWPAS**

## Resource Profile: 門診病歷-Composition OPD TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Composition-opd-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:CompositionOpdTWPAS |

 
此門診病歷-Composition OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-臨床文件架構（TW Core Composition） Profile以呈現免疫製劑事前審查 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) and [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
* Examples for this Profile: [Composition/opd](Composition-opd.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Composition-opd-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Composition-opd-twpas.csv), [Excel](StructureDefinition-Composition-opd-twpas.xlsx), [Schematron](StructureDefinition-Composition-opd-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Composition-opd-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Composition-opd-twpas",
  "version" : "1.1.0",
  "name" : "CompositionOpdTWPAS",
  "title" : "門診病歷-Composition OPD TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此門診病歷-Composition OPD TWPAS Profile說明本IG如何進一步定義臺灣核心-臨床文件架構（TW Core Composition） Profile以呈現免疫製劑事前審查",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition.meta",
        "path" : "Composition.meta",
        "min" : 1
      },
      {
        "id" : "Composition.meta.profile",
        "path" : "Composition.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Composition-opd-twpas"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "patternCode" : "final"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34108-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas",
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code.coding.code"
            }
          ],
          "rules" : "closed"
        },
        "min" : 4
      },
      {
        "id" : "Composition.section:subjective",
        "path" : "Composition.section",
        "sliceName" : "subjective",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:subjective.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section:subjective.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:subjective.code.coding.system",
        "path" : "Composition.section.code.coding.system",
        "min" : 1,
        "patternUri" : "http://loinc.org"
      },
      {
        "id" : "Composition.section:subjective.code.coding.code",
        "path" : "Composition.section.code.coding.code",
        "min" : 1,
        "patternCode" : "10154-3"
      },
      {
        "id" : "Composition.section:subjective.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-subjective-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:objective",
        "path" : "Composition.section",
        "sliceName" : "objective",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:objective.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section:objective.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:objective.code.coding.system",
        "path" : "Composition.section.code.coding.system",
        "min" : 1,
        "patternUri" : "http://loinc.org"
      },
      {
        "id" : "Composition.section:objective.code.coding.code",
        "path" : "Composition.section.code.coding.code",
        "min" : 1,
        "patternCode" : "61149-1"
      },
      {
        "id" : "Composition.section:objective.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-objective-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:assessment",
        "path" : "Composition.section",
        "sliceName" : "assessment",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessment.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section:assessment.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:assessment.code.coding.system",
        "path" : "Composition.section.code.coding.system",
        "min" : 1,
        "patternUri" : "http://loinc.org"
      },
      {
        "id" : "Composition.section:assessment.code.coding.code",
        "path" : "Composition.section.code.coding.code",
        "min" : 1,
        "patternCode" : "51848-0"
      },
      {
        "id" : "Composition.section:assessment.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:plan",
        "path" : "Composition.section",
        "sliceName" : "plan",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:plan.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section:plan.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:plan.code.coding.system",
        "path" : "Composition.section.code.coding.system",
        "min" : 1,
        "patternUri" : "http://loinc.org"
      },
      {
        "id" : "Composition.section:plan.code.coding.code",
        "path" : "Composition.section.code.coding.code",
        "min" : 1,
        "patternCode" : "18776-5"
      },
      {
        "id" : "Composition.section:plan.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
