# 事前審查回覆-ClaimResponse TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查回覆-ClaimResponse TWPAS**

## Resource Profile: 事前審查回覆-ClaimResponse TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas | *Version*:1.1.0 |
| Active as of 2025-12-29 | *Computable Name*:ClaimResponseTWPAS |

 
此事前審查回覆-ClaimResponse TWPAS Profile說明本IG如何進一步定義FHIR的ClaimResponse Resource以呈現事前審查回覆之內容 

## 案件核定結果係綜合該申請案件醫令審核結果做為判斷依據，規則說明如下：

1. 所有醫令皆核定為`1-同意`，則該案件審查結果為`1-同意`。
1. 非所有醫令核定為`1-同意`，其中有一醫令核定為`1-同意`或`3-部分同意`，則該案件審查結果為`3-部分同意`。
1. 所有醫令皆核定為`2-不同意`或`6-不予同意`，則該案件審查結果為`2-不同意`。
1. 排除上述1、2、3規則，案件中有一醫令核定為補件，則該案件審查結果為`4-補件`。
1. 排除上述1、2、3規則，案件中有一醫令核定為退件，則該案件審查結果為`5-退件`。
1. 若核定註記為`7-改核:如審查核定意見`，則判斷申請量與審查結果數量，若核定同總申請量，該醫令核定註記視為
* 同意;若核定量為0(空值視同0)，該醫令核定註記視為`2-不同意`;核定量小於總申請量，該醫令核定註記視為`3-部分同意`。並綜合該申請案件醫令審核結果，作為該案件審查結果(同上述五點)。

**Usages:**

* Use this Profile: [事前審查回覆-Bundle Response TWPAS](StructureDefinition-Bundle-response-twpas.md)
* Examples for this Profile: [ClaimResponse/claim-response-example](ClaimResponse-claim-response-example.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/ClaimResponse-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ClaimResponse-twpas.csv), [Excel](StructureDefinition-ClaimResponse-twpas.xlsx), [Schematron](StructureDefinition-ClaimResponse-twpas.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWPAS支援的RESTful互動功能的完整清單，請參閱[TWPAS Server能力聲明](CapabilityStatement-CapabilityStatementTWPASServer.md)。

#### 建議應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`adjudication-reason`](SearchParameter-ClaimResponse-adjudication-reason.md)**查詢所有ClaimResponse：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ClaimResponse?adjudication-reason=[code]`例子：
(1) GET [base]/ClaimResponse?adjudication-reason=1
1. **必須（SHALL）**支援透過查詢參數**[`request`](SearchParameter-ClaimResponse-request.md)**.**[`patient`](SearchParameter-Claim-patient.md)**.**[`name`](SearchParameter-Patient-name.md)**查詢所有ClaimResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/ClaimResponse?request.patient.name=[姓名]`例子：
(1) GET [base]/ClaimResponse?request.patient.name=王大明
1. **必須（SHALL）**支援透過查詢參數**[`request`](SearchParameter-ClaimResponse-request.md)**.**[`patient`](SearchParameter-Claim-patient.md)**.**[`identifier`](SearchParameter-Patient-identifier.md)**查詢所有ClaimResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ClaimResponse?request.patient.identifier=[code]`例子：
(1) GET [base]/ClaimResponse?request.patient.identifier=A123456789
1. **必須（SHALL）**支援透過查詢參數**[`request`](SearchParameter-ClaimResponse-request.md)**.**[`identifier`](SearchParameter-Claim-identifier.md)**查詢所有ClaimResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ClaimResponse?request.identifier=[code]`例子：
(1) GET [base]/ClaimResponse?request.identifier=20240831010109051701
1. **必須（SHALL）**支援透過查詢參數**[`request`](SearchParameter-ClaimResponse-request.md)**.**[`func-type`](SearchParameter-Claim-func-type.md)**.**[`service-type`](SearchParameter-Encounter-service-type.md)**查詢所有ClaimResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ClaimResponse?request.func-type.service-type={system|}[code]`例子：
(1) GET [base]/ClaimResponse?request.func-type.service-type=AJ
(2) GET [base]/ClaimResponse?request.func-type.service-type=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw|AJ
1. **必須（SHALL）**支援透過查詢參數**[`created`](SearchParameter-ClaimResponse-created.md)**及**[`disposition`](SearchParameter-ClaimResponse-disposition.md)**查詢所有ClaimResponse：
([如何透過date查詢](https://hl7.org/fhir/R4/search.html#date))
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/ClaimResponse?created={gt|lt|ge|le}[date]{&created={gt|lt|ge|le}[date]}&disposition=[已受理|審畢結果]`例子：
(1) GET [base]/ClaimResponse?created=gt2024-08-01&created=lt2024-08-24&disposition=審畢結果



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ClaimResponse-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas",
  "version" : "1.1.0",
  "name" : "ClaimResponseTWPAS",
  "title" : "事前審查回覆-ClaimResponse TWPAS",
  "status" : "active",
  "date" : "2025-12-29T08:44:19+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此事前審查回覆-ClaimResponse TWPAS Profile說明本IG如何進一步定義FHIR的ClaimResponse Resource以呈現事前審查回覆之內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClaimResponse",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClaimResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClaimResponse.meta",
        "path" : "ClaimResponse.meta",
        "min" : 1
      },
      {
        "id" : "ClaimResponse.meta.profile",
        "path" : "ClaimResponse.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas"
      },
      {
        "id" : "ClaimResponse.status",
        "path" : "ClaimResponse.status",
        "patternCode" : "active"
      },
      {
        "id" : "ClaimResponse.type",
        "path" : "ClaimResponse.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "institutional"
            }
          ]
        }
      },
      {
        "id" : "ClaimResponse.use",
        "path" : "ClaimResponse.use",
        "patternCode" : "preauthorization"
      },
      {
        "id" : "ClaimResponse.patient",
        "path" : "ClaimResponse.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "ClaimResponse.created",
        "path" : "ClaimResponse.created",
        "short" : "核定日期或受理日期，即為案件受理狀態(disposition)之異動日期，依據其狀態不同而有不同日期，例如案件受理狀態為已受理，此日期則為受理日期；若為審畢結果則為核定日期。",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.insurer",
        "path" : "ClaimResponse.insurer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ClaimResponse.request",
        "path" : "ClaimResponse.request",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-twpas"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.disposition",
        "path" : "ClaimResponse.disposition",
        "short" : "案件受理狀態。待處理 | 處理中 | 處理中(等待附件檔) | 處理中(檔案檢核中) | 處理中(等待檢查申報資料) | 資料檢核失敗 | 檔案傳送失敗 | 附件檔轉檔失敗 | 影像檔轉檔失敗 | 電子病歷檔轉檔失敗 | 申請檔案檢核失敗 | 申請檔案未備齊 | 已受理 | 審查中 | 審畢結果",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-acceptance-status"
        }
      },
      {
        "id" : "ClaimResponse.item.adjudication.category",
        "path" : "ClaimResponse.item.adjudication.category",
        "short" : "【因FHIR設計而需必填】"
      },
      {
        "id" : "ClaimResponse.item.adjudication.category.coding.system",
        "path" : "ClaimResponse.item.adjudication.category.coding.system",
        "example" : [
          {
            "label" : "General",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/adjudication"
          }
        ]
      },
      {
        "id" : "ClaimResponse.item.adjudication.category.coding.code",
        "path" : "ClaimResponse.item.adjudication.category.coding.code",
        "example" : [
          {
            "label" : "General",
            "valueString" : "submitted"
          }
        ]
      },
      {
        "id" : "ClaimResponse.item.adjudication.reason",
        "path" : "ClaimResponse.item.adjudication.reason",
        "short" : "受理審查案件核定註記。1:同意 | 2:不予同意 | 3:部份同意 | 4:補件 | 5:退件",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-approve-claim-comment"
        }
      },
      {
        "id" : "ClaimResponse.item.adjudication.value",
        "path" : "ClaimResponse.item.adjudication.value",
        "short" : "核定數量。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.detail.detailSequence",
        "path" : "ClaimResponse.item.detail.detailSequence",
        "short" : "請填寫對應的Claim.item.sequence"
      },
      {
        "id" : "ClaimResponse.item.detail.adjudication",
        "path" : "ClaimResponse.item.detail.adjudication",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ClaimResponse.item.detail.adjudication.category",
        "path" : "ClaimResponse.item.detail.adjudication.category",
        "short" : "【因FHIR設計而需必填】"
      },
      {
        "id" : "ClaimResponse.item.detail.adjudication.category.coding.system",
        "path" : "ClaimResponse.item.detail.adjudication.category.coding.system",
        "example" : [
          {
            "label" : "General",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/adjudication"
          }
        ]
      },
      {
        "id" : "ClaimResponse.item.detail.adjudication.category.coding.code",
        "path" : "ClaimResponse.item.detail.adjudication.category.coding.code",
        "example" : [
          {
            "label" : "General",
            "valueString" : "submitted"
          }
        ]
      },
      {
        "id" : "ClaimResponse.item.detail.adjudication.reason",
        "path" : "ClaimResponse.item.detail.adjudication.reason",
        "short" : "個別醫令核定註記。0:審核中 | 1:同意 | 2:不予同意 | 3:部份同意 | 4:補件 | 5:退件 | 6:不予同意:對應手術亦不支付 | 7:改核:如審查核定意見",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-approve-item-comment"
        }
      }
    ]
  }
}

```
