# 事前審查品項-給付適應症特定代碼 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查品項-給付適應症特定代碼**

## Example MedicationRequest: 事前審查品項-給付適應症特定代碼

Profile: [事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md)

**狀態**：On Hold

**目的**：Plan

**事前審查品項代碼**：Herzuma Inj. 440mg ([NHI-健保事前審查-用藥品項值集](CodeSystem-nhi-medication.md)#KC011162B5)

**病人**：[Patient/pat-min](Patient-pat-min.md) "王大明"

**事前審查藥物預定處方起始日期**：2024-03-11

**事前審查藥物預定處方終止日期**：2024-07-28

**事前審查藥品使用頻率及服用時間**：每4週的第1天、每4週的第2天、每4週的第3天、每4週的第4天、每4週的第5天、飯前1小時使用([HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-hl7-nhi.md)#Q4WD1、#Q4WD2、#Q4WD3、#Q4WD4、#Q4WD5、#AC1H)

**事前審查藥品每次處方劑量**：200 mg/m2

**事前審查藥品療程／週期數**：1

**給藥途徑／作用部位**：Oral use ([SNOMED CT + 臺灣健保署給藥途徑值集](http://snomed.info/sct/)#26643006)



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "medReq-apply-2",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
    ]
  },
  "status" : "on-hold",
  "intent" : "plan",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
        "code" : "KC011162B5"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-min"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2024-03-11",
            "end" : "2024-07-28"
          },
          "count" : 1
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "Q4WD1"
            },
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "Q4WD2"
            },
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "Q4WD3"
            },
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "Q4WD4"
            },
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "Q4WD5"
            },
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/medication-frequency-nhi-tw",
              "code" : "AC1H"
            }
          ]
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 200,
            "system" : "http://unitsofmeasure.org",
            "code" : "mg/m2"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "quantity" : {
      "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm"
    }
  }
}

```
