# 自主審查 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **自主審查**

## Example ClaimResponse: 自主審查

Profile: [事前審查結果-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md)

**狀態**：Active

**審查委員身分證號**：F123456789（http://www.moi.gov.tw）、A123456789（http://www.moi.gov.tw）

**類型**：Institutional

**用途**：Preauthorization

**病人**：[Patient/pat-min](Patient-pat-min.md)

**核定日期**：2024-07-30

**保險商**：[Organization 衛生福利部中央健康保險署](Organization-org-nhi.md)

**處置狀態**：Processing Complete

> **item****itemSequence**：1

### Adjudications

| | | | |
| :--- | :--- | :--- | :--- |
| - | **類型** | **核定註記** | **審查結果數量** |
| * | Submitted Amount | 同意備查 | 5 |




## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "self-assessment-example",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-self-assessment-twpas"
    ]
  },
  "extension" : [
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claimResponse-requestor",
      "valueIdentifier" : {
        "system" : "http://www.moi.gov.tw",
        "value" : "F123456789"
      }
    },
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claimResponse-requestor",
      "valueIdentifier" : {
        "system" : "http://www.moi.gov.tw",
        "value" : "A123456789"
      }
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/pat-min"
  },
  "created" : "2024-07-30",
  "insurer" : {
    "reference" : "Organization/org-nhi"
  },
  "outcome" : "complete",
  "item" : [
    {
      "itemSequence" : 1,
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                "code" : "submitted"
              }
            ]
          },
          "reason" : {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-approve-comment",
                "code" : "1"
              }
            ]
          },
          "value" : 5
        }
      ]
    }
  ]
}

```
