# 事前審查回覆 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查回覆**

## Example ClaimResponse: 事前審查回覆

Profile: [事前審查結果-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md)

**狀態**：Active

**類型**：Institutional

**用途**：Preauthorization

**病人**：[Patient/pat-min](Patient-pat-min.md)

**核定日期**：2024-07-30

**關聯的事前審查**：[Claim/cla-1](Claim-cla-1.md)

**保險商**：[Organization 衛生福利部中央健康保險署](Organization-org-nhi.md)

**處置狀態**：Processing Complete

**案件受理狀態**：審畢結果

> **item****itemSequence**：1

### 受理審查案件核定註記

| | | | |
| :--- | :--- | :--- | :--- |
| - | **類型** | **受理審查案件核定註記** | **核定數量** |
| * | Submitted Amount | 同意備查([NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md)#1)) | 2 |

### 個別醫令核定註記

| | | | |
| :--- | :--- | :--- | :--- |
| - | **類型** | **Claim.item.sequence** | **個別醫令核定註記** |
| * | Submitted Amount | 1 | 同意備查([NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md)#1)) |
| * | Submitted Amount | 2 | 同意備查([NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md)#1)) |




## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "claim-response-example",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas"
    ]
  },
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/pat-min"
  },
  "created" : "2024-07-30",
  "insurer" : {
    "reference" : "Organization/org-nhi"
  },
  "request" : {
    "reference" : "Claim/cla-1"
  },
  "outcome" : "complete",
  "disposition" : "審畢結果",
  "item" : [
    {
      "itemSequence" : 1,
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                "code" : "submitted"
              }
            ]
          },
          "reason" : {
            "coding" : [
              {
                "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-approve-comment",
                "code" : "1"
              }
            ]
          },
          "value" : 2
        }
      ],
      "detail" : [
        {
          "detailSequence" : 1,
          "adjudication" : [
            {
              "category" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                    "code" : "submitted"
                  }
                ]
              },
              "reason" : {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-approve-comment",
                    "code" : "1"
                  }
                ]
              }
            }
          ]
        },
        {
          "detailSequence" : 2,
          "adjudication" : [
            {
              "category" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                    "code" : "submitted"
                  }
                ]
              },
              "reason" : {
                "coding" : [
                  {
                    "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-approve-comment",
                    "code" : "1"
                  }
                ]
              }
            }
          ]
        }
      ]
    }
  ]
}

```
