# 專門術語 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* **專門術語**

## 專門術語

以下為本IG必須及可能需使用的所有專門術語(terminology)。

### 值集(Value Sets)

[NCI-健保事前審查-FIGO癌症分期量表結果值集](ValueSet-cancer-stage-score.md)

NCI-健保事前審查-FIGO癌症分期量表結果值集

[SCT + NCI-健保事前審查-癌症分期量表項目值集](ValueSet-cancer-stage.md)

SCT + NCI-健保事前審查-癌症分期量表項目值集

[HL7-AcquisitionModality值集](ValueSet-dicom-cid-29-AcquisitionModality.md)

原值集因總會工具問題無法正常顯示，故先自建值集。

[LOINC-健保事前審查-基因突變類型值集](ValueSet-dna-change-type.md)

LOINC-健保事前審查-基因突變類型值集

[LOINC-健保事前審查-基因檢測代碼值集](ValueSet-gene-test-code.md)

LOINC-健保事前審查-基因檢測代碼值集

[NHI-臺灣健保署2014年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2014-image.md)

NHI-臺灣健保署2014年中文版ICD 10 PCS-影像報告值集

[NHI-臺灣健保署2014年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2014-radiotherapy.md)

NHI-臺灣健保署2014年中文版ICD 10 PCS-放射/照光治療項目值集

[NHI-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md)

NHI-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集

[NHI-臺灣健保署2023年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2023-radiotherapy.md)

NHI-臺灣健保署2023年中文版ICD 10 PCS-放射/照光治療項目值集

[LOINC-健保事前審查-影像報告值集](ValueSet-imaging-report.md)

LOINC-健保事前審查-影像報告值集

[HL7-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md)

HL7-非DICOM影像MimeType值集

[HL7 TimingAbbreviation + NHI-健保事前審查-藥品使用頻率值集](ValueSet-medication-frequency-hl7-nhi.md)

HL7 TimingAbbreviation + NHI-健保事前審查-藥品使用頻率值集。為配合專案時程，使用暫時性代碼系統，日後將統一使用TW Core IG的臺灣健保署藥品使用頻率。
 代碼對應請參照[臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medication-frequency-tw.html)

[SNOMED CT + 臺灣健保署-健保事前審查-給藥途徑值集](ValueSet-medication-path-sct-tw.md)

SNOMED CT + 臺灣健保署-健保事前審查-給藥途徑值集。 代碼對應請參照[臺灣健保署給藥途徑代碼對應SNOMED CT](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medication-path-tw.html)

此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。

[NHI-健保事前審查-案件受理狀態值集](ValueSet-nhi-acceptance-status.md)

NHI-健保事前審查-案件受理狀態值集

[NHI-健保事前審查-給付適應症值集](ValueSet-nhi-apply-reason.md)

NHI-健保事前審查-給付適應症值集

[NHI-健保事前審查-申請部位值集](ValueSet-nhi-apply-side.md)

NHI-健保事前審查-申請部位值集

[NHI-健保事前審查-申報類別值集](ValueSet-nhi-apply-type.md)

NHI-健保事前審查-申報類別值集

[NHI-健保事前審查-受理審查案件核定註記值集](ValueSet-nhi-approve-claim-comment.md)

NHI-健保事前審查-受理審查案件核定註記值集

[NHI-健保事前審查-個別醫令核定註記值集](ValueSet-nhi-approve-item-comment.md)

NHI-健保事前審查-個別醫令核定註記值集

[NHI-健保事前審查-身體部位值集](ValueSet-nhi-body-site.md)

NHI-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)。

[NHI-健保事前審查-續用註記值集](ValueSet-nhi-continuation-status.md)

NHI-健保事前審查-續用註記值集

[NHI-健保事前審查-藥物類型值集](ValueSet-nhi-drug-category.md)

NHI-健保事前審查-藥物類型值集

[NHI-健保事前審查-用藥線別值集](ValueSet-nhi-line-of-therapy.md)

NHI-健保事前審查-用藥線別值集

[NHI-健保事前審查-醫療服務給付項目值集](ValueSet-nhi-medical-service-payment.md)

NHI-健保事前審查-醫療服務給付項目值集

[NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集](ValueSet-nhi-medication-fda.md)

NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集。
 此值集所涵蓋代碼量較大會使載入頁面時間較長，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱。

[NHI-健保事前審查-用藥品項值集](ValueSet-nhi-medication.md)

NHI-健保事前審查-用藥品項值集。
 此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。

[NHI-健保事前審查-醫令類別值集](ValueSet-nhi-order-type.md)

NHI-健保事前審查-醫令類別值集

[NHI-健保事前審查-特約醫事機構值集](ValueSet-nhi-organization.md)

NHI-健保事前審查-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)

代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

[NHI-健保事前審查-文件類型值集](ValueSet-nhi-pdf-type.md)

NHI-健保事前審查-文件類型值集

[NHI-健保事前審查-補充資訊類別值集](ValueSet-nhi-supporting-info-type.md)

NHI-健保事前審查-補充資訊類別值集

[NHI-健保事前審查-申請案件類別值集](ValueSet-nhi-tmhb-type.md)

NHI-健保事前審查-申請案件類別值集

[NHI-健保事前審查-治療後疾病狀態評估項目值集](ValueSet-nhi-tx-ast.md)

NHI-健保事前審查-治療後疾病狀態評估項目值集

[LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集](ValueSet-pat-ast.md)

LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集

[LOINC-健保事前審查-報告類型值集](ValueSet-report-type.md)

LOINC-健保事前審查-報告類型值集

[SNOMEDCT-健保事前審查-身體部位值集](ValueSet-sct-body-site.md)

SNOMEDCT-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)。

[LOINC-健保事前審查-基因檢測檢體類型值集](ValueSet-specime-type.md)

LOINC-健保事前審查-基因檢測檢體類型值集

### 代碼系統(Code Systems)

[INCa-健保事前審查-基因突變類型](CodeSystem-inca-osiris.md)

INCa-健保事前審查-基因突變類型，資料所屬單位：Institut National du Cancer (INCa)，參照至：https://github.com/InstitutNationalduCancer/OSIRIS。

[NHI-健保事前審查-藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md)

NHI-健保事前審查-藥品使用頻率，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「藥品使用頻率（2022/8/2版本）」。

代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

[NCI 健保事前審查-Thesaurus](CodeSystem-nci-thesaurus.md)

NCI 健保事前審查-Thesaurus，參照至http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl
 代碼出版日期：2022-10-13。

[NHI-健保事前審查-案件受理狀態](CodeSystem-nhi-acceptance-status.md)

臺灣衛生福利部中央健康保險署「案件受理狀態」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-給付適應症](CodeSystem-nhi-apply-reason.md)

臺灣衛生福利部中央健康保險署「給付適應症」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-申請部位](CodeSystem-nhi-apply-side.md)

臺灣衛生福利部中央健康保險署「申請部位」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-申報類別](CodeSystem-nhi-apply-type.md)

臺灣衛生福利部中央健康保險署「申報類別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md)

臺灣衛生福利部中央健康保險署「核定註記」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-身體部位](CodeSystem-nhi-body-site.md)

臺灣衛生福利部中央健康保險署「身體部位」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-續用註記](CodeSystem-nhi-continuation-status.md)

臺灣衛生福利部中央健康保險署「續用註記」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-藥物類型](CodeSystem-nhi-drug-category.md)

臺灣衛生福利部中央健康保險署「藥物類型」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-用藥線別](CodeSystem-nhi-line-of-therapy.md)

臺灣衛生福利部中央健康保險署「用藥線別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-用藥品項](CodeSystem-nhi-medication.md)

NHI-健保事前審查-用藥品項，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年4月查詢檔(帶走所有壓縮檔114.4.2更新)」。

代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，相關代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。

[NHI-健保事前審查-醫令類別](CodeSystem-nhi-order-type.md)

臺灣衛生福利部中央健康保險署「醫令類別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-病人狀態評估項目](CodeSystem-nhi-pat-ast.md)

臺灣衛生福利部中央健康保險署「病人狀態評估項目」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-文件類型](CodeSystem-nhi-pdf-type.md)

臺灣衛生福利部中央健康保險署「文件類型」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-補充資訊類別](CodeSystem-nhi-supporting-info-type.md)

臺灣衛生福利部中央健康保險署「補充資訊類別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-申請案件類別](CodeSystem-nhi-tmhb-type.md)

臺灣衛生福利部中央健康保險署「申請案件類別」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-治療後疾病狀態評估項目](CodeSystem-nhi-tx-ast.md)

臺灣衛生福利部中央健康保險署「治療後疾病狀態評估項目」代碼，代碼出版日期：2025-10-01；資料所屬單位：臺灣衛生福利部中央健康保險署。

[NHI-健保事前審查-特約醫事機構](CodeSystem-organization-identifier-tw.md)

臺灣衛生福利部中央健康保險署「特約醫事機構」代碼，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)

代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。

**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**

### 概念對應(Concept Maps)

[臺灣健保署醫療服務給付項目對應LOINC](ConceptMap-nhi-loinc.md)

此對應表為臺灣健保署醫療服務給付項目對應LOINC，供實作者於撰寫程式以自動化對應或轉代碼時使用。

[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)

此對應表為臺灣健保署身體部位代碼對應SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。

[臺灣健保署就醫科別代碼對應SNOMED CT](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medical-consultation-department-nhi-tw.html)

[臺灣健保署診療科別代碼對應SNOMED CT](https://build.fhir.org/ig/MOHW-TWCoreIG/cctwFHIRterm/ConceptMap-medical-treatment-department-nhi-tw.html)

