# tw.gov.mohw.nhi.pas#1.1.0: 臺灣健保事前審查實作指引

## Pages

* [應用說明](index.md)
* [範例](examples.md)
* [視覺化邏輯模型:癌藥事前審查](vision-cancer.md)
* [FHIR Profiles及Extensions](profiles-and-extensions.md)
* [專門術語](terminologies.md)
* [安全性](security.md)
* [查詢參數](searchparameters.md)
* [視覺化邏輯模型:免疫製劑事前審查](vision-imm.md)
* [驗證教學](validate.md)
* [能力聲明](capabilitystatements.md)
* [視覺化邏輯模型](vision.md)
* [Artifacts Summary](artifacts.md)
* [邏輯模型](models.md)
* [結構定義與範例檔下載](downloads.md)
* [SMART on FHIR規範要求與支援能力](scopes.md)
* [TWPAS ImplementationGuide Resource](ImplementationGuide-tw.gov.mohw.nhi.pas.md)

## Resources

### CodeSystems

* [INCa-健保事前審查-基因突變類型](CodeSystem-inca-osiris.md)
* [NHI-健保事前審查-藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md)
* [NCI 健保事前審查-Thesaurus](CodeSystem-nci-thesaurus.md)
* [NHI-健保事前審查-案件受理狀態](CodeSystem-nhi-acceptance-status.md)
* [NHI-健保事前審查-給付適應症](CodeSystem-nhi-apply-reason.md)
* [NHI-健保事前審查-申請部位](CodeSystem-nhi-apply-side.md)
* [NHI-健保事前審查-申報類別](CodeSystem-nhi-apply-type.md)
* [NHI-健保事前審查-核定註記](CodeSystem-nhi-approve-comment.md)
* [NHI-健保事前審查-身體部位](CodeSystem-nhi-body-site.md)
* [NHI-健保事前審查-續用註記](CodeSystem-nhi-continuation-status.md)
* [NHI-健保事前審查-藥物類型](CodeSystem-nhi-drug-category.md)
* [NHI-健保事前審查-用藥線別](CodeSystem-nhi-line-of-therapy.md)
* [NHI-健保事前審查-用藥品項](CodeSystem-nhi-medication.md)
* [NHI-健保事前審查-醫令類別](CodeSystem-nhi-order-type.md)
* [NHI-健保事前審查-病人狀態評估項目](CodeSystem-nhi-pat-ast.md)
* [NHI-健保事前審查-文件類型](CodeSystem-nhi-pdf-type.md)
* [NHI-健保事前審查-補充資訊類別](CodeSystem-nhi-supporting-info-type.md)
* [NHI-健保事前審查-申請案件類別](CodeSystem-nhi-tmhb-type.md)
* [NHI-健保事前審查-治療後疾病狀態評估項目](CodeSystem-nhi-tx-ast.md)
* [NHI-健保事前審查-特約醫事機構](CodeSystem-organization-identifier-tw.md)

### ValueSets

* [NCI-健保事前審查-FIGO癌症分期量表結果值集](ValueSet-cancer-stage-score.md)
* [SCT + NCI-健保事前審查-癌症分期量表項目值集](ValueSet-cancer-stage.md)
* [HL7-AcquisitionModality值集](ValueSet-dicom-cid-29-AcquisitionModality.md)
* [LOINC-健保事前審查-基因突變類型值集](ValueSet-dna-change-type.md)
* [LOINC-健保事前審查-基因檢測代碼值集](ValueSet-gene-test-code.md)
* [NHI-臺灣健保署2014年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2014-image.md)
* [NHI-臺灣健保署2014年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2014-radiotherapy.md)
* [NHI-臺灣健保署2023年中文版ICD 10 PCS-影像報告值集](ValueSet-icd-10-pcs-2023-image.md)
* [NHI-臺灣健保署2023年中文版ICD 10 PCS-放射/照光治療項目值集](ValueSet-icd-10-pcs-2023-radiotherapy.md)
* [LOINC-健保事前審查-影像報告值集](ValueSet-imaging-report.md)
* [HL7-非DICOM影像MimeType值集](ValueSet-media-mimetypes.md)
* [HL7 TimingAbbreviation + NHI-健保事前審查-藥品使用頻率值集](ValueSet-medication-frequency-hl7-nhi.md)
* [SNOMED CT + 臺灣健保署-健保事前審查-給藥途徑值集](ValueSet-medication-path-sct-tw.md)
* [NHI-健保事前審查-案件受理狀態值集](ValueSet-nhi-acceptance-status.md)
* [NHI-健保事前審查-給付適應症值集](ValueSet-nhi-apply-reason.md)
* [NHI-健保事前審查-申請部位值集](ValueSet-nhi-apply-side.md)
* [NHI-健保事前審查-申報類別值集](ValueSet-nhi-apply-type.md)
* [NHI-健保事前審查-受理審查案件核定註記值集](ValueSet-nhi-approve-claim-comment.md)
* [NHI-健保事前審查-個別醫令核定註記值集](ValueSet-nhi-approve-item-comment.md)
* [NHI-健保事前審查-身體部位值集](ValueSet-nhi-body-site.md)
* [NHI-健保事前審查-續用註記值集](ValueSet-nhi-continuation-status.md)
* [NHI-健保事前審查-藥物類型值集](ValueSet-nhi-drug-category.md)
* [NHI-健保事前審查-用藥線別值集](ValueSet-nhi-line-of-therapy.md)
* [NHI-健保事前審查-醫療服務給付項目值集](ValueSet-nhi-medical-service-payment.md)
* [NHI-健保事前審查-臺灣食藥署藥品及醫療器材代碼值集](ValueSet-nhi-medication-fda.md)
* [NHI-健保事前審查-用藥品項值集](ValueSet-nhi-medication.md)
* [NHI-健保事前審查-醫令類別值集](ValueSet-nhi-order-type.md)
* [NHI-健保事前審查-特約醫事機構值集](ValueSet-nhi-organization.md)
* [NHI-健保事前審查-文件類型值集](ValueSet-nhi-pdf-type.md)
* [NHI-健保事前審查-補充資訊類別值集](ValueSet-nhi-supporting-info-type.md)
* [NHI-健保事前審查-申請案件類別值集](ValueSet-nhi-tmhb-type.md)
* [NHI-健保事前審查-治療後疾病狀態評估項目值集](ValueSet-nhi-tx-ast.md)
* [LOINC + SCT + NHI-健保事前審查-病人狀態評估項目值集](ValueSet-pat-ast.md)
* [LOINC-健保事前審查-報告類型值集](ValueSet-report-type.md)
* [SNOMEDCT-健保事前審查-身體部位值集](ValueSet-sct-body-site.md)
* [LOINC-健保事前審查-基因檢測檢體類型值集](ValueSet-specime-type.md)

### Logicals

* [申請(Apply)免疫製劑(Immunologic Aagent)事前審查之資料模型](StructureDefinition-ApplyImmModel.md)
* [申請(Apply)癌症用藥癌藥事前審查之資料模型](StructureDefinition-ApplyModel.md)
* [回覆(Response)事前審查之資料模型](StructureDefinition-ResponseModel.md)

### Resource Profiles

* [過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md)
* [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md)
* [事前審查回覆-Bundle Response TWPAS](StructureDefinition-Bundle-response-twpas.md)
* [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* [計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md)
* [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md)
* [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
* [自主審查-ClaimResponse Self Assessment TWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md)
* [事前審查回覆-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md)
* [評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md)
* [診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md)
* [健保事前審查計畫-Coverage TWPAS](StructureDefinition-Coverage-twpas.md)
* [影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md)
* [檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md)
* [文件參照-DocumentReference TWPAS](StructureDefinition-DocumentReference-twpas.md)
* [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)
* [就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md)
* [DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md)
* [非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md)
* [事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md)
* [用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)
* [血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md)
* [癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md)
* [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)
* [檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md)
* [客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md)
* [病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)
* [主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md)
* [治療後疾病狀態評估-Observation Treatment Assessment TWPAS](StructureDefinition-Observation-tx-assessment-twpas.md)
* [系統回應訊息-OperationOutcome TWPAS](StructureDefinition-Operationoutcome-twpas.md)
* [基因檢測機構-Organization Genetic Testing TWPAS](StructureDefinition-Organization-genetic-testing-twpas.md)
* [醫事機構-Organization TWPAS](StructureDefinition-Organization-twpas.md)
* [病人資訊-Patient TWPAS](StructureDefinition-Patient-twpas.md)
* [醫事人員-Practitioner TWPAS](StructureDefinition-Practitioner-twpas.md)
* [放射/照光治療-Procedure TWPAS](StructureDefinition-Procedure-twpas.md)
* [基因檢測檢體-Specimen TWPAS](StructureDefinition-Specimen-twpas.md)
* [放射/照光治療總劑量-Substance TWPAS](StructureDefinition-Substance-twpas.md)

### Extensions

* [ClaimEncounter](StructureDefinition-extension-claim-encounter.md)
* [ClaimResponseRequestor](StructureDefinition-extension-claimResponse-requestor.md)
* [EncounterCarePlan](StructureDefinition-extension-encounter-carePlan.md)
* [EncounterClinicalImpression](StructureDefinition-extension-encounter-clinicalImpression.md)
* [EncounterObjective](StructureDefinition-extension-encounter-objective.md)
* [EncounterSubjective](StructureDefinition-extension-encounter-subjective.md)
* [RequestedService](StructureDefinition-extension-requestedService.md)

### CapabilityStatements

* [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md)
* [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

### ConceptMaps

* [臺灣健保署醫療服務給付項目對應LOINC](ConceptMap-nhi-loinc.md)
* [臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)

### ImplementationGuides

* [臺灣健保事前審查實作指引](index.md)

### SearchParameters

* [BundleID](SearchParameter-Bundle-id.md)
* [ClaimFuncType](SearchParameter-Claim-func-type.md)
* [ClaimIdentifier](SearchParameter-Claim-identifier.md)
* [ClaimID](SearchParameter-Claim-patient.md)
* [ClaimResponseAdjudicationReason](SearchParameter-ClaimResponse-adjudication-reason.md)
* [ClaimResponseCreated](SearchParameter-ClaimResponse-created.md)
* [ClaimResponseDisposition](SearchParameter-ClaimResponse-disposition.md)
* [ClaimResponseRequest](SearchParameter-ClaimResponse-request.md)
* [EncounterServiceType](SearchParameter-Encounter-service-type.md)
* [PatientIdentifier](SearchParameter-Patient-identifier.md)
* [PatientName](SearchParameter-Patient-name.md)

### Examples

* [all-min (AllergyIntolerance)](AllergyIntolerance-all-min.md)
* [bun-1 (Bundle)](Bundle-bun-1.md)
* [bun-3 (Bundle)](Bundle-bun-3.md)
* [bun-imm (Bundle)](Bundle-bun-imm.md)
* [bun-response (Bundle)](Bundle-bun-response.md)
* [bun-self (Bundle)](Bundle-bun-self.md)
* [bun-uuid-example (Bundle)](Bundle-bun-uuid-example.md)
* [careplan-min (CarePlan)](CarePlan-careplan-min.md)
* [cla-1 (Claim)](Claim-cla-1.md)
* [cla-3 (Claim)](Claim-cla-3.md)
* [cla-imm (Claim)](Claim-cla-imm.md)
* [claim-response-example (ClaimResponse)](ClaimResponse-claim-response-example.md)
* [self-assessment-example (ClaimResponse)](ClaimResponse-self-assessment-example.md)
* [cliImp-min (ClinicalImpression)](ClinicalImpression-cliImp-min.md)
* [con-diagnosis (Condition)](Condition-con-diagnosis.md)
* [cov-min (Coverage)](Coverage-cov-min.md)
* [diaRep-ima-loinc (DiagnosticReport)](DiagnosticReport-diaRep-ima-loinc.md)
* [diaRep-ima-min (DiagnosticReport)](DiagnosticReport-diaRep-ima-min.md)
* [diaRep-min (DiagnosticReport)](DiagnosticReport-diaRep-min.md)
* [inline-2-diaRep-ima-loinc (DiagnosticReport)](DiagnosticReport-inline-2-diaRep-ima-loinc.md)
* [inline-diaRep-ima-loinc (DiagnosticReport)](DiagnosticReport-inline-diaRep-ima-loinc.md)
* [doc-careplan-min (DocumentReference)](DocumentReference-doc-careplan-min.md)
* [doc-gene-min (DocumentReference)](DocumentReference-doc-gene-min.md)
* [doc-medicalRecord-min (DocumentReference)](DocumentReference-doc-medicalRecord-min.md)
* [doc-patientAssessment-min (DocumentReference)](DocumentReference-doc-patientAssessment-min.md)
* [doc-test-min (DocumentReference)](DocumentReference-doc-test-min.md)
* [enc-min (Encounter)](Encounter-enc-min.md)
* [enc-opd (Encounter)](Encounter-enc-opd.md)
* [imaStu-min (ImagingStudy)](ImagingStudy-imaStu-min.md)
* [med-min (Media)](Media-med-min.md)
* [medReq-apply-2 (MedicationRequest)](MedicationRequest-medReq-apply-2.md)
* [medReq-apply (MedicationRequest)](MedicationRequest-medReq-apply.md)
* [medReq-treat (MedicationRequest)](MedicationRequest-medReq-treat.md)
* [obs-blood-group (Observation)](Observation-obs-blood-group.md)
* [obs-cancer-cns (Observation)](Observation-obs-cancer-cns.md)
* [obs-cancer-figo (Observation)](Observation-obs-cancer-figo.md)
* [obs-cancer-tnm (Observation)](Observation-obs-cancer-tnm.md)
* [obs-diagnostic-min (Observation)](Observation-obs-diagnostic-min.md)
* [obs-lab-cbc (Observation)](Observation-obs-lab-cbc.md)
* [obs-lab-min (Observation)](Observation-obs-lab-min.md)
* [obs-objective (Observation)](Observation-obs-objective.md)
* [obs-pat-ctcae (Observation)](Observation-obs-pat-ctcae.md)
* [obs-pat-nyha (Observation)](Observation-obs-pat-nyha.md)
* [obs-pat-pdai (Observation)](Observation-obs-pat-pdai.md)
* [obs-subjective (Observation)](Observation-obs-subjective.md)
* [obs-tx-min (Observation)](Observation-obs-tx-min.md)
* [error-example (OperationOutcome)](OperationOutcome-error-example.md)
* [org-gene-example (Organization)](Organization-org-gene-example.md)
* [臺北市立聯合醫院 (Organization)](Organization-org-hosp-example.md)
* [衛生福利部中央健康保險署 (Organization)](Organization-org-nhi.md)
* [pat-min (Patient)](Patient-pat-min.md)
* [pat-resident (Patient)](Patient-pat-resident.md)
* [pra-min (Practitioner)](Practitioner-pra-min.md)
* [pro-min (Procedure)](Procedure-pro-min.md)
* [spe-min (Specimen)](Specimen-spe-min.md)
* [sub-min (Substance)](Substance-sub-min.md)
