# 應用說明 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* **應用說明**

## 應用說明

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ImplementationGuide/tw.gov.mohw.nhi.pas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:TWPAS |

**請注意**：您目前所看到的IG為持續建置(ci-build)版，主要依據實作者及健保署端的業務需求即時調整V1.0.9版內容，因而會比健保署的IG版本V1.0.9(https://nhicore.nhi.gov.tw/pas/)內容新，僅供未來想以最新版本規格進行資料上傳的人員參考，下次更新版本號時間預計為115年1月，屆時才會調整相應版本的健保署FHIR伺服器規格。
 
 **醫院實作時請以V1.0.9為主進行實例驗證，目前健保署端的伺服器採用V1.0.9版規格。**

擴大事前審查以FHIR送審之範圍至
**免疫製劑**，於2025/12/5新增以下內容：
1. 新增[Profile: 免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md)。
1. 新增[Profile: 免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md)。
1. 病人資訊：
1. 新增[Profile: 過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md)。
1. 新增[Profile: 血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md)。

1. 門診病歷：
1. 新增[Profile: 門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)。
1. 新增[Profile: 診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md)。
1. 新增[Profile: 主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md)。
1. 新增[Profile: 客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md)。
1. 新增[Profile: 評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md)。
1. 新增[Profile: 計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md)。

因考量實作需求，於2025/12/17異動以下內容：
1. 修改[Profile: 癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)：
1. 修改Constraint: supportingInfo：當Claim.priority(案件類別)為1(一般事前審查申請)、3(自主審查)時，至少還需提供檢查報告、影像報告、基因資訊中任一樣資訊。如果Claim.diagnosis.diagnosisCodeableConcept(國際疾病分類代碼)為C61，且Claim.item.modifier:continuation(續用註記)為2，則可排除此條件。
1. 新增Constraint: supportingInfo-tests：當Claim.diagnosis.diagnosisCodeableConcept(國際疾病分類代碼)為C61，且Claim.item.modifier:continuation(續用註記)為2，需提供檢驗(查)。

1. 修改[Profile: 病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)：新增病人狀態評估報告及病人狀態評估報告名稱(`derivedFrom`)。
1. 修改[Profile: 就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md)：取消綁定就醫分類(`class`)之固定值。
1. 修改「放射治療」相關欄位之名稱為「放射/照光治療」。
請留意這些異動，以避免影響您的實作。

**相關資訊可參考衛生福利部中央健康保險署的[事前審查以電子病歷申請專區](https://www.nhi.gov.tw/ch/np-3787-1.html)。**

### 專案介紹

臺灣健保事前審查實作指引(Taiwan NHI Prior Authorization Support Implementation Guide，TWPAS IG)採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在[FHIR R4.0.1](http://hl7.org/fhir/R4/)之標準基礎上，繼承TW Core IG V0.3.2 (2024-12-12)，進一步定義適用於「事前審查」資料需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）及資料類型（文字、日期時間、代碼等）等。

### 專案背景

衛生福利部中央健康保險署規劃事前審查癌症用藥上傳機制。為扣合賴總統於健康台灣之「國家癌症防治計畫」政策，本署刻正規劃NGS申報資料收載、癌症重大傷病申請、事前審查申請及癌症個案療效追蹤等癌症醫療資訊之數位轉型，期透過資料有效互通，達成以病人為中心之完整照護。

申請案件類別包含「一般事前審查申請」、「自主審查」、「緊急報備」，於[Claim](StructureDefinition-Claim-twpas.md).priority呈現。

申報類別包含「送核」、「送核補件」、「申復」、「爭議審議 」、「申復補件 」，於[Claim](StructureDefinition-Claim-twpas.md).subType呈現。 送核、送核補件、申復及申復補件之作業流程皆相同，依該個案是首次送審或不同意後再次送審等之狀態進行選擇不同的申報類別，以做為行政程序之判斷。

### 專案範圍

#### 使用案例(Use Case)

本專案之主要實作者為醫院，醫院透過事前審查系統建立事前審查資料，透過共通傳輸平台批次上傳事前審查相關文件，並送至衛生福利部中央健康保險署審核。

#### 循序圖

送核、送核補件、申復及申復補件之作業流程皆相同，依該個案是首次送審或不同意後再次送審等之狀態進行選擇不同的申請類別，以做為行政程序之判斷。

送核、送核補件、申復及申復補件作業流程如下：

1. 醫院開發事前審查系統產生事前審查報告（Bundle TWPAS）
1. 醫院將已產生之事前審查相關文件上傳至健保署
1. 若資料符合格式，健保署回覆上傳成功訊息，由醫院查詢上傳結果
1. 若資料不符合格式，健保署回覆上傳失敗訊息，由醫院查詢上傳結果
1. 資料上傳成功後，審核醫師審核報告通過，由醫院查詢審核結果
1. 資料上傳成功後，審核醫師審核報告未通過，由醫院查詢審核結果![](sequence.png)

### 如何閱讀這個實作指引(IG)

TWPAS IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：TWPAS IG介紹及背景說明。
* **[視覺化邏輯模型](vision.md)**：TWPAS IG邏輯模型架構視覺化圖。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用TWPAS IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的資料存取功能。 
* **[查詢參數](searchparameters.md)**：查詢FHIR Server的Profiles時，針對各Profiles可使用的查詢參數。
* **[邏輯模型](models.md)**：TWPAS IG的所有邏輯模型(Logical Models)，邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目(element)。 
* **[FHIR Profiles及Extensions](profiles-and-extensions.md)**： 
* TWPAS IG的所有Profiles之定義與範例及Extensions。
* 各資料項目不同實作強制程度的Terminology。
* 各資料項目的限制（Constraints）。
* 查詢依據TWPAS IG實作之FHIR Server的特定Profiles時，可使用的查詢參數。
* 有哪些Profiles具有查詢參數以及Server必須支援哪些必要的查詢參數功能。
 
* **[專門術語](terminologies.md)**：TWPAS IG所使用的專門術語，包括代碼系統（Code Systems）、值集（Value Sets）及概念對應（Concept Map）。 
 
* **[範例](examples.md)**：符合TWPAS IG所定義Profiles之範例檔。
* **[結構定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否符合Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例檔。
* **[安全性](security.md)**：主要說明採用TWPAS IG網站進行實作時，有關資料存取授權的作法。
* **[驗證教學](validate.md)**：如何驗證實作檔是否遵從TWPAS IG規範。
* **[版本異動說明頁](https://nhicore.nhi.gov.tw/pas/history.html)**：若TWPAS IG網站的版本有所異動，皆可透過[異動說明頁](https://nhicore.nhi.gov.tw/pas/history.html)得以瞭解版本間的異動差異。

### 作者與貢獻者

| | | |
| :--- | :--- | :--- |
| 作者-IG | 李麗惠 | 國立臺北護理健康大學-健康事業管理系 |
| 作者-IG | 曾鈺珈 | |
| 貢獻者-IG | 張如薰 | 衛生福利部中央健康保險署-醫審及藥材組 |
| 貢獻者-IG | 涂奇君 | |
| 貢獻者-IG | 張佐安 | |
| 貢獻者-IG | 鄧嘉欣 | |
| 貢獻者-IG | 醫藥品查驗中心(CDE) | |
| 貢獻者-IG | 衛生福利部中央健康保險署-資訊組 | |
| 貢獻者-IG | 衛生福利部資訊處 | |

如醫院有參與意願，或對資料內容、代碼檔、IG有任何疑問，歡迎聯繫下方窗口：

1. 有關資料內容或代碼檔請找張小姐(02-27065866轉3062)、鄧小姐(02-27065866轉3040)
1. 有關TWPAS IG請找吳先生(02-27065866轉6048)
1. 聯繫信箱:E00@nhi.gov.tw(此信箱僅提供醫院洽詢相關業務事項)

*若民眾對事前審查案申請案件有疑義，請洽各分區業務組。

