# NHI-健保事前審查-特約醫事機構值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保事前審查-特約醫事機構值集**

## ValueSet: NHI-健保事前審查-特約醫事機構值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-organization | *Version*:1.1.0 |
| Active as of 2024-08-19 | *Computable Name*:NHIOrganization |

 
NHI-健保事前審查-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120) 
代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 **References** 

* [醫事機構-Organization TWPAS](StructureDefinition-Organization-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-organization",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/nhi-organization",
  "version" : "1.1.0",
  "name" : "NHIOrganization",
  "title" : "NHI-健保事前審查-特約醫事機構值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-19",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保事前審查-特約醫事機構值集，參照至[衛福部健保署特約醫事機構代碼網路查詢服務](https://www.nhi.gov.tw/ch/cp-5548-135e8-2931-1.html)中的[健保特約醫療院所名冊](https://info.nhi.gov.tw/IODE0000/IODE0000S09?id=1120)\n\n代碼出版日期：2024-04-22；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n",
  "compose" : {
    "include" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/organization-identifier-tw"
      }
    ]
  }
}

```
