# LOINC-健保事前審查-基因突變類型值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LOINC-健保事前審查-基因突變類型值集**

## ValueSet: LOINC-健保事前審查-基因突變類型值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/dna-change-type | *Version*:1.1.0 |
| Active as of 2025-10-01 | *Computable Name*:DNAChangeType |

 
LOINC-健保事前審查-基因突變類型值集 

 **References** 

* [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "dna-change-type",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/dna-change-type",
  "version" : "1.1.0",
  "name" : "DNAChangeType",
  "title" : "LOINC-健保事前審查-基因突變類型值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-01",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC-健保事前審查-基因突變類型值集",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "LA6692-3",
            "display" : "Deletion"
          },
          {
            "code" : "LA6686-5",
            "display" : "Duplication"
          },
          {
            "code" : "LA6687-3",
            "display" : "Insertion"
          },
          {
            "code" : "LA6688-1",
            "display" : "Insertion/Deletion"
          },
          {
            "code" : "LA6689-9",
            "display" : "Inversion"
          },
          {
            "code" : "LA6690-7",
            "display" : "Substitution"
          },
          {
            "code" : "101397-8",
            "display" : "Copy number variation analysis in Blood or Tissue by Sequencing"
          },
          {
            "code" : "81695-9",
            "display" : "MSI Ca spec-Imp"
          },
          {
            "code" : "94077-5",
            "display" : "TMB Tumor-Imp"
          },
          {
            "code" : "LA11883-8",
            "display" : "Not detected"
          },
          {
            "code" : "95123-6",
            "display" : "Gene fusion transcript details in Blood or Tissue by Molecular genetics method Narrative"
          }
        ]
      },
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/inca-osiris",
        "concept" : [
          {
            "code" : "O55-2",
            "display" : "Delins"
          }
        ]
      }
    ]
  }
}

```
