# 基因檢測檢體-Specimen TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **基因檢測檢體-Specimen TWPAS**

## Resource Profile: 基因檢測檢體-Specimen TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Specimen-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:SpecimenTWPAS |

 
此基因檢測檢體-Specimen TWPAS Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現事前審查中基因資訊之檢測檢體相關內容 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)
* Examples for this Profile: [Specimen/spe-min](Specimen-spe-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Specimen-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Specimen-twpas.csv), [Excel](StructureDefinition-Specimen-twpas.xlsx), [Schematron](StructureDefinition-Specimen-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Specimen-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Specimen-twpas",
  "version" : "1.1.0",
  "name" : "SpecimenTWPAS",
  "title" : "基因檢測檢體-Specimen TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此基因檢測檢體-Specimen TWPAS Profile說明本IG如何進一步定義臺灣核心-檢體(TW Core Specimen) Profile以呈現事前審查中基因資訊之檢測檢體相關內容",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen.meta",
        "path" : "Specimen.meta",
        "min" : 1
      },
      {
        "id" : "Specimen.meta.profile",
        "path" : "Specimen.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Specimen-twpas"
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "short" : "基因檢測檢體類型",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/specime-type"
        }
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.receivedTime",
        "path" : "Specimen.receivedTime",
        "short" : "基因檢測日期",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
