# 回覆(Response)事前審查之資料模型 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **回覆(Response)事前審查之資料模型**

## Logical Model: 回覆(Response)事前審查之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/ResponseModel | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:ResponseModel |

 
回覆(Response)事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。
為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.md#癌藥事前審查回覆之bundle架構bundle-response)進行欄位對應 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/ResponseModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ResponseModel.csv), [Excel](StructureDefinition-ResponseModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ResponseModel",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ResponseModel",
  "version" : "1.1.0",
  "name" : "ResponseModel",
  "title" : "回覆(Response)事前審查之資料模型",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "回覆(Response)事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.html#癌藥事前審查回覆之bundle架構bundle-response)進行欄位對應",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ResponseModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ResponseModel",
        "path" : "ResponseModel",
        "short" : "回覆(Response)事前審查之資料模型",
        "definition" : "回覆(Response)事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.html#癌藥事前審查回覆之bundle架構bundle-response)進行欄位對應"
      },
      {
        "id" : "ResponseModel.approveDate",
        "path" : "ResponseModel.approveDate",
        "short" : "核定日期",
        "definition" : "核定日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ResponseModel.acptNo",
        "path" : "ResponseModel.acptNo",
        "short" : "案件受理狀態",
        "definition" : "案件受理狀態",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ResponseModel.approveClaimComment",
        "path" : "ResponseModel.approveClaimComment",
        "short" : "受理審查案件核定註記",
        "definition" : "受理審查案件核定註記。1:同意 | 2:不予同意 | 3:部份同意 | 4:補件 | 5:退件",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResponseModel.approveNum",
        "path" : "ResponseModel.approveNum",
        "short" : "核定數量",
        "definition" : "核定數量",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      },
      {
        "id" : "ResponseModel.approveItemComment",
        "path" : "ResponseModel.approveItemComment",
        "short" : "個別醫令核定註記",
        "definition" : "個別醫令核定註記。0:審核中 | 1:同意 | 2:不予同意 | 3:部份同意 | 4:補件 | 5:退件 | 6:不予同意:對應手術亦不支付 | 7:改核:如審查核定意見",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
