# 病人資訊-Patient TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **病人資訊-Patient TWPAS**

## Resource Profile: 病人資訊-Patient TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:PatientTWPAS |

 
此病人資訊-Patient TWPAS Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現事前審查之病人基本資料 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md), [計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md), [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md), [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)...Show 24 more,[自主審查-ClaimResponse Self Assessment TWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md),[事前審查回覆-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md),[評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md),[診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md),[健保事前審查計畫-Coverage TWPAS](StructureDefinition-Coverage-twpas.md),[影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md),[檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md),[文件參照-DocumentReference TWPAS](StructureDefinition-DocumentReference-twpas.md),[門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md),[就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md),[DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md),[非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md),[事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md),[用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md),[血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md),[癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md),[基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md),[檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md),[客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md),[病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md),[主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md),[治療後疾病狀態評估-Observation Treatment Assessment TWPAS](StructureDefinition-Observation-tx-assessment-twpas.md),[放射/照光治療-Procedure TWPAS](StructureDefinition-Procedure-twpas.md)and[基因檢測檢體-Specimen TWPAS](StructureDefinition-Specimen-twpas.md)
* Examples for this Profile: [Patient/pat-min](Patient-pat-min.md) and [Patient/pat-resident](Patient-pat-resident.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Patient-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-twpas.csv), [Excel](StructureDefinition-Patient-twpas.xlsx), [Schematron](StructureDefinition-Patient-twpas.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TWPAS支援的RESTful互動功能的完整清單，請參閱[TWPAS Server能力聲明](CapabilityStatement-CapabilityStatementTWPASServer.md)。

#### 建議應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`name`](SearchParameter-Patient-name.md)**查詢所有Patient：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Patient?name=[string]`例子：
(1) GET [base]/Patient?name=王大明
1. **必須（SHALL）**支援透過查詢參數**[`identifier`](SearchParameter-Patient-identifier.md)**查詢所有Patient：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Patient?identifier=[code]`例子：
(1) GET [base]/Patient?identifier=A123456789



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas",
  "version" : "1.1.0",
  "name" : "PatientTWPAS",
  "title" : "病人資訊-Patient TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此病人資訊-Patient TWPAS Profile說明本IG如何進一步定義臺灣核心-病人(TW Core Patient) Profile以呈現事前審查之病人基本資料",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/emr/StructureDefinition/TWCorePatient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "patient-gender-match",
            "severity" : "error",
            "human" : "gender依據identifier:idCardNumber第二位字符檢核男性與女性代碼 (1=male, 2=female)",
            "expression" : "identifier.where(system = 'http://www.moi.gov.tw').value.exists() implies (identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '1' implies gender = 'male') and (identifier.where(system = 'http://www.moi.gov.tw').value.substring(1, 1) = '2' implies gender = 'female')",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
          }
        ]
      },
      {
        "id" : "Patient.meta",
        "path" : "Patient.meta",
        "min" : 1
      },
      {
        "id" : "Patient.meta.profile",
        "path" : "Patient.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type.coding.code"
            },
            {
              "type" : "value",
              "path" : "type.coding.system"
            }
          ],
          "rules" : "closed"
        },
        "max" : "2"
      },
      {
        "id" : "Patient.identifier:idCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "idCardNumber",
        "short" : "身分證號，被保險人國民身分證統一編號。"
      },
      {
        "id" : "Patient.identifier:passportNumber",
        "path" : "Patient.identifier",
        "sliceName" : "passportNumber",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier:residentNumber",
        "path" : "Patient.identifier",
        "sliceName" : "residentNumber",
        "short" : "居留證號。",
        "constraint" : [
          {
            "key" : "resident-number",
            "severity" : "error",
            "human" : "居留證號格式為：「1碼英文+9碼數字」或「2碼英文+8碼數字」。",
            "expression" : "value.matches('^([A-Za-z][0-9]{9}|[A-Za-z]{2}[0-9]{8})$')",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
          }
        ]
      },
      {
        "id" : "Patient.identifier:medicalRecord",
        "path" : "Patient.identifier",
        "sliceName" : "medicalRecord",
        "short" : "病歷號 (參與醫院必須註冊命名系統)，由醫院自行填寫。"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "pat-name",
            "severity" : "error",
            "human" : "病人姓名有誤 ，超過40字",
            "expression" : "text.length() <= 40",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
          }
        ]
      },
      {
        "id" : "Patient.name:official",
        "path" : "Patient.name",
        "sliceName" : "official",
        "max" : "0"
      },
      {
        "id" : "Patient.name:usual",
        "path" : "Patient.name",
        "sliceName" : "usual",
        "min" : 1
      },
      {
        "id" : "Patient.name:usual.text",
        "path" : "Patient.name.text",
        "min" : 1
      },
      {
        "id" : "Patient.name:temp",
        "path" : "Patient.name",
        "sliceName" : "temp",
        "max" : "0"
      },
      {
        "id" : "Patient.name:anonymous",
        "path" : "Patient.name",
        "sliceName" : "anonymous",
        "max" : "0"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "male:男性 ｜ female:女性 ｜ other:其他 ｜ unknown:未知"
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "出生日期，YYYY-MM-DD，西元年月日。"
      }
    ]
  }
}

```
