# 非DICOM影像-Media TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **非DICOM影像-Media TWPAS**

## Resource Profile: 非DICOM影像-Media TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:MediaTWPAS |

 
此非DICOM影像-Media TWPAS Profile說明本IG如何進一步定義臺灣核心-多媒體(TW Core Media) Profile以呈現事前審查中疾病資訊之影像報告的非DICOM影像 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md)
* Examples for this Profile: [Media/med-min](Media-med-min.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Media-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Media-twpas.csv), [Excel](StructureDefinition-Media-twpas.xlsx), [Schematron](StructureDefinition-Media-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Media-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas",
  "version" : "1.1.0",
  "name" : "MediaTWPAS",
  "title" : "非DICOM影像-Media TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此非DICOM影像-Media TWPAS Profile說明本IG如何進一步定義臺灣核心-多媒體(TW Core Media) Profile以呈現事前審查中疾病資訊之影像報告的非DICOM影像",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Media",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Media.meta",
        "path" : "Media.meta",
        "min" : 1
      },
      {
        "id" : "Media.meta.profile",
        "path" : "Media.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas"
      },
      {
        "id" : "Media.subject",
        "path" : "Media.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      },
      {
        "id" : "Media.bodySite",
        "path" : "Media.bodySite",
        "short" : "影像檢查的身體部位",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/sct-body-site"
        }
      },
      {
        "id" : "Media.content",
        "path" : "Media.content",
        "constraint" : [
          {
            "key" : "UploadContent",
            "severity" : "error",
            "human" : "填寫格式：file://檔名.副檔名，例如：file://US01.jpg、file://PathologyReport01.pdf、file://GenReport01.pdf、file://王大明病歷.pdf",
            "expression" : "url.matches('^file://[a-zA-Z0-9_一-龥()-]+.[a-zA-Z]{2,5}$')",
            "source" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas"
          }
        ]
      },
      {
        "id" : "Media.content.contentType",
        "path" : "Media.content.contentType",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nhicore.nhi.gov.tw/pas/ValueSet/media-mimetypes"
        }
      },
      {
        "id" : "Media.content.url",
        "path" : "Media.content.url",
        "short" : "非DICOM影像（請填寫完整檔案路徑）。填寫上傳附件檔名，例如：file://US01.jpg，且需上傳壓縮後的影像圖檔。",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueUrl" : "file://US01.jpg"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
