# 診斷-Condition TWPAS - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **診斷-Condition TWPAS**

## Resource Profile: 診斷-Condition TWPAS 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:ConditionTWPAS |

 
此診斷-Condition TWPAS Profile說明本IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition）Profile以呈現免疫製劑事前審查之診斷 

**Usages:**

* Use this Profile: [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) and [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
* Refer to this Profile: [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md)
* Examples for this Profile: [Condition/con-diagnosis](Condition-con-diagnosis.md)
* CapabilityStatements using this Profile: [臺灣事前審查-用戶端(TWPAS Client)](CapabilityStatement-CapabilityStatementTWPASClient.md) and [臺灣事前審查-伺服端(TWPAS Server)](CapabilityStatement-CapabilityStatementTWPASServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/Condition-twpas)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition-twpas.csv), [Excel](StructureDefinition-Condition-twpas.xlsx), [Schematron](StructureDefinition-Condition-twpas.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition-twpas",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas",
  "version" : "1.1.0",
  "name" : "ConditionTWPAS",
  "title" : "診斷-Condition TWPAS",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "此診斷-Condition TWPAS Profile說明本IG如何進一步定義臺灣核心-病情、問題或診斷（TW Core Condition）Profile以呈現免疫製劑事前審查之診斷",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition.meta",
        "path" : "Condition.meta",
        "min" : 1
      },
      {
        "id" : "Condition.meta.profile",
        "path" : "Condition.meta.profile",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas"
      },
      {
        "id" : "Condition.clinicalStatus.coding",
        "path" : "Condition.clinicalStatus.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
          "code" : "active"
        }
      },
      {
        "id" : "Condition.category.coding",
        "path" : "Condition.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "29548-5"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "short" : "診斷",
        "min" : 1
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.code.coding:icd10-cm-2021",
        "path" : "Condition.code.coding",
        "sliceName" : "icd10-cm-2021",
        "max" : "0"
      },
      {
        "id" : "Condition.code.coding:icd9-cm-2001",
        "path" : "Condition.code.coding",
        "sliceName" : "icd9-cm-2001",
        "max" : "0"
      },
      {
        "id" : "Condition.code.coding:absentOrUnknownProblem",
        "path" : "Condition.code.coding",
        "sliceName" : "absentOrUnknownProblem",
        "max" : "0"
      },
      {
        "id" : "Condition.code.coding:sct",
        "path" : "Condition.code.coding",
        "sliceName" : "sct",
        "max" : "0"
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas"
            ]
          }
        ]
      }
    ]
  }
}

```
