# 申請(Apply)癌症用藥癌藥事前審查之資料模型 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **申請(Apply)癌症用藥癌藥事前審查之資料模型**

## Logical Model: 申請(Apply)癌症用藥癌藥事前審查之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyModel | *Version*:1.1.0 |
| Active as of 2025-12-17 | *Computable Name*:ApplyModel |

 
申請(Apply)癌症用藥癌藥事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。
為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.md)進行欄位對應 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.nhi.pas|current/StructureDefinition/ApplyModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ApplyModel.csv), [Excel](StructureDefinition-ApplyModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ApplyModel",
  "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyModel",
  "version" : "1.1.0",
  "name" : "ApplyModel",
  "title" : "申請(Apply)癌症用藥癌藥事前審查之資料模型",
  "status" : "active",
  "date" : "2025-12-17T10:01:26+00:00",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "申請(Apply)癌症用藥癌藥事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.html)進行欄位對應",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWPASClaim",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-twpas",
      "name" : "Mapping to TWPAS Claim"
    },
    {
      "identity" : "TWPASPatient",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas",
      "name" : "Mapping to TWPAS Patient"
    },
    {
      "identity" : "TWPASOrganization",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas",
      "name" : "Mapping to TWPAS Organization"
    },
    {
      "identity" : "TWPASEncounter",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas",
      "name" : "Mapping to TWPAS Encounter"
    },
    {
      "identity" : "TWPASDiagnosticReportImage",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-image-twpas",
      "name" : "Mapping to TWPAS DiagnosticReportImage"
    },
    {
      "identity" : "TWPASImagingStudy",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas",
      "name" : "Mapping to TWPAS ImagingStudy"
    },
    {
      "identity" : "TWPASMedia",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas",
      "name" : "Mapping to TWPAS Media"
    },
    {
      "identity" : "TWPASObservationCancerStage",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-cancer-stage-twpas",
      "name" : "Mapping to TWPAS ObservationCancerStage"
    },
    {
      "identity" : "TWPASDiagnosticReport",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-twpas",
      "name" : "Mapping to TWPAS DiagnosticReport"
    },
    {
      "identity" : "TWPASObservationDiagnostic",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-diagnostic-twpas",
      "name" : "Mapping to TWPAS ObservationDiagnostic"
    },
    {
      "identity" : "TWPASObservationLaboratoryResult",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas",
      "name" : "Mapping to TWPAS ObservationLaboratoryResult"
    },
    {
      "identity" : "TWPASObservationPatientAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-pat-assessment-twpas",
      "name" : "Mapping to TWPAS ObservationPatientAssessment"
    },
    {
      "identity" : "TWPASMedicationRequestTreat",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas",
      "name" : "Mapping to TWPAS MedicationRequestTreatTWPAS"
    },
    {
      "identity" : "TWPASProcedure",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas",
      "name" : "Mapping to TWPAS Procedure"
    },
    {
      "identity" : "TWPASSubstance",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas",
      "name" : "Mapping to TWPAS Substance"
    },
    {
      "identity" : "TWPASDocumentReference",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas",
      "name" : "Mapping to TWPAS DocumentReference"
    },
    {
      "identity" : "TWPASObservationTreatmentAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-tx-assessment-twpas",
      "name" : "Mapping to TWPAS ObservationTreatmentAssessment"
    },
    {
      "identity" : "TWPASMedicationRequestApply",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas",
      "name" : "Mapping to TWPAS MedicationRequestApply"
    },
    {
      "identity" : "TWPASClaimResponseSelfAssessment",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-self-assessment-twpas",
      "name" : "Mapping to TWPAS ClaimResponse Self Assessment"
    },
    {
      "identity" : "TWPASPractitioner",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas",
      "name" : "Mapping to TWPAS Practitioner"
    },
    {
      "identity" : "TWPASBundle",
      "uri" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas",
      "name" : "Mapping to TWPAS Bundle"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ApplyModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ApplyModel",
        "path" : "ApplyModel",
        "short" : "申請(Apply)癌症用藥癌藥事前審查之資料模型",
        "definition" : "申請(Apply)癌症用藥癌藥事前審查之資料模型，此邏輯模型為定義癌症用藥事前審查情境下使用的所有資料欄位。  \n為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。亦可配合[視覺化邏輯模型圖](vision-cancer.html)進行欄位對應"
      },
      {
        "id" : "ApplyModel.hosp",
        "path" : "ApplyModel.hosp",
        "short" : "院所資訊",
        "definition" : "院所資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.hospId",
        "path" : "ApplyModel.hosp.hospId",
        "short" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "definition" : "醫事機構代碼，必須存在於醫事機構基本資料檔內",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.provider.reference"
          },
          {
            "identity" : "TWPASOrganization",
            "map" : "Organization.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applType",
        "path" : "ApplyModel.hosp.applType",
        "short" : "申報類別",
        "definition" : "申報類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.subType.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.funcType",
        "path" : "ApplyModel.hosp.funcType",
        "short" : "就醫科別",
        "definition" : "就醫科別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.extension.where(url = 'https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter').valueReference.reference"
          },
          {
            "identity" : "TWPASEncounter",
            "map" : "Encounter.serviceType.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applPrsnId",
        "path" : "ApplyModel.hosp.applPrsnId",
        "short" : "申請醫師身分證號",
        "definition" : "申請醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.enterer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.applDate",
        "path" : "ApplyModel.hosp.applDate",
        "short" : "申請日期，機構自填",
        "definition" : "申請日期，機構自填",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.created"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.immediateDate",
        "path" : "ApplyModel.hosp.immediateDate",
        "short" : "緊急報備日期，機構自填",
        "definition" : "緊急報備日期，機構自填",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASBundle",
            "map" : "Bundle.timestamp"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.tmhbType",
        "path" : "ApplyModel.hosp.tmhbType",
        "short" : "申請案件類別",
        "definition" : "申請案件類別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.priority.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.hosp.oldAcptNo",
        "path" : "ApplyModel.hosp.oldAcptNo",
        "short" : "原受理編號",
        "definition" : "原受理編號",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient",
        "path" : "ApplyModel.patient",
        "short" : "病人資訊",
        "definition" : "病人資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.name",
        "path" : "ApplyModel.patient.name",
        "short" : "姓名",
        "definition" : "姓名",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASPatient",
            "map" : "Patient.name.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.idCard",
        "path" : "ApplyModel.patient.idCard",
        "short" : "身分證字號",
        "definition" : "身分證字號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.patient.reference"
          },
          {
            "identity" : "TWPASPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'NNxxx').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.patId",
        "path" : "ApplyModel.patient.patId",
        "short" : "病歷號",
        "definition" : "病歷號 (參與醫院必須註冊命名系統)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASPatient",
            "map" : "Patient.identifier.where(type.coding.code = 'MR').value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.birthday",
        "path" : "ApplyModel.patient.birthday",
        "short" : "出生日期",
        "definition" : "出生日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASPatient",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.gender",
        "path" : "ApplyModel.patient.gender",
        "short" : "病人性別",
        "definition" : "病人性別",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASPatient",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.weight",
        "path" : "ApplyModel.patient.weight",
        "short" : "病人體重",
        "definition" : "病人體重",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'weight').valueQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.height",
        "path" : "ApplyModel.patient.height",
        "short" : "病人身高",
        "definition" : "病人身高",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'height').valueQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.patient.pregnant",
        "path" : "ApplyModel.patient.pregnant",
        "short" : "是否懷孕或哺乳",
        "definition" : "是否懷孕或哺乳",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'pregnancyBreastfeedingStatus').valueBoolean"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis",
        "path" : "ApplyModel.diagnosis",
        "short" : "疾病資訊",
        "definition" : "疾病資訊",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.icd10cmCode",
        "path" : "ApplyModel.diagnosis.icd10cmCode",
        "short" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "definition" : "國際疾病分類代碼 (sequence=1)，共病症 (sequence>=2)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.diagnosis.diagnosisCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.diagDate",
        "path" : "ApplyModel.diagnosis.diagDate",
        "short" : "診斷日期，sequence=1必填",
        "definition" : "YYYYMMDD，西元年月日，民國前為負數，sequence=1時為必填",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.diagnosis.extension.where(url = 'http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate').valueDate"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.diagCurrentStatus",
        "path" : "ApplyModel.diagnosis.diagCurrentStatus",
        "short" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原事前審查之申請理由。",
        "definition" : "簡要病摘。連結院內HIS系統之簡要病摘，或填寫原事前審查之申請理由。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.diagnosis.type.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.medrec",
        "path" : "ApplyModel.diagnosis.medrec",
        "short" : "病歷資料（非屬影像報告檢查驗報告部分）",
        "definition" : "病歷資料（非屬影像報告檢查驗報告部分）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'medicalRecord').valueReference.reference"
          },
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.medrecTitle",
        "path" : "ApplyModel.diagnosis.medrecTitle",
        "short" : "病歷資料名稱",
        "definition" : "病歷資料名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy",
        "path" : "ApplyModel.diagnosis.imageStudy",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgItem",
        "path" : "ApplyModel.diagnosis.imageStudy.imgItem",
        "short" : "影像報告",
        "definition" : "影像報告",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'imagingReport').valueReference.reference"
          },
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgResult",
        "path" : "ApplyModel.diagnosis.imageStudy.imgResult",
        "short" : "影像報告結果",
        "definition" : "影像報告結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.conclusion"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgBodySite",
        "path" : "ApplyModel.diagnosis.imageStudy.imgBodySite",
        "short" : "影像檢查的身體部位",
        "definition" : "影像檢查的身體部位",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.code.text"
          },
          {
            "identity" : "TWPASImagingStudy",
            "map" : "ImagingStudy.series.bodySite.code"
          },
          {
            "identity" : "TWPASMedia",
            "map" : "Media.bodySite.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDate",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDate",
        "short" : "影像報告日期",
        "definition" : "影像報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgDicom",
        "path" : "ApplyModel.diagnosis.imageStudy.imgDicom",
        "short" : "DICOM影像",
        "definition" : "DICOM影像",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.imagingStudy.reference"
          },
          {
            "identity" : "TWPASImagingStudy",
            "map" : "ImagingStudy.series.instance.uid"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgNonDicom",
        "path" : "ApplyModel.diagnosis.imageStudy.imgNonDicom",
        "short" : "非DICOM影像",
        "definition" : "非DICOM影像",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.media.link.reference"
          },
          {
            "identity" : "TWPASMedia",
            "map" : "Media.contnet.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.imageStudy.imgInterpreter",
        "path" : "ApplyModel.diagnosis.imageStudy.imgInterpreter",
        "short" : "簽發影像報告醫師身分證號",
        "definition" : "簽發影像報告醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReportImage",
            "map" : "DiagnosticReport.performer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.cancerStage",
        "path" : "ApplyModel.diagnosis.cancerStage",
        "short" : "癌症分期量表",
        "definition" : "癌症分期量表",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.cancerStage.assessItem",
        "path" : "ApplyModel.diagnosis.cancerStage.assessItem",
        "short" : "癌症分期量表項目",
        "definition" : "癌症分期量表項目",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'cancerStage').valueReference.reference"
          },
          {
            "identity" : "TWPASObservationCancerStage",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.cancerStage.assessScore",
        "path" : "ApplyModel.diagnosis.cancerStage.assessScore",
        "short" : "癌症分期分數或結果",
        "definition" : "癌症分期分數或結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationCancerStage",
            "map" : "Observation.valueCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.cancerStage.assessDate",
        "path" : "ApplyModel.diagnosis.cancerStage.assessDate",
        "short" : "癌症分期量表評估日期",
        "definition" : "癌症分期量表評估日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationCancerStage",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.cancerStage.assessPerformer",
        "path" : "ApplyModel.diagnosis.cancerStage.assessPerformer",
        "short" : "簽發癌症分期報告醫師身分證號",
        "definition" : "簽發癌症分期報告醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationCancerStage",
            "map" : "Observation.performer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport",
        "path" : "ApplyModel.diagnosis.examinationReport",
        "short" : "檢查報告",
        "definition" : "檢查報告",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportType",
        "path" : "ApplyModel.diagnosis.examinationReport.reportType",
        "short" : "報告類型",
        "definition" : "報告類型。當LOINC無法具體描述檢體種類（例如：`47526-9`時），請填寫及補充說明檢體種類。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.speType",
        "path" : "ApplyModel.diagnosis.examinationReport.speType",
        "short" : "檢體種類",
        "definition" : "檢體種類",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.code.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResult",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResult",
        "short" : "檢查報告結果",
        "definition" : "檢查報告結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultString",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultString",
        "short" : "檢查報告結果（文數字）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.conclusion"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultPdf",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultPdf",
        "short" : "檢查報告結果（檔案路徑）",
        "definition" : "檢查報告結果-文數字與base64Binary應擇一填寫",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'examinationReport').valueReference.reference"
          },
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.presentedForm.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultPdfTitle",
        "path" : "ApplyModel.diagnosis.examinationReport.reportResult.reportResultPdfTitle",
        "short" : "檢查報告名稱",
        "definition" : "檢查報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.presentedForm.title"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportDate",
        "path" : "ApplyModel.diagnosis.examinationReport.reportDate",
        "short" : "報告日期",
        "definition" : "報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.diagnosis.examinationReport.reportPerformer",
        "path" : "ApplyModel.diagnosis.examinationReport.reportPerformer",
        "short" : "檢查報告醫師身分證號",
        "definition" : "檢查報告醫師身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDiagnosticReport",
            "map" : "DiagnosticReport.performer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene",
        "path" : "ApplyModel.gene",
        "short" : "基因資訊",
        "definition" : "基因資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genTestCode",
        "path" : "ApplyModel.gene.genTestCode",
        "short" : "基因檢測代碼",
        "definition" : "基因檢測代碼",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'geneInfo').valueReference.reference"
          },
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.component.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genTestValue",
        "path" : "ApplyModel.gene.genTestValue",
        "short" : "基因檢測實際結果",
        "definition" : "基因檢測實際結果",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.component.value[x]"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.mutationType",
        "path" : "ApplyModel.gene.mutationType",
        "short" : "基因突變類型",
        "definition" : "基因突變類型",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.component.where(code.coding.code = '48019-4').valueCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.specimenType",
        "path" : "ApplyModel.gene.specimenType",
        "short" : "基因檢測檢體類型",
        "definition" : "基因檢測檢體類型",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.specimen.reference"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genMethod",
        "path" : "ApplyModel.gene.genMethod",
        "short" : "基因檢測方法",
        "definition" : "基因檢測方法",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.method.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genDate",
        "path" : "ApplyModel.gene.genDate",
        "short" : "基因檢測日期",
        "definition" : "基因檢測日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genOrg",
        "path" : "ApplyModel.gene.genOrg",
        "short" : "基因檢測機構",
        "definition" : "基因檢測機構",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASOrganization",
            "map" : "Organization.identifier.value"
          },
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.performer.reference"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genResult",
        "path" : "ApplyModel.gene.genResult",
        "short" : "基因檢測分析結果",
        "definition" : "基因檢測分析結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.valueCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genInterpretation",
        "path" : "ApplyModel.gene.genInterpretation",
        "short" : "基因臨床判讀結果",
        "definition" : "基因臨床判讀結果，醫師判讀結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.interpretation.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genPdf",
        "path" : "ApplyModel.gene.genPdf",
        "short" : "基因報告（檔案路徑）",
        "definition" : "基因報告（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationDiagnostic",
            "map" : "Observation.derivedFrom.reference"
          },
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.gene.genPdfTitle",
        "path" : "ApplyModel.gene.genPdfTitle",
        "short" : "基因報告名稱",
        "definition" : "基因報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate",
        "path" : "ApplyModel.evaluate",
        "short" : "評估資訊",
        "definition" : "評估資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests",
        "path" : "ApplyModel.evaluate.tests",
        "short" : "檢驗(查)",
        "definition" : "檢驗(查)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspect",
        "path" : "ApplyModel.evaluate.tests.inspect",
        "short" : "檢驗(查)名稱或套組代碼",
        "definition" : "檢驗(查)名稱或套組代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'tests').valueReference.reference"
          },
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectResultTxt",
        "path" : "ApplyModel.evaluate.tests.inspectResultTxt",
        "short" : "檢驗(查)結果判讀",
        "definition" : "檢驗(查)結果判讀",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.interpretation.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectResult[x]",
        "path" : "ApplyModel.evaluate.tests.inspectResult[x]",
        "short" : "檢驗(查)結果",
        "definition" : "檢驗(查)結果",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.consultValueLower",
        "path" : "ApplyModel.evaluate.tests.consultValueLower",
        "short" : "檢驗(查)結果之參考範圍下限",
        "definition" : "檢驗(查)結果之參考範圍下限",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.referenceRange.low.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.consultValueMax",
        "path" : "ApplyModel.evaluate.tests.consultValueMax",
        "short" : "檢驗(查)結果之參考範圍上限",
        "definition" : "檢驗(查)結果之參考範圍上限",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.referenceRange.high.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.consultValueCat",
        "path" : "ApplyModel.evaluate.tests.consultValueCat",
        "short" : "檢驗(查)結果之參考範圍類型",
        "definition" : "檢驗(查)結果之參考範圍類型",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.referenceRange.type.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.consultValueDesc",
        "path" : "ApplyModel.evaluate.tests.consultValueDesc",
        "short" : "檢驗(查)結果之參考範圍說明",
        "definition" : "檢驗(查)結果之參考範圍說明",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.referenceRange.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectSet",
        "path" : "ApplyModel.evaluate.tests.inspectSet",
        "short" : "套組中的的檢驗",
        "definition" : "套組中的的檢驗",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Observation"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.component"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.caseTime",
        "path" : "ApplyModel.evaluate.tests.caseTime",
        "short" : "檢驗(查)報告日期",
        "definition" : "檢驗(查)報告日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectPdf",
        "path" : "ApplyModel.evaluate.tests.inspectPdf",
        "short" : "檢驗(查)附件（檔案路徑）",
        "definition" : "檢驗(查)附件（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.derivedFrom.reference"
          },
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectPdfTitle",
        "path" : "ApplyModel.evaluate.tests.inspectPdfTitle",
        "short" : "檢驗(查)附件名稱",
        "definition" : "檢驗(查)附件名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.tests.inspectPerformer",
        "path" : "ApplyModel.evaluate.tests.inspectPerformer",
        "short" : "簽發檢驗(查)報告醫事人員身分證號",
        "definition" : "簽發檢驗(查)報告醫事人員身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationLaboratoryResult",
            "map" : "Observation.performer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment",
        "path" : "ApplyModel.evaluate.patientAssessment",
        "short" : "病人狀態評估",
        "definition" : "病人狀態評估",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAst",
        "path" : "ApplyModel.evaluate.patientAssessment.patAst",
        "short" : "病人狀態評估項目代碼",
        "definition" : "病人狀態評估項目代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'patientAssessment').valueReference.reference"
          },
          {
            "identity" : "TWPASObservationPatientAssessment",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAstResult",
        "path" : "ApplyModel.evaluate.patientAssessment.patAstResult",
        "short" : "病人狀態評估結果",
        "definition" : "病人狀態評估結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationPatientAssessment",
            "map" : "Observation.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAstDate",
        "path" : "ApplyModel.evaluate.patientAssessment.patAstDate",
        "short" : "病人狀態評估日期",
        "definition" : "病人狀態評估日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationPatientAssessment",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAstPdf",
        "path" : "ApplyModel.evaluate.patientAssessment.patAstPdf",
        "short" : "病人狀態評估報告（檔案路徑）",
        "definition" : "病人狀態評估報告（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAstPdfTitle",
        "path" : "ApplyModel.evaluate.patientAssessment.patAstPdfTitle",
        "short" : "病人狀態評估報告名稱",
        "definition" : "病人狀態評估報告名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ApplyModel.evaluate.patientAssessment.patAstPerformer",
        "path" : "ApplyModel.evaluate.patientAssessment.patAstPerformer",
        "short" : "評估項目醫事人員身分證號",
        "definition" : "評估項目醫事人員身分證號",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationPatientAssessment",
            "map" : "Observation.performer.reference"
          },
          {
            "identity" : "TWPASPractitioner",
            "map" : "Practitioner.identifier.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat",
        "path" : "ApplyModel.treat",
        "short" : "治療資訊",
        "definition" : "治療資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest",
        "path" : "ApplyModel.treat.medicationRequest",
        "short" : "用藥品項",
        "definition" : "用藥品項",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.drugType",
        "path" : "ApplyModel.treat.medicationRequest.drugType",
        "short" : "自費註記",
        "definition" : "自費註記",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.category.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.drugStatus",
        "path" : "ApplyModel.treat.medicationRequest.drugStatus",
        "short" : "藥物使用狀態",
        "definition" : "藥物使用狀態",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.status"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.drugCode",
        "path" : "ApplyModel.treat.medicationRequest.drugCode",
        "short" : "藥品代碼",
        "definition" : "藥品代碼",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'medicationRequest').valueReference.reference"
          },
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.medicationCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.drugFre",
        "path" : "ApplyModel.treat.medicationRequest.drugFre",
        "short" : "藥品使用頻率及服用時間",
        "definition" : "藥品使用頻率及服用時間",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.code.text"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.drugRoute",
        "path" : "ApplyModel.treat.medicationRequest.drugRoute",
        "short" : "給藥途徑／作用部位",
        "definition" : "給藥途徑／作用部位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.route"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.dose",
        "path" : "ApplyModel.treat.medicationRequest.dose",
        "short" : "藥物每次處方劑量",
        "definition" : "藥物每次處方劑量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.doseUnit",
        "path" : "ApplyModel.treat.medicationRequest.doseUnit",
        "short" : "藥物每次處方劑量單位",
        "definition" : "藥物每次處方劑量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.sDate",
        "path" : "ApplyModel.treat.medicationRequest.sDate",
        "short" : "藥物處方起始日期",
        "definition" : "藥物處方起始日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.boundsPeriod.start"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.eDate",
        "path" : "ApplyModel.treat.medicationRequest.eDate",
        "short" : "藥物處方終止日期",
        "definition" : "藥物處方終止日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.boundsPeriod.end"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.medicationRequest.eReason",
        "path" : "ApplyModel.treat.medicationRequest.eReason",
        "short" : "藥物處方終止原因",
        "definition" : "藥物處方終止原因",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestTreat",
            "map" : "MedicationRequest.statusReason"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy",
        "path" : "ApplyModel.treat.radiotherapy",
        "short" : "放射/照光治療",
        "definition" : "放射/照光治療",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy.rt",
        "path" : "ApplyModel.treat.radiotherapy.rt",
        "short" : "放射/照光治療項目",
        "definition" : "放射/照光治療項目",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'radiotherapy').valueReference.reference"
          },
          {
            "identity" : "TWPASProcedure",
            "map" : "Procedure.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy.rtStatus",
        "path" : "ApplyModel.treat.radiotherapy.rtStatus",
        "short" : "放射/照光治療狀態",
        "definition" : "放射/照光治療狀態",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASProcedure",
            "map" : "Procedure.status"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy.realInspectTime",
        "path" : "ApplyModel.treat.radiotherapy.realInspectTime",
        "short" : "放射/照光治療日期",
        "definition" : "放射/照光治療日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASProcedure",
            "map" : "Procedure.performedDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy.rtDose",
        "path" : "ApplyModel.treat.radiotherapy.rtDose",
        "short" : "放射/照光治療總劑量",
        "definition" : "放射/照光治療總劑量",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASProcedure",
            "map" : "Procedure.usedReference.reference"
          },
          {
            "identity" : "TWPASSubstance",
            "map" : "Substance.ingredient.quantity.numerator.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.radiotherapy.rtUnit",
        "path" : "ApplyModel.treat.radiotherapy.rtUnit",
        "short" : "放射/照光治療總劑量單位",
        "definition" : "放射/照光治療總劑量單位",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASSubstance",
            "map" : "Substance.ingredient.quantity.numerator.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.opCode",
        "path" : "ApplyModel.treat.opCode",
        "short" : "手術(或其他處置)項目",
        "definition" : "手術(或其他處置)項目",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.procedure.procedureCodeableConcept.coding"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.opDate",
        "path" : "ApplyModel.treat.opDate",
        "short" : "手術(或其他處置)日期",
        "definition" : "手術(或其他處置)日期",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.procedure.date"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.carePlanDocument",
        "path" : "ApplyModel.treat.carePlanDocument",
        "short" : "治療計畫文件（檔案路徑）",
        "definition" : "治療計畫文件（檔案路徑）",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'carePlanDocument').valueReference.reference"
          },
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "ApplyModel.treat.carePlanDocumentTitle",
        "path" : "ApplyModel.treat.carePlanDocumentTitle",
        "short" : "治療計畫文件名稱",
        "definition" : "治療計畫文件名稱",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASDocumentReference",
            "map" : "DocumentReference.content.attachment.title"
          }
        ]
      },
      {
        "id" : "ApplyModel.result",
        "path" : "ApplyModel.result",
        "short" : "結果資訊",
        "definition" : "結果資訊",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.result.txAst",
        "path" : "ApplyModel.result.txAst",
        "short" : "治療後疾病狀態評估項目",
        "definition" : "治療後疾病狀態評估項目",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.supportingInfo.where(category.coding.code = 'treatmentAssessment').valueReference.reference"
          },
          {
            "identity" : "TWPASObservationTreatmentAssessment",
            "map" : "Observation.code.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.result.txAstResult",
        "path" : "ApplyModel.result.txAstResult",
        "short" : "治療後疾病狀態評估結果",
        "definition" : "治療後疾病狀態評估結果",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationTreatmentAssessment",
            "map" : "Observation.valueString"
          }
        ]
      },
      {
        "id" : "ApplyModel.result.txAstDate",
        "path" : "ApplyModel.result.txAstDate",
        "short" : "治療後疾病狀態評估日期",
        "definition" : "治療後疾病狀態評估日期",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASObservationTreatmentAssessment",
            "map" : "Observation.effectiveDateTime"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply",
        "path" : "ApplyModel.apply",
        "short" : "申請項目",
        "definition" : "申請項目",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.continuation",
        "path" : "ApplyModel.apply.continuation",
        "short" : "續用註記",
        "definition" : "續用註記",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.modifier.where(coding.system = 'https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status').coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.lot",
        "path" : "ApplyModel.apply.lot",
        "short" : "用藥線別",
        "definition" : "用藥線別",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.modifier.where(coding.system = 'https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy').coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.orderType",
        "path" : "ApplyModel.apply.orderType",
        "short" : "醫令類別",
        "definition" : "醫令類別",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.productOrService.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.cancerDrugType",
        "path" : "ApplyModel.apply.cancerDrugType",
        "short" : "事前審查品項代碼",
        "definition" : "事前審查品項代碼",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.extension.where(url = 'https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService').valueReference.reference"
          },
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.medicationCodeableConcept.coding.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applyReason",
        "path" : "ApplyModel.apply.applyReason",
        "short" : "給付適應症條件",
        "definition" : "給付適應症條件",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.programCode"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applySide",
        "path" : "ApplyModel.apply.applySide",
        "short" : "申請部位",
        "definition" : "申請部位",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.bodySite"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applQty",
        "path" : "ApplyModel.apply.applQty",
        "short" : "事前審查申請數量",
        "definition" : "事前審查申請數量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.quantity.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applQtyUnit",
        "path" : "ApplyModel.apply.applQtyUnit",
        "short" : "事前審查申請數量單位",
        "definition" : "事前審查申請數量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaim",
            "map" : "Claim.item.quantity.code"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applDrugFre",
        "path" : "ApplyModel.apply.applDrugFre",
        "short" : "事前審查藥品使用頻率及服用時間",
        "definition" : "事前審查藥品使用頻率及服用時間",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.code.coding"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applDrugRoute",
        "path" : "ApplyModel.apply.applDrugRoute",
        "short" : "給藥途徑／作用部位",
        "definition" : "給藥途徑／作用部位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.route"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applDosage",
        "path" : "ApplyModel.apply.applDosage",
        "short" : "事前審查藥品每次處方劑量",
        "definition" : "事前審查藥品每次處方劑量",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].value"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applDosageUnit",
        "path" : "ApplyModel.apply.applDosageUnit",
        "short" : "事前審查藥品每次處方劑量單位",
        "definition" : "事前審查藥品每次處方劑量單位",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].unit"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.useSdate",
        "path" : "ApplyModel.apply.useSdate",
        "short" : "事前審查藥物預定處方起始日期",
        "definition" : "事前審查藥物預定處方起始日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].start"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.useEdate",
        "path" : "ApplyModel.apply.useEdate",
        "short" : "事前審查藥物預定處方終止日期",
        "definition" : "事前審查藥物預定處方終止日期",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x].end"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.applDrugCycle",
        "path" : "ApplyModel.apply.applDrugCycle",
        "short" : "事前審查藥品療程／週期數",
        "definition" : "事前審查藥品療程／週期數",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASMedicationRequestApply",
            "map" : "MedicationRequest.dosageInstruction.timing.repeat.count"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.approver",
        "path" : "ApplyModel.apply.approver",
        "short" : "審查委員身分證號",
        "definition" : "審查委員身分證號",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaimResponseSelfAssessment",
            "map" : "ClaimResponse.extension:requestor"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.approveDate",
        "path" : "ApplyModel.apply.approveDate",
        "short" : "核定日期",
        "definition" : "核定日期",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaimResponseSelfAssessment",
            "map" : "ClaimResponse.created"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.approveComment",
        "path" : "ApplyModel.apply.approveComment",
        "short" : "受理審查案件核定註記",
        "definition" : "受理審查案件核定註記",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.adjudication.reason"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.approveNum",
        "path" : "ApplyModel.apply.approveNum",
        "short" : "審查結果數量",
        "definition" : "審查結果數量",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.adjudication.value"
          }
        ]
      },
      {
        "id" : "ApplyModel.apply.acceptanceStatus",
        "path" : "ApplyModel.apply.acceptanceStatus",
        "short" : "個別醫令核定註記",
        "definition" : "個別醫令核定註記",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPASClaimResponseSelfAssessment",
            "map" : "ClaimResponse.item.detail.adjudication.reason"
          }
        ]
      }
    ]
  }
}

```
