# 影像 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **影像**

## Example ImagingStudy: 影像

Profile：[DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md)

**狀態**：registered

**病人**：[Patient/pat-min](Patient-pat-min.md) "王大明"

**Study UID**：urn:oid:2.16.886.2102.54.4546465747.465465465

**Series Instance UID**：2.16.886.2102.54.4546465747.465465466

**SOP Instance UIDs**：2.25.88017001449189502323411118737039844241, 2.25.88017001449189502323411118737039844242

**影像檢查的身體部位**：Head and neck structure([SNOMED CT](http://snomed.info/sct)#774007)

**儀器**：CT Image Storage([DICOM](https://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html)#CT)



## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "imaStu-min",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:dicom:uid",
      "value" : "urn:oid:2.16.886.2102.54.4546465747.465465465"
    }
  ],
  "status" : "registered",
  "subject" : {
    "reference" : "Patient/pat-min"
  },
  "series" : [
    {
      "uid" : "2.16.886.2102.54.4546465747.465465466",
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "CT"
      },
      "bodySite" : {
        "system" : "http://snomed.info/sct",
        "code" : "774007",
        "display" : "Head and neck structure"
      },
      "instance" : [
        {
          "uid" : "2.25.88017001449189502323411118737039844241",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          }
        },
        {
          "uid" : "2.25.88017001449189502323411118737039844242",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          }
        }
      ]
    }
  ]
}

```
