# NHI-健保事前審查-用藥品項 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI-健保事前審查-用藥品項**

## CodeSystem: NHI-健保事前審查-用藥品項 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication | *Version*:1.1.0 |
| Active as of 2025-10-23 | *Computable Name*:NHIMedicationCodes |

 
NHI-健保事前審查-用藥品項，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年4月查詢檔(帶走所有壓縮檔114.4.2更新)」。 
代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，相關代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NHIMedication](ValueSet-nhi-medication.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nhi-medication",
  "url" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-medication",
  "version" : "1.1.0",
  "name" : "NHIMedicationCodes",
  "title" : "NHI-健保事前審查-用藥品項",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-23",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "NHI-健保事前審查-用藥品項，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年4月查詢檔(帶走所有壓縮檔114.4.2更新)」。  \n\n代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*  \n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，相關代碼可至[健保用藥品項網路查詢服務](https://info.nhi.gov.tw/INAE3000/INAE3000S01)查閱。",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 44956,
  "concept" : [
    {
      "code" : "X000353100",
      "display" : "\"MYCOBUTIN 150 MG CAPSULES\""
    },
    {
      "code" : "KC01177224",
      "display" : "RYBREVANT CONCENTRATE FOR SOLUTION FOR INFUSION 50MG/ML"
    },
    {
      "code" : "AC36041109",
      "display" : "SUCA GRANULE FOR SUSPENSION 1GM/1.02GM(SUCRALFATE)"
    },
    {
      "code" : "AC61930421",
      "display" : "BRIMONIN OPHTHALMIC SOLUTION 0.15%"
    },
    {
      "code" : "AC61930429",
      "display" : "BRIMONIN OPHTHALMIC SOLUTION 0.15%"
    },
    {
      "code" : "BC28893414",
      "display" : "PHARTAN EYE DROPS"
    },
    {
      "code" : "AC24016114",
      "display" : "ERYSONE GRANULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "KC00887243",
      "display" : "MIRCERA SOLUTION FOR INJECTION IN PRE-FILLED SYRINGE 30 MCG/0.3 ML"
    },
    {
      "code" : "AC61948100",
      "display" : "GLULIVAN F.C. TABLETS 100MG"
    },
    {
      "code" : "AC473071G0",
      "display" : "\"GLUCOCAR TABLETS \"S.C.\"(鋁箔)\""
    },
    {
      "code" : "AC61924100",
      "display" : "\"SITAWIN F.C. TABLETS 100 MG \"S.C.\"\""
    },
    {
      "code" : "AC49134329",
      "display" : "GENTERMAY OINTMENT"
    },
    {
      "code" : "AC49129329",
      "display" : "GENTERMAY CREAM"
    },
    {
      "code" : "AC61955100",
      "display" : "Sorafenib F.C. Tablets 200 mg “C.C.P.C.”"
    },
    {
      "code" : "BC208951G0",
      "display" : "VOLTAREN RETARD 75MG SLOW RELEASE FILM-COATED TABLETS(鋁箔/膠箔)"
    },
    {
      "code" : "BC28921100",
      "display" : "DUTASTAM CAPSULES"
    },
    {
      "code" : "AC61941100",
      "display" : "SUGARVISE F.C. TABLETS 100 MG “ L.L.”"
    },
    {
      "code" : "BC28718100",
      "display" : "Focuson Extended Release Tablets 54 mg"
    },
    {
      "code" : "BC28719100",
      "display" : "Focuson Extended Release Tablets 27 mg"
    },
    {
      "code" : "BC28816100",
      "display" : "Focuson Extended Release Tablets 36 mg"
    },
    {
      "code" : "BC28898100",
      "display" : "URGECARE SUBLINGUAL TABLETS 60 ΜG"
    },
    {
      "code" : "BC28899100",
      "display" : "URGECARE SUBLINGUAL TABLETS 240 ΜG"
    },
    {
      "code" : "BC28912100",
      "display" : "FOCUSON EXTENDED RELEASE TABLETS 18 MG"
    },
    {
      "code" : "BC28930100",
      "display" : "MIXALL TABLETS 40/5/12.5 MG"
    },
    {
      "code" : "BC28931100",
      "display" : "MIXALL TABLETS 40/10/25 MG"
    },
    {
      "code" : "BC28932100",
      "display" : "MIXALL TABLETS 40/10/12.5 MG"
    },
    {
      "code" : "BC28933100",
      "display" : "MIXALL TABLETS 20/5/12.5 MG"
    },
    {
      "code" : "AC61964100",
      "display" : "Sitarmet F.C. Tablets 50/500 mg"
    },
    {
      "code" : "AC61965100",
      "display" : "SITARMET F.C. TABLETS 50/850 MG"
    },
    {
      "code" : "BC28683100",
      "display" : "Abiraterone Sandoz Film Coated Tablets 250mg"
    },
    {
      "code" : "BC28684100",
      "display" : "Abiraterone Sandoz Film Coated Tablets 500mg"
    },
    {
      "code" : "AC61961116",
      "display" : "ACTEIN GRANULES 600MG"
    },
    {
      "code" : "KC01276263",
      "display" : "Minjuvi powder for concentrate for solution for infusion 200 mg"
    },
    {
      "code" : "BC28860100",
      "display" : "OMJJARA Film-Coated Tablets 100 mg"
    },
    {
      "code" : "BC28861100",
      "display" : "OMJJARA Film-Coated Tablets 150 mg"
    },
    {
      "code" : "BC28862100",
      "display" : "OMJJARA Film-Coated Tablets 200 mg"
    },
    {
      "code" : "BC28959100",
      "display" : "VANFLYTA F.C. TABLETS 17.7 MG"
    },
    {
      "code" : "BC28963100",
      "display" : "Vanflyta F.C. Tablets 26.5 mg"
    },
    {
      "code" : "YC00055212",
      "display" : "PIASKY for Injection"
    },
    {
      "code" : "KC01288209",
      "display" : "XGEVA solution for injection in pre-filled syringe 120 mg"
    },
    {
      "code" : "BC28907100",
      "display" : "LINAGLIPTIN/METFORMIN SANDOZ FILM COATED TABLETS 2.5/850MG"
    },
    {
      "code" : "X000352265",
      "display" : "ACTAVIR 250 (POWDER FOR SOLUTION FOR INFUSION"
    },
    {
      "code" : "X000349257",
      "display" : "AGILUS(DANTROLENE SODIUM HEMIHEPTAHYDRATE)POWDER FOR SOLUTION FOR INJECTION 120MG/VIAL"
    },
    {
      "code" : "AC61845421",
      "display" : "XINCLAME OPHTHALMIC SOLUTION"
    },
    {
      "code" : "KC01155257",
      "display" : "Remsima Solution for injection"
    },
    {
      "code" : "BC28556100",
      "display" : "SCEMBLIX 40MG FILM-COATED TABLETS"
    },
    {
      "code" : "JC00089206",
      "display" : "\"TETANUS TOXOID ALUM PRECIPITATED \"KUO KWANG\"\""
    },
    {
      "code" : "BC28106148",
      "display" : "QINLOCK TABLET 50MG"
    },
    {
      "code" : "KC01142235",
      "display" : "Darzalex 1800mg solution for subcutaneous injection"
    },
    {
      "code" : "BC28878100",
      "display" : "GLINSIP 50 (SITAGLIPTIN TABLETS 50 MG)"
    },
    {
      "code" : "BC28877100",
      "display" : "GLINSIP 25 (Sitagliptin Tablets 25 mg)"
    },
    {
      "code" : "BC28876100",
      "display" : "CANDESARTAN CILEXETIL AND HYDROCHLOROTHIAZIDE 16 MG/12.5 MG TABLETS ”Y.K.”"
    },
    {
      "code" : "AC451721G0",
      "display" : "VASTRIL TABLETS 10MG(鋁箔)"
    },
    {
      "code" : "AC488981G0",
      "display" : "\"LITACARBOSE TABLETS 50MG \"LITA\"(鋁箔)\""
    },
    {
      "code" : "AC501421G0",
      "display" : "HYDROQUINE FILM COATED TABLETS 200MG(鋁箔)"
    },
    {
      "code" : "AC61417159",
      "display" : "\"SMECTITE ORAL SUSPENSION 200MG/ML \"CENTER\"\""
    },
    {
      "code" : "AC384221G0",
      "display" : "CARTIL TABLETS 60MG(鋁箔)"
    },
    {
      "code" : "AC495041G0",
      "display" : "BISO F.C. TABLETS 1.25 MG(鋁箔)"
    },
    {
      "code" : "KC01245236",
      "display" : "VEGZELMA CONCENTRATE FOR SOLUTION FOR INFUSION"
    },
    {
      "code" : "AC61932100",
      "display" : "EUBIVAL F.C. TABLETS 100MG"
    },
    {
      "code" : "NC017831GA",
      "display" : "\"UROGEN F.C. TABLETS \"JOHNSON\"(鋁箔)\""
    },
    {
      "code" : "AC619283FA",
      "display" : "RIVA PATCH 5"
    },
    {
      "code" : "BC28851100",
      "display" : "ZENORA FILM-COATED TABLETS 250 MG"
    },
    {
      "code" : "BC28852100",
      "display" : "ZENORA FILM-COATED TABLETS 500 MG"
    },
    {
      "code" : "BC28868100",
      "display" : "DIHYPE FILM COATED TABLETS 5/40 MG"
    },
    {
      "code" : "BC28869100",
      "display" : "DIHYPE FILM COATED TABLETS 5/20 MG"
    },
    {
      "code" : "BC28870100",
      "display" : "DIHYPE FILM COATED TABLETS 10/40 MG"
    },
    {
      "code" : "BC28896100",
      "display" : "WINTEX FILM-COATED TABLETS 360 MG"
    },
    {
      "code" : "AC61942271",
      "display" : "TARIKIN LYO-INJECTION 400MG"
    },
    {
      "code" : "AC61943263",
      "display" : "TARIKIN LYO-INJECTION 200MG"
    },
    {
      "code" : "AC61934100",
      "display" : "COMTOFF 50/850 MG FILM-COATED TABLETS"
    },
    {
      "code" : "AC61935100",
      "display" : "COMTOFF 50/500 MG FILM-COATED TABLETS"
    },
    {
      "code" : "AC61926100",
      "display" : "OLMECA HCTZ TABLETS 5/40/12.5 MG"
    },
    {
      "code" : "AC61949155",
      "display" : "CEN-CAPTO ORAL SOLUTION 1 MG/ML〝CENTER〞"
    },
    {
      "code" : "KC01145221",
      "display" : "REVESTIVE INJECTION 5MG"
    },
    {
      "code" : "KC01232214",
      "display" : "Columvi solution for infusion"
    },
    {
      "code" : "KC01232229",
      "display" : "Columvi solution for infusion"
    },
    {
      "code" : "KC012592A3",
      "display" : "EPKINLY Solution for Injection 48 mg/0.8 mL"
    },
    {
      "code" : "KC012602A3",
      "display" : "EPKINLY Solution for Injection 4 mg/0.8 mL"
    },
    {
      "code" : "BC28428100",
      "display" : "RINVOQ Extended-Release Tablets 45 mg"
    },
    {
      "code" : "AC05886229",
      "display" : "MORPHINE HYDROCHLORIDE INJECTION 20MG/ML"
    },
    {
      "code" : "AC61952100",
      "display" : "“PPCD” OXYCODONE HYDROCHLORIDE IMMEDIATE RELEASE CAPSULES 5 MG"
    },
    {
      "code" : "BC28888100",
      "display" : "RIVAROXABAN SANDOZ FILM-COATED TABLETS 10MG"
    },
    {
      "code" : "BC28889100",
      "display" : "RIVAROXABAN SANDOZ FILM-COATED TABLETS 20MG"
    },
    {
      "code" : "X000350100",
      "display" : "FLORINEF TABLETS 0.1MG"
    },
    {
      "code" : "X000351221",
      "display" : "NIMBEX 2 MG/ML SOLUZIONE INIETTABILE/PER INFUSIONE (CISATRACURIUM)"
    },
    {
      "code" : "X000350421",
      "display" : "CYSTADROPS 3.8MG/ML EYE DROPS SOLUTION"
    },
    {
      "code" : "BC28902100",
      "display" : "VILGLAD (VILDAGLIPTIN TABLETS 50 MG)"
    },
    {
      "code" : "AC61916100",
      "display" : "ADCIRCA FILM-COATED TABLETS 20 MG"
    },
    {
      "code" : "BC28554100",
      "display" : "SOTYKTU film-coated tablets 6mg"
    },
    {
      "code" : "BC27243100",
      "display" : "UPTRAVI (CM) film-coated tablets 200 mcg"
    },
    {
      "code" : "BC27245100",
      "display" : "UPTRAVI (CM) film-coated tablets 600 mcg"
    },
    {
      "code" : "BC27246100",
      "display" : "UPTRAVI (CM) film-coated tablets 800 mcg"
    },
    {
      "code" : "BC28789100",
      "display" : "TULIP“SDZ” FILM COATED TABLET 10MG"
    },
    {
      "code" : "BC28788100",
      "display" : "TULIP“SDZ” FILM COATED TABLET 20MG"
    },
    {
      "code" : "BC28787100",
      "display" : "TULIP“SDZ” FILM COATED TABLET 40MG"
    },
    {
      "code" : "AC61865321",
      "display" : "\"CLOBURATE CREAM 0.5MG/GM \"SINPHAR\"\""
    },
    {
      "code" : "BC28841100",
      "display" : "TICAGRELOR SANDOZ FILM COATED TABLETS 90MG"
    },
    {
      "code" : "BC28857100",
      "display" : "OLMECARD A 10/40 (AMLODIPINE AND OLMESARTAN MEDOXOMIL TABLETS 10 MG / 40 MG)"
    },
    {
      "code" : "BC28856100",
      "display" : "OLMECARD A 5/40 (AMLODIPINE AND OLMESARTAN MEDOXOMIL TABLETS 5 MG / 40 MG)"
    },
    {
      "code" : "BC28858100",
      "display" : "OLMECARD A 5/20 (AMLODIPINE AND OLMESARTAN MEDOXOMIL TABLETS 5 MG / 20 MG)"
    },
    {
      "code" : "AC61581312",
      "display" : "GENDELIN CREAM"
    },
    {
      "code" : "AC45186330",
      "display" : "KOLINCIN GEL 10MG/G"
    },
    {
      "code" : "AC45186340",
      "display" : "KOLINCIN GEL 10MG/G"
    },
    {
      "code" : "AC61883100",
      "display" : "CYMLUTINE CAPSULES 20MG"
    },
    {
      "code" : "BC28880100",
      "display" : "GLINSIP 100 (SITAGLIPTIN TABLETS 100 MG)"
    },
    {
      "code" : "BC28806100",
      "display" : "ARITERO 15 (ARIPIPRAZOLE TABLETS 15 MG)"
    },
    {
      "code" : "AC61872421",
      "display" : "KETOLAKU OPHTHALMIC SOLUTION 0.5%"
    },
    {
      "code" : "AC61873248",
      "display" : "CASPOCURE FOR INJECTION 50 MG"
    },
    {
      "code" : "AC61890100",
      "display" : "OXAPRESS F.C. TABLETS 5/20MG"
    },
    {
      "code" : "BC28758212",
      "display" : "DEXDOR INJECTION 100MCG/ML CONCENTRATE FOR SOLUTION FOR INFUSION"
    },
    {
      "code" : "AC57169116",
      "display" : "SMECTIN POWDER FOR ORAL SUSPENSION 3G/SACHET"
    },
    {
      "code" : "AC61918100",
      "display" : "GLUPHOR 50/850 MG FILM-COATED TABLETS"
    },
    {
      "code" : "AC61919100",
      "display" : "GLUPHOR 50/500 MG FILM-COATED TABLETS"
    },
    {
      "code" : "AC61870100",
      "display" : "NIFIBRO SOFT CAPSULE 150 MG"
    },
    {
      "code" : "AC61871100",
      "display" : "NIFIBRO SOFT CAPSULE 100 MG"
    },
    {
      "code" : "AC618942E2",
      "display" : "FUNGIPOSA 18 MG/ML CONCENTRATE FOR SOLUTION FOR INFUSION"
    },
    {
      "code" : "AC03019100",
      "display" : "WEITUMON TABLETS"
    },
    {
      "code" : "AC030191G0",
      "display" : "WEITUMON TABLETS(鋁箔)"
    },
    {
      "code" : "AC61885100",
      "display" : "Betizine Extended Release Tablets 36mg"
    },
    {
      "code" : "AC61911100",
      "display" : "SITARNY F.C. TABLETS 100 MG"
    },
    {
      "code" : "AC491293AK",
      "display" : "GENTERMAY CREAM"
    },
    {
      "code" : "AC491343AK",
      "display" : "Gentermay Ointment"
    },
    {
      "code" : "AC61914100",
      "display" : "SIGTAMET FILM-COATED TABLETS 50/500MG"
    },
    {
      "code" : "AC61929100",
      "display" : "SITAMET F.C.TABLETS 50/500MG?C.H.〃"
    },
    {
      "code" : "NC017271G0",
      "display" : "\"SODIUM BICARBONATE COMPOUND TABLETS \"JOHNSON\"(鋁箔)\""
    },
    {
      "code" : "KC01252216",
      "display" : "KAULIV 20 MICROGRAMS/ 80 MICROLITERS SOLUTION FOR INJECTION"
    },
    {
      "code" : "X000349100",
      "display" : "RAXONE 150MG FILM-COATED TABLET"
    },
    {
      "code" : "KC01258235",
      "display" : "TECENTRIQ SOLUTION FOR SUBCUTANEOUS INJECTION"
    },
    {
      "code" : "AC619103CS",
      "display" : "FENTANYL TRANSDERMAL PATCH 50 μg/hr“PPCD”"
    },
    {
      "code" : "A000015421",
      "display" : "YEN KUANG EYE DROPS"
    },
    {
      "code" : "A000015435",
      "display" : "YEN KUANG EYE DROPS"
    },
    {
      "code" : "A000023100",
      "display" : "NYDRAZID TABLETS 100MG"
    },
    {
      "code" : "A000026157",
      "display" : "VI-GRANS LIQUID"
    },
    {
      "code" : "A000058172",
      "display" : "MEWEILY GRANULES \"TOLIN\""
    },
    {
      "code" : "A000058199",
      "display" : "MEWEILY GRANULES \"TOLIN\""
    },
    {
      "code" : "A000059100",
      "display" : "Diapin Tablets 2mg (Diazepam) \"Pine Lawer\""
    },
    {
      "code" : "A0000591G0",
      "display" : "Diapin Tablets 2mg (Diazepam) \"Pine Lawer\""
    },
    {
      "code" : "A000060100",
      "display" : "Diapin Tablets 5mg (Diazepam) \"Pine Lawer\""
    },
    {
      "code" : "A0000601G0",
      "display" : "Diapin Tablets 5mg (Diazepam) \"Pine Lawer\""
    },
    {
      "code" : "A000072100",
      "display" : "EPHEDRINE HCL TABLETS 25MG \"H.S.\""
    },
    {
      "code" : "A000076100",
      "display" : "ACETAMINOPHEN TABLETS 0.3 GM \"F.Y.\""
    },
    {
      "code" : "A000080277",
      "display" : "KEFLODIN INJECTION 0.5GM"
    },
    {
      "code" : "A000081100",
      "display" : "TETRACIN CAPSULES"
    },
    {
      "code" : "A000085100",
      "display" : "KESONTON CAPSULES"
    },
    {
      "code" : "A000086100",
      "display" : "SINOMIN TABLETS 500 MG"
    },
    {
      "code" : "A000090100",
      "display" : "FISHERMAN STRONG LIVER OIL CAPSULES"
    },
    {
      "code" : "A000096100",
      "display" : "MENNA CAPSULES"
    },
    {
      "code" : "A000098100",
      "display" : "EACO-15MG S.C. TABLETS"
    },
    {
      "code" : "A000106100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"SYNMOSA\""
    },
    {
      "code" : "A000111100",
      "display" : "ESTRIOL TABLETS \"HONTEN\""
    },
    {
      "code" : "A000118100",
      "display" : "EPHEDRINE HCL TABLETS 25 MG \"F.Y.\""
    },
    {
      "code" : "A0001181G0",
      "display" : "EPHEDRINE HCL TABLETS 25 MG \"F.Y.\""
    },
    {
      "code" : "A000119100",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS 25.MG \"F.Y.\""
    },
    {
      "code" : "A0001191G0",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS 25.MG \"F.Y.\""
    },
    {
      "code" : "A000133209",
      "display" : "PROLUTON DEPOT INJECTION 250 MG"
    },
    {
      "code" : "A000134209",
      "display" : "TESTOVIRON DEPOT INJECTION 100 MG"
    },
    {
      "code" : "A000135321",
      "display" : "ULTRALANUM OINTMENT"
    },
    {
      "code" : "A000135329",
      "display" : "ULTRALANUM OINTMENT"
    },
    {
      "code" : "A000137151",
      "display" : "BROWN MIXTURE LIQUID (WITHOUT OPIUM)"
    },
    {
      "code" : "A000138209",
      "display" : "TESTOVIRON DEPOT INJECTION 250 MG"
    },
    {
      "code" : "A000152100",
      "display" : "PUCOPIN TABLETS"
    },
    {
      "code" : "A000164100",
      "display" : "NITROGLYCERIN TABLETS \"NYSCO\""
    },
    {
      "code" : "A000173100",
      "display" : "FUDECOUGH TABLETS 15MG \"F.Y.\""
    },
    {
      "code" : "A000175100",
      "display" : "FUDECOUGH TABLETS 10MG \"F.Y.\""
    },
    {
      "code" : "A000177100",
      "display" : "MUSCOL TABLETS 250MG"
    },
    {
      "code" : "A000178100",
      "display" : "APREZIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A0001781G0",
      "display" : "APREZIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A000181209",
      "display" : "PRIMODIAN DEPOT INJECTION"
    },
    {
      "code" : "A000186100",
      "display" : "DUOLUTON S.C. TABLETS"
    },
    {
      "code" : "A000197100",
      "display" : "CHLORAMPHENICOL CAPSULES 250MG \"C.M.\""
    },
    {
      "code" : "A000199100",
      "display" : "LASIX TABLETS"
    },
    {
      "code" : "A000207177",
      "display" : "MYLANTA LIQUID"
    },
    {
      "code" : "A000207199",
      "display" : "MYLANTA LIQUID"
    },
    {
      "code" : "A000208100",
      "display" : "MYLANTA TABLETS"
    },
    {
      "code" : "A000209100",
      "display" : "DISON TABLETS \"VEI MIN\""
    },
    {
      "code" : "A000215100",
      "display" : "TERBOLAN TABLETS"
    },
    {
      "code" : "A000260277",
      "display" : "COMPOUND SODIUM LACTATE INJECTION \"Y.F.\""
    },
    {
      "code" : "A000263209",
      "display" : "DEXTROSE 2.5％ AND SODIUM CHLORIDE 0.45％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A000263265",
      "display" : "DEXTROSE 2.5％ AND SODIUM CHLORIDE 0.45％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A000263277",
      "display" : "DEXTROSE 2.5％ AND SODIUM CHLORIDE 0.45％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A000264421",
      "display" : "SCHEROSON F OPHTHALMICUM"
    },
    {
      "code" : "A000315100",
      "display" : "CYPRODIN TABLETS"
    },
    {
      "code" : "A000373100",
      "display" : "PELITIN CAPSULES"
    },
    {
      "code" : "A000389100",
      "display" : "LUXSON TABLETS 40MG"
    },
    {
      "code" : "A000415100",
      "display" : "GASMIN TABLETS \"F.Y.\""
    },
    {
      "code" : "A000419209",
      "display" : "DEXASONLIN INJECTION \"SINTON\""
    },
    {
      "code" : "A000419212",
      "display" : "DEXASONLIN INJECTION \"SINTON\""
    },
    {
      "code" : "A000419229",
      "display" : "DEXASONLIN INJECTION \"SINTON\""
    },
    {
      "code" : "A000420100",
      "display" : "REIZER S.C. TABLETS 100 MG \"F.Y.\""
    },
    {
      "code" : "A000428100",
      "display" : "SECOPON S.C. TABLETS"
    },
    {
      "code" : "A000429100",
      "display" : "WINON TABLETS"
    },
    {
      "code" : "A000432100",
      "display" : "HETACILLIN CAPSULES 250MG \"KINGDOM\""
    },
    {
      "code" : "A000437100",
      "display" : "ALLERCUR S.C. TABLETS"
    },
    {
      "code" : "A000463100",
      "display" : "PARAMESONE TABLETS 6MG"
    },
    {
      "code" : "A000476100",
      "display" : "INPAN CAPSULES"
    },
    {
      "code" : "A000479100",
      "display" : "A-PARAMINE CAPSULES"
    },
    {
      "code" : "A000480209",
      "display" : "ADRENALIN INJECTION"
    },
    {
      "code" : "A000483209",
      "display" : "PROGYNON DEPOT INJECTION"
    },
    {
      "code" : "A000484100",
      "display" : "FESTAL ENTERIC-COATED TABLETS"
    },
    {
      "code" : "A000505209",
      "display" : "PROLUTON DEPOT INJECTION 125MG"
    },
    {
      "code" : "A000506100",
      "display" : "POPON CAPSULES"
    },
    {
      "code" : "A000518100",
      "display" : "OXYETERACYCLINE HCL CAPSULES \"TAH-AN\""
    },
    {
      "code" : "A000519100",
      "display" : "TETRACYCLINE CAPSULES \"LIN CHEMICAL\""
    },
    {
      "code" : "A000522100",
      "display" : "S.M.P. TABLETS \"CURIE\""
    },
    {
      "code" : "A000541100",
      "display" : "AMPICILLIN CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A000542100",
      "display" : "ERYTHROMYCIN CAPSULES \"LIN CHEMICAL\""
    },
    {
      "code" : "A000543355",
      "display" : "FLUCORT CREAM 0.025％"
    },
    {
      "code" : "A000544316",
      "display" : "FLUCORT OINTMENT 0.025％"
    },
    {
      "code" : "A000552209",
      "display" : "NEOLEWESHUE INJECTION"
    },
    {
      "code" : "A000572100",
      "display" : "PROWEL S.C.TABLETS"
    },
    {
      "code" : "A000575100",
      "display" : "PARAMESONE TABLETS 2.0MG"
    },
    {
      "code" : "A000576100",
      "display" : "PARAMESONE TABLETS 1.5MG"
    },
    {
      "code" : "A000581212",
      "display" : "Methorphan Injection \"K.S.\""
    },
    {
      "code" : "A000582212",
      "display" : "Fubanol Injection"
    },
    {
      "code" : "A000582221",
      "display" : "Fubanol Injection"
    },
    {
      "code" : "A000582238",
      "display" : "Fubanol Injection"
    },
    {
      "code" : "A000587100",
      "display" : "VIBRAMYCIN CAPSULES 50MG"
    },
    {
      "code" : "A000591238",
      "display" : "RANKAN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A000604151",
      "display" : "Codcan Syrup ''CENTER''"
    },
    {
      "code" : "A000605316",
      "display" : "FLUCORT-F OINTMENT 0.025％"
    },
    {
      "code" : "A000605321",
      "display" : "FLUCORT-F OINTMENT 0.025％"
    },
    {
      "code" : "A000605338",
      "display" : "FLUCORT-F OINTMENT 0.025％"
    },
    {
      "code" : "A000605355",
      "display" : "FLUCORT-F OINTMENT 0.025％"
    },
    {
      "code" : "A000612329",
      "display" : "ULTRAPROCT OINTMENT"
    },
    {
      "code" : "A000638100",
      "display" : "SODINATE S.C. TABLETS"
    },
    {
      "code" : "A000639100",
      "display" : "TRYNOL S.C. TABLETS 25MG \"JOHNSON\""
    },
    {
      "code" : "A0006391G0",
      "display" : "TRYNOL S.C. TABLETS 25MG \"JOHNSON\""
    },
    {
      "code" : "A000642500",
      "display" : "ZAMIN SUPPOSITORIES"
    },
    {
      "code" : "A000647100",
      "display" : "CYTADINE 2MG TABLETS(CYPROHEPTADINE)"
    },
    {
      "code" : "A000649100",
      "display" : "TRYNOL S.C. TABLETS 10MG"
    },
    {
      "code" : "A000655100",
      "display" : "Aminophylline Tablets 100mg \"F.Y.\""
    },
    {
      "code" : "A000706109",
      "display" : "PEPTIDIN GRANULES"
    },
    {
      "code" : "A000742177",
      "display" : "HUSTAZOL POWDER"
    },
    {
      "code" : "A000742199",
      "display" : "HUSTAZOL POWDER"
    },
    {
      "code" : "A000749100",
      "display" : "ALU-GEL COMPOUND CAPSULES \"M.H.\""
    },
    {
      "code" : "A000755118",
      "display" : "ANTI-COUGH SYRUP \"WASHINGTON\""
    },
    {
      "code" : "A000755151",
      "display" : "ANTI-COUGH SYRUP \"WASHINGTON\""
    },
    {
      "code" : "A000755155",
      "display" : "ANTI-COUGH SYRUP \"WASHINGTON\""
    },
    {
      "code" : "A000755199",
      "display" : "ANTI-COUGH SYRUP \"WASHINGTON\""
    },
    {
      "code" : "A000768209",
      "display" : "LYO-KEROMYCIN INTRAMUSCULAR INJECTION 1GM \"C.C.P.\""
    },
    {
      "code" : "A000769209",
      "display" : "LYO-KEROMYCIN INJECTION 1GM \"C.C.P.\""
    },
    {
      "code" : "A000773100",
      "display" : "PULINPELIN CAPSULES"
    },
    {
      "code" : "A000822157",
      "display" : "FUSOCO SYRUP \"L.S.\""
    },
    {
      "code" : "A000842100",
      "display" : "ENPURIN S.C. TABLETS \"VEI MIN\""
    },
    {
      "code" : "A000844100",
      "display" : "TRANCOLON F.C. TABLETS 7.5MG (MEPENZOLATE BROMIDE)"
    },
    {
      "code" : "A0008441G0",
      "display" : "TRANCOLON F.C. TABLETS 7.5MG (MEPENZOLATE BROMIDE)"
    },
    {
      "code" : "A000849100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES \"LITA\""
    },
    {
      "code" : "A000862100",
      "display" : "ANTACID TABLETS \"F.Y.\""
    },
    {
      "code" : "A000863100",
      "display" : "ISOXINE TABLETS"
    },
    {
      "code" : "A000865209",
      "display" : "BLUTON INJECTION 10％ \"C.C.P.\""
    },
    {
      "code" : "A000865277",
      "display" : "BLUTON INJECTION 10％ \"C.C.P.\""
    },
    {
      "code" : "A000886100",
      "display" : "P.T.D. SUGAR COATED TABLETS"
    },
    {
      "code" : "A000895100",
      "display" : "TRANZEPAM TABLETS"
    },
    {
      "code" : "A000897212",
      "display" : "PROTHIAMIN B12 INJECTION \"SINTON\""
    },
    {
      "code" : "A000900100",
      "display" : "ADREBLOCK TABLETS"
    },
    {
      "code" : "A000902100",
      "display" : "HEXANICIT TABLETS"
    },
    {
      "code" : "A000912100",
      "display" : "INZUTOLIN CAPSULES 25MG"
    },
    {
      "code" : "A000913100",
      "display" : "DECANS TABLETS \"C.M.\""
    },
    {
      "code" : "A000917100",
      "display" : "DENFLU CAPSULES"
    },
    {
      "code" : "A000933100",
      "display" : "PREDNISOLONE TABLETS \" NAN YA\""
    },
    {
      "code" : "A000985100",
      "display" : "DOZIGEN S.C. TABLETS 50MG"
    },
    {
      "code" : "A000998100",
      "display" : "LEDERSCON TABLETS"
    },
    {
      "code" : "A001001100",
      "display" : "DANZEN TABLETS"
    },
    {
      "code" : "A0010011G0",
      "display" : "DANZEN TABLETS"
    },
    {
      "code" : "A001027277",
      "display" : "BLUTON-SALINE INJECTION"
    },
    {
      "code" : "A001041100",
      "display" : "SANTIN TABLETS"
    },
    {
      "code" : "A001045100",
      "display" : "VESSELON CAPSULES \"N.C.P\""
    },
    {
      "code" : "A001046100",
      "display" : "Magnesium Oxide Tablets \"H.L\""
    },
    {
      "code" : "A001047100",
      "display" : "URETROPIC TABLETS"
    },
    {
      "code" : "A0010471G0",
      "display" : "URETROPIC TABLETS"
    },
    {
      "code" : "A001048118",
      "display" : "TECOSIN SYRUP"
    },
    {
      "code" : "A001048199",
      "display" : "TECOSIN SYRUP"
    },
    {
      "code" : "A001050277",
      "display" : "DEXTROSE INJECTION 10％ \"ASTAR\""
    },
    {
      "code" : "A001051277",
      "display" : "SODIUM CHLORIDE INJECTION 3％ \"C.C.P.\""
    },
    {
      "code" : "A001057100",
      "display" : "TANCOSIL S.C. TABLETS"
    },
    {
      "code" : "A001059100",
      "display" : "DECADOLONE TABLETS"
    },
    {
      "code" : "A001068100",
      "display" : "AMPICILLIN CAPSULES 250MG \"SINTON\""
    },
    {
      "code" : "A001074100",
      "display" : "BACTERCIDE TABLETS"
    },
    {
      "code" : "A001085209",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001085238",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001085248",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001085255",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001085265",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001085277",
      "display" : "SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A001086209",
      "display" : "GLUCOSE INJECTION 10％ \"Y.F.\""
    },
    {
      "code" : "A001086238",
      "display" : "GLUCOSE INJECTION 10％ \"Y.F.\""
    },
    {
      "code" : "A001086265",
      "display" : "GLUCOSE INJECTION 10％ \"Y.F.\""
    },
    {
      "code" : "A001086277",
      "display" : "GLUCOSE INJECTION 10％ \"Y.F.\""
    },
    {
      "code" : "A001089100",
      "display" : "METHU S.C. TABLETS \"C.M.\""
    },
    {
      "code" : "A001093100",
      "display" : "SWUNDERPIN CAPSULES"
    },
    {
      "code" : "A001112100",
      "display" : "TRICO TABLETS"
    },
    {
      "code" : "A001113265",
      "display" : "GURONTOU-C INJECTION"
    },
    {
      "code" : "A001113277",
      "display" : "GURONTOU-C INJECTION"
    },
    {
      "code" : "A001115212",
      "display" : "PROGESTERONE INJECTION 25MG/ML \"Y.F.\""
    },
    {
      "code" : "A001143100",
      "display" : "PIDONIN TABLETS \"N.T.\""
    },
    {
      "code" : "A001144100",
      "display" : "GINBO TABLETS"
    },
    {
      "code" : "A001154100",
      "display" : "INDOY CAPSULES"
    },
    {
      "code" : "A0011541G0",
      "display" : "INDOY CAPSULES"
    },
    {
      "code" : "A001155100",
      "display" : "PHENOBARBITAL TABLETS \"JENG SHENG\""
    },
    {
      "code" : "A001160100",
      "display" : "ENKER TABLETS"
    },
    {
      "code" : "A001164100",
      "display" : "POTASSIUM PERMANGANATE TABLETS 0.324 GM \"WASHINGTON\""
    },
    {
      "code" : "A001169100",
      "display" : "INTALITON CAPSULES"
    },
    {
      "code" : "A001170100",
      "display" : "VATIN TABLETS"
    },
    {
      "code" : "A001177100",
      "display" : "LITALON TABLETS \"LITA\""
    },
    {
      "code" : "A001192100",
      "display" : "CINBININ TABLETS"
    },
    {
      "code" : "A0011921G0",
      "display" : "CINBININ TABLETS"
    },
    {
      "code" : "A001206100",
      "display" : "Hisunsero capsules \"Y.K.\""
    },
    {
      "code" : "A001208100",
      "display" : "COUSY S.C. TABLETS \"KINGDOM\""
    },
    {
      "code" : "A001217100",
      "display" : "DIAZEPAM TABLETS"
    },
    {
      "code" : "A001226100",
      "display" : "PREDNISOLONE TABLETS 5MG"
    },
    {
      "code" : "A001234209",
      "display" : "KANAMYCIN INJECTION \"G.L.\""
    },
    {
      "code" : "A001239100",
      "display" : "ASMA-S CAPSULES"
    },
    {
      "code" : "A001261100",
      "display" : "INDOPAN E.C. TABLETS"
    },
    {
      "code" : "A001353100",
      "display" : "THIOROKAN S.C. TABLETS"
    },
    {
      "code" : "A001358100",
      "display" : "AMINOPHYLLINE TABLETS"
    },
    {
      "code" : "A001386500",
      "display" : "INDOMEN SUPPOSITORIES \"YUNG SHIN\""
    },
    {
      "code" : "A001396100",
      "display" : "ERYTHROMYCIN S.C. TABLETS 250MG \"KINGDOM\""
    },
    {
      "code" : "A001398100",
      "display" : "NALIDIN TABLETS 500MG \"N.C.P.\""
    },
    {
      "code" : "A001400100",
      "display" : "PROPHYLLIN TABLETS\"T.F.\""
    },
    {
      "code" : "A001402100",
      "display" : "TOLANCOL TABLETS"
    },
    {
      "code" : "A001412100",
      "display" : "SHAN YEN TABLETS \"Y.S.\""
    },
    {
      "code" : "A001413100",
      "display" : "VALISIN TABLETS"
    },
    {
      "code" : "A001420309",
      "display" : "FURAN OINTMENT"
    },
    {
      "code" : "A001420321",
      "display" : "FURAN OINTMENT"
    },
    {
      "code" : "A001420329",
      "display" : "FURAN OINTMENT"
    },
    {
      "code" : "A0014203CH",
      "display" : "FURAN OINTMENT"
    },
    {
      "code" : "A001426100",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426118",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426137",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426155",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426165",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426172",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426177",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001426199",
      "display" : "ALUM GEL \"WASHINGTON\""
    },
    {
      "code" : "A001433100",
      "display" : "VITAMIN E TABLETS 50MG \"ORIENTAL\""
    },
    {
      "code" : "A001437277",
      "display" : "AMPICILLIN INJECTION 500 MG \"CHI SHENG\""
    },
    {
      "code" : "A001446100",
      "display" : "AMPICILLIN CAPSULES 500MG \"SINTON\""
    },
    {
      "code" : "A001448100",
      "display" : "NOSCAPINE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A001449100",
      "display" : "NALIC TABLETS"
    },
    {
      "code" : "A001466100",
      "display" : "PAPAVERINE HCL TABLETS"
    },
    {
      "code" : "A001473277",
      "display" : "AMPICILLIN FOR INJECTION 500MG \"SINTON\""
    },
    {
      "code" : "A001488100",
      "display" : "DAONIL TABLETS"
    },
    {
      "code" : "A001493229",
      "display" : "KANAMYCIN SULFATE INJ. \"SINTON\""
    },
    {
      "code" : "A001493238",
      "display" : "KANAMYCIN SULFATE INJ. \"SINTON\""
    },
    {
      "code" : "A001531100",
      "display" : "ANSULON S.C. TABLETS"
    },
    {
      "code" : "A001532100",
      "display" : "MEDAZIN CAPSULES 5MG"
    },
    {
      "code" : "A001563212",
      "display" : "DIAZEPAM INJECTION 5MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A001577100",
      "display" : "TRIPYLINE TABLETS 25MG \"H.L.\""
    },
    {
      "code" : "A001584100",
      "display" : "MAGNESIA TABLETS \"WASHINGTON\""
    },
    {
      "code" : "A001585100",
      "display" : "UANETHIDINE SULFATE TABLETS \"WASHINGTON\""
    },
    {
      "code" : "A001591238",
      "display" : "CHLORAM-S INJETION \"KINGDOM\""
    },
    {
      "code" : "A001598100",
      "display" : "RESOZIN S.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A001599100",
      "display" : "MEBRON FILM COATING TABLETS"
    },
    {
      "code" : "A001604212",
      "display" : "HOROMPELIN INJECTION \"TBC\""
    },
    {
      "code" : "A001607100",
      "display" : "ZUDAW S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A001622277",
      "display" : "DEXTRAN 6％ INJECTION IN NORMAL SALINE \"CHI SHENG\""
    },
    {
      "code" : "A001624100",
      "display" : "GLYCYRRHIZA AND OPIUM COMPOUND TABLETS"
    },
    {
      "code" : "A0016241G0",
      "display" : "GLYCYRRHIZA AND OPIUM COMPOUND TABLETS"
    },
    {
      "code" : "A001625100",
      "display" : "LUMRIN F.C. TABLETS"
    },
    {
      "code" : "A001629277",
      "display" : "DEXTRAN 10％ INJECTION IN NORMAL SALINE \"CHI SHENG\""
    },
    {
      "code" : "A001632100",
      "display" : "MINOCIN CAPSULES 100MG"
    },
    {
      "code" : "A001637100",
      "display" : "TABENEX S.C. TABLETS 250MG"
    },
    {
      "code" : "A001641100",
      "display" : "CYTADINE TABLETS 4MG"
    },
    {
      "code" : "A001644100",
      "display" : "BENTAL TABLETS \"WILSON\""
    },
    {
      "code" : "A001646100",
      "display" : "DIAZEPAM TABLETS \"SYNMOSA\""
    },
    {
      "code" : "A0016461G0",
      "display" : "DIAZEPAM TABLETS \"SYNMOSA\""
    },
    {
      "code" : "A001648100",
      "display" : "JOHNCIDIN S.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A001662100",
      "display" : "AMINOPHYLLINE TABLETS 100MG \"JOHNSON\""
    },
    {
      "code" : "A001673100",
      "display" : "CINNAZINE TABLETS"
    },
    {
      "code" : "A0016731G0",
      "display" : "CINNAZINE TABLETS"
    },
    {
      "code" : "A001682100",
      "display" : "ZINTONLIN S.C. TABLETS"
    },
    {
      "code" : "A001691100",
      "display" : "PULIN S.C. TABLETS"
    },
    {
      "code" : "A001692100",
      "display" : "ASTHIMA CAPSULES"
    },
    {
      "code" : "A001701221",
      "display" : "ANTIMIN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A001701238",
      "display" : "ANTIMIN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A001702110",
      "display" : "IROSE POWDER FOR SUSPENSION \"KINGDOM\""
    },
    {
      "code" : "A001702151",
      "display" : "IROSE POWDER FOR SUSPENSION \"KINGDOM\""
    },
    {
      "code" : "A001707100",
      "display" : "AMPICILLIN CAPSULES 500MG \"WAH FOO\""
    },
    {
      "code" : "A001713100",
      "display" : "ENZYME TABLETS \"H.C.T.\""
    },
    {
      "code" : "A001726100",
      "display" : "ALIMEZINE TABLETS"
    },
    {
      "code" : "A001735100",
      "display" : "KAPIN F.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A001741100",
      "display" : "ASPARA-CA TABLETS"
    },
    {
      "code" : "A001779100",
      "display" : "MEDESONE TABLETS \"Y.K.\""
    },
    {
      "code" : "A001781100",
      "display" : "VANMESON TABLETS"
    },
    {
      "code" : "A001782100",
      "display" : "CABETAN S.C. TABLETS"
    },
    {
      "code" : "A001790100",
      "display" : "SUVECON S.C. TABLETS"
    },
    {
      "code" : "A001793100",
      "display" : "LIGHT SUN CAPSULES \"H.S.\""
    },
    {
      "code" : "A001799100",
      "display" : "WE-WANG TABLETS"
    },
    {
      "code" : "A001806100",
      "display" : "PROPRANOLOL TABLETS 40mg"
    },
    {
      "code" : "A001811100",
      "display" : "AMPICILLIN CAPSULES 250MG \"WAH FOO\""
    },
    {
      "code" : "A001816100",
      "display" : "VANTYL TABLETS"
    },
    {
      "code" : "A001832209",
      "display" : "DEMETHOR INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A001833229",
      "display" : "DECAMIN INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A001836100",
      "display" : "METAZOLE TABLETS"
    },
    {
      "code" : "A001850100",
      "display" : "AMPICILLIN CAPSULES 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A001853277",
      "display" : "AMPOLIN INJECTION 500MG"
    },
    {
      "code" : "A001856100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"WAH FOO\""
    },
    {
      "code" : "A001862100",
      "display" : "KOLIGIN TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A001864209",
      "display" : "PANMESON INJECTION"
    },
    {
      "code" : "A001864229",
      "display" : "PANMESON INJECTION"
    },
    {
      "code" : "A001865212",
      "display" : "FANIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A001866100",
      "display" : "AMPICILLIN CAPSULES 500MG \"PANBIOTIC\""
    },
    {
      "code" : "A001867277",
      "display" : "AMPICILLIN INJECTION 500MG \"PANBIOTIC\""
    },
    {
      "code" : "A001868209",
      "display" : "AMPICILLIN INJECTION 1000MG \"PANBIOTIC\""
    },
    {
      "code" : "A001878212",
      "display" : "PYRIDOXINE HCL INJECTION 100 MG \"CHI SHENG\""
    },
    {
      "code" : "A001879209",
      "display" : "PYRIDOXINE HCL INJECTION 50 MG \"CHI SHENG\""
    },
    {
      "code" : "A001881100",
      "display" : "Codimagen Tablets \"Y.K.\""
    },
    {
      "code" : "A001886100",
      "display" : "LICHECHIN TABLETS 10MG"
    },
    {
      "code" : "A001891100",
      "display" : "MEPARAN TABLETS"
    },
    {
      "code" : "A001894100",
      "display" : "SUMINCURDA TABLETS"
    },
    {
      "code" : "A001923229",
      "display" : "CALCIUM GLUCONATE I.V. INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A001924209",
      "display" : "SPARTINE INJECTION 0.15 GM"
    },
    {
      "code" : "A001941100",
      "display" : "Perzin F.C. Tablets \"Yu Sheng\""
    },
    {
      "code" : "A0019411G0",
      "display" : "Perzin F.C. Tablets \"Yu Sheng\""
    },
    {
      "code" : "A001946100",
      "display" : "PREVOMIC S.C. TABLETS"
    },
    {
      "code" : "A0019461G0",
      "display" : "PREVOMIC S.C. TABLETS"
    },
    {
      "code" : "A001963100",
      "display" : "Fuliclin Tablets"
    },
    {
      "code" : "A0019631G0",
      "display" : "Fuliclin Tablets"
    },
    {
      "code" : "A001973100",
      "display" : "VITAMIN E CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A001982212",
      "display" : "VANTYL INJECTION"
    },
    {
      "code" : "A001997100",
      "display" : "TRANSONE TABLETS"
    },
    {
      "code" : "A002031209",
      "display" : "MERO INJ."
    },
    {
      "code" : "A002076100",
      "display" : "RIOTOL TABLETS"
    },
    {
      "code" : "A002078100",
      "display" : "MESUCON TABLETS"
    },
    {
      "code" : "A002079219",
      "display" : "KANASIDINE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A002079229",
      "display" : "KANASIDINE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A002079238",
      "display" : "KANASIDINE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A002086100",
      "display" : "WEIERNIN TABLETS"
    },
    {
      "code" : "A002089209",
      "display" : "MERO INJ. 1ML"
    },
    {
      "code" : "A002101100",
      "display" : "PERONE S.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A002104100",
      "display" : "NYMOLON TABLETS"
    },
    {
      "code" : "A002107500",
      "display" : "STIN SUPPOSITORIES"
    },
    {
      "code" : "A002112100",
      "display" : "UROBENIN S.C. TABLETS"
    },
    {
      "code" : "A002126100",
      "display" : "WEICHINHO TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002131100",
      "display" : "AMCLOCILLIN CAPSULES"
    },
    {
      "code" : "A002137100",
      "display" : "COLWEN TABLETS"
    },
    {
      "code" : "A002140100",
      "display" : "VITAMIN B12 S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0021401G0",
      "display" : "VITAMIN B12 S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A002160209",
      "display" : "LEDERSPAN SUSPEND INJECTION 20MG/ML"
    },
    {
      "code" : "A002198100",
      "display" : "LUWI-U TABLETS"
    },
    {
      "code" : "A002223100",
      "display" : "RELASMA TABLETS"
    },
    {
      "code" : "A002242100",
      "display" : "UNSULON TABLETS \"CHINTENG\""
    },
    {
      "code" : "A002244100",
      "display" : "JINLUN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0022441G0",
      "display" : "JINLUN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A002310100",
      "display" : "PERIAN TABLETS"
    },
    {
      "code" : "A002314212",
      "display" : "DIANZEM INJECTION \"Y.Y.\""
    },
    {
      "code" : "A002314221",
      "display" : "DIANZEM INJECTION \"Y.Y.\""
    },
    {
      "code" : "A002317212",
      "display" : "DIAZEPAM INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A002320100",
      "display" : "ALEVIATIN TABLETS"
    },
    {
      "code" : "A0023201G0",
      "display" : "ALEVIATIN TABLETS"
    },
    {
      "code" : "A002321212",
      "display" : "BUSCOMINE INJECTION"
    },
    {
      "code" : "A002323100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES 250MG \"CHI SHENG\""
    },
    {
      "code" : "A002325100",
      "display" : "NEO-VIBON COMPLEX S.C. TABLETS"
    },
    {
      "code" : "A002327209",
      "display" : "CLOXAMPICIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A002327277",
      "display" : "CLOXAMPICIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A002328100",
      "display" : "BOMIT TABLETS \"C.C.P.\""
    },
    {
      "code" : "A002341349",
      "display" : "CALAMINE LOTION PHENOLATED AND MENTHOLATED \"SYNMOSA\""
    },
    {
      "code" : "A002341351",
      "display" : "CALAMINE LOTION PHENOLATED AND MENTHOLATED \"SYNMOSA\""
    },
    {
      "code" : "A002341355",
      "display" : "CALAMINE LOTION PHENOLATED AND MENTHOLATED \"SYNMOSA\""
    },
    {
      "code" : "A002341357",
      "display" : "CALAMINE LOTION PHENOLATED AND MENTHOLATED \"SYNMOSA\""
    },
    {
      "code" : "A002343100",
      "display" : "THININ TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002346100",
      "display" : "IUNAIDON TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002355229",
      "display" : "KANAMYCIN INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A002359100",
      "display" : "PREDNISOLONE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002362100",
      "display" : "BROSCO TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A002368100",
      "display" : "NADIS TABLETS"
    },
    {
      "code" : "A0023681G0",
      "display" : "NADIS TABLETS"
    },
    {
      "code" : "A002385100",
      "display" : "PREDNISOLONE TABLETS \"SANTONG\""
    },
    {
      "code" : "A002389100",
      "display" : "COMPOUND GLYCYRRHIZIAE TABLETS \"CURIE\""
    },
    {
      "code" : "A002393100",
      "display" : "THEOLINATE S.C. TABLETS 100MG"
    },
    {
      "code" : "A002394238",
      "display" : "PAMPARA INJECTION"
    },
    {
      "code" : "A002403100",
      "display" : "AMPICILLIN CAPSULES 250MG \"KINGDOM\""
    },
    {
      "code" : "A002420100",
      "display" : "WEIKA TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A002444100",
      "display" : "ANCILLIN CAPSULES 500MG"
    },
    {
      "code" : "A002445100",
      "display" : "CLOXAMPICIN CAPSULES 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A002479100",
      "display" : "ULCERIN-P TABLETS"
    },
    {
      "code" : "A002483100",
      "display" : "GELAWEN TABLETS \"F.Y.\""
    },
    {
      "code" : "A002504100",
      "display" : "FUSEMIDE TABLETS 40MG"
    },
    {
      "code" : "A002516100",
      "display" : "GLYCEMIDE TABLETS"
    },
    {
      "code" : "A002555100",
      "display" : "MAWEI TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002558100",
      "display" : "THIOZIN S.C. TABLETS 25MG"
    },
    {
      "code" : "A002562100",
      "display" : "BENZYMIN S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002569100",
      "display" : "STANNEL S.C. TABLETS"
    },
    {
      "code" : "A002573100",
      "display" : "SKELAXINE TABLETS"
    },
    {
      "code" : "A0025731G0",
      "display" : "SKELAXINE TABLETS"
    },
    {
      "code" : "A002581265",
      "display" : "CHIAMINE-S INJECTION"
    },
    {
      "code" : "A002581277",
      "display" : "CHIAMINE-S INJECTION"
    },
    {
      "code" : "A002589100",
      "display" : "DIPORAX S.C. TABLETS"
    },
    {
      "code" : "A002595100",
      "display" : "BALON S.C. TABLETS"
    },
    {
      "code" : "A002616100",
      "display" : "MEFENA CAPSULES"
    },
    {
      "code" : "A002626100",
      "display" : "PROSTEN CAPSULES"
    },
    {
      "code" : "A002628209",
      "display" : "AMPICILLIN INJECTION 1GM \"N.K.\""
    },
    {
      "code" : "A002635100",
      "display" : "GASTROPAN S.C. TABLETS"
    },
    {
      "code" : "A002636100",
      "display" : "AMCLOX CAPSULES 125MG: 125MG \"F.M.\""
    },
    {
      "code" : "A002638100",
      "display" : "CHLOROMYCETIN CAPSULES 250MG"
    },
    {
      "code" : "A002644100",
      "display" : "TONIPIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002650100",
      "display" : "CHIN TAN TABLETS"
    },
    {
      "code" : "A002652100",
      "display" : "AMPICILLIN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A002657209",
      "display" : "PROGESTERONE INJECTION 2.5％ \"ASTAR\""
    },
    {
      "code" : "A002657229",
      "display" : "PROGESTERONE INJECTION 2.5％ \"ASTAR\""
    },
    {
      "code" : "A002657240",
      "display" : "PROGESTERONE INJECTION 2.5％ \"ASTAR\""
    },
    {
      "code" : "A002658100",
      "display" : "LIUMPIN TABLETS"
    },
    {
      "code" : "A002663100",
      "display" : "CHINLIPAN TABLETS"
    },
    {
      "code" : "A002666209",
      "display" : "GRAVIBINAN INJECTION"
    },
    {
      "code" : "A002667100",
      "display" : "PRIMOLUT-NOR TABLETS 5 MG"
    },
    {
      "code" : "A002675277",
      "display" : "SODIUM AMPICILLIN INJECTION 500MG \"KINGDOM\""
    },
    {
      "code" : "A002678100",
      "display" : "POWEID TABLETS \"F.Y.\""
    },
    {
      "code" : "A002680100",
      "display" : "LIJEX TABLETS"
    },
    {
      "code" : "A002684100",
      "display" : "ILITAN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002691100",
      "display" : "THYARON TABLETS \"CHIU PO\""
    },
    {
      "code" : "A002699100",
      "display" : "ACETAMINOPHEN TABLETS \"S.S.P.\""
    },
    {
      "code" : "A002724100",
      "display" : "GLAMIDE TABLETS 5MG"
    },
    {
      "code" : "A002755100",
      "display" : "COULITAMIN S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A002756100",
      "display" : "YAJUNLO TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002759100",
      "display" : "RIBOFLAVIN TABLETS 10MG \"YU SHENG\""
    },
    {
      "code" : "A002760100",
      "display" : "THIAN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002763100",
      "display" : "PHENYTOIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A002766100",
      "display" : "ACETAMINOPHEN TABLETS \"CENTRAL\""
    },
    {
      "code" : "A002801209",
      "display" : "LACTATED RINGER'S B INJECTION \"Y.F.\""
    },
    {
      "code" : "A002801265",
      "display" : "LACTATED RINGER'S B INJECTION \"Y.F.\""
    },
    {
      "code" : "A002801277",
      "display" : "LACTATED RINGER'S B INJECTION \"Y.F.\""
    },
    {
      "code" : "A002839100",
      "display" : "VITAMIN E CAPSULES 200MG \"C.B.C.\""
    },
    {
      "code" : "A002844100",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002845100",
      "display" : "VITAMIN B6 TABLETS 50MG \"YU SHENG\""
    },
    {
      "code" : "A002846100",
      "display" : "WANSE S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002848100",
      "display" : "ZUCANLIN CAPSULES 25MG (ANETHOLE) \"C.T.\""
    },
    {
      "code" : "A002854277",
      "display" : "AMPICILLIN INJECTION 500MG \"N.K.\""
    },
    {
      "code" : "A002856100",
      "display" : "FULLPHAGEN TABLETS \"F.Y.\""
    },
    {
      "code" : "A002858100",
      "display" : "FURSERPINE TABLETS"
    },
    {
      "code" : "A002863100",
      "display" : "GLIBEN TABLETS"
    },
    {
      "code" : "A0028631G0",
      "display" : "GLIBEN TABLETS"
    },
    {
      "code" : "A002874100",
      "display" : "VITAMIN K1 FLIM COATED TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A002904100",
      "display" : "CYPRODIN TABLETS"
    },
    {
      "code" : "A002915100",
      "display" : "ESUMIN S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002921100",
      "display" : "MININ S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002938100",
      "display" : "MEDAZEPAM CAPSULES"
    },
    {
      "code" : "A002947100",
      "display" : "SHITON S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A002953100",
      "display" : "ETOLE S.C. TABLETS"
    },
    {
      "code" : "A002955100",
      "display" : "STOMA-HLIN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A002956100",
      "display" : "YONG WANG CAPSULES \"T.F.\""
    },
    {
      "code" : "A002960100",
      "display" : "COLD CAPSULES \"Y.S.\""
    },
    {
      "code" : "A002961100",
      "display" : "METROLE S.C. TABLETS"
    },
    {
      "code" : "A002962100",
      "display" : "PREIN TABLETS \"T.F.\""
    },
    {
      "code" : "A002963100",
      "display" : "\"ZM\"CALCIUM GLUCONATED TABLETS"
    },
    {
      "code" : "A002964100",
      "display" : "SUYUAN S.C. TABLETS"
    },
    {
      "code" : "A002971100",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS \"Y.S.\""
    },
    {
      "code" : "A002975100",
      "display" : "INDETOLE CAPSULES \"Y.S.\""
    },
    {
      "code" : "A002976100",
      "display" : "STOMATH TABLETS \"Y.S.\""
    },
    {
      "code" : "A002979100",
      "display" : "EPAL TABLETS"
    },
    {
      "code" : "A002985100",
      "display" : "EVENIN TABLETS"
    },
    {
      "code" : "A002986100",
      "display" : "EPOLE S.C. TABLETS"
    },
    {
      "code" : "A002987100",
      "display" : "VITA B12 CAPSULES \"Y.S.\""
    },
    {
      "code" : "A002989100",
      "display" : "PUSIA VITA S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A002992100",
      "display" : "SUIL CAPSULES \"Y.S.\""
    },
    {
      "code" : "A002994100",
      "display" : "KANGCHINMIN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A003004209",
      "display" : "ALLCOL INJECTION"
    },
    {
      "code" : "A003004212",
      "display" : "ALLCOL INJECTION"
    },
    {
      "code" : "A003006209",
      "display" : "TESTENAN DEPOT INJECTION"
    },
    {
      "code" : "A003023212",
      "display" : "FUYULIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A003025221",
      "display" : "HISTIDINE INJECTION \"SINTON\""
    },
    {
      "code" : "A003033212",
      "display" : "ALLERGEN HOUSE DUST EXTRACT \"TORII\" 2ML"
    },
    {
      "code" : "A003078100",
      "display" : "DIURETIC TABLETS 40MG (FUROSEMIDE) \"C.T.\""
    },
    {
      "code" : "A003084100",
      "display" : "FUZIN CAPSULES \"LITA\""
    },
    {
      "code" : "A003086100",
      "display" : "DEXAMETHASONE TABLETS \"Y.S.\""
    },
    {
      "code" : "A003092100",
      "display" : "ASPIRIN TABLETS 500MG"
    },
    {
      "code" : "A003096100",
      "display" : "SOXAZONE TABLETS"
    },
    {
      "code" : "A003098100",
      "display" : "DITHIAZIDE TABLETS"
    },
    {
      "code" : "A0030981G0",
      "display" : "DITHIAZIDE TABLETS"
    },
    {
      "code" : "A003099100",
      "display" : "ANCOFEN TABLETS"
    },
    {
      "code" : "A003107100",
      "display" : "URICAN S.C. TABLETS"
    },
    {
      "code" : "A003109100",
      "display" : "VITAMIN C TABLETS \"HONTEN\""
    },
    {
      "code" : "A003115209",
      "display" : "SPARTEINE INJECTION \"ANSHIN\""
    },
    {
      "code" : "A003116100",
      "display" : "CEDRIC CAPSULES"
    },
    {
      "code" : "A003133238",
      "display" : "STERILE WATER FOR INJECTION \"N.K.\""
    },
    {
      "code" : "A003135100",
      "display" : "ANTHALONE S.C. TABLETS"
    },
    {
      "code" : "A003156212",
      "display" : "VITA-6 INJECTION \"ANSHIN\""
    },
    {
      "code" : "A003157221",
      "display" : "HISTIDINE INJECTION \"ANSHIN\""
    },
    {
      "code" : "A003159238",
      "display" : "PARAKERN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A003160238",
      "display" : "PROCARNE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A003168100",
      "display" : "GLEUTON TABLETS 2.5MG \"YU SHENG\""
    },
    {
      "code" : "A003171100",
      "display" : "DECALON TABLETS \"YU SHENG\""
    },
    {
      "code" : "A003173100",
      "display" : "FETIRIN S.C. TABLETS 10MG"
    },
    {
      "code" : "A003174100",
      "display" : "FETIRIN S.C. TABLETS 5MG"
    },
    {
      "code" : "A003206100",
      "display" : "PASSTON CAPSULES"
    },
    {
      "code" : "A003222221",
      "display" : "HISULX INJECTION \"N.K.\""
    },
    {
      "code" : "A003224100",
      "display" : "SUROLE CAPSULES"
    },
    {
      "code" : "A003225212",
      "display" : "ANCONMIN INJECTION \"AN SHIN\""
    },
    {
      "code" : "A003227100",
      "display" : "KEFLEX CAPSULES 500MG"
    },
    {
      "code" : "A003241100",
      "display" : "PARDIN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A003243100",
      "display" : "TRANTHISON TABLETS \"YU SHENG\""
    },
    {
      "code" : "A003244100",
      "display" : "ROUMIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A003245100",
      "display" : "EARMIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A0032451G0",
      "display" : "EARMIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A003263100",
      "display" : "ERCAZON TABLETS"
    },
    {
      "code" : "A003266100",
      "display" : "D.X. CAPSULES \"LITA\""
    },
    {
      "code" : "A003286100",
      "display" : "HYLOMYCIN CAPSULES 250MG \"SWISS\""
    },
    {
      "code" : "A0032861G0",
      "display" : "HYLOMYCIN CAPSULES 250MG \"SWISS\""
    },
    {
      "code" : "A003291100",
      "display" : "PINSAUN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A0032911G0",
      "display" : "PINSAUN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A003293209",
      "display" : "DIAZEPAM INJECTION"
    },
    {
      "code" : "A003293212",
      "display" : "DIAZEPAM INJECTION"
    },
    {
      "code" : "A003296229",
      "display" : "METHASONE INJECTION"
    },
    {
      "code" : "A003301100",
      "display" : "DIAZEZIN TABLETS"
    },
    {
      "code" : "A003311100",
      "display" : "TRIENZYME CAPSULES \"WASHINGTON\""
    },
    {
      "code" : "A003314100",
      "display" : "YUNSTAN CAPSULES"
    },
    {
      "code" : "A003317212",
      "display" : "LASIX INJECTION"
    },
    {
      "code" : "A003318100",
      "display" : "PROMERAN F.C. TABLETS 3.84mg"
    },
    {
      "code" : "A0033181G0",
      "display" : "PROMERAN F.C. TABLETS 3.84mg"
    },
    {
      "code" : "A003325100",
      "display" : "DIABE H.C. TABLETS"
    },
    {
      "code" : "A003326100",
      "display" : "PINGIN TABLETS"
    },
    {
      "code" : "A003355212",
      "display" : "DIANLIN INJECTION \"N.K.\""
    },
    {
      "code" : "A003365100",
      "display" : "PREDNISOLONE TABLETS 5mg\"VPC\""
    },
    {
      "code" : "A0033651G0",
      "display" : "PREDNISOLONE TABLETS 5mg\"VPC\""
    },
    {
      "code" : "A003367100",
      "display" : "VITAMIN B12 S.C. TABLETS 100MCG \"YU SHENG\""
    },
    {
      "code" : "A003373321",
      "display" : "FLUCONIN  OINTMENT"
    },
    {
      "code" : "A003373329",
      "display" : "FLUCONIN  OINTMENT"
    },
    {
      "code" : "A003373372",
      "display" : "FLUCONIN  OINTMENT"
    },
    {
      "code" : "A003373399",
      "display" : "FLUCONIN  OINTMENT"
    },
    {
      "code" : "A003386209",
      "display" : "ORICORT-IM INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A003386212",
      "display" : "ORICORT-IM INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A003386221",
      "display" : "ORICORT-IM INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A003386229",
      "display" : "ORICORT-IM INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A003388100",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS \"VPP\""
    },
    {
      "code" : "A0033881G0",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS \"VPP\""
    },
    {
      "code" : "A003389100",
      "display" : "ACETAZOLAMIDE TABLETS 250MG \"VPP\""
    },
    {
      "code" : "A003390100",
      "display" : "MEPROBAMATE TABLETS 200MG \"VPP\""
    },
    {
      "code" : "A003392100",
      "display" : "ISONIAZID TABLETS \"V.P.P.\""
    },
    {
      "code" : "A003393100",
      "display" : "CHLORPROMAZINE HCL S.C. TABLETS 100MG \"VPP\""
    },
    {
      "code" : "A003403100",
      "display" : "NITROFURANTOIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A003417209",
      "display" : "Streptomycin Sulfate for Injection 1g \"VPC\""
    },
    {
      "code" : "A003429100",
      "display" : "VITAMIN K1 S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A003434100",
      "display" : "WINTORIN TABLETS"
    },
    {
      "code" : "A003440100",
      "display" : "RIBOFLAVIN TABLETS \"R.S.P.P.\""
    },
    {
      "code" : "A003442100",
      "display" : "CHLORPHENIRAMINE MALEATE TABLETS \"VPP\""
    },
    {
      "code" : "A003446221",
      "display" : "ORICORT INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A003448100",
      "display" : "EPHALINE S.C. TABLETS"
    },
    {
      "code" : "A003462100",
      "display" : "TAY HOU CHIN S.C. TABLETS"
    },
    {
      "code" : "A003468209",
      "display" : "RESERPINE INJECTION \"ASTAR\""
    },
    {
      "code" : "A003468212",
      "display" : "RESERPINE INJECTION \"ASTAR\""
    },
    {
      "code" : "A003469209",
      "display" : "NEOSTIGMINE INJECTION \"ASTAR\""
    },
    {
      "code" : "A003494100",
      "display" : "BETAMETHASONE TABLETS \"LITA\""
    },
    {
      "code" : "A003495100",
      "display" : "RELAX TABLETS \"LITA\""
    },
    {
      "code" : "A003496100",
      "display" : "F.S. TABLETS \"LITA\""
    },
    {
      "code" : "A003534100",
      "display" : "DESON TABLETS"
    },
    {
      "code" : "A003551100",
      "display" : "PRONALATE TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A003552212",
      "display" : "PROMERAN INJECTION"
    },
    {
      "code" : "A003554100",
      "display" : "COMBANTRIN TABLETS 125MG"
    },
    {
      "code" : "A003555100",
      "display" : "COMBANTRIN ORAL SUSPENSION"
    },
    {
      "code" : "A003555129",
      "display" : "COMBANTRIN ORAL SUSPENSION"
    },
    {
      "code" : "A003558212",
      "display" : "PROPHYLLIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A003559100",
      "display" : "PREDNISLOLNE TABLETS \"TON SHENG\""
    },
    {
      "code" : "A003572421",
      "display" : "CON-F EYE DROPS"
    },
    {
      "code" : "A003573221",
      "display" : "PLASLLOID INJECTION"
    },
    {
      "code" : "A003601100",
      "display" : "CHLORAMPHENICOL CAPSULES \"CENTRAL\""
    },
    {
      "code" : "A003603110",
      "display" : "KEFLEX FOR ORAL SUSP. 125MG/5ML"
    },
    {
      "code" : "A003603199",
      "display" : "KEFLEX FOR ORAL SUSP. 125MG/5ML"
    },
    {
      "code" : "A003617100",
      "display" : "AMPICILLIN CAPSULES \"CENTRAL\""
    },
    {
      "code" : "A003618212",
      "display" : "BARALGIN INJECTION"
    },
    {
      "code" : "A003618229",
      "display" : "BARALGIN INJECTION"
    },
    {
      "code" : "A003619209",
      "display" : "DEXTROSE IN SALINE INJECTION \"SINTONG\""
    },
    {
      "code" : "A003619265",
      "display" : "DEXTROSE IN SALINE INJECTION \"SINTONG\""
    },
    {
      "code" : "A003619277",
      "display" : "DEXTROSE IN SALINE INJECTION \"SINTONG\""
    },
    {
      "code" : "A003621100",
      "display" : "DEXCON TABLETS 10MG \"Honten\""
    },
    {
      "code" : "A003622100",
      "display" : "HONCALM CAPSULES"
    },
    {
      "code" : "A003623100",
      "display" : "WESU TABLETS"
    },
    {
      "code" : "A003632100",
      "display" : "ANLIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A003633100",
      "display" : "BENDA TABLETS \"Y.S.\""
    },
    {
      "code" : "A003642100",
      "display" : "CAPILAN CAPSULES"
    },
    {
      "code" : "A003648100",
      "display" : "ASMETHOL S.C. TABLETS"
    },
    {
      "code" : "A003654100",
      "display" : "PROGIN CAPSULES"
    },
    {
      "code" : "A003669100",
      "display" : "YIDOLI TABLET \"YUNG CHI\""
    },
    {
      "code" : "A003677100",
      "display" : "SILICON TABLETS 40MG \"CHIU PO\""
    },
    {
      "code" : "A003684100",
      "display" : "NEO-VIBON-S S.C. TABLETS 50MG"
    },
    {
      "code" : "A003686100",
      "display" : "TRIENZYMES CAPSULES \"KINGDOM\""
    },
    {
      "code" : "A003687100",
      "display" : "DOXYCYCLINE HCL CAPSULES \"S.T.\""
    },
    {
      "code" : "A003696100",
      "display" : "LI-CILLIN CAPSULES 500MG"
    },
    {
      "code" : "A003697417",
      "display" : "TETRACYCLINE EYE OINTMENT \"OASIS\""
    },
    {
      "code" : "A003699212",
      "display" : "DEXARON INJECTION 1MG"
    },
    {
      "code" : "A003699229",
      "display" : "DEXARON INJECTION 1MG"
    },
    {
      "code" : "A003700212",
      "display" : "DEXARON INJECTION 2MG"
    },
    {
      "code" : "A003700229",
      "display" : "DEXARON INJECTION 2MG"
    },
    {
      "code" : "A003703100",
      "display" : "EPILON TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A0037031G0",
      "display" : "EPILON TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A003704100",
      "display" : "ULTA TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A003705219",
      "display" : "KANAMYCIN INJECITON \"LIN CHEMICAL\""
    },
    {
      "code" : "A003705229",
      "display" : "KANAMYCIN INJECITON \"LIN CHEMICAL\""
    },
    {
      "code" : "A003706100",
      "display" : "FLUGESIC TABLETS"
    },
    {
      "code" : "A003712212",
      "display" : "PHYLLIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A003715271",
      "display" : "LEUCOMYCIN INTRAVENOUS INJECTION 400MG \"Taiwan Tung Yang\""
    },
    {
      "code" : "A003727100",
      "display" : "HITUS CAPSULES 25 MG"
    },
    {
      "code" : "A003739100",
      "display" : "A.M.D. TABLETS"
    },
    {
      "code" : "A003742100",
      "display" : "CLOBRATE CAPSULES \"JOHNSON\""
    },
    {
      "code" : "A003754100",
      "display" : "CHIAMYLON TABLETS"
    },
    {
      "code" : "A003757100",
      "display" : "FEBICON S.C. TABLETS"
    },
    {
      "code" : "A003759100",
      "display" : "INTEAN CAPSULES"
    },
    {
      "code" : "A003764100",
      "display" : "LILIAN TABLETS \"CURIE\""
    },
    {
      "code" : "A003768100",
      "display" : "SULFADIMETHOXINE TABLETS"
    },
    {
      "code" : "A003773100",
      "display" : "SWEICON TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A003775100",
      "display" : "ERYTHROMYCIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A003777100",
      "display" : "TZUCHIEH S.C. TABLETS"
    },
    {
      "code" : "A003780100",
      "display" : "CHLORAMPHENICOL CAPSULES 250MG \"CHIPHAR\""
    },
    {
      "code" : "A003782209",
      "display" : "CHLORPHENIRAMINE INJECTION \"ASTAR\""
    },
    {
      "code" : "A003786209",
      "display" : "ERGOMETRIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A003792100",
      "display" : "TOLBUTAMIDE TABLETS \"R.S.P.P.\""
    },
    {
      "code" : "A003793100",
      "display" : "ASCORBIC ACID TABLETS \"VPP\""
    },
    {
      "code" : "A003794100",
      "display" : "EPHEDRINE SULFATE CAPSULES \"VPP\""
    },
    {
      "code" : "A003796229",
      "display" : "AMINOPHYLLINE INJECTION \"VPP\""
    },
    {
      "code" : "A003797100",
      "display" : "COMBIGEL TABLETS \"VPP\""
    },
    {
      "code" : "A003817255",
      "display" : "MINOCIN INTRAVENOUS INJECTION 100MG"
    },
    {
      "code" : "A003828100",
      "display" : "GINBO TABLETS 2MG"
    },
    {
      "code" : "A003840100",
      "display" : "GERSKIN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A003851100",
      "display" : "RIPOLIN CAPSULES 150MG"
    },
    {
      "code" : "A003852100",
      "display" : "RIPOLIN CAPSULES 300MG"
    },
    {
      "code" : "A003853100",
      "display" : "SANTININ TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A003864209",
      "display" : "RESERPINE INJECTION 2.5MG/ML \"VPP\""
    },
    {
      "code" : "A003867209",
      "display" : "LIHOSIN INJECTION"
    },
    {
      "code" : "A003871417",
      "display" : "ERYTHROMYCIN EYE OINTMENT"
    },
    {
      "code" : "A003873100",
      "display" : "TETRACYCLINE HCL CAPSULES \"CENTRAL\""
    },
    {
      "code" : "A003876100",
      "display" : "SULVITEN S.C. TABLETS"
    },
    {
      "code" : "A003881209",
      "display" : "DEXAMETHASONE INJECTION"
    },
    {
      "code" : "A003884100",
      "display" : "PROTORIN ENTERIC-COATED TABLETS"
    },
    {
      "code" : "A003893100",
      "display" : "NITROFURANTOIN TABLETS 100MG \"R.S.P.P\""
    },
    {
      "code" : "A003898229",
      "display" : "KCL INJECTION \"C.C.P.\""
    },
    {
      "code" : "A003898238",
      "display" : "KCL INJECTION \"C.C.P.\""
    },
    {
      "code" : "A003902100",
      "display" : "SUSWUN TABLETS"
    },
    {
      "code" : "A003903100",
      "display" : "PELION TABLETS"
    },
    {
      "code" : "A003911100",
      "display" : "AMINOPHYLLINE TABLETS 200MG \"VPP\""
    },
    {
      "code" : "A003912100",
      "display" : "BAUSUTONERN CAPSULES"
    },
    {
      "code" : "A003913100",
      "display" : "PIBAUWEICON TABLETS SOLUTION"
    },
    {
      "code" : "A003933100",
      "display" : "NIROPYDIN S.C. TABLETS"
    },
    {
      "code" : "A003941421",
      "display" : "NARPINA EYE DROPS"
    },
    {
      "code" : "A003942421",
      "display" : "HYDROCORTISONE ACETATE OPHTHALMIC SUSPENSION 0.5％ \"C.M.\""
    },
    {
      "code" : "A003943100",
      "display" : "SPARKAN CAPSULES"
    },
    {
      "code" : "A003948417",
      "display" : "ATROPINE EYE OINTMENT"
    },
    {
      "code" : "A003953212",
      "display" : "MELERMINS INJECTION"
    },
    {
      "code" : "A003954212",
      "display" : "LIDOCAINE HCL INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A003956100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"T.T.\""
    },
    {
      "code" : "A003959500",
      "display" : "FULIZIN VAGINAL SUPPOSITORIES"
    },
    {
      "code" : "A003967229",
      "display" : "CYANOCOBALAMIN INJECTION \"VPP\""
    },
    {
      "code" : "A003968421",
      "display" : "SULOMIN EYE DROPS"
    },
    {
      "code" : "A003968429",
      "display" : "SULOMIN EYE DROPS"
    },
    {
      "code" : "A003969417",
      "display" : "CODEMYCIN EYE OINTMENT"
    },
    {
      "code" : "A003976100",
      "display" : "BISMUTH SUBCARBONATE TABLETS 324MG \"VPP\""
    },
    {
      "code" : "A003994421",
      "display" : "CON-N EYE-DROPS"
    },
    {
      "code" : "A004000209",
      "display" : "DASMA INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A004001421",
      "display" : "PILOCARPINE EYE DROPS 4％"
    },
    {
      "code" : "A004042100",
      "display" : "LICOTIN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A004044100",
      "display" : "THIAMINE HCL TABLETS \"VPP\""
    },
    {
      "code" : "A004048221",
      "display" : "TRACO SUSPENSION 1％ \"CHI SHENG\""
    },
    {
      "code" : "A004049221",
      "display" : "TRACON \"CHI SHENG\""
    },
    {
      "code" : "A004052100",
      "display" : "JOHNSTAL CAPSULES"
    },
    {
      "code" : "A004068429",
      "display" : "SELEAR EYE DROPS"
    },
    {
      "code" : "A004068435",
      "display" : "SELEAR EYE DROPS"
    },
    {
      "code" : "A004070321",
      "display" : "NILSTAT TOPICAL CREAM"
    },
    {
      "code" : "A004073221",
      "display" : "STACORT-A INJECTION 10MG \"STANDARD\""
    },
    {
      "code" : "A004073229",
      "display" : "STACORT-A INJECTION 10MG \"STANDARD\""
    },
    {
      "code" : "A004073299",
      "display" : "STACORT-A INJECTION 10MG \"STANDARD\""
    },
    {
      "code" : "A004074100",
      "display" : "AMPICILLIN CAPSULES 500MG \"N.K.\""
    },
    {
      "code" : "A004099100",
      "display" : "MECOSON TABLETS 15MG \"H.L.\""
    },
    {
      "code" : "A004101100",
      "display" : "NICOTINIC ACID TABLETS \"VPP\""
    },
    {
      "code" : "A004102100",
      "display" : "NICOTINAMIDE TABLETS \"VPP\""
    },
    {
      "code" : "A004115100",
      "display" : "GENCAN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A004122100",
      "display" : "BAOGIN TABLETS 2MG \"BOWLIN\""
    },
    {
      "code" : "A004151209",
      "display" : "KANAMYCIN SULFATE INJECTION \"SINTON\""
    },
    {
      "code" : "A004152100",
      "display" : "DEXSONE TABLETS 0.5MG"
    },
    {
      "code" : "A004156417",
      "display" : "VITA A EYE OINTMENT \"OASIS\""
    },
    {
      "code" : "A004163100",
      "display" : "ESCIN S.C. TABLETS"
    },
    {
      "code" : "A004166421",
      "display" : "COLSAMIN EYE DROPS"
    },
    {
      "code" : "A004176100",
      "display" : "TRIASYN B S.C. TABLETS \"R.S.P.P.\""
    },
    {
      "code" : "A004180100",
      "display" : "AMPICILLIN CAPSULES \"ASTAR\""
    },
    {
      "code" : "A004188417",
      "display" : "F.A.D. EYE OINTMENT"
    },
    {
      "code" : "A004189100",
      "display" : "RESERPINE TABLETS \"VPP\""
    },
    {
      "code" : "A004190100",
      "display" : "AMINOPHYLLINE AND PHENOBARBITAL TABLETS \"RSPP\""
    },
    {
      "code" : "A004194100",
      "display" : "LUNGING TABLETS"
    },
    {
      "code" : "A004200100",
      "display" : "ORETIN S.C. TABLETS \"CHIU PO\""
    },
    {
      "code" : "A004205100",
      "display" : "WEBOWELL TABLETS"
    },
    {
      "code" : "A004211100",
      "display" : "MULTIVITAMIN S.C. TABLETS \"CENTRAL\""
    },
    {
      "code" : "A004219100",
      "display" : "BISLAN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A004220100",
      "display" : "WEIFU TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A004221100",
      "display" : "LICA TABLETS"
    },
    {
      "code" : "A0042211G0",
      "display" : "LICA TABLETS"
    },
    {
      "code" : "A004222100",
      "display" : "BETA-DEXALONE TABLETS"
    },
    {
      "code" : "A004223100",
      "display" : "SULFISOMEZOLE TABLETS \"R.S.P.P.\""
    },
    {
      "code" : "A004229100",
      "display" : "ENTHACIN CAPSULES \"IDEAL\""
    },
    {
      "code" : "A004247100",
      "display" : "ERYTHROMYCIN CAPSULES \"CENTROL\""
    },
    {
      "code" : "A004249100",
      "display" : "DYNIN TABLETS"
    },
    {
      "code" : "A004255100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES \"ASTAR\""
    },
    {
      "code" : "A004256100",
      "display" : "CHLORAMPHENICOL CAPSULES \"ANSHIN\""
    },
    {
      "code" : "A004263100",
      "display" : "ANTICOUGH CAPSULES"
    },
    {
      "code" : "A004265100",
      "display" : "TONILIN CAPSULES (METRONIDAZOLE)\"M.T.\""
    },
    {
      "code" : "A004266100",
      "display" : "NAGOMIN TABLETS (NALIDIXIC ACID)\"M.T.\""
    },
    {
      "code" : "A004269212",
      "display" : "PYRABITAL INJECTION \"ASTAR\""
    },
    {
      "code" : "A004274100",
      "display" : "FUTYSOL S.C. TABLETS \"CHUI PO\""
    },
    {
      "code" : "A004276100",
      "display" : "EAZIDE TABLETS"
    },
    {
      "code" : "A0042761G0",
      "display" : "EAZIDE TABLETS"
    },
    {
      "code" : "A004280100",
      "display" : "DICLOCIL CAPSULES 250MG"
    },
    {
      "code" : "A004287100",
      "display" : "POTON CAPSULES"
    },
    {
      "code" : "A004300100",
      "display" : "TAWEGEN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A004301500",
      "display" : "METRODIN SUPPOSITORIES \"YUNG CHI\""
    },
    {
      "code" : "A004302100",
      "display" : "PUTELOME S.C. TABLETS"
    },
    {
      "code" : "A004305100",
      "display" : "SUDOLEM S.C. TABLETS"
    },
    {
      "code" : "A004306100",
      "display" : "ADREBLOCK TABLETS 40MG"
    },
    {
      "code" : "A004321100",
      "display" : "WARROWSOL CAPSULES \"KINGDOM\""
    },
    {
      "code" : "A004322229",
      "display" : "VITAMIN B COMPLEX INJECTION \"VPP\""
    },
    {
      "code" : "A004326100",
      "display" : "TEANLANG TABLETS"
    },
    {
      "code" : "A004334100",
      "display" : "RIMANCIN CAPUSLES"
    },
    {
      "code" : "A004347209",
      "display" : "VITAMIN K1 INJECTION \"N.K.\""
    },
    {
      "code" : "A004355212",
      "display" : "NICOXAN INJECTION"
    },
    {
      "code" : "A004360100",
      "display" : "DEXTROMETHORPHAN TABLETS"
    },
    {
      "code" : "A004385100",
      "display" : "DECOLIN TABLETS"
    },
    {
      "code" : "A004393100",
      "display" : "METROCYCLINE-P CAPSULES"
    },
    {
      "code" : "A004404100",
      "display" : "STUGEIN TABLETS"
    },
    {
      "code" : "A004411100",
      "display" : "TUBAX S.C. TABLETS"
    },
    {
      "code" : "A004414100",
      "display" : "SULOMIN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A004417100",
      "display" : "BULISIKANG-B EX S.C. TABLETS"
    },
    {
      "code" : "A004423100",
      "display" : "ESTROMON S.C. TABLETS"
    },
    {
      "code" : "A004441100",
      "display" : "DEAN TABLETS 5MG \"YUNG CHI\""
    },
    {
      "code" : "A004459109",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES 250MG/GM \"SINTON\""
    },
    {
      "code" : "A004459177",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES 250MG/GM \"SINTON\""
    },
    {
      "code" : "A004459199",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES 250MG/GM \"SINTON\""
    },
    {
      "code" : "A004461100",
      "display" : "ANTICOUGH TABLETS"
    },
    {
      "code" : "A004462100",
      "display" : "DEXAMETHASONE TABLETS \"ASTAR\""
    },
    {
      "code" : "A004463212",
      "display" : "SINTHATO INJECTION"
    },
    {
      "code" : "A004466297",
      "display" : "TRICILLIN INJECTION \"VPP\""
    },
    {
      "code" : "A004467210",
      "display" : "PROCAINE PENICILLIN G FOR AQUA INJECTION 1,500,000 UNITS \"VPP\""
    },
    {
      "code" : "A004475100",
      "display" : "PREDNISOLONE TABLETS \"ASTAR\""
    },
    {
      "code" : "A004484100",
      "display" : "SOLIKIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A004488421",
      "display" : "BISMING EYE DROPS"
    },
    {
      "code" : "A004489417",
      "display" : "COLIMYCIN EYE OINTMENT"
    },
    {
      "code" : "A004490417",
      "display" : "CHLORAMPHENICOL OPHTHALMIC OINTMENT"
    },
    {
      "code" : "A004491417",
      "display" : "ERYSMYCIN EYE OINTMENT"
    },
    {
      "code" : "A004492421",
      "display" : "ERYSMYCIN EYE DROPS"
    },
    {
      "code" : "A004495238",
      "display" : "MORIAMIN S-2 INJECTION"
    },
    {
      "code" : "A004495263",
      "display" : "MORIAMIN S-2 INJECTION"
    },
    {
      "code" : "A004506100",
      "display" : "FUCON TABLETS"
    },
    {
      "code" : "A004514100",
      "display" : "DUOCIDE TABLETS"
    },
    {
      "code" : "A004517100",
      "display" : "LI ERH KO S.C. TABLETS"
    },
    {
      "code" : "A004533212",
      "display" : "SULPYRIN INJECTION \"METRO\""
    },
    {
      "code" : "A004539157",
      "display" : "BOINTUSSIN SOLUTION 20MG/ML (GUAIFENESIN) \"BOWLIN\""
    },
    {
      "code" : "A004565209",
      "display" : "DECAMIN INJECTION 4MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A004565229",
      "display" : "DECAMIN INJECTION 4MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A004568100",
      "display" : "STOPAIN CAPSULES"
    },
    {
      "code" : "A004574100",
      "display" : "WINDOL TABLETS"
    },
    {
      "code" : "A004575100",
      "display" : "SECOBARBITAL SODIUM CAPSULES \"VPP\""
    },
    {
      "code" : "A004587238",
      "display" : "DEXTRON V INJECTION \"N.K.\""
    },
    {
      "code" : "A004643100",
      "display" : "XATONE E.C. TABLETS \"F.Y.\""
    },
    {
      "code" : "A004648100",
      "display" : "DECARON TABLETS"
    },
    {
      "code" : "A004649321",
      "display" : "LI KA LANG OINTMENT\"H.S.\""
    },
    {
      "code" : "A004649329",
      "display" : "LI KA LANG OINTMENT\"H.S.\""
    },
    {
      "code" : "A004649372",
      "display" : "LI KA LANG OINTMENT\"H.S.\""
    },
    {
      "code" : "A004649399",
      "display" : "LI KA LANG OINTMENT\"H.S.\""
    },
    {
      "code" : "A004662100",
      "display" : "CHICHESON TABLETS"
    },
    {
      "code" : "A004670100",
      "display" : "BOWLIN-C TABLETS"
    },
    {
      "code" : "A004675100",
      "display" : "RIF CAPSULES 150MG"
    },
    {
      "code" : "A004676100",
      "display" : "RIF CAPSULES 300MG"
    },
    {
      "code" : "A004678238",
      "display" : "MORIAMIN-2 INJECTION"
    },
    {
      "code" : "A004678263",
      "display" : "MORIAMIN-2 INJECTION"
    },
    {
      "code" : "A004678277",
      "display" : "MORIAMIN-2 INJECTION"
    },
    {
      "code" : "A004687100",
      "display" : "RIFAMTIBI CAPSULES 300MG"
    },
    {
      "code" : "A004692100",
      "display" : "COPALIN TABLETS (CHLORMEZANONE) \"M.T.\""
    },
    {
      "code" : "A004703100",
      "display" : "CHLORDIAZEPOXIDE HCL CAPSULES 10MG \"VPP\""
    },
    {
      "code" : "A004704100",
      "display" : "CHLORPHENIRAMINE TABLETS \"ASTAR\""
    },
    {
      "code" : "A004715100",
      "display" : "DIABETIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A0047151G0",
      "display" : "DIABETIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A004720100",
      "display" : "PAIDERTON TABLETS"
    },
    {
      "code" : "A004722100",
      "display" : "CYPRO TABLETS 4MG \"F.Y.\""
    },
    {
      "code" : "A004737100",
      "display" : "PILIAN TABLETS \"Y.S.\""
    },
    {
      "code" : "A0047371G0",
      "display" : "PILIAN TABLETS \"Y.S.\""
    },
    {
      "code" : "A004738100",
      "display" : "SULISTAN S.C. TABLETS"
    },
    {
      "code" : "A004739100",
      "display" : "CHISOU COUGH CAPSULES \"HCT\""
    },
    {
      "code" : "A004754100",
      "display" : "RIFAMTIBI CAPSULES 150MG"
    },
    {
      "code" : "A004755230",
      "display" : "JUPITER INJECTION 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A004755238",
      "display" : "JUPITER INJECTION 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A004761329",
      "display" : "SHIELIN POWDER"
    },
    {
      "code" : "A004763100",
      "display" : "HONTAN TABLETS"
    },
    {
      "code" : "A004766100",
      "display" : "LISU TABLETS \"H.S.\""
    },
    {
      "code" : "A004771238",
      "display" : "MAGNESIUM SULFATE INJECTION \"TBC\""
    },
    {
      "code" : "A004771263",
      "display" : "MAGNESIUM SULFATE INJECTION \"TBC\""
    },
    {
      "code" : "A004775100",
      "display" : "VALETA TABLETS \"ASTAR\""
    },
    {
      "code" : "A004776229",
      "display" : "AMINOPHYLLINE INJECTION \"ASTAR\""
    },
    {
      "code" : "A004778100",
      "display" : "LI SHIH NING CAPSULES 25MG \"C.H.\" (INDOMETHACIN)"
    },
    {
      "code" : "A004807100",
      "display" : "ANLISU TABLETS \"KINGDOM\""
    },
    {
      "code" : "A004811209",
      "display" : "SODIUM PHENOBARBITAL INJECTION 100MG/ML \"VPP\""
    },
    {
      "code" : "A004813100",
      "display" : "Aspirin Tablets 324mg \"VPP\""
    },
    {
      "code" : "A004815100",
      "display" : "DIAZEPAM TABLETS \"ASTAR\""
    },
    {
      "code" : "A004816100",
      "display" : "TOCHUN TABLETS \"Y.S.\""
    },
    {
      "code" : "A004817100",
      "display" : "TORCOL TABLETS \"Y.S.\""
    },
    {
      "code" : "A004820100",
      "display" : "CHITOU TABLETS \"Y.S.\""
    },
    {
      "code" : "A004823100",
      "display" : "CHUNCOTOL TABLETS \"Y.S.\""
    },
    {
      "code" : "A004828100",
      "display" : "DECHIMIN TABLETS"
    },
    {
      "code" : "A004829100",
      "display" : "ISETIN S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A004835100",
      "display" : "ECHICON TABLETS \"Y.S.\""
    },
    {
      "code" : "A004838100",
      "display" : "PISULOU CAPSULES \"Y.S.\""
    },
    {
      "code" : "A004842100",
      "display" : "SULFADIAZINE TABLETS \"T.S.\""
    },
    {
      "code" : "A004852212",
      "display" : "COUGSTIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A004853209",
      "display" : "TRILIZIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A004857100",
      "display" : "ZIKAN TABLETS \"Lita\""
    },
    {
      "code" : "A004864212",
      "display" : "LIDOCAINE HCI INJECTION 2％ \"CHI SHENG\""
    },
    {
      "code" : "A004864238",
      "display" : "LIDOCAINE HCI INJECTION 2％ \"CHI SHENG\""
    },
    {
      "code" : "A004864299",
      "display" : "LIDOCAINE HCI INJECTION 2％ \"CHI SHENG\""
    },
    {
      "code" : "A004865209",
      "display" : "VITAMIN K1 INJECTION"
    },
    {
      "code" : "A004867100",
      "display" : "YENPITIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A004891240",
      "display" : "VARIDASE FOR LOCAL AND TOPICAL USE"
    },
    {
      "code" : "A004891255",
      "display" : "VARIDASE FOR LOCAL AND TOPICAL USE"
    },
    {
      "code" : "A004892209",
      "display" : "VARIDASE INTRAMUSCULAR INJECTION"
    },
    {
      "code" : "A004892212",
      "display" : "VARIDASE INTRAMUSCULAR INJECTION"
    },
    {
      "code" : "A004899100",
      "display" : "NARIZIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A0048991G0",
      "display" : "NARIZIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A004904100",
      "display" : "TRANS CAPSULES"
    },
    {
      "code" : "A004917421",
      "display" : "ANGEL EYE DROPS"
    },
    {
      "code" : "A004919100",
      "display" : "BAKTAR TABLETS 400MG"
    },
    {
      "code" : "A0049191G0",
      "display" : "BAKTAR TABLETS 400MG"
    },
    {
      "code" : "A004921100",
      "display" : "CHLORAMINE TABLETS \"BOWLIN\""
    },
    {
      "code" : "A004928321",
      "display" : "BETADERM CREAM"
    },
    {
      "code" : "A004928329",
      "display" : "BETADERM CREAM"
    },
    {
      "code" : "A004928372",
      "display" : "BETADERM CREAM"
    },
    {
      "code" : "A004928399",
      "display" : "BETADERM CREAM"
    },
    {
      "code" : "A004932238",
      "display" : "LAMVITA INJECTION"
    },
    {
      "code" : "A004933100",
      "display" : "FUWEININ CAPSULES \"Y.S.\""
    },
    {
      "code" : "A004941100",
      "display" : "YUANBAO S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A004942209",
      "display" : "PROGESTERONE INJECTION 25MG \"PANBIOTIC\""
    },
    {
      "code" : "A004942221",
      "display" : "PROGESTERONE INJECTION 25MG \"PANBIOTIC\""
    },
    {
      "code" : "A004942229",
      "display" : "PROGESTERONE INJECTION 25MG \"PANBIOTIC\""
    },
    {
      "code" : "A004951209",
      "display" : "ATROPINE SULFATE INJECTION \"SINTONG\""
    },
    {
      "code" : "A004957100",
      "display" : "KANFUYEN CAPSULES"
    },
    {
      "code" : "A004963100",
      "display" : "TETRACYCLINE HCL CAPSULES \"C.C.P.\""
    },
    {
      "code" : "A0049631G0",
      "display" : "TETRACYCLINE HCL CAPSULES \"C.C.P.\""
    },
    {
      "code" : "A004973321",
      "display" : "RINDERON-VA CREAM 0.06％"
    },
    {
      "code" : "A004974416",
      "display" : "NEO-BETASON EYE OINTMENT"
    },
    {
      "code" : "A004975416",
      "display" : "EYE RINDERON-A SOLUTION"
    },
    {
      "code" : "A004975421",
      "display" : "EYE RINDERON-A SOLUTION"
    },
    {
      "code" : "A004977421",
      "display" : "YEN SAN EYE DROPS"
    },
    {
      "code" : "A004977429",
      "display" : "YEN SAN EYE DROPS"
    },
    {
      "code" : "A004979209",
      "display" : "PHENOTROPIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A004995100",
      "display" : "CEPHALIN CAPSULES"
    },
    {
      "code" : "A0049951G0",
      "display" : "CEPHALIN CAPSULES"
    },
    {
      "code" : "A004997277",
      "display" : "SIUNITOL INJECTION \"SIU GUAN\""
    },
    {
      "code" : "A005021100",
      "display" : "VITAMIN B2 TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005022100",
      "display" : "NASELIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A005024100",
      "display" : "ELINE S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A005026100",
      "display" : "SUIL S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A005034100",
      "display" : "OMNIN S.C. TABLETS"
    },
    {
      "code" : "A005040100",
      "display" : "PENTHO S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A005041100",
      "display" : "NICOXAN TABLETS"
    },
    {
      "code" : "A005045100",
      "display" : "Zhiyuntu Tablets \"Chen Ta\""
    },
    {
      "code" : "A0050451G0",
      "display" : "Zhiyuntu Tablets \"Chen Ta\""
    },
    {
      "code" : "A005051100",
      "display" : "NACID TABLETS"
    },
    {
      "code" : "A005054100",
      "display" : "INDOCINE CAPSULES"
    },
    {
      "code" : "A005056100",
      "display" : "GERI-VITA TABLETS \"VPP\""
    },
    {
      "code" : "A005062100",
      "display" : "Kidolex  Capsules  250mg (Cephalexin)"
    },
    {
      "code" : "A005075100",
      "display" : "PANAMAX TABLETS 500MG(ACETAMINOPHEN)"
    },
    {
      "code" : "A005090100",
      "display" : "ZUCAIN TABLETS \"CURIE\""
    },
    {
      "code" : "A005097100",
      "display" : "FETEFU TABLETS"
    },
    {
      "code" : "A005111100",
      "display" : "FLOPIN TABLETS"
    },
    {
      "code" : "A005118209",
      "display" : "PROGESTERONE INJECTION 25MG \"METRO\""
    },
    {
      "code" : "A005135100",
      "display" : "TZUCHUNAN TABLETS"
    },
    {
      "code" : "A005136100",
      "display" : "BALAMIN S.C. TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005185100",
      "display" : "TRIAMCINOLONE TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005191100",
      "display" : "KANGCHINMIN S.C. TABLETS"
    },
    {
      "code" : "A005200100",
      "display" : "PERSINE S.C. TABLETS 25MG"
    },
    {
      "code" : "A005203100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"CHIPHAR\""
    },
    {
      "code" : "A005225100",
      "display" : "COLCHICINE TABLETS"
    },
    {
      "code" : "A005227100",
      "display" : "PREDNISOLONE TABLETS \"DAU CHI\""
    },
    {
      "code" : "A005228100",
      "display" : "ZUNCHIN CAPSULES \"DAU CHI\""
    },
    {
      "code" : "A005232100",
      "display" : "COLD CAPSULES \"M.T.\""
    },
    {
      "code" : "A005243219",
      "display" : "KANAMYCIN INJECTION"
    },
    {
      "code" : "A005243238",
      "display" : "KANAMYCIN INJECTION"
    },
    {
      "code" : "A005243299",
      "display" : "KANAMYCIN INJECTION"
    },
    {
      "code" : "A005247100",
      "display" : "METHYLEPHEDRINE HCL TABLETS \"ASTAR\""
    },
    {
      "code" : "A005249100",
      "display" : "CYANTON CAPSULES \"Y.S.\""
    },
    {
      "code" : "A005250100",
      "display" : "LINAGAN TABLETS 25MG"
    },
    {
      "code" : "A005266100",
      "display" : "HYDRALAZINE HCL TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005272100",
      "display" : "HUEI YI CAPSULES \"J.H.\""
    },
    {
      "code" : "A005278209",
      "display" : "ERGOMETRINE MALEATE INJECTION 0.2MG \"SINTON\""
    },
    {
      "code" : "A005285100",
      "display" : "AZO-NEGACIDE TABLETS"
    },
    {
      "code" : "A005286100",
      "display" : "DEKESU TABLETS 0.5MG (DEXAMETHASONE)\"F.S.\""
    },
    {
      "code" : "A005290100",
      "display" : "EUROID TABLETS"
    },
    {
      "code" : "A005291100",
      "display" : "CHLORPHENIRAMINE TABLETS \"METRO\""
    },
    {
      "code" : "A005300100",
      "display" : "PHENOBARBITAL TABLETS 32MG \"VPP\""
    },
    {
      "code" : "A005305100",
      "display" : "SATAMOL TABLETS"
    },
    {
      "code" : "A005313100",
      "display" : "TRANTAL FILM COATED TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A005321100",
      "display" : "METOYUI CAPSULES \"DAU CHI\""
    },
    {
      "code" : "A005322100",
      "display" : "COMPOUND OPIUM AND GLYCYRRIZA MIXTURE TABLET"
    },
    {
      "code" : "A005323238",
      "display" : "CHLORAMPHENICOL INJECTION"
    },
    {
      "code" : "A005324209",
      "display" : "DELTONIN INJECTION \"N.K.\""
    },
    {
      "code" : "A005324221",
      "display" : "DELTONIN INJECTION \"N.K.\""
    },
    {
      "code" : "A005330100",
      "display" : "EGALIN TABLETS"
    },
    {
      "code" : "A005344209",
      "display" : "TUTANIN INJECTION \"SINTON\""
    },
    {
      "code" : "A005352100",
      "display" : "VITACOMPLEX B S.C. TABLETS \"F.S.\""
    },
    {
      "code" : "A005353100",
      "display" : "HICONCIL CAPSULES 500MG"
    },
    {
      "code" : "A005354100",
      "display" : "HICONCIL CAPSULES 250MG"
    },
    {
      "code" : "A005359100",
      "display" : "METRODIN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A005365109",
      "display" : "TETRACYCLINE GRANULES \"ASTAR\""
    },
    {
      "code" : "A005365177",
      "display" : "TETRACYCLINE GRANULES \"ASTAR\""
    },
    {
      "code" : "A005381100",
      "display" : "Shuton Capsules \"Y.K.\""
    },
    {
      "code" : "A005391100",
      "display" : "SHIMIN TABLETS \"N.W.\""
    },
    {
      "code" : "A005412100",
      "display" : "MEDISOL TABLETS 15MG \"Y.K.\""
    },
    {
      "code" : "A005414100",
      "display" : "WNSHINLIEN S.C. TABLETS 12.5MG (DIPYRIDAMOLE)\"F.S.\""
    },
    {
      "code" : "A005418100",
      "display" : "O.D.K. CAPSULES"
    },
    {
      "code" : "A005420100",
      "display" : "RONPILINE TABLETS \"DAU CHI\""
    },
    {
      "code" : "A005431100",
      "display" : "NALIXIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A005435100",
      "display" : "RHEUMASTON CAPSULES"
    },
    {
      "code" : "A005443100",
      "display" : "RIPOLIN CAPSULES 450MG"
    },
    {
      "code" : "A005445100",
      "display" : "PARAFLEX CAPSULES 500MG \"PANBIOTIC\""
    },
    {
      "code" : "A005446100",
      "display" : "PARAFLEX CAPSULES 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A005454100",
      "display" : "AMCICORT TABLETS \"Y.K.\""
    },
    {
      "code" : "A005482109",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES \"ASTAR\""
    },
    {
      "code" : "A005482199",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES \"ASTAR\""
    },
    {
      "code" : "A005483212",
      "display" : "DIPROPHYLLIN  INJEDTION \"SINTON\""
    },
    {
      "code" : "A005491100",
      "display" : "AMPICILLIN CAPSULES 500MG \"PRINCE\""
    },
    {
      "code" : "A005495100",
      "display" : "DOINMYCIN CAPSULES"
    },
    {
      "code" : "A005508100",
      "display" : "GLARE CAPSULES \"F.Y.\""
    },
    {
      "code" : "A005515100",
      "display" : "AMINOPHYLLINE TABLETS \"Lita\""
    },
    {
      "code" : "A005517100",
      "display" : "INDOSUN E.C. TABLETS"
    },
    {
      "code" : "A005519100",
      "display" : "CHINCOUGH CAPSULES \"PANBIOTIC\""
    },
    {
      "code" : "A005521421",
      "display" : "CODEMYCIN EYE DROPS"
    },
    {
      "code" : "A005575316",
      "display" : "ESPERSON OINTMENT 0.25％"
    },
    {
      "code" : "A005575321",
      "display" : "ESPERSON OINTMENT 0.25％"
    },
    {
      "code" : "A005575343",
      "display" : "ESPERSON OINTMENT 0.25％"
    },
    {
      "code" : "A005592317",
      "display" : "CHLORTETRACYCLINE OINTMENT (OPHTHALMIC) \"UNION\""
    },
    {
      "code" : "A005592417",
      "display" : "CHLORTETRACYCLINE OINTMENT (OPHTHALMIC) \"UNION\""
    },
    {
      "code" : "A005592421",
      "display" : "CHLORTETRACYCLINE OINTMENT (OPHTHALMIC) \"UNION\""
    },
    {
      "code" : "A005593209",
      "display" : "EREMON INJECTION"
    },
    {
      "code" : "A005603221",
      "display" : "GLUCAL BLACK INJECTION"
    },
    {
      "code" : "A005603243",
      "display" : "GLUCAL BLACK INJECTION"
    },
    {
      "code" : "A005612100",
      "display" : "BUTOSAN S.C. TABLETS"
    },
    {
      "code" : "A005616229",
      "display" : "DEXAMETHASONE-21 INJECTION 1MG/ML\"C.Y.\""
    },
    {
      "code" : "A005627229",
      "display" : "OXYTETRACYCLINE HCL 50MG/ML I.M. INJECTION \"Union\""
    },
    {
      "code" : "A005628221",
      "display" : "PHENAMINCAL-B6 INJECTION \"C.Y.\""
    },
    {
      "code" : "A005628229",
      "display" : "PHENAMINCAL-B6 INJECTION \"C.Y.\""
    },
    {
      "code" : "A005646100",
      "display" : "WEISKON S.C. TABLETS \"H.C.T.\""
    },
    {
      "code" : "A005661500",
      "display" : "OMNIN VAGINAL TABLETS"
    },
    {
      "code" : "A005662135",
      "display" : "SIMAGAL SUSPENSION"
    },
    {
      "code" : "A005663100",
      "display" : "TEALIGEN CAPSULES \"T.L.B\""
    },
    {
      "code" : "A005664100",
      "display" : "FLUFEMIN CAPSULES"
    },
    {
      "code" : "A005669100",
      "display" : "AMINOPHYLLINE TABLETS \"ASTAR\""
    },
    {
      "code" : "A005673100",
      "display" : "LIVOCTAN S.C. TABLETS"
    },
    {
      "code" : "A005691100",
      "display" : "CAFETON TABLETS \"Y.K.\""
    },
    {
      "code" : "A005698100",
      "display" : "URIAN TABLETS"
    },
    {
      "code" : "A005701100",
      "display" : "LASPIN TABLETS"
    },
    {
      "code" : "A005702100",
      "display" : "SUNCHLOMYCIN CAPSULES"
    },
    {
      "code" : "A005703100",
      "display" : "NEWMOMYCIN CAPSULES"
    },
    {
      "code" : "A005704100",
      "display" : "ETHROMYCIN-S CAPSULES"
    },
    {
      "code" : "A005708100",
      "display" : "BROWN MIXTURE TABLETS"
    },
    {
      "code" : "A005710100",
      "display" : "RIBOFLAVIN TABLETS \"ASTAR\""
    },
    {
      "code" : "A005711100",
      "display" : "PYRIDOXINE HCL TABLETS \"ASTAR\""
    },
    {
      "code" : "A005712100",
      "display" : "DIPROPHYLLIN TABLETS \"ASTAR\""
    },
    {
      "code" : "A005716100",
      "display" : "PRINCEMYLON CAPSULES 500MG \"PRINCE\""
    },
    {
      "code" : "A005721100",
      "display" : "SWECON TABLETS"
    },
    {
      "code" : "A005723100",
      "display" : "PYRIDOXINE HCL TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005724100",
      "display" : "PHYTOMENADIONE TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005737100",
      "display" : "VITALUX TABLETS"
    },
    {
      "code" : "A005749100",
      "display" : "MEDISOL CAPSULES 30MG \"Y.K.\""
    },
    {
      "code" : "A005753212",
      "display" : "THIAMINE HYDROCHLORIDE INJECTION 50MG \"ASTAR\""
    },
    {
      "code" : "A005757100",
      "display" : "CHIERHSIN TABLETS 10mg"
    },
    {
      "code" : "A005773100",
      "display" : "TRIACT TABLETS"
    },
    {
      "code" : "A005789100",
      "display" : "FUSTON TABLETS 100MG \"Y.S.\""
    },
    {
      "code" : "A005807100",
      "display" : "LONFLEX CAPSULES \"UNION\""
    },
    {
      "code" : "A005810100",
      "display" : "ASTHONE TABLETS"
    },
    {
      "code" : "A005811100",
      "display" : "STROCAIN TABLETS"
    },
    {
      "code" : "A0058111G0",
      "display" : "STROCAIN TABLETS"
    },
    {
      "code" : "A005812100",
      "display" : "HOMOCLOMIN TABLETS"
    },
    {
      "code" : "A0058121G0",
      "display" : "HOMOCLOMIN TABLETS"
    },
    {
      "code" : "A005813100",
      "display" : "SOLAXIN TABLETS"
    },
    {
      "code" : "A0058131G0",
      "display" : "SOLAXIN TABLETS"
    },
    {
      "code" : "A005827100",
      "display" : "AMINOPHYLLINE TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005833100",
      "display" : "TANCOSIL TABLETS 200MG\"ROYAL\""
    },
    {
      "code" : "A005838100",
      "display" : "VITAMIN B COMPLEX TABLETS"
    },
    {
      "code" : "A005852209",
      "display" : "INJECTIO APOMORPHINAE HYDROCHLORIDI"
    },
    {
      "code" : "A005855209",
      "display" : "INJECTIO ALKALODI OPII HYDROCHLORIDI ET SCOPOLAMINAE"
    },
    {
      "code" : "A005857100",
      "display" : "CODEINE PHOSPHATE TABLETS 15 MG"
    },
    {
      "code" : "A005858100",
      "display" : "Pethidine Hydrochloride Tablets 50 mg"
    },
    {
      "code" : "A005859100",
      "display" : "TABELLAE MISTURAE GLYCYRRHIZAE COMPOSITAE"
    },
    {
      "code" : "A005860100",
      "display" : "MORPHINE HYDROCHLORIDE TABLET 10MG"
    },
    {
      "code" : "A005862209",
      "display" : "INJECTIO MORPHINAE ET ATROPINAE"
    },
    {
      "code" : "A005863117",
      "display" : "CAMPHORATED OPIUM TINCTURE"
    },
    {
      "code" : "A005863177",
      "display" : "CAMPHORATED OPIUM TINCTURE"
    },
    {
      "code" : "A005863199",
      "display" : "CAMPHORATED OPIUM TINCTURE"
    },
    {
      "code" : "A005864209",
      "display" : "INJECTIO ALKALOIDI OPII HYDROCHLORIDI 20 MG"
    },
    {
      "code" : "A005865100",
      "display" : "Codeine Phosphate Tablets 30mg"
    },
    {
      "code" : "A005868148",
      "display" : "PULVIS OPII ET IPECACUANHAE"
    },
    {
      "code" : "A005868155",
      "display" : "PULVIS OPII ET IPECACUANHAE"
    },
    {
      "code" : "A005868199",
      "display" : "PULVIS OPII ET IPECACUANHAE"
    },
    {
      "code" : "A005869117",
      "display" : "OPIUM TINCTURE"
    },
    {
      "code" : "A005869155",
      "display" : "OPIUM TINCTURE"
    },
    {
      "code" : "A005869199",
      "display" : "OPIUM TINCTURE"
    },
    {
      "code" : "A005874209",
      "display" : "PETHIDINE HYDROCHLORIDE INJECTION 50MG/ML"
    },
    {
      "code" : "A005877100",
      "display" : "TABELLAE NOSCAPINAE HYDROCHLORIDUM 15 MG"
    },
    {
      "code" : "A005879117",
      "display" : "MISTURA GLYCYRRHIZA COMPOSITA"
    },
    {
      "code" : "A005879118",
      "display" : "MISTURA GLYCYRRHIZA COMPOSITA"
    },
    {
      "code" : "A005879177",
      "display" : "MISTURA GLYCYRRHIZA COMPOSITA"
    },
    {
      "code" : "A005879199",
      "display" : "MISTURA GLYCYRRHIZA COMPOSITA"
    },
    {
      "code" : "A005882100",
      "display" : "TABELLAE PAPAVERINAE HYDROCHLORIDI 30MG"
    },
    {
      "code" : "A005886209",
      "display" : "MORPHINE HYDROCHLORIDE INJECTION 20MG/ML"
    },
    {
      "code" : "A005888100",
      "display" : "TABELLAE OPII ET IPECACUANHAE 0.3 GM"
    },
    {
      "code" : "A005889209",
      "display" : "CODEINE PHOSPHATE INJECTION 15MG/ML"
    },
    {
      "code" : "A005891209",
      "display" : "Morphine Hydrochloride Injection 10mg/mL"
    },
    {
      "code" : "A005895118",
      "display" : "COMPOUND MIXTURE OF GLYCYRRHIZA"
    },
    {
      "code" : "A005896209",
      "display" : "IMPERAN INJECTION \"N.K.\""
    },
    {
      "code" : "A005896212",
      "display" : "IMPERAN INJECTION \"N.K.\""
    },
    {
      "code" : "A005925100",
      "display" : "MERISLON TABLETS 6MG (BETAHISTINE MESILATE)"
    },
    {
      "code" : "A0059251G0",
      "display" : "MERISLON TABLETS 6MG (BETAHISTINE MESILATE)"
    },
    {
      "code" : "A005936100",
      "display" : "SETON TABLETS 100MG (ETHAVERINE)"
    },
    {
      "code" : "A005945100",
      "display" : "DEXTROMETHORPHAN TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A005949500",
      "display" : "INTOCIN SUPPOSITORIES"
    },
    {
      "code" : "A005952100",
      "display" : "PROVIRON CAPSULE"
    },
    {
      "code" : "A005953100",
      "display" : "HIJUVEN CAPSULES"
    },
    {
      "code" : "A005954100",
      "display" : "COSPANON CAPSULES"
    },
    {
      "code" : "A0059541G0",
      "display" : "COSPANON CAPSULES"
    },
    {
      "code" : "A005986100",
      "display" : "MENIPERAN TABLETS 5MG \"M.T.\"(METOCLOPRAMIDE HCl)"
    },
    {
      "code" : "A005987100",
      "display" : "INOLIN TABLETS 3MG"
    },
    {
      "code" : "A005989100",
      "display" : "INDOCAPS CAPSULES \"Y.K.\""
    },
    {
      "code" : "A005995209",
      "display" : "CAPRONE INJECTION"
    },
    {
      "code" : "A006003100",
      "display" : "ERGONOVINE MALEATE F.C. TABLETS \"T.F.\""
    },
    {
      "code" : "A006006100",
      "display" : "PONSTAL CAPSULES"
    },
    {
      "code" : "A006081212",
      "display" : "METOPRAN INJECTION"
    },
    {
      "code" : "A006086317",
      "display" : "FLUO A OINTMENT 0.03％ (FLUOCINOLONE)"
    },
    {
      "code" : "A006087100",
      "display" : "PITHATE TABLETS \"Y.K.\""
    },
    {
      "code" : "A006094100",
      "display" : "CYCLAN CAPSULES"
    },
    {
      "code" : "A006097100",
      "display" : "TETRACYCLINE HCL CAPSULES"
    },
    {
      "code" : "A006124238",
      "display" : "SORBITOL INJECTION 20％ \"CHI SHENG\""
    },
    {
      "code" : "A006125277",
      "display" : "SORBITOL INJECTION 5％ \"CHI SHENG\""
    },
    {
      "code" : "A006130100",
      "display" : "COLD TABLETS \"CHEN TA\""
    },
    {
      "code" : "A006171100",
      "display" : "HEPI CAPSULES \"H.C.T.\""
    },
    {
      "code" : "A006172100",
      "display" : "CHLORPHENIRAMINE MALEATE TABLETS \"S.S.P.\""
    },
    {
      "code" : "A006187417",
      "display" : "COLSAMIN EYE OINTMENT"
    },
    {
      "code" : "A006194100",
      "display" : "PRONALOL TABLETS"
    },
    {
      "code" : "A006228100",
      "display" : "PENAZOL S.C. TABLETS"
    },
    {
      "code" : "A006229100",
      "display" : "SOLMATIN TABLETS"
    },
    {
      "code" : "A006230100",
      "display" : "HELFATON S.C. TABLETS"
    },
    {
      "code" : "A006232100",
      "display" : "MATALMIN TABLETS 200MG \"W.S.\""
    },
    {
      "code" : "A006233100",
      "display" : "ENTERAN S.C. TABLETS"
    },
    {
      "code" : "A006235109",
      "display" : "POWDERED OPIUM"
    },
    {
      "code" : "A006235177",
      "display" : "POWDERED OPIUM"
    },
    {
      "code" : "A006235199",
      "display" : "POWDERED OPIUM"
    },
    {
      "code" : "A006236100",
      "display" : "BUSHITON S.C. TABLETS \"C.L.\""
    },
    {
      "code" : "A006245100",
      "display" : "KINLIZONE TABLETS"
    },
    {
      "code" : "A006271100",
      "display" : "FUCOLE PARAN TABLETS"
    },
    {
      "code" : "A006299100",
      "display" : "NETHILINE S.C. TABLETS"
    },
    {
      "code" : "A006316100",
      "display" : "CENTICON TABLETS \"F.B.\""
    },
    {
      "code" : "A006318100",
      "display" : "CENTRARIN TABLETS"
    },
    {
      "code" : "A006344100",
      "display" : "BUSTON S.C. TABLETS"
    },
    {
      "code" : "A006345100",
      "display" : "INDETOLE S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A006347100",
      "display" : "RIBOFLAVIN TABLETS 10MG \"S.S.P.\""
    },
    {
      "code" : "A006352100",
      "display" : "EFFORCARDIA TABLETS"
    },
    {
      "code" : "A006354100",
      "display" : "WEI E S.C. TABLETS"
    },
    {
      "code" : "A006373100",
      "display" : "HEMAGEN CAPSULES"
    },
    {
      "code" : "A006378209",
      "display" : "JNFLIN INJECTION 1GM"
    },
    {
      "code" : "A006388100",
      "display" : "URIDINE S.C. TABLETS \"N.W.\""
    },
    {
      "code" : "A006393100",
      "display" : "PYRIDOXINE HCL TABLETS 10MG \"S.S.P.\""
    },
    {
      "code" : "A006394100",
      "display" : "Pyridamole F.C. Tablets 25mg"
    },
    {
      "code" : "A006397100",
      "display" : "EDEMALIN TABLETS"
    },
    {
      "code" : "A006423500",
      "display" : "REFLOX SUPPOSITORIES"
    },
    {
      "code" : "A006451100",
      "display" : "RECORTAN S.C. TABLETS"
    },
    {
      "code" : "A006477100",
      "display" : "JICHUAN TABLETS \"N.M.\""
    },
    {
      "code" : "A006485500",
      "display" : "Lybrile Suppositories"
    },
    {
      "code" : "A006486100",
      "display" : "CYPROHEPTADINE TABLETS 2MG \"F.S.\""
    },
    {
      "code" : "A006501100",
      "display" : "SCHENTESE TABLETS \"H.H.P.\""
    },
    {
      "code" : "A006512277",
      "display" : "MANNITOL INJECTION 10％"
    },
    {
      "code" : "A006514277",
      "display" : "2.5％ DEXTROSE IN 0.45％ SALINE"
    },
    {
      "code" : "A006538100",
      "display" : "BETAMETHASONE TABLETS"
    },
    {
      "code" : "A006543100",
      "display" : "PREDNISOLONE TABLETS 5MG \"CHEN TA\""
    },
    {
      "code" : "A006551100",
      "display" : "NIRAMINE TABLETS 4MG \"CHEN TA\" (CHLORGHENIRAMINE MALEATE)"
    },
    {
      "code" : "A006552100",
      "display" : "ALLERMIN TABLETS 4MG"
    },
    {
      "code" : "A006553100",
      "display" : "ALUMINUM HYDROXIDE DRIED GEL TABLETS \"HONTEN\""
    },
    {
      "code" : "A006554100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"HONTEN\""
    },
    {
      "code" : "A006558100",
      "display" : "NITOX CAPSULES"
    },
    {
      "code" : "A006560100",
      "display" : "TONTI CAPSULES"
    },
    {
      "code" : "A006562100",
      "display" : "BRONCHODIL TABLETS"
    },
    {
      "code" : "A006567100",
      "display" : "DIAZIPAM TABLETS 5MG \"F.S.\""
    },
    {
      "code" : "A006568100",
      "display" : "NALIDIXIC ACID TABLETS 250MG \"F.S.\""
    },
    {
      "code" : "A006571500",
      "display" : "INDOCAPS SUPPOSITORY \"N.W.\""
    },
    {
      "code" : "A006572277",
      "display" : "YEIAMIN-X INJECTION"
    },
    {
      "code" : "A006574100",
      "display" : "WAN RIH NIN CAPSULES \"C.H.\""
    },
    {
      "code" : "A006598100",
      "display" : "HORM CAPSULES"
    },
    {
      "code" : "A006602100",
      "display" : "MULTI-VITAMIN S.C. TABLETS \"C.M.\""
    },
    {
      "code" : "A006611329",
      "display" : "NEOMYCIN OINTMENT"
    },
    {
      "code" : "A006611340",
      "display" : "NEOMYCIN OINTMENT"
    },
    {
      "code" : "A006611342",
      "display" : "NEOMYCIN OINTMENT"
    },
    {
      "code" : "A006611372",
      "display" : "NEOMYCIN OINTMENT"
    },
    {
      "code" : "A006611399",
      "display" : "NEOMYCIN OINTMENT"
    },
    {
      "code" : "A006613212",
      "display" : "METORAMIN INJECTION \"T.S.\""
    },
    {
      "code" : "A006615100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES \"METRO\""
    },
    {
      "code" : "A006616209",
      "display" : "SUNAMON INJECTION \"ASTAR\""
    },
    {
      "code" : "A006618100",
      "display" : "ZITHINE TABLETS \"Honten\""
    },
    {
      "code" : "A006629100",
      "display" : "TINTEN TABLETS 500MG"
    },
    {
      "code" : "A006638100",
      "display" : "CHINCHEN TABLETS"
    },
    {
      "code" : "A006645100",
      "display" : "METHYLEPHEDRINE TABLETS \"TEM CPARP\""
    },
    {
      "code" : "A006649100",
      "display" : "KRECIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A006677100",
      "display" : "VALEMATE TABLETS 10 MG"
    },
    {
      "code" : "A006678209",
      "display" : "SUNAMON DEPOT INJECTION \"ASTAR\""
    },
    {
      "code" : "A006691100",
      "display" : "UCALON TABLETS 0.5MG \"CHEN TA\" (DEXAMETHASONE)"
    },
    {
      "code" : "A006695100",
      "display" : "MELLERIN S.C. TABLETS"
    },
    {
      "code" : "A006696100",
      "display" : "DICYCLOMINE TABLETS \"F.B\""
    },
    {
      "code" : "A006697100",
      "display" : "GLIBENCLAMIDE TABLETS \"C.T.\""
    },
    {
      "code" : "A006698100",
      "display" : "LONGCORT TABLETS"
    },
    {
      "code" : "A006702100",
      "display" : "HUO LI CHIEN KANG S.C. TABLETS"
    },
    {
      "code" : "A006705100",
      "display" : "MINIPRESS TABLETS 2MG"
    },
    {
      "code" : "A006706100",
      "display" : "MINIPRESS TABLETS 1MG"
    },
    {
      "code" : "A006747100",
      "display" : "CEPHALEXIN CAPSULES 250mg \"TBC\""
    },
    {
      "code" : "A0067471G0",
      "display" : "CEPHALEXIN CAPSULES 250mg \"TBC\""
    },
    {
      "code" : "A006749209",
      "display" : "Longcort  Injection\"Astar\""
    },
    {
      "code" : "A006761100",
      "display" : "TRIZYLASE CAPSULES \"BOWLIN\""
    },
    {
      "code" : "A006774212",
      "display" : "BUTONSAN INJECTION"
    },
    {
      "code" : "A006783212",
      "display" : "JNLINAMIN INJECTION \"C.Y.\""
    },
    {
      "code" : "A006784212",
      "display" : "VITAMIN B-COMPLEX & C INJECTION \"C.Y.\""
    },
    {
      "code" : "A006787277",
      "display" : "CELODIN INJECTION 500 MG \"CHI SHENG\""
    },
    {
      "code" : "A006788265",
      "display" : "CELODIN INJECTION 250MG \"CHI SHENG\""
    },
    {
      "code" : "A006795100",
      "display" : "MAGNESIUM OXIDE TABLETS \"HONTEN\""
    },
    {
      "code" : "A006817100",
      "display" : "WEGANN S.C. TABLETS"
    },
    {
      "code" : "A006819100",
      "display" : "CHLORPROMAZINE HCL S.C. TABLETS 50MG \"VPP\""
    },
    {
      "code" : "A006820277",
      "display" : "SODIUM AMPICILLIN FOR INJECTION 500MG \"VPP\""
    },
    {
      "code" : "A006821100",
      "display" : "AMPICILLIN CAPSULES 250MG \"VPP\""
    },
    {
      "code" : "A006822100",
      "display" : "CHLORPROMAZINE HCL S.C. TABLETS 25MG \"VPP\""
    },
    {
      "code" : "A006823100",
      "display" : "CHLORPROPAMIDE TABLETS \"RSPP\""
    },
    {
      "code" : "A006824100",
      "display" : "DIGOXIN TABLETS \"RSPP\""
    },
    {
      "code" : "A006827100",
      "display" : "AMINOPHYLLINE TABLETS 100MG \"VPP\""
    },
    {
      "code" : "A006849100",
      "display" : "YEA BUN CAPSULES \"L.D.\""
    },
    {
      "code" : "A006851100",
      "display" : "ACETAMINOPHEN TABLETS \"P.L.\""
    },
    {
      "code" : "A006859209",
      "display" : "SINCOPAN INJECTION"
    },
    {
      "code" : "A006865100",
      "display" : "CLOFIBRATE CAPSULES \"HON TEN\""
    },
    {
      "code" : "A006868100",
      "display" : "NINCONIOCHI CAPSULES \"T.L.B\""
    },
    {
      "code" : "A006869100",
      "display" : "YOURISIN TABLETS 500MG \"CHEN TA\" (NALIDIXIC ACID)"
    },
    {
      "code" : "A006873100",
      "display" : "TUNFON TABLETS \"H.C.T.\""
    },
    {
      "code" : "A006932209",
      "display" : "INCHLOMYCIN SODIUM SUCCINATE INJECTION 1GM \"C.Y.\""
    },
    {
      "code" : "A006939209",
      "display" : "AMPICILLIN INJECTION \"UNION\""
    },
    {
      "code" : "A006939212",
      "display" : "AMPICILLIN INJECTION \"UNION\""
    },
    {
      "code" : "A006939277",
      "display" : "AMPICILLIN INJECTION \"UNION\""
    },
    {
      "code" : "A006943100",
      "display" : "TETOCYN CAPSULES"
    },
    {
      "code" : "A006959100",
      "display" : "TERIMAN CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A006964100",
      "display" : "SEDITON TABLETS"
    },
    {
      "code" : "A006984100",
      "display" : "METHYLTESTOSTERONE TABLETS 10MG \"VPP\""
    },
    {
      "code" : "A006987100",
      "display" : "Ririton S. C. Tablets"
    },
    {
      "code" : "A007014100",
      "display" : "VITAMIN B6 TABLETS"
    },
    {
      "code" : "A007021100",
      "display" : "LANYI S.C. TABLETS"
    },
    {
      "code" : "A007024100",
      "display" : "FUNIONE TABLETS 250MG (METRONIDAZOLE)"
    },
    {
      "code" : "A007037100",
      "display" : "\"UBIP\"CERIATIN TABLETS"
    },
    {
      "code" : "A007038100",
      "display" : "Promin Tablets"
    },
    {
      "code" : "A007061100",
      "display" : "GLIMIDE TABLETS \"VEIMIN\""
    },
    {
      "code" : "A007062100",
      "display" : "FUROSIX TABLETS \"VEIMIN\""
    },
    {
      "code" : "A007067100",
      "display" : "POLUN S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A007072100",
      "display" : "SELANTYL TABLETS"
    },
    {
      "code" : "A007073100",
      "display" : "LNDACIN CAPSULES"
    },
    {
      "code" : "A007074100",
      "display" : "VITAMIN C TABLETS \"METRO\""
    },
    {
      "code" : "A007081100",
      "display" : "INCHLOMYCIN S.C. TABLETS 50MG \"C.Y.\""
    },
    {
      "code" : "A007091100",
      "display" : "INCHLOMYCIN CAPSULES \"C.Y.\""
    },
    {
      "code" : "A007096209",
      "display" : "CYANOCOBALAMIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A007096229",
      "display" : "CYANOCOBALAMIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A007114209",
      "display" : "EPHEDRINE SULFATE INJECTION 25MG/ML \"VPP\""
    },
    {
      "code" : "A007139100",
      "display" : "VITAMIN B6 TABLETS \"METRO\""
    },
    {
      "code" : "A007140100",
      "display" : "CHLORZOXAZONE TABLETS 250mg \"VPC\""
    },
    {
      "code" : "A0071401G0",
      "display" : "CHLORZOXAZONE TABLETS 250mg \"VPC\""
    },
    {
      "code" : "A007141100",
      "display" : "VITAMINE B6 TABLETS \"HON TEN\""
    },
    {
      "code" : "A007157100",
      "display" : "OXAPAM TABLETS"
    },
    {
      "code" : "A007165100",
      "display" : "ANZULENE S.C. TABLETS \"Y.K.\""
    },
    {
      "code" : "A007167329",
      "display" : "KONIF OINTMENT \"CHEN TA\""
    },
    {
      "code" : "A007167335",
      "display" : "KONIF OINTMENT \"CHEN TA\""
    },
    {
      "code" : "A007167377",
      "display" : "KONIF OINTMENT \"CHEN TA\""
    },
    {
      "code" : "A007167399",
      "display" : "KONIF OINTMENT \"CHEN TA\""
    },
    {
      "code" : "A007174100",
      "display" : "PRANOL TABLETS 40MG \"JOHNSON\""
    },
    {
      "code" : "A007175100",
      "display" : "PRANOL TABLETS 20MG \"JOHNSON\""
    },
    {
      "code" : "A007190100",
      "display" : "TENSANLIN TABLETS"
    },
    {
      "code" : "A007202100",
      "display" : "PUN LIH LONG TABLETS \"L.D.\""
    },
    {
      "code" : "A007203100",
      "display" : "ASTHPHYPIN TABLETS"
    },
    {
      "code" : "A007204229",
      "display" : "LIFUTIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A007213100",
      "display" : "AMINOPHYLLINE TABLETS \"C.A.\""
    },
    {
      "code" : "A007219355",
      "display" : "BETTER-IODINE SURGICAL SCRUB (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A007219363",
      "display" : "BETTER-IODINE SURGICAL SCRUB (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A007219399",
      "display" : "BETTER-IODINE SURGICAL SCRUB (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A007220318",
      "display" : "BETTER-IODINE ALCOHOLIC SOLUTION \"WEI-MING\""
    },
    {
      "code" : "A007220363",
      "display" : "BETTER-IODINE ALCOHOLIC SOLUTION \"WEI-MING\""
    },
    {
      "code" : "A007220399",
      "display" : "BETTER-IODINE ALCOHOLIC SOLUTION \"WEI-MING\""
    },
    {
      "code" : "A007221318",
      "display" : "BETTER-IODINE AQUEOUS SOLUTION (POVIDONE IODINE) \"WEI -MING\""
    },
    {
      "code" : "A007221355",
      "display" : "BETTER-IODINE AQUEOUS SOLUTION (POVIDONE IODINE) \"WEI -MING\""
    },
    {
      "code" : "A007221399",
      "display" : "BETTER-IODINE AQUEOUS SOLUTION (POVIDONE IODINE) \"WEI -MING\""
    },
    {
      "code" : "A007233100",
      "display" : "DOXYCYCLINE CAPSULES"
    },
    {
      "code" : "A007243100",
      "display" : "EPHEDRINE HCL TABLETS 25MG \"VPP\""
    },
    {
      "code" : "A007245100",
      "display" : "AMINOPHYLLINE TABLETS 100MG \"Standard\""
    },
    {
      "code" : "A007254100",
      "display" : "DECARONE TABLETS"
    },
    {
      "code" : "A007256100",
      "display" : "PROCID TABLETS"
    },
    {
      "code" : "A007258100",
      "display" : "CHLORAMPHENICOL CAPSULES 250MG \"VPP\""
    },
    {
      "code" : "A007261100",
      "display" : "BETASHIN TABLETS"
    },
    {
      "code" : "A007264100",
      "display" : "BETAMETHASONE TABLETS"
    },
    {
      "code" : "A007265321",
      "display" : "XYLO OINTMENT"
    },
    {
      "code" : "A007266100",
      "display" : "FUNINTAN S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A007270238",
      "display" : "SINKOTON INJECTION \"ASTAR\""
    },
    {
      "code" : "A007275212",
      "display" : "METACOLI INJECTION 2000000 UNITS \"CHI SHENG\""
    },
    {
      "code" : "A007276148",
      "display" : "METACOLI GRANULES 1500000 UNITS \"CHI SHENG\""
    },
    {
      "code" : "A007279100",
      "display" : "ESTRIOL TABLETS \"GOODRUG\""
    },
    {
      "code" : "A007322229",
      "display" : "METAPLEX INJECTION"
    },
    {
      "code" : "A007342100",
      "display" : "APULON TABLETS \"Y.S.\""
    },
    {
      "code" : "A007356100",
      "display" : "SANKIRIN S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A007362100",
      "display" : "CHINACAN TABLETS"
    },
    {
      "code" : "A007371100",
      "display" : "VASODILAN TABLETS"
    },
    {
      "code" : "A007372100",
      "display" : "GRISEOFULVIN TABLETS"
    },
    {
      "code" : "A007374100",
      "display" : "MAGNESIUM HYDROXIDE TABLETS \"SHINLON\""
    },
    {
      "code" : "A007396100",
      "display" : "PAMOXICILLIN CAPSULES \"C.Y.\""
    },
    {
      "code" : "A0073961G0",
      "display" : "PAMOXICILLIN CAPSULES \"C.Y.\""
    },
    {
      "code" : "A007398100",
      "display" : "CHOLESOLVIN TABLETS"
    },
    {
      "code" : "A007399209",
      "display" : "LILACILLIN INJECTION 1GM"
    },
    {
      "code" : "A007399212",
      "display" : "LILACILLIN INJECTION 1GM"
    },
    {
      "code" : "A007402209",
      "display" : "LILACILLIN INJECTION 2GM"
    },
    {
      "code" : "A007402212",
      "display" : "LILACILLIN INJECTION 2GM"
    },
    {
      "code" : "A007404100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"CHIPHAR\""
    },
    {
      "code" : "A007406500",
      "display" : "METAGYL VAGINAL TABLETS"
    },
    {
      "code" : "A007443323",
      "display" : "PARACORT OINTMENT \"H.L.\""
    },
    {
      "code" : "A007443329",
      "display" : "PARACORT OINTMENT \"H.L.\""
    },
    {
      "code" : "A007443377",
      "display" : "PARACORT OINTMENT \"H.L.\""
    },
    {
      "code" : "A007443399",
      "display" : "PARACORT OINTMENT \"H.L.\""
    },
    {
      "code" : "A007447100",
      "display" : "FUROSEMIDE TABLETS \"AND\""
    },
    {
      "code" : "A007454221",
      "display" : "GLYMINE INJECTION"
    },
    {
      "code" : "A007456100",
      "display" : "GETIGON TABLETS"
    },
    {
      "code" : "A007458100",
      "display" : "PREDNISOLONE TABLETS \"M.S.\""
    },
    {
      "code" : "A007466238",
      "display" : "SINAMMIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A007466277",
      "display" : "SINAMMIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A007471100",
      "display" : "PEYUAN S.C. TABLETS"
    },
    {
      "code" : "A007475100",
      "display" : "INDOMETHACIN CAPSULES \"SHOU CHAN\""
    },
    {
      "code" : "A007483277",
      "display" : "AMPICILLIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A007497100",
      "display" : "CINARIN TABLETS \"VEIMIN\""
    },
    {
      "code" : "A007513100",
      "display" : "ANTONON TABLETS"
    },
    {
      "code" : "A007514100",
      "display" : "DIMENHYDRINATE TABLETS \"AND\""
    },
    {
      "code" : "A007525109",
      "display" : "DUOCIDE GRANULES"
    },
    {
      "code" : "A007525199",
      "display" : "DUOCIDE GRANULES"
    },
    {
      "code" : "A007543100",
      "display" : "FOLIC ACID TABLETS 5MG \"VPC\""
    },
    {
      "code" : "A0075431G0",
      "display" : "FOLIC ACID TABLETS 5MG \"VPC\""
    },
    {
      "code" : "A007544221",
      "display" : "CHLORPROMAZINE HCL 125MG/5ML \"VPP\""
    },
    {
      "code" : "A007552100",
      "display" : "OOBICAN-P TABLETS"
    },
    {
      "code" : "A007563100",
      "display" : "JINPINFAN TABLETS 5MG \"M.S.\""
    },
    {
      "code" : "A007564100",
      "display" : "JINPINFAN TABLETS 2MG \"M.S.\""
    },
    {
      "code" : "A007605100",
      "display" : "BACERON TABLETS"
    },
    {
      "code" : "A007612100",
      "display" : "PUSUAN S.C. TABLETS 5MG \"F.S.\" (Metoclopramide HCl)"
    },
    {
      "code" : "A007613100",
      "display" : "RIFAMPIN CAPSULES 300 MG \"CHI SHENG\""
    },
    {
      "code" : "A007618100",
      "display" : "EKAM CAPSULES \"S.C.\""
    },
    {
      "code" : "A007630212",
      "display" : "PULIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A007641100",
      "display" : "DELCOPAN TABLETS 30MG"
    },
    {
      "code" : "A007665100",
      "display" : "PRENINE TABLETS"
    },
    {
      "code" : "A007670229",
      "display" : "DOUCEIN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A007673100",
      "display" : "PREDNISOLONE TABLETS \"P.L.\""
    },
    {
      "code" : "A007676100",
      "display" : "BROPHEMIN TABLETS"
    },
    {
      "code" : "A007679100",
      "display" : "RESPLAMIN TABLETS"
    },
    {
      "code" : "A007680100",
      "display" : "LIPHALEXIN CAPSULES 250MG \"LITA\""
    },
    {
      "code" : "A007681229",
      "display" : "DEXASON INJECTION 2MG/ML \"LITA\""
    },
    {
      "code" : "A007682229",
      "display" : "DEXASON INJECTION 4MG/ML \"LITA\""
    },
    {
      "code" : "A007693100",
      "display" : "FUBAXIN TABLETS"
    },
    {
      "code" : "A007707100",
      "display" : "CANMALIN CAPSULES"
    },
    {
      "code" : "A007715421",
      "display" : "LOSEMIN EYE DROPS \"OASIS\""
    },
    {
      "code" : "A007747100",
      "display" : "SHIN TAN TABLETS \"SHOU CHAN\""
    },
    {
      "code" : "A007748100",
      "display" : "GASCON TABLETS \"SHOU CHAN\""
    },
    {
      "code" : "A007749100",
      "display" : "DELAX TABLETS \"SHOU CHAN\""
    },
    {
      "code" : "A007751100",
      "display" : "FUROSELY TABLETS \"M.S.\""
    },
    {
      "code" : "A007758100",
      "display" : "LESTIN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A007772100",
      "display" : "CEPHALEXIN CAPSULES \"H.S.C.\""
    },
    {
      "code" : "A007773100",
      "display" : "KEFLEXIN CAPSULES 250MG \"PRINCE\""
    },
    {
      "code" : "A007778100",
      "display" : "SERODINE TABLETS"
    },
    {
      "code" : "A007780212",
      "display" : "DEPOT TESTODIOL INJECTION \"LITA\""
    },
    {
      "code" : "A007782100",
      "display" : "METHYLTESTOSTERONE TABLETS 20MG"
    },
    {
      "code" : "A007786100",
      "display" : "BACIDIM TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A007787100",
      "display" : "SULIAM SUGAR COATED TABLETS 50MG (VIT.E)"
    },
    {
      "code" : "A007792100",
      "display" : "SULFAPRIME TABLETS"
    },
    {
      "code" : "A007796100",
      "display" : "PETTI CAPSULES"
    },
    {
      "code" : "A007799212",
      "display" : "SINCE INJECTION"
    },
    {
      "code" : "A007801499",
      "display" : "MY-GEL LIQUID"
    },
    {
      "code" : "A007803100",
      "display" : "AIFU TABLETS\"H.S.\""
    },
    {
      "code" : "A007804157",
      "display" : "MY-GEL SUSPENSION \"CBC\""
    },
    {
      "code" : "A007804163",
      "display" : "MY-GEL SUSPENSION \"CBC\""
    },
    {
      "code" : "A007804199",
      "display" : "MY-GEL SUSPENSION \"CBC\""
    },
    {
      "code" : "A007808209",
      "display" : "VITAMIN K1 INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A007809100",
      "display" : "CARDERAL TABLETS \"VEIMIN\""
    },
    {
      "code" : "A007815100",
      "display" : "ERWAIR-U TABLETS \"C.M.\""
    },
    {
      "code" : "A007819100",
      "display" : "ACETAZOLAMAX TABLETS"
    },
    {
      "code" : "A007822100",
      "display" : "AMOXICILLIN CAPSULES \"PANBIOTIC\""
    },
    {
      "code" : "A007824100",
      "display" : "FURSEDE TABLETS"
    },
    {
      "code" : "A007828277",
      "display" : "LACTATED RINGER'S INJECTION \"ASTAR\""
    },
    {
      "code" : "A007830212",
      "display" : "LINWELS INJECTION"
    },
    {
      "code" : "A007835100",
      "display" : "NALICINE TABLETS \"M.S.\""
    },
    {
      "code" : "A007936100",
      "display" : "BORGAL TABLETS \"LITA\""
    },
    {
      "code" : "A007943100",
      "display" : "PIALITE TABLETS 250 MG \"F.Y.\""
    },
    {
      "code" : "A007944100",
      "display" : "DETTACKS S.C. TABLETS 10 MG \"F.Y.\""
    },
    {
      "code" : "A0079441G0",
      "display" : "DETTACKS S.C. TABLETS 10 MG \"F.Y.\""
    },
    {
      "code" : "A007949100",
      "display" : "CEFALOX CAPSULES 250MG"
    },
    {
      "code" : "A007961212",
      "display" : "FUCHONROPIN INJECTION"
    },
    {
      "code" : "A007973421",
      "display" : "NEOSINICIN EYE DROPS 5％ \"OASIS\""
    },
    {
      "code" : "A007974212",
      "display" : "LARKMYCIN INJECTION 40MG/ML \"LITA\""
    },
    {
      "code" : "A007974229",
      "display" : "LARKMYCIN INJECTION 40MG/ML \"LITA\""
    },
    {
      "code" : "A007976100",
      "display" : "RIKAPARIN CAPSULES"
    },
    {
      "code" : "A007983100",
      "display" : "PROPANTHELINE BROMIDE S.C. TABLETS \"SHOU CHAN\""
    },
    {
      "code" : "A007986100",
      "display" : "VITAMIN E CAPSULES \"JEN SHENG\""
    },
    {
      "code" : "A007996209",
      "display" : "DEPOT-TESTERONE INJECTION 200MG \"METRO\""
    },
    {
      "code" : "A008006100",
      "display" : "PYLON CAPSULES"
    },
    {
      "code" : "A008017100",
      "display" : "MERPURINE TABLETS"
    },
    {
      "code" : "A008032100",
      "display" : "LITANAN S.C. TABLETS 12.5MG (ANETHOLE)\"F.S.\""
    },
    {
      "code" : "A008035100",
      "display" : "CHIPIN TABLETS \"S.C.\""
    },
    {
      "code" : "A008050100",
      "display" : "CEPHALEXIN CAPSULES"
    },
    {
      "code" : "A008052100",
      "display" : "MESIN ENTERIC COATED TABLETS"
    },
    {
      "code" : "A008053100",
      "display" : "COFGEN TABLETS"
    },
    {
      "code" : "A008061100",
      "display" : "WINCOU TABLETS"
    },
    {
      "code" : "A008062100",
      "display" : "CINNARIZINE TABLETS"
    },
    {
      "code" : "A008069100",
      "display" : "BACIN TABLETS"
    },
    {
      "code" : "A008073100",
      "display" : "PULPERAN TABLETS\"H.S.\""
    },
    {
      "code" : "A008075100",
      "display" : "BETASONE TABLETS"
    },
    {
      "code" : "A008084100",
      "display" : "SKELETON TABLETS"
    },
    {
      "code" : "A008089100",
      "display" : "Sinflex Capsules \"Taiten\""
    },
    {
      "code" : "A008097100",
      "display" : "INDOMETHACIN CAPSULES \"MEIDER\""
    },
    {
      "code" : "A008154100",
      "display" : "CHINICHUAN TABLETS \"J.S.\""
    },
    {
      "code" : "A008160100",
      "display" : "CANON CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A008162100",
      "display" : "BACCIDE TABLETS"
    },
    {
      "code" : "A008165100",
      "display" : "WATOLIN TABLETS 8MG \"TF\""
    },
    {
      "code" : "A008169100",
      "display" : "OUTALLERGIN TABLETS"
    },
    {
      "code" : "A008192100",
      "display" : "BROMOCIX TABLETS"
    },
    {
      "code" : "A008246100",
      "display" : "HYOPAN S.C. TABLETS \"VEIMIN\""
    },
    {
      "code" : "A008260212",
      "display" : "METHOTREXATE SODIUM PARENTERAL 25MG/ML"
    },
    {
      "code" : "A008262100",
      "display" : "MINOCIN CAPSULES 50MG"
    },
    {
      "code" : "A008279100",
      "display" : "KESHIAU TABLETS 25MG (HYDROCHLOROTHIAZIDE)\"F.S.\""
    },
    {
      "code" : "A008289100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"UNION\""
    },
    {
      "code" : "A008290100",
      "display" : "RIFAMPICIN CAPSULES 150MG \"UNION\""
    },
    {
      "code" : "A008304100",
      "display" : "TOAMCILON TABLETS \"Standard\""
    },
    {
      "code" : "A008309100",
      "display" : "BEGATAL S.C. TABLETS"
    },
    {
      "code" : "A008310100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"LITA\""
    },
    {
      "code" : "A008311100",
      "display" : "RIFAMPICIN CAPSULES 150MG \"LITA\""
    },
    {
      "code" : "A008312209",
      "display" : "LARKCORT INJECTION 40MG/ML \"LITA\""
    },
    {
      "code" : "A008312229",
      "display" : "LARKCORT INJECTION 40MG/ML \"LITA\""
    },
    {
      "code" : "A008355100",
      "display" : "GASLAN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A008367100",
      "display" : "SEPAN TABLETS"
    },
    {
      "code" : "A008368100",
      "display" : "B-RED S.C. TABLETS"
    },
    {
      "code" : "A008380100",
      "display" : "PERISIN S.C. TABLETS \"Lita\""
    },
    {
      "code" : "A008381221",
      "display" : "ASTERLONE INJECTION 10MG \"ASTAR\""
    },
    {
      "code" : "A008397100",
      "display" : "BETASON TABLETS \"M.T.\""
    },
    {
      "code" : "A008404100",
      "display" : "KEFOLAN CAPSULES 500MG \"N.K.\""
    },
    {
      "code" : "A008405100",
      "display" : "KEFOLAN CAPSULES 250MG \"N.K.\""
    },
    {
      "code" : "A008450100",
      "display" : "DEXAZON TABLETS 0.5MG \"GREAT ASIA\""
    },
    {
      "code" : "A008469100",
      "display" : "PROZINE TABLETS 4MG \"SHIN FONG\""
    },
    {
      "code" : "A008470212",
      "display" : "COTORIN INJECTION"
    },
    {
      "code" : "A008472100",
      "display" : "ASPARA-K TABLETS"
    },
    {
      "code" : "A008473212",
      "display" : "DOUBLE BETASON INJECTION \"LITA\""
    },
    {
      "code" : "A008473221",
      "display" : "DOUBLE BETASON INJECTION \"LITA\""
    },
    {
      "code" : "A008499100",
      "display" : "SULFAMETHOXAZOLE TABLETS \"M.T.\""
    },
    {
      "code" : "A008504100",
      "display" : "VITAMINE-B6 TABLETS 50mg \"H.L.\""
    },
    {
      "code" : "A008505100",
      "display" : "METOPERAN TABLETS"
    },
    {
      "code" : "A008510100",
      "display" : "DACOCILIN CAPSULES 250MG"
    },
    {
      "code" : "A008519100",
      "display" : "VALEMATE S.C. TABLETS 10MG"
    },
    {
      "code" : "A008526100",
      "display" : "SZULEN S.C. TABLETS"
    },
    {
      "code" : "A008533100",
      "display" : "LINPERAN S.C. TABLETS \"LIN CHEMICAL\""
    },
    {
      "code" : "A008534209",
      "display" : "SCOBTIN INJECTION"
    },
    {
      "code" : "A008536100",
      "display" : "R-WEX TABLETS"
    },
    {
      "code" : "A008541100",
      "display" : "TONPHEN TABLETS"
    },
    {
      "code" : "A008543100",
      "display" : "PENCILEE TABLETS"
    },
    {
      "code" : "A008565100",
      "display" : "MEANLOU S.C. TABLETS 50MG (BENZYDAMINE)\"F.S.\""
    },
    {
      "code" : "A008590100",
      "display" : "COMIOSAN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A008591100",
      "display" : "GUAIN TABLETS"
    },
    {
      "code" : "A008592100",
      "display" : "PACINOL TABLETS"
    },
    {
      "code" : "A008594100",
      "display" : "SULTRIM TABLETS \"VEIMIN\""
    },
    {
      "code" : "A008606100",
      "display" : "HISTANTI TABLET"
    },
    {
      "code" : "A008609100",
      "display" : "REC S.C. TABLETS"
    },
    {
      "code" : "A008616209",
      "display" : "ASTARLONE INJECTION 40MG \"ASTAR\""
    },
    {
      "code" : "A008629100",
      "display" : "TWINGEL TABLETS"
    },
    {
      "code" : "A008630100",
      "display" : "CEPHAMYCIN CAPSULES"
    },
    {
      "code" : "A008631212",
      "display" : "F.S. INJECTION \"LITA\""
    },
    {
      "code" : "A008632100",
      "display" : "WEISUDIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A008642209",
      "display" : "FUCON INJECTION"
    },
    {
      "code" : "A008645417",
      "display" : "PZULEN EYE OINTMENT \"OASIS\""
    },
    {
      "code" : "A008661100",
      "display" : "TONFONYUANIN CAPSULES \"K.N.\""
    },
    {
      "code" : "A008662100",
      "display" : "SENFIHU TABLETS"
    },
    {
      "code" : "A008663100",
      "display" : "CHIAOWELGEN F.C. TABLETS"
    },
    {
      "code" : "A008667100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"CHIU PO\""
    },
    {
      "code" : "A008676100",
      "display" : "BENTEA \"JENN MAW\""
    },
    {
      "code" : "A008678335",
      "display" : "BETASON CREAM \"LITA\""
    },
    {
      "code" : "A008685100",
      "display" : "MYAMBUTOL I/P 300MG TABLETS"
    },
    {
      "code" : "A008715100",
      "display" : "PRENIN TABLETS"
    },
    {
      "code" : "A008734100",
      "display" : "E-CHUN CAPSULES \"N.T.\""
    },
    {
      "code" : "A008743100",
      "display" : "COYENLIN TABLETS"
    },
    {
      "code" : "A008753100",
      "display" : "TRAMEZIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A0087531G0",
      "display" : "TRAMEZIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A008757100",
      "display" : "BASED TABLETS \"CURIE\""
    },
    {
      "code" : "A008759100",
      "display" : "ALUMIGEL GREEN TABLETS"
    },
    {
      "code" : "A008761177",
      "display" : "ASVERIN GRANULES"
    },
    {
      "code" : "A008761199",
      "display" : "ASVERIN GRANULES"
    },
    {
      "code" : "A008764100",
      "display" : "COSTOL CAPSULES"
    },
    {
      "code" : "A008766100",
      "display" : "PATETIN CAPSULES"
    },
    {
      "code" : "A008767100",
      "display" : "LOXAPAC CAPSULES 10MG"
    },
    {
      "code" : "A008774100",
      "display" : "PONSTAN F.C. TABLETS"
    },
    {
      "code" : "A008790100",
      "display" : "YICHENTAN TABLETS"
    },
    {
      "code" : "A008822100",
      "display" : "SUNPRED TABLETS"
    },
    {
      "code" : "A008839100",
      "display" : "DERTIN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A008840100",
      "display" : "BEINSON TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A008851209",
      "display" : "ANCILLINA INJECTION 1GM"
    },
    {
      "code" : "A008855100",
      "display" : "CHEMIX TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A008863100",
      "display" : "LIFUNWAN CAPSULES"
    },
    {
      "code" : "A008870100",
      "display" : "PARACETAMOL TABLETS \"KINGDOM\""
    },
    {
      "code" : "A008883100",
      "display" : "METHYLTESTOSTERONE CAPSULES \"Y.S.\""
    },
    {
      "code" : "A008888100",
      "display" : "PANTHDAN CAPSULES"
    },
    {
      "code" : "A008890100",
      "display" : "WINACORT-A TABLETS \"WINSTON\""
    },
    {
      "code" : "A008893100",
      "display" : "WINVITA-E CAPSULES \"WINSTON\""
    },
    {
      "code" : "A008894212",
      "display" : "WINPERAN INJECTION \"WINSTON\""
    },
    {
      "code" : "A008895100",
      "display" : "WINCOUGH CAPSULES \"WINSTON\""
    },
    {
      "code" : "A008896100",
      "display" : "WINTYL TABLETS \"WINSTON\""
    },
    {
      "code" : "A008899100",
      "display" : "ANTIMONAS S.C. TABLETS"
    },
    {
      "code" : "A008905100",
      "display" : "ASVERIN TABLETS 10MG"
    },
    {
      "code" : "A008907100",
      "display" : "ASVERIN TABLETS 20MG"
    },
    {
      "code" : "A008910248",
      "display" : "SANYL LYO INJECTION"
    },
    {
      "code" : "A008912221",
      "display" : "ESCIN LYO-INJECTION"
    },
    {
      "code" : "A008913209",
      "display" : "PIPETO INJECTION"
    },
    {
      "code" : "A008917100",
      "display" : "PULIN SUGAR COATED TABLETS 5MG"
    },
    {
      "code" : "A008919209",
      "display" : "PROGESTERONE INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A008924321",
      "display" : "SUFUCIN OINTMENT \"S.T.\""
    },
    {
      "code" : "A008927100",
      "display" : "TRIMEZOL TABLETS"
    },
    {
      "code" : "A008928100",
      "display" : "DEXAMETHASONE TABLETS \"MEIDER\""
    },
    {
      "code" : "A008934100",
      "display" : "RINMESON TABLETS \"F.B.\""
    },
    {
      "code" : "A008937100",
      "display" : "ZUPERAN S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A008944100",
      "display" : "VITAMIN E S.C. TABLETS \"KYORIN\""
    },
    {
      "code" : "A008945100",
      "display" : "HYDROCHOL S.C. TABLETS"
    },
    {
      "code" : "A008948100",
      "display" : "CEPHALEXIN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A008956212",
      "display" : "GENTAMYCIN INJECTION"
    },
    {
      "code" : "A008956229",
      "display" : "GENTAMYCIN INJECTION"
    },
    {
      "code" : "A008956238",
      "display" : "GENTAMYCIN INJECTION"
    },
    {
      "code" : "A008956299",
      "display" : "GENTAMYCIN INJECTION"
    },
    {
      "code" : "A008957100",
      "display" : "WINCOLD CAPSULES \"WINSTON\""
    },
    {
      "code" : "A008970118",
      "display" : "GUAIACOSIN SYRUP"
    },
    {
      "code" : "A008970199",
      "display" : "GUAIACOSIN SYRUP"
    },
    {
      "code" : "A008977100",
      "display" : "NITOSON TAB. 100MG"
    },
    {
      "code" : "A009010421",
      "display" : "NEOCOSON EYE DROPS \"PATRON\""
    },
    {
      "code" : "A009011100",
      "display" : "NEOPANTIMIN TABLETS"
    },
    {
      "code" : "A009017100",
      "display" : "SUNCYCLINE-V CAPSULES"
    },
    {
      "code" : "A009019100",
      "display" : "GRIFUVIN CAPSULES"
    },
    {
      "code" : "A009032100",
      "display" : "OILAX OINTMENT"
    },
    {
      "code" : "A009034100",
      "display" : "HARYBA SOFT CAPSULES"
    },
    {
      "code" : "A009038100",
      "display" : "BISCO TABLETS 8MG"
    },
    {
      "code" : "A009043100",
      "display" : "SUMENCHITON TABLETS"
    },
    {
      "code" : "A009054318",
      "display" : "PVP-I SOLUTION \"HEALTH\""
    },
    {
      "code" : "A009054399",
      "display" : "PVP-I SOLUTION \"HEALTH\""
    },
    {
      "code" : "A009055100",
      "display" : "DAOLIN TABLETS"
    },
    {
      "code" : "A009067212",
      "display" : "KASON INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A009069277",
      "display" : "SUNAMIN INJECTION"
    },
    {
      "code" : "A009071109",
      "display" : "BROADIM GRANULES"
    },
    {
      "code" : "A009071199",
      "display" : "BROADIM GRANULES"
    },
    {
      "code" : "A009086212",
      "display" : "GUAIC INJECTION"
    },
    {
      "code" : "A009092100",
      "display" : "GINDOAN TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A009094209",
      "display" : "COHORMON INJECTION \"C.C.P.\""
    },
    {
      "code" : "A009096100",
      "display" : "DOUCEIN TABLETS \"Y.Y.\""
    },
    {
      "code" : "A009099100",
      "display" : "IKODIN CAPSULES 250 MG"
    },
    {
      "code" : "A0090991G0",
      "display" : "IKODIN CAPSULES 250 MG"
    },
    {
      "code" : "A009101100",
      "display" : "METHOTREXATE TABLETS 2.5MG"
    },
    {
      "code" : "A009102100",
      "display" : "PROPRANOLOL TABLETS 10MG"
    },
    {
      "code" : "A0091021G0",
      "display" : "PROPRANOLOL TABLETS 10MG"
    },
    {
      "code" : "A009104100",
      "display" : "APAP TABLETS 300MG"
    },
    {
      "code" : "A009106100",
      "display" : "BROMINE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A009111100",
      "display" : "SOLCON TABLETS 8MG"
    },
    {
      "code" : "A009115100",
      "display" : "PRINCUR F.C. TABLETS"
    },
    {
      "code" : "A009129100",
      "display" : "TERRAMYCIN CAPSULES 500MG"
    },
    {
      "code" : "A009138100",
      "display" : "POINSTAN CAPSULES"
    },
    {
      "code" : "A009164100",
      "display" : "GUVITA TABLETS"
    },
    {
      "code" : "A009167209",
      "display" : "WINACORT-A INJECTION \"WINSTON\""
    },
    {
      "code" : "A009167221",
      "display" : "WINACORT-A INJECTION \"WINSTON\""
    },
    {
      "code" : "A009191238",
      "display" : "DOAMIN INJECTION \"TF\""
    },
    {
      "code" : "A009203100",
      "display" : "LIBLAN S.C. TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A009205100",
      "display" : "SUNDRON TABLETS"
    },
    {
      "code" : "A009211100",
      "display" : "ALUDENE TABLETS"
    },
    {
      "code" : "A0092111G0",
      "display" : "ALUDENE TABLETS"
    },
    {
      "code" : "A009250500",
      "display" : "BISACODYL SUPPOSITORIES \"YUNG SHIN\""
    },
    {
      "code" : "A009252100",
      "display" : "LUTUTIN TABLETS"
    },
    {
      "code" : "A009255100",
      "display" : "GERSCON TABLETS \"C.L.\""
    },
    {
      "code" : "A009256100",
      "display" : "SOMEPRIM TABLETS"
    },
    {
      "code" : "A009258100",
      "display" : "FUCHONROPIN TABLETS \"ASTAR\""
    },
    {
      "code" : "A009260100",
      "display" : "SEPCIDIM TABLETS"
    },
    {
      "code" : "A009264100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"CHIU PO\""
    },
    {
      "code" : "A009271277",
      "display" : "SORBIT-HARTMANN INJECTION"
    },
    {
      "code" : "A009272209",
      "display" : "SPASMEX INJECTION 0.6MG"
    },
    {
      "code" : "A009275100",
      "display" : "VICOMP S.C. TABLETS"
    },
    {
      "code" : "A009276212",
      "display" : "STOPNIN INJECTION"
    },
    {
      "code" : "A009283500",
      "display" : "ULTRAPROCT SUPPOSITORIES"
    },
    {
      "code" : "A009289212",
      "display" : "WINII INJECTION \"WINSTON\""
    },
    {
      "code" : "A009291100",
      "display" : "EUCLIDAN S.C. TABLETS 50MG"
    },
    {
      "code" : "A0092911G0",
      "display" : "EUCLIDAN S.C. TABLETS 50MG"
    },
    {
      "code" : "A009296100",
      "display" : "TONIKER TABLETS 500MG"
    },
    {
      "code" : "A009299100",
      "display" : "LIGILIN CAPSULES"
    },
    {
      "code" : "A009300100",
      "display" : "BETAMETHASONE TABLETS \"Y.S.\""
    },
    {
      "code" : "A009309100",
      "display" : "CHINPIN TABLETS \"Y.C.\""
    },
    {
      "code" : "A009311100",
      "display" : "KONACOTO TABLETS \"Y.C.\""
    },
    {
      "code" : "A009314100",
      "display" : "CHLORTERACYCLINE HCL CAPSULES \"Y.C.\""
    },
    {
      "code" : "A009331100",
      "display" : "ALUMINUM GEL TABLET 300MG"
    },
    {
      "code" : "A009334100",
      "display" : "FUZUIN S.C. TABLETS \"CHINGTENG\""
    },
    {
      "code" : "A0093341G0",
      "display" : "FUZUIN S.C. TABLETS \"CHINGTENG\""
    },
    {
      "code" : "A009345277",
      "display" : "RESECTOL-T INJECTION"
    },
    {
      "code" : "A009346212",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION 20MG \"KYORIN\""
    },
    {
      "code" : "A009352100",
      "display" : "HOMALIN TABLETS \"W.S.\""
    },
    {
      "code" : "A009358100",
      "display" : "RIFANPISIN CAPSULES"
    },
    {
      "code" : "A009364100",
      "display" : "BISAPAN S.C. TABLETS \"WINSTON\""
    },
    {
      "code" : "A009365209",
      "display" : "SPAL INJECTION"
    },
    {
      "code" : "A009366100",
      "display" : "BISPAN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A009367100",
      "display" : "AETHOCAF CAPSULES"
    },
    {
      "code" : "A009369100",
      "display" : "BISACODYL S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A009384100",
      "display" : "CYPROHEPTADINE TABLETS \"ASTAR\""
    },
    {
      "code" : "A009393100",
      "display" : "BETAMETHASONE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A009397100",
      "display" : "MIRACLIN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A009400100",
      "display" : "CODANTYL TABLETS \"Y.C.\""
    },
    {
      "code" : "A009404212",
      "display" : "WINTYL INJECTION \"WINSTON\""
    },
    {
      "code" : "A009408100",
      "display" : "METRONIDAZOLE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A009409100",
      "display" : "CO-TRIMOXAZOLE TABLETS \"Y.S.\""
    },
    {
      "code" : "A009413100",
      "display" : "BUTOPEN TABLETS"
    },
    {
      "code" : "A009437212",
      "display" : "DANPYRIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A009438212",
      "display" : "SINCEN INJECTION"
    },
    {
      "code" : "A009440221",
      "display" : "LARKCORT INJECTION 10MG/ML"
    },
    {
      "code" : "A009440229",
      "display" : "LARKCORT INJECTION 10MG/ML"
    },
    {
      "code" : "A009440299",
      "display" : "LARKCORT INJECTION 10MG/ML"
    },
    {
      "code" : "A009451212",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION 10MG \"KYORIN\""
    },
    {
      "code" : "A009453100",
      "display" : "CEPHANMYCIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A009454100",
      "display" : "DOXYCYCLINE HCL CAPSULES 100MG \"PRINCE\""
    },
    {
      "code" : "A009463100",
      "display" : "AMOXICILLIN CAPSULES \"Y.C.\""
    },
    {
      "code" : "A009469421",
      "display" : "HYDROCORTISONE ACETATE OPHTHALMIC SUSPENSION 0.5％ \"OASIS\""
    },
    {
      "code" : "A009470100",
      "display" : "YUNGBAYAN TABLETS \"Y.C.\""
    },
    {
      "code" : "A009472212",
      "display" : "PYDOXIN INJECTION \"WINSTON\""
    },
    {
      "code" : "A009474277",
      "display" : "KYOLARTE INJECTION"
    },
    {
      "code" : "A009480100",
      "display" : "RAMIN CAPSULES 25MG"
    },
    {
      "code" : "A009484277",
      "display" : "GLUCOSAN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A009486417",
      "display" : "NEOSONE OPHTHALMIC OINTMENT"
    },
    {
      "code" : "A009489100",
      "display" : "LIVA-VITA CAPSULES \"WINSTON\""
    },
    {
      "code" : "A009496100",
      "display" : "WALIN TABLETS 2MG"
    },
    {
      "code" : "A009499100",
      "display" : "BEILITA CAP. \"TK&A\""
    },
    {
      "code" : "A009514100",
      "display" : "Egotan F.C. Tablets \"WINSTON\""
    },
    {
      "code" : "A009570100",
      "display" : "OUTERDZEN S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0095701G0",
      "display" : "OUTERDZEN S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A009580100",
      "display" : "DOXYCYCLINE CAPSULES \"CHIU PO\""
    },
    {
      "code" : "A009587100",
      "display" : "FROTIN ENTERIC SUGAR COATED TABLETS"
    },
    {
      "code" : "A009594212",
      "display" : "DISEMIDE IV INJECTION \"WINSTON\""
    },
    {
      "code" : "A009596209",
      "display" : "BETAMETHASONE INJECTION"
    },
    {
      "code" : "A009609100",
      "display" : "AMPICILLIN CAPSULES 500MG \"VPC\""
    },
    {
      "code" : "A0096091G0",
      "display" : "AMPICILLIN CAPSULES 500MG \"VPC\""
    },
    {
      "code" : "A009610265",
      "display" : "SODIUM AMPICILLIN FOR INJECTION 250MG \"VPP\""
    },
    {
      "code" : "A009615100",
      "display" : "CYPRODINE TABLETS \"MEIDER\""
    },
    {
      "code" : "A009616100",
      "display" : "GLANEGA TABLETS \"MEIDER\""
    },
    {
      "code" : "A009617100",
      "display" : "CINRAZINE TABLETS \"MEIDER\""
    },
    {
      "code" : "A009619100",
      "display" : "BISADYL E.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A0096191G0",
      "display" : "BISADYL E.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A009622100",
      "display" : "TETRACYCLINE HCL CAPSULES \"C.S.\""
    },
    {
      "code" : "A009625100",
      "display" : "PONSUTON CAPSULES \"C.S.\""
    },
    {
      "code" : "A009630100",
      "display" : "CHLORAMPHENICOL CAPSULES \"C.S.\""
    },
    {
      "code" : "A009632100",
      "display" : "BAKRIN TABLETS"
    },
    {
      "code" : "A009633255",
      "display" : "MANITON INJECTION"
    },
    {
      "code" : "A009633265",
      "display" : "MANITON INJECTION"
    },
    {
      "code" : "A009633266",
      "display" : "MANITON INJECTION"
    },
    {
      "code" : "A009633277",
      "display" : "MANITON INJECTION"
    },
    {
      "code" : "A009636100",
      "display" : "CHINGLITOSAN CAPSULES \"TK&A.\""
    },
    {
      "code" : "A009638100",
      "display" : "CHANPON TABLETS \"Y.C.\""
    },
    {
      "code" : "A009645209",
      "display" : "STACORT-A INJECTION 40MG \"STANDARD\""
    },
    {
      "code" : "A009645221",
      "display" : "STACORT-A INJECTION 40MG \"STANDARD\""
    },
    {
      "code" : "A009645229",
      "display" : "STACORT-A INJECTION 40MG \"STANDARD\""
    },
    {
      "code" : "A009649209",
      "display" : "AMPICILLIN INJECTION 1 GM \"CHI SHENG\""
    },
    {
      "code" : "A009654100",
      "display" : "DOXYMYCIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A009658100",
      "display" : "PANDEHOL TABLETS"
    },
    {
      "code" : "A009662100",
      "display" : "TONDA TABLETS 300MG"
    },
    {
      "code" : "A009673100",
      "display" : "LIMOX CAPSULES 250MG \"LITA\""
    },
    {
      "code" : "A009683266",
      "display" : "XYLITOL INJECTION 5％ \"KYORIN\""
    },
    {
      "code" : "A009683277",
      "display" : "XYLITOL INJECTION 5％ \"KYORIN\""
    },
    {
      "code" : "A009685199",
      "display" : "ANTICOUGH SYRUP \"Y.C.\""
    },
    {
      "code" : "A009690100",
      "display" : "COMBICIN TABLETS \"Y.K.\""
    },
    {
      "code" : "A009691100",
      "display" : "PUKAMIN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A009705100",
      "display" : "NADON CAPSULES"
    },
    {
      "code" : "A009719209",
      "display" : "WINVACAN INJECTION \"WINSTON\""
    },
    {
      "code" : "A009722100",
      "display" : "MEFEINE TABLETS"
    },
    {
      "code" : "A009732212",
      "display" : "METOCLOPRAMIDE INJECTION \"PRINCE\""
    },
    {
      "code" : "A009743100",
      "display" : "RIDONRA TABLETS"
    },
    {
      "code" : "A009744100",
      "display" : "CARDITONIN TABLETS \"MEIDER\""
    },
    {
      "code" : "A009745277",
      "display" : "MANNITOL INJECTION"
    },
    {
      "code" : "A009750100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"PRINCE\""
    },
    {
      "code" : "A009754209",
      "display" : "B-RED INJECTION \"KYORIN\""
    },
    {
      "code" : "A009763100",
      "display" : "BENZAMINE TABLETS"
    },
    {
      "code" : "A009767100",
      "display" : "CLIZEP S.C. TABLETS"
    },
    {
      "code" : "A009768238",
      "display" : "YIN KONG MYCIN INJECTION \"FUMIN\""
    },
    {
      "code" : "A009769100",
      "display" : "STOMACH TABLETS \"F.Y.\""
    },
    {
      "code" : "A009770100",
      "display" : "PRINTOPIN S.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A009781100",
      "display" : "PAPAVORINE TABLETS \"C.T.\""
    },
    {
      "code" : "A009782100",
      "display" : "INDAL TABLETS"
    },
    {
      "code" : "A009791100",
      "display" : "CEPHALEXIN CAPSULES \"Y.C.\""
    },
    {
      "code" : "A009792100",
      "display" : "BENTYL TABLETS 10MG"
    },
    {
      "code" : "A009905229",
      "display" : "KANAMYCIN SULFATE INJECTION 250MG \"CHIU PO\""
    },
    {
      "code" : "A009915100",
      "display" : "METASONE TABLETS \"H.S.\""
    },
    {
      "code" : "A0099151G0",
      "display" : "METASONE TABLETS \"H.S.\""
    },
    {
      "code" : "A009916100",
      "display" : "DEXAN TABLETS \"H.S.\""
    },
    {
      "code" : "A009918100",
      "display" : "AISULAN TALBETS 2MG (GUAIAZULENE) \"F.S.\""
    },
    {
      "code" : "A009927100",
      "display" : "VITA-LONG S.C. TABLETS \"WINSTON\""
    },
    {
      "code" : "A009931221",
      "display" : "NEWNACORT INJECTION"
    },
    {
      "code" : "A009939212",
      "display" : "SINICORT IMM. INJECTION"
    },
    {
      "code" : "A009939221",
      "display" : "SINICORT IMM. INJECTION"
    },
    {
      "code" : "A009941100",
      "display" : "WINPICILLIN CAPSULES 500MG \"WINSTON\""
    },
    {
      "code" : "A009943100",
      "display" : "WINPICILLIN CAPSULES 250MG \"WINSTON\""
    },
    {
      "code" : "A009945100",
      "display" : "Musclo Tablets  \"Y.K.\""
    },
    {
      "code" : "A009947321",
      "display" : "ERYTHROMYCIN OINTMENT \"SHIONOGI\""
    },
    {
      "code" : "A009961209",
      "display" : "WINDICON INJECTION \"WINSTON\""
    },
    {
      "code" : "A009961212",
      "display" : "WINDICON INJECTION \"WINSTON\""
    },
    {
      "code" : "A009963100",
      "display" : "KOSPANONE CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A009964221",
      "display" : "FULORASOL INJECTION \"N.K.\""
    },
    {
      "code" : "A009975248",
      "display" : "EUCLIDAN INJECTION 50MG"
    },
    {
      "code" : "A009982238",
      "display" : "DEXTROSE INJECTION 20％ \"S.Y.\""
    },
    {
      "code" : "A009983100",
      "display" : "CYASIN S.C. TABLETS"
    },
    {
      "code" : "A0099831G0",
      "display" : "CYASIN S.C. TABLETS"
    },
    {
      "code" : "A009987100",
      "display" : "CONICINE TABLETS \"H.H.\""
    },
    {
      "code" : "A0099871G0",
      "display" : "CONICINE TABLETS \"H.H.\""
    },
    {
      "code" : "A009990212",
      "display" : "ASCORBIC ACID INJECTION \"S.Y.\""
    },
    {
      "code" : "A009990221",
      "display" : "ASCORBIC ACID INJECTION \"S.Y.\""
    },
    {
      "code" : "A009991100",
      "display" : "TOUFONG TABLETS 5MG \"CHEN TA\""
    },
    {
      "code" : "A009992100",
      "display" : "KUWELIN TABLETS \"C.S.\""
    },
    {
      "code" : "A010056238",
      "display" : "RESPLAMIN INJECTION 5％"
    },
    {
      "code" : "A010057229",
      "display" : "RESPLAMIN INJECTION 20％"
    },
    {
      "code" : "A010058100",
      "display" : "PROPRANOLOL TABLETS \"YU SHENG\""
    },
    {
      "code" : "A010065263",
      "display" : "GLUTATHIONE-LYO INJECTION \"H.S.C.\""
    },
    {
      "code" : "A010066277",
      "display" : "FRUCTOSE INJECTION 5％"
    },
    {
      "code" : "A010067265",
      "display" : "GLUCURONO RINGER'S INJECTION"
    },
    {
      "code" : "A010067277",
      "display" : "GLUCURONO RINGER'S INJECTION"
    },
    {
      "code" : "A010068277",
      "display" : "GLUCURONSAN DEXTROSE INJECTION"
    },
    {
      "code" : "A010069265",
      "display" : "HARTMANN'S INJECTION"
    },
    {
      "code" : "A010069277",
      "display" : "HARTMANN'S INJECTION"
    },
    {
      "code" : "A010070100",
      "display" : "WELLPIN TWO LAYER TABLETS"
    },
    {
      "code" : "A010071100",
      "display" : "DIBROM TABLETS \"WINSTON\""
    },
    {
      "code" : "A010072100",
      "display" : "HUKURON F.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A010079100",
      "display" : "CARBETIN TABLETS"
    },
    {
      "code" : "A010082196",
      "display" : "REFULEN LIQUID \"H.S.\""
    },
    {
      "code" : "A010082348",
      "display" : "REFULEN LIQUID \"H.S.\""
    },
    {
      "code" : "A010082396",
      "display" : "REFULEN LIQUID \"H.S.\""
    },
    {
      "code" : "A010102100",
      "display" : "ANKOCILLIN CAPSULES 250MG \"W.F.\""
    },
    {
      "code" : "A010116100",
      "display" : "CARBETAPENTANE CAPSULES 30MG \"GENMONT\""
    },
    {
      "code" : "A010117100",
      "display" : "DIGOXIN TABLETS"
    },
    {
      "code" : "A010120100",
      "display" : "CO-TRIMOXAZOL TABLETS \"H.L.\""
    },
    {
      "code" : "A010124277",
      "display" : "SORBIT INJECTION 5％"
    },
    {
      "code" : "A010126100",
      "display" : "MEPEZOLIN TABLETS"
    },
    {
      "code" : "A010127100",
      "display" : "Bisacodyl Enteric-Coated Tablets \"M.D.\""
    },
    {
      "code" : "A010137100",
      "display" : "PREDNISOLONE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A010139100",
      "display" : "PREDSON TABLETS \"H.S.\""
    },
    {
      "code" : "A010140100",
      "display" : "YUAKOLI TABLETS"
    },
    {
      "code" : "A010150212",
      "display" : "DIZEPAM INJECTION \"S.Y.\""
    },
    {
      "code" : "A010159100",
      "display" : "CHILIEANZIN TABLETS \"C.S.\""
    },
    {
      "code" : "A010162100",
      "display" : "WINMOX CAPSULES \"WINSTON\""
    },
    {
      "code" : "A010168100",
      "display" : "DECAN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A0101681G0",
      "display" : "DECAN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A010172100",
      "display" : "GERISTS TABLETS"
    },
    {
      "code" : "A010182209",
      "display" : "KANAMYCIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A010183100",
      "display" : "WITHAMYCIN CAPSULES"
    },
    {
      "code" : "A010184317",
      "display" : "DECANEOMYCIN OPHTHALMIC OINTMENT \"UNION\""
    },
    {
      "code" : "A010192100",
      "display" : "WINTELLIN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A010193209",
      "display" : "WINAMYCIN INJECTION 1GM \"WINSTON\""
    },
    {
      "code" : "A010194100",
      "display" : "WINLEX CAPSULES \"WINSTON\""
    },
    {
      "code" : "A010195100",
      "display" : "WINLERIL S.C. TABLETS \"WINSTON\""
    },
    {
      "code" : "A010196229",
      "display" : "WINAMYCIN INJECTION 250MG \"WINSTON\""
    },
    {
      "code" : "A010199110",
      "display" : "ERYTHROMYCIN ESTOLATE ORAL SUSP."
    },
    {
      "code" : "A010199199",
      "display" : "ERYTHROMYCIN ESTOLATE ORAL SUSP."
    },
    {
      "code" : "A0101991CN",
      "display" : "ERYTHROMYCIN ESTOLATE ORAL SUSP."
    },
    {
      "code" : "A0101991CP",
      "display" : "ERYTHROMYCIN ESTOLATE ORAL SUSP."
    },
    {
      "code" : "A010204100",
      "display" : "FUZINLIN CAPSULES \"H.L.\""
    },
    {
      "code" : "A010207100",
      "display" : "INDECIN CAPSULES \"H.S.\""
    },
    {
      "code" : "A0102071G0",
      "display" : "INDECIN CAPSULES \"H.S.\""
    },
    {
      "code" : "A010211100",
      "display" : "BRONCOMINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A010213100",
      "display" : "CEPHALEXIN CAPSULES 250 MG \"CHI SHENG\""
    },
    {
      "code" : "A010217209",
      "display" : "CELODIN INJECTION 1 GM \"CHI SHENG\""
    },
    {
      "code" : "A010218100",
      "display" : "AMOCILLIN CAPSULES 250 MG \"CHI SHENG\""
    },
    {
      "code" : "A010220100",
      "display" : "RIFAMTIBI CAPSULES 450MG"
    },
    {
      "code" : "A010221321",
      "display" : "WINCORT CREAM"
    },
    {
      "code" : "A010221329",
      "display" : "WINCORT CREAM"
    },
    {
      "code" : "A010221372",
      "display" : "WINCORT CREAM"
    },
    {
      "code" : "A010221399",
      "display" : "WINCORT CREAM"
    },
    {
      "code" : "A010229100",
      "display" : "THIMAZOL TABLETS \"SHUN HWA\""
    },
    {
      "code" : "A010232229",
      "display" : "PANCEBRIN INJECTION"
    },
    {
      "code" : "A010232299",
      "display" : "PANCEBRIN INJECTION"
    },
    {
      "code" : "A010233243",
      "display" : "GLUCO-CALCIUM INJECTION"
    },
    {
      "code" : "A010233299",
      "display" : "GLUCO-CALCIUM INJECTION"
    },
    {
      "code" : "A010246100",
      "display" : "NITROFURANTOIN E.C. TABLETS"
    },
    {
      "code" : "A010248100",
      "display" : "COOCHIL TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0102481G0",
      "display" : "COOCHIL TABLETS \"CHINTENG\""
    },
    {
      "code" : "A010249100",
      "display" : "PIWEILIN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0102491G0",
      "display" : "PIWEILIN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A010256100",
      "display" : "HUA PAM TABLETS \"H.H.\""
    },
    {
      "code" : "A010259100",
      "display" : "ORCINALINE TABLETS \"C.T.\""
    },
    {
      "code" : "A010268100",
      "display" : "BROBEN TABLETS 100MG \"YU SHENG\""
    },
    {
      "code" : "A010269100",
      "display" : "FLOPROPIONE CAPSULES \"Y.S.\""
    },
    {
      "code" : "A010277100",
      "display" : "TETRALOW CAPSULES 250MG \"CHIU PO\""
    },
    {
      "code" : "A010282100",
      "display" : "BACIDE TABLETS"
    },
    {
      "code" : "A0102821G0",
      "display" : "BACIDE TABLETS"
    },
    {
      "code" : "A010288212",
      "display" : "WINCYNON INJECTION \"WINSTON\""
    },
    {
      "code" : "A010295212",
      "display" : "GENTAMICIN INJECTION \"N.K.\""
    },
    {
      "code" : "A010295238",
      "display" : "GENTAMICIN INJECTION \"N.K.\""
    },
    {
      "code" : "A010295299",
      "display" : "GENTAMICIN INJECTION \"N.K.\""
    },
    {
      "code" : "A010296100",
      "display" : "COLILON S.C. TABLETS"
    },
    {
      "code" : "A010302100",
      "display" : "ROTELAN TABLETS \"SHIN FONG\""
    },
    {
      "code" : "A010305100",
      "display" : "HYTOL TABLETS 400MG\"CHIU PO\""
    },
    {
      "code" : "A010319212",
      "display" : "BENAPYRIN INJECTION \"T.S.\""
    },
    {
      "code" : "A010320277",
      "display" : "ELECTRO-5％ DEXTROSE INFUSION SOLUTION \"Y.F.\""
    },
    {
      "code" : "A010323100",
      "display" : "BIGUNAL TABLET 50MG"
    },
    {
      "code" : "A010332100",
      "display" : "CINDERAL TABLETS \"PATRON\""
    },
    {
      "code" : "A010333212",
      "display" : "TONTYL INJECTION \"PATRON\""
    },
    {
      "code" : "A010334100",
      "display" : "TONTYL TABLETS \"PATRON\""
    },
    {
      "code" : "A010339321",
      "display" : "CORTISON-D-PASTA"
    },
    {
      "code" : "A010347100",
      "display" : "ANTACID TABLETS \"C.S.\""
    },
    {
      "code" : "A010350100",
      "display" : "PIPNATE S.C. TABLETS"
    },
    {
      "code" : "A010353212",
      "display" : "FUTROSEMIDE INJECTION \"G.C.\""
    },
    {
      "code" : "A010358100",
      "display" : "HERBESSER TABLETS 30MG"
    },
    {
      "code" : "A0103581G0",
      "display" : "HERBESSER TABLETS 30MG"
    },
    {
      "code" : "A010365100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"SYNMOSA\""
    },
    {
      "code" : "A010366209",
      "display" : "LUMIAN INJECTION \"ASTAR\""
    },
    {
      "code" : "A010372100",
      "display" : "KLIMER TABLETS"
    },
    {
      "code" : "A010373209",
      "display" : "DONISON INJECTION 25MG"
    },
    {
      "code" : "A010374100",
      "display" : "CINNARIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A0103741G0",
      "display" : "CINNARIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A010376421",
      "display" : "DECANEOMYCIN OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A010376455",
      "display" : "DECANEOMYCIN OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A010380177",
      "display" : "TETRACYCLINE PHOSPHATE COMPLEX GRANULES \"PATRON\""
    },
    {
      "code" : "A010380199",
      "display" : "TETRACYCLINE PHOSPHATE COMPLEX GRANULES \"PATRON\""
    },
    {
      "code" : "A010381316",
      "display" : "PATRONCORT-F OINTMENT \"PATRON\""
    },
    {
      "code" : "A010381329",
      "display" : "PATRONCORT-F OINTMENT \"PATRON\""
    },
    {
      "code" : "A010382100",
      "display" : "PATOCILLIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A010390100",
      "display" : "NOWASUFU TABLETS 25MG 0(CINNARIZINE) \"C.T.\""
    },
    {
      "code" : "A010391209",
      "display" : "BETAMETHASONE SODIUM PHOSPHATE INJECTION \"PRINCE\""
    },
    {
      "code" : "A010391229",
      "display" : "BETAMETHASONE SODIUM PHOSPHATE INJECTION \"PRINCE\""
    },
    {
      "code" : "A010392100",
      "display" : "THIAMPHENICOL CAPSULES 250MG \"PRINCE\""
    },
    {
      "code" : "A010395100",
      "display" : "TRAN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A010398100",
      "display" : "MELLAZINE S.C. TABLETS 50MG \"H.L.\""
    },
    {
      "code" : "A010399212",
      "display" : "KEFLIN INJECTION NEUTRAL 2GM"
    },
    {
      "code" : "A010402100",
      "display" : "ZINPIN TABLETS"
    },
    {
      "code" : "A010409238",
      "display" : "INSELON INJECTION \"Y.Y.\""
    },
    {
      "code" : "A010409248",
      "display" : "INSELON INJECTION \"Y.Y.\""
    },
    {
      "code" : "A010409299",
      "display" : "INSELON INJECTION \"Y.Y.\""
    },
    {
      "code" : "A010414417",
      "display" : "EYE WINACORT OINTMENT \"WINSTON\""
    },
    {
      "code" : "A010414429",
      "display" : "EYE WINACORT OINTMENT \"WINSTON\""
    },
    {
      "code" : "A010415100",
      "display" : "ANCOCILLIN CAPSULES"
    },
    {
      "code" : "A010416100",
      "display" : "ENTERCON TABLETS"
    },
    {
      "code" : "A010422212",
      "display" : "THIAMINE HYDROCHLORIDE INJECTION 50MG \"S.Y.\""
    },
    {
      "code" : "A010428100",
      "display" : "WINHOAMIN S.C. TABLETS 100MG \"H.L.\""
    },
    {
      "code" : "A010429209",
      "display" : "KEFLIN INJECTION NEUTRAL 1GM"
    },
    {
      "code" : "A010431100",
      "display" : "CALITH CAPSULES \"PATRON\""
    },
    {
      "code" : "A010434212",
      "display" : "ASTHCOMIN INJECTION \"T.S.\""
    },
    {
      "code" : "A010446100",
      "display" : "ANZUWEI CAPSULES \"H.H.\""
    },
    {
      "code" : "A0104461G0",
      "display" : "ANZUWEI CAPSULES \"H.H.\""
    },
    {
      "code" : "A010449221",
      "display" : "LIPOIC AC INJECTION"
    },
    {
      "code" : "A010450229",
      "display" : "KANOCIN INJECTION \"LITA\""
    },
    {
      "code" : "A010452221",
      "display" : "HISTIDINE INJECTION"
    },
    {
      "code" : "A010453212",
      "display" : "PADELIN INJECTION \"PATRON\""
    },
    {
      "code" : "A010457209",
      "display" : "PANTHOL INJECTION 100MG \"Y.Y.\""
    },
    {
      "code" : "A010457212",
      "display" : "PANTHOL INJECTION 100MG \"Y.Y.\""
    },
    {
      "code" : "A010460321",
      "display" : "TONITE OINTMENT"
    },
    {
      "code" : "A010465229",
      "display" : "KANAMYCIN INJECTION \"PATRON\""
    },
    {
      "code" : "A010478416",
      "display" : "BETASON-N EYE OINTMENT \"WINSTON\""
    },
    {
      "code" : "A010479100",
      "display" : "PONPAI CAPSULES"
    },
    {
      "code" : "A010482100",
      "display" : "BENZEL CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A010486212",
      "display" : "WINCOLD-S INJECTION \"WINSTON\""
    },
    {
      "code" : "A010487100",
      "display" : "HUASWEI TABLETS \"H.H.\""
    },
    {
      "code" : "A0104871G0",
      "display" : "HUASWEI TABLETS \"H.H.\""
    },
    {
      "code" : "A010488100",
      "display" : "HUAVINE TABLETS \"H.S.\""
    },
    {
      "code" : "A010489100",
      "display" : "HUAROKINE CAPSULES \"H.S.\""
    },
    {
      "code" : "A0104891G0",
      "display" : "HUAROKINE CAPSULES \"H.S.\""
    },
    {
      "code" : "A010491100",
      "display" : "NOGERON CAPSULES \"PATRON\""
    },
    {
      "code" : "A010508221",
      "display" : "LONACORT INJECTION 10MG/ML \"C.Y.\""
    },
    {
      "code" : "A010510100",
      "display" : "Sheemin Tablets 0.5mg \"F.Y.\""
    },
    {
      "code" : "A010511100",
      "display" : "H.R.P TABLETS"
    },
    {
      "code" : "A010547212",
      "display" : "DIAZEPAM INJECTION \"LITA\""
    },
    {
      "code" : "A010549209",
      "display" : "KANAMYCIN SULFATE INJECTIONS \"CHIU PO\""
    },
    {
      "code" : "A010569209",
      "display" : "KANAMYCIN SULFATE FOR INJECTION 1GM \"VPC\""
    },
    {
      "code" : "A010574100",
      "display" : "NOTONLEN CAPSULES"
    },
    {
      "code" : "A010576100",
      "display" : "Broadin-S Tablets \"Eayung\""
    },
    {
      "code" : "A010582100",
      "display" : "Gylonol Tablets \"H.L.\""
    },
    {
      "code" : "A010588100",
      "display" : "SINUCON CAPSULES \"LITA\""
    },
    {
      "code" : "A010614329",
      "display" : "LEDERCORT A TOPICAL CREAM 0.5％"
    },
    {
      "code" : "A010615377",
      "display" : "LEDERCORT A TOPICAL CREAM 0.1％"
    },
    {
      "code" : "A010615399",
      "display" : "LEDERCORT A TOPICAL CREAM 0.1％"
    },
    {
      "code" : "A010616335",
      "display" : "DELY OINTMENT \"W.F.\""
    },
    {
      "code" : "A010621100",
      "display" : "MIAU-WE TABLETS \"Y.C.\""
    },
    {
      "code" : "A010625100",
      "display" : "WINLEX CAPSULES 250MG \"WINSTON\""
    },
    {
      "code" : "A010638277",
      "display" : "STAMINA INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A010648100",
      "display" : "PARAFLU CAPSULES \"PANBIOTIC\""
    },
    {
      "code" : "A010652277",
      "display" : "RINGER'S INJECTION \"OTSUKA\""
    },
    {
      "code" : "A010654277",
      "display" : "NORM-SALINE INJECTION \"OTSUKA\""
    },
    {
      "code" : "A010655277",
      "display" : "DEXT-SALINE INJECTION \"OTSUKA\""
    },
    {
      "code" : "A010661348",
      "display" : "BETTER-IODINE GARGLE (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A010661355",
      "display" : "BETTER-IODINE GARGLE (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A010664209",
      "display" : "ERGO-S INJECTION \"WINSTON\""
    },
    {
      "code" : "A010683100",
      "display" : "ACETANIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A010688100",
      "display" : "ERYTHROCIN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A010689100",
      "display" : "LICOMINE TABLETS \"WINSTON\""
    },
    {
      "code" : "A010690100",
      "display" : "WINBUTOL TABLETS 250MG \"WINSTON\""
    },
    {
      "code" : "A010691100",
      "display" : "WINBUTOL TABLETS 400MG \"WINSTON\""
    },
    {
      "code" : "A010692100",
      "display" : "WINBUTOL-I TABLETS \"WINSTON\""
    },
    {
      "code" : "A010704100",
      "display" : "LOXAPAC CAPSULES 25MG"
    },
    {
      "code" : "A010709100",
      "display" : "SERNVITA S.C. TABLETS 100MG \"CHINTENG\""
    },
    {
      "code" : "A010710100",
      "display" : "SERNVITA S.C. TABLETS 50MG \"CHINTENG\""
    },
    {
      "code" : "A010720209",
      "display" : "OGECORT SUSPENDED INJECTIONS \"Y.Y.\""
    },
    {
      "code" : "A010720221",
      "display" : "OGECORT SUSPENDED INJECTIONS \"Y.Y.\""
    },
    {
      "code" : "A010721209",
      "display" : "Cyanocobalamine Injection \"S.Y.\""
    },
    {
      "code" : "A010721229",
      "display" : "Cyanocobalamine Injection \"S.Y.\""
    },
    {
      "code" : "A010722209",
      "display" : "SEKIJIS INJECTION"
    },
    {
      "code" : "A010726100",
      "display" : "MELLAZINE S.C. TABLETS 100MG \"H.L.\""
    },
    {
      "code" : "A010727100",
      "display" : "FURESURE S.C. TABLETS"
    },
    {
      "code" : "A010741100",
      "display" : "TONZ TABLETS \"S.T.\""
    },
    {
      "code" : "A010747100",
      "display" : "SUROATE TABLETS \"HONTEN\""
    },
    {
      "code" : "A010750100",
      "display" : "ILLUME TABLETS"
    },
    {
      "code" : "A010751100",
      "display" : "FASIGYN ORAL TABLETS 500MG"
    },
    {
      "code" : "A010753100",
      "display" : "PLINDAN S.C. TABLETS \"SHUN HWA\""
    },
    {
      "code" : "A010755100",
      "display" : "INDOMETHACIN CAPSULES \"T.A.\""
    },
    {
      "code" : "A010764100",
      "display" : "BACDAN TABLETS \"PATRON\""
    },
    {
      "code" : "A010773100",
      "display" : "AMPOLIN CAPSULES 500MG"
    },
    {
      "code" : "A010774100",
      "display" : "PIMINTON TABLETS \"PATRON\""
    },
    {
      "code" : "A010775100",
      "display" : "BRONDIN TABLETS \"PATRON\""
    },
    {
      "code" : "A010777340",
      "display" : "NIFUCIN OINTMENT \"PATRON\""
    },
    {
      "code" : "A0107773CH",
      "display" : "NIFUCIN OINTMENT \"PATRON\""
    },
    {
      "code" : "A010784209",
      "display" : "PANACAL INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A010790100",
      "display" : "PROTOKYLOL S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A010793212",
      "display" : "PATOBITAL INJECTION \"PATRON\""
    },
    {
      "code" : "A010794229",
      "display" : "PATAMICIN INJECTION \"PATRON\""
    },
    {
      "code" : "A010797229",
      "display" : "GENTAMYCIN INJECTION \"CHIUPO\""
    },
    {
      "code" : "A010800100",
      "display" : "Doxcycline Capsules \"Taiten\""
    },
    {
      "code" : "A010802100",
      "display" : "PECTRIN S.C. TABLETS 25MG"
    },
    {
      "code" : "A010812100",
      "display" : "HERSUN TABLETS 10MG \"F.Y.\""
    },
    {
      "code" : "A010815100",
      "display" : "BETAMETHASONE TABLETS \"PRINCE\""
    },
    {
      "code" : "A010819100",
      "display" : "SUPERCILLIN CAPSULES 250MG"
    },
    {
      "code" : "A0108191G0",
      "display" : "SUPERCILLIN CAPSULES 250MG"
    },
    {
      "code" : "A010822100",
      "display" : "VOSUTON S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A010823100",
      "display" : "TAREIN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A010826100",
      "display" : "GREEN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A010830209",
      "display" : "DIAZEPAM INJECTION \"ASTAR\""
    },
    {
      "code" : "A010830212",
      "display" : "DIAZEPAM INJECTION \"ASTAR\""
    },
    {
      "code" : "A010845212",
      "display" : "SUZUNAN INJECTIONS \"CHIU PO\""
    },
    {
      "code" : "A010848212",
      "display" : "PRANOL INJECTION \"Y.Y.\""
    },
    {
      "code" : "A010858100",
      "display" : "Meclizine Tablets \"M.D.\""
    },
    {
      "code" : "A010871277",
      "display" : "Stin powder for Injection"
    },
    {
      "code" : "A010893100",
      "display" : "FORD-PIN CAPSULES \"P.L.\""
    },
    {
      "code" : "A010906219",
      "display" : "SUNAMYCIN INJECTION \"T.F.\""
    },
    {
      "code" : "A010906229",
      "display" : "SUNAMYCIN INJECTION \"T.F.\""
    },
    {
      "code" : "A010907209",
      "display" : "GRECORT-A INJECTION \"G.L.\""
    },
    {
      "code" : "A010909100",
      "display" : "CINNARIZINE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A010912212",
      "display" : "HOBERINOL INJECTION \"G.C.\""
    },
    {
      "code" : "A010912229",
      "display" : "HOBERINOL INJECTION \"G.C.\""
    },
    {
      "code" : "A010914212",
      "display" : "Lidocaine HCl 2％ for I.V. Injection \"LITA\""
    },
    {
      "code" : "A010914221",
      "display" : "Lidocaine HCl 2％ for I.V. Injection \"LITA\""
    },
    {
      "code" : "A010916100",
      "display" : "MEBRON FILM COATING TABLETS 100MG"
    },
    {
      "code" : "A010917100",
      "display" : "BEHYD TABLETS"
    },
    {
      "code" : "A0109171G0",
      "display" : "BEHYD TABLETS"
    },
    {
      "code" : "A010928209",
      "display" : "TUDIN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A010937100",
      "display" : "HUALEN S.C. TABLETS \"H.H.\""
    },
    {
      "code" : "A010939277",
      "display" : "SAILISANNA INJECTION \"S.Y.\""
    },
    {
      "code" : "A010940238",
      "display" : "AIPATRON INJECTION \"PATRON\""
    },
    {
      "code" : "A010941100",
      "display" : "FUNGACIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A010943100",
      "display" : "RELAX TABLETS \"SHINLON\""
    },
    {
      "code" : "A010991100",
      "display" : "IBUPROFEN S.C. TABLETS"
    },
    {
      "code" : "A010992100",
      "display" : "PASTON CAPSULES \"P.L.\""
    },
    {
      "code" : "A011003100",
      "display" : "AMOLIN CAPSULES \"Y.F.\""
    },
    {
      "code" : "A011005100",
      "display" : "SUTAN TABLETS"
    },
    {
      "code" : "A011006100",
      "display" : "NICAMET F.C. TABLETS"
    },
    {
      "code" : "A011007100",
      "display" : "DIARRIKE TABLETS \"PATRON\""
    },
    {
      "code" : "A011007200",
      "display" : "DIARRIKE TABLETS \"PATRON\""
    },
    {
      "code" : "A011012100",
      "display" : "SKETA CAPSULES \"PATRON\""
    },
    {
      "code" : "A011013100",
      "display" : "ANTICOLD CAPSULES \"PATRON\""
    },
    {
      "code" : "A011014155",
      "display" : "COUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A011014157",
      "display" : "COUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A011014199",
      "display" : "COUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A011022100",
      "display" : "IBUFEN S.C. TABLETS \"S.C.\""
    },
    {
      "code" : "A011037421",
      "display" : "DECOTONG-N EYE DROPS"
    },
    {
      "code" : "A011041100",
      "display" : "LOMANTON S.C.TABLETS \"Y.S.\""
    },
    {
      "code" : "A011044100",
      "display" : "NONASMA TABLETS"
    },
    {
      "code" : "A011047221",
      "display" : "METHIOLAMINE-B12 INJECTION \"Y.Y.\""
    },
    {
      "code" : "A011048100",
      "display" : "EXPECTOLIN TABLETS 8MG"
    },
    {
      "code" : "A011063100",
      "display" : "KOAN-I TABLETS"
    },
    {
      "code" : "A011075209",
      "display" : "Sincort Suspended Injection"
    },
    {
      "code" : "A011075221",
      "display" : "Sincort Suspended Injection"
    },
    {
      "code" : "A011075229",
      "display" : "Sincort Suspended Injection"
    },
    {
      "code" : "A011076100",
      "display" : "CHAN-WAE TABLETS \"P.L.\""
    },
    {
      "code" : "A011078100",
      "display" : "PEI-MINE TABLETS \"P.L.\""
    },
    {
      "code" : "A011081321",
      "display" : "BENISON CREAM 0.1％ \"GENTLE\""
    },
    {
      "code" : "A011082100",
      "display" : "INDOZU E.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A011084100",
      "display" : "NORSON TABLETS \"HONTEN\""
    },
    {
      "code" : "A011093118",
      "display" : "COTAINE SYRUP \"HEALTH\""
    },
    {
      "code" : "A011093151",
      "display" : "COTAINE SYRUP \"HEALTH\""
    },
    {
      "code" : "A011093199",
      "display" : "COTAINE SYRUP \"HEALTH\""
    },
    {
      "code" : "A011103318",
      "display" : "SAINT-IODINE EXTERNAL SOLUTION \"PATRON\""
    },
    {
      "code" : "A011103319",
      "display" : "SAINT-IODINE EXTERNAL SOLUTION \"PATRON\""
    },
    {
      "code" : "A011103340",
      "display" : "SAINT-IODINE EXTERNAL SOLUTION \"PATRON\""
    },
    {
      "code" : "A011103399",
      "display" : "SAINT-IODINE EXTERNAL SOLUTION \"PATRON\""
    },
    {
      "code" : "A011124100",
      "display" : "BUTYPON S.C. TABLETS"
    },
    {
      "code" : "A011125100",
      "display" : "KERCORT TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A0111251G0",
      "display" : "KERCORT TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A011126277",
      "display" : "PAN-AMIN INJECTION"
    },
    {
      "code" : "A011128100",
      "display" : "KODA SUGAR-COATED TABLETS"
    },
    {
      "code" : "A011129100",
      "display" : "CORSETE S.C. TABLETS 0.5MG \"CHEN TA\" (COBAMAMIDE)"
    },
    {
      "code" : "A011132100",
      "display" : "BAOGIN TABLETS 5MG \"BOWLIN\""
    },
    {
      "code" : "A011135209",
      "display" : "CLOXAMPICILLIN INJECTION 1GM \"C.Y.\""
    },
    {
      "code" : "A011136209",
      "display" : "VETHASONE INJECTION \"S.Y.\""
    },
    {
      "code" : "A011136229",
      "display" : "VETHASONE INJECTION \"S.Y.\""
    },
    {
      "code" : "A011150212",
      "display" : "SUOPINCHON INJECTION \"S.Y.\""
    },
    {
      "code" : "A011154100",
      "display" : "SEQUITON TABLETS"
    },
    {
      "code" : "A0111541G0",
      "display" : "SEQUITON TABLETS"
    },
    {
      "code" : "A011155100",
      "display" : "NALIDIXIC ACID TABLETS 500MG \"T.A.\""
    },
    {
      "code" : "A011163100",
      "display" : "CINLOL TABLETS \"N.Y.\""
    },
    {
      "code" : "A011168100",
      "display" : "BETAMETHASONE TABLETS \"NCP\""
    },
    {
      "code" : "A011175277",
      "display" : "PAN-AMIN G INJECTION"
    },
    {
      "code" : "A011180100",
      "display" : "MESMIN TABLETS 15MG"
    },
    {
      "code" : "A011189118",
      "display" : "COLISO SYRUP \"WINSTON\""
    },
    {
      "code" : "A011189151",
      "display" : "COLISO SYRUP \"WINSTON\""
    },
    {
      "code" : "A011189157",
      "display" : "COLISO SYRUP \"WINSTON\""
    },
    {
      "code" : "A011189199",
      "display" : "COLISO SYRUP \"WINSTON\""
    },
    {
      "code" : "A011191100",
      "display" : "UNION TABLETS 5MG"
    },
    {
      "code" : "A011193100",
      "display" : "TEITHCAN SUGAR COATING TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A0111931G0",
      "display" : "TEITHCAN SUGAR COATING TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A011194100",
      "display" : "FUCOYEN CAPSULES 200MG \"CHEN TA\" (FLUFENAMIC ACID)"
    },
    {
      "code" : "A011199212",
      "display" : "MATOLON INJECTION \"Honten\""
    },
    {
      "code" : "A011207155",
      "display" : "SOMEPRIM GRANULES"
    },
    {
      "code" : "A011207199",
      "display" : "SOMEPRIM GRANULES"
    },
    {
      "code" : "A011209100",
      "display" : "ALUBRATE CAPSULES \"PATRON\""
    },
    {
      "code" : "A011213329",
      "display" : "PAONIMIN TABLETS"
    },
    {
      "code" : "A011219221",
      "display" : "TRENTAL INJECTION 20MG/ML(PENTOXIFYLLINE)"
    },
    {
      "code" : "A011224100",
      "display" : "DOXYNIN CAPSULES \"SWISS\""
    },
    {
      "code" : "A0112241G0",
      "display" : "DOXYNIN CAPSULES \"SWISS\""
    },
    {
      "code" : "A011230100",
      "display" : "HICOBAL CAPSULES \"GENTLE\""
    },
    {
      "code" : "A011234277",
      "display" : "CEPOLON INJECTION 500MG \"N.K.\""
    },
    {
      "code" : "A011254100",
      "display" : "KREAMALINE TABLETS"
    },
    {
      "code" : "A011308209",
      "display" : "Betasone Injection \"K.S.\""
    },
    {
      "code" : "A011317100",
      "display" : "ANTI-COUGH TABLETS"
    },
    {
      "code" : "A0113171G0",
      "display" : "ANTI-COUGH TABLETS"
    },
    {
      "code" : "A011318100",
      "display" : "OLYRRHIZIN F.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A011330309",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011330321",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011330329",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011330372",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011330377",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011330399",
      "display" : "PROPISONE OINTMENT"
    },
    {
      "code" : "A011331212",
      "display" : "GENTAMICIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011331229",
      "display" : "GENTAMICIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011331238",
      "display" : "GENTAMICIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011331299",
      "display" : "GENTAMICIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011337100",
      "display" : "TIN-BRAIN TABLETS \"HONG YA\""
    },
    {
      "code" : "A011341100",
      "display" : "Liventin TABLETS 8MG"
    },
    {
      "code" : "A011343100",
      "display" : "KANGCHITAN S.C. TABALETS"
    },
    {
      "code" : "A011344100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"Y.C.\""
    },
    {
      "code" : "A011352100",
      "display" : "BICHINTON TABLETS \"N.W.\""
    },
    {
      "code" : "A011358100",
      "display" : "TRANTIN S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A011404100",
      "display" : "FLOPIONE CAPSULES 80MG \"CHEN TA\""
    },
    {
      "code" : "A011407100",
      "display" : "COWEITHELINE TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A011409100",
      "display" : "MEPENZOLEN TABLETS"
    },
    {
      "code" : "A011410100",
      "display" : "PAINMEZONE TABLETS"
    },
    {
      "code" : "A011411100",
      "display" : "NICOPLAMIN TABLETS"
    },
    {
      "code" : "A011412100",
      "display" : "OROTIN S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A011420221",
      "display" : "NOOPOL INJECTION \"N.K.\""
    },
    {
      "code" : "A011420229",
      "display" : "NOOPOL INJECTION \"N.K.\""
    },
    {
      "code" : "A011421100",
      "display" : "NOOPOL CAPSULES \"N.K.\""
    },
    {
      "code" : "A011431437",
      "display" : "MYTEAR EYE LOTION"
    },
    {
      "code" : "A011435100",
      "display" : "RONFLOW CAPSULES 250MG \"S.S.P.\""
    },
    {
      "code" : "A011437229",
      "display" : "MEXATON INJECTION 0.4％ \"Y.A.\""
    },
    {
      "code" : "A011444277",
      "display" : "SEAFAR POWDER 0.5G FOR INJECTION"
    },
    {
      "code" : "A011449100",
      "display" : "PANTOMIN F.C. TABLETS"
    },
    {
      "code" : "A011465212",
      "display" : "HUAZIN INJECTION"
    },
    {
      "code" : "A011472100",
      "display" : "BETASONE TABLETS \"SHIN FONG\""
    },
    {
      "code" : "A011475209",
      "display" : "SHINCORT I.M. INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011475221",
      "display" : "SHINCORT I.M. INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011475229",
      "display" : "SHINCORT I.M. INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011476209",
      "display" : "SHINCORT INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011476221",
      "display" : "SHINCORT INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011476229",
      "display" : "SHINCORT INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011477212",
      "display" : "DECAN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011477229",
      "display" : "DECAN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011478100",
      "display" : "PEMIN TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A011479100",
      "display" : "CINNARIZINE TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A011482238",
      "display" : "POLYVITA INJECTION \"Y.Y.\""
    },
    {
      "code" : "A011483100",
      "display" : "GASTON TABLETS \"H.L.\""
    },
    {
      "code" : "A011485100",
      "display" : "POLYCIDE TABLETS \"BOWLIN\""
    },
    {
      "code" : "A011487100",
      "display" : "PYRIDOXINE HCL TABLETS 50MG"
    },
    {
      "code" : "A011489100",
      "display" : "PRENPERON S.C. TABLETS 10MG (METOCLOPRAMIDE)"
    },
    {
      "code" : "A011490109",
      "display" : "AMPICILLIN POWDER FOR ORAL SUSPENSION \"C.Y.\""
    },
    {
      "code" : "A011490110",
      "display" : "AMPICILLIN POWDER FOR ORAL SUSPENSION \"C.Y.\""
    },
    {
      "code" : "A011490199",
      "display" : "AMPICILLIN POWDER FOR ORAL SUSPENSION \"C.Y.\""
    },
    {
      "code" : "A011493151",
      "display" : "AREMIN COLD SOLUTION"
    },
    {
      "code" : "A011517100",
      "display" : "SINUTON CAPSULES \"N.W.\""
    },
    {
      "code" : "A011518100",
      "display" : "NEOMYCIN CAPSULES 250MG"
    },
    {
      "code" : "A011520209",
      "display" : "STERILE SHINOLON SUSPENDED INJECTION"
    },
    {
      "code" : "A011520229",
      "display" : "STERILE SHINOLON SUSPENDED INJECTION"
    },
    {
      "code" : "A011523100",
      "display" : "PERICON TABLETS \"W.T.\""
    },
    {
      "code" : "A011526100",
      "display" : "DEXAMETHASONE TABLETS \"S.C.\""
    },
    {
      "code" : "A011547100",
      "display" : "ALLORIC TABLETS"
    },
    {
      "code" : "A011548100",
      "display" : "ACENOL TABLETS 500MG"
    },
    {
      "code" : "A011552209",
      "display" : "DEXTROSE INJECTION 5％ \"OTSUKA\""
    },
    {
      "code" : "A011552255",
      "display" : "DEXTROSE INJECTION 5％ \"OTSUKA\""
    },
    {
      "code" : "A011552265",
      "display" : "DEXTROSE INJECTION 5％ \"OTSUKA\""
    },
    {
      "code" : "A011552277",
      "display" : "DEXTROSE INJECTION 5％ \"OTSUKA\""
    },
    {
      "code" : "A011555375",
      "display" : "GENTACIN OINTMENT"
    },
    {
      "code" : "A011555399",
      "display" : "GENTACIN OINTMENT"
    },
    {
      "code" : "A011562100",
      "display" : "PANTRIM TABLETS"
    },
    {
      "code" : "A011564329",
      "display" : "WANTACORT CREAM \"W.T.\""
    },
    {
      "code" : "A011564335",
      "display" : "WANTACORT CREAM \"W.T.\""
    },
    {
      "code" : "A011564338",
      "display" : "WANTACORT CREAM \"W.T.\""
    },
    {
      "code" : "A011564372",
      "display" : "WANTACORT CREAM \"W.T.\""
    },
    {
      "code" : "A011564399",
      "display" : "WANTACORT CREAM \"W.T.\""
    },
    {
      "code" : "A011570212",
      "display" : "SERACIN INJECTION"
    },
    {
      "code" : "A011570229",
      "display" : "SERACIN INJECTION"
    },
    {
      "code" : "A011570238",
      "display" : "SERACIN INJECTION"
    },
    {
      "code" : "A011576212",
      "display" : "SWITYL INJECTION \"SWISS BRAND\""
    },
    {
      "code" : "A011612100",
      "display" : "TAMDRON TABLETS 325MG \"COMFORT\""
    },
    {
      "code" : "A011631100",
      "display" : "CARBINOXAMINE TAB."
    },
    {
      "code" : "A011644100",
      "display" : "CONQUER TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A011652321",
      "display" : "BETTERSONE OINTMENT"
    },
    {
      "code" : "A011652329",
      "display" : "BETTERSONE OINTMENT"
    },
    {
      "code" : "A011652335",
      "display" : "BETTERSONE OINTMENT"
    },
    {
      "code" : "A011652372",
      "display" : "BETTERSONE OINTMENT"
    },
    {
      "code" : "A011652399",
      "display" : "BETTERSONE OINTMENT"
    },
    {
      "code" : "A011655100",
      "display" : "VIVIKA TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A0116551G0",
      "display" : "VIVIKA TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A011663209",
      "display" : "BROMINE INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011665209",
      "display" : "ASTHPIN INJECTION"
    },
    {
      "code" : "A011667216",
      "display" : "RIFOMYCIN INJECTION \"LITA\""
    },
    {
      "code" : "A011667223",
      "display" : "RIFOMYCIN INJECTION \"LITA\""
    },
    {
      "code" : "A011696238",
      "display" : "SULTON INJECTION \"LITA\""
    },
    {
      "code" : "A011701100",
      "display" : "PEIWETSU TABLETS \"P.L.\""
    },
    {
      "code" : "A011702100",
      "display" : "WUPIN TABLETS \"P.L.\""
    },
    {
      "code" : "A011703212",
      "display" : "SINCOVLIN INJECTION \"ASTAR\""
    },
    {
      "code" : "A011706100",
      "display" : "MINXLN TABLETS"
    },
    {
      "code" : "A0117061G0",
      "display" : "MINXLN TABLETS"
    },
    {
      "code" : "A011711265",
      "display" : "10％ DEXTROSE INJECTION \"OTSUKA\""
    },
    {
      "code" : "A011711277",
      "display" : "10％ DEXTROSE INJECTION \"OTSUKA\""
    },
    {
      "code" : "A011723265",
      "display" : "AMINOL-K INJECTION"
    },
    {
      "code" : "A011723277",
      "display" : "AMINOL-K INJECTION"
    },
    {
      "code" : "A011750212",
      "display" : "BIOMIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A011756100",
      "display" : "KELEXIN CAPSULES \"SHINLON\""
    },
    {
      "code" : "A011762212",
      "display" : "SULIVITA INJECTION 100MG"
    },
    {
      "code" : "A011762238",
      "display" : "SULIVITA INJECTION 100MG"
    },
    {
      "code" : "A011764216",
      "display" : "BERINE INJECTION"
    },
    {
      "code" : "A011775212",
      "display" : "CHIAOWELGEN INJECTION \"SWISS\""
    },
    {
      "code" : "A011776212",
      "display" : "SWELIUM INJECTION"
    },
    {
      "code" : "A011778355",
      "display" : "IODINE AQUEOUS SOLUTION 10％"
    },
    {
      "code" : "A011780212",
      "display" : "METOPERAN INJECTION"
    },
    {
      "code" : "A011782209",
      "display" : "ASTHNIL INJECTION"
    },
    {
      "code" : "A011783100",
      "display" : "SCOTCH S.C. TABLETS"
    },
    {
      "code" : "A011786100",
      "display" : "COFCON TABLETS 15MG"
    },
    {
      "code" : "A011788100",
      "display" : "EDITIN TABLETS 2MG"
    },
    {
      "code" : "A011790318",
      "display" : "BIODYNE ALCOHOLIC SOLUTION"
    },
    {
      "code" : "A011792100",
      "display" : "AMOXCIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A011794100",
      "display" : "HUSCOL CAPSULES \"Jenn Maw\""
    },
    {
      "code" : "A011795212",
      "display" : "CHUCO INJECTION"
    },
    {
      "code" : "A011806100",
      "display" : "INDOTHAN CAPSULES"
    },
    {
      "code" : "A011807100",
      "display" : "DIPYRON TABLETS"
    },
    {
      "code" : "A011809100",
      "display" : "FUROSIX TABLETS"
    },
    {
      "code" : "A011832209",
      "display" : "Seafar Powder 1g, 2g, 5g, 10g, 20g for Injection"
    },
    {
      "code" : "A011832212",
      "display" : "Seafar Powder 1g, 2g, 5g, 10g, 20g for Injection"
    },
    {
      "code" : "A011832221",
      "display" : "Seafar Powder 1g, 2g, 5g, 10g, 20g for Injection"
    },
    {
      "code" : "A011832229",
      "display" : "Seafar Powder 1g, 2g, 5g, 10g, 20g for Injection"
    },
    {
      "code" : "A011832238",
      "display" : "Seafar Powder 1g, 2g, 5g, 10g, 20g for Injection"
    },
    {
      "code" : "A011838417",
      "display" : "GENTAMICIN OPHTHALMIC OINTMENT \"OASIS\""
    },
    {
      "code" : "A011844100",
      "display" : "ORCITEC TABLETS \"GOLDEN HORSE\""
    },
    {
      "code" : "A011845209",
      "display" : "FRUCTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A011845265",
      "display" : "FRUCTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A011845277",
      "display" : "FRUCTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A011850118",
      "display" : "CONFLU SYRUP \"F.Y.\""
    },
    {
      "code" : "A011850155",
      "display" : "CONFLU SYRUP \"F.Y.\""
    },
    {
      "code" : "A011850199",
      "display" : "CONFLU SYRUP \"F.Y.\""
    },
    {
      "code" : "A011852100",
      "display" : "PARAME S.C. TABLETS"
    },
    {
      "code" : "A011862109",
      "display" : "PODOKEDON SYRUP"
    },
    {
      "code" : "A011862151",
      "display" : "PODOKEDON SYRUP"
    },
    {
      "code" : "A011862157",
      "display" : "PODOKEDON SYRUP"
    },
    {
      "code" : "A011862199",
      "display" : "PODOKEDON SYRUP"
    },
    {
      "code" : "A011863100",
      "display" : "PINRU TABLETS"
    },
    {
      "code" : "A011865212",
      "display" : "BIOVITAS INJECTION"
    },
    {
      "code" : "A011871118",
      "display" : "NOCOUGH-U SYRUP"
    },
    {
      "code" : "A011871151",
      "display" : "NOCOUGH-U SYRUP"
    },
    {
      "code" : "A011871199",
      "display" : "NOCOUGH-U SYRUP"
    },
    {
      "code" : "A011876100",
      "display" : "KORTUFEN CAPSULES \"H.H.P.\""
    },
    {
      "code" : "A011886277",
      "display" : "DEXTROSE AND SODIUM CHLORIDE INJECTION \"ASTAR\""
    },
    {
      "code" : "A011890212",
      "display" : "UCOUGIN-MEI INJECTION"
    },
    {
      "code" : "A011897172",
      "display" : "HISTAPP ELIXIR"
    },
    {
      "code" : "A011897199",
      "display" : "HISTAPP ELIXIR"
    },
    {
      "code" : "A011898100",
      "display" : "OUCEMIN TABLETS \"Y.Y.\""
    },
    {
      "code" : "A011904100",
      "display" : "TETRACYCLINE CAPSULES \"ENSUNE\""
    },
    {
      "code" : "A011905100",
      "display" : "PERONE S.C. TABLETS 10MG"
    },
    {
      "code" : "A011921238",
      "display" : "CHINLIVITA INJECTION"
    },
    {
      "code" : "A011924100",
      "display" : "FU-CHE TABLETS"
    },
    {
      "code" : "A011926100",
      "display" : "COMFORT TABLETS 5MG"
    },
    {
      "code" : "A011928100",
      "display" : "PARMINRIN F.C.TABLETS"
    },
    {
      "code" : "A011929100",
      "display" : "SOLAX CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A011931100",
      "display" : "PREDNISOLONE TABLETS \"MEIDER\""
    },
    {
      "code" : "A011932100",
      "display" : "RIPRIM TABLETS \"MEIDER\""
    },
    {
      "code" : "A011933209",
      "display" : "CEFACIN INJECTION \"LITA\""
    },
    {
      "code" : "A011933212",
      "display" : "CEFACIN INJECTION \"LITA\""
    },
    {
      "code" : "A011933277",
      "display" : "CEFACIN INJECTION \"LITA\""
    },
    {
      "code" : "A011949100",
      "display" : "ENTERAN TABLETS"
    },
    {
      "code" : "A011950212",
      "display" : "NEWNACORT INJECTION 40MG/ML"
    },
    {
      "code" : "A011950221",
      "display" : "NEWNACORT INJECTION 40MG/ML"
    },
    {
      "code" : "A011951100",
      "display" : "CEPHYALEXIN CAPSULES \"C.S.\""
    },
    {
      "code" : "A011964100",
      "display" : "TEKILON CAPSULES \"P.L.\""
    },
    {
      "code" : "A011968100",
      "display" : "RIFAPIN CAPSULES 300MG \"CHIU PO\""
    },
    {
      "code" : "A011969100",
      "display" : "PINSU TABLETS"
    },
    {
      "code" : "A011970100",
      "display" : "CEPHALEXIN CAPSULES"
    },
    {
      "code" : "A011971100",
      "display" : "ASTHMIN TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A011977212",
      "display" : "PYRABITAL INJECTION \"S.T.\""
    },
    {
      "code" : "A011979100",
      "display" : "LISUEN TABLETS \"P.L.\""
    },
    {
      "code" : "A011982100",
      "display" : "NICEFON TABLETS"
    },
    {
      "code" : "A011983100",
      "display" : "ORCITRAN TABLETS \"H.C.\""
    },
    {
      "code" : "A011986100",
      "display" : "RIOTOL TABLETS 400MG"
    },
    {
      "code" : "A011987212",
      "display" : "GARAMYCIN INJECTION \"N.K.\""
    },
    {
      "code" : "A011987219",
      "display" : "GARAMYCIN INJECTION \"N.K.\""
    },
    {
      "code" : "A011987229",
      "display" : "GARAMYCIN INJECTION \"N.K.\""
    },
    {
      "code" : "A011987238",
      "display" : "GARAMYCIN INJECTION \"N.K.\""
    },
    {
      "code" : "A011991100",
      "display" : "COLD CAPSULES \"JEN SHENG\""
    },
    {
      "code" : "A012000100",
      "display" : "TRIANPRES S.C. TABLETS \"N.C.P.\""
    },
    {
      "code" : "A012001372",
      "display" : "QUADRICREM CREAM"
    },
    {
      "code" : "A012001399",
      "display" : "QUADRICREM CREAM"
    },
    {
      "code" : "A012002209",
      "display" : "LYO-BC LYO-INJECTION"
    },
    {
      "code" : "A012004100",
      "display" : "SONVITA S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A012008100",
      "display" : "LISALEN TABLETS \"C.A.\""
    },
    {
      "code" : "A012019212",
      "display" : "GENTAMICIN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A012050212",
      "display" : "Gentacin Injection \"S.T.\""
    },
    {
      "code" : "A012050229",
      "display" : "Gentacin Injection \"S.T.\""
    },
    {
      "code" : "A012050238",
      "display" : "Gentacin Injection \"S.T.\""
    },
    {
      "code" : "A012050299",
      "display" : "Gentacin Injection \"S.T.\""
    },
    {
      "code" : "A012051100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"C.C.P.\""
    },
    {
      "code" : "A0120511G0",
      "display" : "AMOXICILLIN CAPSULES 250MG \"C.C.P.\""
    },
    {
      "code" : "A012053212",
      "display" : "GENTAMYCIN INJECTION 40MG \"ORIENTAL\""
    },
    {
      "code" : "A012053229",
      "display" : "GENTAMYCIN INJECTION 40MG \"ORIENTAL\""
    },
    {
      "code" : "A012055100",
      "display" : "MIN TA-WE TABLETS (DINYDROXYALUMINUM ALLANTOIN)\"M.T.\""
    },
    {
      "code" : "A012059100",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"Y.C.\""
    },
    {
      "code" : "A012060209",
      "display" : "BRONDIN INJECTION \"PATRON\""
    },
    {
      "code" : "A012065100",
      "display" : "OXYTETRACYCLINE CAPSULES 250MG \"S.S.P.\""
    },
    {
      "code" : "A012070335",
      "display" : "HUJYE OINTMENT \"P.L.\""
    },
    {
      "code" : "A012076100",
      "display" : "MYANLIN CAPSULES \"GENMONT\""
    },
    {
      "code" : "A012080100",
      "display" : "PURINOL TABLETS"
    },
    {
      "code" : "A012081100",
      "display" : "SPIRON TABLETS"
    },
    {
      "code" : "A0120811G0",
      "display" : "SPIRON TABLETS"
    },
    {
      "code" : "A012082100",
      "display" : "ANTIMIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A012089100",
      "display" : "SINARITIN TABETS"
    },
    {
      "code" : "A012090100",
      "display" : "ALATOLON S.C. TABLETS"
    },
    {
      "code" : "A012111100",
      "display" : "COBAMIDE CAPSULES"
    },
    {
      "code" : "A012115100",
      "display" : "PROFEN CAPSULES 200MG \"SHIN FONG\""
    },
    {
      "code" : "A012131100",
      "display" : "FOSTERON CAPSULES"
    },
    {
      "code" : "A012140100",
      "display" : "METRICHO CAPSULESS"
    },
    {
      "code" : "A012142100",
      "display" : "PRONOL CAPSULES"
    },
    {
      "code" : "A012145100",
      "display" : "WHILIDAN S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A012147100",
      "display" : "SULFATRIM TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A012148100",
      "display" : "KENARICIN TABLETS"
    },
    {
      "code" : "A012149100",
      "display" : "TRIMESOL TABLETS"
    },
    {
      "code" : "A012212100",
      "display" : "VITAMIN B COMPLEX TABLETS \"Y.C.\""
    },
    {
      "code" : "A012223100",
      "display" : "ALISIN-F S.C. TABLETS"
    },
    {
      "code" : "A012227372",
      "display" : "BETTER-IODINE HYDROCORTISONE OINTMENT \"WEI-MING\""
    },
    {
      "code" : "A012228109",
      "display" : "PAMOXICILLIN POWDER FOR ORAL SUSPENSION"
    },
    {
      "code" : "A012228110",
      "display" : "PAMOXICILLIN POWDER FOR ORAL SUSPENSION"
    },
    {
      "code" : "A012228199",
      "display" : "PAMOXICILLIN POWDER FOR ORAL SUSPENSION"
    },
    {
      "code" : "A012229100",
      "display" : "BIOVITA S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A012243100",
      "display" : "B.H. TABLETS 8MG \"LITA\""
    },
    {
      "code" : "A012292321",
      "display" : "FU-LI-HAO OINTMENT"
    },
    {
      "code" : "A012300321",
      "display" : "VEIMINCORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A012300329",
      "display" : "VEIMINCORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A012300372",
      "display" : "VEIMINCORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A012302100",
      "display" : "KIDORAL TABLETS 40MG \"KINGDOM\""
    },
    {
      "code" : "A012303100",
      "display" : "SEROGIN CAPSULES \"C.R.\""
    },
    {
      "code" : "A012311221",
      "display" : "TROBICIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A012311238",
      "display" : "TROBICIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A012314100",
      "display" : "ETHAMBUTOL TABLETS \"M.S.\""
    },
    {
      "code" : "A012315100",
      "display" : "DICA TABLETS"
    },
    {
      "code" : "A012318100",
      "display" : "YIKANG TABLETS"
    },
    {
      "code" : "A012325100",
      "display" : "WEOWE TABLETS \"M.S.\""
    },
    {
      "code" : "A012332100",
      "display" : "ASPHONLIN CAPSULES"
    },
    {
      "code" : "A012333100",
      "display" : "ORCIPRIN CAPSULES"
    },
    {
      "code" : "A012335100",
      "display" : "AN-WA CAPSULES \"C.R.\""
    },
    {
      "code" : "A012336100",
      "display" : "SU SOU TABLETS \"C.R.\""
    },
    {
      "code" : "A012337100",
      "display" : "SLEEPIN TABLETS \"C.R.\""
    },
    {
      "code" : "A012344100",
      "display" : "URESIDE TABLETS \"C.R.\""
    },
    {
      "code" : "A012371100",
      "display" : "BETAMETHASONE TABLETS \"M.T.\""
    },
    {
      "code" : "A012372100",
      "display" : "AMOXICILLIN CAPSULES \"C.S.\""
    },
    {
      "code" : "A012377329",
      "display" : "BETTER-INODINE OINTMENT (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A012377372",
      "display" : "BETTER-INODINE OINTMENT (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A012377399",
      "display" : "BETTER-INODINE OINTMENT (POVIDONE IODINE) \"WEI-MING\""
    },
    {
      "code" : "A012379100",
      "display" : "DOXYMYCIN CAPSULES \"PFOSHEN\""
    },
    {
      "code" : "A012383100",
      "display" : "HELZIN S.C. TABLETS \"EAYUNG\""
    },
    {
      "code" : "A012393417",
      "display" : "BENEMYCIN EYE OINTMENT \"OASIS\""
    },
    {
      "code" : "A012395100",
      "display" : "HUROMIDE TABLETS"
    },
    {
      "code" : "A012400100",
      "display" : "PHUSDOR TABLETS 200MG \"Y.S.\""
    },
    {
      "code" : "A012407500",
      "display" : "ANTI-GI SUPPOSITORY"
    },
    {
      "code" : "A012414100",
      "display" : "COLIOPAN TABLETS"
    },
    {
      "code" : "A012419209",
      "display" : "E.L.R. INJECTION NO.2"
    },
    {
      "code" : "A012419263",
      "display" : "E.L.R. INJECTION NO.2"
    },
    {
      "code" : "A012419277",
      "display" : "E.L.R. INJECTION NO.2"
    },
    {
      "code" : "A012420209",
      "display" : "E.L.R. INJECTION NO.3"
    },
    {
      "code" : "A012420263",
      "display" : "E.L.R. INJECTION NO.3"
    },
    {
      "code" : "A012420277",
      "display" : "E.L.R. INJECTION NO.3"
    },
    {
      "code" : "A012424321",
      "display" : "SULIKON CREAM \"S.S.P.\""
    },
    {
      "code" : "A012428100",
      "display" : "NOBAFON GRANULES \"GAP\""
    },
    {
      "code" : "A012428199",
      "display" : "NOBAFON GRANULES \"GAP\""
    },
    {
      "code" : "A012433100",
      "display" : "SUPANTAN CAPSULES \"S.C.\""
    },
    {
      "code" : "A012434100",
      "display" : "PANSTAL CAPSULES \"C.R.\""
    },
    {
      "code" : "A012443500",
      "display" : "INTHACID SUPPOSITORIES \"PATRON\""
    },
    {
      "code" : "A012445100",
      "display" : "LIBITIM S.C. TABLETS 10MG \"CHEN TA\" (CHLORDIAZEPOXIDE)"
    },
    {
      "code" : "A012446100",
      "display" : "BETASON TABLETS 0.5MG \"CHEN TA\" (BETAMETHASONE)"
    },
    {
      "code" : "A012447100",
      "display" : "BOSCON F.C. TABLETS 10MG \"T.F.\""
    },
    {
      "code" : "A012451229",
      "display" : "HIDOMIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A012452100",
      "display" : "FLACIL CAPSULES"
    },
    {
      "code" : "A012454100",
      "display" : "KIMMEDOM TABLETS \"KINGDOM\""
    },
    {
      "code" : "A012458100",
      "display" : "EURODIN TABLETS 2MG"
    },
    {
      "code" : "A0124581G0",
      "display" : "EURODIN TABLETS 2MG"
    },
    {
      "code" : "A012472100",
      "display" : "BROMHEXIN TABLETS \"GENTLE\""
    },
    {
      "code" : "A012474209",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"N.K.\""
    },
    {
      "code" : "A012474229",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"N.K.\""
    },
    {
      "code" : "A012484100",
      "display" : "LISON TABLETS \"P.L.\""
    },
    {
      "code" : "A012488100",
      "display" : "SULININ TABLETS \"K.N.\""
    },
    {
      "code" : "A012489100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES \"S.S.P.\""
    },
    {
      "code" : "A012492100",
      "display" : "PREDNISOLONE TABLETS \"C.R\""
    },
    {
      "code" : "A012505100",
      "display" : "Vigill Menstrual Relief Tablets"
    },
    {
      "code" : "A012506100",
      "display" : "UPTHASONE TABLETS \"JINUP\""
    },
    {
      "code" : "A012517100",
      "display" : "CAROLIN TABLETS \"C.R.\""
    },
    {
      "code" : "A012519100",
      "display" : "ANETHION S.C. TABLETS"
    },
    {
      "code" : "A012520318",
      "display" : "BIODYNE AQUEOUS SOLUTION"
    },
    {
      "code" : "A012520399",
      "display" : "BIODYNE AQUEOUS SOLUTION"
    },
    {
      "code" : "A012521212",
      "display" : "GENTACIN INJECTION"
    },
    {
      "code" : "A012521229",
      "display" : "GENTACIN INJECTION"
    },
    {
      "code" : "A012521299",
      "display" : "GENTACIN INJECTION"
    },
    {
      "code" : "A012523100",
      "display" : "GUSERVIN TABLETS \"C.Y.\""
    },
    {
      "code" : "A012524100",
      "display" : "MINRID TABLETS \"H.S.\""
    },
    {
      "code" : "A012527209",
      "display" : "SIVKORT SUSPENSION"
    },
    {
      "code" : "A012527229",
      "display" : "SIVKORT SUSPENSION"
    },
    {
      "code" : "A012528210",
      "display" : "SEVATRIM INJECTION"
    },
    {
      "code" : "A012528221",
      "display" : "SEVATRIM INJECTION"
    },
    {
      "code" : "A012530329",
      "display" : "PREDNISOLONE OINTMENT \"K.Y.\""
    },
    {
      "code" : "A012530372",
      "display" : "PREDNISOLONE OINTMENT \"K.Y.\""
    },
    {
      "code" : "A012538100",
      "display" : "DOXYCYCLINE CAPSULES \"C.S.\""
    },
    {
      "code" : "A012542100",
      "display" : "ULCEWEI TABLETS \"CHEN TA\""
    },
    {
      "code" : "A012548100",
      "display" : "VASOLIN TABLETS \"BOWLIN\""
    },
    {
      "code" : "A012550100",
      "display" : "DECARON S.C. TABLET 0.75MG (DEXAMETHASONE) \"CHEN TA\""
    },
    {
      "code" : "A012551100",
      "display" : "SKELIN TABLETS \"F.Y.\""
    },
    {
      "code" : "A012552100",
      "display" : "CININ TABLETS \"N.C.P.\""
    },
    {
      "code" : "A012556109",
      "display" : "SHECO GRANULES(Bromhexine Hydrochloride)"
    },
    {
      "code" : "A012557100",
      "display" : "DURAMYCIN CAPSULES \"GCPC\""
    },
    {
      "code" : "A012596100",
      "display" : "MECOFAN TABLETS \"ASTAR\""
    },
    {
      "code" : "A012597209",
      "display" : "BERLICORT SUSPENSION IM. INJECTION 40MG \"PRINCE\""
    },
    {
      "code" : "A012597212",
      "display" : "BERLICORT SUSPENSION IM. INJECTION 40MG \"PRINCE\""
    },
    {
      "code" : "A012597229",
      "display" : "BERLICORT SUSPENSION IM. INJECTION 40MG \"PRINCE\""
    },
    {
      "code" : "A012599100",
      "display" : "TRIMEZOL TABLETS \"KINGDOM\""
    },
    {
      "code" : "A012601100",
      "display" : "EI BAE YAN S.C TABLETS 100MG \"N.K.\""
    },
    {
      "code" : "A012603100",
      "display" : "METHOMINE TABLETS \"H.S.\""
    },
    {
      "code" : "A012633100",
      "display" : "AMPIMYCIN CAPSULES \"ENSURE\""
    },
    {
      "code" : "A012639100",
      "display" : "TETRACYCLINE HCL TABLETS \"C.C.P.\""
    },
    {
      "code" : "A012646100",
      "display" : "GYNEDOL TABLETS 1MG \"H.L.\""
    },
    {
      "code" : "A012649212",
      "display" : "AVAPYRA INJECTION"
    },
    {
      "code" : "A012649216",
      "display" : "AVAPYRA INJECTION"
    },
    {
      "code" : "A012673100",
      "display" : "CASTON TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A012675100",
      "display" : "\"UBIP\"CINNARIZINE TABLETS"
    },
    {
      "code" : "A012687100",
      "display" : "WINPECON TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A012692100",
      "display" : "TANCULON S.C. TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A012694100",
      "display" : "ULCEN TABLETS \"MEIDER\""
    },
    {
      "code" : "A012703100",
      "display" : "SINPRIM F.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0127031G0",
      "display" : "SINPRIM F.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A012714100",
      "display" : "NO-PEIN CAPSULES \"P.L.\""
    },
    {
      "code" : "A012730212",
      "display" : "LIN KAN INJECITON"
    },
    {
      "code" : "A012735212",
      "display" : "GENTAMYCIN INJECTION 40MG/ML \"C.Y.\""
    },
    {
      "code" : "A012735229",
      "display" : "GENTAMYCIN INJECTION 40MG/ML \"C.Y.\""
    },
    {
      "code" : "A012735238",
      "display" : "GENTAMYCIN INJECTION 40MG/ML \"C.Y.\""
    },
    {
      "code" : "A012739100",
      "display" : "DEXON TABLETS \"MAY SEE\""
    },
    {
      "code" : "A012745309",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745316",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745321",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745329",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745335",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745338",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745377",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012745399",
      "display" : "PARMASON CREAM \"BOWLIN\""
    },
    {
      "code" : "A012752212",
      "display" : "CANTAMYCIN INJECTION 40MG (POTENCY)/ML \"PRINCE\""
    },
    {
      "code" : "A012752229",
      "display" : "CANTAMYCIN INJECTION 40MG (POTENCY)/ML \"PRINCE\""
    },
    {
      "code" : "A012752238",
      "display" : "CANTAMYCIN INJECTION 40MG (POTENCY)/ML \"PRINCE\""
    },
    {
      "code" : "A012754140",
      "display" : "SPEERO GRANULES \"H.H.\""
    },
    {
      "code" : "A012756212",
      "display" : "GENTEACIN INJECTION 40MG \"FUMIN\""
    },
    {
      "code" : "A012759100",
      "display" : "BICIDIUM TABLETS \"C.R.\""
    },
    {
      "code" : "A012763100",
      "display" : "DEYANJUNN TABLETS"
    },
    {
      "code" : "A012765100",
      "display" : "Idofen Tablets 200mg (Ibuprofen)"
    },
    {
      "code" : "A012776100",
      "display" : "PSEUDOPHRINE CAPSULES"
    },
    {
      "code" : "A012782100",
      "display" : "DOXYCYCLINE CAPSULES 100MG \"CSP\""
    },
    {
      "code" : "A012803100",
      "display" : "EULIVER F.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A0128031G0",
      "display" : "EULIVER F.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A012804100",
      "display" : "SUPITON TABLETS \"F.B\""
    },
    {
      "code" : "A012807100",
      "display" : "OUTINFLAME TABLETS \"H.S.\""
    },
    {
      "code" : "A012814100",
      "display" : "TINIDAZOLE TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A012817100",
      "display" : "MEICO TABLETS 15MG"
    },
    {
      "code" : "A012818100",
      "display" : "MEICO TABLETS 30MG"
    },
    {
      "code" : "A012824277",
      "display" : "LOW MOLECULAR DEXTRAN DEXTROSE INJECTION \"OTSUKA\""
    },
    {
      "code" : "A012825100",
      "display" : "NITROGLYCERIN TABLETS 0.6 MG \"NYSCO\""
    },
    {
      "code" : "A012828100",
      "display" : "ALUZAINE TABLETS"
    },
    {
      "code" : "A0128281G0",
      "display" : "ALUZAINE TABLETS"
    },
    {
      "code" : "A012831100",
      "display" : "MEFEN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0128311G0",
      "display" : "MEFEN TABLETS \"CHINTENG\""
    },
    {
      "code" : "A012833100",
      "display" : "PYMADON TABLETS \"CHINTENG\""
    },
    {
      "code" : "A012835100",
      "display" : "ILLUME CAPSULES"
    },
    {
      "code" : "A012836100",
      "display" : "RESERPINE TABLETS \"ASTAR\""
    },
    {
      "code" : "A012837100",
      "display" : "HYLAZINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A0128371G0",
      "display" : "HYLAZINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A012854100",
      "display" : "UROINE S.C. TABLETS \"S.S.P.\""
    },
    {
      "code" : "A012858277",
      "display" : "DICILLIN INJECTION 500MG"
    },
    {
      "code" : "A012859100",
      "display" : "FETAY TABLETS"
    },
    {
      "code" : "A012860100",
      "display" : "NONASMA TABLETS 20MG"
    },
    {
      "code" : "A012876100",
      "display" : "BIOTASE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A012877100",
      "display" : "ROCOSOL CAPSULES \"C.R.\""
    },
    {
      "code" : "A012879177",
      "display" : "CEPHALEXIN GRANULES FOR SYRUP \"Y.C.\""
    },
    {
      "code" : "A012880100",
      "display" : "COUGHMIN S.C. TABLETS \"KYORIN\""
    },
    {
      "code" : "A012886321",
      "display" : "SUNBIN MEDICINE CREAM"
    },
    {
      "code" : "A012886329",
      "display" : "SUNBIN MEDICINE CREAM"
    },
    {
      "code" : "A012886372",
      "display" : "SUNBIN MEDICINE CREAM"
    },
    {
      "code" : "A012886399",
      "display" : "SUNBIN MEDICINE CREAM"
    },
    {
      "code" : "A012888100",
      "display" : "VITAMIN E S.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A012898100",
      "display" : "SERPINE TABLETS \"Y.C.\""
    },
    {
      "code" : "A012901321",
      "display" : "AYGAUSHON OINTMENT \"J.H.\""
    },
    {
      "code" : "A012902100",
      "display" : "KUAY WEY HAO TABLETS \"J.H.\""
    },
    {
      "code" : "A012905100",
      "display" : "NEWFORT S.C. TABLETS 10MG"
    },
    {
      "code" : "A012907100",
      "display" : "WEIKEPYNG S.C. TABLETS \"N.M.\""
    },
    {
      "code" : "A012910100",
      "display" : "IBUFEN TABLETS 200MG"
    },
    {
      "code" : "A012951100",
      "display" : "TRIMEZOLE TABLETS"
    },
    {
      "code" : "A012955100",
      "display" : "ECON TABLETS 40MG"
    },
    {
      "code" : "A012958100",
      "display" : "TWUCOLIN CAPSULES"
    },
    {
      "code" : "A012964100",
      "display" : "UNOUTON S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A012972100",
      "display" : "HOMAGAL TABLETS"
    },
    {
      "code" : "A012973421",
      "display" : "GENTAMICIN EYE DROPS \"OASIS\""
    },
    {
      "code" : "A012975100",
      "display" : "SALTOLIN TABLETS \"GENTLE\""
    },
    {
      "code" : "A012986265",
      "display" : "DEXT-SALINE INJECTION 5:0.3 \"OTSUKA\""
    },
    {
      "code" : "A012986277",
      "display" : "DEXT-SALINE INJECTION 5:0.3 \"OTSUKA\""
    },
    {
      "code" : "A012989100",
      "display" : "IPUFEN TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A012999323",
      "display" : "BETA CORT CREAM"
    },
    {
      "code" : "A012999335",
      "display" : "BETA CORT CREAM"
    },
    {
      "code" : "A013007100",
      "display" : "BRONOUT TABLETS 20MG \"JINUP\""
    },
    {
      "code" : "A013011100",
      "display" : "RIPIN CAPSULES 150MG"
    },
    {
      "code" : "A013012212",
      "display" : "SAUCON INJECTION \"H.S.C.\""
    },
    {
      "code" : "A013020321",
      "display" : "KONZIN CREAM \"CHIUPO\""
    },
    {
      "code" : "A013023100",
      "display" : "EPHEZON TABLETS"
    },
    {
      "code" : "A013024177",
      "display" : "CEPHALEXIN GRANULES \"H.S.C.\""
    },
    {
      "code" : "A013024199",
      "display" : "CEPHALEXIN GRANULES \"H.S.C.\""
    },
    {
      "code" : "A013049100",
      "display" : "SOURIREE COMNAMINE-F S.C. TABLET 50MG"
    },
    {
      "code" : "A013054100",
      "display" : "QURMININ-H CAPSULES \"S.C.\""
    },
    {
      "code" : "A013077100",
      "display" : "HUALISHIH CAPSULES\"H.S.\""
    },
    {
      "code" : "A013078100",
      "display" : "JIEE-SUAN-LONG TABLETS"
    },
    {
      "code" : "A013082100",
      "display" : "SALBUTAMOL TABLETS \"PRINCE\""
    },
    {
      "code" : "A013083100",
      "display" : "ISONIAZID TABLETS \"WINSTON\""
    },
    {
      "code" : "A0130831G0",
      "display" : "ISONIAZID TABLETS \"WINSTON\""
    },
    {
      "code" : "A013084100",
      "display" : "NOSCAPINE TABLETS 20mg \"H.L.\""
    },
    {
      "code" : "A013085100",
      "display" : "IBUPROFEN TABLETS 200MG \"C.S.\""
    },
    {
      "code" : "A013087100",
      "display" : "GLIBENCLAMIDE TABLETS \"H.C.\""
    },
    {
      "code" : "A013089100",
      "display" : "SALBUTAMOL TABLETS"
    },
    {
      "code" : "A013091100",
      "display" : "\"UBIP\" MEPENZOLATE TABLETS"
    },
    {
      "code" : "A0130911G0",
      "display" : "\"UBIP\" MEPENZOLATE TABLETS"
    },
    {
      "code" : "A013093100",
      "display" : "AMPICILLIN CAPSULES 500MG \"CHI SHENG\""
    },
    {
      "code" : "A013097100",
      "display" : "IBUPROFEN S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A013103109",
      "display" : "HISTAPP GRANULES"
    },
    {
      "code" : "A013118100",
      "display" : "CHLORMEZANONE TABLETS \"SHINLON\""
    },
    {
      "code" : "A013119100",
      "display" : "Dicyclomine Tablets\"Standard\""
    },
    {
      "code" : "A013126100",
      "display" : "HCNORITLE PIPRINHYDRINATE TABLETS"
    },
    {
      "code" : "A013130100",
      "display" : "OXELADIN CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A013133100",
      "display" : "GLYCERYL TABLETS \"Y.C.\""
    },
    {
      "code" : "A013137100",
      "display" : "SCOPOMINE TABLETS"
    },
    {
      "code" : "A013141209",
      "display" : "GENTAMYCIN INJECTION \"H.S.C.\""
    },
    {
      "code" : "A013141212",
      "display" : "GENTAMYCIN INJECTION \"H.S.C.\""
    },
    {
      "code" : "A013147155",
      "display" : "MINOCYCLINE GRANULES"
    },
    {
      "code" : "A013147199",
      "display" : "MINOCYCLINE GRANULES"
    },
    {
      "code" : "A013162100",
      "display" : "BETAMETHASONE TABLETS \"JOHNSON\""
    },
    {
      "code" : "A013168100",
      "display" : "METOCLOPRAMIDE S.C. TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A013175100",
      "display" : "PREDNISOLONE TABLETS \"C.H.\""
    },
    {
      "code" : "A013178100",
      "display" : "GLIBENCLAMIDE TABLETS"
    },
    {
      "code" : "A013180100",
      "display" : "NALIDIXIC ACID TABLETS 500MG \"SHINLON\""
    },
    {
      "code" : "A013181100",
      "display" : "URINTESTIN TABLETS 500MG"
    },
    {
      "code" : "A013184100",
      "display" : "RYNIN CAPSULES \"S.C.\""
    },
    {
      "code" : "A013198110",
      "display" : "AMPICILLIN POWDER FOR ORAL SUSPENSION \"VPP\""
    },
    {
      "code" : "A013199209",
      "display" : "ORCIPRENALINE INJECTION \"S.Y.\""
    },
    {
      "code" : "A013205109",
      "display" : "BATHOLIN GRANULES \"GENTLE\""
    },
    {
      "code" : "A013205199",
      "display" : "BATHOLIN GRANULES \"GENTLE\""
    },
    {
      "code" : "A013210100",
      "display" : "CLORPRENALINE TABLETS \"Y.S.\""
    },
    {
      "code" : "A013228100",
      "display" : "TEH LI KON ANODYNE CAPSULES (Ibuprofen 200mg)"
    },
    {
      "code" : "A013229100",
      "display" : "AMOXICILLIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A013230100",
      "display" : "FUCOLE IBUPROFEN CAPSULES"
    },
    {
      "code" : "A013236100",
      "display" : "VITAMIN C TABLETS 200MG \"WINSTON\""
    },
    {
      "code" : "A013240100",
      "display" : "FLUFENAMIC ACID CAPSULES \"TK&A\""
    },
    {
      "code" : "A013262421",
      "display" : "MAXITROL OPHTHALMIC SUSPENSION"
    },
    {
      "code" : "A013311100",
      "display" : "SILANCON TABLETS \"GENTLE\""
    },
    {
      "code" : "A013329100",
      "display" : "RICOL CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A013333100",
      "display" : "IBUPROFEN CAPSULES \"C.P.\""
    },
    {
      "code" : "A013339151",
      "display" : "PANCOPAR SYRUP \"BOWLIN\""
    },
    {
      "code" : "A013339157",
      "display" : "PANCOPAR SYRUP \"BOWLIN\""
    },
    {
      "code" : "A013348100",
      "display" : "TRIMOX TABLETS \"PRINCE\""
    },
    {
      "code" : "A013349212",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 10MG \"PRINCE\""
    },
    {
      "code" : "A013349229",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 10MG \"PRINCE\""
    },
    {
      "code" : "A013351100",
      "display" : "ACETAMINOPHEN TABLETS \"Y.C.\""
    },
    {
      "code" : "A013354277",
      "display" : "MANNITOL INJECTION 20％ \"CHI SHENG\""
    },
    {
      "code" : "A013360100",
      "display" : "CARBETAPENTANE CAPSULES 30MG \"S.T.\""
    },
    {
      "code" : "A013361100",
      "display" : "MEFENAMIC ACID CAPSULES \"C.H.\""
    },
    {
      "code" : "A013366100",
      "display" : "SINZUIN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A013367100",
      "display" : "RIFAMPICIN CAPSULES \"Y.C.\""
    },
    {
      "code" : "A013381100",
      "display" : "Cortisone Acetate Tablets 25mg \"Pine Lawer\""
    },
    {
      "code" : "A013382100",
      "display" : "MAGNESIUM OXIDE TABLETS 250MG \"VPP\""
    },
    {
      "code" : "A013399100",
      "display" : "PROTHIAMIN F50 S.C.TAB."
    },
    {
      "code" : "A013403209",
      "display" : "METHYLERGONOVINE MALEATE INJECTION \"N.K.\""
    },
    {
      "code" : "A013405100",
      "display" : "MEFENAMIC ACID CAPSULES \"N.C.P.\""
    },
    {
      "code" : "A013408177",
      "display" : "ERYTHROMYCIN ESTOLATE GRANULES \"H.S.C.\""
    },
    {
      "code" : "A013408199",
      "display" : "ERYTHROMYCIN ESTOLATE GRANULES \"H.S.C.\""
    },
    {
      "code" : "A013415100",
      "display" : "IBUPROFEN CAPSULES \"H.C.\""
    },
    {
      "code" : "A013425212",
      "display" : "METOCLOPRAMIDE INJECTION \"FUMIN\""
    },
    {
      "code" : "A013429100",
      "display" : "NEUZYM TABLETS 30MG (LYSOZYME TABLETS 30MG)"
    },
    {
      "code" : "A013431100",
      "display" : "NEUZYM TABLETS 10MG (LYSOZYME TABLETS 10MG)"
    },
    {
      "code" : "A013432100",
      "display" : "TEDOFURYL CAPSULES \"CHIUPO\""
    },
    {
      "code" : "A013433100",
      "display" : "ALLOPURINOL TABLETS \"MEIDER\""
    },
    {
      "code" : "A013439209",
      "display" : "ISOPROTERENOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A013440221",
      "display" : "VETHASONE SUSPENDED INJECTION \"S.Y.\""
    },
    {
      "code" : "A013465500",
      "display" : "ASPIRIN SUPPOSITORIES \"Y.S.\""
    },
    {
      "code" : "A013471100",
      "display" : "BROWN MIXTURE WITHOUT OPIUM \"METRO\""
    },
    {
      "code" : "A013471118",
      "display" : "BROWN MIXTURE WITHOUT OPIUM \"METRO\""
    },
    {
      "code" : "A013471199",
      "display" : "BROWN MIXTURE WITHOUT OPIUM \"METRO\""
    },
    {
      "code" : "A013480100",
      "display" : "KANMO CAPSULES \"H.L.\""
    },
    {
      "code" : "A013483100",
      "display" : "MEFENAMIC ACID CAPSULES \"SHIN FONG\""
    },
    {
      "code" : "A013491100",
      "display" : "SUNSHINGCOUGH CAPSULES \"H.S.\""
    },
    {
      "code" : "A013500100",
      "display" : "SHIN WEY JIAN TABLETS"
    },
    {
      "code" : "A013503100",
      "display" : "ERGONOVINE MALEATE TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A013509209",
      "display" : "DEXSALIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013509265",
      "display" : "DEXSALIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013509277",
      "display" : "DEXSALIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013510329",
      "display" : "MESENZIN OINTMENT \"Y.C.\""
    },
    {
      "code" : "A013510338",
      "display" : "MESENZIN OINTMENT \"Y.C.\""
    },
    {
      "code" : "A013511100",
      "display" : "CHLOROMEZANONE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A013520321",
      "display" : "METHASONE OINTMENT \"H.L.\""
    },
    {
      "code" : "A013525100",
      "display" : "BROMHEXINE TABLETS \"GENMONT\""
    },
    {
      "code" : "A013526100",
      "display" : "GLIBENCLAMIDE TABLETS \"PRINCE\""
    },
    {
      "code" : "A013531100",
      "display" : "SEDASPA S.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A013535151",
      "display" : "ANTICOUGH SYRUP WITH CODEINE \"C.S.P.\""
    },
    {
      "code" : "A013535157",
      "display" : "ANTICOUGH SYRUP WITH CODEINE \"C.S.P.\""
    },
    {
      "code" : "A013535199",
      "display" : "ANTICOUGH SYRUP WITH CODEINE \"C.S.P.\""
    },
    {
      "code" : "A013545219",
      "display" : "KANAMYCIN INJECTION \"METRO\""
    },
    {
      "code" : "A013545229",
      "display" : "KANAMYCIN INJECTION \"METRO\""
    },
    {
      "code" : "A013546100",
      "display" : "PAPAVERINE CAPSULES \"C.S.\""
    },
    {
      "code" : "A013547100",
      "display" : "ANETHOL CAPSULES \"M.T.\""
    },
    {
      "code" : "A013550212",
      "display" : "PYRABITAL INJECTION \"SWISS\""
    },
    {
      "code" : "A013557100",
      "display" : "TONPICON CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A013565118",
      "display" : "DEXAMETHASONE SYRUP 0.1MG"
    },
    {
      "code" : "A013565199",
      "display" : "DEXAMETHASONE SYRUP 0.1MG"
    },
    {
      "code" : "A013567100",
      "display" : "MIAWSHYJING TABLETS \"S.T.\""
    },
    {
      "code" : "A013573277",
      "display" : "CEPHALORIDINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013574238",
      "display" : "TAIBILONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013575209",
      "display" : "PROGESTERONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013575229",
      "display" : "PROGESTERONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013576219",
      "display" : "KANAMYCIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013576229",
      "display" : "KANAMYCIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013576238",
      "display" : "KANAMYCIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013576299",
      "display" : "KANAMYCIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013577212",
      "display" : "VITAMIN C INJECTION \"TAI YU\""
    },
    {
      "code" : "A013577229",
      "display" : "VITAMIN C INJECTION \"TAI YU\""
    },
    {
      "code" : "A013577238",
      "display" : "VITAMIN C INJECTION \"TAI YU\""
    },
    {
      "code" : "A013578209",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 10MG \"TAI YU\""
    },
    {
      "code" : "A013578221",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 10MG \"TAI YU\""
    },
    {
      "code" : "A013578229",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 10MG \"TAI YU\""
    },
    {
      "code" : "A013581277",
      "display" : "AMPICILLIN SODIUM INJECTION \"TAI YU\""
    },
    {
      "code" : "A013582238",
      "display" : "GLUCAMETHI INJECTION \"TAI YU\""
    },
    {
      "code" : "A013583209",
      "display" : "HYDROXOCOBALAMIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013583229",
      "display" : "HYDROXOCOBALAMIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A013591100",
      "display" : "GRISEOFULVIN TABALETS \"Y.C.\""
    },
    {
      "code" : "A013594100",
      "display" : "GRISEOFULVIN TABLETS \"S.S.P.\""
    },
    {
      "code" : "A013612100",
      "display" : "IBUPROFEN CAPSULES \"HONTEN\""
    },
    {
      "code" : "A013617100",
      "display" : "PROBENECID TABLETS \"SHITEH\""
    },
    {
      "code" : "A013627100",
      "display" : "RIFAMPICIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A013631100",
      "display" : "CARBINOXAMINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A013634100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A0136341G0",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A013637212",
      "display" : "GENTAMICIN SULFATE INJECTION \"SOURIREE\""
    },
    {
      "code" : "A013637216",
      "display" : "GENTAMICIN SULFATE INJECTION \"SOURIREE\""
    },
    {
      "code" : "A013637229",
      "display" : "GENTAMICIN SULFATE INJECTION \"SOURIREE\""
    },
    {
      "code" : "A013637238",
      "display" : "GENTAMICIN SULFATE INJECTION \"SOURIREE\""
    },
    {
      "code" : "A013638100",
      "display" : "BROMPHENIRAMINE TABLETS \"J.S.\""
    },
    {
      "code" : "A013644100",
      "display" : "LONTEC TABLETS \"H.H.\""
    },
    {
      "code" : "A013645238",
      "display" : "SALCON INJECTION \"N.K.\""
    },
    {
      "code" : "A013647309",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013647321",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013647329",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013647335",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013647372",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013647399",
      "display" : "GENTASONE CREAM"
    },
    {
      "code" : "A013650100",
      "display" : "INAVITA TABLETS \"WINSTON\""
    },
    {
      "code" : "A0136501G0",
      "display" : "INAVITA TABLETS \"WINSTON\""
    },
    {
      "code" : "A013651229",
      "display" : "FELINAMIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013651238",
      "display" : "FELINAMIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013661100",
      "display" : "SHAPTON CAPSULES \"CSP\""
    },
    {
      "code" : "A013662100",
      "display" : "METRONIDAZOLE CAPSULES \"C.H.\""
    },
    {
      "code" : "A013663100",
      "display" : "SWEETS TABLETS \"C.R.\""
    },
    {
      "code" : "A013664100",
      "display" : "METRONIDAZOLE CAPSULES 250MG \"SHINLON\""
    },
    {
      "code" : "A0136641G0",
      "display" : "METRONIDAZOLE CAPSULES 250MG \"SHINLON\""
    },
    {
      "code" : "A013666100",
      "display" : "Relax Analgesic Tablets 500mg"
    },
    {
      "code" : "A013676100",
      "display" : "RIFAMPICIN CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A013677100",
      "display" : "BETAMETHASONE TABLETS \"C.M.\""
    },
    {
      "code" : "A013679229",
      "display" : "LINCOMYCIN INJECTION \"SWISS\""
    },
    {
      "code" : "A013699277",
      "display" : "GLUVITOSE INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A013709100",
      "display" : "VIBRAMYCIN FILM COATED TABLETS 100MG"
    },
    {
      "code" : "A013710100",
      "display" : "NALIDIXIC ACID TABLETS \"C.I.\""
    },
    {
      "code" : "A013711100",
      "display" : "CHLORAMPHENICOL CAPSULES 250MG \"C.I.\""
    },
    {
      "code" : "A013712100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"C.I.\""
    },
    {
      "code" : "A013713100",
      "display" : "AMPICILLIN CAPSULES 250MG \"C.I.\""
    },
    {
      "code" : "A013714100",
      "display" : "ERGOMETRINE MALEATE S.C. TABLETS \"C.I.\""
    },
    {
      "code" : "A013718209",
      "display" : "5％/0.45％ DEXTROSE AND SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A013718277",
      "display" : "5％/0.45％ DEXTROSE AND SODIUM CHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A013719100",
      "display" : "LIBUSE S.C. TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A013720100",
      "display" : "MEFENAMIC ACID CAPSULES \"JEN SHENG\""
    },
    {
      "code" : "A013722500",
      "display" : "Metrocide Vaginal Suppositories 250mg \"T.F.\""
    },
    {
      "code" : "A013723100",
      "display" : "CHLORZOXAZONE TABLETS \"EAYUNG\""
    },
    {
      "code" : "A013727100",
      "display" : "TETRACYCLINE HCL CAPSULES 250MG \"C.I.\""
    },
    {
      "code" : "A013728100",
      "display" : "PREDNISOLONE TABLETS \"C.I.\""
    },
    {
      "code" : "A013741100",
      "display" : "GLYCERYL GUAIACOLATE TABLETS \"N.T.\""
    },
    {
      "code" : "A013742100",
      "display" : "CHLORDIAZEPOXIDE S.C. TABLETS"
    },
    {
      "code" : "A013743100",
      "display" : "PYRITHIOXIN S.C. TABLETS"
    },
    {
      "code" : "A013744100",
      "display" : "CONJUGATED ESTROGEN S.C. TABLETS\"N.C.P\""
    },
    {
      "code" : "A013746100",
      "display" : "THIORIDAZINE S.C. TABLETS"
    },
    {
      "code" : "A013747100",
      "display" : "ANETHOLE S.C. TABLETS \"KODAK\""
    },
    {
      "code" : "A013748100",
      "display" : "AMILIN S.C. TABLETS\"N.C.P\""
    },
    {
      "code" : "A013750100",
      "display" : "CLIOXIDE S.C. TABLETS"
    },
    {
      "code" : "A013751100",
      "display" : "VALETONE S.C. TABLETS\"N.C.P\""
    },
    {
      "code" : "A013752100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"KODAK\""
    },
    {
      "code" : "A013753100",
      "display" : "BENZYDAMINE S.C. TABLETS"
    },
    {
      "code" : "A013761100",
      "display" : "TINIDAZOLE TABLETS \"HONTEN\""
    },
    {
      "code" : "A013764100",
      "display" : "IBUPROFEN S.C. TABLETS \"KODAK\""
    },
    {
      "code" : "A013766100",
      "display" : "METO S.C. TABLETS\"N.C.P\""
    },
    {
      "code" : "A013767100",
      "display" : "CHLOPERASTINE S.C. TABLETS \"KODAK\""
    },
    {
      "code" : "A013771229",
      "display" : "GENTAMICIN INJECTION 1％ \"Y.Y.\""
    },
    {
      "code" : "A013777100",
      "display" : "SO-MEN CAPSULES \"M.T.\""
    },
    {
      "code" : "A013778100",
      "display" : "NO-COUGH CAPSULES \"M.T.\""
    },
    {
      "code" : "A0137781G0",
      "display" : "NO-COUGH CAPSULES \"M.T.\""
    },
    {
      "code" : "A013796100",
      "display" : "BETAMETHASONE TABLETS \"SHINLON\""
    },
    {
      "code" : "A013799100",
      "display" : "MEFENAMIC ACID CAPSULES \"METRO\""
    },
    {
      "code" : "A013800100",
      "display" : "WILCON U TABLETS \"C.Y.\""
    },
    {
      "code" : "A013801100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"STANDARD\""
    },
    {
      "code" : "A0138011G0",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"STANDARD\""
    },
    {
      "code" : "A013803100",
      "display" : "TRICOTON TABLETS \"G.A.P.\""
    },
    {
      "code" : "A013817265",
      "display" : "AMINOPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A013817266",
      "display" : "AMINOPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A013817277",
      "display" : "AMINOPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A013876100",
      "display" : "IBUPROFEN CAPSULES \"S.T.\""
    },
    {
      "code" : "A013879100",
      "display" : "ZHI FU MAO CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A013900100",
      "display" : "NALIDIXIC ACID TABLETS"
    },
    {
      "code" : "A013906238",
      "display" : "VITAGEN-SF INJECTION"
    },
    {
      "code" : "A013907238",
      "display" : "VITAGEN-S INJECTION"
    },
    {
      "code" : "A013912209",
      "display" : "DEXAMETHASONE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A013912229",
      "display" : "DEXAMETHASONE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A013914100",
      "display" : "CETYL TABLETS \"S.C.\""
    },
    {
      "code" : "A0139141G0",
      "display" : "CETYL TABLETS \"S.C.\""
    },
    {
      "code" : "A013920277",
      "display" : "CEFAZOLIN INJECTION \"H.S.C.\""
    },
    {
      "code" : "A013929238",
      "display" : "DEXTROSE-LACTATED RINGER'S INJECTION \"TAI YU\""
    },
    {
      "code" : "A013929265",
      "display" : "DEXTROSE-LACTATED RINGER'S INJECTION \"TAI YU\""
    },
    {
      "code" : "A013929277",
      "display" : "DEXTROSE-LACTATED RINGER'S INJECTION \"TAI YU\""
    },
    {
      "code" : "A013955100",
      "display" : "ORCIPRENALINE TABLETS \"S.Y.\""
    },
    {
      "code" : "A013961100",
      "display" : "SINOTRIM TABLETS"
    },
    {
      "code" : "A013962100",
      "display" : "FRUSEMIDE TABLETS \"TA\""
    },
    {
      "code" : "A013964238",
      "display" : "XYLITOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A013964277",
      "display" : "XYLITOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A013969100",
      "display" : "DEXTROMETHORPHAN TABLETS \"Y.C.\""
    },
    {
      "code" : "A013973100",
      "display" : "RESCOL CAPSULES \"C.R.\""
    },
    {
      "code" : "A013979100",
      "display" : "Pyridoxine HCL Tablets 50MG \"Chen Ta\""
    },
    {
      "code" : "A013980238",
      "display" : "DEXTROSE INJECTION 20％ \"TAI YU\""
    },
    {
      "code" : "A013980277",
      "display" : "DEXTROSE INJECTION 20％ \"TAI YU\""
    },
    {
      "code" : "A013981209",
      "display" : "ESTRADIOL BENZOATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013983212",
      "display" : "PYRABITAL INJECTION \"TAI YU\""
    },
    {
      "code" : "A013984209",
      "display" : "KANAMYCIN SULFATE INJECTION 1GM \"TAI YU\""
    },
    {
      "code" : "A013985209",
      "display" : "TESTOSTERONE CYPIONATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A013990100",
      "display" : "CHUWEIYU GRANULES \"J.H.\""
    },
    {
      "code" : "A013997100",
      "display" : "MINOCIN G CAPSULES 250MG"
    },
    {
      "code" : "A014014100",
      "display" : "DIISOPROPYLAMINE S.C. TABLETS"
    },
    {
      "code" : "A014015100",
      "display" : "SPIRONOLACTONE TABLETS 25 MG \"C. L.\""
    },
    {
      "code" : "A014020177",
      "display" : "THREE-CON LIQUID"
    },
    {
      "code" : "A014024429",
      "display" : "CORTIGEN EYE-DROPS"
    },
    {
      "code" : "A014024438",
      "display" : "CORTIGEN EYE-DROPS"
    },
    {
      "code" : "A014025100",
      "display" : "KENTAMIN CAPSULES"
    },
    {
      "code" : "A014027100",
      "display" : "RIFAZID CAPSULES \"CHIU PO\""
    },
    {
      "code" : "A014030212",
      "display" : "METOCLOPRAMIDE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014040100",
      "display" : "CEPHALEXIN CAPSULES \"C.I.\""
    },
    {
      "code" : "A014044100",
      "display" : "PIPRINHYDRINATE S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A014079100",
      "display" : "CLONIDINE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A014081109",
      "display" : "CEPHANMYCIN GRANULES \"YUNG SHIN\""
    },
    {
      "code" : "A014088100",
      "display" : "MITOYU TABLETS \"H.S.\""
    },
    {
      "code" : "A014092209",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION \"Y.A.\""
    },
    {
      "code" : "A014093238",
      "display" : "GISALCON INJECTION \"Y.Y.\""
    },
    {
      "code" : "A014102100",
      "display" : "AMOXICILLIN CAPSULES \"C.I.\""
    },
    {
      "code" : "A014108100",
      "display" : "SPAGASTROL TABLETS"
    },
    {
      "code" : "A014111100",
      "display" : "PHLOROPROPIOPHENONE CAPSULES \"S.T.\""
    },
    {
      "code" : "A014118316",
      "display" : "FUMEI OINTMENT \"IDEAL\""
    },
    {
      "code" : "A014118321",
      "display" : "FUMEI OINTMENT \"IDEAL\""
    },
    {
      "code" : "A014118335",
      "display" : "FUMEI OINTMENT \"IDEAL\""
    },
    {
      "code" : "A014118399",
      "display" : "FUMEI OINTMENT \"IDEAL\""
    },
    {
      "code" : "A014121100",
      "display" : "BROMHEXINE TABLETS \"ASTAR\""
    },
    {
      "code" : "A014148212",
      "display" : "HYDROXOCOBALAMIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A014148229",
      "display" : "HYDROXOCOBALAMIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A014148299",
      "display" : "HYDROXOCOBALAMIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A014152212",
      "display" : "Lincomycin Injection \"K.S.\""
    },
    {
      "code" : "A014152229",
      "display" : "Lincomycin Injection \"K.S.\""
    },
    {
      "code" : "A014154100",
      "display" : "ALLOPURINOL TABLETS \"STANDARD\""
    },
    {
      "code" : "A0141541G0",
      "display" : "ALLOPURINOL TABLETS \"STANDARD\""
    },
    {
      "code" : "A014160100",
      "display" : "TRIDEAL TABLETS \"IDEAL\""
    },
    {
      "code" : "A014164100",
      "display" : "PROPRANOLOL TABLETS"
    },
    {
      "code" : "A014170100",
      "display" : "DEXAMETHASONE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A014171100",
      "display" : "CEPHALEXIN CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A014174118",
      "display" : "MIAWELCON SYRUP \"H.H.P.\""
    },
    {
      "code" : "A014174151",
      "display" : "MIAWELCON SYRUP \"H.H.P.\""
    },
    {
      "code" : "A014183100",
      "display" : "DEXAMETHASONE TABLETS \"WINSTON\""
    },
    {
      "code" : "A014184100",
      "display" : "PREDNISOLONE TABLETS \"WINSTON\""
    },
    {
      "code" : "A0141841G0",
      "display" : "PREDNISOLONE TABLETS \"WINSTON\""
    },
    {
      "code" : "A014185100",
      "display" : "DEXTROMETHORPHAN TABLETS \"WINSTON\""
    },
    {
      "code" : "A014187100",
      "display" : "FUROSEMIDE TABLETS \"WINSTON\""
    },
    {
      "code" : "A014190238",
      "display" : "SUAMIN INJECTION \"S.Y.\""
    },
    {
      "code" : "A014190277",
      "display" : "SUAMIN INJECTION \"S.Y.\""
    },
    {
      "code" : "A014194100",
      "display" : "DIAZEPAM TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A014195100",
      "display" : "D.A.A. TABLETS \"F.Y.\""
    },
    {
      "code" : "A014205238",
      "display" : "SURPLEX INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A014205277",
      "display" : "SURPLEX INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A014220100",
      "display" : "ANTICOLD CAPSULES \"C.S.\""
    },
    {
      "code" : "A014222100",
      "display" : "GACID TABLETS \"H.S.\""
    },
    {
      "code" : "A014224212",
      "display" : "VITAMIN B12 INJECTION \"LITA\""
    },
    {
      "code" : "A014224229",
      "display" : "VITAMIN B12 INJECTION \"LITA\""
    },
    {
      "code" : "A014227100",
      "display" : "BETAMETHASONE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A014228100",
      "display" : "ALLOPURINOL TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A0142281G0",
      "display" : "ALLOPURINOL TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A014230100",
      "display" : "OXESILIN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A014233100",
      "display" : "RIFAMPICIN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A014235100",
      "display" : "GUAPYNG TABLETS"
    },
    {
      "code" : "A014238363",
      "display" : "ZINC OXIDE OINTMENT \"WST\""
    },
    {
      "code" : "A014238399",
      "display" : "ZINC OXIDE OINTMENT \"WST\""
    },
    {
      "code" : "A0142383AN",
      "display" : "ZINC OXIDE OINTMENT \"WST\""
    },
    {
      "code" : "A014241212",
      "display" : "DIPROPHYLLIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A014256100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"S.T.\""
    },
    {
      "code" : "A014258100",
      "display" : "KAIZOLE TABLETS (MEBENDAZOLE)"
    },
    {
      "code" : "A014263100",
      "display" : "TONCA TABLETS \"H.C.T.\""
    },
    {
      "code" : "A014272100",
      "display" : "PANTOSHENG S.C. TABLETS"
    },
    {
      "code" : "A014273100",
      "display" : "VITAMIN E S.C. TABLETS 50MG \"JOHNSON\""
    },
    {
      "code" : "A014274100",
      "display" : "ERYTHROMYCIN CAPSULES \"Union\""
    },
    {
      "code" : "A0142741G0",
      "display" : "ERYTHROMYCIN CAPSULES \"Union\""
    },
    {
      "code" : "A014277100",
      "display" : "SAUSCON TABLETS"
    },
    {
      "code" : "A014283100",
      "display" : "CINNARIZINE TABLETS \"KODAK\""
    },
    {
      "code" : "A014287100",
      "display" : "TRIAMCINOLONE TABLETS \"S.D.\""
    },
    {
      "code" : "A014288100",
      "display" : "HYDRALAZINE TABLETS \"WST\""
    },
    {
      "code" : "A014304212",
      "display" : "ANTICOUGH INJECTION \"PATRON\""
    },
    {
      "code" : "A014307100",
      "display" : "BIOVITA TABLETS \"Y.S.\""
    },
    {
      "code" : "A014313100",
      "display" : "RESERPINE TABLETS \"J.C.S.\""
    },
    {
      "code" : "A014315238",
      "display" : "SULYCEL INJECTION \"TAI YU\""
    },
    {
      "code" : "A014317209",
      "display" : "SPARMETRINE INJECTION \"PATRON\""
    },
    {
      "code" : "A014318212",
      "display" : "PATOMIN INJECTION \"PATRON\""
    },
    {
      "code" : "A014319100",
      "display" : "DEHYDROCHOLIC ACID TABLETS \"PATRON\""
    },
    {
      "code" : "A014320435",
      "display" : "SILETONG NASAL DROPS \"PATRON\""
    },
    {
      "code" : "A014321421",
      "display" : "PAMESONE OPHTHALMIC SOLUTION \"PATRON\""
    },
    {
      "code" : "A014324100",
      "display" : "LOGEN CAPSULES 500MG \"YUNG CHI\""
    },
    {
      "code" : "A014325209",
      "display" : "DEXAMETHASONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014325229",
      "display" : "DEXAMETHASONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014328100",
      "display" : "SMOOTH TABLETS 30MG"
    },
    {
      "code" : "A014331100",
      "display" : "FLAMBACK TABLETS"
    },
    {
      "code" : "A014332100",
      "display" : "KOTOWI TABLETS 2.5MG\"N.C.P\""
    },
    {
      "code" : "A014340100",
      "display" : "CLEMASTINE TABLETS \"PRINCE\""
    },
    {
      "code" : "A014341100",
      "display" : "IBUPROFEN TABLETS \"GENMONT\""
    },
    {
      "code" : "A014343100",
      "display" : "COBAMAMIDE CAPSULES \"HONTEN\""
    },
    {
      "code" : "A014346100",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS \"SHINLON\""
    },
    {
      "code" : "A014348100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE F.C. TABLETS \"L.L.\""
    },
    {
      "code" : "A014349212",
      "display" : "GENTAMICIN INJECTION 10MG/ML \"Y.F.\""
    },
    {
      "code" : "A014349219",
      "display" : "GENTAMICIN INJECTION 10MG/ML \"Y.F.\""
    },
    {
      "code" : "A014349229",
      "display" : "GENTAMICIN INJECTION 10MG/ML \"Y.F.\""
    },
    {
      "code" : "A014350212",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.F.\""
    },
    {
      "code" : "A014350219",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.F.\""
    },
    {
      "code" : "A014350229",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.F.\""
    },
    {
      "code" : "A014350238",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.F.\""
    },
    {
      "code" : "A014350299",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.F.\""
    },
    {
      "code" : "A014354277",
      "display" : "XYLITOL INJECTION 5％ \"TAI YU\""
    },
    {
      "code" : "A014355209",
      "display" : "ATROPINE SULFATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014356209",
      "display" : "TESTOSTERONE PROPIONATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014357238",
      "display" : "PYRICOBAMIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A014359209",
      "display" : "ESTRADIOL CYPIONATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014360212",
      "display" : "SKIMITIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A014360221",
      "display" : "SKIMITIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A014360238",
      "display" : "SKIMITIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A014361209",
      "display" : "NEOSTIGMINE METHYLSULFATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014362209",
      "display" : "SPARTEINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014363209",
      "display" : "ERGONOVINE MALEATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014364238",
      "display" : "WATER FOR INJECTION \"TAI YU\""
    },
    {
      "code" : "A014367199",
      "display" : "VITAMIN B COMPLEX SYRUP"
    },
    {
      "code" : "A014395100",
      "display" : "DEXAMETHASONE TABLETS \"C.I.\""
    },
    {
      "code" : "A014413100",
      "display" : "GINCOSON TABLETS \"KODAK\""
    },
    {
      "code" : "A014416118",
      "display" : "METOCLOPRAMIDE SYRUP 100MG"
    },
    {
      "code" : "A014416199",
      "display" : "METOCLOPRAMIDE SYRUP 100MG"
    },
    {
      "code" : "A014417100",
      "display" : "HEDICAN TABLETS \"KODAK\""
    },
    {
      "code" : "A014418100",
      "display" : "KOWELL-U TABLETS\"N.C.P\""
    },
    {
      "code" : "A014419100",
      "display" : "KOSULAN CAPSULES \"KODAK\""
    },
    {
      "code" : "A014420100",
      "display" : "MEDAZEPAM TABLETS 5MG"
    },
    {
      "code" : "A014421100",
      "display" : "VITAMIN E CAPSULES 100MG"
    },
    {
      "code" : "A014425100",
      "display" : "MEFENAMIC ACID CAPSULES \"KODAK\""
    },
    {
      "code" : "A014426100",
      "display" : "MEGOVIN TABLETS 0.2MG"
    },
    {
      "code" : "A014427100",
      "display" : "MOLAW CAPSULES 250MG\"N.C.P\""
    },
    {
      "code" : "A014435377",
      "display" : "VENAPAS-A OINTMENT"
    },
    {
      "code" : "A014435399",
      "display" : "VENAPAS-A OINTMENT"
    },
    {
      "code" : "A014439100",
      "display" : "ANIGI-COLD TABLETS"
    },
    {
      "code" : "A014441221",
      "display" : "BLONDA INJECTION 5％ (TRANEXAMIC ACID) \"C.C.P."
    },
    {
      "code" : "A014442212",
      "display" : "SULPYRINE INJECTION 25％ \"TAI YU\""
    },
    {
      "code" : "A014447100",
      "display" : "BROMELAIN ENTERIC S.C. TABLETS \"H.C.T.\""
    },
    {
      "code" : "A014449100",
      "display" : "COUGH CAPSULES \"PATRON\""
    },
    {
      "code" : "A014452100",
      "display" : "CODEVERINE TABLETS \"PATRON\""
    },
    {
      "code" : "A014453119",
      "display" : "COTONPIN SYRUP \"PATRON\""
    },
    {
      "code" : "A014453199",
      "display" : "COTONPIN SYRUP \"PATRON\""
    },
    {
      "code" : "A014456238",
      "display" : "AMINO COMPOSITE INJECTION \"TAI YU\""
    },
    {
      "code" : "A014459100",
      "display" : "BUCLIZINE TABLETS 25MG \"C.L.\""
    },
    {
      "code" : "A014461100",
      "display" : "AIPATRON S.C. TABLETS \"PATRON\""
    },
    {
      "code" : "A014462212",
      "display" : "ANTICOLD INJECTION \"PATRON\""
    },
    {
      "code" : "A014463100",
      "display" : "CLORPRENALINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A014470229",
      "display" : "GENTAMICIN INJECTION \"METRO\""
    },
    {
      "code" : "A014472100",
      "display" : "SUTONWERIN \"DOUCHI\""
    },
    {
      "code" : "A014552238",
      "display" : "SORBIT-SALINE INJECTION"
    },
    {
      "code" : "A014552265",
      "display" : "SORBIT-SALINE INJECTION"
    },
    {
      "code" : "A014552277",
      "display" : "SORBIT-SALINE INJECTION"
    },
    {
      "code" : "A014555100",
      "display" : "GLIBENCLAMIDE TABLETS \"KINGDOM\""
    },
    {
      "code" : "A014578209",
      "display" : "DIAZEPAM INJECTION \"T.S.\""
    },
    {
      "code" : "A014580100",
      "display" : "ETHYLPAPAVERINE HCL TABLETS \"Y.S.\""
    },
    {
      "code" : "A014594100",
      "display" : "TEDOFURYL CAPSULES \"N.W.\""
    },
    {
      "code" : "A014596500",
      "display" : "NYSTATIN VAGINAL TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A014601399",
      "display" : "NITROFURAZONE OINTMENT \"GENTLE\""
    },
    {
      "code" : "A0146013CH",
      "display" : "NITROFURAZONE OINTMENT \"GENTLE\""
    },
    {
      "code" : "A014604100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE TABLETS \"C.S.\""
    },
    {
      "code" : "A014607100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"PRINCE\""
    },
    {
      "code" : "A014614212",
      "display" : "GENTAMYCIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A014614229",
      "display" : "GENTAMYCIN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A014620435",
      "display" : "OXYMETAZOLINE Nasal Spray"
    },
    {
      "code" : "A014622212",
      "display" : "FUTIGEN-H INJECTION \"S.Y.\""
    },
    {
      "code" : "A014622221",
      "display" : "FUTIGEN-H INJECTION \"S.Y.\""
    },
    {
      "code" : "A014622238",
      "display" : "FUTIGEN-H INJECTION \"S.Y.\""
    },
    {
      "code" : "A014623100",
      "display" : "ANETHOLE CAPSULES \"Y.C.\""
    },
    {
      "code" : "A014624100",
      "display" : "BUPROFEN CAPSULES 400MG \"LITA\""
    },
    {
      "code" : "A014628100",
      "display" : "CEPHALEXIN CAPSULES \"IDEAL\""
    },
    {
      "code" : "A014638100",
      "display" : "DIMETHICONE TABLETS \"ASTAR\""
    },
    {
      "code" : "A014641100",
      "display" : "REDREL TSBLETS"
    },
    {
      "code" : "A014642100",
      "display" : "NITROZEPAM TABLETS"
    },
    {
      "code" : "A014658309",
      "display" : "GENTACIN CREAM"
    },
    {
      "code" : "A014658372",
      "display" : "GENTACIN CREAM"
    },
    {
      "code" : "A014658399",
      "display" : "GENTACIN CREAM"
    },
    {
      "code" : "A014664229",
      "display" : "DEXAMETHASONE INJECTION \"WINSTON\""
    },
    {
      "code" : "A014665100",
      "display" : "CHLORDIAZEPOXIDE CAPSULES \"PFOSHEN\""
    },
    {
      "code" : "A014684100",
      "display" : "PANACID TABLETS 500MG"
    },
    {
      "code" : "A014686100",
      "display" : "DECANON TABLETS 500 MCG \"CHI SHENG\""
    },
    {
      "code" : "A014692100",
      "display" : "DEXAMETHASONE TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A014697100",
      "display" : "TRIAMCINOLONE TABLETS \"PATRON\""
    },
    {
      "code" : "A014700277",
      "display" : "XYLITOL INJECTION 5％ \"ASTAR\""
    },
    {
      "code" : "A014704100",
      "display" : "METOCLOPRAMIDE S.C. TABLETS \"C.I.\""
    },
    {
      "code" : "A014722123",
      "display" : "SAULONLU SOLUTION \"Y.Y.\""
    },
    {
      "code" : "A014722199",
      "display" : "SAULONLU SOLUTION \"Y.Y.\""
    },
    {
      "code" : "A014733100",
      "display" : "PUSKO S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A014735100",
      "display" : "BLONDA(TRANEXAMIC ACID) CAPSULES 250MG \"C.C.P"
    },
    {
      "code" : "A014737212",
      "display" : "Phenamin-H Injection \"Union\""
    },
    {
      "code" : "A014746100",
      "display" : "SCOPOLAMINE BUTYLBROMIDE CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A014749100",
      "display" : "ACETAMINOPHEN TABLETS \"JINUP\""
    },
    {
      "code" : "A014750229",
      "display" : "LINCOMYCIN INJECTION 300MG/ML \"CSP\""
    },
    {
      "code" : "A014755100",
      "display" : "DIKUTON TABLETS"
    },
    {
      "code" : "A014756209",
      "display" : "PENICILLIN G SODIUM INJECTION  \"Y.F.\""
    },
    {
      "code" : "A014756216",
      "display" : "PENICILLIN G SODIUM INJECTION  \"Y.F.\""
    },
    {
      "code" : "A014756229",
      "display" : "PENICILLIN G SODIUM INJECTION  \"Y.F.\""
    },
    {
      "code" : "A014759209",
      "display" : "B-COMPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A014759229",
      "display" : "B-COMPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A014763209",
      "display" : "SACOCILLIN INJECTION 1GM \"N.K.\""
    },
    {
      "code" : "A014766100",
      "display" : "METRONIDAZOLE TABLETS \"T.A.\""
    },
    {
      "code" : "A014767277",
      "display" : "SACOCILLIN INJECTION 500MG \"N.K.\""
    },
    {
      "code" : "A014769100",
      "display" : "MEBENDAZOLE TABLETS \"Y.C.\""
    },
    {
      "code" : "A014779100",
      "display" : "BAENTA S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A014783100",
      "display" : "MEFENAMIC ACID CAPSULES \"WST\""
    },
    {
      "code" : "A014791100",
      "display" : "IBUPROFEN CAPSULES"
    },
    {
      "code" : "A014792100",
      "display" : "HI-CAVITAMIN S.C. TABLETS \"S.C.\""
    },
    {
      "code" : "A014796100",
      "display" : "CHLORMEZANONE"
    },
    {
      "code" : "A014799100",
      "display" : "SULFALIN TABLETS \"J.C.S.\""
    },
    {
      "code" : "A014801100",
      "display" : "TA DAR RING CAPSULES \"J.C.S.\""
    },
    {
      "code" : "A014809100",
      "display" : "BETHANECOL CHLORIDE \"J.C.S.\""
    },
    {
      "code" : "A014813100",
      "display" : "SAKERENN CAPSULES \"J.C.S.\""
    },
    {
      "code" : "A014823100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"CHI SHENG\""
    },
    {
      "code" : "A014832109",
      "display" : "EPILON POWDER \"YUNG SHIN\""
    },
    {
      "code" : "A014832199",
      "display" : "EPILON POWDER \"YUNG SHIN\""
    },
    {
      "code" : "A014833100",
      "display" : "CHOLAR S.C. TABLETS 25MG \"YUNG SHIN\""
    },
    {
      "code" : "A014842100",
      "display" : "DEXTROMETHORPHAN TABLETS 30MG \"LITA\""
    },
    {
      "code" : "A014845100",
      "display" : "FULUCON TABLETS \"S.T.\""
    },
    {
      "code" : "A014858321",
      "display" : "DERMACOMB CREAM \"W.F.\""
    },
    {
      "code" : "A014858372",
      "display" : "DERMACOMB CREAM \"W.F.\""
    },
    {
      "code" : "A014858399",
      "display" : "DERMACOMB CREAM \"W.F.\""
    },
    {
      "code" : "A014864100",
      "display" : "DEMETHOR TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A014865100",
      "display" : "KAIGEN IB TABLETS"
    },
    {
      "code" : "A014873100",
      "display" : "IBUPROFEN S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A014880100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE TABLETS \"S.Y.\""
    },
    {
      "code" : "A014892100",
      "display" : "ETHAMBUTOL TABLETS 400MG \"N.W.\""
    },
    {
      "code" : "A014894212",
      "display" : "GENTAMICIN INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014894229",
      "display" : "GENTAMICIN INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014894238",
      "display" : "GENTAMICIN INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014894299",
      "display" : "GENTAMICIN INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014898100",
      "display" : "VITAMIN E CAPSULES 100MG \"KINGDOM\""
    },
    {
      "code" : "A014900229",
      "display" : "LINCOMYCIN INJECTION \"PRINCE\""
    },
    {
      "code" : "A014900238",
      "display" : "LINCOMYCIN INJECTION \"PRINCE\""
    },
    {
      "code" : "A014901229",
      "display" : "LINCOMYCIN INJECTION \"PATRON\""
    },
    {
      "code" : "A014907100",
      "display" : "INDOMETHACIN CAPSULES \"WST\""
    },
    {
      "code" : "A014909100",
      "display" : "MEFENAMIC ACID CAPSULES 250MG\"D.T.S\""
    },
    {
      "code" : "A014912100",
      "display" : "NALIDIXIC ACID TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A014914209",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014914212",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014914221",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014914229",
      "display" : "TRIAMCINOLONE SUSPENDED INJECTION 4％ \"TAI YU\""
    },
    {
      "code" : "A014915321",
      "display" : "FLUCORTONE OINTMENT \"TAI YU\""
    },
    {
      "code" : "A014915329",
      "display" : "FLUCORTONE OINTMENT \"TAI YU\""
    },
    {
      "code" : "A014915373",
      "display" : "FLUCORTONE OINTMENT \"TAI YU\""
    },
    {
      "code" : "A014915399",
      "display" : "FLUCORTONE OINTMENT \"TAI YU\""
    },
    {
      "code" : "A014917100",
      "display" : "FERACON F.C. TABLETS"
    },
    {
      "code" : "A014919100",
      "display" : "EDENE SUGAR COATED TABLETS"
    },
    {
      "code" : "A014920100",
      "display" : "KANCAN CAPSULES"
    },
    {
      "code" : "A014922100",
      "display" : "NOSOUTIN TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A014924100",
      "display" : "JAWEIHSIC TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A014925100",
      "display" : "ANETHOLE CAPSULES \"LITA\""
    },
    {
      "code" : "A014926212",
      "display" : "BROMHEXINE INJECTION \"S.Y.\""
    },
    {
      "code" : "A014928100",
      "display" : "RIBOFLAVIN TABLETS 10MG \"C.I.\""
    },
    {
      "code" : "A014929100",
      "display" : "BETAMETHASONE TABLETS \"C.I.\""
    },
    {
      "code" : "A014930100",
      "display" : "CHLORZOXAZONE TABLETS \"WINSTON\""
    },
    {
      "code" : "A014932100",
      "display" : "AMOXICILLIN CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A014941100",
      "display" : "IBUPROFEN CAPSULES"
    },
    {
      "code" : "A014967100",
      "display" : "FRISIUM TABLETS (CLOBAZAM)"
    },
    {
      "code" : "A014975100",
      "display" : "CINNARIZINE TABLETS \"H.S.\""
    },
    {
      "code" : "A014981209",
      "display" : "CLONIDINE INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A015011100",
      "display" : "EDITIN TABLETS"
    },
    {
      "code" : "A015021100",
      "display" : "GUAIAZULENE SODIUM SULFONATE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A015024100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE TABLETS \"P.L."
    },
    {
      "code" : "A015026100",
      "display" : "LILOCOL CAPSULES \"TK&A\""
    },
    {
      "code" : "A015028100",
      "display" : "SALBUTAMOL TABLETS \"P.L.\""
    },
    {
      "code" : "A015029212",
      "display" : "Carlmycin Injection 250mg/ml"
    },
    {
      "code" : "A015029229",
      "display" : "Carlmycin Injection 250mg/ml"
    },
    {
      "code" : "A015029238",
      "display" : "Carlmycin Injection 250mg/ml"
    },
    {
      "code" : "A015030100",
      "display" : "ZUNTON TABLETS \"C.S.\""
    },
    {
      "code" : "A015033100",
      "display" : "PSEUDOEPHEDRINE TABLETS \"CURIE\""
    },
    {
      "code" : "A0150331G0",
      "display" : "PSEUDOEPHEDRINE TABLETS \"CURIE\"(鋁箔/膠箔)"
    },
    {
      "code" : "A015034100",
      "display" : "ACETAMINOPHEN TABLETS \"C.R.\""
    },
    {
      "code" : "A015035100",
      "display" : "EASY CAPSULES"
    },
    {
      "code" : "A015040100",
      "display" : "ASTOBORINE S.C. TABLETS"
    },
    {
      "code" : "A015041100",
      "display" : "KETOFEN CAPSULES \"H.H.\""
    },
    {
      "code" : "A0150411G0",
      "display" : "KETOFEN CAPSULES \"H.H.\""
    },
    {
      "code" : "A015042100",
      "display" : "JINCIN TABLETS 10MG\"N.C.P\""
    },
    {
      "code" : "A015056238",
      "display" : "DEXTROSE INJECTION 50％ \"TAI YU\""
    },
    {
      "code" : "A015057118",
      "display" : "ANTIPHEN SYRUP (ACETAMINOPHEN 24MG/ML)"
    },
    {
      "code" : "A015057151",
      "display" : "ANTIPHEN SYRUP (ACETAMINOPHEN 24MG/ML)"
    },
    {
      "code" : "A015057199",
      "display" : "ANTIPHEN SYRUP (ACETAMINOPHEN 24MG/ML)"
    },
    {
      "code" : "A015063100",
      "display" : "\"ZGLHY\" LIFUMIN TABLET"
    },
    {
      "code" : "A015065100",
      "display" : "LITONBA TABLETS \"Y.S.\""
    },
    {
      "code" : "A015075100",
      "display" : "ACETAMINOPHEN TABLETS"
    },
    {
      "code" : "A015078100",
      "display" : "DIPHENIDOL S.C. TABLETS"
    },
    {
      "code" : "A0150781G0",
      "display" : "DIPHENIDOL S.C. TABLETS"
    },
    {
      "code" : "A015080329",
      "display" : "Y.T.II Ointment \"Tai Yu\""
    },
    {
      "code" : "A015085100",
      "display" : "COLD CAPSULES \"HONTEN\""
    },
    {
      "code" : "A015088100",
      "display" : "RIFAMPISIN CAPSULES"
    },
    {
      "code" : "A015090100",
      "display" : "PSEUDOEPHEDRINE HCL TABLETS \"HONTEN\""
    },
    {
      "code" : "A0150901G0",
      "display" : "PSEUDOEPHEDRINE HCL TABLETS \"HONTEN\""
    },
    {
      "code" : "A015091100",
      "display" : "KETOPROFEN CAPSULES 50MG \"F.Y.\""
    },
    {
      "code" : "A015100100",
      "display" : "RIF CAPSULES 450MG"
    },
    {
      "code" : "A015118100",
      "display" : "RIFAMPIN CAPSULES 150MG \"WINSTON\""
    },
    {
      "code" : "A015153212",
      "display" : "BIOSTIN INJECTION"
    },
    {
      "code" : "A015177100",
      "display" : "PYRIDOXAL PHOSPHATE TABLETS"
    },
    {
      "code" : "A015180212",
      "display" : "COLISTIN POWDER FOR INJECTION"
    },
    {
      "code" : "A015190100",
      "display" : "DIMETHICONE TABLETS \"S.Y.\""
    },
    {
      "code" : "A015195100",
      "display" : "NARCARICIN CAPSULES (BENZBROMARONE)"
    },
    {
      "code" : "A015199100",
      "display" : "PYRININ TABLETS \"GENTLE\""
    },
    {
      "code" : "A015201100",
      "display" : "ANKOCILLIN CAPSULES 500MG \"W.F.\""
    },
    {
      "code" : "A015204100",
      "display" : "LOPERAMIDE TABLETS \"N.Y.\""
    },
    {
      "code" : "A015206110",
      "display" : "WEOWE GRANULES \"M.S.\""
    },
    {
      "code" : "A015212100",
      "display" : "ETHYLPHENYLEPHRINE TABLETS \"Y.S.\""
    },
    {
      "code" : "A015217100",
      "display" : "TEDOFURYL CAPSULES \"S.T.\""
    },
    {
      "code" : "A015218238",
      "display" : "DEXTROSE INJECTION 5％ \"TAI YU\""
    },
    {
      "code" : "A015218255",
      "display" : "DEXTROSE INJECTION 5％ \"TAI YU\""
    },
    {
      "code" : "A015218265",
      "display" : "DEXTROSE INJECTION 5％ \"TAI YU\""
    },
    {
      "code" : "A015218277",
      "display" : "DEXTROSE INJECTION 5％ \"TAI YU\""
    },
    {
      "code" : "A015219500",
      "display" : "PEDIATRIC ASPIRIN SUPPOSITORIES \"Y.C.\""
    },
    {
      "code" : "A015227100",
      "display" : "COUGH CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A015235100",
      "display" : "SWAN B12 CAPSULES \"C.S.P.\""
    },
    {
      "code" : "A015242100",
      "display" : "STOMACHIC TABLETS \"PATRON\""
    },
    {
      "code" : "A015246265",
      "display" : "5％ DEXTROSE IN 0.33％ SALINE INJECTION \"SIN TONG\""
    },
    {
      "code" : "A015246277",
      "display" : "5％ DEXTROSE IN 0.33％ SALINE INJECTION \"SIN TONG\""
    },
    {
      "code" : "A015253209",
      "display" : "PYRIDOXINE HCL INJECTION 100MG/ML \"TAI YU\""
    },
    {
      "code" : "A015253229",
      "display" : "PYRIDOXINE HCL INJECTION 100MG/ML \"TAI YU\""
    },
    {
      "code" : "A015259100",
      "display" : "TRIAMCINOLONE TABLETS 4MG \"C.R.\""
    },
    {
      "code" : "A015265100",
      "display" : "CHLORPROMAZINE TABLETS \"Y.Y.\""
    },
    {
      "code" : "A015268100",
      "display" : "DEXAMETHASONE TABLETS \"S.Y.\""
    },
    {
      "code" : "A015269100",
      "display" : "Sinflex Capsules 500mg\"Taiten\""
    },
    {
      "code" : "A015277421",
      "display" : "PLATINUM EYE SOLUTION \"H.S.C.\""
    },
    {
      "code" : "A015277429",
      "display" : "PLATINUM EYE SOLUTION \"H.S.C.\""
    },
    {
      "code" : "A015278100",
      "display" : "TINIDAZOLE CAPSULES 500MG \"CURIE\""
    },
    {
      "code" : "A015279209",
      "display" : "DEXAMETHASONE INJECTION 4MG \"TAI YU\""
    },
    {
      "code" : "A015279229",
      "display" : "DEXAMETHASONE INJECTION 4MG \"TAI YU\""
    },
    {
      "code" : "A015284100",
      "display" : "DIAZEPAM TABLETS \"C.I.\""
    },
    {
      "code" : "A015285100",
      "display" : "AMPICILLIN CAPSULES 500MG \"C.I.\""
    },
    {
      "code" : "A015286100",
      "display" : "AMPICILLIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A015287100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"H.L.\""
    },
    {
      "code" : "A015290100",
      "display" : "DIAZEPAM TABLETS 5MG \"TA\""
    },
    {
      "code" : "A015291100",
      "display" : "CLEMASTINE TABLETS \"S.T.\""
    },
    {
      "code" : "A015316100",
      "display" : "CYCLOBUTYROL TABLETS \"J.C.S.\""
    },
    {
      "code" : "A015317100",
      "display" : "Kolotonin Tablets \"N.T.\""
    },
    {
      "code" : "A015318100",
      "display" : "UROGARONE CAPSULES \"CHIPHAR\""
    },
    {
      "code" : "A015331100",
      "display" : "HAUOWN CAPSULES"
    },
    {
      "code" : "A015342212",
      "display" : "CEPHALORIDINE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A015342277",
      "display" : "CEPHALORIDINE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A015343221",
      "display" : "HISTIDINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A015344100",
      "display" : "BROMHEXINE TABLETS 8MG \"F.Y.\""
    },
    {
      "code" : "A015345100",
      "display" : "TRIMESIN TABLETS"
    },
    {
      "code" : "A015346100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"F.Y.\""
    },
    {
      "code" : "A015349212",
      "display" : "COUFSTOP INJECTION \"Y.F.\""
    },
    {
      "code" : "A015354343",
      "display" : "SABINA CREAM"
    },
    {
      "code" : "A015359100",
      "display" : "ANETHOL TRITHIONE S.C. TABLETS \"SHINLON\""
    },
    {
      "code" : "A015367177",
      "display" : "PEDIALYTE ORAL ELECTROLYTE 500ML"
    },
    {
      "code" : "A015368100",
      "display" : "DIPHENIDOL SUGAR COATING TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A015373309",
      "display" : "PRETTY CREAM \"F.B\""
    },
    {
      "code" : "A015376100",
      "display" : "PORSUCON S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A015387100",
      "display" : "NAPOSIN TABLETS (NAPROXEN)250MG"
    },
    {
      "code" : "A0153871G0",
      "display" : "NAPOSIN TABLETS (NAPROXEN)250MG"
    },
    {
      "code" : "A015394100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE TABLETS \"LITA"
    },
    {
      "code" : "A015396100",
      "display" : "COCARBOXYLASE S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A015397100",
      "display" : "KALUFIBRATE CAPSULES \"C.S.\""
    },
    {
      "code" : "A015398100",
      "display" : "ASTOMIN S.C. TABLETS"
    },
    {
      "code" : "A015401100",
      "display" : "RIFAMPICIN CAPSULES \"SHINLON\""
    },
    {
      "code" : "A015402212",
      "display" : "LINCOMYCIN INJECTION \"C.Y.\""
    },
    {
      "code" : "A015402229",
      "display" : "LINCOMYCIN INJECTION \"C.Y.\""
    },
    {
      "code" : "A015405100",
      "display" : "RIFAMPICIN CAPSULES 450MG \"WINSTON\""
    },
    {
      "code" : "A015407229",
      "display" : "LINCOMYCIN INJECTION \"SINTONG\""
    },
    {
      "code" : "A015409100",
      "display" : "TAI CHI TABLETS"
    },
    {
      "code" : "A015415100",
      "display" : "CATIGEN TABLETS \"LONG DER\""
    },
    {
      "code" : "A015422100",
      "display" : "RELAZIDE S.C. TABLETS \"STANDARD\""
    },
    {
      "code" : "A0154221G0",
      "display" : "RELAZIDE S.C. TABLETS \"STANDARD\""
    },
    {
      "code" : "A015423109",
      "display" : "METOCLOPRAMIDE GRANULES \"CHINTENG\""
    },
    {
      "code" : "A015423199",
      "display" : "METOCLOPRAMIDE GRANULES \"CHINTENG\""
    },
    {
      "code" : "A015426100",
      "display" : "TONTHIN TABLETS \"CHEN TA\""
    },
    {
      "code" : "A015430238",
      "display" : "SPORMINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A015430265",
      "display" : "SPORMINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A015430266",
      "display" : "SPORMINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A015430277",
      "display" : "SPORMINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A015436100",
      "display" : "URSODEOXYCHOLIC ACID TABLETS \"Y.Y.\""
    },
    {
      "code" : "A015466212",
      "display" : "ALLOSULPYRA INJECTION"
    },
    {
      "code" : "A015467100",
      "display" : "DEXAMETHASONE TABLETS 4MG \"STANDARD\""
    },
    {
      "code" : "A015469100",
      "display" : "COLD SUGAR COATING TABLETS \"T.L.B\""
    },
    {
      "code" : "A015473229",
      "display" : "LINCOMYCIN HCL INJECTION 300MG \"TAI YU\""
    },
    {
      "code" : "A015473238",
      "display" : "LINCOMYCIN HCL INJECTION 300MG \"TAI YU\""
    },
    {
      "code" : "A015473299",
      "display" : "LINCOMYCIN HCL INJECTION 300MG \"TAI YU\""
    },
    {
      "code" : "A015509112",
      "display" : "JOSAMY DRY SYRUP"
    },
    {
      "code" : "A015509155",
      "display" : "JOSAMY DRY SYRUP"
    },
    {
      "code" : "A015509199",
      "display" : "JOSAMY DRY SYRUP"
    },
    {
      "code" : "A015511100",
      "display" : "PESINE S.C. TABLETS 25MG \"GOLDEN HORSE\""
    },
    {
      "code" : "A015514209",
      "display" : "EPINEPHRINE INJECTION \"VPP\""
    },
    {
      "code" : "A015518100",
      "display" : "BROMHEXINE TABLETS \"C.I.\""
    },
    {
      "code" : "A015520100",
      "display" : "ANETHOLE S.C. TABLETS"
    },
    {
      "code" : "A015522100",
      "display" : "CANCIDIN TABLETS 500MG (TINIDAZOLE) \"BOWLIN\""
    },
    {
      "code" : "A015526229",
      "display" : "LINCOMYCIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A015529100",
      "display" : "DICYCLOMINE TABLETS \"D.T.S.\""
    },
    {
      "code" : "A015539238",
      "display" : "K.C.L. INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A015540100",
      "display" : "NORSECON TABLETS \"CHINTENG\""
    },
    {
      "code" : "A015543100",
      "display" : "PEICHIA TABLETS \"P.L.\""
    },
    {
      "code" : "A0155431G0",
      "display" : "PEICHIA TABLETS \"P.L.\""
    },
    {
      "code" : "A015549100",
      "display" : "PEDIATRIC YUTON TABLETS 120MG\"N.C.P\""
    },
    {
      "code" : "A015553212",
      "display" : "GENTAMICIN SULFATE INJECTION 40MG \"WINSTON\""
    },
    {
      "code" : "A015553229",
      "display" : "GENTAMICIN SULFATE INJECTION 40MG \"WINSTON\""
    },
    {
      "code" : "A015555100",
      "display" : "MEFENAMIC ACID CAPSULES \"G.T.\""
    },
    {
      "code" : "A015560100",
      "display" : "HONZO TABLETS"
    },
    {
      "code" : "A015561255",
      "display" : "MANNITOL INJECTION 20％ \"SHUN HWA\""
    },
    {
      "code" : "A015561266",
      "display" : "MANNITOL INJECTION 20％ \"SHUN HWA\""
    },
    {
      "code" : "A015561277",
      "display" : "MANNITOL INJECTION 20％ \"SHUN HWA\""
    },
    {
      "code" : "A015566100",
      "display" : "STROVITAN S.C. TABLETS"
    },
    {
      "code" : "A015577100",
      "display" : "CHLORPRENALINE TABLETS \"J.C.S.\""
    },
    {
      "code" : "A015578100",
      "display" : "MEBENDAZOLE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A015579100",
      "display" : "TRIAMCINOLONE TABLETS 4 MG \"F.Y.\""
    },
    {
      "code" : "A0155791G0",
      "display" : "TRIAMCINOLONE TABLETS 4 MG \"F.Y.\""
    },
    {
      "code" : "A015581100",
      "display" : "ACETAMINOPHEN TABLETS"
    },
    {
      "code" : "A015582277",
      "display" : "AMPICLOXACIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A015584229",
      "display" : "LINCOMYCIN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A015584299",
      "display" : "LINCOMYCIN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A015596100",
      "display" : "APAP TABLETS 500MG"
    },
    {
      "code" : "A015599100",
      "display" : "ISONIAZID TABLETS \"METRO\""
    },
    {
      "code" : "A015605100",
      "display" : "MYLANLO TABLETS \"MEIDER\""
    },
    {
      "code" : "A015613209",
      "display" : "ORCIPRENALINE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A015616100",
      "display" : "BACZINE TABLETS \"H.S.\""
    },
    {
      "code" : "A015622100",
      "display" : "MEBENDAZOLE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A015629100",
      "display" : "CINNARIZINE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0156291G0",
      "display" : "CINNARIZINE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A015630100",
      "display" : "DEXTROMETHORPHAN HYDROBROMIDE S.C. TABLETS \"WEI LI\""
    },
    {
      "code" : "A015632209",
      "display" : "DEPOT. TESTOESTRADIOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A015637100",
      "display" : "MEBENDAZOLE TABLETS \"H.L.\""
    },
    {
      "code" : "A015638118",
      "display" : "A.A.P. solution"
    },
    {
      "code" : "A015638199",
      "display" : "A.A.P. solution"
    },
    {
      "code" : "A015639100",
      "display" : "PACINOL TABLETS 500MG"
    },
    {
      "code" : "A015640100",
      "display" : "LONTA S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A015660100",
      "display" : "Cephalexin Capsules 500mg \"TBC\""
    },
    {
      "code" : "A015666100",
      "display" : "ACETAMINOPHEN TABLETS 300MG \"YU SHENG\""
    },
    {
      "code" : "A015668100",
      "display" : "MEBENDAZOLE TABLETS \"P.L.\""
    },
    {
      "code" : "A015670100",
      "display" : "SPILAZIDE TABLETS \"C.R.\""
    },
    {
      "code" : "A015672100",
      "display" : "D.M.C.C. TABLETS \"C.I.\""
    },
    {
      "code" : "A015674100",
      "display" : "SESDEN CAPSULES (TIMEPIDIUM)"
    },
    {
      "code" : "A015684100",
      "display" : "NITRAZEPAM TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A015691212",
      "display" : "GENTAMICIN INJECTIONS \"L.C.C.\""
    },
    {
      "code" : "A015691229",
      "display" : "GENTAMICIN INJECTIONS \"L.C.C.\""
    },
    {
      "code" : "A015692229",
      "display" : "LINCOMYCIN INJECTIONS \"LIN CHEMICAL\""
    },
    {
      "code" : "A015694100",
      "display" : "IBUPROFEN S.C. TABLETS 100MG \"F.Y.\""
    },
    {
      "code" : "A015697100",
      "display" : "LIPHALEXIN CAPSULES 500MG \"LITA\""
    },
    {
      "code" : "A015698100",
      "display" : "TRIMEPRAZINE TARTRATE TABLETS \"HONTEN\""
    },
    {
      "code" : "A015700100",
      "display" : "RIFAMNICIN CAPSULES 300MG \"C.S.P.\""
    },
    {
      "code" : "A015703100",
      "display" : "LIMOX CAPSULES 500MG \"LITA\""
    },
    {
      "code" : "A015716209",
      "display" : "METHYL SCOPOLAMINE METHYL SULFATE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A015721100",
      "display" : "DIS S.C. TABLETS (DIPHENIDOL)"
    },
    {
      "code" : "A015722100",
      "display" : "BIONAMIN-H TABLETS \"C.Y.\""
    },
    {
      "code" : "A015723177",
      "display" : "ANTASIL SUSPENSION"
    },
    {
      "code" : "A015727100",
      "display" : "PSEUDOCOL CAPSULES \"LITA\""
    },
    {
      "code" : "A015731229",
      "display" : "THIAMINE HCL INJECTION"
    },
    {
      "code" : "A015734100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS 12.5MG \"CHEN TA\""
    },
    {
      "code" : "A015736100",
      "display" : "SUPERGEL TABLETS"
    },
    {
      "code" : "A015740100",
      "display" : "COLD CAPSULES"
    },
    {
      "code" : "A015745100",
      "display" : "PENICILLAMINE CAPSULES \"PATRON\""
    },
    {
      "code" : "A015748100",
      "display" : "ALDIOXA TABLETS \"PATRON\" (DIHYDROXYALUMINUM ALLANTOINATE)"
    },
    {
      "code" : "A015751100",
      "display" : "Meisyke Tablets 1mg \"Chen Ta\""
    },
    {
      "code" : "A015752100",
      "display" : "ANETHOLE S.C. TABLETS 25MG \"CHEN TA\""
    },
    {
      "code" : "A015759500",
      "display" : "NILSTAT VAGINAL TABLETS (NYSTATIN)"
    },
    {
      "code" : "A015760100",
      "display" : "HWA KOR TABLETS"
    },
    {
      "code" : "A015762435",
      "display" : "KASULO NASAL SPRAY \"C.S.P.\""
    },
    {
      "code" : "A015789100",
      "display" : "DISRON"
    },
    {
      "code" : "A015791100",
      "display" : "TETRACYCLINE HCL CAPSULES 250MG \"VPC\""
    },
    {
      "code" : "A0157911G0",
      "display" : "TETRACYCLINE HCL CAPSULES 250MG \"VPC\""
    },
    {
      "code" : "A015796100",
      "display" : "ANETHOLE S.C. TABLETS \"T.A.\""
    },
    {
      "code" : "A015800100",
      "display" : "GLIBENCLAMIDE TABLETS \"J.S.\""
    },
    {
      "code" : "A015805100",
      "display" : "METHYLSCOPOLAMINE METHYL SULFATE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A015808100",
      "display" : "MEBENDAZOLE TABLETS \"S.T.\""
    },
    {
      "code" : "A015815100",
      "display" : "FONGMIN CAPSULES \"EAYUNG\""
    },
    {
      "code" : "A015829229",
      "display" : "LINCOMYCIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A015829299",
      "display" : "LINCOMYCIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A015830100",
      "display" : "LINCOMYCIN CAPSULES 250 MG \"CHI SHENG\""
    },
    {
      "code" : "A015831209",
      "display" : "ERGONOVINE MALEATE INJECTIONS \"CHI SHENG\""
    },
    {
      "code" : "A015832100",
      "display" : "ERGONOVINE MALEATE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A015833100",
      "display" : "AMPICILLIN CAPSULES 500MG \"YUNG CHANG\""
    },
    {
      "code" : "A015834100",
      "display" : "GLYCERYL GUAIACOLATE TABLETS \"M.T.\""
    },
    {
      "code" : "A015835100",
      "display" : "GOODCIDE TABLETS \"M.S.\""
    },
    {
      "code" : "A015837100",
      "display" : "PIRAMIDE TABLETS \"P.L.\""
    },
    {
      "code" : "A015838100",
      "display" : "RIFAMPICIN CAPSULES \"C.I.\""
    },
    {
      "code" : "A015839100",
      "display" : "SALTOL TABLETS (SALBUTAMOL) \"C.C.P.\""
    },
    {
      "code" : "A015842209",
      "display" : "CEFAZOLIN INJECTIONS 1 Gm \"YUNG SHIN\""
    },
    {
      "code" : "A015843277",
      "display" : "CEFAZOLIN INJECTION  \"YUNG SHIN\""
    },
    {
      "code" : "A015845209",
      "display" : "PENICILLIN G SODIUM INJECTION \"Y.F.\""
    },
    {
      "code" : "A015845216",
      "display" : "PENICILLIN G SODIUM INJECTION \"Y.F.\""
    },
    {
      "code" : "A015845229",
      "display" : "PENICILLIN G SODIUM INJECTION \"Y.F.\""
    },
    {
      "code" : "A015849100",
      "display" : "CLOMIPHENE CAPSULES 50MG \"YU SHENG\""
    },
    {
      "code" : "A015853100",
      "display" : "LONG-ONE CAPSULES (FLUOXYMESTERONE)\"S.C.\""
    },
    {
      "code" : "A015908209",
      "display" : "HYDROXYPROGESTERONE CAPROATE INJECTIONS \"TAI YU\""
    },
    {
      "code" : "A015910100",
      "display" : "PIPRINHYDRINATE TABLETS \"P.L.\""
    },
    {
      "code" : "A015911209",
      "display" : "AMPOLIN INJECTIONS 1000MG"
    },
    {
      "code" : "A015912100",
      "display" : "SALBUTAMOL TABLETS 4MG \"EAYUNG\""
    },
    {
      "code" : "A015916100",
      "display" : "POKITON TABLETS \"Y.S.\""
    },
    {
      "code" : "A015917209",
      "display" : "AMCLOCILLIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A015917277",
      "display" : "AMCLOCILLIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A015919157",
      "display" : "COLD COUGH SYRUP \"C.M.\""
    },
    {
      "code" : "A015919199",
      "display" : "COLD COUGH SYRUP \"C.M.\""
    },
    {
      "code" : "A015933238",
      "display" : "POLYVITA-S INJ. 20ML"
    },
    {
      "code" : "A015980209",
      "display" : "PROGESTERONE INJECTION 25MG \"G.C.\""
    },
    {
      "code" : "A015984100",
      "display" : "DIAZEPAM TABLETS 5MG \"JEN SHENG\""
    },
    {
      "code" : "A015985100",
      "display" : "CLONIDINE TABLETS \"Y.K.\""
    },
    {
      "code" : "A015986100",
      "display" : "ITONFEN CAPSULES 200MG \"CHEN TA\""
    },
    {
      "code" : "A015987212",
      "display" : "DIAZEPAM INJECTIONS \"TAI YU\""
    },
    {
      "code" : "A015988229",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A015988238",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION \"Y.F.\""
    },
    {
      "code" : "A015989100",
      "display" : "ANETHOLE CAPSULES\"H.S.\""
    },
    {
      "code" : "A015990100",
      "display" : "PERTIN S.C. TABLETS 25MG"
    },
    {
      "code" : "A015992100",
      "display" : "PANATOL TABLETS \"M.T.\""
    },
    {
      "code" : "A016004100",
      "display" : "NALICIDE TABLETS (NALIDIXIC ACID) \"KINGDOM\""
    },
    {
      "code" : "A016009100",
      "display" : "BROMHEXINE TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A016010100",
      "display" : "SCOPOLAMINE BUTYLBROMIDE S.C. TABLETS \"EAYUNG\""
    },
    {
      "code" : "A016011100",
      "display" : "FONGMIN S.C. TABLETS"
    },
    {
      "code" : "A016015100",
      "display" : "PROPRANOLOL TABLETS \"SHUN HWA\""
    },
    {
      "code" : "A016018100",
      "display" : "BROMHEXINE TABLETS \"SHUN HWA\""
    },
    {
      "code" : "A016019100",
      "display" : "Mebendazole Tablets \"M.D.\""
    },
    {
      "code" : "A016020100",
      "display" : "BATHOLIN TABLETS \"GENTLE\""
    },
    {
      "code" : "A016021100",
      "display" : "DICYCLOMINE TABLETS \"Y.C.\""
    },
    {
      "code" : "A016028100",
      "display" : "TONPYRON TABLETS \"PATRON\""
    },
    {
      "code" : "A016034100",
      "display" : "ALRA TABLETS \"HEALTH\""
    },
    {
      "code" : "A016055100",
      "display" : "MEBENDAZOLE TABLETS \"SHINLON\""
    },
    {
      "code" : "A016063100",
      "display" : "DEXAMETHASONE TABLETS \"T.A.\""
    },
    {
      "code" : "A016065209",
      "display" : "Dexamethasone Injection 4mg/ml \"ASTAR\""
    },
    {
      "code" : "A016065229",
      "display" : "Dexamethasone Injection 4mg/ml \"ASTAR\""
    },
    {
      "code" : "A016071100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"TA\""
    },
    {
      "code" : "A016072100",
      "display" : "ETHAVERINE TABLETS \"LEONZES\""
    },
    {
      "code" : "A016080335",
      "display" : "LINER OINTMENT"
    },
    {
      "code" : "A016084100",
      "display" : "ANTICOUGH CAPSULES \"HEALTH\""
    },
    {
      "code" : "A016088100",
      "display" : "SEDENTON TABLETS \"C.L.\""
    },
    {
      "code" : "A016093100",
      "display" : "Tonlan Tablets 500mg \"Chen Ta\""
    },
    {
      "code" : "A016094100",
      "display" : "RIFAMPICIN CAPSULES \"C.I.\""
    },
    {
      "code" : "A016099100",
      "display" : "CLOXAMPICIN CAPSULES 500MG \"PANBIOTIC\""
    },
    {
      "code" : "A016108100",
      "display" : "HONBITAN CAPSULES \"HONTEN\""
    },
    {
      "code" : "A016130100",
      "display" : "SALOBEL TABLETS (ALLOPURINOL)"
    },
    {
      "code" : "A016131100",
      "display" : "STREPMAGEN TABLETS \"F.Y.\""
    },
    {
      "code" : "A016133100",
      "display" : "MAICA CAPSULES \"P.L.\""
    },
    {
      "code" : "A016138100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"GOLDEN HORSE\""
    },
    {
      "code" : "A016141100",
      "display" : "SALBUTAMOL TABLETS 4MG \"F.Y.\""
    },
    {
      "code" : "A0161411G0",
      "display" : "SALBUTAMOL TABLETS 4MG \"F.Y.\""
    },
    {
      "code" : "A016143100",
      "display" : "BROMHEXINE TABLETS \"Y.C.\""
    },
    {
      "code" : "A016144100",
      "display" : "CINNARIZINE TABLETS \"S.T.\""
    },
    {
      "code" : "A016145100",
      "display" : "WETARING S.C. TABLETS \"S.T.\""
    },
    {
      "code" : "A016158100",
      "display" : "TINCO CAPSULES \"C.M.\""
    },
    {
      "code" : "A016162100",
      "display" : "CO-TRIMO TABLETS \"F.Y.\""
    },
    {
      "code" : "A016171100",
      "display" : "COMMON COLD CAPSULES \"M.S.\""
    },
    {
      "code" : "A016172100",
      "display" : "MEBENDAZOLE TABLETS \"MEIDER\""
    },
    {
      "code" : "A016186100",
      "display" : "SEMANTON CAPSULES \"TOLIN\""
    },
    {
      "code" : "A016195100",
      "display" : "DEXTROMETHORPHAN TABLETS 30 MG"
    },
    {
      "code" : "A016199100",
      "display" : "ASCORBIC ACID TABLETS \"IDEAL\""
    },
    {
      "code" : "A016204100",
      "display" : "VITATROSCINE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A016206100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"Y.F.\""
    },
    {
      "code" : "A016216100",
      "display" : "ANTICOUGH CAPSULES \"M.S.\""
    },
    {
      "code" : "A016220100",
      "display" : "ACETAMINOPHEN TABLETS \"JENSHENG\""
    },
    {
      "code" : "A016221209",
      "display" : "PENICILLIN G SODIUM FOR INJECTION 1,000,000 UNITS \"VPP\""
    },
    {
      "code" : "A016222435",
      "display" : "SUBICIN NASAL SPRAY \"WINSTON\""
    },
    {
      "code" : "A016223100",
      "display" : "PROCHLORPERAZINE MALEATE S.C. TABLETS 5MG \"VPP\""
    },
    {
      "code" : "A016224209",
      "display" : "ASCORBIC ACID INJECTION \"LIN CHEMICAL\""
    },
    {
      "code" : "A016224221",
      "display" : "ASCORBIC ACID INJECTION \"LIN CHEMICAL\""
    },
    {
      "code" : "A016227100",
      "display" : "DOXYCYCLINE CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A016247100",
      "display" : "MEBENDAZOLE TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A0162471G0",
      "display" : "MEBENDAZOLE TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A016248157",
      "display" : "NOGESIC SYRUP (ACETAMINOPHEN) \"HEALTH\""
    },
    {
      "code" : "A016298100",
      "display" : "CHIAKANG TABLETS \"ASTAR\""
    },
    {
      "code" : "A016299100",
      "display" : "PHLOROPROPIOPHENONE CAPSULES\"H.S.\""
    },
    {
      "code" : "A016302277",
      "display" : "CEFAZOLIN INJECTION 500MG \"TAH-AN\""
    },
    {
      "code" : "A016303421",
      "display" : "DECASON EYE DROPS"
    },
    {
      "code" : "A016317100",
      "display" : "CASCARA S.C. TABLETS 130MG \"V.P.P.\""
    },
    {
      "code" : "A016318100",
      "display" : "CASCARA S.C. TABLETS 250MG \"V.P.P.\""
    },
    {
      "code" : "A016322100",
      "display" : "HOWEI TABLETS"
    },
    {
      "code" : "A016332100",
      "display" : "MEFENAMIC ACID CAPSULES \"B.C.\""
    },
    {
      "code" : "A016336100",
      "display" : "BEYLIYAN TABLETS \"M.T.\""
    },
    {
      "code" : "A016337100",
      "display" : "VITA B.E. TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A016343100",
      "display" : "RIFAMPIN CAPSULES 150MG \"CHI SHENG\""
    },
    {
      "code" : "A016348100",
      "display" : "RHIN TABLETS \"GCPC\""
    },
    {
      "code" : "A016349309",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016349321",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016349329",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016349377",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016349399",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A0163493B9",
      "display" : "BETASONE CREAM (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016350100",
      "display" : "ENDURE TABLETS (PROPRANOLOL) \"GCPC\""
    },
    {
      "code" : "A016351100",
      "display" : "EXTAMINE TABLETS (BROMPHENIRAMINE) \"GCPC\""
    },
    {
      "code" : "A016352100",
      "display" : "BETASONE TABLETS (BETAMETHASONE) \"GCPC\""
    },
    {
      "code" : "A016353435",
      "display" : "EPHRINE NASAL SPRAY \"GCPC\""
    },
    {
      "code" : "A016371100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A016373100",
      "display" : "\"O.Y.\" Reh Nar Tong TABLETS"
    },
    {
      "code" : "A016374100",
      "display" : "WELIMIN TABLETS \"M.T.\""
    },
    {
      "code" : "A016376212",
      "display" : "TIOPRONIN INJ. 2ML"
    },
    {
      "code" : "A016377100",
      "display" : "MONTEASE CAPSULES (PROTEASE) \"CHIPHAR\""
    },
    {
      "code" : "A016378100",
      "display" : "AMPICILLIN CAPSULES \"SINTONG\""
    },
    {
      "code" : "A016379212",
      "display" : "TIOPRONIN INJECTION \"TBC\""
    },
    {
      "code" : "A016379221",
      "display" : "TIOPRONIN INJECTION \"TBC\""
    },
    {
      "code" : "A016390155",
      "display" : "ZUTON SOLUTION 15MG/ML \"L.S.\" (ACETAMINOPHEN)"
    },
    {
      "code" : "A016392100",
      "display" : "BETAMETHASONE TABLETS \"HONTEN\""
    },
    {
      "code" : "A016395100",
      "display" : "BUCLIZINE TABLETS \"H.L.\""
    },
    {
      "code" : "A016402329",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016402338",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016402348",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016402371",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016402377",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016402399",
      "display" : "SILVER SULFADIAZINE CREAM"
    },
    {
      "code" : "A016409100",
      "display" : "CHANWEILEN TABLETS \"F.S.\""
    },
    {
      "code" : "A016411212",
      "display" : "SULPYRIN INJECTION \"WINSTON\""
    },
    {
      "code" : "A016415100",
      "display" : "PERPHENSZINE S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A016420100",
      "display" : "CHLORZOXAZONE TABLETS \"P.L.\""
    },
    {
      "code" : "A016422100",
      "display" : "SEUPHENON TABLETS \"C.L.\""
    },
    {
      "code" : "A016432100",
      "display" : "ANTON TABLETS"
    },
    {
      "code" : "A0164321G0",
      "display" : "ANTON TABLETS"
    },
    {
      "code" : "A016434100",
      "display" : "SUITIN CAPSULES (MEDAZEPAM) \"K.B.\""
    },
    {
      "code" : "A016435100",
      "display" : "PRELONE TABLETS (PREDNISOLONE) \"K.B.\""
    },
    {
      "code" : "A016437100",
      "display" : "SALTEROL TABLETS (SALBUTAMOL) \"K.B.\""
    },
    {
      "code" : "A016439100",
      "display" : "\"O.Y.\"WONSOUANE CAPSULES"
    },
    {
      "code" : "A016444100",
      "display" : "PRINATE TABLETS \"CHINTENG\" (PIPRINHYDRINATE)"
    },
    {
      "code" : "A016446100",
      "display" : "BROMHEXINE HCL TABLETS \"WINSTON\""
    },
    {
      "code" : "A016447229",
      "display" : "LINCOMYCIN HCL INJECTION 300MG \"WINSTON\""
    },
    {
      "code" : "A016449100",
      "display" : "CEPHENDOL S.C. TABLETS 25MG (DIPHENIDOL) \"F.Y"
    },
    {
      "code" : "A0164491G0",
      "display" : "CEPHENDOL S.C. TABLETS 25MG (DIPHENIDOL) \"F.Y"
    },
    {
      "code" : "A016457212",
      "display" : "HYCOBAL INJECTION \"SWISS\"(HYDROXOCOBALAMINE)"
    },
    {
      "code" : "A016457216",
      "display" : "HYCOBAL INJECTION \"SWISS\"(HYDROXOCOBALAMINE)"
    },
    {
      "code" : "A016461100",
      "display" : "RIFAMPIN CAPSULES 150MG \"TAI YU\""
    },
    {
      "code" : "A016462100",
      "display" : "RIFAMPIN CAPSULES 300MG \"TAI YU\""
    },
    {
      "code" : "A016464100",
      "display" : "PREDNISOLONE TABLETS \"P.J.\""
    },
    {
      "code" : "A016465100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES \"P.J.\""
    },
    {
      "code" : "A016466100",
      "display" : "COZEPAM TABLETS (DIAZEPAM) \"P.J.\""
    },
    {
      "code" : "A016467100",
      "display" : "CADIORAL TABLETS (PROPRANOLOL) \"P.J.\""
    },
    {
      "code" : "A016469100",
      "display" : "NADIXIN TABLETS (NALIDIXIC ACID) \"P.J.\""
    },
    {
      "code" : "A016470100",
      "display" : "DIUSIX TABLETS (FRUOSEMIDE) \"P.J.\""
    },
    {
      "code" : "A016474100",
      "display" : "CEPHALEXIN CAPSULES \"TAI YU\""
    },
    {
      "code" : "A016475212",
      "display" : "LIDOCAINE INJECTION 2％ \"TAI YU\""
    },
    {
      "code" : "A016475238",
      "display" : "LIDOCAINE INJECTION 2％ \"TAI YU\""
    },
    {
      "code" : "A016475299",
      "display" : "LIDOCAINE INJECTION 2％ \"TAI YU\""
    },
    {
      "code" : "A016476238",
      "display" : "MANNITOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A016476266",
      "display" : "MANNITOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A016476277",
      "display" : "MANNITOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A016477209",
      "display" : "CEPHALORIDINE INJECTION 1GM \"TAI YU\""
    },
    {
      "code" : "A016481219",
      "display" : "AMPICILLIN POWDER FOR INJECTION 500MG \"Y.Y.\""
    },
    {
      "code" : "A016483100",
      "display" : "DECALON TABLETS (DEXAMETH-ASONE) \"F M\""
    },
    {
      "code" : "A016485100",
      "display" : "TONREN CAPSULES \"C.M.\""
    },
    {
      "code" : "A016488100",
      "display" : "GRISEOFULVIN TABLETS \"W.F.\""
    },
    {
      "code" : "A016489100",
      "display" : "Rhinomin Tablets"
    },
    {
      "code" : "A016491100",
      "display" : "SAN HUNG TABLETS \"C.T.\""
    },
    {
      "code" : "A016496100",
      "display" : "DEXAMETHASONE TABLETS\"C.L\""
    },
    {
      "code" : "A016498100",
      "display" : "SUBETE TABLETS \"C.S.\""
    },
    {
      "code" : "A016499240",
      "display" : "LICOLASE LYOPHILIZED INJECTION \"LITA\""
    },
    {
      "code" : "A016500100",
      "display" : "CHYMOTRYPSIN E.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A016503100",
      "display" : "ISOPRIN TABLETS (ISOXSUPRINE) \"ATOBI\""
    },
    {
      "code" : "A016506100",
      "display" : "DEXTROMETHORPHAN HBR TABLETS \"P.J.\""
    },
    {
      "code" : "A016508100",
      "display" : "BISOLDIN TABLETS \"P.J.\""
    },
    {
      "code" : "A016509100",
      "display" : "ACETAMINOPHEN TABLETS \"P.J.\""
    },
    {
      "code" : "A016518235",
      "display" : "THIOTEPA PARENTERAL"
    },
    {
      "code" : "A016525277",
      "display" : "AMPICILLIN INJECTION \"SINTONG\""
    },
    {
      "code" : "A016583229",
      "display" : "GENTAMICIN INJECTION 40MG/ML \"Y.A.\""
    },
    {
      "code" : "A016584209",
      "display" : "SALBUTAMOL INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A016585100",
      "display" : "HATRANPIN TABLETS (MEBENDAZOLE)"
    },
    {
      "code" : "A016587100",
      "display" : "ANTICON TABLETS \"WU THE\""
    },
    {
      "code" : "A016589209",
      "display" : "ORIDERON INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A016590421",
      "display" : "GENTA EYE DROPS (GENTAMYCIN) \"Y.F.\""
    },
    {
      "code" : "A016590429",
      "display" : "GENTA EYE DROPS (GENTAMYCIN) \"Y.F.\""
    },
    {
      "code" : "A016590435",
      "display" : "GENTA EYE DROPS (GENTAMYCIN) \"Y.F.\""
    },
    {
      "code" : "A016592100",
      "display" : "POLYYEN S.C. TABLETS \"K.B.\""
    },
    {
      "code" : "A016594100",
      "display" : "WEI YUNG AN TABLETS \"O.Y.\""
    },
    {
      "code" : "A0165941G0",
      "display" : "WEI YUNG AN TABLETS \"O.Y.\""
    },
    {
      "code" : "A016595100",
      "display" : "CHOLIGEN S.C. TABLETS \"K.B.\""
    },
    {
      "code" : "A016599372",
      "display" : "GETASON CREAM \"CHIU PO\""
    },
    {
      "code" : "A016599399",
      "display" : "GETASON CREAM \"CHIU PO\""
    },
    {
      "code" : "A016605229",
      "display" : "LINCOMYCIN INJECTION \"STANDARD\""
    },
    {
      "code" : "A016605299",
      "display" : "LINCOMYCIN INJECTION \"STANDARD\""
    },
    {
      "code" : "A016612209",
      "display" : "STREPTOMYCIN SULFATE FOR INJECTION 1GM (POTENCY)"
    },
    {
      "code" : "A016615212",
      "display" : "FUROSEMIDE INJECTION \"TAI YU\""
    },
    {
      "code" : "A016616100",
      "display" : "GUAIAZULENE SODIUM SULFONATE S.C. TABLETS \"N.C.P.\""
    },
    {
      "code" : "A016617100",
      "display" : "TRIMEPRAZINE TARTRATE S.C. TABLETS \"N.C.P.\""
    },
    {
      "code" : "A016672100",
      "display" : "METOPELAN S.C. TABLETS (METOCLOPRAMIDE) \"ATOBI\""
    },
    {
      "code" : "A016674100",
      "display" : "ITON CAPSULES \"N.C.P.\""
    },
    {
      "code" : "A016678100",
      "display" : "FUNGACIN TABLETS 125MG (GRISEOFULVIN) \"P.J.\""
    },
    {
      "code" : "A016679100",
      "display" : "IPUTON TABLETS \"Y.K.\""
    },
    {
      "code" : "A016689100",
      "display" : "ANTITON TABLETS \"H.C.\""
    },
    {
      "code" : "A016692100",
      "display" : "METHYLEPHEDRINE HCL TABLETS \"J.S.\""
    },
    {
      "code" : "A016698100",
      "display" : "Winsocaine Tablets \"Y.K.\""
    },
    {
      "code" : "A016699100",
      "display" : "ANPOLIN S.C. TABLETS 50MG (HYDRALAZINE)"
    },
    {
      "code" : "A016700100",
      "display" : "METHYLSCOPOLAMINE METHYLSULFATE TABLETS"
    },
    {
      "code" : "A016705321",
      "display" : "EUDERMA CREAM (TRIAMCINOLONE)"
    },
    {
      "code" : "A016705377",
      "display" : "EUDERMA CREAM (TRIAMCINOLONE)"
    },
    {
      "code" : "A016705399",
      "display" : "EUDERMA CREAM (TRIAMCINOLONE)"
    },
    {
      "code" : "A016706100",
      "display" : "ULEXIN CAPSULES (CEPHALEXIN)"
    },
    {
      "code" : "A0167061G0",
      "display" : "ULEXIN CAPSULES (CEPHALEXIN)"
    },
    {
      "code" : "A016712100",
      "display" : "ANTISEMIN TABLETS"
    },
    {
      "code" : "A0167121G0",
      "display" : "ANTISEMIN TABLETS"
    },
    {
      "code" : "A016713100",
      "display" : "XYLONOL TABLETS (ALLOPURINOL)"
    },
    {
      "code" : "A016748100",
      "display" : "NEWLIMIN TABLETS (PIPRINHYDRINATE) \"N.Y.\""
    },
    {
      "code" : "A016749212",
      "display" : "NEWLIMIN INJECTION (PIPRINHYDRINATE) \"GCPC\""
    },
    {
      "code" : "A016751100",
      "display" : "COLDENIN S.C. TABLETS"
    },
    {
      "code" : "A016754100",
      "display" : "FULIAN CAPSULES"
    },
    {
      "code" : "A016769100",
      "display" : "MASOLON CAPSULES"
    },
    {
      "code" : "A016796100",
      "display" : "SINGAPININ TABLETS"
    },
    {
      "code" : "A016802209",
      "display" : "BETASONE INJECTION (DI-BETAMETHASONE)"
    },
    {
      "code" : "A016802221",
      "display" : "BETASONE INJECTION (DI-BETAMETHASONE)"
    },
    {
      "code" : "A016810212",
      "display" : "DEXAMETHASONE INJECTION 2MG/ML \"N.K.\""
    },
    {
      "code" : "A016810229",
      "display" : "DEXAMETHASONE INJECTION 2MG/ML \"N.K.\""
    },
    {
      "code" : "A016816100",
      "display" : "CYPRODINE TABLETS (CYPROHEPTADINE HCL)"
    },
    {
      "code" : "A016818100",
      "display" : "SALTMOL TABLETS 4MG \"CHEN TA\" (SALBUTAMOL)"
    },
    {
      "code" : "A016821100",
      "display" : "LOPERAMIDE CAPSULES \"HONTEN\""
    },
    {
      "code" : "A0168211G0",
      "display" : "LOPERAMIDE CAPSULES \"HONTEN\""
    },
    {
      "code" : "A016829100",
      "display" : "UPVENA TABLETS 4MG\"JINUP\" (CARBINOXAMINE MALEATE)"
    },
    {
      "code" : "A016830100",
      "display" : "PAINLAX CAPSULES \"JINUP\" (DICYCLOMINE)"
    },
    {
      "code" : "A016831100",
      "display" : "GETCHILD TABLETS \"N.C.P.\" (CLOMIPHENE)"
    },
    {
      "code" : "A016835100",
      "display" : "LITONING TABLETS \"S.T.\""
    },
    {
      "code" : "A016838100",
      "display" : "KETOPROFEN CAPSULES 50MG \"P.J.\""
    },
    {
      "code" : "A016839100",
      "display" : "MEBENZOLE TABLETS (MEBENDAZOLE) \"H.H.\""
    },
    {
      "code" : "A0168391G0",
      "display" : "MEBENZOLE TABLETS (MEBENDAZOLE) \"H.H.\""
    },
    {
      "code" : "A016840100",
      "display" : "VITADOXIN E.C. TABLETS (PYRIDOXAL-PHOSPHATE)"
    },
    {
      "code" : "A016844277",
      "display" : "COBAMAMIDE LYOPHILIZED INJECTION \"LITA\""
    },
    {
      "code" : "A016845100",
      "display" : "MYALAX TABLETS (CHLORZOXAZONE) \"T.A.\""
    },
    {
      "code" : "A016850100",
      "display" : "TAR WEING TABLETS (METHYLSCOPOLAMIN METHYL SULFATE) \"CHEN TA.\""
    },
    {
      "code" : "A016854100",
      "display" : "SUPRIM TABLETS \"P.J.\""
    },
    {
      "code" : "A016862321",
      "display" : "TOPCORT CREAM \"RICHEVER\""
    },
    {
      "code" : "A016862329",
      "display" : "TOPCORT CREAM \"RICHEVER\""
    },
    {
      "code" : "A016862377",
      "display" : "TOPCORT CREAM \"RICHEVER\""
    },
    {
      "code" : "A016862399",
      "display" : "TOPCORT CREAM \"RICHEVER\""
    },
    {
      "code" : "A016863212",
      "display" : "BISCO INJECTION  \"STANDARD\"(BROMHEXINE)"
    },
    {
      "code" : "A016867177",
      "display" : "ERYTHROMYCIN ESTOLATE FOR ORAL SUSPENSION \"P.J.\""
    },
    {
      "code" : "A016867199",
      "display" : "ERYTHROMYCIN ESTOLATE FOR ORAL SUSPENSION \"P.J.\""
    },
    {
      "code" : "A016868209",
      "display" : "HYOSCON INJECTION (SCOPOLAMINE BUTYLBROMIDE)\"TAI YU\""
    },
    {
      "code" : "A016872100",
      "display" : "RIFAMPICIN CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A016873100",
      "display" : "YIPAITAN TABLETS 8MG \"Y.S.\" (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A016876100",
      "display" : "DECOUGH CAPSULES \"C.H.\""
    },
    {
      "code" : "A016878229",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION \"LITA\""
    },
    {
      "code" : "A016879100",
      "display" : "WACICORT TABLETS \"WST\" (TRIAMCINOLONE)"
    },
    {
      "code" : "A016887209",
      "display" : "ANTITUSSIVE INJECTION (DEXTROMETHORPHAN) \"TAI YU\""
    },
    {
      "code" : "A016901321",
      "display" : "YONFU OINTMENT"
    },
    {
      "code" : "A016901329",
      "display" : "YONFU OINTMENT"
    },
    {
      "code" : "A016901372",
      "display" : "YONFU OINTMENT"
    },
    {
      "code" : "A016901399",
      "display" : "YONFU OINTMENT"
    },
    {
      "code" : "A016902100",
      "display" : "METOPERAN S.C. TABLETS (METOCLOPRAMIDE) \"H.C.\""
    },
    {
      "code" : "A016908209",
      "display" : "5％ DEXTROSE IN 0.225％ SALINE INJECTION \"S.T.\""
    },
    {
      "code" : "A016908277",
      "display" : "5％ DEXTROSE IN 0.225％ SALINE INJECTION \"S.T.\""
    },
    {
      "code" : "A016909377",
      "display" : "HAIRFEELY TISEN OINTMENT \"C.M.\""
    },
    {
      "code" : "A016909399",
      "display" : "HAIRFEELY TISEN OINTMENT \"C.M.\""
    },
    {
      "code" : "A016913209",
      "display" : "CARBENMYCIN INJECTION (CARBENICILLIN) \"YUNG SHIN\""
    },
    {
      "code" : "A016932100",
      "display" : "SEUDORIN TABLETS (PSEUDOEPHEDRINE HCL)"
    },
    {
      "code" : "A0169321G0",
      "display" : "SEUDORIN TABLETS (PSEUDOEPHEDRINE HCL)"
    },
    {
      "code" : "A016934100",
      "display" : "LISORAX S.C. TABLETS \"M.S.\""
    },
    {
      "code" : "A016936100",
      "display" : "OXTRIPHYLLINE TABLETS \"S.T.\""
    },
    {
      "code" : "A016938100",
      "display" : "METOCLOPRAMIDE S.C. TABLETS \"WINSTON\""
    },
    {
      "code" : "A016941100",
      "display" : "ERGONOVINE MALEATE TABLETS \"S.H.\""
    },
    {
      "code" : "A016944100",
      "display" : "IBUPROFEN TABLETS \"SHINLON\""
    },
    {
      "code" : "A016947100",
      "display" : "MIDECAMYCIN CAPSULES 200MG"
    },
    {
      "code" : "A016950212",
      "display" : "FUROSEMIDE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A016951100",
      "display" : "LITON E.C.TABLETS (BISACODYL)\"Y.S.\""
    },
    {
      "code" : "A016953100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"YUNG SHIN\""
    },
    {
      "code" : "A016958100",
      "display" : "NICOFEROL CAPSULES (TOCOPHEROL NICOTINATE) \"GENTLE\""
    },
    {
      "code" : "A016959100",
      "display" : "MEDAZOLE S.C. TABLETS 100MG (MEBENDAZOLE)\"F.S.\""
    },
    {
      "code" : "A016962100",
      "display" : "SABUTAL TABLETS  \"SWISS BRAND\" (SALBUTAMOL)"
    },
    {
      "code" : "A016963209",
      "display" : "SIVKORT STERILE SUSPENSION 40MG (TRIAMCINOLONE)"
    },
    {
      "code" : "A016963212",
      "display" : "SIVKORT STERILE SUSPENSION 40MG (TRIAMCINOLONE)"
    },
    {
      "code" : "A016963221",
      "display" : "SIVKORT STERILE SUSPENSION 40MG (TRIAMCINOLONE)"
    },
    {
      "code" : "A016963229",
      "display" : "SIVKORT STERILE SUSPENSION 40MG (TRIAMCINOLONE)"
    },
    {
      "code" : "A016964100",
      "display" : "LISUZONE TABLETS \"Y.K.\"(HYDROCHLOROTHIAZIDE)"
    },
    {
      "code" : "A016969100",
      "display" : "CONAMIN TABLETS \"GENTLE\""
    },
    {
      "code" : "A016972100",
      "display" : "SWITYL TABLETS"
    },
    {
      "code" : "A017006100",
      "display" : "FONES-TON CAPSULES \"K.B.\""
    },
    {
      "code" : "A017007277",
      "display" : "CEFAZOLIN INJECTION 0.5GM \"C.C.P.\""
    },
    {
      "code" : "A017011100",
      "display" : "SANACTASE TABLETS"
    },
    {
      "code" : "A017014321",
      "display" : "FLUDEX OINTMENT (FLUOCINONIDE) \"CBC\""
    },
    {
      "code" : "A017014329",
      "display" : "FLUDEX OINTMENT (FLUOCINONIDE) \"CBC\""
    },
    {
      "code" : "A017014377",
      "display" : "FLUDEX OINTMENT (FLUOCINONIDE) \"CBC\""
    },
    {
      "code" : "A017014399",
      "display" : "FLUDEX OINTMENT (FLUOCINONIDE) \"CBC\""
    },
    {
      "code" : "A017017100",
      "display" : "MEBENDAZOLE TABLETS \"WELCAN\""
    },
    {
      "code" : "A017018100",
      "display" : "LETANLON S.C. TABLETS (ANETHOLE TRITHIONE)"
    },
    {
      "code" : "A017022265",
      "display" : "HARTMANN'S G INJECTION"
    },
    {
      "code" : "A017022277",
      "display" : "HARTMANN'S G INJECTION"
    },
    {
      "code" : "A017023238",
      "display" : "POTASSIUM CHLORIDE INJECTION (15％ W/V)"
    },
    {
      "code" : "A017053100",
      "display" : "COLD VON ROLE TABLETS \"TA\""
    },
    {
      "code" : "A017077209",
      "display" : "KANAMYCIN SULFATE FOR INJECTION 1GM(POTENCY)"
    },
    {
      "code" : "A017078100",
      "display" : "KANAMYCIN SULFATE CAPSULES 250MG"
    },
    {
      "code" : "A017081277",
      "display" : "CEPHAZOLIN INJECTION 500MG \"S.T.\""
    },
    {
      "code" : "A017082100",
      "display" : "SIDUS TABLETS \"F.Y.\""
    },
    {
      "code" : "A017084100",
      "display" : "IBUPROFEN CAPSULES"
    },
    {
      "code" : "A017088238",
      "display" : "GISACON-B12 INJECTION \"Honten\""
    },
    {
      "code" : "A017090209",
      "display" : "GRIPMINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A017106309",
      "display" : "PROPISONE CREAM"
    },
    {
      "code" : "A017106321",
      "display" : "PROPISONE CREAM"
    },
    {
      "code" : "A017106329",
      "display" : "PROPISONE CREAM"
    },
    {
      "code" : "A017106399",
      "display" : "PROPISONE CREAM"
    },
    {
      "code" : "A017107100",
      "display" : "DEPAIN TABLETS"
    },
    {
      "code" : "A017108100",
      "display" : "SUNET HETON CAPSULES"
    },
    {
      "code" : "A017119100",
      "display" : "DESININE S.C. TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A017121100",
      "display" : "MIN'S TABLETS \"H.C.\""
    },
    {
      "code" : "A017122100",
      "display" : "MINOPHEN TABLETS (ACETAMINOPHEN)"
    },
    {
      "code" : "A017123435",
      "display" : "BERBERINE CHLORIDE EYE DROPS SOLUTION \"LITA\""
    },
    {
      "code" : "A017124100",
      "display" : "WEYAN TABLETS \"M.T.\""
    },
    {
      "code" : "A0171241G0",
      "display" : "WEYAN TABLETS \"M.T.\""
    },
    {
      "code" : "A017125248",
      "display" : "FURATONIN INJECTION \"G.C.\""
    },
    {
      "code" : "A017125277",
      "display" : "FURATONIN INJECTION \"G.C.\""
    },
    {
      "code" : "A017126100",
      "display" : "KONWEINENG TABLETS \"CHEN TA\""
    },
    {
      "code" : "A017132100",
      "display" : "KOPHYLLIN TABLETS \"P.L.\""
    },
    {
      "code" : "A017136100",
      "display" : "TONPEN TABLETS \"W.S.\""
    },
    {
      "code" : "A017138100",
      "display" : "CYHEPDIN TABLETS \"J.H.\" (CYPROHEPTADINE)"
    },
    {
      "code" : "A017143100",
      "display" : "WISH TABLETS"
    },
    {
      "code" : "A017144321",
      "display" : "BAK CREAM \"H.S.C.\""
    },
    {
      "code" : "A017144329",
      "display" : "BAK CREAM \"H.S.C.\""
    },
    {
      "code" : "A017144372",
      "display" : "BAK CREAM \"H.S.C.\""
    },
    {
      "code" : "A017144399",
      "display" : "BAK CREAM \"H.S.C.\""
    },
    {
      "code" : "A017146238",
      "display" : "K-CL INJECTION 15％W/V (POTASSIUM CHLORIDE)"
    },
    {
      "code" : "A017147100",
      "display" : "EUVITA TABLETS"
    },
    {
      "code" : "A017148421",
      "display" : "KANENDOMYCIN OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A017149263",
      "display" : "KANENDOMYCIN FOR INJECTION"
    },
    {
      "code" : "A017149271",
      "display" : "KANENDOMYCIN FOR INJECTION"
    },
    {
      "code" : "A017152100",
      "display" : "THYRODIN TABLETS 65mg"
    },
    {
      "code" : "A017153100",
      "display" : "CYPROHEPTADINE HCL TABLETS \"SHINLON\""
    },
    {
      "code" : "A017156100",
      "display" : "CHLORMEZANONE TABLETS \"TA\""
    },
    {
      "code" : "A017176100",
      "display" : "SKELAX TABLETS \"GCPC\""
    },
    {
      "code" : "A017179100",
      "display" : "Shulijn Tablets \" Chen Ta\""
    },
    {
      "code" : "A017180100",
      "display" : "TOCOPHEROL ACETATE CAPSULES \"C.I.\""
    },
    {
      "code" : "A017181100",
      "display" : "IDOFEN CAPSULES 200 MG \"STANDARD\"  (IBUPROFEN)"
    },
    {
      "code" : "A017184100",
      "display" : "LOTENSION TABLETS 25MG (HYDRALAZINE) \"GCPC\""
    },
    {
      "code" : "A017185100",
      "display" : "MEFENA TABLETS \"GCPC\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A0171851G0",
      "display" : "MEFENA TABLETS \"GCPC\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A017187135",
      "display" : "ANTAGEL LIQUID \"GCPC\""
    },
    {
      "code" : "A017187166",
      "display" : "ANTAGEL LIQUID \"GCPC\""
    },
    {
      "code" : "A017195321",
      "display" : "FUOBIHOW CREAM \"UNIVERSAL\""
    },
    {
      "code" : "A017195329",
      "display" : "FUOBIHOW CREAM \"UNIVERSAL\""
    },
    {
      "code" : "A017195335",
      "display" : "FUOBIHOW CREAM \"UNIVERSAL\""
    },
    {
      "code" : "A017195399",
      "display" : "FUOBIHOW CREAM \"UNIVERSAL\""
    },
    {
      "code" : "A017199100",
      "display" : "TON FONLIN CAPSULES \"Y.S.\" (IBUPROFEN)"
    },
    {
      "code" : "A017200421",
      "display" : "DECASON EYE DROPS \"OASIS\" (DEXAMETHASONE)"
    },
    {
      "code" : "A017203100",
      "display" : "GLYCYRRIZINE & OPIUM COMPOUND TABLETS \"HEALTH\""
    },
    {
      "code" : "A017204157",
      "display" : "BROWN MIXTURE LIQ. (WITH OPIUM) \"HEALTH\""
    },
    {
      "code" : "A017204199",
      "display" : "BROWN MIXTURE LIQ. (WITH OPIUM) \"HEALTH\""
    },
    {
      "code" : "A017205100",
      "display" : "SHOUENLIN TABLETS (IBUPROFEN)\"Y.Y.\""
    },
    {
      "code" : "A017206100",
      "display" : "FLUOXYMESTERONE TABLETS \"C.S.\""
    },
    {
      "code" : "A017245100",
      "display" : "MORIEIN TABLETS \"D.T.S.\" (BENZYDAMINE)"
    },
    {
      "code" : "A017246229",
      "display" : "KOAGTIN INJECTION"
    },
    {
      "code" : "A017248100",
      "display" : "MIGUZETO TABLETS \"M.T.\""
    },
    {
      "code" : "A017252100",
      "display" : "BROWN MIXTURE TABLETS \"C.T.\""
    },
    {
      "code" : "A017256100",
      "display" : "BETALIN TABLETS (BETAMETHASONE)"
    },
    {
      "code" : "A017279416",
      "display" : "GENTAMICIN EYE DROPS \"GCPC\""
    },
    {
      "code" : "A017279421",
      "display" : "GENTAMICIN EYE DROPS \"GCPC\""
    },
    {
      "code" : "A017280130",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017280137",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017280144",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017280155",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017280180",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017280199",
      "display" : "ULEXIN FOR ORAL SUSPENSION (CEPHALEXIN)"
    },
    {
      "code" : "A017286100",
      "display" : "ETHINYLON S.C. TABLETS \"F.S.\""
    },
    {
      "code" : "A017291100",
      "display" : "Pyston Tablets 250 mg \"Shinlon\" (Mefenamic Acid)"
    },
    {
      "code" : "A017292100",
      "display" : "LITONIN TABLETS (TRIAMCINOLONE)"
    },
    {
      "code" : "A017297100",
      "display" : "DIPHENIDOL S.C. TABLETS \"N.K.\""
    },
    {
      "code" : "A017299100",
      "display" : "Comakin Capsules \"C.L.\""
    },
    {
      "code" : "A017302100",
      "display" : "COUGHXIN TABLET 8MG"
    },
    {
      "code" : "A017303238",
      "display" : "GLUMINE INJECTION (THIAMINE DISULFIDE) \"LITA\""
    },
    {
      "code" : "A017305100",
      "display" : "SILFOAM TABLETS 40MG (SIMETHICONE) \"GCPC\""
    },
    {
      "code" : "A017308100",
      "display" : "KETOPROFEN S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A017313100",
      "display" : "METOCLOPRAMIDE S.C. TABLETS \"C.I.\""
    },
    {
      "code" : "A017315321",
      "display" : "ZEOGEN CREAM \"METRO\""
    },
    {
      "code" : "A017315372",
      "display" : "ZEOGEN CREAM \"METRO\""
    },
    {
      "code" : "A017328100",
      "display" : "DEXTROMETHORPHAN TABLETS 30MG \"HONTEN\""
    },
    {
      "code" : "A0173281G0",
      "display" : "DEXTROMETHORPHAN TABLETS 30MG \"HONTEN\""
    },
    {
      "code" : "A017329100",
      "display" : "CHLOPHEDIANOL CAPSULES \"HONTEN\""
    },
    {
      "code" : "A017331100",
      "display" : "MEFENAMIC ACID CAPSULES \"WINSTON\""
    },
    {
      "code" : "A017335100",
      "display" : "PYRIDOXINE HCL TABLETS \"WST\""
    },
    {
      "code" : "A017341100",
      "display" : "DEXTROMETHORPHAN TABLETS"
    },
    {
      "code" : "A017343100",
      "display" : "DEXTROMETHORPHAN TABLETS 30MG \"EAYUNG\""
    },
    {
      "code" : "A017350212",
      "display" : "DIPYRIDAMOLE INJECTION \"STANDARD\""
    },
    {
      "code" : "A017351100",
      "display" : "INDOCIN E.C. TABLETS 25MG \"CHEN TA\" (INDOMETHACIN)"
    },
    {
      "code" : "A017353100",
      "display" : "N-METHYLSCOPOLAMINE METHYL SULFATE TABLETS \"M.T.\""
    },
    {
      "code" : "A0173531G0",
      "display" : "N-METHYLSCOPOLAMINE METHYL SULFATE TABLETS \"M.T.\""
    },
    {
      "code" : "A017357100",
      "display" : "A-SANTONG TABLETS \"GOLDEN HORSE\""
    },
    {
      "code" : "A017367100",
      "display" : "PILINTON CAPSULES \"F.Y.\""
    },
    {
      "code" : "A017372212",
      "display" : "CLEMASTINE INJECTION \"N.K.\""
    },
    {
      "code" : "A017380100",
      "display" : "TRINON TABLETS (TRIAMCINOLONE) \"VEIMIN\""
    },
    {
      "code" : "A017382100",
      "display" : "NORDRON S.C. TABLETS (NORETHINDRONE)"
    },
    {
      "code" : "A017383100",
      "display" : "ANTICOLD CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A017387100",
      "display" : "SUWELIN TABLETS \"H.L..\""
    },
    {
      "code" : "A017397100",
      "display" : "WAPININ TABLETS (PROPRANOLOL)\"WST\""
    },
    {
      "code" : "A017402100",
      "display" : "SULNIN CAPSULES \"LITA\""
    },
    {
      "code" : "A017412100",
      "display" : "EXPELLING CAPSULES \"TOLIN\""
    },
    {
      "code" : "A017429100",
      "display" : "ISOPRINE S.C. TABLETS (ISOXSUPRINE)"
    },
    {
      "code" : "A017433100",
      "display" : "SULFATRIME TABLETS \"J.H.\""
    },
    {
      "code" : "A017438100",
      "display" : "IBUPROFEN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A017439100",
      "display" : "FLOPROPIONE CAPSULES"
    },
    {
      "code" : "A017441100",
      "display" : "Pitonning Tablets \"Chen Ta\""
    },
    {
      "code" : "A017450100",
      "display" : "TINIDAZOLE TABLETS 500MG \"H.H.\""
    },
    {
      "code" : "A017454423",
      "display" : "RINTERON OPHTHALMIC SOLUTION \"MAY SEE\""
    },
    {
      "code" : "A017482100",
      "display" : "COROMALIN TABLETS \"KUANG NAN\""
    },
    {
      "code" : "A017494212",
      "display" : "GENTAMICIN INJECTION \"S.T.\" 40MG"
    },
    {
      "code" : "A017494229",
      "display" : "GENTAMICIN INJECTION \"S.T.\" 40MG"
    },
    {
      "code" : "A017494238",
      "display" : "GENTAMICIN INJECTION \"S.T.\" 40MG"
    },
    {
      "code" : "A017496100",
      "display" : "VITAMIN K TABLETS 10MG \"CHEN TA\""
    },
    {
      "code" : "A017497100",
      "display" : "ROWELCON S.C. TABLETS (METOCLOPRAMIDE)"
    },
    {
      "code" : "A017498100",
      "display" : "HANTOLINE TABLETS \"Y.C.\" (MECLIZINE)"
    },
    {
      "code" : "A017500100",
      "display" : "NEWKEFOR CAPSULES 250MG (CEPHALEXIN) \"GCPC\""
    },
    {
      "code" : "A017501100",
      "display" : "TENSOL TABLETS \"TA\""
    },
    {
      "code" : "A017502100",
      "display" : "BETAMETHASONE TABLETS \"T.A.\""
    },
    {
      "code" : "A017503100",
      "display" : "CLOMIPHENE TABLETS 50MG\"N.C.P\""
    },
    {
      "code" : "A017504100",
      "display" : "CARBIMAZOLE TABLETS \"KODAK\""
    },
    {
      "code" : "A017507212",
      "display" : "ANSULIN SUSPENDED INJUECTION 40MG \"S.T.\""
    },
    {
      "code" : "A017507229",
      "display" : "ANSULIN SUSPENDED INJUECTION 40MG \"S.T.\""
    },
    {
      "code" : "A017508100",
      "display" : "KNOWFUL CAPSULES (PIRACETAM) \"YUNG SHIN\""
    },
    {
      "code" : "A0175081G0",
      "display" : "KNOWFUL CAPSULES (PIRACETAM) \"YUNG SHIN\""
    },
    {
      "code" : "A017509100",
      "display" : "FUROSEMIDE TABLETS \"M.T.\""
    },
    {
      "code" : "A017527100",
      "display" : "CHOZON TABLETS 50MG\"N.C.P\""
    },
    {
      "code" : "A017530100",
      "display" : "KETOPROFEN CAPSULES \"F.S.\""
    },
    {
      "code" : "A017534100",
      "display" : "DRIED ALUMINUM HYDROXIDE GEL TABLETS 300MG \"C.T.\""
    },
    {
      "code" : "A017537209",
      "display" : "ESTRAMON INJECTION \"Y.Y.\""
    },
    {
      "code" : "A017538209",
      "display" : "RESERPINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A017543100",
      "display" : "Coldex Capsules"
    },
    {
      "code" : "A017545100",
      "display" : "ANTONE TABLETS 500MG\"D.T.S\""
    },
    {
      "code" : "A017547100",
      "display" : "COPYRIN CAPSULES \"CBC\""
    },
    {
      "code" : "A017550100",
      "display" : "PHENTON S.C. TABLETS"
    },
    {
      "code" : "A017561100",
      "display" : "SEKUTON TABLETS"
    },
    {
      "code" : "A017564212",
      "display" : "SULSCOPAN INJECTION \"TAI YU\""
    },
    {
      "code" : "A017568100",
      "display" : "ASTHAN S.C. TABLETS \"Y.Y\""
    },
    {
      "code" : "A017573100",
      "display" : "DICOROL S.C. TABLETS \"C.R.\"(DIPYRIDAMOLE)"
    },
    {
      "code" : "A017582100",
      "display" : "SKEDESIN TABLETS (METHOCARBAMOL) \"H.H.\""
    },
    {
      "code" : "A017588100",
      "display" : "DEXCHLORPHENIRAMINE MALEATE TABLETS 2MG"
    },
    {
      "code" : "A017594100",
      "display" : "RIFAMPIN CAPSULES 300MG"
    },
    {
      "code" : "A017621100",
      "display" : "ALON CAPSULES"
    },
    {
      "code" : "A017624100",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS \"HONTEN\""
    },
    {
      "code" : "A017628100",
      "display" : "STOPIN TABLETS (METHYL-SCOPOLAMINE METHYL SULFATE)"
    },
    {
      "code" : "A017632100",
      "display" : "CALVAMOX TABLETS \"S.C.\" (MEBENDAZOLE)"
    },
    {
      "code" : "A017633100",
      "display" : "COLD TABLETS \"C.C.P.\""
    },
    {
      "code" : "A017691100",
      "display" : "ORCIPRENALINE TABLETS"
    },
    {
      "code" : "A017701100",
      "display" : "BROMELAIN ENTERIC S.C. TABLETS"
    },
    {
      "code" : "A017704100",
      "display" : "TRANCOLIN S.C. TABLETS"
    },
    {
      "code" : "A017705277",
      "display" : "DEXTROSE INJECTION 25％ \"CHI SHENG\""
    },
    {
      "code" : "A017706100",
      "display" : "POLYTHIOCTAN S.C. TABLETS \"M.S.\""
    },
    {
      "code" : "A017707100",
      "display" : "COBAMAMIDE TABLETS \"C.I.\""
    },
    {
      "code" : "A017709100",
      "display" : "DIISOPROPYLAMINE DICHLOROACETATE S.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A017711212",
      "display" : "VILITOMIN INJECTION"
    },
    {
      "code" : "A017712209",
      "display" : "CEFAZOLIN INJECTION 1GM \"C.C.P.\""
    },
    {
      "code" : "A017712343",
      "display" : "CEFAZOLIN INJECTION 1GM \"C.C.P.\""
    },
    {
      "code" : "A017713100",
      "display" : "MEBENDAZOLE TABLETS \"LITA\""
    },
    {
      "code" : "A017715100",
      "display" : "SOTHICON TABLETS \"N.K.\""
    },
    {
      "code" : "A017719209",
      "display" : "ULOTHIN INJECTION 1GM (CEPHALOTHIN)"
    },
    {
      "code" : "A017722100",
      "display" : "KALVITAZON TABLETS (ETILEFRINE HCL)"
    },
    {
      "code" : "A017723100",
      "display" : "MEBENDAZOLE TABLETS \"Y.K.\""
    },
    {
      "code" : "A017728100",
      "display" : "SULONTIN TABLETS (SULFAMETHOXAZOLE) \"C.I.\""
    },
    {
      "code" : "A017730321",
      "display" : "BECA-A CREAM (BETAMATHASONE) \"C.R.\""
    },
    {
      "code" : "A017732100",
      "display" : "SUWEI TABLETS \"S.T.\""
    },
    {
      "code" : "A017733435",
      "display" : "SWININ NASAL SOLUTION (OXYMETAZOLINE)"
    },
    {
      "code" : "A017735100",
      "display" : "SUWALIN TABLETS \"P.L.\""
    },
    {
      "code" : "A017737100",
      "display" : "UGININ TABLETS (DIPYRIDAMOLE)"
    },
    {
      "code" : "A017793100",
      "display" : "SALBUTAMOL TABLETS \"C.S.\""
    },
    {
      "code" : "A017794100",
      "display" : "PREDNISOLONE TABLETS \"L.S.\""
    },
    {
      "code" : "A017795321",
      "display" : "SOFT CREAM"
    },
    {
      "code" : "A017795329",
      "display" : "SOFT CREAM"
    },
    {
      "code" : "A017795335",
      "display" : "SOFT CREAM"
    },
    {
      "code" : "A017795338",
      "display" : "SOFT CREAM"
    },
    {
      "code" : "A017795399",
      "display" : "SOFT CREAM"
    },
    {
      "code" : "A017799100",
      "display" : "PAPAVERINE HCL TABLETS 30MG \"HONTEN\""
    },
    {
      "code" : "A017800100",
      "display" : "RESERPINE TABLETS \"METRO\""
    },
    {
      "code" : "A017805229",
      "display" : "KANAMYCIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A017805238",
      "display" : "KANAMYCIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A017805299",
      "display" : "KANAMYCIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A017806118",
      "display" : "PANCOUDENIN SYRUP \"PANBIOTIC\""
    },
    {
      "code" : "A017806157",
      "display" : "PANCOUDENIN SYRUP \"PANBIOTIC\""
    },
    {
      "code" : "A017806199",
      "display" : "PANCOUDENIN SYRUP \"PANBIOTIC\""
    },
    {
      "code" : "A017809100",
      "display" : "NOSCOUGH TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0178091G0",
      "display" : "NOSCOUGH TABLETS \"CHINTENG\""
    },
    {
      "code" : "A017818100",
      "display" : "SU JI PIN TABLETS \"TK&A\" (CHLORMEZANONE)"
    },
    {
      "code" : "A017820100",
      "display" : "ERGONOVINE MALEATE TABLETS \"J.C.S.\""
    },
    {
      "code" : "A017827100",
      "display" : "THIAMINE HYDROCHLORIDE TABLETS \"METRO\""
    },
    {
      "code" : "A017829100",
      "display" : "FUROSIN TABLETS (FUROSEMIDE)\"N.C.P.\""
    },
    {
      "code" : "A017833277",
      "display" : "CEFAZOLIN INJECTION"
    },
    {
      "code" : "A017842100",
      "display" : "TUTON TABLETS \"Y.S.\""
    },
    {
      "code" : "A017847277",
      "display" : "VOLEX INJECTION"
    },
    {
      "code" : "A017857100",
      "display" : "DE-ASTHMA TABLETS \"H.S.\""
    },
    {
      "code" : "A017859100",
      "display" : "AMPICILLIN CAPSULES 500MG \"SYNMOSA\""
    },
    {
      "code" : "A017860100",
      "display" : "ZEMIN TABLETS \"PANBIOTIC\"(CLEMASTINE FUMARATE)"
    },
    {
      "code" : "A017862100",
      "display" : "ETHYLPAPAVERINE HYDROCHLORIDE TABLETS 100MG \"F.S.\""
    },
    {
      "code" : "A017863100",
      "display" : "SINOPRIN TABLETS \"SHIN FONG\""
    },
    {
      "code" : "A017864100",
      "display" : "TOFEN CAPSULES (KETOPROFEN)\"CHINTENG\""
    },
    {
      "code" : "A017866100",
      "display" : "SPARTIN TABLETS"
    },
    {
      "code" : "A017868100",
      "display" : "SUWIMIN TABLETS  \"CHEN TA\"(DICYCLOMINE)"
    },
    {
      "code" : "A017869100",
      "display" : "PREDNISOLONE TABLETS"
    },
    {
      "code" : "A017872212",
      "display" : "YUOSINCIN INJECTION \"S.Y.\"(DIPYRIDAMOLE)"
    },
    {
      "code" : "A017873100",
      "display" : "FONSUCAINE TABLETS \"Y.Y.\""
    },
    {
      "code" : "A017874100",
      "display" : "Setacin E.M CAPSULES"
    },
    {
      "code" : "A017877100",
      "display" : "COSUTONE TABLETS \"H.H.\""
    },
    {
      "code" : "A017880416",
      "display" : "GENTAMYCIN OPHTHALMIC SOLUTION \"SHIONOGI\""
    },
    {
      "code" : "A017880421",
      "display" : "GENTAMYCIN OPHTHALMIC SOLUTION \"SHIONOGI\""
    },
    {
      "code" : "A017881321",
      "display" : "GENTAMYCIN CREAM \"SHIONOGI\""
    },
    {
      "code" : "A017882118",
      "display" : "UNITUSSIN SYRUP \" CENTER\""
    },
    {
      "code" : "A017882155",
      "display" : "UNITUSSIN SYRUP \" CENTER\""
    },
    {
      "code" : "A017882163",
      "display" : "UNITUSSIN SYRUP \" CENTER\""
    },
    {
      "code" : "A017882199",
      "display" : "UNITUSSIN SYRUP \" CENTER\""
    },
    {
      "code" : "A017883100",
      "display" : "SEDON TABLETS"
    },
    {
      "code" : "A017887100",
      "display" : "COBAMAMIDE CAPSULES \"Y.C.\""
    },
    {
      "code" : "A0178871G0",
      "display" : "COBAMAMIDE CAPSULES \"Y.C.\""
    },
    {
      "code" : "A017890100",
      "display" : "SELADIN CAPSULES"
    },
    {
      "code" : "A017919209",
      "display" : "TESTOSTERONE CYPIONATE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A017945100",
      "display" : "PANGAMINE S.C. TABLETS 20MG (DIISOPROPYLAMINE)\"F.S.\""
    },
    {
      "code" : "A017950100",
      "display" : "FANTONCHU TABLETS"
    },
    {
      "code" : "A017958100",
      "display" : "DICYCLOMINE TABLETS"
    },
    {
      "code" : "A017959100",
      "display" : "ASTAMOL TABLETS  \"Y.K.\""
    },
    {
      "code" : "A017960100",
      "display" : "PHENOZOLATE TABLETS \"H.S.\""
    },
    {
      "code" : "A017961100",
      "display" : "ACETOZANONE TABLETS \"TK&A\""
    },
    {
      "code" : "A017965100",
      "display" : "CINNARANE TABLETS (CINNARIZINE) \"K.B.\""
    },
    {
      "code" : "A017966100",
      "display" : "Commoncold Capsules \"Y.K.\""
    },
    {
      "code" : "A017980100",
      "display" : "ERGONOVINE MALEATE TABLETS 0.5MG \"CHEN TA\""
    },
    {
      "code" : "A017984100",
      "display" : "METOCLOPRAMIDE TABALETS \"Y.K.\""
    },
    {
      "code" : "A017985100",
      "display" : "FUROSEMIDE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A017986212",
      "display" : "FUROSEMIDE INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A017994100",
      "display" : "DIANLIN TABLETS (DIAZEPAM) \"N.K.\""
    },
    {
      "code" : "A017997100",
      "display" : "PROFENADD CAPSULES \"SHIN FONG\" (KETOPROFEN)"
    },
    {
      "code" : "A018006100",
      "display" : "DIPHACOL S.C. TABLETS \"S.C.\" (DIPHENIDOL)"
    },
    {
      "code" : "A018023321",
      "display" : "FUNGIDERMA CREAM"
    },
    {
      "code" : "A018023329",
      "display" : "FUNGIDERMA CREAM"
    },
    {
      "code" : "A018023377",
      "display" : "FUNGIDERMA CREAM"
    },
    {
      "code" : "A018023399",
      "display" : "FUNGIDERMA CREAM"
    },
    {
      "code" : "A018037100",
      "display" : "DIPHENIDOL TABLETS \"P.L.\""
    },
    {
      "code" : "A018048212",
      "display" : "VITAMIN BC INJECTION \"LITA\""
    },
    {
      "code" : "A018051100",
      "display" : "HALOSTEN TABLETS 1MG (HALOPERIDOL)"
    },
    {
      "code" : "A018053321",
      "display" : "SWISSCORT CREAM"
    },
    {
      "code" : "A018053399",
      "display" : "SWISSCORT CREAM"
    },
    {
      "code" : "A018061100",
      "display" : "COPHYLLINE TABLETS"
    },
    {
      "code" : "A018062100",
      "display" : "\"O.Y.\"CHUNBIK TABLETS (MEBENDAZOLE)"
    },
    {
      "code" : "A018063316",
      "display" : "TOPSYM CREAM (FLUOCINONIDE)"
    },
    {
      "code" : "A018063321",
      "display" : "TOPSYM CREAM (FLUOCINONIDE)"
    },
    {
      "code" : "A018063329",
      "display" : "TOPSYM CREAM (FLUOCINONIDE)"
    },
    {
      "code" : "A018063338",
      "display" : "TOPSYM CREAM (FLUOCINONIDE)"
    },
    {
      "code" : "A018064100",
      "display" : "MEDAZOLE TABLETS \"SHIN FONG\" (MEBENDAZOLE)"
    },
    {
      "code" : "A018069100",
      "display" : "ANCOTON TABLETS (ACETAMINOPHEN)"
    },
    {
      "code" : "A018086100",
      "display" : "CAMYLOFIN S.C. TABLETS \"TEN SUN\""
    },
    {
      "code" : "A018088321",
      "display" : "TOPSYM OINTMENT (FLUOCINONIDE)"
    },
    {
      "code" : "A018088338",
      "display" : "TOPSYM OINTMENT (FLUOCINONIDE)"
    },
    {
      "code" : "A018089100",
      "display" : "TINIDAZOLE CAPSULES 150MG \"P.J.\""
    },
    {
      "code" : "A018091100",
      "display" : "METHON TABLETS 15MG"
    },
    {
      "code" : "A018092100",
      "display" : "CINNARIZINE TABLETS \"EVEREST\""
    },
    {
      "code" : "A018095100",
      "display" : "WEIPINTIN TABLETS \"S.T.\""
    },
    {
      "code" : "A018097100",
      "display" : "KETOPROFEN CAPSULES \"M.T.\""
    },
    {
      "code" : "A018098110",
      "display" : "SUPERCILLIN POWDER FOR ORAL SUSPENSION \"VPP\""
    },
    {
      "code" : "A018098191",
      "display" : "SUPERCILLIN POWDER FOR ORAL SUSPENSION \"VPP\""
    },
    {
      "code" : "A018098199",
      "display" : "SUPERCILLIN POWDER FOR ORAL SUSPENSION \"VPP\""
    },
    {
      "code" : "A018100100",
      "display" : "DELUGI TABLETS \"WP\" (NALIDIXIC ACID)"
    },
    {
      "code" : "A018107100",
      "display" : "ALUCON TABLETS \"P.J.\""
    },
    {
      "code" : "A018132100",
      "display" : "WETUNLIN TABLETS \"S.Y.\""
    },
    {
      "code" : "A018133100",
      "display" : "BENTOLIN TABLETS 4MG (SALBUTAMOL)\"F.S.\""
    },
    {
      "code" : "A018136100",
      "display" : "ACETAMINOPHEN TABLETS \"Y.S.\""
    },
    {
      "code" : "A018139100",
      "display" : "NITROFURANTOIN TABLETS \"WINSTON\""
    },
    {
      "code" : "A018153100",
      "display" : "BETAMETHASONE TABLETS \"B.C.\""
    },
    {
      "code" : "A018155100",
      "display" : "BUCLIZINE TABLETS \"P.J.\""
    },
    {
      "code" : "A018157329",
      "display" : "Crolax-H Cream"
    },
    {
      "code" : "A018157377",
      "display" : "Crolax-H Cream"
    },
    {
      "code" : "A018157399",
      "display" : "Crolax-H Cream"
    },
    {
      "code" : "A018158100",
      "display" : "ELICE TABLETS \"STANDARD\""
    },
    {
      "code" : "A018160100",
      "display" : "DEHYDRI S.C. TABLETS \"P.J.\""
    },
    {
      "code" : "A018162100",
      "display" : "PAINTYL TABLETS \"P.J.\""
    },
    {
      "code" : "A018171100",
      "display" : "WEICOLA TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0181711G0",
      "display" : "WEICOLA TABLETS \"CHINTENG\""
    },
    {
      "code" : "A018176100",
      "display" : "SUFUCON CAPSULES \"S.D.\""
    },
    {
      "code" : "A018180100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"P.J.\""
    },
    {
      "code" : "A018183100",
      "display" : "RELAPINE TABLETS \"C.H.\""
    },
    {
      "code" : "A018184100",
      "display" : "NEUROVITAN F.C. TABLETS"
    },
    {
      "code" : "A018188100",
      "display" : "FLOXESTRON CAPSULES (FLUOXYMESTERONE) \"P.J.\""
    },
    {
      "code" : "A018193100",
      "display" : "HOMSHIPEN CAPSULES"
    },
    {
      "code" : "A018195118",
      "display" : "Bromtapp Liquid \"P.J\""
    },
    {
      "code" : "A018195151",
      "display" : "Bromtapp Liquid \"P.J\""
    },
    {
      "code" : "A018195157",
      "display" : "Bromtapp Liquid \"P.J\""
    },
    {
      "code" : "A018195199",
      "display" : "Bromtapp Liquid \"P.J\""
    },
    {
      "code" : "A018202332",
      "display" : "DISCO EYE FROP \"C.R.\""
    },
    {
      "code" : "A018204212",
      "display" : "SEQUITON INJECTION"
    },
    {
      "code" : "A018208238",
      "display" : "COPOLAMIN-B 12 INJECTION \"N.K.\""
    },
    {
      "code" : "A018219100",
      "display" : "SNIFCON TABLETS \"P.J.\""
    },
    {
      "code" : "A018220100",
      "display" : "SAMOL TABLETS (SALBUTAMOL) \"T.F.\""
    },
    {
      "code" : "A018224100",
      "display" : "LOWE TABLETS \"N.K.\""
    },
    {
      "code" : "A018229100",
      "display" : "ULWELOR TABLETS \"P.J.\""
    },
    {
      "code" : "A018231100",
      "display" : "MEPENZOL TABLETS \"ATOBI\""
    },
    {
      "code" : "A018232100",
      "display" : "SUSEMIDE TABLETS (HYDRALAZINE) \"H.C.\""
    },
    {
      "code" : "A018237100",
      "display" : "SOFTCOUGH CAPSULES \"PANBITOTIC\""
    },
    {
      "code" : "A018238100",
      "display" : "EUSOLEN CAPSULES (TOCOPHERYL NICOTINATE) \"N.W\""
    },
    {
      "code" : "A018240100",
      "display" : "PHENYTOIN TABLETS 100MG \"VPC\""
    },
    {
      "code" : "A0182401G0",
      "display" : "PHENYTOIN TABLETS 100MG \"VPC\""
    },
    {
      "code" : "A018244100",
      "display" : "KLISTMIN TABLETS (CARBINOXAMINS)"
    },
    {
      "code" : "A018249100",
      "display" : "PRONOLOL TABLETS 20MG (PROPRANOLOL)"
    },
    {
      "code" : "A018250100",
      "display" : "PRONOLOL TABLETS 40MG (PROPRANOLOL)"
    },
    {
      "code" : "A0182501G0",
      "display" : "PRONOLOL TABLETS 40MG (PROPRANOLOL)"
    },
    {
      "code" : "A018251100",
      "display" : "PRONOLOL TABLETS 10MG (PROPRANOLOL)"
    },
    {
      "code" : "A0182511G0",
      "display" : "PRONOLOL TABLETS 10MG (PROPRANOLOL)"
    },
    {
      "code" : "A018255209",
      "display" : "U-GENCIN INJECTION 40MG/ML (GENTAMYCIN)"
    },
    {
      "code" : "A018255212",
      "display" : "U-GENCIN INJECTION 40MG/ML (GENTAMYCIN)"
    },
    {
      "code" : "A018267100",
      "display" : "KETOPRFEN CAPSULES \"M.S.\""
    },
    {
      "code" : "A018270100",
      "display" : "COLDLAX CAPSULES \"JINUP\""
    },
    {
      "code" : "A018274118",
      "display" : "ETHAMSYLATE INJECTION \"LITA\""
    },
    {
      "code" : "A018274199",
      "display" : "ETHAMSYLATE INJECTION \"LITA\""
    },
    {
      "code" : "A018277118",
      "display" : "DECOFEN SOLUTION \"VPP\""
    },
    {
      "code" : "A018277156",
      "display" : "DECOFEN SOLUTION \"VPP\""
    },
    {
      "code" : "A018277199",
      "display" : "DECOFEN SOLUTION \"VPP\""
    },
    {
      "code" : "A018279100",
      "display" : "HON-DAN-AN CAPSULES (FLOPROPIONE)"
    },
    {
      "code" : "A018281100",
      "display" : "HUGALIN S.C. TABLETS (DIISOPROPYLAMINE DICHLOROACETATE) \"H.H.\""
    },
    {
      "code" : "A018282100",
      "display" : "SEPRONIN CAPSULES (KETOPROFEN) \"SHITEH\""
    },
    {
      "code" : "A018291212",
      "display" : "GENTA-C INJECTION 40MG/ML \"GENTLE\""
    },
    {
      "code" : "A018292100",
      "display" : "COMCODENE TABLETS \"F.S.\""
    },
    {
      "code" : "A018296100",
      "display" : "SUBILIN TABLETS"
    },
    {
      "code" : "A018304100",
      "display" : "SEDONIN TABLETS (DIAZEPAM) \"SHIN FONG\""
    },
    {
      "code" : "A018315100",
      "display" : "OROMIN S.C. TABLETS \"T.A.\""
    },
    {
      "code" : "A018316100",
      "display" : "ACETAMINOPHEN TABLETS 325MG \"T.A.\""
    },
    {
      "code" : "A018322321",
      "display" : "GENDERON CREAM \"PATRON\""
    },
    {
      "code" : "A018322329",
      "display" : "GENDERON CREAM \"PATRON\""
    },
    {
      "code" : "A018322399",
      "display" : "GENDERON CREAM \"PATRON\""
    },
    {
      "code" : "A018331100",
      "display" : "SALBUTAMOL TABLETS \"HONTEN\""
    },
    {
      "code" : "A018332100",
      "display" : "NOVAZIL TABLETS \"F.B\""
    },
    {
      "code" : "A0183321G0",
      "display" : "NOVAZIL TABLETS \"F.B\""
    },
    {
      "code" : "A018336100",
      "display" : "KENACORT TABLETS (TRIAMCINOLONE)\"Y.Y.\""
    },
    {
      "code" : "A018340100",
      "display" : "SPASCHOL CAPSULES (FLOPROPIONE) \"SHIN FONG\""
    },
    {
      "code" : "A018342100",
      "display" : "LOBAK TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0183421G0",
      "display" : "LOBAK TABLETS \"CHINTENG\""
    },
    {
      "code" : "A018343329",
      "display" : "BETASONE CREAM \"PRINCE\""
    },
    {
      "code" : "A018347329",
      "display" : "NERISONE CREAM"
    },
    {
      "code" : "A018347343",
      "display" : "NERISONE CREAM"
    },
    {
      "code" : "A018348329",
      "display" : "NERISONE OINTMENT"
    },
    {
      "code" : "A018349329",
      "display" : "NERISONE FATTY OINTMENT"
    },
    {
      "code" : "A018350329",
      "display" : "NERISONE C CREAM"
    },
    {
      "code" : "A018352100",
      "display" : "RUBAC TABLETS \"KINGDOM\""
    },
    {
      "code" : "A018353100",
      "display" : "PRESON TABLETS (PREDNISOLONE) \"VEIMIN\""
    },
    {
      "code" : "A018358100",
      "display" : "NURCOUGH TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A018361100",
      "display" : "CO COLD S.C. TABLETS \"N.C.P\""
    },
    {
      "code" : "A018362100",
      "display" : "TINIDAZOLE TABLETS \"N.W.\""
    },
    {
      "code" : "A018365100",
      "display" : "ANTAGEL II TABLETS \"GCPC\""
    },
    {
      "code" : "A018373100",
      "display" : "TATONLIN CAPSULES \"Y.S.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A018379209",
      "display" : "DIPHENHYDRAMINE INJECTION \"METRO\""
    },
    {
      "code" : "A018381100",
      "display" : "COLSUN CAPSULES \"S.T.\""
    },
    {
      "code" : "A018394100",
      "display" : "ILIYA TABLETS (TRICHLORMETHIAZIDE)\"CURIE\""
    },
    {
      "code" : "A018397100",
      "display" : "MEXASONE TABLETS \"SHIN FONG\" (DEXAMETHASONE)"
    },
    {
      "code" : "A018401100",
      "display" : "GASTRODYN TABLETS (GLYCOPYRROLATE)\"JOHNSON\""
    },
    {
      "code" : "A018402100",
      "display" : "CLEMASTINE TABLETS \"CURIE\""
    },
    {
      "code" : "A018404100",
      "display" : "TENWEILIN TABLETS \"PRINCE\""
    },
    {
      "code" : "A018405100",
      "display" : "LIVERSTAL S.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A018406100",
      "display" : "CINNARIZINE TABLETS \"C.H.\""
    },
    {
      "code" : "A018411100",
      "display" : "MEBENDAZOLE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A018413238",
      "display" : "TRITAMIN B12 INJECTION \"LITA\""
    },
    {
      "code" : "A018414100",
      "display" : "CONGEN OUTWORM TABLETS (MEBENDAZOLE) \"C.M.\""
    },
    {
      "code" : "A018415318",
      "display" : "CALAMINE LOTION \"WP.\""
    },
    {
      "code" : "A018415399",
      "display" : "CALAMINE LOTION \"WP.\""
    },
    {
      "code" : "A018416100",
      "display" : "Shi-de-jian S.C. Tablets \"M.T.\""
    },
    {
      "code" : "A018421100",
      "display" : "AZULENE TABLETS \"S.T.\""
    },
    {
      "code" : "A018424212",
      "display" : "ASCORBIC ACID INJECTION 500MG \"SWISS\""
    },
    {
      "code" : "A018425100",
      "display" : "MEBENDAZOLE TABLETS \"WINSTON\""
    },
    {
      "code" : "A018430100",
      "display" : "SUYALIN TABLETS 25MG (HYDRALRZINE) \"ASTAR\""
    },
    {
      "code" : "A018432100",
      "display" : "ACETAMINOPHEN TABLETS \"WINSTON\""
    },
    {
      "code" : "A018433100",
      "display" : "ACTIVE-B6 CAPSULES (PYRIDOXAL PHOSPHATE)\"CHINTENG\""
    },
    {
      "code" : "A018434100",
      "display" : "TRIAMCINOLONE TABLETS \"MERDER\""
    },
    {
      "code" : "A018437309",
      "display" : "BATASONE CREAM \"L.S.\""
    },
    {
      "code" : "A018437321",
      "display" : "BATASONE CREAM \"L.S.\""
    },
    {
      "code" : "A018437329",
      "display" : "BATASONE CREAM \"L.S.\""
    },
    {
      "code" : "A018437338",
      "display" : "BATASONE CREAM \"L.S.\""
    },
    {
      "code" : "A018437399",
      "display" : "BATASONE CREAM \"L.S.\""
    },
    {
      "code" : "A018444100",
      "display" : "CABIDRIN FILM COATED TABLETS \"JOHNSON\""
    },
    {
      "code" : "A0184441G0",
      "display" : "CABIDRIN FILM COATED TABLETS \"JOHNSON\""
    },
    {
      "code" : "A018448100",
      "display" : "SUYALIN TABLETS 10MG (HYDRALAZINE) \"ASTAR\""
    },
    {
      "code" : "A018451100",
      "display" : "G.P.D. CAPSULES \"HEALTH\""
    },
    {
      "code" : "A018458100",
      "display" : "PROSANOL TABLETS (PROPRANOLOL)"
    },
    {
      "code" : "A018460100",
      "display" : "BUU SHIEE VITAMINE CAPSULES \"H.S.\" (COBAMAMIDE)"
    },
    {
      "code" : "A018461100",
      "display" : "DAGYN CAPSULES (TINIDAZOLE)"
    },
    {
      "code" : "A018463100",
      "display" : "PSEUDOEPHEDRINE HYDROCHLORIDE TABLETS"
    },
    {
      "code" : "A018467100",
      "display" : "HALOSTEN TABLETS 2MG (HALOPERIDOL)"
    },
    {
      "code" : "A018471321",
      "display" : "GENTAMYCIN OINTMENT \"SHIONOGI\""
    },
    {
      "code" : "A018479100",
      "display" : "PELON CAPSULES (TOCOPHEROL NICOTINATE) \"F.S.\""
    },
    {
      "code" : "A018498100",
      "display" : "PISANTONG TABLETS \"CHINTENG\""
    },
    {
      "code" : "A018506100",
      "display" : "GUADESIN TABLETS (GLYCERYL GUAIACOLATE) \"C.R.\""
    },
    {
      "code" : "A018507209",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION \"H.S.C.\""
    },
    {
      "code" : "A018507212",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION \"H.S.C.\""
    },
    {
      "code" : "A018511100",
      "display" : "VITAMIN B2 TABLETS \"METRO\""
    },
    {
      "code" : "A018514372",
      "display" : "PEIJISONE CREAM (BETAMETHASONE) \"ATOBI\""
    },
    {
      "code" : "A018514399",
      "display" : "PEIJISONE CREAM (BETAMETHASONE) \"ATOBI\""
    },
    {
      "code" : "A018515100",
      "display" : "CLOPRENALINE TABLETS \"C.P.\""
    },
    {
      "code" : "A018519209",
      "display" : "PROMIN INJECTION \"N.K.\""
    },
    {
      "code" : "A018519265",
      "display" : "PROMIN INJECTION \"N.K.\""
    },
    {
      "code" : "A018519277",
      "display" : "PROMIN INJECTION \"N.K.\""
    },
    {
      "code" : "A018522100",
      "display" : "BALLEKA S.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A018529100",
      "display" : "RIFAMIN CAPSULES 300MG (RIFAMPICIN)\"SHITEH\""
    },
    {
      "code" : "A018530212",
      "display" : "CILLIC INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A018530238",
      "display" : "CILLIC INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A018543100",
      "display" : "ELICAN S.C. TABLETS (ANETHOLE) \"N.K.\""
    },
    {
      "code" : "A018554100",
      "display" : "RESCINNAMINE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A018555100",
      "display" : "PUNORTOR TABLETS  \"PANBIOTIC\" (ACETAMINOPHEN)"
    },
    {
      "code" : "A018559100",
      "display" : "LONZUMIN TABLETS  \"STANDARD\"(BUCLIZINE)"
    },
    {
      "code" : "A018561100",
      "display" : "LEAF TABLETS \"LONG DER\""
    },
    {
      "code" : "A018565212",
      "display" : "PACOUGH INJECTION \"PATRON\""
    },
    {
      "code" : "A018568100",
      "display" : "NEOSTIGMINE BROMIDE TABLETS \"C.T.\""
    },
    {
      "code" : "A018569100",
      "display" : "SPIROTONE TABLETS 25MG (SPIRONOLACTONE) \"V.P.P.\""
    },
    {
      "code" : "A0185691G0",
      "display" : "SPIROTONE TABLETS 25MG (SPIRONOLACTONE) \"V.P.P.\""
    },
    {
      "code" : "A018570100",
      "display" : "MYOLAX TABLETS 500MG (METHOCARBAMOL) \"VPP\""
    },
    {
      "code" : "A018572100",
      "display" : "KETOPROFEN CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A018573100",
      "display" : "AMILO TABLETS 10MG\"N.C.P\""
    },
    {
      "code" : "A018587100",
      "display" : "PSEUDOEPHEDRINE HCL TABLETS \"T.A.\""
    },
    {
      "code" : "A018589209",
      "display" : "NEO-ERGO INJECTION \"ORIENTAL\""
    },
    {
      "code" : "A018592100",
      "display" : "ECAN CAPSULES 25 mg\"S.D.\"(ANETHOLE)"
    },
    {
      "code" : "A018597500",
      "display" : "HEMODIN SUPPOSITORIES"
    },
    {
      "code" : "A018598329",
      "display" : "HEMODIN OINTMENT \"PATRON\""
    },
    {
      "code" : "A018600100",
      "display" : "RITHION CAPSULES \"CHINTENG\" (PYRITHIOXINE)"
    },
    {
      "code" : "A018605209",
      "display" : "PABICON INJECTION \"PATRON\""
    },
    {
      "code" : "A018608100",
      "display" : "SHIN T'E KAN MAO TABLETS \"MAY SEE\""
    },
    {
      "code" : "A018609100",
      "display" : "ANALGESIC TABLETS 500MG \"SOURIREE\" (ACETAMINOPHEN)"
    },
    {
      "code" : "A018620100",
      "display" : "UNDIARRHEA CAPSULES (LOPERAMIDE) \"YUNG SHIN\""
    },
    {
      "code" : "A018621100",
      "display" : "ERGOCAINE TABLETS \"C.R.\""
    },
    {
      "code" : "A018626100",
      "display" : "STOKLE TABLETS 50MG \"Y.S.\""
    },
    {
      "code" : "A018637100",
      "display" : "COLAC E.S.C. TABLETS \"F.B\""
    },
    {
      "code" : "A018638100",
      "display" : "Sujnli Tablets \"Chen Ta\""
    },
    {
      "code" : "A018640100",
      "display" : "TIZOL CAPSULES 500MG \"SHIN FONG\" (TINIDAZOLE)"
    },
    {
      "code" : "A018644355",
      "display" : "POLVIDINE SOLUTION 10％"
    },
    {
      "code" : "A018644363",
      "display" : "POLVIDINE SOLUTION 10％"
    },
    {
      "code" : "A018646100",
      "display" : "Diphenidol F.C. Tablets \"H.S.\""
    },
    {
      "code" : "A0186461G0",
      "display" : "Diphenidol F.C. Tablets \"H.S.\""
    },
    {
      "code" : "A018648100",
      "display" : "KORYNASE E.C. TABLETS 10MG"
    },
    {
      "code" : "A018649100",
      "display" : "KORYNASE E.C. TABLETS 5MG"
    },
    {
      "code" : "A018650100",
      "display" : "LIPOTECON CAPSULES \"GENTLE\""
    },
    {
      "code" : "A018654100",
      "display" : "COFFEGOT TABLETS \"Y.Y.\""
    },
    {
      "code" : "A018657100",
      "display" : "ALLOPURINOL TABLETS \"SHIN FONG\""
    },
    {
      "code" : "A018658100",
      "display" : "INDOMETHACIN CAPSULES \"SHIN FONG\""
    },
    {
      "code" : "A018659100",
      "display" : "ACETAMINOPHEN TABLETS \"S.Y.\""
    },
    {
      "code" : "A018660100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"C.L.\""
    },
    {
      "code" : "A018664100",
      "display" : "PROPRANOLOL TABLETS \"Y.S.\""
    },
    {
      "code" : "A018665100",
      "display" : "LINPEMYCIN CAPSULES 500MG (AMPICILLIN)"
    },
    {
      "code" : "A018668100",
      "display" : "SIPEMIN TABALETS \"VEIMIN\""
    },
    {
      "code" : "A018669212",
      "display" : "BETAMETHASONE SUSPENDED INJECTION \"GENTLE\""
    },
    {
      "code" : "A018670209",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"GENTLE\""
    },
    {
      "code" : "A018670229",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"GENTLE\""
    },
    {
      "code" : "A018671100",
      "display" : "RIMANCIN CAPSULES 300MG \"CYC\" (RIFAMPICIN)"
    },
    {
      "code" : "A018672100",
      "display" : "RIMANCIN CAPSULES 450MG (RIFAMPICIN) \"CYC\""
    },
    {
      "code" : "A018678100",
      "display" : "BIDICON TABLETS (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A018679209",
      "display" : "DEXAMETHASONE INJECTION 0.5％"
    },
    {
      "code" : "A018680100",
      "display" : "IRTONPYSON S.C. TABLETS (PHENYLBUTAZONE)"
    },
    {
      "code" : "A018685121",
      "display" : "VIBRAMYCIN GRANULES FOR ORAL SUSPENSION 50MG/GM"
    },
    {
      "code" : "A018690100",
      "display" : "MACEN TABLETS (MEDAZEPAM) \"P.L.\""
    },
    {
      "code" : "A018692100",
      "display" : "MEBENDAZOLE TABLETS \"M.T.\""
    },
    {
      "code" : "A0186921G0",
      "display" : "MEBENDAZOLE TABLETS \"M.T.\""
    },
    {
      "code" : "A018694209",
      "display" : "ATROPINE SULFATE INJECTION 1MG/ML \"VPP\""
    },
    {
      "code" : "A018696100",
      "display" : "BIDYL E.S.C. TABLETS"
    },
    {
      "code" : "A018700100",
      "display" : "FUNGACIN CAPSULES 500MG (GRISEOFULVIN) \"P.J\""
    },
    {
      "code" : "A018705100",
      "display" : "ALLOPRIM TABLETS \"SL\"(ALLOPURINOL)"
    },
    {
      "code" : "A018719100",
      "display" : "IMIMINE S.C. TABLETS 25MG"
    },
    {
      "code" : "A0187191G0",
      "display" : "IMIMINE S.C. TABLETS 25MG"
    },
    {
      "code" : "A018721100",
      "display" : "WEINA TABLETS (BETAHISTINE) \"CBC\""
    },
    {
      "code" : "A018726100",
      "display" : "GU YEN TABLETS \"T.F.\""
    },
    {
      "code" : "A0187261G0",
      "display" : "GU YEN TABLETS \"T.F.\""
    },
    {
      "code" : "A018727100",
      "display" : "NALIDIXIC ACID TABLETS"
    },
    {
      "code" : "A018734212",
      "display" : "BERBERINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A018739100",
      "display" : "FOONG-C TABLETS 250MG (ASCORBIC ACID) \"Y.F.\""
    },
    {
      "code" : "A018750100",
      "display" : "COLDENIN CAPSULES"
    },
    {
      "code" : "A018756100",
      "display" : "ZUTON TABLETS \"YU SHENG\""
    },
    {
      "code" : "A018771329",
      "display" : "TOLDINE OINTMENT \"S.T.\""
    },
    {
      "code" : "A018772121",
      "display" : "KOSULER PASTE (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A018772129",
      "display" : "KOSULER PASTE (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A018772135",
      "display" : "KOSULER PASTE (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A018773100",
      "display" : "FURAMMINE TABLETS 50MG (DIMENHYDRINATE)"
    },
    {
      "code" : "A018783100",
      "display" : "CLONIDINE TABLETS 0.15MG (CLONIDINE)\"F.S.\""
    },
    {
      "code" : "A018786500",
      "display" : "TRICO VAGINAL TABLETS\"C.L\""
    },
    {
      "code" : "A018789100",
      "display" : "POSTON CAPSULES 250MG \"CHEN TA\""
    },
    {
      "code" : "A018791100",
      "display" : "SEDENIN TABLETS \"MEIDER\""
    },
    {
      "code" : "A018797100",
      "display" : "MEBENDAZOLE TABLETS \"TK&A\""
    },
    {
      "code" : "A018798335",
      "display" : "TRICODEX CREAM \"C.C.P.\""
    },
    {
      "code" : "A018802100",
      "display" : "VITAMINE B2,B6 COMPLEX TABLETS \"KODAK\""
    },
    {
      "code" : "A018803100",
      "display" : "SULAN SUGAR COATED TABLETS \"P.L.\""
    },
    {
      "code" : "A018805221",
      "display" : "CHYMASE LYOPHILIZED INJECTION (CHYMOTRYPSIN)"
    },
    {
      "code" : "A018808100",
      "display" : "UPDIAN TABLETS \"JINUP\" (METRONIDAZOLE)"
    },
    {
      "code" : "A018809100",
      "display" : "CARU TABLETS 30MG (CARBETAPENTANE) \"GOLDEN HORSE\""
    },
    {
      "code" : "A018810100",
      "display" : "MECAL TABLETS \"CHINTENG\""
    },
    {
      "code" : "A018820229",
      "display" : "VITAMIN B COMPLEX INJECTION \"WINSTON\""
    },
    {
      "code" : "A018820299",
      "display" : "VITAMIN B COMPLEX INJECTION \"WINSTON\""
    },
    {
      "code" : "A018823100",
      "display" : "SUNET HTON TABLETS"
    },
    {
      "code" : "A018828100",
      "display" : "COLDEX CAPSULES \"PRINCE\""
    },
    {
      "code" : "A018848421",
      "display" : "ATROPINE EYE DROPS (ATROPINE SULFATE)\"OASIS\""
    },
    {
      "code" : "A018853100",
      "display" : "LIBOUBIN TABLETS"
    },
    {
      "code" : "A018860255",
      "display" : "GUROCAN INJECTION \"N.K.\""
    },
    {
      "code" : "A018860265",
      "display" : "GUROCAN INJECTION \"N.K.\""
    },
    {
      "code" : "A018860277",
      "display" : "GUROCAN INJECTION \"N.K.\""
    },
    {
      "code" : "A018862100",
      "display" : "MEFENAMIC ACID CAPSULES \"S.T.\""
    },
    {
      "code" : "A018866100",
      "display" : "VERMOX TABLETS (MEBENDAZOLE)"
    },
    {
      "code" : "A018870100",
      "display" : "HONSEOFULVIN TABLETS \"HONTEN\" (GRISEOFULVIN)"
    },
    {
      "code" : "A018873100",
      "display" : "BUCLIZINE TABLETS \"H.H.\""
    },
    {
      "code" : "A018878100",
      "display" : "KEYENSUTA CAPSULES (KETOPROFEN) \"S.T.\""
    },
    {
      "code" : "A018884265",
      "display" : "SUPERCILLIN FOR INJECTION \"VPP\""
    },
    {
      "code" : "A018886100",
      "display" : "KETOPROFENE CAPSULES \"LITA\""
    },
    {
      "code" : "A018887100",
      "display" : "HOTITON TABLETS"
    },
    {
      "code" : "A018890100",
      "display" : "ANSITON CAPSULES (KETOPROFEN) \"C.M.\""
    },
    {
      "code" : "A018892100",
      "display" : "KOSIWAY TABLETS \"T.F.\""
    },
    {
      "code" : "A018895100",
      "display" : "NYSTATIN CAPSULES \"YUNG SHIN\""
    },
    {
      "code" : "A018896100",
      "display" : "SALUTOL TABLETS (SALBUTAMOL)"
    },
    {
      "code" : "A0188961G0",
      "display" : "SALUTOL TABLETS (SALBUTAMOL)"
    },
    {
      "code" : "A018902100",
      "display" : "MEPA TABLETS \"S.C.\" (METHYLDOPA)"
    },
    {
      "code" : "A018904100",
      "display" : "OBYRAN S.C. TABLETS (ALUMINUM FLUFENAMATE)"
    },
    {
      "code" : "A018905100",
      "display" : "THIRIZINE S.C. TABLETS 25mg"
    },
    {
      "code" : "A018914100",
      "display" : "VITAMIN C TABLETS (ASCORBIC ACID) \"N.W.\""
    },
    {
      "code" : "A018916100",
      "display" : "TOPICAINE TABLETS\"Y.K.\" (OXETHAZINE)"
    },
    {
      "code" : "A018920100",
      "display" : "DACTIRAN F.C. TABLETS (PIPERIDOLATE) \"KYORIN\""
    },
    {
      "code" : "A018926100",
      "display" : "TIOPRONIN S.C. TABLETS \"S.T.\""
    },
    {
      "code" : "A018927329",
      "display" : "VENIFCORT CREAM \"N.K.\""
    },
    {
      "code" : "A018929100",
      "display" : "ANTALGIC TABLETS \"H.H.\""
    },
    {
      "code" : "A018930100",
      "display" : "KETOPROFEN CAPSULES 50MG \"Y.Y.\""
    },
    {
      "code" : "A018937417",
      "display" : "GENTAMICIN OPHTHALMIC OINTMENT \"METRO\""
    },
    {
      "code" : "A018942100",
      "display" : "DOPHEDOL CAPSULES (DIPHENIDOL) \"SHIN FONG\""
    },
    {
      "code" : "A018946209",
      "display" : "DEXAMETHASONE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A018946229",
      "display" : "DEXAMETHASONE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A018949100",
      "display" : "Bisacodyl Enteric Film Coated Tablets  5mg \"VPC\""
    },
    {
      "code" : "A0189491G0",
      "display" : "Bisacodyl Enteric Film Coated Tablets  5mg \"VPC\""
    },
    {
      "code" : "A018952333",
      "display" : "HEPARINOID OINTMENT \"Y.Y.\""
    },
    {
      "code" : "A018955100",
      "display" : "UMIX TABLETS \"MEIDER\""
    },
    {
      "code" : "A018959100",
      "display" : "POLYASE TABLETS \"P.J.\""
    },
    {
      "code" : "A018973100",
      "display" : "AMPICILLIN CAPSULES 250MG \"CSP\""
    },
    {
      "code" : "A018983100",
      "display" : "AMYBITAL CAPSULES 200MG (AMOBARBITAL) \"VPP\""
    },
    {
      "code" : "A018985118",
      "display" : "PACOUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A018985163",
      "display" : "PACOUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A018985199",
      "display" : "PACOUGH SYRUP \"PATRON\""
    },
    {
      "code" : "A018987421",
      "display" : "BENOXINATE EYE DROPS \"OASIS\""
    },
    {
      "code" : "A018996100",
      "display" : "M.B. TABLETS (MEPENZOLATE BROMIDE) \"M.T.\""
    },
    {
      "code" : "A019033100",
      "display" : "GEMOX CAPSULES 500MG (AMOXYCILLIN) \"GENTLE\""
    },
    {
      "code" : "A019034100",
      "display" : "DIPYRIDAMOLE TABLETS \"ASTAR\""
    },
    {
      "code" : "A019039100",
      "display" : "KOCHANLIN TABLETS  \"S.Y.\"(CLONIDINE)"
    },
    {
      "code" : "A019040100",
      "display" : "AMITRIPTYLINE TABLETS \"JINUP\""
    },
    {
      "code" : "A019045100",
      "display" : "TUSSIVIDE TABLETS (GLCERYL GUAIACOLATE) \"SHIN FONG\""
    },
    {
      "code" : "A019047100",
      "display" : "OROTIC ACID TABLETS 100MG"
    },
    {
      "code" : "A019054100",
      "display" : "GEMOX CAPSULES 250MG (AMOXYCILLIN) \"GENTLE\""
    },
    {
      "code" : "A019055100",
      "display" : "YES TABLETS (CLONIDINE) \"N.K.\""
    },
    {
      "code" : "A019070100",
      "display" : "TANPAMIDE TABLETS (CHLORPROPAMIDE) \"SHINLON\""
    },
    {
      "code" : "A019072100",
      "display" : "KETOPROFEN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A019078100",
      "display" : "CARES TABLETS (CLONIDINE) \"S.C.\""
    },
    {
      "code" : "A019087100",
      "display" : "CLOMIPHENE CAPSULES 50MG \"JINUP\""
    },
    {
      "code" : "A019089100",
      "display" : "SHUPINLIN S.C. TABLETS (DIISOPROPYLAMINE DICHLOROACETATE) \"Y.S.\""
    },
    {
      "code" : "A019093100",
      "display" : "DIPHENIDOL TABLETS 25MG\"N.C.P\""
    },
    {
      "code" : "A019097100",
      "display" : "LOFAXIN CAPSULES 250MG (CEPHALEXIN) \"GENTLE\""
    },
    {
      "code" : "A019102100",
      "display" : "BICOROMIN TABLETS \"MEIDER\""
    },
    {
      "code" : "A019108100",
      "display" : "MENSTOGEN S.C. TABLETS \"S.C.\""
    },
    {
      "code" : "A019111100",
      "display" : "VERMICIDE TABLETS (MEBENDAZOLE) \"PFOSHEN\""
    },
    {
      "code" : "A019115100",
      "display" : "PAWINT TABLETS \"PATRON\""
    },
    {
      "code" : "A019118100",
      "display" : "ORCIPRENALINE TABLETS \"SHINLON\""
    },
    {
      "code" : "A019127100",
      "display" : "STANOL TABLETS (STANOZOLOL) \"H.H.\""
    },
    {
      "code" : "A019129100",
      "display" : "LEVODOPA CAPSULES \"F.S.\""
    },
    {
      "code" : "A019135100",
      "display" : "AMPICILLIN CAPSULES 500MG \"GENTLE\""
    },
    {
      "code" : "A019137100",
      "display" : "ANICAMET F.C. TABLETS（NICAMETATE）\"W.S.\""
    },
    {
      "code" : "A019138100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS \"SHINLON\""
    },
    {
      "code" : "A019141100",
      "display" : "TENING TABLETS  \"C.H.\""
    },
    {
      "code" : "A019142100",
      "display" : "ACETAZONE TABLETS \"J.H.\""
    },
    {
      "code" : "A019144318",
      "display" : "DEHIST LOTION \"GCPC\""
    },
    {
      "code" : "A019144351",
      "display" : "DEHIST LOTION \"GCPC\""
    },
    {
      "code" : "A019144355",
      "display" : "DEHIST LOTION \"GCPC\""
    },
    {
      "code" : "A019144399",
      "display" : "DEHIST LOTION \"GCPC\""
    },
    {
      "code" : "A019145100",
      "display" : "ALBUTOL TABLETS \"J.H.\" (SALBUTAMOL)"
    },
    {
      "code" : "A019150238",
      "display" : "VITAPLEX INJECTION \"S.Y.\""
    },
    {
      "code" : "A019150265",
      "display" : "VITAPLEX INJECTION \"S.Y.\""
    },
    {
      "code" : "A019150277",
      "display" : "VITAPLEX INJECTION \"S.Y.\""
    },
    {
      "code" : "A019154100",
      "display" : "CAPDES TABLETS \"JOHNSON\""
    },
    {
      "code" : "A019157100",
      "display" : "NIFUTOIN TABLETS  \"C.H.\"(NITROFURANTOIN)"
    },
    {
      "code" : "A019159100",
      "display" : "ACETA TABLETS  \"C.H.\""
    },
    {
      "code" : "A019161421",
      "display" : "LARKASONE EYE DROPS \"LITA\""
    },
    {
      "code" : "A019171100",
      "display" : "BROEN C ENTERIC S.C. TABLETS \"N.K.\""
    },
    {
      "code" : "A019177100",
      "display" : "SUWEILAN TABLETS \"S.Y.\"(METOCLOPRAMIDE)"
    },
    {
      "code" : "A019178100",
      "display" : "ANTIASTHMA CAPSULES"
    },
    {
      "code" : "A019192100",
      "display" : "PROPRANOLOL TABLETS \"SHINLON\""
    },
    {
      "code" : "A019195100",
      "display" : "HONPINTSWAN TABLETS \"HONTEN\""
    },
    {
      "code" : "A019200100",
      "display" : "Jing Fuping Tablet 1mg \"C.L.\""
    },
    {
      "code" : "A019206100",
      "display" : "VITAMIN B6 TABLETS 50MG (PYRIDOXINE HCL) \"C.T.\""
    },
    {
      "code" : "A019210100",
      "display" : "ERGOCAFE TABLETS \"C.H.\""
    },
    {
      "code" : "A019244100",
      "display" : "SEDALOON TABLETS"
    },
    {
      "code" : "A019246100",
      "display" : "BONAS E.S. TABLETS (BROMELAIN)"
    },
    {
      "code" : "A019247100",
      "display" : "SILENCE TABLETS (LORAZEPAM) \"YUNG SHIN\""
    },
    {
      "code" : "A0192471G0",
      "display" : "SILENCE TABLETS (LORAZEPAM) \"YUNG SHIN\""
    },
    {
      "code" : "A019251100",
      "display" : "NEO-ANTIHISTAMINE TABLETS  \"J.H.\"(CHLORPHENIRAMINE)"
    },
    {
      "code" : "A019252100",
      "display" : "KETOFEN CAPSULES \"J.H.\" (KETOPROFEN)"
    },
    {
      "code" : "A019255100",
      "display" : "FRISIUM TABLETS 5MG (CLOBAZAM)"
    },
    {
      "code" : "A019260100",
      "display" : "DYS-COLD CAPSULES \"H.H.\""
    },
    {
      "code" : "A019263100",
      "display" : "MUQUAPIN F.C. TABLETS \"H.S.\" (N-METHYLSCOPOLAMINE METHYLSULFATE)"
    },
    {
      "code" : "A0192631G0",
      "display" : "MUQUAPIN F.C. TABLETS \"H.S.\" (N-METHYLSCOPOLAMINE METHYLSULFATE)"
    },
    {
      "code" : "A019268209",
      "display" : "DEPO-TESTERMON 200MG"
    },
    {
      "code" : "A019269329",
      "display" : "SIFUZIN CREAM \"YUNG CHANG\""
    },
    {
      "code" : "A019269338",
      "display" : "SIFUZIN CREAM \"YUNG CHANG\""
    },
    {
      "code" : "A019270277",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019272238",
      "display" : "TRI-B INJECTION \"WINSTON\""
    },
    {
      "code" : "A019275100",
      "display" : "SARIN TABLETS \"J.H.\""
    },
    {
      "code" : "A019276212",
      "display" : "THIOCTAN INJECTION (THIOCTIC ACID) \"TAI YU\""
    },
    {
      "code" : "A019276221",
      "display" : "THIOCTAN INJECTION (THIOCTIC ACID) \"TAI YU\""
    },
    {
      "code" : "A019280209",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019280212",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019280221",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019280229",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019280238",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019280277",
      "display" : "CEFAZOLIN INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A019281100",
      "display" : "THIORIDAZINE S.C. TABLETS \"C.I.\""
    },
    {
      "code" : "A019282209",
      "display" : "TRIALON INJECTION 40MG \"C.C.P.\""
    },
    {
      "code" : "A019282212",
      "display" : "TRIALON INJECTION 40MG \"C.C.P.\""
    },
    {
      "code" : "A019282221",
      "display" : "TRIALON INJECTION 40MG \"C.C.P.\""
    },
    {
      "code" : "A019288100",
      "display" : "WELIGEN CAPSULES (VITAMIN E) \"K.B.\""
    },
    {
      "code" : "A019289100",
      "display" : "KETOPROFEN CAPSULES \"ORIENTAL\""
    },
    {
      "code" : "A019296238",
      "display" : "DEPAINING INJECTION \"TAI YU\""
    },
    {
      "code" : "A019299135",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019299143",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019299151",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019299157",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019299177",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019299199",
      "display" : "PANDOL LIQUID (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A019300100",
      "display" : "AMPICILLIN CAPSULES 500MG \"Taiten\""
    },
    {
      "code" : "A019302100",
      "display" : "ASCORBIC ACID TABLETS \"C.I.\""
    },
    {
      "code" : "A019308100",
      "display" : "THIODAZINE S.C. TABLETS 25MG (THIORIDAZINE) \" N.Y.\""
    },
    {
      "code" : "A019328100",
      "display" : "DEXTROMETHORPHAN TABLETS \"JEN SHENG\""
    },
    {
      "code" : "A019330238",
      "display" : "RENMATIN INJECTION \"WINSTON\""
    },
    {
      "code" : "A019336100",
      "display" : "VITAMINE-B1 TABLETS 10mg \"H.L.\""
    },
    {
      "code" : "A019337100",
      "display" : "LIMODIUM TABLETS (LOPERAMIDE)"
    },
    {
      "code" : "A0193371G0",
      "display" : "LIMODIUM TABLETS (LOPERAMIDE)"
    },
    {
      "code" : "A019338100",
      "display" : "COSOPHYLLIN TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A019339100",
      "display" : "DIPHENIDOL HCL S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A019341109",
      "display" : "SPAGASTROL GRANULES \"SWISS BRAND\""
    },
    {
      "code" : "A019343100",
      "display" : "ACETAMINOPHEN TABLETS \"Vita\""
    },
    {
      "code" : "A019346100",
      "display" : "ALLORIN TABLETS (ALLOPURINOL) \"WILSON\""
    },
    {
      "code" : "A019348100",
      "display" : "KUANIUM S.C. TABLETS \"VPP\""
    },
    {
      "code" : "A019350100",
      "display" : "PAINLAX TABLETS 20MG (DICYCLOMINE)\"JINUP\""
    },
    {
      "code" : "A019353100",
      "display" : "STAZYME F.C. TABLETS \"STANDARD\""
    },
    {
      "code" : "A019356100",
      "display" : "BERIAN TABLETS \"N.K.\""
    },
    {
      "code" : "A019358277",
      "display" : "CEFAMANDOLE INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A019359100",
      "display" : "PAINLESS TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A019360100",
      "display" : "ASMELLIN-EPG TABLETS \"CHINTENG\""
    },
    {
      "code" : "A0193601G0",
      "display" : "ASMELLIN-EPG TABLETS \"CHINTENG\""
    },
    {
      "code" : "A019362399",
      "display" : "TODERMGEN CREAM"
    },
    {
      "code" : "A019389100",
      "display" : "CHINFENG TABLETS"
    },
    {
      "code" : "A019403100",
      "display" : "LAWEN TABLETS (DIMENHYDRINATE)\"CURIE\""
    },
    {
      "code" : "A019410100",
      "display" : "UNCOLA CAPSULES \"F.B.\""
    },
    {
      "code" : "A0194101G0",
      "display" : "UNCOLA CAPSULES \"F.B.\""
    },
    {
      "code" : "A019411100",
      "display" : "DOXYMYCIN ENTERIC COATED TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A019412100",
      "display" : "SEDICON TABLETS \"YU SHENG\""
    },
    {
      "code" : "A019418100",
      "display" : "DECONE TABLETS \"SINPHAR\" (DEXAMETHASONE)"
    },
    {
      "code" : "A0194181G0",
      "display" : "DECONE TABLETS \"SINPHAR\" (DEXAMETHASONE)"
    },
    {
      "code" : "A019419100",
      "display" : "PONSTAL CAPSULES 250MG  \"SINPHAR\"(MEFENAMIC ACID)"
    },
    {
      "code" : "A0194191G0",
      "display" : "PONSTAL CAPSULES 250MG  \"SINPHAR\"(MEFENAMIC ACID)"
    },
    {
      "code" : "A019420100",
      "display" : "PONSTAL F.C. TABLETS 500MG \"SINPHAR\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A0194201G0",
      "display" : "PONSTAL F.C. TABLETS 500MG \"SINPHAR\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A019421100",
      "display" : "Ponstal F.C. Tablets 250mg \"Sinphar\" (Mefenamic Acid)"
    },
    {
      "code" : "A019422335",
      "display" : "SCALPHEN OINTMENT \"SINPHAR\" (MESULPHEN)"
    },
    {
      "code" : "A019423309",
      "display" : "SINDINE SOLUTION \"SINPHAR\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A019423318",
      "display" : "SINDINE SOLUTION \"SINPHAR\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A019423399",
      "display" : "SINDINE SOLUTION \"SINPHAR\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A019427100",
      "display" : "ANLITRAN CAPSULES"
    },
    {
      "code" : "A019442100",
      "display" : "ESMYCIN CAPSULES (ERYTHROMYCIN ESTOLATE) \"WSHINGTON\""
    },
    {
      "code" : "A019443100",
      "display" : "C C MYCIN CAPSULES (CHLORAMPHENICOL) \"WASHINGTON\""
    },
    {
      "code" : "A019444100",
      "display" : "MEBENDAZOLE TABLETS \"S.Y.\""
    },
    {
      "code" : "A019445100",
      "display" : "KPHADOL TABLETS \"SWISS\" (DIPHENIDOL)"
    },
    {
      "code" : "A019446100",
      "display" : "ANPOLIN S.C. TABLETS 10MG (HYDRALAZINE)"
    },
    {
      "code" : "A019449100",
      "display" : "PYRIAN TABLETS 500MG (ACETAMINOPHEN) \"EVEREST\""
    },
    {
      "code" : "A019459100",
      "display" : "SERAZIDE TABLETS \"WINSTON\""
    },
    {
      "code" : "A019461100",
      "display" : "METHYLDOPA　F.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A019462100",
      "display" : "STOLINE TABLETS \"LITA\""
    },
    {
      "code" : "A019468100",
      "display" : "PHENAZODINE S.C. Tablets 100mg (PHENAZOPYRIDINE HCl)"
    },
    {
      "code" : "A019473329",
      "display" : "VEDARON OINTMENT"
    },
    {
      "code" : "A019474100",
      "display" : "TTMYCIN CAPSULES \"WASHINGTON\" (TETRACYCILINE HCL)"
    },
    {
      "code" : "A019481209",
      "display" : "CEPHALOTHIN INJECTION 1GM \"CHIPHAR\""
    },
    {
      "code" : "A019484100",
      "display" : "ANDERAN TABLETS (PROPRANOLOL) \"A.S.\""
    },
    {
      "code" : "A019485100",
      "display" : "DEXCHLORPHENIRAMINE TABLETS \"HONTEN\""
    },
    {
      "code" : "A019486100",
      "display" : "CLOMIPHENE TABLETS \"HONTEN\""
    },
    {
      "code" : "A019492100",
      "display" : "METRONIDAZOLE S.C. TABLETS \"Eayung\""
    },
    {
      "code" : "A019493209",
      "display" : "METRONEURIL INJECTION \"METRO\" (HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A019493229",
      "display" : "METRONEURIL INJECTION \"METRO\" (HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A019495100",
      "display" : "LORAZEPAM TABLETS 1MG \"LITA\""
    },
    {
      "code" : "A019502100",
      "display" : "PERDAMOL S.C. TABLETS (DIPYRIDAMOLE) \"SINPHAR\""
    },
    {
      "code" : "A019503100",
      "display" : "SINPHADOL S.C. TABLETS \"SINPHAR\" (DIPHENIDOL)"
    },
    {
      "code" : "A0195031G0",
      "display" : "SINPHADOL S.C. TABLETS \"SINPHAR\" (DIPHENIDOL)"
    },
    {
      "code" : "A019505209",
      "display" : "BUTYSCOL INJECTION\"STANDARD\"(SCOPOLAMINE)"
    },
    {
      "code" : "A019506100",
      "display" : "DISCO TABLETS (DIPHENIDOL)"
    },
    {
      "code" : "A019510100",
      "display" : "DIABENLYSE TABLETS (GLIBENCLAMIDE) \"PATRON\""
    },
    {
      "code" : "A019518100",
      "display" : "FULOAN CAPSULES (FLUOXYMESTERONE) \"N.C.P.\""
    },
    {
      "code" : "A019522100",
      "display" : "BICOTAN E.C. TABLETS (BISACODYL)"
    },
    {
      "code" : "A019526100",
      "display" : "VITAMIN E S.C. TABLETS \"TANABE\""
    },
    {
      "code" : "A019533100",
      "display" : "CHLORAMPHENICOL S.C. TABLET 250MG \"SINPHAR\""
    },
    {
      "code" : "A019535100",
      "display" : "BETAMETHASONE TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A019548100",
      "display" : "ASRITIN TABLETS (ORCIPRENALINE) \"ROYAL\""
    },
    {
      "code" : "A019549100",
      "display" : "TELINCOL TABLETS \"ROYAL\""
    },
    {
      "code" : "A0195491G0",
      "display" : "TELINCOL TABLETS \"ROYAL\""
    },
    {
      "code" : "A019551100",
      "display" : "MEDOPA F.C. TABLETS (METHYLDOPA) \"ROYAL\""
    },
    {
      "code" : "A019553100",
      "display" : "HALOLIUM TABLETS (HALOPERIDOL) \"ROYAL\""
    },
    {
      "code" : "A0195551G0",
      "display" : "DIAZEPAM TABLETS \"ROYAL\""
    },
    {
      "code" : "A019556100",
      "display" : "CYPRO TABLETS (CYPROHEPTADINE) \"ROYAL\""
    },
    {
      "code" : "A0195561G0",
      "display" : "CYPRO TABLETS (CYPROHEPTADINE) \"ROYAL\""
    },
    {
      "code" : "A019557100",
      "display" : "PURINOL TABLETS (ALLOPURINOL) \"ROYAL\""
    },
    {
      "code" : "A0195571G0",
      "display" : "PURINOL TABLETS (ALLOPURINOL) \"ROYAL\""
    },
    {
      "code" : "A019558100",
      "display" : "NAPROXEN TABLETS \"ROYAL\""
    },
    {
      "code" : "A019559100",
      "display" : "XANTHIN TABLETS (XANTHINOL NICOTINATE) \"ROYAL\""
    },
    {
      "code" : "A019560100",
      "display" : "SERIDON TABLETS (FUROSEMIDE)\"ROYAL\""
    },
    {
      "code" : "A019562100",
      "display" : "TOROFEN CAPSULES \"STANDARD\" (KETOPROFEN)"
    },
    {
      "code" : "A019573100",
      "display" : "CLOMIPHENE TABLETS \"PEILI\""
    },
    {
      "code" : "A019576212",
      "display" : "SULPYRINE INJECTION \"S.Y.\""
    },
    {
      "code" : "A019577100",
      "display" : "BACTALIN TABLETS \"S.Y.\""
    },
    {
      "code" : "A019579100",
      "display" : "LIMIN TABLETS \"YU SHENG\" (NITRAZEPAM)"
    },
    {
      "code" : "A019595100",
      "display" : "INDALGIN CAPSULES 25MG (INDOMETHACIN)"
    },
    {
      "code" : "A0195951G0",
      "display" : "INDALGIN CAPSULES 25MG (INDOMETHACIN)"
    },
    {
      "code" : "A019596100",
      "display" : "IBUPROFEN TABLETS 400MG \"HONTEN\""
    },
    {
      "code" : "A0195961G0",
      "display" : "IBUPROFEN TABLETS 400MG \"HONTEN\""
    },
    {
      "code" : "A019597100",
      "display" : "LOPERAMIDE CAPSULES 2MG \"C.L.\""
    },
    {
      "code" : "A019600100",
      "display" : "NEGACHINE TABLETS (NALIDIXIC ACID)"
    },
    {
      "code" : "A019608100",
      "display" : "WALOSONE POWDER FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE) \"WSASHINGTON\""
    },
    {
      "code" : "A019608143",
      "display" : "WALOSONE POWDER FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE) \"WSASHINGTON\""
    },
    {
      "code" : "A019608151",
      "display" : "WALOSONE POWDER FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE) \"WSASHINGTON\""
    },
    {
      "code" : "A019610100",
      "display" : "ROITONIN S.C. TABLETS (DICLOFENAC) \"JOHNSON\""
    },
    {
      "code" : "A019614329",
      "display" : "SINPHARDERM-HC CREAM \"SINPHAR\""
    },
    {
      "code" : "A019615329",
      "display" : "SINQUART CREAM \"SINPHAR\""
    },
    {
      "code" : "A019616309",
      "display" : "BETAMETHASONE OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A019616321",
      "display" : "BETAMETHASONE OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A019616329",
      "display" : "BETAMETHASONE OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A019616372",
      "display" : "BETAMETHASONE OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A019616399",
      "display" : "BETAMETHASONE OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A019617100",
      "display" : "ULMERLINE TABLETS \"SINPHAR\""
    },
    {
      "code" : "A019620100",
      "display" : "NAPROXEN TABLETS \"SINPHAR\""
    },
    {
      "code" : "A019621209",
      "display" : "PROGESTERONE INJECTION \"SINPHAR\""
    },
    {
      "code" : "A019622209",
      "display" : "DEPO-TESTOMONE INJECTION (TESTOSTERONE CYPIONATE) \"SINPHAR\""
    },
    {
      "code" : "A019623100",
      "display" : "ALUFIBRATE F.C. TABLETS \"ROYAL\""
    },
    {
      "code" : "A019624100",
      "display" : "Santorin F.C. Tablets"
    },
    {
      "code" : "A019625100",
      "display" : "PISANTA CAPSULES (PIRACETAM) \"ROYAL\""
    },
    {
      "code" : "A0196251G0",
      "display" : "PISANTA CAPSULES (PIRACETAM) \"ROYAL\""
    },
    {
      "code" : "A019627100",
      "display" : "PESADIN F.C TABLETS (DIPYRIDAMOLE) \"ROYAL\""
    },
    {
      "code" : "A019628100",
      "display" : "EACI TABLETS \"ROYAL\""
    },
    {
      "code" : "A019636100",
      "display" : "CLEANSERA CAPSULES (TOCOPHERYL NICOTINATE) \"ROYAL\""
    },
    {
      "code" : "A019639100",
      "display" : "PROPRA TABLETS (PROPRANOLOL) \"ROYAL\""
    },
    {
      "code" : "A0196391G0",
      "display" : "PROPRA TABLETS (PROPRANOLOL) \"ROYAL\""
    },
    {
      "code" : "A019640100",
      "display" : "ALKANTIN TABLETS \"ROYAL\""
    },
    {
      "code" : "A0196401G0",
      "display" : "ALKANTIN TABLETS \"ROYAL\""
    },
    {
      "code" : "A019643100",
      "display" : "DORISON TABLETS (DEXAMETHASONE) \"ROYAL\""
    },
    {
      "code" : "A0196431G0",
      "display" : "DORISON TABLETS (DEXAMETHASONE) \"ROYAL\""
    },
    {
      "code" : "A019644100",
      "display" : "SALBUTOL TABLETS (SALBUTAMOL) \"ROYAL\""
    },
    {
      "code" : "A019649100",
      "display" : "JACIDE TABLETS \"ROYAL\""
    },
    {
      "code" : "A019650100",
      "display" : "Bromco Tablets \"Royal\" (Bromhexine hydrochloride)"
    },
    {
      "code" : "A019654238",
      "display" : "KANAMYCIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A019654299",
      "display" : "KANAMYCIN INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A019655399",
      "display" : "FURAWOUND OINTMENT \"METRO\" (NITROFURAZONE)"
    },
    {
      "code" : "A0196553CH",
      "display" : "FURAWOUND OINTMENT \"METRO\" (NITROFURAZONE)"
    },
    {
      "code" : "A019656100",
      "display" : "AZUNEN TABLETS \"MEIDER\" (GUAIAZULENE)"
    },
    {
      "code" : "A019659209",
      "display" : "BETAMETHASONE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A019659229",
      "display" : "BETAMETHASONE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A019663100",
      "display" : "WEILCOLAN TABLETS \"Y.S.\""
    },
    {
      "code" : "A019665100",
      "display" : "LORAZEPAM TABLETS 0.5MG \"LITA\""
    },
    {
      "code" : "A019676209",
      "display" : "FERVAN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019676210",
      "display" : "FERVAN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019676214",
      "display" : "FERVAN INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019679238",
      "display" : "POTASSIUM PHOSPHATE DIBASIC INJECTION \"S.T.\""
    },
    {
      "code" : "A019682100",
      "display" : "HISLICON CAPSULES \"H.S.\""
    },
    {
      "code" : "A019683100",
      "display" : "GELUSIL-1 TABLETS"
    },
    {
      "code" : "A019686309",
      "display" : "SINDINE GARGLE AND MOUTH WASH \"SINPHAR\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A019686355",
      "display" : "SINDINE GARGLE AND MOUTH WASH \"SINPHAR\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A019702500",
      "display" : "ASPIRIN SUPPOSITORY 325MG \"SINPHAR\""
    },
    {
      "code" : "A019705100",
      "display" : "COUGHCIN TABLETS \"WINSTON\""
    },
    {
      "code" : "A019706100",
      "display" : "DIFENDOL S.C. TABLETS (DIPHENIDOL) \"JOHNSON\""
    },
    {
      "code" : "A019709100",
      "display" : "MESCO TABLETS \"J.H.\"(METHYLSCOPOLAMINE METHYLSULFATE)"
    },
    {
      "code" : "A019717212",
      "display" : "GENTAMICIN INJECTION 40MG \"SINPHAR\""
    },
    {
      "code" : "A019719209",
      "display" : "PRO-ERAL INJECTION \"SINPHAR\""
    },
    {
      "code" : "A019721209",
      "display" : "DECONE INJECTION 5MG (DEXAMETHASONE) \"SINPHAR\""
    },
    {
      "code" : "A019729100",
      "display" : "YESCAN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A019730100",
      "display" : "PROBEN CAPSULES (KETOPROFEN) \"YU SHENG\""
    },
    {
      "code" : "A019749100",
      "display" : "PRIMRAN F.C. TABLETS (METOCLOPRAMIDE) \"ROYAL\""
    },
    {
      "code" : "A0197491G0",
      "display" : "PRIMRAN F.C. TABLETS (METOCLOPRAMIDE) \"ROYAL\""
    },
    {
      "code" : "A019752100",
      "display" : "SINCLOCILLIN CAPSULES 500MG \"SINPHAR\""
    },
    {
      "code" : "A019753100",
      "display" : "AMPICILLIN CAPSULES 250MG \"SINPHAR\""
    },
    {
      "code" : "A019754100",
      "display" : "AMPICILLIN CAPSULES 500MG \"SINPHAR\""
    },
    {
      "code" : "A019756100",
      "display" : "CLOXACILLIN CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A019764212",
      "display" : "STOPNIN INJECTION 5MG \"KYORIN\""
    },
    {
      "code" : "A019769100",
      "display" : "LOPERAMIDE CAPSULES \"H.S.\""
    },
    {
      "code" : "A0197691G0",
      "display" : "LOPERAMIDE CAPSULES \"H.S.\""
    },
    {
      "code" : "A019786100",
      "display" : "TIDAZOL F.C. TABLETS \"STANDARD\" (TINIDAZOLE)"
    },
    {
      "code" : "A019788100",
      "display" : "VITAMIN B COMPLEX S.C. TABLETS \"J.S.\""
    },
    {
      "code" : "A019793212",
      "display" : "ICOTON INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019793221",
      "display" : "ICOTON INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019793229",
      "display" : "ICOTON INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019793238",
      "display" : "ICOTON INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A019794209",
      "display" : "DISEMONE INJECTION \"N.K.\""
    },
    {
      "code" : "A019796100",
      "display" : "SUNMEGEN TABLETS (DIPYRIDAMOLE)\"Y.Y.\""
    },
    {
      "code" : "A019799212",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION \"TAI YU\""
    },
    {
      "code" : "A019800100",
      "display" : "DECALIN TABLETS (DEXAMETHASONE)\"C.H.\""
    },
    {
      "code" : "A019819100",
      "display" : "ANTONIN CAPSULES"
    },
    {
      "code" : "A019853209",
      "display" : "PRO-ESTRAMON-S INJECTION \"C.C.P.\""
    },
    {
      "code" : "A019858100",
      "display" : "TINIDAZOLE CAPSULES 500MG \"P.J.\""
    },
    {
      "code" : "A019859100",
      "display" : "DICLOFEN TABLETS (DICLOFENAC)\"SHIN FONG\""
    },
    {
      "code" : "A019860100",
      "display" : "SAUAN CAPSULES \"CHEN SING\""
    },
    {
      "code" : "A019861100",
      "display" : "DICYCLOMINE HCL TABLETS \"LONG DER\""
    },
    {
      "code" : "A019864100",
      "display" : "ACEDOL TABLETS \"ROYAL\""
    },
    {
      "code" : "A019865100",
      "display" : "MEMODIN TABLETS (DIPHENIDOL) \"ROYAL\""
    },
    {
      "code" : "A0198651G0",
      "display" : "MEMODIN TABLETS (DIPHENIDOL) \"ROYAL\""
    },
    {
      "code" : "A019869100",
      "display" : "COLD TABLETS \"W.T\""
    },
    {
      "code" : "A019875100",
      "display" : "CARDOLOL TABLETS 40MG (PROPRANOLOL) \"V.P.P.\""
    },
    {
      "code" : "A0198751G0",
      "display" : "CARDOLOL TABLETS 40MG (PROPRANOLOL) \"V.P.P.\""
    },
    {
      "code" : "A019877100",
      "display" : "EPBUTOL TABLETS \"YU SHENG\" (ETHAMBUTOL)"
    },
    {
      "code" : "A019889100",
      "display" : "TOPESON F.C. TABLETS  \"STANDARD\" (TOLPERISONE)"
    },
    {
      "code" : "A019892100",
      "display" : "STOPIN S.C. TABLETS  (N-METHYLSCOPOLAMINE METHYLSULFA TE)\"S.C.\""
    },
    {
      "code" : "A019893100",
      "display" : "BIOCAINE TABLETS"
    },
    {
      "code" : "A019894100",
      "display" : "PERSATIN S.C. TABLETS (DIPYIDAMOLE) \"CHIU PO\""
    },
    {
      "code" : "A019895100",
      "display" : "CARDITONIN S.C. TABLETS 25MG (DIPYRIDAMOLE) \"VPP\""
    },
    {
      "code" : "A0198951G0",
      "display" : "CARDITONIN S.C. TABLETS 25MG (DIPYRIDAMOLE) \"VPP\""
    },
    {
      "code" : "A019897100",
      "display" : "GELIN CAPSULES (LOPERMIDE) \"M.S.\""
    },
    {
      "code" : "A019898100",
      "display" : "GUASHEATON CAPSULES (IBUPROFEN) \"T.W.\""
    },
    {
      "code" : "A019899100",
      "display" : "DACTJIN F.C. TABLETS \"SHITEH\""
    },
    {
      "code" : "A019904421",
      "display" : "WINMEGEN OPHTHALMIC SOLUTION \"WINSTON\""
    },
    {
      "code" : "A019904429",
      "display" : "WINMEGEN OPHTHALMIC SOLUTION \"WINSTON\""
    },
    {
      "code" : "A019904435",
      "display" : "WINMEGEN OPHTHALMIC SOLUTION \"WINSTON\""
    },
    {
      "code" : "A019915421",
      "display" : "DELONE EYE DROP \"SINPHAR\""
    },
    {
      "code" : "A019915429",
      "display" : "DELONE EYE DROP \"SINPHAR\""
    },
    {
      "code" : "A019924100",
      "display" : "MERITO S.C. TABLETS \"CHINTENG\""
    },
    {
      "code" : "A019927209",
      "display" : "PROGESTEDIOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A019935265",
      "display" : "VELIP INFUSION SOLUTION \"N.K.\""
    },
    {
      "code" : "A019935277",
      "display" : "VELIP INFUSION SOLUTION \"N.K.\""
    },
    {
      "code" : "A019937421",
      "display" : "FLUOROMETHOLONE EYE DROPS \"OASIS\""
    },
    {
      "code" : "A019941277",
      "display" : "VITAMINOPLEX INJECTION \"TAI YU\""
    },
    {
      "code" : "A019945100",
      "display" : "KETOPROFEN CAPSULES \"N.T.\""
    },
    {
      "code" : "A019947100",
      "display" : "NOSCAPINE TABLETS \"C.L.\""
    },
    {
      "code" : "A019949100",
      "display" : "STANDARD ANTI-COUGH CAPSULES"
    },
    {
      "code" : "A019952100",
      "display" : "FULIVER S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A019956100",
      "display" : "VANTONIN TABLETS (MEFENAMIC ACID)"
    },
    {
      "code" : "A019961342",
      "display" : "NITROFURAZONE OINTMENT \"Y.Y.\""
    },
    {
      "code" : "A019962277",
      "display" : "AMINOPLEXYTOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A019964221",
      "display" : "SIOCLOFEN INJECTION \"S.Y.\""
    },
    {
      "code" : "A019968109",
      "display" : "SHU-SHAN GRANULES \"M.T\""
    },
    {
      "code" : "A019968177",
      "display" : "SHU-SHAN GRANULES \"M.T\""
    },
    {
      "code" : "A019968199",
      "display" : "SHU-SHAN GRANULES \"M.T\""
    },
    {
      "code" : "A019969100",
      "display" : "HEPAMIN S.C. TABLETS\"N.C.P\""
    },
    {
      "code" : "A019970100",
      "display" : "THIAMPHENICOL CAP. 250MG \"P.J.\""
    },
    {
      "code" : "A019972100",
      "display" : "LILONDIUM CAPSULES (LOPERAMIDE) \"L.T.\""
    },
    {
      "code" : "A019974100",
      "display" : "VOLTAREN TABLETS (DICLOFENAC) \"CHIUPO\""
    },
    {
      "code" : "A019976100",
      "display" : "RIFAMPIN CAPSULES 300MG \"VPC\""
    },
    {
      "code" : "A019977100",
      "display" : "MESYTOL TABLETS 6MG \"CHEN TA\" (BETAHISTINE)"
    },
    {
      "code" : "A019978100",
      "display" : "NEPHRON TABLETS \"CHEN TA\""
    },
    {
      "code" : "A019982100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"SYNMOSA\""
    },
    {
      "code" : "A019983100",
      "display" : "KETOFEN CAPSULE. (KETOPROFEN)"
    },
    {
      "code" : "A019984100",
      "display" : "COBAMAMIDE CAPSULES \"C.H.\""
    },
    {
      "code" : "A019985100",
      "display" : "KETOPROFEN CAPSULES 50MG \"EAYUNG\""
    },
    {
      "code" : "A019987100",
      "display" : "BROAIN S.C. TABLETS (BROMELAIN) \"CHIN TENG\""
    },
    {
      "code" : "A0199871G0",
      "display" : "BROAIN S.C. TABLETS (BROMELAIN) \"CHIN TENG\""
    },
    {
      "code" : "A020012100",
      "display" : "THEOPAN TABLETS"
    },
    {
      "code" : "A020018100",
      "display" : "CANTIL TABLETS \"C.H.\""
    },
    {
      "code" : "A020022100",
      "display" : "TERBULINE TABLETS (TERBUTALINE)"
    },
    {
      "code" : "A020037100",
      "display" : "SONGORA F.C TABLETS (NICAMETATE) \"ROYAL\""
    },
    {
      "code" : "A0200371G0",
      "display" : "SONGORA F.C TABLETS (NICAMETATE) \"ROYAL\""
    },
    {
      "code" : "A020038100",
      "display" : "DICLOFENAC E.C. TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A020043100",
      "display" : "SINOX TABLETS \"N.C.P.\" (MEBENDAZOLE)"
    },
    {
      "code" : "A020044100",
      "display" : "SIOFULIN TABLETS  \"S.Y.\"(DICLOFENAC)"
    },
    {
      "code" : "A020046100",
      "display" : "LESUTON TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A020058100",
      "display" : "LIDERIUM CAPSULES (LOPERAMIDE)"
    },
    {
      "code" : "A020059100",
      "display" : "LOPERAM CAPSULES (LOPERAMIDE) \"JOHNSON\""
    },
    {
      "code" : "A0200591G0",
      "display" : "LOPERAM CAPSULES (LOPERAMIDE) \"JOHNSON\""
    },
    {
      "code" : "A020061277",
      "display" : "STROMIN INFUSION SOLUTION (PROTEIN HYDROLYSATE) \"N.K.\""
    },
    {
      "code" : "A020063100",
      "display" : "URECIN TABLETS (ALLOPURINOL) \"Y.Y.\""
    },
    {
      "code" : "A020070100",
      "display" : "CLOMIFEN CAPSULES (CLOMIPHENE) \"ROYAL\""
    },
    {
      "code" : "A020080212",
      "display" : "BIOCON INJECTION \"GENTLE\""
    },
    {
      "code" : "A020084100",
      "display" : "FENOTEROL TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A020088100",
      "display" : "NAGENTON TABLETS (NAPROXEN) \"N.K.\""
    },
    {
      "code" : "A020092100",
      "display" : "SOOTHING TABLETS (OXETHAZAINE) \"YUNG SHIN\""
    },
    {
      "code" : "A020095100",
      "display" : "PYRIDAMOLE S.C. TABLETS 75MG (DIPYRIDAMDE) \"C.T\""
    },
    {
      "code" : "A020096100",
      "display" : "SULQUINYL CAPSULES (SULPIRIDE) \"PATRON\""
    },
    {
      "code" : "A020100238",
      "display" : "MAMICON INJECTION \"PATRON\""
    },
    {
      "code" : "A020101100",
      "display" : "BUCLIZINE TABLETS 50mg \"H.S.\""
    },
    {
      "code" : "A020102309",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102321",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102323",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102330",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102336",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102355",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102372",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020102399",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A0201023B9",
      "display" : "TRIACT CREAM \"GCPC\""
    },
    {
      "code" : "A020103100",
      "display" : "Diclofen F.C. Tablets  \"H.S.\"(Diclofenac)"
    },
    {
      "code" : "A0201031G0",
      "display" : "Diclofen F.C. Tablets  \"H.S.\"(Diclofenac)"
    },
    {
      "code" : "A020109100",
      "display" : "ROYADRIN TABLETS \"ROYAL\""
    },
    {
      "code" : "A020111100",
      "display" : "TRISDOWN F.C TABLETS \"ROYAL\""
    },
    {
      "code" : "A0201111G0",
      "display" : "TRISDOWN F.C TABLETS \"ROYAL\""
    },
    {
      "code" : "A020112100",
      "display" : "TRICOGYL F.C TABLETS (METRONIDAZOLE) \"ROYAL\""
    },
    {
      "code" : "A0201121G0",
      "display" : "TRICOGYL F.C TABLETS (METRONIDAZOLE) \"ROYAL\""
    },
    {
      "code" : "A020115100",
      "display" : "TRIDERGEN TABLETS (DIHYDROERGOTOXINE MESYLATE)\" ROYAL \""
    },
    {
      "code" : "A020116100",
      "display" : "URODIX TABLETS (NALIDIXIC ACID) \"ROYAL\""
    },
    {
      "code" : "A020118212",
      "display" : "GURON-BC INJECTION \"GENTLE\""
    },
    {
      "code" : "A020118221",
      "display" : "GURON-BC INJECTION \"GENTLE\""
    },
    {
      "code" : "A020124100",
      "display" : "BETACOM S.C. TABLETS \"WILSON\""
    },
    {
      "code" : "A020125109",
      "display" : "COLD GRANULE \"H.H.\""
    },
    {
      "code" : "A020125155",
      "display" : "COLD GRANULE \"H.H.\""
    },
    {
      "code" : "A020132100",
      "display" : "CORTIMIN CAPSULES \"BOWLIN\""
    },
    {
      "code" : "A020134100",
      "display" : "TANPIN TABLETS"
    },
    {
      "code" : "A020137100",
      "display" : "TURNSTYLE ANALGESIC F.C. TABLETS 400MG"
    },
    {
      "code" : "A020144100",
      "display" : "LIPAIMIN S.C. TABLETS \"EAYUNG\""
    },
    {
      "code" : "A020148212",
      "display" : "HEPATOSWISS IM INJECTION"
    },
    {
      "code" : "A020156100",
      "display" : "DIAZEPAM TABLETS \"C.I.\""
    },
    {
      "code" : "A020159100",
      "display" : "HO CULAR TABLETS \"P.L.\" (LOPERAMIDE)"
    },
    {
      "code" : "A020174100",
      "display" : "LOTINTON TABLETS"
    },
    {
      "code" : "A0201741G0",
      "display" : "LOTINTON TABLETS"
    },
    {
      "code" : "A020194100",
      "display" : "STAREN F.C. TABLETS (DICLOFENAC) \"N.K.\""
    },
    {
      "code" : "A020204100",
      "display" : "CALCIUM TABLET \"CURIE\""
    },
    {
      "code" : "A020205100",
      "display" : "ORONAMINE S.C. TABLETS \"C.Y.\""
    },
    {
      "code" : "A020208100",
      "display" : "RIPIN CAPSULES 450MG (RIFAMPIN) \"KINGDOM\""
    },
    {
      "code" : "A020215343",
      "display" : "SINBABY BABY LOTION \"SINPHAR\""
    },
    {
      "code" : "A020215357",
      "display" : "SINBABY BABY LOTION \"SINPHAR\""
    },
    {
      "code" : "A020215377",
      "display" : "SINBABY BABY LOTION \"SINPHAR\""
    },
    {
      "code" : "A020215399",
      "display" : "SINBABY BABY LOTION \"SINPHAR\""
    },
    {
      "code" : "A020220100",
      "display" : "ASMALINE TABLETS (CLORPRENALINE) \"KODAK\""
    },
    {
      "code" : "A020226119",
      "display" : "COUGH FREE SYRUP \"CHI SHENG\""
    },
    {
      "code" : "A020226199",
      "display" : "COUGH FREE SYRUP \"CHI SHENG\""
    },
    {
      "code" : "A020227100",
      "display" : "DECOUPHAN LOZENGES"
    },
    {
      "code" : "A020228221",
      "display" : "HEPATOSWISS I.V. INJECTION (For infusion use)"
    },
    {
      "code" : "A020256100",
      "display" : "SADIXIN TABLETS \"S.Y.\"(NALIDIXIC ACID)"
    },
    {
      "code" : "A020257100",
      "display" : "MEFENAMIC ACID CAPSULE \"A.S.\""
    },
    {
      "code" : "A020264100",
      "display" : "DOZIN TABLETS (NAPROXEN) \"YUNG-CHANG\""
    },
    {
      "code" : "A020267100",
      "display" : "FLUFENAMIC ACID CAPSULE \"HONTEN\""
    },
    {
      "code" : "A020276348",
      "display" : "UBURN CREAM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A020276365",
      "display" : "UBURN CREAM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A020276377",
      "display" : "UBURN CREAM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A020276399",
      "display" : "UBURN CREAM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A020279100",
      "display" : "ANCHEN TABLETS (MEBENDAZOLE) \"J.H.\""
    },
    {
      "code" : "A020281100",
      "display" : "NAPROCIDE TABLETS \"S.Y.\""
    },
    {
      "code" : "A020285100",
      "display" : "SOLAX CAPSULAS \"ROYAL\""
    },
    {
      "code" : "A0202851G0",
      "display" : "SOLAX CAPSULAS \"ROYAL\""
    },
    {
      "code" : "A020286100",
      "display" : "SUSPAN F.C TABLETS (SCOPOLAMINE BUTYL BROMIDE) \" ROYAL \""
    },
    {
      "code" : "A020287100",
      "display" : "CINATIN TABLETS (CINNARIZINE) \"ROYAL\""
    },
    {
      "code" : "A0202871G0",
      "display" : "CINATIN TABLETS (CINNARIZINE) \"ROYAL\""
    },
    {
      "code" : "A020288100",
      "display" : "CARBELONE TABLETS (CARBENOXOLONE) \"ROYAL\""
    },
    {
      "code" : "A020291100",
      "display" : "OXETHAINE TABLETS \"C.L.\""
    },
    {
      "code" : "A020293100",
      "display" : "TINIDAZOLE CAPSULES \"Y.S.\""
    },
    {
      "code" : "A020295500",
      "display" : "ANTIFUNGAL VAGINAL TABLETS (MICONAZOLE) \"YUNG SHIN\""
    },
    {
      "code" : "A020296321",
      "display" : "WINSOLVE ANTIFUNGAL CREAM"
    },
    {
      "code" : "A020296329",
      "display" : "WINSOLVE ANTIFUNGAL CREAM"
    },
    {
      "code" : "A020296399",
      "display" : "WINSOLVE ANTIFUNGAL CREAM"
    },
    {
      "code" : "A020299100",
      "display" : "LIKANCOCHIEN S.C. TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A020309100",
      "display" : "SULINTEN TABLETS \"S.Y.\"(FENOTEROL)"
    },
    {
      "code" : "A020317100",
      "display" : "SKAINAR CAPSULES"
    },
    {
      "code" : "A020318100",
      "display" : "BOWELL TABLETS \"H.S.\""
    },
    {
      "code" : "A020333100",
      "display" : "VOREN ENTERIC COATED TABLETS (DICLOFENAC) \"YUNG SHIN\""
    },
    {
      "code" : "A0203331G0",
      "display" : "VOREN ENTERIC COATED TABLETS (DICLOFENAC) \"YUNG SHIN\""
    },
    {
      "code" : "A020336100",
      "display" : "DEXTRAN E.C. TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A020338100",
      "display" : "ATUSSIN S.C. TABLETS (SODIUM DIBUNATE) \"VPP\""
    },
    {
      "code" : "A020340100",
      "display" : "DISKO S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A020353100",
      "display" : "KING-PROFEN CAPSULES \"KINGDOM\""
    },
    {
      "code" : "A020359209",
      "display" : "KPHADOL INJECTION  \"SWISS\" (DIPHENIDOL)"
    },
    {
      "code" : "A020359212",
      "display" : "KPHADOL INJECTION  \"SWISS\" (DIPHENIDOL)"
    },
    {
      "code" : "A020368100",
      "display" : "NAPROXEN TABLETS \"JOHNSON\""
    },
    {
      "code" : "A020370100",
      "display" : "LOPERAMIDE CAPSULES"
    },
    {
      "code" : "A020384100",
      "display" : "GFMYCIN CAPSULE 125MG (GRISEOFULVIN) \"WST\""
    },
    {
      "code" : "A020387100",
      "display" : "NAPROXEN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A020395100",
      "display" : "POSESUN TABLET 10MG (HYDRALAZINE) \"G.A.P.\""
    },
    {
      "code" : "A020400100",
      "display" : "RONGHSIC TABLETS \"T.A.\""
    },
    {
      "code" : "A020405100",
      "display" : "AMCLOCIN CAPSULE \"SYNMOSA\""
    },
    {
      "code" : "A020416100",
      "display" : "DEXAMETHASONE TABLETS 1.5MG"
    },
    {
      "code" : "A020420100",
      "display" : "BININ-U TABLETS 2MG (HALOPERIDOL)"
    },
    {
      "code" : "A020421100",
      "display" : "PARANOL TABLETS (ACETAMINOPHEN) \"GCPC\""
    },
    {
      "code" : "A020433100",
      "display" : "MEFENAMIC CAPSULES \"UNION\""
    },
    {
      "code" : "A020435100",
      "display" : "DINSCO TABLETS"
    },
    {
      "code" : "A020436100",
      "display" : "ANECON CAPSULES (ANETHOLE) \"SHIN FONG\""
    },
    {
      "code" : "A020441421",
      "display" : "KINGMIN OPHTHALMIC SOLUTION (SULFAMETHOXAZOLE)"
    },
    {
      "code" : "A020441429",
      "display" : "KINGMIN OPHTHALMIC SOLUTION (SULFAMETHOXAZOLE)"
    },
    {
      "code" : "A020441435",
      "display" : "KINGMIN OPHTHALMIC SOLUTION (SULFAMETHOXAZOLE)"
    },
    {
      "code" : "A020444100",
      "display" : "PARAMOL TABLETS"
    },
    {
      "code" : "A020451100",
      "display" : "ALOPRINOL TABLETS (ALLOPURINOL) \"JOHNSON\""
    },
    {
      "code" : "A020453212",
      "display" : "DIPROPHYLLINE INJECTION \"S.Y.\""
    },
    {
      "code" : "A020455100",
      "display" : "MAGNESIUM HYDROXIDE TABLETS 300MG \"CHEN TA\""
    },
    {
      "code" : "A020458100",
      "display" : "RIBOFLAVIN TETRABUTYRATE TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A020459100",
      "display" : "CP MYCIN CAPSULE 500MG (CEPHALEXIN)\"WP\""
    },
    {
      "code" : "A020460100",
      "display" : "CPMYCIN CAPSULE 250MG \"WASHINGTON\" (CEPHALEXIN)"
    },
    {
      "code" : "A020485100",
      "display" : "JOHNSTAL FILM COATED TABLETS (MEFENAMIC ACID)\"JOHNSON\""
    },
    {
      "code" : "A020489100",
      "display" : "OXETHZINE TABLETS \"H.S.\""
    },
    {
      "code" : "A020490100",
      "display" : "TOLSICOR TABLET (OXPRENOLOL) \"H.H.\""
    },
    {
      "code" : "A020493118",
      "display" : "UNIAN COLD SYRUP"
    },
    {
      "code" : "A020493151",
      "display" : "UNIAN COLD SYRUP"
    },
    {
      "code" : "A020520100",
      "display" : "YU-MIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A020524216",
      "display" : "MORCASIN I.M. INJECTION \"SINPHAR\""
    },
    {
      "code" : "A020528100",
      "display" : "DECAVITAMIN CAPSULES \"HONTEN\""
    },
    {
      "code" : "A020535100",
      "display" : "LOPERAMIDE CAPSULES \"METRO\""
    },
    {
      "code" : "A020538238",
      "display" : "PLEXVITE INJECTION"
    },
    {
      "code" : "A020538277",
      "display" : "PLEXVITE INJECTION"
    },
    {
      "code" : "A020549100",
      "display" : "QUININE HCL CAPSULES \"J.S.\""
    },
    {
      "code" : "A020557100",
      "display" : "ACETOMIN TABLETS 500MG"
    },
    {
      "code" : "A020564100",
      "display" : "SEDON TABLETS \"PRINCE\""
    },
    {
      "code" : "A020570100",
      "display" : "GELCON TABLETS \"Y.K.\""
    },
    {
      "code" : "A020573221",
      "display" : "POTASSIUM CHLORIDE INJECTION 15％"
    },
    {
      "code" : "A020573229",
      "display" : "POTASSIUM CHLORIDE INJECTION 15％"
    },
    {
      "code" : "A020573238",
      "display" : "POTASSIUM CHLORIDE INJECTION 15％"
    },
    {
      "code" : "A020578100",
      "display" : "IB-herbal Cap. \"H.S.\""
    },
    {
      "code" : "A020587321",
      "display" : "BETA-GENTA OINTMENT \"Y.F.\""
    },
    {
      "code" : "A020587335",
      "display" : "BETA-GENTA OINTMENT \"Y.F.\""
    },
    {
      "code" : "A020587340",
      "display" : "BETA-GENTA OINTMENT \"Y.F.\""
    },
    {
      "code" : "A020587343",
      "display" : "BETA-GENTA OINTMENT \"Y.F.\""
    },
    {
      "code" : "A020587348",
      "display" : "BETA-GENTA OINTMENT \"Y.F.\""
    },
    {
      "code" : "A020591265",
      "display" : "DEXT-SALINE INJECTION 2.5:0.45 \"OTSUKA\""
    },
    {
      "code" : "A020591277",
      "display" : "DEXT-SALINE INJECTION 2.5:0.45 \"OTSUKA\""
    },
    {
      "code" : "A020604100",
      "display" : "ALLOPURINOL TABLETS 100MG \"CHEN TA\""
    },
    {
      "code" : "A020613100",
      "display" : "CLONIDINE TABLETS \"H.H.\""
    },
    {
      "code" : "A020616100",
      "display" : "Nitraze Tablets (Nitrazepam)"
    },
    {
      "code" : "A020617100",
      "display" : "ASLOZINE TABLETS (HYDRALAZINE) \"S.C.\""
    },
    {
      "code" : "A020626100",
      "display" : "CODELIN CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A020628100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"N.Y.\""
    },
    {
      "code" : "A020631255",
      "display" : "SOLU-TISONE INJECTION 500MG \"C.C.P.\" (HYDROCORTISONE)"
    },
    {
      "code" : "A020638209",
      "display" : "CEFADOL INJECTION (CEFAMANDOLE)"
    },
    {
      "code" : "A020638277",
      "display" : "CEFADOL INJECTION (CEFAMANDOLE)"
    },
    {
      "code" : "A020639277",
      "display" : "CEFADOL INJECTION 0.5GM (CEFAMANDOLE)"
    },
    {
      "code" : "A020651255",
      "display" : "SOLU-TISONE INJECTION 100MG (HYDROCORTISONE)"
    },
    {
      "code" : "A020656371",
      "display" : "POLVIDINE OINTMENT 10％"
    },
    {
      "code" : "A020664100",
      "display" : "GLIBENCLAMIDE TABLETS \"WINSTON\""
    },
    {
      "code" : "A0206641G0",
      "display" : "GLIBENCLAMIDE TABLETS \"WINSTON\""
    },
    {
      "code" : "A020666100",
      "display" : "RIFAMPICIN CAPSULES 150MG \"N.Y.\""
    },
    {
      "code" : "A020668209",
      "display" : "PANBICORT INJECTION (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A020668221",
      "display" : "PANBICORT INJECTION (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A020668229",
      "display" : "PANBICORT INJECTION (TRIAMCINOLONE) \"PANBIOTIC\""
    },
    {
      "code" : "A020683100",
      "display" : "PROFEN CAPSULES \"WILSON\""
    },
    {
      "code" : "A020684100",
      "display" : "HONLOW TABLETS (NAPROXEN) \"CURIE\""
    },
    {
      "code" : "A020686100",
      "display" : "MENSTERON FORTE CAPSULES \"P.J.\""
    },
    {
      "code" : "A020694429",
      "display" : "ENGENE EYE DROPS \"PATRON\""
    },
    {
      "code" : "A020700100",
      "display" : "KETOPROFEN CAPSULES \"WINSTON\""
    },
    {
      "code" : "A020702100",
      "display" : "UNIQNE TABLETS \"TAITEN\" (MEBENDAZOLE)"
    },
    {
      "code" : "A020707100",
      "display" : "DEPYRETIN TABLETS 500mg(ACETAMINOPHEN)"
    },
    {
      "code" : "A020713100",
      "display" : "DIABEN TABLETS (GLIBENCLAMIDE) \"ROYAL\""
    },
    {
      "code" : "A0207131G0",
      "display" : "DIABEN TABLETS (GLIBENCLAMIDE) \"ROYAL\""
    },
    {
      "code" : "A020715100",
      "display" : "SINTON TABLETS (NAPROXEN) \"CHINTENG\""
    },
    {
      "code" : "A020732209",
      "display" : "PARPON-A INJECTION"
    },
    {
      "code" : "A020738100",
      "display" : "SOUDIPAN TABLETS \"S.Y.\"(DIAZEPAM)"
    },
    {
      "code" : "A020740100",
      "display" : "LIGENCON TABLETS (GLIBENCLAMIDE)"
    },
    {
      "code" : "A020746100",
      "display" : "ALLOPURINE TABLETS (ALLOPURINOL) \"PFOSHEN\""
    },
    {
      "code" : "A020755100",
      "display" : "ERYCIN CAPSULES (ERYTHROMYCIN STEARATE)"
    },
    {
      "code" : "A020756113",
      "display" : "URYCIN FOR ORAL SUSPENSION (ERYTHROMYCIN ETHYLSUCCINATE)"
    },
    {
      "code" : "A020758100",
      "display" : "Coba B12 CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A020769100",
      "display" : "OXETHAZAINE TABLETS 5MG"
    },
    {
      "code" : "A020776100",
      "display" : "YUSU TABLETS (FUROSEMIDE) \"SHINLON\""
    },
    {
      "code" : "A020781100",
      "display" : "TRIAMCINOLONE TABLETS \"N.C.P.\""
    },
    {
      "code" : "A020782209",
      "display" : "PANDOL INJECTION (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A020782212",
      "display" : "PANDOL INJECTION (HALOPERIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A020784100",
      "display" : "U-SORBIDE TABLETS (ISOSORBIDE)"
    },
    {
      "code" : "A020785212",
      "display" : "VOREN INJECTION (DICLOFENAC) \"YUNG SHIN\""
    },
    {
      "code" : "A020785216",
      "display" : "VOREN INJECTION (DICLOFENAC) \"YUNG SHIN\""
    },
    {
      "code" : "A020791100",
      "display" : "PYRAZODINE S.C. TABLETS \"C.H.\" (PHENAZOPYRIDINE)"
    },
    {
      "code" : "A020792209",
      "display" : "CEFOR INJECTION 1000MG (CEPHALORIDINE) \"GCPC\""
    },
    {
      "code" : "A020793100",
      "display" : "ACETAMINOPHEN TABLETS 500MG"
    },
    {
      "code" : "A020799100",
      "display" : "ESRONE TABLETS \"CHEN TA\""
    },
    {
      "code" : "A020800209",
      "display" : "ELICAN INJECTION (ANETHOLE) \"N.K.\""
    },
    {
      "code" : "A020801100",
      "display" : "LIY'S CAPSULES (LOPERAMIDE)\"CURIE\""
    },
    {
      "code" : "A020832100",
      "display" : "DL-METHYLEPHEDRINE HCL TABLET \"C.L.\""
    },
    {
      "code" : "A020842209",
      "display" : "Estradiol Injection\"T.F.\""
    },
    {
      "code" : "A020843212",
      "display" : "Dicyclomine Injection \"K.S.\""
    },
    {
      "code" : "A020846100",
      "display" : "CONEST S.C. TABLETS \"C.H.\" (CONJUGATED ESTROGEN)"
    },
    {
      "code" : "A020847100",
      "display" : "WILCONIN TABLETS \"C.Y.\""
    },
    {
      "code" : "A020849100",
      "display" : "LOPERAMIDE TABLETS 2 MG \"F.Y.\""
    },
    {
      "code" : "A0208491G0",
      "display" : "LOPERAMIDE TABLETS 2 MG \"F.Y.\""
    },
    {
      "code" : "A020852100",
      "display" : "TIN'S TABLETS (CLORPRENALINE) \"CURIE\""
    },
    {
      "code" : "A020854100",
      "display" : "Censolin Tablets"
    },
    {
      "code" : "A020857100",
      "display" : "ROSTAN CAPSULES (BETA-AESCIN) \"CHEN TA\""
    },
    {
      "code" : "A020859118",
      "display" : "CODELIN SYRUP \"CHINTENG\""
    },
    {
      "code" : "A020859119",
      "display" : "CODELIN SYRUP \"CHINTENG\""
    },
    {
      "code" : "A020859199",
      "display" : "CODELIN SYRUP \"CHINTENG\""
    },
    {
      "code" : "A020860100",
      "display" : "SINSOLAX TABLETS"
    },
    {
      "code" : "A020871100",
      "display" : "PROPRA TABLETS 10MG (PROPRANOLOL) \"ROYAL\""
    },
    {
      "code" : "A0208711G0",
      "display" : "PROPRA TABLETS 10MG (PROPRANOLOL) \"ROYAL\""
    },
    {
      "code" : "A020873100",
      "display" : "CLIXIN F.C. TABLETS \"ROYAL\""
    },
    {
      "code" : "A0208731G0",
      "display" : "CLIXIN F.C. TABLETS \"ROYAL\""
    },
    {
      "code" : "A020878212",
      "display" : "PRIMRAN INJECTION (METOCLOPRAMIDE) \"ROYAL\""
    },
    {
      "code" : "A020879151",
      "display" : "HALOLIUM DROPS \"ROYAL\""
    },
    {
      "code" : "A020879199",
      "display" : "HALOLIUM DROPS \"ROYAL\""
    },
    {
      "code" : "A020892329",
      "display" : "SINPHARDERM CREAM \"SINPHAR\""
    },
    {
      "code" : "A020892343",
      "display" : "SINPHARDERM CREAM \"SINPHAR\""
    },
    {
      "code" : "A020893100",
      "display" : "SINAL TABLETS (PROPRANOLOL) \"SINPHAR\""
    },
    {
      "code" : "A020894100",
      "display" : "URINOL TABLETS \"SINPHAR\" (ALLOPURINOL)"
    },
    {
      "code" : "A0208941G0",
      "display" : "URINOL TABLETS \"SINPHAR\" (ALLOPURINOL)"
    },
    {
      "code" : "A020900100",
      "display" : "SIRIN S.C. TABLETS (SILYMARIN) \"Y. S.\""
    },
    {
      "code" : "A020902100",
      "display" : "NEPHRARGIN TABLETS"
    },
    {
      "code" : "A020904100",
      "display" : "JYYKO TABLETS 30MG (DEXTROMETHORPHEN) \"N.C.P.\""
    },
    {
      "code" : "A020908221",
      "display" : "Methocarbamol Injection\"K.S.\""
    },
    {
      "code" : "A020910100",
      "display" : "DOLCOL FILM COATING TABLETS 250MG"
    },
    {
      "code" : "A020911100",
      "display" : "SONCO TABLETS \"ROYAL\""
    },
    {
      "code" : "A020915100",
      "display" : "MATAMFE TABLETS (ETHAMBUTOL) \"HSITEH\""
    },
    {
      "code" : "A020921100",
      "display" : "CEFENINE S.C. TABLETS (DIPHENIDOL)"
    },
    {
      "code" : "A0209211G0",
      "display" : "CEFENINE S.C. TABLETS (DIPHENIDOL)"
    },
    {
      "code" : "A020926329",
      "display" : "FUTOCAN CREAM (FLUO CINOLONE)\"SHINLON\""
    },
    {
      "code" : "A020927100",
      "display" : "PROPRALOL TABLETS \"Y.Y.\" (PROPRANOLOL)"
    },
    {
      "code" : "A020929212",
      "display" : "ISURIN INJECTION (ISOXSUPRINE) \"WINSTON\""
    },
    {
      "code" : "A020930100",
      "display" : "CYRITIN TABLETS (CINNARIZINE) \"SHINLON\""
    },
    {
      "code" : "A020931100",
      "display" : "DOMYCIN CAPSULES"
    },
    {
      "code" : "A020936100",
      "display" : "MUSLAX-A TABLETS \"C.C.P.\""
    },
    {
      "code" : "A020940100",
      "display" : "DOMETON CAPSULES (SULPIRIDE)"
    },
    {
      "code" : "A020941100",
      "display" : "ERYSTAC CAPSULES (ERYTHROMYCIN STEARATE)"
    },
    {
      "code" : "A020948100",
      "display" : "CLONIDINE TABLETS \"Y.S.\""
    },
    {
      "code" : "A020958100",
      "display" : "SINGIPENT TABLETS (PENTAERYTHRITOL)"
    },
    {
      "code" : "A020959100",
      "display" : "CLONIN CAPSULES (CLOMIPHENE)"
    },
    {
      "code" : "A020961100",
      "display" : "AMMONIUM CHLORIDE E.C. TABLETS \"METRO\""
    },
    {
      "code" : "A020964329",
      "display" : "SCABI CREAM (GAMMA-BHC) \"HEALTH\""
    },
    {
      "code" : "A020967421",
      "display" : "GENTAMYCIN OPHTHALMIC SOLUTION \"C.M.\""
    },
    {
      "code" : "A020968212",
      "display" : "Berberin Injection\"K.S.\""
    },
    {
      "code" : "A020972100",
      "display" : "BOUSUZONE TABLETS"
    },
    {
      "code" : "A020975100",
      "display" : "VOLTON CAPSULES (DICLOFENAC) \"N.C.P.\""
    },
    {
      "code" : "A020976100",
      "display" : "SEUSTON CAPSULES (MEFENAMIC ACID)"
    },
    {
      "code" : "A020990100",
      "display" : "GLIBENCLAMIDE TABLETS 5MG"
    },
    {
      "code" : "A020996100",
      "display" : "OPIUM AND GLYCYRRHIZA MIXTURE TABLETS \"ASTAR\""
    },
    {
      "code" : "A020998321",
      "display" : "BEGTI CREAM \"STANDARD\""
    },
    {
      "code" : "A021010100",
      "display" : "LIAID CAPSULES (LOPERAMIDE) \"SHIN FONG\""
    },
    {
      "code" : "A021012209",
      "display" : "WINZOLIN INJECTION 1G (CEFAZOLIN) \"WINSTON\""
    },
    {
      "code" : "A021014100",
      "display" : "Sautun Tablets \"W.P.\" (Dextromethorphan Hydrobromide)"
    },
    {
      "code" : "A021015100",
      "display" : "PATAZOLE TABLETS \"PATRON\" (METHIMAZOLE)"
    },
    {
      "code" : "A021020212",
      "display" : "ORPHENADRINE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A021025100",
      "display" : "KETAFON CAPSULES 50MG (KETOPROFEN) \"G.A.P.\""
    },
    {
      "code" : "A021029100",
      "display" : "FULNIN CAPSULES (LOPERAMIDE) \"PANBIOTIC\""
    },
    {
      "code" : "A021030212",
      "display" : "Biotin-H Injection"
    },
    {
      "code" : "A021032100",
      "display" : "ANTIDIA CAPSULES (LOPERAMIDE) \"F.B.\""
    },
    {
      "code" : "A021033216",
      "display" : "PLEXINA INJECTION \"ROYAL\""
    },
    {
      "code" : "A021036100",
      "display" : "LOTAMIN TABLETS  \"SWISS\"(PROCHLORPERAZINE)"
    },
    {
      "code" : "A021044100",
      "display" : "SUPROGEL TABLETS \"F.Y.\""
    },
    {
      "code" : "A021045430",
      "display" : "COMBAT NASAL SPRAY"
    },
    {
      "code" : "A021045477",
      "display" : "COMBAT NASAL SPRAY"
    },
    {
      "code" : "A021048255",
      "display" : "KANENDOMYCIN SULFATE FOR INJECTION 100MG (POTENCY)"
    },
    {
      "code" : "A021054421",
      "display" : "IANSOU Ophthalmic Solution"
    },
    {
      "code" : "A021054423",
      "display" : "IANSOU Ophthalmic Solution"
    },
    {
      "code" : "A021062321",
      "display" : "AMCICORT CREAM  \"Y.K.\""
    },
    {
      "code" : "A021063100",
      "display" : "LOPEDIN CAPSULES \"STANDARD\"(LOPERAMIDE)"
    },
    {
      "code" : "A021064177",
      "display" : "ANTASIL-B SUSPENSION \"VPP\""
    },
    {
      "code" : "A021064199",
      "display" : "ANTASIL-B SUSPENSION \"VPP\""
    },
    {
      "code" : "A021074209",
      "display" : "SALICON INJECTION \"N.C.P.\""
    },
    {
      "code" : "A021074212",
      "display" : "SALICON INJECTION \"N.C.P.\""
    },
    {
      "code" : "A021075229",
      "display" : "Fuzetamin Injection"
    },
    {
      "code" : "A021075238",
      "display" : "Fuzetamin Injection"
    },
    {
      "code" : "A021078100",
      "display" : "CINNARIZINE TABLETS 50MG \"M.T.\""
    },
    {
      "code" : "A021080100",
      "display" : "CHITONAL TABLETS (ACETAMINOPHEN) \"C.P.\""
    },
    {
      "code" : "A021101113",
      "display" : "ERYSROCIN GRANULES FOR ORAL SUSPENSION (ERYTHROMYCIN ETHYLSUCCINATE)"
    },
    {
      "code" : "A021101143",
      "display" : "ERYSROCIN GRANULES FOR ORAL SUSPENSION (ERYTHROMYCIN ETHYLSUCCINATE)"
    },
    {
      "code" : "A021101172",
      "display" : "ERYSROCIN GRANULES FOR ORAL SUSPENSION (ERYTHROMYCIN ETHYLSUCCINATE)"
    },
    {
      "code" : "A021101199",
      "display" : "ERYSROCIN GRANULES FOR ORAL SUSPENSION (ERYTHROMYCIN ETHYLSUCCINATE)"
    },
    {
      "code" : "A021109229",
      "display" : "HICOVITA INJECTION \"GENTLE\""
    },
    {
      "code" : "A021109238",
      "display" : "HICOVITA INJECTION \"GENTLE\""
    },
    {
      "code" : "A021111151",
      "display" : "KODAPIN SYRUP \"ROYAL\""
    },
    {
      "code" : "A021117100",
      "display" : "ERGOFEIN CAPSULES \"PATRON\""
    },
    {
      "code" : "A021120229",
      "display" : "DEXAMETHASONE INJECTION 0.4％ \"SWISS\""
    },
    {
      "code" : "A021125100",
      "display" : "MEDON CAPSULES (MEDAZEPAM) \"F.S.\""
    },
    {
      "code" : "A021128100",
      "display" : "LOPERA CAPSULES (LOPERAMIDE) \"GOLDEN HORSE\""
    },
    {
      "code" : "A021137123",
      "display" : "SCARTENAN GRANULES"
    },
    {
      "code" : "A021148100",
      "display" : "TRIAMCINOLONE TABLETS \"S.Y.\""
    },
    {
      "code" : "A021152265",
      "display" : "GUROVITAGEN INJECTION \"S.T.\""
    },
    {
      "code" : "A021152277",
      "display" : "GUROVITAGEN INJECTION \"S.T.\""
    },
    {
      "code" : "A021154277",
      "display" : "WINZOLIN INJECTION 500MG \"WINSTON\""
    },
    {
      "code" : "A021155238",
      "display" : "FRUCTOSE INJECTION \"S.Y.\""
    },
    {
      "code" : "A021155265",
      "display" : "FRUCTOSE INJECTION \"S.Y.\""
    },
    {
      "code" : "A021155277",
      "display" : "FRUCTOSE INJECTION \"S.Y.\""
    },
    {
      "code" : "A021157100",
      "display" : "ERYHROMYCIN ESTOLATE CAPSULES \"C.R.\""
    },
    {
      "code" : "A021158212",
      "display" : "SULQUINYL INJECTION \"PATRON\" (SULPIRIDE)"
    },
    {
      "code" : "A021162157",
      "display" : "POLYMINE SYRUP \"HEALTH\""
    },
    {
      "code" : "A021162199",
      "display" : "POLYMINE SYRUP \"HEALTH\""
    },
    {
      "code" : "A021164212",
      "display" : "HUCOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A021167100",
      "display" : "Oxetacain Tablets"
    },
    {
      "code" : "A021189212",
      "display" : "METOCLOPRAMIDE INJECTION \"LITA\""
    },
    {
      "code" : "A021190100",
      "display" : "LOPERAMIDE CAPSULES \"Lita\""
    },
    {
      "code" : "A021191421",
      "display" : "CHLORAMPHENICOL EYE DROPS \"OASIS\""
    },
    {
      "code" : "A021196100",
      "display" : "LIPIMIN TABLETS"
    },
    {
      "code" : "A021199100",
      "display" : "SULPIRIDE CAPSULES \"JOHNSON\""
    },
    {
      "code" : "A021200100",
      "display" : "LOPERAMIDE CAPSULES \"CHI SHENG\""
    },
    {
      "code" : "A021201100",
      "display" : "FUZINE S.C. TABLETS (TRIFLUOPERAZINE HCL) \"SHIN FONG\""
    },
    {
      "code" : "A021202100",
      "display" : "DIABEN TABLETS (GLIBENCLAMIDE) \"SHIN FONG\""
    },
    {
      "code" : "A021204209",
      "display" : "CEFAMON INJECTION (CEFAMANDOLE) \"LITA\""
    },
    {
      "code" : "A021204212",
      "display" : "CEFAMON INJECTION (CEFAMANDOLE) \"LITA\""
    },
    {
      "code" : "A021204277",
      "display" : "CEFAMON INJECTION (CEFAMANDOLE) \"LITA\""
    },
    {
      "code" : "A021207100",
      "display" : "CLONIDINE TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A021210277",
      "display" : "SU CHI LEN INJECTION (CEFAZOLIN)\"SHITEH\""
    },
    {
      "code" : "A021213100",
      "display" : "DICLOCIN CAPSULES (DICLOXACILLIN)"
    },
    {
      "code" : "A021218500",
      "display" : "CHLORAMPHENICOL SUPPOSITORIES \"YUNG CHI\""
    },
    {
      "code" : "A021223209",
      "display" : "AMPICILLIN INJECTION 1GM (POTENCY)/VIAL \"TAI YU\""
    },
    {
      "code" : "A021227100",
      "display" : "LOPERIN CAPSULES (LOPERAMIDE) \"AND\""
    },
    {
      "code" : "A021228100",
      "display" : "LOPERADIUM CAPSULES (LOPERAMIDE) \"P.J.\""
    },
    {
      "code" : "A021237100",
      "display" : "KACOUIXON CAPSULES \"ORIENTAL\""
    },
    {
      "code" : "A021241100",
      "display" : "METOCLOPRAMIDE HCL S.C. TABLETS 10MG \"Jensheng\""
    },
    {
      "code" : "A021242118",
      "display" : "RITUSSIN SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021242199",
      "display" : "RITUSSIN SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021253100",
      "display" : "SUCOTIN TABLETS (SALBUTAMOL) \"WINSTON\""
    },
    {
      "code" : "A021263212",
      "display" : "BERIAN INJECTION \"N.K.\""
    },
    {
      "code" : "A021265100",
      "display" : "LIVERGEN CAPSULES \"ROYAL\""
    },
    {
      "code" : "A021268212",
      "display" : "TOBCIN INJECTION 40MG/ML (TOBRAMYCIN) \"N.K.\""
    },
    {
      "code" : "A021272100",
      "display" : "LYSOZYME TABLETS"
    },
    {
      "code" : "A021274100",
      "display" : "XANPLAMIN TABLETS 150MG (XANTHINOL NICOTINATE) \"VPP\""
    },
    {
      "code" : "A021281212",
      "display" : "KETOPROFEN I.M. INJECTION  \"Y.Y.\""
    },
    {
      "code" : "A021282100",
      "display" : "HILO BU FU TABLETS (ALLOPURINOL)"
    },
    {
      "code" : "A021290100",
      "display" : "FLOPROPIONE CAPSULES \"M.T.\""
    },
    {
      "code" : "A021298100",
      "display" : "COBAMAMIDE CAPSULES \"M.T.\""
    },
    {
      "code" : "A0212981G0",
      "display" : "COBAMAMIDE CAPSULES \"M.T.\""
    },
    {
      "code" : "A021300100",
      "display" : "PYRANAL TABLETS (ACETAMINOPHEN) \"HSIN FONG"
    },
    {
      "code" : "A021302100",
      "display" : "BUCATON TABLETS"
    },
    {
      "code" : "A021316100",
      "display" : "SALBUTAMOL TABLETS \"M.T.\""
    },
    {
      "code" : "A021317110",
      "display" : "KEFLOR GRANULES FOR ORAL SUSPENSION 125MG PER 5ML (CEFACLOR)"
    },
    {
      "code" : "A021317158",
      "display" : "KEFLOR GRANULES FOR ORAL SUSPENSION 125MG PER 5ML (CEFACLOR)"
    },
    {
      "code" : "A021317189",
      "display" : "KEFLOR GRANULES FOR ORAL SUSPENSION 125MG PER 5ML (CEFACLOR)"
    },
    {
      "code" : "A021317199",
      "display" : "KEFLOR GRANULES FOR ORAL SUSPENSION 125MG PER 5ML (CEFACLOR)"
    },
    {
      "code" : "A021326100",
      "display" : "ISIDIUM CAPSULES \"Y.K.\""
    },
    {
      "code" : "A021328100",
      "display" : "SILYGEN CAPSULES \"STANDARD\""
    },
    {
      "code" : "A0213281G0",
      "display" : "SILYGEN CAPSULES \"STANDARD\""
    },
    {
      "code" : "A021331100",
      "display" : "LEVASOL F.C. TABLETS (LEVAMISOLE) \"ROYAL\""
    },
    {
      "code" : "A021340100",
      "display" : "PACOUGH TABLETS \"PATRON\""
    },
    {
      "code" : "A021343238",
      "display" : "POTASSIUM PHOSPHATE INJECTION"
    },
    {
      "code" : "A021344421",
      "display" : "SUSON OPHTHALMIC SOL;UTION \"YS\""
    },
    {
      "code" : "A021362100",
      "display" : "DICLO-DENK 25"
    },
    {
      "code" : "A021366100",
      "display" : "BENZYUANINE CAPSULES"
    },
    {
      "code" : "A021372221",
      "display" : "PIRACETAM INJECTION \"Y.Y.\""
    },
    {
      "code" : "A021372238",
      "display" : "PIRACETAM INJECTION \"Y.Y.\""
    },
    {
      "code" : "A021376277",
      "display" : "SUPERCILLIN FOR INJECTION 500MG \"VPP\""
    },
    {
      "code" : "A021381100",
      "display" : "FUCHEN CAPSULES \"CURIE\""
    },
    {
      "code" : "A021383100",
      "display" : "PAPACOTIN TABLETS \"PRINCE\""
    },
    {
      "code" : "A021388100",
      "display" : "EGALON-B CAPSULES \"N.K.\""
    },
    {
      "code" : "A021389100",
      "display" : "LOPERAMIDE CAPSULES \"KODAK\""
    },
    {
      "code" : "A021390100",
      "display" : "HECAMOL TABLETS (ACETAMINOPHEN) \"HEALTH\""
    },
    {
      "code" : "A021391309",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021391321",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021391329",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021391335",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021391338",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021391372",
      "display" : "TEPSIM CREAM (FLUOCINONIDE) \"C.R.\""
    },
    {
      "code" : "A021395500",
      "display" : "INDOMETHACIN SUPPOSITORIES \"PFOSHEN\""
    },
    {
      "code" : "A021398321",
      "display" : "URESON CREAM \"CHIUPO\""
    },
    {
      "code" : "A021399100",
      "display" : "NAPROXEN TABLETS \"LITA\""
    },
    {
      "code" : "A021401100",
      "display" : "TAGAMET TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A021406100",
      "display" : "WETONLIN TABLETS \"M.T.\""
    },
    {
      "code" : "A0214061G0",
      "display" : "WETONLIN TABLETS \"M.T.\""
    },
    {
      "code" : "A021410221",
      "display" : "ANSUCORT INJECTION 10MG/ML \"S.T.\"(TRIAMCINOLONE)"
    },
    {
      "code" : "A021410229",
      "display" : "ANSUCORT INJECTION 10MG/ML \"S.T.\"(TRIAMCINOLONE)"
    },
    {
      "code" : "A021411100",
      "display" : "AISZEN-S S.C. TABLETS \"HONTEN\""
    },
    {
      "code" : "A021417100",
      "display" : "ERGONOSAN TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE) \"Y.F.\""
    },
    {
      "code" : "A021418212",
      "display" : "WINZOLIN INJECTION 2GM (CEFAZOLIN) \"WINSTON\""
    },
    {
      "code" : "A021434100",
      "display" : "KEFLOR PULVULES 250MG (CEFACLOR)"
    },
    {
      "code" : "A021439100",
      "display" : "ANFONKER CAPSULES \"K.B.\""
    },
    {
      "code" : "A021441100",
      "display" : "AMOXICILLIN CAPSULES \"TAI YU\""
    },
    {
      "code" : "A021449100",
      "display" : "Bromelain E.C. Tablets \"F.Y.\""
    },
    {
      "code" : "A021450238",
      "display" : "SUNSUVITA INJECTION \"S.Y.\""
    },
    {
      "code" : "A021452118",
      "display" : "ISIDIUM SYRUPS (LOPERAMIDE) \"N.W.\""
    },
    {
      "code" : "A021452157",
      "display" : "ISIDIUM SYRUPS (LOPERAMIDE) \"N.W.\""
    },
    {
      "code" : "A021455335",
      "display" : "XYLMOL OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A021459100",
      "display" : "ACTIVE TABLETS (LEVAMISOLE)"
    },
    {
      "code" : "A021462100",
      "display" : "ZECOL TABLETS"
    },
    {
      "code" : "A0214621G0",
      "display" : "ZECOL TABLETS"
    },
    {
      "code" : "A021463209",
      "display" : "ATROPINE SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A021464209",
      "display" : "VITAMIN K3 INJECTION (MENADION SODIUM BISULFITE) \"ASTAR\""
    },
    {
      "code" : "A021464221",
      "display" : "VITAMIN K3 INJECTION (MENADION SODIUM BISULFITE) \"ASTAR\""
    },
    {
      "code" : "A021470100",
      "display" : "NO-MINE TABLETS \"W.P.\" (CARBINOXAMINE MALEATE)"
    },
    {
      "code" : "A021472316",
      "display" : "KINGTRILONE CREAM (TRIAMCINOLONE) \"HEALTH\""
    },
    {
      "code" : "A021480100",
      "display" : "CLONIDINE TABLETS \"SWISS\""
    },
    {
      "code" : "A0214801G0",
      "display" : "CLONIDINE TABLETS \"SWISS\""
    },
    {
      "code" : "A021484100",
      "display" : "TONCOPIN TABLETS \"N.C.P.\""
    },
    {
      "code" : "A021491100",
      "display" : "IZAN E.C. TABLETS 100MG (BROMELAIN) \"LITA\""
    },
    {
      "code" : "A021495100",
      "display" : "ATIPAM TABLETS (LORAZEPAM) \"ROYAL\""
    },
    {
      "code" : "A0214951G0",
      "display" : "ATIPAM TABLETS (LORAZEPAM) \"ROYAL\""
    },
    {
      "code" : "A021507100",
      "display" : "OXECAIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A021509100",
      "display" : "SOLARGIN F.C. TABLETS 100MG (CHLORPROMAZINE)\"GCPC\""
    },
    {
      "code" : "A021514100",
      "display" : "CHLORZOXAZONE TABLETS 200MG"
    },
    {
      "code" : "A021529100",
      "display" : "EXTANCIN TABLETS \"H.S.\""
    },
    {
      "code" : "A021534100",
      "display" : "CLEMASTINE CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A021536100",
      "display" : "KUFETIN TABLETS (MEBENDAZOLE)\"MEY SEE\""
    },
    {
      "code" : "A021539100",
      "display" : "RISONIN CAPSULES \"D.T.S.\""
    },
    {
      "code" : "A021552100",
      "display" : "Suntonin Capsules \"Standard\""
    },
    {
      "code" : "A021554100",
      "display" : "WEIANCHI TABLETS"
    },
    {
      "code" : "A021557100",
      "display" : "CLODIN FILM COATED TABLETS (CLONIDINE) \"YUNG SHIN\""
    },
    {
      "code" : "A021558100",
      "display" : "SIMETHON TABLETS (DIMETHICONE) \"AND\""
    },
    {
      "code" : "A021563100",
      "display" : "WINMOX CAPSULES 500MG (AMOXICILLIN) \"WINSTON\""
    },
    {
      "code" : "A021566100",
      "display" : "PYDAMOLE S.C. TABLETS  25 MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A021572421",
      "display" : "BELINRON EYE DROPS \"M.L.C.\""
    },
    {
      "code" : "A021573316",
      "display" : "SCHEREE CREAM \"BOWLIN\""
    },
    {
      "code" : "A021573324",
      "display" : "SCHEREE CREAM \"BOWLIN\""
    },
    {
      "code" : "A021577335",
      "display" : "VANCARE OINTMENT"
    },
    {
      "code" : "A021578229",
      "display" : "NUTRASE INJECTION 10MG (COCARBOXYLASE)"
    },
    {
      "code" : "A021586100",
      "display" : "DIMENHYDRINATE TABLETS \"Union\""
    },
    {
      "code" : "A021587321",
      "display" : "FMINA CREAM (MICONAZOLE)"
    },
    {
      "code" : "A021591100",
      "display" : "AMPICILLIN CAPSULES \"TAI YU\""
    },
    {
      "code" : "A021602100",
      "display" : "COASMALIN TABLETS \"ASTAR\""
    },
    {
      "code" : "A021603100",
      "display" : "HEMALOL TABLETS \"SWISS\" (PROPRANOLOL)"
    },
    {
      "code" : "A021606100",
      "display" : "WINLIPAN CAPSULES (LOPERAMIDE) \"WINSTON\""
    },
    {
      "code" : "A0216061G0",
      "display" : "WINLIPAN CAPSULES (LOPERAMIDE) \"WINSTON\""
    },
    {
      "code" : "A021607100",
      "display" : "ALDOPA FILM COATED TABLETS (METHYLDOPA) \"YUNG SHIN\""
    },
    {
      "code" : "A021608100",
      "display" : "R.H.H. TABLETS \"N.M.\""
    },
    {
      "code" : "A021611100",
      "display" : "DEXAMETHASONE TABLETS \"M.T.\""
    },
    {
      "code" : "A021614100",
      "display" : "SPOLINE S.C. TABLETS (SCOPOLAMINE BUTYLBROMIDE)"
    },
    {
      "code" : "A021619180",
      "display" : "ULEX FOR ORAL SUSPENSION 250MG (CEPHALEXINE)"
    },
    {
      "code" : "A021619199",
      "display" : "ULEX FOR ORAL SUSPENSION 250MG (CEPHALEXINE)"
    },
    {
      "code" : "A021622100",
      "display" : "MEPRAM S.C. TABLETS (METOCLOPRAMIDE) \"SHINLON\""
    },
    {
      "code" : "A021623109",
      "display" : "COSOPHYLLINE GRANULES \"ORIENTAL\""
    },
    {
      "code" : "A021623199",
      "display" : "COSOPHYLLINE GRANULES \"ORIENTAL\""
    },
    {
      "code" : "A021629265",
      "display" : "TAITA NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021629277",
      "display" : "TAITA NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021630265",
      "display" : "TAITA NO.2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021630277",
      "display" : "TAITA NO.2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021632265",
      "display" : "TAITA NO.1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021632277",
      "display" : "TAITA NO.1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A021633399",
      "display" : "ANCO CREAM (SILVER SULFADIAZINE) \"ROYAL\""
    },
    {
      "code" : "A021635100",
      "display" : "LIPIN TABLETS (METHYLSCOPOLAMINE METHYLSULFAT) \"ROYAL\""
    },
    {
      "code" : "A0216351G0",
      "display" : "LIPIN TABLETS (METHYLSCOPOLAMINE METHYLSULFAT) \"ROYAL\""
    },
    {
      "code" : "A021638100",
      "display" : "COUGHSTOP TABLETS (CHLOPHEDIANOL) \"SHIN FONG\""
    },
    {
      "code" : "A021640100",
      "display" : "GLIDIAB TABLETS 5MG(GLIPIZIDE)"
    },
    {
      "code" : "A0216401G0",
      "display" : "GLIDIAB TABLETS 5MG(GLIPIZIDE)"
    },
    {
      "code" : "A021645100",
      "display" : "ANPOLIN TABLETS 25MG"
    },
    {
      "code" : "A021648100",
      "display" : "NAPROXEN TAB. 250MG"
    },
    {
      "code" : "A021652118",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021652143",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021652151",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021652155",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021652157",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021652199",
      "display" : "MINTAPP SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021656100",
      "display" : "TEOLLIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A021670212",
      "display" : "Dexamethasone Phosphate Injection 5 mg \"K.S.\""
    },
    {
      "code" : "A021670229",
      "display" : "Dexamethasone Phosphate Injection 5 mg \"K.S.\""
    },
    {
      "code" : "A021674100",
      "display" : "WEIDOSON TABLETS"
    },
    {
      "code" : "A021678151",
      "display" : "CODIN P SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021678157",
      "display" : "CODIN P SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021678162",
      "display" : "CODIN P SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021678199",
      "display" : "CODIN P SYRUP \"SINPHAR\""
    },
    {
      "code" : "A021681100",
      "display" : "GRAMAZINE TABLETS 500MG (NALIDIXIC ACID) \"JOHSON\""
    },
    {
      "code" : "A021684100",
      "display" : "CLONIDINE TABLETS \"JOHNSON\""
    },
    {
      "code" : "A021689100",
      "display" : "CEPORMYCIN CAPSULES (CEPHALEXIN) \"ORIENTAL\""
    },
    {
      "code" : "A021693100",
      "display" : "LOPERAMIDE CAPSULES \"Y.C.\""
    },
    {
      "code" : "A021697100",
      "display" : "ACETAMINOPHEN TABLET 500MG"
    },
    {
      "code" : "A021698100",
      "display" : "CONA SINGAN CAPSULES"
    },
    {
      "code" : "A021699100",
      "display" : "THIOCON S.C. TABLETS (ANETHOLE)"
    },
    {
      "code" : "A021703100",
      "display" : "GENLATIN CAPSULES \"TAITEN\" (LOPERAMIDE)"
    },
    {
      "code" : "A021706100",
      "display" : "Rifampin Capsules 450 mg \"VPC\""
    },
    {
      "code" : "A021707100",
      "display" : "PERAMIDE CAPSULES (LOPERAMIDE)"
    },
    {
      "code" : "A021709212",
      "display" : "TRANEXAMIC ACID INJECTION \"S.Y.\""
    },
    {
      "code" : "A021709221",
      "display" : "TRANEXAMIC ACID INJECTION \"S.Y.\""
    },
    {
      "code" : "A021709238",
      "display" : "TRANEXAMIC ACID INJECTION \"S.Y.\""
    },
    {
      "code" : "A021711100",
      "display" : "POTOSINTIN S.C. TABLETS (DIPYRIDAMOLE)"
    },
    {
      "code" : "A021715100",
      "display" : "MEBENDAZOLE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A021719438",
      "display" : "NASAL SPRAY \"NYSCO\""
    },
    {
      "code" : "A021724372",
      "display" : "MICONAZOLE CREAM \"Y.S.\""
    },
    {
      "code" : "A021724399",
      "display" : "MICONAZOLE CREAM \"Y.S.\""
    },
    {
      "code" : "A021726100",
      "display" : "PADELIN TABLETS (LORAZEPAM) \"PATRON\""
    },
    {
      "code" : "A021730209",
      "display" : "LIFOXITIN INJECTION (CEFOXITIN) \"LITA\""
    },
    {
      "code" : "A021731151",
      "display" : "ANTISEMIN DRY SYRUP (CYPROHEPTADINE)"
    },
    {
      "code" : "A021731157",
      "display" : "ANTISEMIN DRY SYRUP (CYPROHEPTADINE)"
    },
    {
      "code" : "A021737100",
      "display" : "VITAMIN B2 TABLETS \"H.C.\""
    },
    {
      "code" : "A021743100",
      "display" : "FELDENE CAPSULES 10MG"
    },
    {
      "code" : "A021747435",
      "display" : "CATALIN OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A021748277",
      "display" : "6-H.E.S. INJECTION"
    },
    {
      "code" : "A021754100",
      "display" : "COLCIN TABLETS (COLCHICINE)"
    },
    {
      "code" : "A0217541G0",
      "display" : "COLCIN TABLETS (COLCHICINE)"
    },
    {
      "code" : "A021755100",
      "display" : "BIOGEN TABLETS \"ROYAL\""
    },
    {
      "code" : "A021756209",
      "display" : "SCODEXIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A021758100",
      "display" : "MEDICON-A CAPSULES"
    },
    {
      "code" : "A0217581G0",
      "display" : "MEDICON-A CAPSULES"
    },
    {
      "code" : "A021765100",
      "display" : "OXECAIN TABLETS"
    },
    {
      "code" : "A021767100",
      "display" : "DIPHENIDOL S.C. TABLETS"
    },
    {
      "code" : "A021776118",
      "display" : "CODEPIN SYRUP \"Center\""
    },
    {
      "code" : "A021776151",
      "display" : "CODEPIN SYRUP \"Center\""
    },
    {
      "code" : "A021776157",
      "display" : "CODEPIN SYRUP \"Center\""
    },
    {
      "code" : "A021791100",
      "display" : "SUPRAGEL TABLETS"
    },
    {
      "code" : "A021792100",
      "display" : "CHLORZOXAZONE TABLETS \"ASTAR\""
    },
    {
      "code" : "A021794135",
      "display" : "POLYGEL SUSPENSION \"STANDARD\""
    },
    {
      "code" : "A021801100",
      "display" : "SULFAGEN TABLETS (SULFADIMETHOXINE) \"K.B.\""
    },
    {
      "code" : "A021802100",
      "display" : "CONVELON S.C. TABLETS (METHYL METHIOMINE SULFONIUM CHLORIED) \"K.B.\""
    },
    {
      "code" : "A021804100",
      "display" : "LIMICON CAPSULES (NITROFURANTOIN) \"K.B.\""
    },
    {
      "code" : "A021805100",
      "display" : "BENDOCIN CAPSULES (INDOMETHACIN) \"K.B.\""
    },
    {
      "code" : "A021806100",
      "display" : "SHU TONG JIA TABLETS \"C.M.\""
    },
    {
      "code" : "A021815100",
      "display" : "BROMELAIN ENTERIC SUGAR COATED TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A021817100",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"PRINCE\""
    },
    {
      "code" : "A021819100",
      "display" : "LOPERAMIDE CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A021820100",
      "display" : "SERPATHIAZIDE F.C. TABLETS \"WST\""
    },
    {
      "code" : "A021830100",
      "display" : "LOPERAMIN TABLETS (LOPERAMIDE) \"M.T.\""
    },
    {
      "code" : "A021832100",
      "display" : "TONPASS CAPSULES 250MG (MEFENAMIC ACID) \"JINUP\""
    },
    {
      "code" : "A021841100",
      "display" : "SUMINCON TABLETS \"H.S.\""
    },
    {
      "code" : "A021844129",
      "display" : "ANTAGEL II LIQUID \"GCPC\""
    },
    {
      "code" : "A021845321",
      "display" : "BEAUTYSKIN CREAM \"ROYAL\""
    },
    {
      "code" : "A021853329",
      "display" : "DAFRIN CREAM \"SWISS\" (MICONAZOLE)"
    },
    {
      "code" : "A021855100",
      "display" : "COLD S.C. TABLET \"WELCAN\""
    },
    {
      "code" : "A021856100",
      "display" : "UNDECA S.C. TABLETS \"VPP\""
    },
    {
      "code" : "A021857109",
      "display" : "AZUEIN GRANULES \"Y.Y\" (AZULENE)"
    },
    {
      "code" : "A021857155",
      "display" : "AZUEIN GRANULES \"Y.Y\" (AZULENE)"
    },
    {
      "code" : "A021857172",
      "display" : "AZUEIN GRANULES \"Y.Y\" (AZULENE)"
    },
    {
      "code" : "A021857199",
      "display" : "AZUEIN GRANULES \"Y.Y\" (AZULENE)"
    },
    {
      "code" : "A021863100",
      "display" : "CHIZENSWN TABLETS (ORCIPRENALINE)\"CURIE\""
    },
    {
      "code" : "A021864100",
      "display" : "KOUNEN CAPSULES 200MG (IBUPROFEN)\"CURIE\""
    },
    {
      "code" : "A021870100",
      "display" : "Astar Tablets"
    },
    {
      "code" : "A021871100",
      "display" : "MEBEZOL TABLETS (MEBENDAZOLE) \"JOHNSON\""
    },
    {
      "code" : "A021875100",
      "display" : "IMODE CAPSULES \"YU SHENG\" (LOPERAMIDE)"
    },
    {
      "code" : "A021877209",
      "display" : "KANAMYCIN SULFATE FOR INJECTION \"KINGDOM\""
    },
    {
      "code" : "A021880316",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021880321",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021880329",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021880355",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021880372",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021880399",
      "display" : "WANT CREAM \"M.D.\""
    },
    {
      "code" : "A021882100",
      "display" : "NINGILON CAPSULES \"P.L.\""
    },
    {
      "code" : "A021883209",
      "display" : "AMINOL 12X INJECTION"
    },
    {
      "code" : "A021883263",
      "display" : "AMINOL 12X INJECTION"
    },
    {
      "code" : "A021883265",
      "display" : "AMINOL 12X INJECTION"
    },
    {
      "code" : "A021883266",
      "display" : "AMINOL 12X INJECTION"
    },
    {
      "code" : "A021886100",
      "display" : "BETAMETHASONE TABLETS \"S.Y.\""
    },
    {
      "code" : "A021887416",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021887417",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021887421",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021887423",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021887429",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021887499",
      "display" : "LECORTIN ORAL BASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A021890100",
      "display" : "METATU HON TABLETS"
    },
    {
      "code" : "A021893209",
      "display" : "METHYLERGONOVINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A021896100",
      "display" : "PISUTON CAPSULE (MEFENAMIC ACID) \"PRINCE\""
    },
    {
      "code" : "A021898100",
      "display" : "CITOPHENE CAPSULES (CLOMIPHENE) \"P.L.\""
    },
    {
      "code" : "A021902100",
      "display" : "NICOTINIC ACID TABLETS \"KINGDOM\""
    },
    {
      "code" : "A021905100",
      "display" : "WINTEL CAPSULES (TETRACYCLINE METAPHOSPHATE)\"WINSTON\""
    },
    {
      "code" : "A0219051G0",
      "display" : "WINTEL CAPSULES (TETRACYCLINE METAPHOSPHATE)\"WINSTON\"(鋁箔)"
    },
    {
      "code" : "A021909100",
      "display" : "GLUIN TABLETS (GLIBENCLAMIDE) \"K.B.\""
    },
    {
      "code" : "A021923100",
      "display" : "SODIUM BICARBONATE TABLETS \"ASTAR\""
    },
    {
      "code" : "A021924309",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924321",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924323",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924329",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924336",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924351",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924372",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021924399",
      "display" : "MY COMB CREAM \"SINPHAR\""
    },
    {
      "code" : "A021932100",
      "display" : "CLEMASTINE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A021955209",
      "display" : "TONSTOP INJECTION  \"STANDARD\"(ORPHENADRINE)"
    },
    {
      "code" : "A021955212",
      "display" : "TONSTOP INJECTION  \"STANDARD\"(ORPHENADRINE)"
    },
    {
      "code" : "A021955299",
      "display" : "TONSTOP INJECTION  \"STANDARD\"(ORPHENADRINE)"
    },
    {
      "code" : "A021957100",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS \"N.Y.\""
    },
    {
      "code" : "A021959209",
      "display" : "BETAMETHASONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A021959221",
      "display" : "BETAMETHASONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A021959229",
      "display" : "BETAMETHASONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A021960118",
      "display" : "COCOSAU SYRUP \"Y.Y\""
    },
    {
      "code" : "A021960151",
      "display" : "COCOSAU SYRUP \"Y.Y\""
    },
    {
      "code" : "A021960157",
      "display" : "COCOSAU SYRUP \"Y.Y\""
    },
    {
      "code" : "A021961100",
      "display" : "CEPHADROXIL CAPSULES \"LITA\""
    },
    {
      "code" : "A021965100",
      "display" : "LYSOZYME TABLETS 30MG \"M.T.\""
    },
    {
      "code" : "A021978221",
      "display" : "URAMIN INJECTION (DOPAMINE)"
    },
    {
      "code" : "A021979165",
      "display" : "KEFLOR GRANULES FOR ORAL SUSPENSION 250MG PER 5ML (CEFACLOR)"
    },
    {
      "code" : "A021980100",
      "display" : "KEFLOR PULVULES 500MG (CEFACLOR)"
    },
    {
      "code" : "A021981417",
      "display" : "NINCORT ORAL GEL (TRIAMCINOLONE) \"SINPHAR\""
    },
    {
      "code" : "A021981421",
      "display" : "NINCORT ORAL GEL (TRIAMCINOLONE) \"SINPHAR\""
    },
    {
      "code" : "A021981423",
      "display" : "NINCORT ORAL GEL (TRIAMCINOLONE) \"SINPHAR\""
    },
    {
      "code" : "A021981455",
      "display" : "NINCORT ORAL GEL (TRIAMCINOLONE) \"SINPHAR\""
    },
    {
      "code" : "A021981499",
      "display" : "NINCORT ORAL GEL (TRIAMCINOLONE) \"SINPHAR\""
    },
    {
      "code" : "A021990100",
      "display" : "SONCHI TABLETS"
    },
    {
      "code" : "A021994100",
      "display" : "VI JANE CAPSULES (FLUOXYMESTERONE) \"S.T.\""
    },
    {
      "code" : "A021995209",
      "display" : "KOGIFON INJECTION"
    },
    {
      "code" : "A021995212",
      "display" : "KOGIFON INJECTION"
    },
    {
      "code" : "A021996100",
      "display" : "OPIUM AND GLYCYRRHIZA MIXTURE TABLETS \"ASTAR\""
    },
    {
      "code" : "A0219961G0",
      "display" : "OPIUM AND GLYCYRRHIZA MIXTURE TABLETS \"ASTAR\""
    },
    {
      "code" : "A022002100",
      "display" : "PAMOXICILLIN CAPSULES 500MG (AMOXICILLIN) \"C.Y.\""
    },
    {
      "code" : "A022007100",
      "display" : "TINIDAZOLE TABLETS"
    },
    {
      "code" : "A022010212",
      "display" : "HYCOMIN INJECTION \"S.Y.\" (HYDROXOCOBALAMINE)"
    },
    {
      "code" : "A022010229",
      "display" : "HYCOMIN INJECTION \"S.Y.\" (HYDROXOCOBALAMINE)"
    },
    {
      "code" : "A022013421",
      "display" : "DECANEO EYE DROPS \"T.F.\""
    },
    {
      "code" : "A022014100",
      "display" : "THYOBUROL CAPSULES \"N.C.P\""
    },
    {
      "code" : "A022020100",
      "display" : "ALUMINGEL TABLETS \"JEN SHENG\" (ALUMINUM HYDROXIDE GEL)"
    },
    {
      "code" : "A022023100",
      "display" : "FUSO TABLETS \"ROYAL\""
    },
    {
      "code" : "A022030100",
      "display" : "WEOSOLO TABLETS \"M.S.\""
    },
    {
      "code" : "A022033100",
      "display" : "ROMTEC TABLETS \"J.S.\""
    },
    {
      "code" : "A022034321",
      "display" : "ACNED GEL \"SINPHAR\" (TRETINOIN)"
    },
    {
      "code" : "A022036100",
      "display" : "WINII TABLETS (DIAZEPAM) \"WINSTON\""
    },
    {
      "code" : "A022043100",
      "display" : "ALETON TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A022045100",
      "display" : "CARMEITON TABLETS \"N.C.P.\""
    },
    {
      "code" : "A022047100",
      "display" : "RIFAMPIN CAPSULES 300MG \"W.P.\""
    },
    {
      "code" : "A022049209",
      "display" : "DIPHENHYDRAMINE HCL INJECTION \"TAI YU\""
    },
    {
      "code" : "A022050100",
      "display" : "EDEPRESS CAPSULES \"SHIN FONG\""
    },
    {
      "code" : "A022055238",
      "display" : "PROVITA INJECTION \"S.T.\""
    },
    {
      "code" : "A022058100",
      "display" : "GLULI TABLETS (GLIBENCLAMIDE)\"W.P.\""
    },
    {
      "code" : "A022062100",
      "display" : "AMOXICILLIN CAPSULES \"SINTON\""
    },
    {
      "code" : "A022065100",
      "display" : "RIFAMPIN CAPSULES 150MG \"W.P.\""
    },
    {
      "code" : "A022069100",
      "display" : "SILYMARIN CAPSULES \"P.L.\""
    },
    {
      "code" : "A022073229",
      "display" : "HI-METHASONE INJECTION  \"TAH-AN\""
    },
    {
      "code" : "A022077100",
      "display" : "COLCHICINE TABLETS \"N.Y.\""
    },
    {
      "code" : "A022078321",
      "display" : "ANTIFUNGUS CREAM \"GCPC\""
    },
    {
      "code" : "A022081100",
      "display" : "Z-C F.C. TABLETS \"GCPC\""
    },
    {
      "code" : "A022082248",
      "display" : "NUTRASE INJECTION 50MG (COCARBOXYLASE)"
    },
    {
      "code" : "A022083238",
      "display" : "NUTRASE INJECTION 20MG (COCARBOXYLASE)"
    },
    {
      "code" : "A022084100",
      "display" : "TECOLIN TABLETS \"ROYAL\""
    },
    {
      "code" : "A022092100",
      "display" : "GASZEPIN TABLETS (PIRENZEPINE) \"SWISS\""
    },
    {
      "code" : "A022096118",
      "display" : "APPITAMINE SYRUP"
    },
    {
      "code" : "A022096151",
      "display" : "APPITAMINE SYRUP"
    },
    {
      "code" : "A022096174",
      "display" : "APPITAMINE SYRUP"
    },
    {
      "code" : "A022096199",
      "display" : "APPITAMINE SYRUP"
    },
    {
      "code" : "A022100100",
      "display" : "LYZOIN TABLETS (LYSOZYME) \"YUNG CHI\""
    },
    {
      "code" : "A022105100",
      "display" : "ULEXIN CAPSULES 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A022106100",
      "display" : "SABUCHAN TABLETS \"Y.K.\" (SALBUTAMOL)"
    },
    {
      "code" : "A022107118",
      "display" : "SINTAPP ELIXIR"
    },
    {
      "code" : "A022107199",
      "display" : "SINTAPP ELIXIR"
    },
    {
      "code" : "A022109100",
      "display" : "IMODINE CAPSULES (LOPERAMIDE)"
    },
    {
      "code" : "A022114321",
      "display" : "CLOTRIMAZOLE CREAM \"PRINCE\""
    },
    {
      "code" : "A022115212",
      "display" : "CIMETINE INJECTION \"PATRON\" (CIMETIDINE)"
    },
    {
      "code" : "A022117100",
      "display" : "PANACON TABLETS"
    },
    {
      "code" : "A022118100",
      "display" : "BROWN MIXTURE TABLETS \"N.Y.\""
    },
    {
      "code" : "A022120100",
      "display" : "WHITE ANTI-PEPTIC ULCER TABLETS (GEFARNATE)"
    },
    {
      "code" : "A022122100",
      "display" : "LACTAM TABLETS \"SINPHAR\"(ACETAMINOPHEN)"
    },
    {
      "code" : "A022123100",
      "display" : "IMOLEX CAPSULES \"SINPHAR\" (LOPERAMIDE)"
    },
    {
      "code" : "A0221231G0",
      "display" : "IMOLEX CAPSULES \"SINPHAR\" (LOPERAMIDE)"
    },
    {
      "code" : "A022124100",
      "display" : "TONLAXAN ETERIC-COATED TABLETS \"Y.K.\""
    },
    {
      "code" : "A022126100",
      "display" : "MIXANATE CAPSULES \"SHIN FONG\""
    },
    {
      "code" : "A022128100",
      "display" : "DIAZEPAM TABLETS \"TAI YU\""
    },
    {
      "code" : "A022139421",
      "display" : "NEOMYCIN EYE DROPS \"OASIS\""
    },
    {
      "code" : "A022140100",
      "display" : "LIFUNE TABLETS \"CHEN TA\""
    },
    {
      "code" : "A022141100",
      "display" : "SILIPIN TABLETS 50MG \"H.S.\""
    },
    {
      "code" : "A022150100",
      "display" : "CHICOUGH TABLETS (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A022159209",
      "display" : "LEUCOVORIN CALCIUM INJECTION"
    },
    {
      "code" : "A022159221",
      "display" : "LEUCOVORIN CALCIUM INJECTION"
    },
    {
      "code" : "A022172100",
      "display" : "POUTANCHIN TABLETS (DEHYDROCHOLIC ACID ) \"CURIE\""
    },
    {
      "code" : "A022178100",
      "display" : "CINNARIZINE TABLETS \"MEDRAY\""
    },
    {
      "code" : "A022181100",
      "display" : "TECLIN CAPSULES (TETRACYCLINE HCL) \"P.L.\""
    },
    {
      "code" : "A022187100",
      "display" : "COUNTHIN S.C. TABLETS  \"CHEN TA.\"(DIPYRIDAMOLE)"
    },
    {
      "code" : "A022189100",
      "display" : "CIMETINE TABLETS \"PATRON\""
    },
    {
      "code" : "A022190100",
      "display" : "CIMETIDINE TABLETS 200MG \"C.L.\""
    },
    {
      "code" : "A022191100",
      "display" : "CIMETIDINE TABLETS \"HSC\""
    },
    {
      "code" : "A022192321",
      "display" : "SEPTON CREAM (BETAMETHASONE DIPROPIONATE)"
    },
    {
      "code" : "A022193321",
      "display" : "SEPTON OINTMENT (BETAMETHASONE DIPROPIONATE)"
    },
    {
      "code" : "A022197177",
      "display" : "SAUHONRO GRANULES \"C.M.\""
    },
    {
      "code" : "A022198421",
      "display" : "GENTAMICIN EYE DROPS \"SINPHAR\""
    },
    {
      "code" : "A022199100",
      "display" : "COULITIN TABLETS \"ASTAR\""
    },
    {
      "code" : "A022200500",
      "display" : "XYLMOL SUPPOSITORY \"SINPHAR\""
    },
    {
      "code" : "A022207100",
      "display" : "DICLOFEN TABLETS (DICLOFENAC) \"WELCAN\""
    },
    {
      "code" : "A022209100",
      "display" : "ANROKIN TABLETS (CHLORZOXAZONE)"
    },
    {
      "code" : "A0222091G0",
      "display" : "ANROKIN TABLETS (CHLORZOXAZONE)"
    },
    {
      "code" : "A022210100",
      "display" : "CIQUATE TABLETS \"CBC\""
    },
    {
      "code" : "A0222101G0",
      "display" : "CIQUATE TABLETS \"CBC\""
    },
    {
      "code" : "A022211100",
      "display" : "STAPAM TABLETS \"STANDARD\"(LORAZEPAM)"
    },
    {
      "code" : "A022212100",
      "display" : "DEXAMETHASONE TABLETS\"N.C.P\""
    },
    {
      "code" : "A022217100",
      "display" : "SULFADIMETHOXINE TABLETS"
    },
    {
      "code" : "A022223100",
      "display" : "\"YONFUPHARM\" IBUPROFEN TABLETS"
    },
    {
      "code" : "A022224100",
      "display" : "GEFARNATE CAPSULES \"Y.S.\""
    },
    {
      "code" : "A022225100",
      "display" : "NICE FILM COATED TABLETS \"YUNG SHIN\"(NITROXOLINE)"
    },
    {
      "code" : "A022226212",
      "display" : "SULOFAGEN INJECTION"
    },
    {
      "code" : "A022227100",
      "display" : "BICODIN TABLETS \"STANDARD\""
    },
    {
      "code" : "A0222271G0",
      "display" : "BICODIN TABLETS \"STANDARD\""
    },
    {
      "code" : "A022229100",
      "display" : "WACO TABLETS (GLYCERYL GUAIACOLATE) \"W.P.\""
    },
    {
      "code" : "A022230209",
      "display" : "ASKACEF FOR INJECTION 1000MG (CEPHRADINE) \"C.C.P.\""
    },
    {
      "code" : "A022231277",
      "display" : "ASKACEF FOR INJECTION 500MG \"C.C.P.\""
    },
    {
      "code" : "A022238221",
      "display" : "VIBRAMYCIN IV PRE-CON"
    },
    {
      "code" : "A022239100",
      "display" : "AMPICILLIN CAPSULES 500MG \"ASTAR\""
    },
    {
      "code" : "A022241212",
      "display" : "TENSIONLEX INJECTION (ORPHENADRINE) \"PANHIOTIC\""
    },
    {
      "code" : "A022242177",
      "display" : "ASTOMIN SOLUTION (DIMEMORFAN)"
    },
    {
      "code" : "A022250100",
      "display" : "TUSTOP CAPSULES \"T.A.\""
    },
    {
      "code" : "A022259100",
      "display" : "PRANOLOL TABLETS (PROPRANOLOL) \"N.C.P.\""
    },
    {
      "code" : "A022262100",
      "display" : "SAFE F.C. TABLETS \"ROYAL\""
    },
    {
      "code" : "A022265100",
      "display" : "OXACAIN TABLETS (OXETHAZINE)\"M.T.\""
    },
    {
      "code" : "A0222651G0",
      "display" : "OXACAIN TABLETS (OXETHAZINE)\"M.T.\""
    },
    {
      "code" : "A022270100",
      "display" : "CHEI WUEI TABLETS \"ASTAR\""
    },
    {
      "code" : "A022272209",
      "display" : "BININ-U INJECTION (HALOPERIDOL)"
    },
    {
      "code" : "A022272212",
      "display" : "BININ-U INJECTION (HALOPERIDOL)"
    },
    {
      "code" : "A022274100",
      "display" : "UFUNIN TABLETS"
    },
    {
      "code" : "A0222741G0",
      "display" : "UFUNIN TABLETS"
    },
    {
      "code" : "A022278100",
      "display" : "FENOPRON PULVULES 200MG"
    },
    {
      "code" : "A022286100",
      "display" : "CINNARIZINE TABLETS \"S.Y.\""
    },
    {
      "code" : "A022289100",
      "display" : "LOPERAMIDE CAPSULES 2MG \"CHEN TA\""
    },
    {
      "code" : "A0222891G0",
      "display" : "LOPERAMIDE CAPSULES 2MG \"CHEN TA\""
    },
    {
      "code" : "A022296100",
      "display" : "CIMETIN TABLETS (CIMETIDINE) \"JOHNSON\""
    },
    {
      "code" : "A0222961G0",
      "display" : "CIMETIN TABLETS (CIMETIDINE) \"JOHNSON\""
    },
    {
      "code" : "A022297135",
      "display" : "BININ-U SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A022297157",
      "display" : "BININ-U SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A022297199",
      "display" : "BININ-U SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A022298100",
      "display" : "CHLORZOXAZONE TABLETS"
    },
    {
      "code" : "A022301121",
      "display" : "FUMUCIL GRAMULES  \"SWISS\"(ACETYLCYSTEINE)"
    },
    {
      "code" : "A022301155",
      "display" : "FUMUCIL GRAMULES  \"SWISS\"(ACETYLCYSTEINE)"
    },
    {
      "code" : "A022301199",
      "display" : "FUMUCIL GRAMULES  \"SWISS\"(ACETYLCYSTEINE)"
    },
    {
      "code" : "A022304318",
      "display" : "POVIDONE IODINE SOLUTION 10％ \"CHI SHENG\""
    },
    {
      "code" : "A022304399",
      "display" : "POVIDONE IODINE SOLUTION 10％ \"CHI SHENG\""
    },
    {
      "code" : "A022314100",
      "display" : "RADI-K TABLETS (POTASSIUM GLUCONATE) \"BOWLIN\""
    },
    {
      "code" : "A022318100",
      "display" : "SINUTAB TABLETS"
    },
    {
      "code" : "A022319209",
      "display" : "PANTOTHENOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A022319212",
      "display" : "PANTOTHENOL INJECTION \"S.Y.\""
    },
    {
      "code" : "A022321100",
      "display" : "URORIDINE S.C. TABLETS (PHENAZOPYRIDINE) \"N.Y"
    },
    {
      "code" : "A022322100",
      "display" : "ETHAPIN TABLETS (ETHAVERINE) \"PANBIOTIC\""
    },
    {
      "code" : "A022339100",
      "display" : "ULCUS CAPSULES (SULPIRIDE) \"M.S.\""
    },
    {
      "code" : "A022340321",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340329",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340335",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340340",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340345",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340355",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340372",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022340399",
      "display" : "TOTUSAN OINTMENT"
    },
    {
      "code" : "A022343277",
      "display" : "LOFALIN INJECTION 500MG (CEFAZOLIN) \"GENTLE\""
    },
    {
      "code" : "A022345100",
      "display" : "TAMEDIN F.C. TABLETS \"STANDARD\"(CIMETIDINE)"
    },
    {
      "code" : "A0223451G0",
      "display" : "TAMEDIN F.C. TABLETS \"STANDARD\"(CIMETIDINE)"
    },
    {
      "code" : "A022348100",
      "display" : "HUCOPIN TABLETS \"S.Y.\""
    },
    {
      "code" : "A022357100",
      "display" : "LYCOZE TABLETS (LYSOZYME)"
    },
    {
      "code" : "A0223571G0",
      "display" : "LYCOZE TABLETS (LYSOZYME)"
    },
    {
      "code" : "A022359100",
      "display" : "WINTONIN TABLETS (NALIDIXIC ACID) \"K.B.\""
    },
    {
      "code" : "A022363209",
      "display" : "CLAFORAN I.V. INJECTION 1.0GM"
    },
    {
      "code" : "A022364277",
      "display" : "CLAFORAN INJECTION 0.5GM"
    },
    {
      "code" : "A022365265",
      "display" : "CLAFORAN INJECTION 0.25GM"
    },
    {
      "code" : "A022367212",
      "display" : "CLAFORAN I.V. INJECTION 2.0GM"
    },
    {
      "code" : "A022368500",
      "display" : "SUSEPOL SUPPOSITORIES \"Y.S.\""
    },
    {
      "code" : "A022381100",
      "display" : "RASEMIN CAPSULES (TRANEXAMIC ACID) \"H.S.C.\""
    },
    {
      "code" : "A022383100",
      "display" : "ASTOP TABLETS \"STANDARD\""
    },
    {
      "code" : "A022392309",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A022392321",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A022392329",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A022392335",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A022392399",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A0223923B9",
      "display" : "NEOSONE CREAM \"GCPC\""
    },
    {
      "code" : "A022393221",
      "display" : "RASEMIN INJECTION \"Y.Y.\"(TRANEXAMIC ACID)"
    },
    {
      "code" : "A022398212",
      "display" : "VITACON-C INJECTION \"WINSTON\""
    },
    {
      "code" : "A022399100",
      "display" : "CAMTRIN TABLETS \"J.C.S.\""
    },
    {
      "code" : "A022403109",
      "display" : "LONFLEX GRANULES (CEPHALEXIN) \"C.Y.\""
    },
    {
      "code" : "A022403177",
      "display" : "LONFLEX GRANULES (CEPHALEXIN) \"C.Y.\""
    },
    {
      "code" : "A022403199",
      "display" : "LONFLEX GRANULES (CEPHALEXIN) \"C.Y.\""
    },
    {
      "code" : "A022404100",
      "display" : "LILITIN TABLETS"
    },
    {
      "code" : "A022407100",
      "display" : "KETOPROFEN CAPSULES 50MG \"CHI SHENG\""
    },
    {
      "code" : "A022408100",
      "display" : "C.M.T. TABLETS (CIMETIDINE) \"BOWLIN\""
    },
    {
      "code" : "A022412277",
      "display" : "CEFAZIN INJECTION \"KINGDOM\" (CEFAZOLIN ECTION)"
    },
    {
      "code" : "A022416119",
      "display" : "SATO SYRUP"
    },
    {
      "code" : "A022416151",
      "display" : "SATO SYRUP"
    },
    {
      "code" : "A022416157",
      "display" : "SATO SYRUP"
    },
    {
      "code" : "A022416199",
      "display" : "SATO SYRUP"
    },
    {
      "code" : "A022418100",
      "display" : "PLASLLOID CAPSULES (EPSILON-AMINOCAPROIC ACID) \"M.S.\""
    },
    {
      "code" : "A022419100",
      "display" : "TETRACYCLINE HCL CAPSULES \"ASTAR\""
    },
    {
      "code" : "A022421100",
      "display" : "RIFAMPICIN CAPSULES \"SINTON\""
    },
    {
      "code" : "A022423100",
      "display" : "UPROFEN CAPSULES 400MG (IBUPROFEN)"
    },
    {
      "code" : "A022425100",
      "display" : "ASCORBIC ACID TABLETS \"SYNMOSA\""
    },
    {
      "code" : "A022431209",
      "display" : "DIPICILLIN INJECTION 1000MG \"G.C.\""
    },
    {
      "code" : "A022432100",
      "display" : "CEPHSLEXIN CAPSULES \"SINTON\""
    },
    {
      "code" : "A022433118",
      "display" : "Rikemin SYRUP"
    },
    {
      "code" : "A022433143",
      "display" : "Rikemin SYRUP"
    },
    {
      "code" : "A022433151",
      "display" : "Rikemin SYRUP"
    },
    {
      "code" : "A022433157",
      "display" : "Rikemin SYRUP"
    },
    {
      "code" : "A022433199",
      "display" : "Rikemin SYRUP"
    },
    {
      "code" : "A022434100",
      "display" : "NAPROXEN TABLETS \"JINUP\""
    },
    {
      "code" : "A022440229",
      "display" : "LIKONSIN INJECTION (LINCOMYCIN HCL) \"SHITEH\""
    },
    {
      "code" : "A022441100",
      "display" : "WINPRON TABLETS 250MG (NAPROXEN) \"WINSTON\""
    },
    {
      "code" : "A022442100",
      "display" : "ENLAIN F.C TABLETS 100MG \"CHEN TA\""
    },
    {
      "code" : "A022444100",
      "display" : "TIGAWET TABLETS (CIMETIDINE)"
    },
    {
      "code" : "A0224441G0",
      "display" : "TIGAWET TABLETS (CIMETIDINE)"
    },
    {
      "code" : "A022448100",
      "display" : "DOLAN TABLETS"
    },
    {
      "code" : "A022450100",
      "display" : "WINCYNON TABLETS 250MG (ETHAMSYLATE) \"WINSTON"
    },
    {
      "code" : "A022457212",
      "display" : "PIPRIL PARENTERAL 2GM (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A022458209",
      "display" : "PIPRIL  PARENTERAL 1GM (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A022459209",
      "display" : "GENTAMICIN INJECTION 140MG/ML \"GENTLE\""
    },
    {
      "code" : "A022459212",
      "display" : "GENTAMICIN INJECTION 140MG/ML \"GENTLE\""
    },
    {
      "code" : "A022459229",
      "display" : "GENTAMICIN INJECTION 140MG/ML \"GENTLE\""
    },
    {
      "code" : "A022460100",
      "display" : "YULVIX CAPSULES \"JINUP\""
    },
    {
      "code" : "A022461238",
      "display" : "LICOTON INJECTION \"S.Y.\""
    },
    {
      "code" : "A022463100",
      "display" : "CIMETIDINE TABLETS \"SHIN FONG\""
    },
    {
      "code" : "A022464100",
      "display" : "CIMETIDINE TABLETS \"CHI SHENG\""
    },
    {
      "code" : "A022465212",
      "display" : "CIMETIDINE INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A022467100",
      "display" : "INCALM TABLETS \"SINPHAR\""
    },
    {
      "code" : "A022470100",
      "display" : "DEXAMETHASONE TABLETS \"TAI YU\""
    },
    {
      "code" : "A022471421",
      "display" : "BEACA-N EYE DROPS \"C.R.\""
    },
    {
      "code" : "A022473429",
      "display" : "PATEAR EYE LOTIONS \"PATRON\""
    },
    {
      "code" : "A022474321",
      "display" : "HIRUCORT CREAM \"PATRON\""
    },
    {
      "code" : "A022474329",
      "display" : "HIRUCORT CREAM \"PATRON\""
    },
    {
      "code" : "A022476216",
      "display" : "FUMUCIL INJECTION (ACETYLCYSTEINE)"
    },
    {
      "code" : "A022499100",
      "display" : "NYCITON CAPSULES"
    },
    {
      "code" : "A022501100",
      "display" : "EBUTOL F.C. TABLETS 400MG (ETHAMBUTOL) \"VPP\""
    },
    {
      "code" : "A022507100",
      "display" : "LOVEGEN F.C. TABLETS (CONJUGATED ESTROGEN) \"ROYAL\""
    },
    {
      "code" : "A022512100",
      "display" : "ETHAVERINE TABLETS \"S.Y.\""
    },
    {
      "code" : "A022514263",
      "display" : "GLUTATHIONE INJECTION \"TAI YU\""
    },
    {
      "code" : "A022515435",
      "display" : "Kirakira eye drop \"Patron\""
    },
    {
      "code" : "A022519277",
      "display" : "LYO-POVIGEN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A022519299",
      "display" : "LYO-POVIGEN INJECTION \"C.C.P.\""
    },
    {
      "code" : "A022525321",
      "display" : "CLOMELON CREAM (CLOTRIMAZOLE) \"GENTLE\""
    },
    {
      "code" : "A022526500",
      "display" : "ASMETHOL SUPPOSITORIES \"C.C.P.\""
    },
    {
      "code" : "A022529100",
      "display" : "BROMPHENIRAMINE TABLETS \"TAI YU\""
    },
    {
      "code" : "A022532100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"SINTON\""
    },
    {
      "code" : "A022534100",
      "display" : "COLICINE TABLETS (COLCHICINE)"
    },
    {
      "code" : "A022535100",
      "display" : "METHASONE TABLETS (BETAMETHASONE)"
    },
    {
      "code" : "A022539100",
      "display" : "VITAMIN B COMPLEX TABLETS \"TAI YU\""
    },
    {
      "code" : "A022540321",
      "display" : "EPIDREM OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A022541100",
      "display" : "GRIFULVIN CAPSULES (GRISEOFULVIN) \"C.I.\""
    },
    {
      "code" : "A022542100",
      "display" : "LOLILIN TABLETS (LOPERAMIDE) \"Eayung\""
    },
    {
      "code" : "A022545212",
      "display" : "AVATON INJECTION \"G.C.\""
    },
    {
      "code" : "A022545216",
      "display" : "AVATON INJECTION \"G.C.\""
    },
    {
      "code" : "A022545221",
      "display" : "AVATON INJECTION \"G.C.\""
    },
    {
      "code" : "A022548277",
      "display" : "CEZOLIN INJECTION 500MG (CEFAZOLIN) \"SWISS\""
    },
    {
      "code" : "A022554100",
      "display" : "GERIUM CAPSULES (LOPERAMIDE) \"ROYAL\""
    },
    {
      "code" : "A0225541G0",
      "display" : "GERIUM CAPSULES (LOPERAMIDE) \"ROYAL\""
    },
    {
      "code" : "A022557100",
      "display" : "REASON TABLETS (LYSOZYME) \"ROYAL\""
    },
    {
      "code" : "A0225571G0",
      "display" : "REASON TABLETS (LYSOZYME) \"ROYAL\""
    },
    {
      "code" : "A022558100",
      "display" : "SORCILIN TABLETS 10MG (ISOSURBIDE) \"ROYAL\""
    },
    {
      "code" : "A022559100",
      "display" : "ROYAMET F.C. TABLETS (CIMETIDINE) \"ROYAL\""
    },
    {
      "code" : "A0225591G0",
      "display" : "ROYAMET F.C. TABLETS (CIMETIDINE) \"ROYAL\""
    },
    {
      "code" : "A022565212",
      "display" : "KETOPROFEN I.M. INJECTION \"S.Y.\""
    },
    {
      "code" : "A022565216",
      "display" : "KETOPROFEN I.M. INJECTION \"S.Y.\""
    },
    {
      "code" : "A022565238",
      "display" : "KETOPROFEN I.M. INJECTION \"S.Y.\""
    },
    {
      "code" : "A022568212",
      "display" : "CIMETIDINE INJECTION \"N.K.\""
    },
    {
      "code" : "A022568216",
      "display" : "CIMETIDINE INJECTION \"N.K.\""
    },
    {
      "code" : "A022569100",
      "display" : "CIMETIDINE TABLETS 200MG \"T.F.\""
    },
    {
      "code" : "A022570100",
      "display" : "COLURECIN TABLETS (PIPEMIDIC ACID) \"SHIN FONG\""
    },
    {
      "code" : "A022572100",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"SWISS\""
    },
    {
      "code" : "A0225721G0",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"SWISS\""
    },
    {
      "code" : "A022582212",
      "display" : "LICOXIN INJECTION 300MG/ML (LINCOMYCIN) \"GENTLE\""
    },
    {
      "code" : "A022582229",
      "display" : "LICOXIN INJECTION 300MG/ML (LINCOMYCIN) \"GENTLE\""
    },
    {
      "code" : "A022586100",
      "display" : "ELININ CAPSULES (LOPERAMIDE)\"SHINLON\""
    },
    {
      "code" : "A0225861G0",
      "display" : "ELININ CAPSULES (LOPERAMIDE)\"SHINLON\""
    },
    {
      "code" : "A022588209",
      "display" : "BENAMINE INJECTION 30MG/ML (DIPHENHYDRAMINE HCL) \"VPP\""
    },
    {
      "code" : "A022595100",
      "display" : "POUGENIN CAPSULES (SILYMARIN)"
    },
    {
      "code" : "A022596100",
      "display" : "LOIDIUM CAPSULES (LOPETAMIDE) \"C.R.\""
    },
    {
      "code" : "A022601100",
      "display" : "NEO-COL TABLETS \"STANDARD\""
    },
    {
      "code" : "A022608212",
      "display" : "ORFLEX INJECTION (ORPHENADRINE) \"GENTLE\""
    },
    {
      "code" : "A022610277",
      "display" : "LYO-MEDONIN INJECTION 500MG \"C.C.P.\""
    },
    {
      "code" : "A022611100",
      "display" : "PAWSANLON CAPSULES \"J.S.\""
    },
    {
      "code" : "A022613212",
      "display" : "DECARON INJECTION (DEXAMETHASONE SODIUM PHOSPHATE) \"Y.F.\""
    },
    {
      "code" : "A022613229",
      "display" : "DECARON INJECTION (DEXAMETHASONE SODIUM PHOSPHATE) \"Y.F.\""
    },
    {
      "code" : "A022622212",
      "display" : "SUWELIN INJECTION  \"S.Y.\"(CIMETIDINE)"
    },
    {
      "code" : "A022622216",
      "display" : "SUWELIN INJECTION  \"S.Y.\"(CIMETIDINE)"
    },
    {
      "code" : "A022628100",
      "display" : "PIPMA FILM COATED TABLETS (PIPEMIDIC ACID)"
    },
    {
      "code" : "A022630100",
      "display" : "WINTIN TABLETS (LORAZEPAM) \"WINSTON\""
    },
    {
      "code" : "A0226301G0",
      "display" : "WINTIN TABLETS (LORAZEPAM) \"WINSTON\""
    },
    {
      "code" : "A022634100",
      "display" : "DIABITIN TABLETS 5MG (GLIBENCLAMIDE) \"VPP\""
    },
    {
      "code" : "A0226341G0",
      "display" : "DIABITIN TABLETS 5MG (GLIBENCLAMIDE) \"VPP\""
    },
    {
      "code" : "A022638329",
      "display" : "MYCODERIN CREAM (MICONAZOLE) \"BOWLIN\""
    },
    {
      "code" : "A022640321",
      "display" : "FLUOMYCIN CREAM"
    },
    {
      "code" : "A022641100",
      "display" : "ROSIS TABLETS 40MG"
    },
    {
      "code" : "A0226411G0",
      "display" : "ROSIS TABLETS 40MG"
    },
    {
      "code" : "A022647100",
      "display" : "TAVEL TABLETS (CLEMASTINE) \"TA\""
    },
    {
      "code" : "A022652100",
      "display" : "LOMIFEN CAPSULES (CLOMIPHENE) \"SHIN FONG\""
    },
    {
      "code" : "A022656100",
      "display" : "DICYCLOMINE TABLETS \"S.Y.\""
    },
    {
      "code" : "A022657100",
      "display" : "Hema  F S. C. Tablets"
    },
    {
      "code" : "A022658100",
      "display" : "PRESITON TABLETS 250MG \"H.L.\""
    },
    {
      "code" : "A022659209",
      "display" : "KARCILLIN INJECTION (CARBENICILLIN)\"SWISS\""
    },
    {
      "code" : "A022664100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"Taiten\""
    },
    {
      "code" : "A022665100",
      "display" : "AMMONIUM CHLORIDE E.C. TABLETS"
    },
    {
      "code" : "A022666209",
      "display" : "DEXTROSE 5％ AND SODIUM CHLORIDE 0.33％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A022666277",
      "display" : "DEXTROSE 5％ AND SODIUM CHLORIDE 0.33％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A022674100",
      "display" : "PRESITON TABLETS 500MG \"H.L.\""
    },
    {
      "code" : "A022678100",
      "display" : "BRAMIN TABLETS \"PANBIOTIC\"(BROMPHENIRAMIN MALEATE)"
    },
    {
      "code" : "A022682265",
      "display" : "TAITA NO.5 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A022682271",
      "display" : "TAITA NO.5 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A022682277",
      "display" : "TAITA NO.5 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A022685100",
      "display" : "WERGEN TABLETS (CIMETIDINE) \"YUNG CHI\""
    },
    {
      "code" : "A022686329",
      "display" : "CLOMAZOLE CREAM 1％ (CLOTRIMAZOLE)"
    },
    {
      "code" : "A022689100",
      "display" : "AMMONIUM CHLORIDE E.C. TABLETS \"W.P.\""
    },
    {
      "code" : "A022690100",
      "display" : "CIMETINE TABLETS (CIMETIDINE)"
    },
    {
      "code" : "A022693329",
      "display" : "FLUOCINONIDE OINTMENT\"H.S.\""
    },
    {
      "code" : "A022693335",
      "display" : "FLUOCINONIDE OINTMENT\"H.S.\""
    },
    {
      "code" : "A022693338",
      "display" : "FLUOCINONIDE OINTMENT\"H.S.\""
    },
    {
      "code" : "A022693399",
      "display" : "FLUOCINONIDE OINTMENT\"H.S.\""
    },
    {
      "code" : "A022694338",
      "display" : "MARGITON OINTMENT 0.1％ \"C.C.P.\""
    },
    {
      "code" : "A022701266",
      "display" : "ALLAMIN INJECTION ISOTONIC \"KYORIN\""
    },
    {
      "code" : "A022701277",
      "display" : "ALLAMIN INJECTION ISOTONIC \"KYORIN\""
    },
    {
      "code" : "A022712100",
      "display" : "TOLMETIN TABLETS \"H.S.C.\""
    },
    {
      "code" : "A022719421",
      "display" : "CONDRON-DEMISON EYE DROP"
    },
    {
      "code" : "A022722100",
      "display" : "BUCOFENE TABLETS"
    },
    {
      "code" : "A022723100",
      "display" : "DIPYRIDAMOLE TABLETS \"TAI YU\""
    },
    {
      "code" : "A022726100",
      "display" : "KER LI CAPSULES (LOPERAMIDE) \"C.M.\""
    },
    {
      "code" : "A022729229",
      "display" : "GENTAMICIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A022729238",
      "display" : "GENTAMICIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A022729299",
      "display" : "GENTAMICIN SULFATE INJECTION \"ASTAR\""
    },
    {
      "code" : "A022736109",
      "display" : "CHLORAMPHENICOL PALMITATE GRANULES 250MG/GM \"PRINCE\""
    },
    {
      "code" : "A022740100",
      "display" : "SULMIN TABLETS (SULFAMETHOXAZOLE) \"W.P.\""
    },
    {
      "code" : "A022743100",
      "display" : "STOGAMET TABLETS \"SWISS\"(CIMETIDINE)"
    },
    {
      "code" : "A0227431G0",
      "display" : "STOGAMET TABLETS \"SWISS\"(CIMETIDINE)"
    },
    {
      "code" : "A022746100",
      "display" : "SUWELIN TABLETS \"S.Y.\"(CIMETIDINE)"
    },
    {
      "code" : "A022747100",
      "display" : "PISUNIN TABLETS \"Chen Ta\""
    },
    {
      "code" : "A022748172",
      "display" : "ANSO GRANULES \"TOLIN\""
    },
    {
      "code" : "A022748199",
      "display" : "ANSO GRANULES \"TOLIN\""
    },
    {
      "code" : "A022750100",
      "display" : "MEFENAMIC ACID CAPSULE 250MG \"M.D.\""
    },
    {
      "code" : "A022751100",
      "display" : "COTHOPIN TABLETS \"H.S.C.\" (FENOTEROL)"
    },
    {
      "code" : "A022766212",
      "display" : "CIMETIDINE INJECTION \"H.S.C.\""
    },
    {
      "code" : "A022767500",
      "display" : "DAFRIN VAGINAL TABLETS \"SWISS\"(MICONAZOLE)"
    },
    {
      "code" : "A022774209",
      "display" : "ORICIN INJECTION \"H.S.C.\""
    },
    {
      "code" : "A022776212",
      "display" : "KETOPROFEN INJECTION \"FUMIN\""
    },
    {
      "code" : "A022780118",
      "display" : "SUBILO SYRUPS \"Y.K.\""
    },
    {
      "code" : "A022780199",
      "display" : "SUBILO SYRUPS \"Y.K.\""
    },
    {
      "code" : "A022781100",
      "display" : "ANMINING TABLETS (NITRAZEPAM) \"H.A.\""
    },
    {
      "code" : "A022782299",
      "display" : "DICILLIN INJECTION \"VPP\""
    },
    {
      "code" : "A022786100",
      "display" : "SPOLIN TABLETS (LORAZEPAM) \"H.H.\""
    },
    {
      "code" : "A0227861G0",
      "display" : "SPOLIN TABLETS (LORAZEPAM) \"H.H.\""
    },
    {
      "code" : "A022793100",
      "display" : "LOPERAMIDE CAPSULES \"PRINCE\""
    },
    {
      "code" : "A022795100",
      "display" : "DIPHEDOL TABLETS (DIPHENIDOL) \"GOLDEN HORSE\""
    },
    {
      "code" : "A022796212",
      "display" : "KETOPROFEN I.M. INJECTION 50MG/ML \"Y.Y.\""
    },
    {
      "code" : "A022800229",
      "display" : "MID-METHASONE INJECTION (DEXAMETHASONE SODIUM PHOSPHATE) \"LIN CHEMICAL\""
    },
    {
      "code" : "A022801100",
      "display" : "Conspin Tablets \"H.S.\""
    },
    {
      "code" : "A022802100",
      "display" : "PERSENTIN S.C. TABLETS (DIPYRIDAMOLE) \"KINGDOM\""
    },
    {
      "code" : "A022805100",
      "display" : "TETRACYCLINE HCL FILM COATED TABLETS \"SHITEH\""
    },
    {
      "code" : "A022810100",
      "display" : "WERIN TABLETS \"YUNG CHI\""
    },
    {
      "code" : "A022814229",
      "display" : "GENTAMYCIN SULFATE INJECTION 40mg/ml \"T.F.\""
    },
    {
      "code" : "A022814238",
      "display" : "GENTAMYCIN SULFATE INJECTION 40mg/ml \"T.F.\""
    },
    {
      "code" : "A022815100",
      "display" : "LORAZEPAM TABLETS 0.5 MG \"F.Y.\""
    },
    {
      "code" : "A0228151G0",
      "display" : "LORAZEPAM TABLETS 0.5 MG \"F.Y.\""
    },
    {
      "code" : "A022816100",
      "display" : "LORAZIN TABLETS (LORAZEPAM) \"JOHNSON\""
    },
    {
      "code" : "A022819100",
      "display" : "LORAZEPAM TABLETS 1 MG \"F.Y.\""
    },
    {
      "code" : "A0228191G0",
      "display" : "LORAZEPAM TABLETS 1 MG \"F.Y.\""
    },
    {
      "code" : "A022825100",
      "display" : "LIKAN TABLETS (TRIAMCINOLONE) \"S.M.\""
    },
    {
      "code" : "A022836100",
      "display" : "DEFENSE FILM COATED TABLETS (CIMETIDINE) \"YUNG SHIN\""
    },
    {
      "code" : "A0228361G0",
      "display" : "DEFENSE FILM COATED TABLETS (CIMETIDINE) \"YUNG SHIN\""
    },
    {
      "code" : "A022837100",
      "display" : "LEVAMISOLE TABLETS"
    },
    {
      "code" : "A022840209",
      "display" : "ATROPINE SULFATE INJCETION \"ORIENTAL\""
    },
    {
      "code" : "A022843100",
      "display" : "CHLORMEZANONE TABLETS \"S.Y.\""
    },
    {
      "code" : "A022850321",
      "display" : "BEVAMEN OINTMENT \"H.A.\""
    },
    {
      "code" : "A022850324",
      "display" : "BEVAMEN OINTMENT \"H.A.\""
    },
    {
      "code" : "A022852100",
      "display" : "DIPHENIDOL F.C. TABLETS \"SHOU CHAN\""
    },
    {
      "code" : "A022859318",
      "display" : "PVP-IODINE AQUEOUS SOLUTION \"P.J.\""
    },
    {
      "code" : "A022859399",
      "display" : "PVP-IODINE AQUEOUS SOLUTION \"P.J.\""
    },
    {
      "code" : "A022861109",
      "display" : "PECSIE GRANULES \"KYORIN\""
    },
    {
      "code" : "A022865500",
      "display" : "DICLOFENAC SUPPOSITORIES \"YUNG CHI\""
    },
    {
      "code" : "A022867421",
      "display" : "MYCOMB OTIC DROPS \"SINPHAR\""
    },
    {
      "code" : "A022872100",
      "display" : "Gasbella TABLETS \"VPP\""
    },
    {
      "code" : "A022875110",
      "display" : "AMOXICILLIN POWDER FOR ORAL SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A022876100",
      "display" : "LYSOZYME TABLETS 30MG \"P.L.\""
    },
    {
      "code" : "A022879100",
      "display" : "DHAA TABLETS 100MG \"H.C.T.\" (DIHYDROXY ALUMINUM ALLANTOINATE)"
    },
    {
      "code" : "A022880100",
      "display" : "GASTOMET TABLETS (CIMETIDINE) \"CYC\""
    },
    {
      "code" : "A022883338",
      "display" : "MARGITON OINTMENT 0.5％"
    },
    {
      "code" : "A022888100",
      "display" : "YUGLUCON TABLETS (GLIBENCLAMIDE) \"TAI YU\""
    },
    {
      "code" : "A022890100",
      "display" : "MILISHER TABLETS (LYSOZYME) \"H.S.\""
    },
    {
      "code" : "A022901100",
      "display" : "Tricort Tablets (Triamcinolone)"
    },
    {
      "code" : "A022902100",
      "display" : "GASTRODIN TABLETS 300MG (CIMETIDINE)"
    },
    {
      "code" : "A022903100",
      "display" : "GASTRODIN TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A0229031G0",
      "display" : "GASTRODIN TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A022904118",
      "display" : "COCOLIN SYRUP \"F.B.\""
    },
    {
      "code" : "A022904199",
      "display" : "COCOLIN SYRUP \"F.B.\""
    },
    {
      "code" : "A022905100",
      "display" : "TRANZANSHOW CAPSULES"
    },
    {
      "code" : "A022908100",
      "display" : "SPIRONOLACTONE TABLETS \"S.C.\""
    },
    {
      "code" : "A0229081G0",
      "display" : "SPIRONOLACTONE TABLETS \"S.C.\""
    },
    {
      "code" : "A022909500",
      "display" : "MICARIN VAGINAL SUPPOSITORY (MICONAZOLE) \"H.C.T.\""
    },
    {
      "code" : "A022920417",
      "display" : "CHLORSON EYE OINTMENT \"OASIS\""
    },
    {
      "code" : "A022928100",
      "display" : "ODETIN TABLETS (BUCLIZINE) \"VPP\""
    },
    {
      "code" : "A022930212",
      "display" : "GEXAMIN INJECTION (TRANEXAMIC ACID) \"GENTLE\""
    },
    {
      "code" : "A022933100",
      "display" : "METHYLDOPA TABLETS"
    },
    {
      "code" : "A022937212",
      "display" : "CONAMIN INJECTION \"WINSTON\""
    },
    {
      "code" : "A022940209",
      "display" : "DEPO-OVADIOL INJECTION \"SUC\""
    },
    {
      "code" : "A022941100",
      "display" : "TRIAMCORT TABLETS (TRIAMCINOLONE) \"K.B.\""
    },
    {
      "code" : "A022944100",
      "display" : "RIFAMCIN CAPSULES (RIFAMPICIN) \"C.R.\""
    },
    {
      "code" : "A022949277",
      "display" : "COFLEX INJECTION \"S.Y.\""
    },
    {
      "code" : "A022950100",
      "display" : "NOSCO TABLETS \"WINSTON\""
    },
    {
      "code" : "A022952289",
      "display" : "UCEFAXIM INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A022953265",
      "display" : "UCEFAXIM INJECTION 250MG (CEFUROXIME)"
    },
    {
      "code" : "A022960100",
      "display" : "ZINGA TABLETS (ZINC GLUCONATE) \"BOWLIN\""
    },
    {
      "code" : "A022964100",
      "display" : "NARCARICIN CAPSULES 100MG (BENZBROMARONE)"
    },
    {
      "code" : "A022970209",
      "display" : "CANHONLIN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A022972100",
      "display" : "RUOHFONTON TABLET"
    },
    {
      "code" : "A022973100",
      "display" : "WETIDINE TABLETS (LIMETIDINE) \"LIN CHEMICAL\""
    },
    {
      "code" : "A022975209",
      "display" : "OLDAN-A INJECTION \"S.Y.\""
    },
    {
      "code" : "A022975212",
      "display" : "OLDAN-A INJECTION \"S.Y.\""
    },
    {
      "code" : "A022977100",
      "display" : "WEISUPINE TABLETS \"S.C.\""
    },
    {
      "code" : "A022978100",
      "display" : "CIMETIDINE TABLETS \"N.K.\""
    },
    {
      "code" : "A022981100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"SHINLON\""
    },
    {
      "code" : "A022982100",
      "display" : "BISOCU TABLETS \"W.P.\" (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A022983212",
      "display" : "COUGHANPIN INJECTION \"SINTON\""
    },
    {
      "code" : "A022984212",
      "display" : "MINFUGEN H INJECTION \"SINTON\""
    },
    {
      "code" : "A022987100",
      "display" : "PRIMPERAN F. C. TABLETS (METOCLOPRAMIDE)"
    },
    {
      "code" : "A0229871G0",
      "display" : "PRIMPERAN F. C. TABLETS (METOCLOPRAMIDE)"
    },
    {
      "code" : "A022990335",
      "display" : "B. &N. BACINEOCIN OINTMENT"
    },
    {
      "code" : "A022990343",
      "display" : "B. &N. BACINEOCIN OINTMENT"
    },
    {
      "code" : "A022990372",
      "display" : "B. &N. BACINEOCIN OINTMENT"
    },
    {
      "code" : "A022990399",
      "display" : "B. &N. BACINEOCIN OINTMENT"
    },
    {
      "code" : "A022995100",
      "display" : "CIMETIDINE TABLETS 200MG \"F.Y.\""
    },
    {
      "code" : "A0229951G0",
      "display" : "CIMETIDINE TABLETS 200MG \"F.Y.\""
    },
    {
      "code" : "A022999100",
      "display" : "IMOLI CAPSULES (LOPERAMIDE) \"N.T.\""
    },
    {
      "code" : "A023002212",
      "display" : "AGASTRIN INJECTION (CIMETIDINE) \"KINGDOM\""
    },
    {
      "code" : "A023003100",
      "display" : "AGASTRIN TABLETS (CIMETIDINE) \"KINGDOM\""
    },
    {
      "code" : "A023008100",
      "display" : "CIMETIN TABLETS (CIMETIDINE) \"TAI YU\""
    },
    {
      "code" : "A023012321",
      "display" : "SINSODERM CREAM"
    },
    {
      "code" : "A023020100",
      "display" : "FASTOP TABLETS 200MG"
    },
    {
      "code" : "A023021100",
      "display" : "CIWETIM TABLETS (CIMETIDINE)\"M.S.\""
    },
    {
      "code" : "A023023209",
      "display" : "CEPHEN INJECTION (DIPHENIDOL) \"Y.Y.\""
    },
    {
      "code" : "A023023212",
      "display" : "CEPHEN INJECTION (DIPHENIDOL) \"Y.Y.\""
    },
    {
      "code" : "A023024238",
      "display" : "ILUFU INJECTION \"WINSTON\""
    },
    {
      "code" : "A023026100",
      "display" : "SULPIDE TABLETS (SULPIRIDE) \"H.C.\""
    },
    {
      "code" : "A023028100",
      "display" : "DA CON WEI TABLETS (CIMETIDINE) \"C.M.\""
    },
    {
      "code" : "A023029100",
      "display" : "SULPIRID CAPSULES \"H.S.C.\""
    },
    {
      "code" : "A023031100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"K.T.\""
    },
    {
      "code" : "A023033100",
      "display" : "CIMETINE TABLETS (CIMETIDINE) \"PRINCE\""
    },
    {
      "code" : "A023035321",
      "display" : "GYNO-MYCODERIN CREAM (MICONAZOLE) \"BOWLIN\""
    },
    {
      "code" : "A023037100",
      "display" : "CARDOLOL TABLETS 10MG (PROPRANOLOL) \"VPP\""
    },
    {
      "code" : "A0230371G0",
      "display" : "CARDOLOL TABLETS 10MG (PROPRANOLOL) \"VPP\""
    },
    {
      "code" : "A023038321",
      "display" : "CHAA CREAM \"H.C.T.\" (CHLOROHYDROXY ALUMINUM ALLANTOINATE)"
    },
    {
      "code" : "A023039100",
      "display" : "CEFALOX CAPSULES 500MG (CEPHALEXIN) \"Y.F.\""
    },
    {
      "code" : "A023041100",
      "display" : "ALLOPURINOL TABLETS \"PANBIOTIC\""
    },
    {
      "code" : "A023042100",
      "display" : "AMOLIN CAPSULES 500MG (AMOXICILLIN) \"Y.F.\""
    },
    {
      "code" : "A023048209",
      "display" : "CEZOLIN INJECTION 1GM \"SWISS\""
    },
    {
      "code" : "A023054100",
      "display" : "Cephen S.C. Tablets \"Y.Y.\""
    },
    {
      "code" : "A023063100",
      "display" : "ANPRELINE TABLETS \"OEIENTAL\""
    },
    {
      "code" : "A023077214",
      "display" : "KANAMYCIN SULFATE FOR INJECTION 2.5GM (POTENCY)"
    },
    {
      "code" : "A023079221",
      "display" : "KANAMYCIN SULFATE FOR INJECTION 5.0GM (POTENCY)"
    },
    {
      "code" : "A023084229",
      "display" : "LICOSON INJECTION (DEXAMETHASONE SODIUM)\"SIUTON\""
    },
    {
      "code" : "A023087212",
      "display" : "MEGATO INJECTION (CIMETIDINE) \"GENTLE\""
    },
    {
      "code" : "A023096100",
      "display" : "ATILEN TABLETS (LORAZEPAM) \"M.S.\""
    },
    {
      "code" : "A023097100",
      "display" : "CLONAC TABLETS \"GOLDEN HORSE\""
    },
    {
      "code" : "A023100100",
      "display" : "AMPICILLIN CAPSULES 250MG \"YUNG CHANG\""
    },
    {
      "code" : "A023102100",
      "display" : "PONTON TABLETS 500MG\"Y.K.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A023108214",
      "display" : "TRANEXAMIC ACID INJECTION 100MG/ML \"G.C.\""
    },
    {
      "code" : "A023108221",
      "display" : "TRANEXAMIC ACID INJECTION 100MG/ML \"G.C.\""
    },
    {
      "code" : "A023109212",
      "display" : "CIMETIDINE INJECTION 100MG/ML \"Y.Y.\""
    },
    {
      "code" : "A023110100",
      "display" : "MEGATO TABLETS (CMETIDINE) \"GENTLE\""
    },
    {
      "code" : "A023113209",
      "display" : "LUMIATO INJECTION \"TAI YU\""
    },
    {
      "code" : "A023114212",
      "display" : "SERACIN INJECTION 6％ (GENTAMYCIN SULFATE)"
    },
    {
      "code" : "A023114229",
      "display" : "SERACIN INJECTION 6％ (GENTAMYCIN SULFATE)"
    },
    {
      "code" : "A023115335",
      "display" : "CLOMAZOLE SPRAY SOLUTION 1％ (CLOTRIMAZOLE)."
    },
    {
      "code" : "A023121100",
      "display" : "S-CON TABLETS 40MG (DIMETHYLPOLYSILOXANE) \"TAI YU\""
    },
    {
      "code" : "A023126343",
      "display" : "AQU SERODINE (POVIDONE IODINE) \"GCPC\""
    },
    {
      "code" : "A023131321",
      "display" : "AIFUPO OINTMENT \"Y.U.\""
    },
    {
      "code" : "A023131329",
      "display" : "AIFUPO OINTMENT \"Y.U.\""
    },
    {
      "code" : "A023131372",
      "display" : "AIFUPO OINTMENT \"Y.U.\""
    },
    {
      "code" : "A023131399",
      "display" : "AIFUPO OINTMENT \"Y.U.\""
    },
    {
      "code" : "A023133323",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023133329",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023133330",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023133335",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023133372",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023133399",
      "display" : "EXTRACOMB CREAM"
    },
    {
      "code" : "A023135100",
      "display" : "TAGASONE TABLETS \"Y.Y.\" (CIMETIDINE)"
    },
    {
      "code" : "A0231351G0",
      "display" : "TAGASONE TABLETS \"Y.Y.\" (CIMETIDINE)"
    },
    {
      "code" : "A023137100",
      "display" : "RESEIN TABLETS \"SHITEH\""
    },
    {
      "code" : "A023143100",
      "display" : "Pseubyirin Tablets 60MG \"T.F.\""
    },
    {
      "code" : "A0231431G0",
      "display" : "Pseubyirin Tablets 60MG \"T.F.\""
    },
    {
      "code" : "A023148435",
      "display" : "WIN-WAY NASAL SPRAY"
    },
    {
      "code" : "A023150421",
      "display" : "EYESMIN EYE DROPS (NEOSTIGMINE METHYLSULFATE) \"OASIS\""
    },
    {
      "code" : "A023150429",
      "display" : "EYESMIN EYE DROPS (NEOSTIGMINE METHYLSULFATE) \"OASIS\""
    },
    {
      "code" : "A023151100",
      "display" : "\"UBIP\" ERGONOVINE MALEATE S.C. TABLETS"
    },
    {
      "code" : "A0231511G0",
      "display" : "\"UBIP\" ERGONOVINE MALEATE S.C. TABLETS"
    },
    {
      "code" : "A023152100",
      "display" : "CAFEGOTAMINE S.C. TABLETS \"H.L.\""
    },
    {
      "code" : "A023155118",
      "display" : "GLYMECON SYRUP"
    },
    {
      "code" : "A023155199",
      "display" : "GLYMECON SYRUP"
    },
    {
      "code" : "A023156221",
      "display" : "ZUCERIN INJECTION (TRANEXAMIC ACID) \"LITA\""
    },
    {
      "code" : "A023157335",
      "display" : "JOYLA CREAM \"SINPHAR\""
    },
    {
      "code" : "A023162100",
      "display" : "RE-LIVER CAPSULES \"JINUP\""
    },
    {
      "code" : "A023164500",
      "display" : "CLOMAZOLE VAGINAL SUPPOSITORIES (CLOTRIMAZOLE) \"VEIMIN\""
    },
    {
      "code" : "A023167319",
      "display" : "VISDERM H CREAM 0.1％ (AMCINONIDE)"
    },
    {
      "code" : "A023167362",
      "display" : "VISDERM H CREAM 0.1％ (AMCINONIDE)"
    },
    {
      "code" : "A023167363",
      "display" : "VISDERM H CREAM 0.1％ (AMCINONIDE)"
    },
    {
      "code" : "A023167365",
      "display" : "VISDERM H CREAM 0.1％ (AMCINONIDE)"
    },
    {
      "code" : "A023167399",
      "display" : "VISDERM H CREAM 0.1％ (AMCINONIDE)"
    },
    {
      "code" : "A023169500",
      "display" : "CLOMAZOLE VAGINAL TABLETS 100MG"
    },
    {
      "code" : "A023180100",
      "display" : "SULPIRIDE CAPSULES"
    },
    {
      "code" : "A023183100",
      "display" : "TETRACYCLINE CAPSULES 250MG \"C.R.\""
    },
    {
      "code" : "A023184100",
      "display" : "TETRACYCLINE CAPSULES 500MG \"C.R.\""
    },
    {
      "code" : "A023185321",
      "display" : "TETRADERM CREAM \"Union\""
    },
    {
      "code" : "A023185372",
      "display" : "TETRADERM CREAM \"Union\""
    },
    {
      "code" : "A023185399",
      "display" : "TETRADERM CREAM \"Union\""
    },
    {
      "code" : "A023186100",
      "display" : "BETAMETHASONE TABLETS \"ASTAR\""
    },
    {
      "code" : "A023187100",
      "display" : "RICOL TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A023192100",
      "display" : "AMPICILLIN CAPSULES 500MG \"K.T.\""
    },
    {
      "code" : "A023194100",
      "display" : "SABUMOL TABLETS (SALBUTAMOL)"
    },
    {
      "code" : "A0231941G0",
      "display" : "SABUMOL TABLETS (SALBUTAMOL)"
    },
    {
      "code" : "A023196100",
      "display" : "PIZEPIN TABLETS \"STANDARD\" (PIRENEPINE 2HCL)"
    },
    {
      "code" : "A023200100",
      "display" : "NEUER CAPSULES 100MG (CETRAXATE HCL)"
    },
    {
      "code" : "A023206100",
      "display" : "BONCA TABLETS CHEWABLE \"BOWLIN\""
    },
    {
      "code" : "A023213100",
      "display" : "SPIZIN S.C. TABLETS (THIORIDAZINE HYDROCHLORIDE) \"W.P.\""
    },
    {
      "code" : "A023217100",
      "display" : "PIPEMID CAPSULES (PIPEMIDIC ACID) \"M.S.\""
    },
    {
      "code" : "A023219100",
      "display" : "POTON CAPSULES 500MG (MEFENAMIC ACID) \"CURIE\""
    },
    {
      "code" : "A023220100",
      "display" : "BIOSAREN CAPSULES (TRANEXAMIC ACID) \"PANBIOTIC\""
    },
    {
      "code" : "A023226212",
      "display" : "HYDRO-B12 INJECTION \"Y.A.\"(HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A023230221",
      "display" : "RASEMIN INJECTION 10％ \"Y.Y.\"(TRANEXAMIC ACID)"
    },
    {
      "code" : "A023230229",
      "display" : "RASEMIN INJECTION 10％ \"Y.Y.\"(TRANEXAMIC ACID)"
    },
    {
      "code" : "A023231321",
      "display" : "CIVIDOID GEL \"SINPHAR\" (HEPARINOID)"
    },
    {
      "code" : "A023231329",
      "display" : "CIVIDOID GEL \"SINPHAR\" (HEPARINOID)"
    },
    {
      "code" : "A023231338",
      "display" : "CIVIDOID GEL \"SINPHAR\" (HEPARINOID)"
    },
    {
      "code" : "A023234100",
      "display" : "DOCOL TABLETS (PIPEMIDIC ACID) \"M.T.\""
    },
    {
      "code" : "A023239100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"TBC.\""
    },
    {
      "code" : "A0232391G0",
      "display" : "AMOXICILLIN CAPSULES 500MG \"TBC.\""
    },
    {
      "code" : "A023242221",
      "display" : "LISAMIN INJECTION \"N.K.\"(TRANEXAMIC ACID)"
    },
    {
      "code" : "A023250238",
      "display" : "K-CILLIN INJECTION 20,000,000 UNITS (POTASSIUM PENICILLIN G) \"VPP\""
    },
    {
      "code" : "A023253100",
      "display" : "LISAMIN CAPSULES (TRANEXAMIC ACID) \"N.K.\""
    },
    {
      "code" : "A023257100",
      "display" : "FULETIN TABLETS"
    },
    {
      "code" : "A023264100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"TBC\""
    },
    {
      "code" : "A0232641G0",
      "display" : "AMOXICILLIN CAPSULES 250MG \"TBC\""
    },
    {
      "code" : "A023265277",
      "display" : "PAMOXICILLIN INJECTION 500MG (AMOXICILLIN)\"C.Y.\""
    },
    {
      "code" : "A023266212",
      "display" : "ALON INJECTION"
    },
    {
      "code" : "A023266216",
      "display" : "ALON INJECTION"
    },
    {
      "code" : "A023276100",
      "display" : "STONE TABLETS (ACETAMINOPHEN) \"METRO\""
    },
    {
      "code" : "A023284100",
      "display" : "NEWZYME TABLETS \"STANDARD\""
    },
    {
      "code" : "A023285100",
      "display" : "YUPENT TABLETS (ORCIPRENALINE) \"TAI YU\""
    },
    {
      "code" : "A023287100",
      "display" : "AMPICILLIN CAPSULES 500MG \"TAI YU\""
    },
    {
      "code" : "A023288209",
      "display" : "KOSCOPAN INJECTION (HYOSCINE-N-BUTYLBROMIDE)"
    },
    {
      "code" : "A023290100",
      "display" : "FUPAUCAN CAPSULES (PIPEMIDIC ACID) \"UIRIE\""
    },
    {
      "code" : "A023293118",
      "display" : "LOPERA SYRUP (LOPERAMIDE) \"IDEAL\""
    },
    {
      "code" : "A023293155",
      "display" : "LOPERA SYRUP (LOPERAMIDE) \"IDEAL\""
    },
    {
      "code" : "A023293157",
      "display" : "LOPERA SYRUP (LOPERAMIDE) \"IDEAL\""
    },
    {
      "code" : "A023293199",
      "display" : "LOPERA SYRUP (LOPERAMIDE) \"IDEAL\""
    },
    {
      "code" : "A023297100",
      "display" : "METICON TABLETS 30MG \"S.Y.\" (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A023298100",
      "display" : "CON-BI TABLETS \"Y.C.\""
    },
    {
      "code" : "A023303100",
      "display" : "ZALPAM TABLETS 5MG (DIAZEPAM) \"SINPHAR\""
    },
    {
      "code" : "A023308100",
      "display" : "HI-BESTON 50MG S.C. TABLETS"
    },
    {
      "code" : "A023309100",
      "display" : "AFUCO TABLETS"
    },
    {
      "code" : "A023312265",
      "display" : "AMINOGEN X INJECTION \"N.K.\""
    },
    {
      "code" : "A023312277",
      "display" : "AMINOGEN X INJECTION \"N.K.\""
    },
    {
      "code" : "A023313100",
      "display" : "KWEI SAN TABLETS \"C.M.\""
    },
    {
      "code" : "A023317212",
      "display" : "DIPYRIDAMOLE INJECTION \"ASTAR\""
    },
    {
      "code" : "A023318100",
      "display" : "DIFENDIN TABLETS (DIPHENIDOL) \"CHINTENG\""
    },
    {
      "code" : "A0233181G0",
      "display" : "DIFENDIN TABLETS (DIPHENIDOL) \"CHINTENG\""
    },
    {
      "code" : "A023319100",
      "display" : "CLEMASTINE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A023320100",
      "display" : "YUMENIN TABLETS (NITROFURANTOIN) \"TAI YU\""
    },
    {
      "code" : "A023321100",
      "display" : "PYDAMOLE S.C. TABLETS 12.5MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A023322100",
      "display" : "POSTAN CAPSULES \"W.S.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A023330100",
      "display" : "ANBININ TABLETS FOR CHILDREN (ASPIRIN) \"Y.S.\""
    },
    {
      "code" : "A023331100",
      "display" : "PYLINATON TABLETS 500MG"
    },
    {
      "code" : "A023334221",
      "display" : "KOSAMIN INJECTION (TRANEXAMIC ACID)\"LIN CHEMICAL\""
    },
    {
      "code" : "A023336321",
      "display" : "PASCA GEL \"SHIONOGI\""
    },
    {
      "code" : "A023336329",
      "display" : "PASCA GEL \"SHIONOGI\""
    },
    {
      "code" : "A023337100",
      "display" : "RIFA CAPSULES (RIFAMPICIN) \"LIN CHEMICAL\""
    },
    {
      "code" : "A023341216",
      "display" : "VENTON INJECTION (DICLOFENAC) \"LITA\""
    },
    {
      "code" : "A023342100",
      "display" : "LORAT TABLETS (LORAZEPAM) \"M.T.\""
    },
    {
      "code" : "A023344100",
      "display" : "ANTHEL TABLETS \"Y.Y.\""
    },
    {
      "code" : "A023352100",
      "display" : "SATINMIN TABLETS \"S.C.\" (CARBINOXAMINE)"
    },
    {
      "code" : "A023353100",
      "display" : "PARANADRINE TABLETS \"S.C.\""
    },
    {
      "code" : "A023356100",
      "display" : "SU'S CAPSULES"
    },
    {
      "code" : "A023359238",
      "display" : "SUNLILIN INJECTION \"S.Y.\""
    },
    {
      "code" : "A023361100",
      "display" : "BICOMTRON S.C. TABLETS \"C.R.\""
    },
    {
      "code" : "A023369100",
      "display" : "PIPEK CAPSULES (PIPEMIDIC ACID) \"P.L.\""
    },
    {
      "code" : "A023370100",
      "display" : "ANZEPAM TABLETS 0.5MG (LORAZEPAM)"
    },
    {
      "code" : "A0233701G0",
      "display" : "ANZEPAM TABLETS 0.5MG (LORAZEPAM)"
    },
    {
      "code" : "A023374212",
      "display" : "CIMETINE INJECTION 100MG/ML (CIMETIDINE) \"TAI YU\""
    },
    {
      "code" : "A023376100",
      "display" : "EROCIN F.C. TABLETS (ERYTHROMYCIN) \"GCPC\""
    },
    {
      "code" : "A023378212",
      "display" : "CIMETINE INJECTION 100MG/ML (CIMETIDINE) \"PRINCE\""
    },
    {
      "code" : "A023379100",
      "display" : "SULPIRIDE TABLETS   \"VEIMIN\""
    },
    {
      "code" : "A023380435",
      "display" : "YIPI NASAL SOLUTION \"HEALTH\""
    },
    {
      "code" : "A023380477",
      "display" : "YIPI NASAL SOLUTION \"HEALTH\""
    },
    {
      "code" : "A023381100",
      "display" : "THYROID TABLETS \"GCPC\""
    },
    {
      "code" : "A023387100",
      "display" : "LEMISOL F.C. TABLETS \"STANDARD\"(LEVAMISOLE)"
    },
    {
      "code" : "A023389100",
      "display" : "Diclofon  Tablets 25mg \"F.Y.\""
    },
    {
      "code" : "A0233891G0",
      "display" : "Diclofon  Tablets 25mg \"F.Y.\""
    },
    {
      "code" : "A023391100",
      "display" : "STROMAFON TABLETS \"EAYUNG\""
    },
    {
      "code" : "A023394212",
      "display" : "WETIDINE INJECTION  \"TAH-AN\""
    },
    {
      "code" : "A023397100",
      "display" : "EACO TABLETS 30MG (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A023398100",
      "display" : "PAPAVERINE HYDROCHLORIDE TABLETS \"C.I.\""
    },
    {
      "code" : "A023399212",
      "display" : "KETOPHEN INJECTION \"SINTON\" (KETOPROFEN)"
    },
    {
      "code" : "A023412100",
      "display" : "ANQUWEI TABLETS (PIRENZEPINE) \"CURIE\""
    },
    {
      "code" : "A023415100",
      "display" : "WEIANLIN TABLETS \"HEALTH.\""
    },
    {
      "code" : "A023416100",
      "display" : "GONCID CAPSULES (INDOMETHACIN) \"METRO\""
    },
    {
      "code" : "A023422238",
      "display" : "GLYGEN-M INJECTION \"N.K.\""
    },
    {
      "code" : "A023424209",
      "display" : "HEXOESTROL INJECTION \"TAI YU\""
    },
    {
      "code" : "A023430100",
      "display" : "GASPIN TABLETS (PIRENZEPINE) \"GENTLE\""
    },
    {
      "code" : "A023434100",
      "display" : "LYSOEM TABLETS (LYSOZYME)"
    },
    {
      "code" : "A023435216",
      "display" : "STAREN INJECTION \"N.K.\"(DICLOFENAC)"
    },
    {
      "code" : "A023437212",
      "display" : "ZEMIN INJECTION (CLEMASTINE) \"PANBIOTIC\""
    },
    {
      "code" : "A023444221",
      "display" : "THIOKAGEN INJECTION (TIOPRONIN) \"Y.Y.\""
    },
    {
      "code" : "A023445209",
      "display" : "TRAVELLIN INJECTION \"TAI YU\""
    },
    {
      "code" : "A023446100",
      "display" : "AMOXICILLIN CAPSULES \"ASTAR\""
    },
    {
      "code" : "A023447100",
      "display" : "ASCORBIC ACID TABLETS \"ASTAR\""
    },
    {
      "code" : "A023449100",
      "display" : "LOPERAMIDE CAPSULES \"ORIENTAL\""
    },
    {
      "code" : "A023457100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"K.T.\""
    },
    {
      "code" : "A023459321",
      "display" : "UNIDERM CREAM \"HOCHENG\""
    },
    {
      "code" : "A023465100",
      "display" : "GRIVIN TABLETS (GRISEOFULVIN) \"METRO\""
    },
    {
      "code" : "A023466100",
      "display" : "TRIFLUOPERAZINE HCL TABLETS \"S.C.\""
    },
    {
      "code" : "A023479209",
      "display" : "DEXAMETHASONE INJECTION 1MG/ML \"TAI YU\""
    },
    {
      "code" : "A023479229",
      "display" : "DEXAMETHASONE INJECTION 1MG/ML \"TAI YU\""
    },
    {
      "code" : "A023479299",
      "display" : "DEXAMETHASONE INJECTION 1MG/ML \"TAI YU\""
    },
    {
      "code" : "A023481100",
      "display" : "CEPHALIN CAPSULES 500MG"
    },
    {
      "code" : "A023483100",
      "display" : "KU-WE-RIN TABLETS \"Y.S.\" (CIMETIDINE)"
    },
    {
      "code" : "A023488100",
      "display" : "ULCOGEN TABLETS"
    },
    {
      "code" : "A0234881G0",
      "display" : "ULCOGEN TABLETS"
    },
    {
      "code" : "A023490100",
      "display" : "SODICON TABLETS \"SINPHAR\""
    },
    {
      "code" : "A023491100",
      "display" : "SODICON-G TABLETS \"SINPHAR\""
    },
    {
      "code" : "A0234911G0",
      "display" : "SODICON-G TABLETS \"SINPHAR\""
    },
    {
      "code" : "A023492212",
      "display" : "DEPO-B12 INJEDTION  \"ORIENTAL\" (HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A023494219",
      "display" : "PIPRIL PARENTERAL 4GM (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A023499100",
      "display" : "LOPERAMIDE CAPSULES \"J.H.\""
    },
    {
      "code" : "A023500100",
      "display" : "AZULIN TABLETS (GUAIAZULENE) \"K.B.\""
    },
    {
      "code" : "A023508100",
      "display" : "DALCONE TABLETS (PIPEMIDIC ACID) \"H.H.\""
    },
    {
      "code" : "A023511212",
      "display" : "SULPIRIDE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A023512100",
      "display" : "VITAMIN C TABLETS 250MG\"N.C.P\""
    },
    {
      "code" : "A023513100",
      "display" : "FUROSEMIDE TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A023517100",
      "display" : "AMPICILLIN CAPSULES 500MG \"Y.S.\""
    },
    {
      "code" : "A023519321",
      "display" : "TOPICON OINTMENT (FLUCLOROLONE)"
    },
    {
      "code" : "A023519329",
      "display" : "TOPICON OINTMENT (FLUCLOROLONE)"
    },
    {
      "code" : "A023519343",
      "display" : "TOPICON OINTMENT (FLUCLOROLONE)"
    },
    {
      "code" : "A023519355",
      "display" : "TOPICON OINTMENT (FLUCLOROLONE)"
    },
    {
      "code" : "A023519399",
      "display" : "TOPICON OINTMENT (FLUCLOROLONE)"
    },
    {
      "code" : "A023521100",
      "display" : "MAGNESIUM OXIDE TABLETS \"SYNMOSA\""
    },
    {
      "code" : "A023524100",
      "display" : "COSTENE TABLETS \"H.S.\"(CARBETAPENTANE)"
    },
    {
      "code" : "A023527100",
      "display" : "AZENOL TABLETS (AZULENE) \"CENTRAL\""
    },
    {
      "code" : "A023531421",
      "display" : "BENEMYCIN EYE DROPS \"OASIS\""
    },
    {
      "code" : "A023532100",
      "display" : "LIZEPINE TABLETS (PIRENZEPINE DIHYDROCHLORIDE)"
    },
    {
      "code" : "A023533329",
      "display" : "FUNGICIDE CREAM (CLOTRIMAZOLE) \"ROYAL\""
    },
    {
      "code" : "A023534100",
      "display" : "ROPAL TABLETS (ASPIRIN) \"ROYAL\""
    },
    {
      "code" : "A023536100",
      "display" : "COFUCAINE TABLETS \"F.S.\""
    },
    {
      "code" : "A023547209",
      "display" : "Anethole Injection\"K.S.\""
    },
    {
      "code" : "A023557100",
      "display" : "MIZO AMTHELEMINTICS TABLETS (MEBENDAZOLE) \"K.T.\""
    },
    {
      "code" : "A023560100",
      "display" : "DICARIS TABLETS (LEVAMISOLE) \"SHITEH\""
    },
    {
      "code" : "A023562216",
      "display" : "ORITAREN INJECTION (DICLOFENAC) \"ORIENTAL\""
    },
    {
      "code" : "A023563212",
      "display" : "KETOFEN INJECTION (KETOPROFEN) \"ORIENTAL\""
    },
    {
      "code" : "A023563216",
      "display" : "KETOFEN INJECTION (KETOPROFEN) \"ORIENTAL\""
    },
    {
      "code" : "A023565100",
      "display" : "LYSOZYME TABLETS 50MG \"SINPHAR\""
    },
    {
      "code" : "A023571100",
      "display" : "VITALY S.C. TABLETS \"PRINCE\""
    },
    {
      "code" : "A023572100",
      "display" : "WYPIRIDE CAPSULES (SULPIRIDE) \"S.P.C.\""
    },
    {
      "code" : "A023576100",
      "display" : "CHLORAMPHENICOL CAPSULES \"C.R.\""
    },
    {
      "code" : "A023577100",
      "display" : "OXYTETRACYCLINE CAPSULES \"C.R.\""
    },
    {
      "code" : "A023583100",
      "display" : "A-WEIAN TABLETS (PIRENZEPINE DIHYDROCHLORIDE) \"H.C.\""
    },
    {
      "code" : "A023587421",
      "display" : "E E N EYE DROPS \"GCPC\""
    },
    {
      "code" : "A023587423",
      "display" : "E E N EYE DROPS \"GCPC\""
    },
    {
      "code" : "A023589100",
      "display" : "LOGMAL CAPSULES (SULPIRIDE) \"M.T.\""
    },
    {
      "code" : "A0235891G0",
      "display" : "LOGMAL CAPSULES (SULPIRIDE) \"M.T.\""
    },
    {
      "code" : "A023592100",
      "display" : "CIMETIDINE TABLETS 200MG\"D.T.S\""
    },
    {
      "code" : "A023593100",
      "display" : "DIPHENIDOL S.C. TABLETS \"EAYUNG\""
    },
    {
      "code" : "A023598118",
      "display" : "GLYLATE SYRUP (GLYCERYL GUAIACOLATE)"
    },
    {
      "code" : "A023598199",
      "display" : "GLYLATE SYRUP (GLYCERYL GUAIACOLATE)"
    },
    {
      "code" : "A023599100",
      "display" : "PELIN CAPSULES (DL-ALPHA-TOCOPHEROL NICOTINATE)"
    },
    {
      "code" : "A023600321",
      "display" : "Camisten Cream \"Sinphar\"(Miconazole Nitrate )"
    },
    {
      "code" : "A023602309",
      "display" : "SINDINE OINTMENT \"SINPHAR\"(POVIDONE-IODINE)"
    },
    {
      "code" : "A023602329",
      "display" : "SINDINE OINTMENT \"SINPHAR\"(POVIDONE-IODINE)"
    },
    {
      "code" : "A023602372",
      "display" : "SINDINE OINTMENT \"SINPHAR\"(POVIDONE-IODINE)"
    },
    {
      "code" : "A023602399",
      "display" : "SINDINE OINTMENT \"SINPHAR\"(POVIDONE-IODINE)"
    },
    {
      "code" : "A023603209",
      "display" : "SEZUMINE INJECTION \"PANHIOTIC\""
    },
    {
      "code" : "A023603216",
      "display" : "SEZUMINE INJECTION \"PANHIOTIC\""
    },
    {
      "code" : "A023604209",
      "display" : "SEPINE INJECTION (HYDROXOCOBALAMIN) \"PANBIOTIC\""
    },
    {
      "code" : "A023604212",
      "display" : "SEPINE INJECTION (HYDROXOCOBALAMIN) \"PANBIOTIC\""
    },
    {
      "code" : "A023606100",
      "display" : "PEPTIDIN TABLETS"
    },
    {
      "code" : "A0236061G0",
      "display" : "PEPTIDIN TABLETS"
    },
    {
      "code" : "A023610277",
      "display" : "KANAMYCIN SULFATE FOR INJECTION 0.5GM(POTENCY"
    },
    {
      "code" : "A023611100",
      "display" : "ENMOCIL  CAPSULES 250MG (AMOXICILLIN) \"ENSURE\""
    },
    {
      "code" : "A023611112",
      "display" : "ENMOCIL  CAPSULES 250MG (AMOXICILLIN) \"ENSURE\""
    },
    {
      "code" : "A023616100",
      "display" : "SEDENTON TABLETS"
    },
    {
      "code" : "A023618100",
      "display" : "PARACETAMOL TABLETS"
    },
    {
      "code" : "A023619100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"SINPHAR\""
    },
    {
      "code" : "A023622212",
      "display" : "CIMETIDINE INJECTION 150MG/ML \"G.C.\""
    },
    {
      "code" : "A023624271",
      "display" : "PAREMENTAL A INJECTION \"C.C.P.\""
    },
    {
      "code" : "A023625271",
      "display" : "PAREMENTAL-B INJECTION \"C.C.P.\""
    },
    {
      "code" : "A023626321",
      "display" : "DAFRIN-H CREAM\"SWISS\""
    },
    {
      "code" : "A023627100",
      "display" : "VENTURIN TABLETS \"Y.S.\" (DIPHENIDOL)"
    },
    {
      "code" : "A023628212",
      "display" : "GASPIN INJECTION (PIRENZEPINE) \"GENTLE\""
    },
    {
      "code" : "A023630100",
      "display" : "PANSIL-P S.C. TABLETS"
    },
    {
      "code" : "A023631321",
      "display" : "TOPICON CREAM (FLUCLOROLONE)"
    },
    {
      "code" : "A023631355",
      "display" : "TOPICON CREAM (FLUCLOROLONE)"
    },
    {
      "code" : "A023631399",
      "display" : "TOPICON CREAM (FLUCLOROLONE)"
    },
    {
      "code" : "A023635100",
      "display" : "RITESONE CAPSULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A023644100",
      "display" : "PERITIN  TABLET 25MG \"Y.C.\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A023645100",
      "display" : "HECODEN TABLETS"
    },
    {
      "code" : "A023646100",
      "display" : "CEPHALEXIN CAPSULES"
    },
    {
      "code" : "A023648100",
      "display" : "DOXYCYCLINE CAPSULES"
    },
    {
      "code" : "A023652100",
      "display" : "BECOLON CAPSULES"
    },
    {
      "code" : "A023653100",
      "display" : "CHLORAMPHENICOL CAPSULES"
    },
    {
      "code" : "A023654100",
      "display" : "DECOUGH CAPSULES \"Y.C.\""
    },
    {
      "code" : "A023655100",
      "display" : "SALBUTAMOL TABLETS"
    },
    {
      "code" : "A023656100",
      "display" : "ANTICOUGH TABLETS 15MG \" F.S.\" (DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A023662329",
      "display" : "ECOSONE CREAM \"BOWLIN\""
    },
    {
      "code" : "A023662330",
      "display" : "ECOSONE CREAM \"BOWLIN\""
    },
    {
      "code" : "A023662372",
      "display" : "ECOSONE CREAM \"BOWLIN\""
    },
    {
      "code" : "A023662399",
      "display" : "ECOSONE CREAM \"BOWLIN\""
    },
    {
      "code" : "A023663321",
      "display" : "ECONAZOLE TRIAMCINOLONE CREAM \"TWI\""
    },
    {
      "code" : "A023663329",
      "display" : "ECONAZOLE TRIAMCINOLONE CREAM \"TWI\""
    },
    {
      "code" : "A023663335",
      "display" : "ECONAZOLE TRIAMCINOLONE CREAM \"TWI\""
    },
    {
      "code" : "A023663377",
      "display" : "ECONAZOLE TRIAMCINOLONE CREAM \"TWI\""
    },
    {
      "code" : "A023664500",
      "display" : "ECONAZOLE VAGINAL SUPPOSITORIES \"O.Y.\""
    },
    {
      "code" : "A023666329",
      "display" : "TUAN OINTMENT \"H.L.\""
    },
    {
      "code" : "A023668212",
      "display" : "CLEMASTINE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A023670100",
      "display" : "PIROCAM CAPSULES (PIROXICAM) \"GENTLE\""
    },
    {
      "code" : "A023671100",
      "display" : "FENOT TABLETS 2.5mg (FENOTEROL)"
    },
    {
      "code" : "A023674399",
      "display" : "ECONSONE CREAM"
    },
    {
      "code" : "A023677109",
      "display" : "PANTRIUM GRANULES"
    },
    {
      "code" : "A023677199",
      "display" : "PANTRIUM GRANULES"
    },
    {
      "code" : "A023683100",
      "display" : "REPACIN F.C TABLETS (BETA-AESCIN) \"ROYAL\""
    },
    {
      "code" : "A023684100",
      "display" : "DOXYCYCLINE CAPSULES \"C.R.\""
    },
    {
      "code" : "A023686100",
      "display" : "LYSOZYME TABLETS 90MG \"CHEN TA\""
    },
    {
      "code" : "A023687309",
      "display" : "FUDELIN CREAM (FLUOCINONIDE)\"L.S.\""
    },
    {
      "code" : "A023687321",
      "display" : "FUDELIN CREAM (FLUOCINONIDE)\"L.S.\""
    },
    {
      "code" : "A023687329",
      "display" : "FUDELIN CREAM (FLUOCINONIDE)\"L.S.\""
    },
    {
      "code" : "A023687399",
      "display" : "FUDELIN CREAM (FLUOCINONIDE)\"L.S.\""
    },
    {
      "code" : "A023692100",
      "display" : "E-NATE CAPSULES (TOCOPHEROL NICOTINATE) \"SHITEH\""
    },
    {
      "code" : "A023695100",
      "display" : "PYRIXAL E.C. TABLETS (PYRIDOXAL PHOSPHATE) \"M.T.\""
    },
    {
      "code" : "A023700209",
      "display" : "SULPIRIDE INJECTION \"H.S.C.\""
    },
    {
      "code" : "A023700212",
      "display" : "SULPIRIDE INJECTION \"H.S.C.\""
    },
    {
      "code" : "A023708100",
      "display" : "ESCIN S.C. TABLETS (BETA-AESIN)"
    },
    {
      "code" : "A023711321",
      "display" : "PIDELON CREAM \"N.K.\""
    },
    {
      "code" : "A023714109",
      "display" : "NOFLAGMA GRANULES (LYSOZYME) \"YUNG SHIN\""
    },
    {
      "code" : "A023714199",
      "display" : "NOFLAGMA GRANULES (LYSOZYME) \"YUNG SHIN\""
    },
    {
      "code" : "A023715100",
      "display" : "CARMINE TABLETS \"Y.Y.\""
    },
    {
      "code" : "A023716277",
      "display" : "ASPIRIN INJECTION \"SHITEH\""
    },
    {
      "code" : "A023723100",
      "display" : "TRIAMCINOLONE TABLETS \"C.H.\""
    },
    {
      "code" : "A023727100",
      "display" : "E-FUCON S.C. TABLETS \"M.T.\""
    },
    {
      "code" : "A023729321",
      "display" : "QUADRIGEN CREAM \"SWISS\""
    },
    {
      "code" : "A023733263",
      "display" : "GLYCETOSE INJECTION \"S.T.\""
    },
    {
      "code" : "A023733265",
      "display" : "GLYCETOSE INJECTION \"S.T.\""
    },
    {
      "code" : "A023733266",
      "display" : "GLYCETOSE INJECTION \"S.T.\""
    },
    {
      "code" : "A023733277",
      "display" : "GLYCETOSE INJECTION \"S.T.\""
    },
    {
      "code" : "A023736100",
      "display" : "PIROCAM CAPSULES \"SWISS\"(PIROXICAM)"
    },
    {
      "code" : "A0237361G0",
      "display" : "PIROCAM CAPSULES \"SWISS\"(PIROXICAM)"
    },
    {
      "code" : "A023739151",
      "display" : "ILOSONE LIQUID 125MG/5ML"
    },
    {
      "code" : "A023739177",
      "display" : "ILOSONE LIQUID 125MG/5ML"
    },
    {
      "code" : "A023739199",
      "display" : "ILOSONE LIQUID 125MG/5ML"
    },
    {
      "code" : "A023742100",
      "display" : "EFU CAPSULE \"C.H.\""
    },
    {
      "code" : "A023743100",
      "display" : "PARAMMINE TABLETS"
    },
    {
      "code" : "A023749100",
      "display" : "LICOLIN TABLETS (LOPERAMIDE)\"T.L.\""
    },
    {
      "code" : "A023752221",
      "display" : "KNOWFUL INJECTION (PIRACETAM)\"YUNG SHIN\""
    },
    {
      "code" : "A023756100",
      "display" : "LOPERAMIDE CAPSULES"
    },
    {
      "code" : "A023762100",
      "display" : "KASCOPAN S.C. TABLETS"
    },
    {
      "code" : "A023763100",
      "display" : "LYZOTOSE TABLETS (LYSOZYME)"
    },
    {
      "code" : "A023764100",
      "display" : "CLONIDINE TABLETS"
    },
    {
      "code" : "A023769100",
      "display" : "MEFENAMA CAPSULES \"Y.C.\"(MEFENAMIC ACID)"
    },
    {
      "code" : "A023771100",
      "display" : "PROCOTON TABLETS \"J.L.\""
    },
    {
      "code" : "A023772100",
      "display" : "DIAZEPAM TABLETS \"KODAK\""
    },
    {
      "code" : "A023773100",
      "display" : "FOLDCAM CAPSULES (PIROXICAM) \"CHINTHENG\""
    },
    {
      "code" : "A0237731G0",
      "display" : "FOLDCAM CAPSULES (PIROXICAM) \"CHINTHENG\""
    },
    {
      "code" : "A023774100",
      "display" : "CLEMASTINE TABLETS \"TK&A\""
    },
    {
      "code" : "A023775100",
      "display" : "COLISTIN SULFATE CAPSULES"
    },
    {
      "code" : "A023785100",
      "display" : "ASCOPINE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A023789100",
      "display" : "TRANCOSU TABLETS"
    },
    {
      "code" : "A023790100",
      "display" : "FENOTER TABLETS (FENOTEROL) \"LITA\""
    },
    {
      "code" : "A023791100",
      "display" : "ENLAIN F.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A023792100",
      "display" : "CARNET CAPSULES \"M.S.\" (PIROXICAM)\"M.S.\""
    },
    {
      "code" : "A023793100",
      "display" : "LIVERALL F.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A023796500",
      "display" : "ECORIN VAGINAL SUPPOSITORY \"H.C.T.\" (ECONAZOLE)"
    },
    {
      "code" : "A023806100",
      "display" : "PECILMINE CAPSULES"
    },
    {
      "code" : "A023814219",
      "display" : "AMIMYCIN INJECTION 125MG/ML (AMIKACIN)"
    },
    {
      "code" : "A023815100",
      "display" : "FUTOFON TABLETS (BENZBROMARONE)"
    },
    {
      "code" : "A023819100",
      "display" : "CODECON CAPSULES"
    },
    {
      "code" : "A023820100",
      "display" : "CITIDINE TABLETS (CIMETIDINE)"
    },
    {
      "code" : "A0238201G0",
      "display" : "CITIDINE TABLETS (CIMETIDINE)"
    },
    {
      "code" : "A023822100",
      "display" : "DEPHEDOL F.C. TABLETS 25MG(DIPHRNIDOL)"
    },
    {
      "code" : "A023825100",
      "display" : "SPLOTIN TABLETS \"Y.C.\""
    },
    {
      "code" : "A023828100",
      "display" : "PROCOSONE TABLETS (PREDNISOLONE) \"KODAK\""
    },
    {
      "code" : "A023833100",
      "display" : "SWEI TABLETS \"YU SHENG\""
    },
    {
      "code" : "A023839118",
      "display" : "CORIGIN SYRUP"
    },
    {
      "code" : "A023839157",
      "display" : "CORIGIN SYRUP"
    },
    {
      "code" : "A023839199",
      "display" : "CORIGIN SYRUP"
    },
    {
      "code" : "A023844212",
      "display" : "STOGAMET INJECTION \"SWISS\"(CIMETIDINE)"
    },
    {
      "code" : "A023845100",
      "display" : "CHIERHSIN-40MG TABLETS"
    },
    {
      "code" : "A023846100",
      "display" : "WINDPIN TABLETS (BETAHISTINE) \"YUNG CHI\""
    },
    {
      "code" : "A023850100",
      "display" : "AN-AN TABLETS"
    },
    {
      "code" : "A023856100",
      "display" : "TINIGYN TABLETS (TINIDAZOLE) \"KINGDOM\""
    },
    {
      "code" : "A023857100",
      "display" : "LORAZEPAM TABLETS \"Y.C.\""
    },
    {
      "code" : "A023860100",
      "display" : "SULICAN S.C. TABLETS (SILYMARIN) \"YU SHENG\""
    },
    {
      "code" : "A023862100",
      "display" : "FELON CAPSULES (PIROXICAM) \"EAYUNG\""
    },
    {
      "code" : "A023863100",
      "display" : "SUKAINON CAPSULES 500MG (ACETAMINOPHEN) \"CURIE\""
    },
    {
      "code" : "A023864500",
      "display" : "ALL RIGHT Hemorrhoidal Suppository"
    },
    {
      "code" : "A023866100",
      "display" : "Genlimin S.C. Tablets \"F.Y.\""
    },
    {
      "code" : "A023872100",
      "display" : "CHATONCHI TABLETS (PRIDINOL) \"CURIE\""
    },
    {
      "code" : "A023876100",
      "display" : "LEMISOL TABLETS (LEVAMISOLE)"
    },
    {
      "code" : "A023879100",
      "display" : "ROTEC TABLETS \"F.Y.\""
    },
    {
      "code" : "A0238791G0",
      "display" : "ROTEC TABLETS \"F.Y.\""
    },
    {
      "code" : "A023882100",
      "display" : "HEMATONIC F.C. TABLETS \"GCPC\""
    },
    {
      "code" : "A023885355",
      "display" : "POVIDONE IODINE SOLUTION"
    },
    {
      "code" : "A023889100",
      "display" : "KONSUL TABLETS (PRIDINOL) \"LITA\""
    },
    {
      "code" : "A023890277",
      "display" : "AMINOL-V INJECTION \"S.T.\""
    },
    {
      "code" : "A023895100",
      "display" : "PHENOBARBITAL TABLETS 30MG"
    },
    {
      "code" : "A023896100",
      "display" : "PIROCAM CAPSULES (PIROXICAM) \"N.K.\""
    },
    {
      "code" : "A023901100",
      "display" : "PYROCAM CAPSULES 10MG (PIROXICAM) \"F.Y.\""
    },
    {
      "code" : "A023903238",
      "display" : "AIVITAL INJECTION \"GENTLE\""
    },
    {
      "code" : "A023904100",
      "display" : "LIDONIN TABLETS (DICLOFENAC) \"TAI YU\""
    },
    {
      "code" : "A023908100",
      "display" : "GELMALIN TABLETS"
    },
    {
      "code" : "A023912100",
      "display" : "BENZOLE TABLETS (MEBENDAZOLE) \"HONTEN\""
    },
    {
      "code" : "A023913100",
      "display" : "WEICOLIN TABLETS (CIMETIDINE) \"W.P.\""
    },
    {
      "code" : "A023915277",
      "display" : "AMOX INJECTION 500MG"
    },
    {
      "code" : "A023918100",
      "display" : "FLUZINE TABLETS \"STANDARD\" (FLUNARIZINE) 5MG"
    },
    {
      "code" : "A023920100",
      "display" : "BROPIN F.C. TABLETS \"STANDARD\" (BROMOPRIDE)"
    },
    {
      "code" : "A023925100",
      "display" : "COUGDAU TABLETS \"NCP\""
    },
    {
      "code" : "A023929277",
      "display" : "SODIUM ALGINATE INJECTION"
    },
    {
      "code" : "A023932100",
      "display" : "AZOL TABLETS (ACETAZOLAMIDE) \"NCP\""
    },
    {
      "code" : "A023934277",
      "display" : "SINCOLIN INJECTION"
    },
    {
      "code" : "A023936100",
      "display" : "BISMUTH SUBCARBONATE TABLETS \"N.C.P.\""
    },
    {
      "code" : "A023954100",
      "display" : "ATON TABLETS (ACETAMINOPHEN) \"NCP\""
    },
    {
      "code" : "A023967277",
      "display" : "Cepha Injection\"K.S.\""
    },
    {
      "code" : "A023969100",
      "display" : "MERO CAPSULES (KETOPROFEN) \"NCP\""
    },
    {
      "code" : "A023970100",
      "display" : "Erythrocin Capsules\"Taiten\"(Erythromycin Estolates)"
    },
    {
      "code" : "A023973100",
      "display" : "ASU CAPSULES \"NCP\""
    },
    {
      "code" : "A023978100",
      "display" : "Bocyline Capsules 500mg\"Taiten\""
    },
    {
      "code" : "A023979318",
      "display" : "ZUYAN SUSPENSION \"NCP\""
    },
    {
      "code" : "A023979399",
      "display" : "ZUYAN SUSPENSION \"NCP\""
    },
    {
      "code" : "A023981100",
      "display" : "ZIMIN S.C. TABLETS (CHLORCYCLIZINE) \"NCP\""
    },
    {
      "code" : "A023990109",
      "display" : "CEPHANMYCIN GRANULES 500MG (CEPHALEXIN) \"YUNG SHIN\""
    },
    {
      "code" : "A023990199",
      "display" : "CEPHANMYCIN GRANULES 500MG (CEPHALEXIN) \"YUNG SHIN\""
    },
    {
      "code" : "A023996100",
      "display" : "PIROXICAM CAPSULES \"S.C.\""
    },
    {
      "code" : "A023997100",
      "display" : "NIFEDIPINE CAPSULES"
    },
    {
      "code" : "A023998100",
      "display" : "ALUFIBRATE CAPSULES"
    },
    {
      "code" : "A023999100",
      "display" : "BACIDE CAPSULES (PIPEMIDIC ACID) \"S.C.\""
    },
    {
      "code" : "A024002100",
      "display" : "TETRACYCLINE HCL CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A024004100",
      "display" : "BUGIFENE TABLETS \"P.L.\""
    },
    {
      "code" : "A024005100",
      "display" : "TEPEZINE F.C. TABLETS 2MG (TRIFLUOPERAZINE HCL)"
    },
    {
      "code" : "A024006209",
      "display" : "TBC No.8A Injection"
    },
    {
      "code" : "A024006271",
      "display" : "TBC No.8A Injection"
    },
    {
      "code" : "A024008109",
      "display" : "CEPHALEXIN GRANULES"
    },
    {
      "code" : "A024008199",
      "display" : "CEPHALEXIN GRANULES"
    },
    {
      "code" : "A024010100",
      "display" : "IBUPROFEN F.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A024014221",
      "display" : "TRANSACID INJECTION (TRANEXAMIC ACID)"
    },
    {
      "code" : "A024016109",
      "display" : "ERYSONE GRANULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A024016177",
      "display" : "ERYSONE GRANULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A024016199",
      "display" : "ERYSONE GRANULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A024017100",
      "display" : "CIMEDIN TABLETS 200MG (CIMETIDINE) \"TBC\""
    },
    {
      "code" : "A0240171G0",
      "display" : "CIMEDIN TABLETS 200MG (CIMETIDINE) \"TBC\""
    },
    {
      "code" : "A024018100",
      "display" : "NIFEPIN CAPSULES (NIFEDIPINE) \"ROYAL\""
    },
    {
      "code" : "A024020100",
      "display" : "POUDERCAM CAPSULES \"H.S.\""
    },
    {
      "code" : "A024023100",
      "display" : "ANJAL TABLETS \"YU SHENG\""
    },
    {
      "code" : "A024024209",
      "display" : "SWIPIN INJECTION"
    },
    {
      "code" : "A024029263",
      "display" : "MORIAMIN-SN INJECTION"
    },
    {
      "code" : "A024029277",
      "display" : "MORIAMIN-SN INJECTION"
    },
    {
      "code" : "A024037100",
      "display" : "ANALGIN TABLETS \"M.H.\""
    },
    {
      "code" : "A024040209",
      "display" : "KONSUL INJECTION (PRIDINOL) \"LITA\""
    },
    {
      "code" : "A024044100",
      "display" : "BACTIN TABLETS \"YIHHAW\""
    },
    {
      "code" : "A024053100",
      "display" : "BLOODFULL S.C. TABLETS \"C.H.\""
    },
    {
      "code" : "A024054100",
      "display" : "RHEUCAM CAPSULES \"SHIN FONG\" (PIROXICAM)"
    },
    {
      "code" : "A024055100",
      "display" : "PAIN RELIEF F.C. TABLETS 200mg (Ibuprofen)"
    },
    {
      "code" : "A024057100",
      "display" : "VICOUCHIN TABLETS \"C.T.\""
    },
    {
      "code" : "A024062100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"K.T.\""
    },
    {
      "code" : "A024063100",
      "display" : "FENOTEROL HBR TABLETS \"S.C.\""
    },
    {
      "code" : "A024071500",
      "display" : "GLYDGICON VAGINAL SUPPO-SITORIES \"N.C.P.\" (ECONAZOLE)"
    },
    {
      "code" : "A024073212",
      "display" : "CIMEDIN INJECTION (CIMETIDINE) \"S.T.\""
    },
    {
      "code" : "A024076100",
      "display" : "PRANOL F.C. TABLETS (PROPRANOLOL)"
    },
    {
      "code" : "A024077100",
      "display" : "CIMEWET TABLETS (CIMETIDINE) \"N.C.P.\""
    },
    {
      "code" : "A024078100",
      "display" : "PRIDINOL TABLETS \"P.L.\""
    },
    {
      "code" : "A024079100",
      "display" : "BOWCON TABLETS"
    },
    {
      "code" : "A024081100",
      "display" : "LYSOZYME TABLETS 30MG \"T.L.\""
    },
    {
      "code" : "A024085100",
      "display" : "WEIBAMYCIN CAPSULES  \"Tai Yu\" (DOXYCYCLINE)"
    },
    {
      "code" : "A024090100",
      "display" : "SOLANTAL FILM COATED TABLETS 50MG (TIARAMIDE)"
    },
    {
      "code" : "A024091100",
      "display" : "SOLANTAL FILM COATED TABLETS 100MG (TIARAMIDE"
    },
    {
      "code" : "A024098100",
      "display" : "BISPLEN TABLETS \"Y.C.\""
    },
    {
      "code" : "A024099100",
      "display" : "LINCOCIN CAPSULES 500MG (LINCOMYCIN HCL)"
    },
    {
      "code" : "A024103100",
      "display" : "TONTARIN F.C. TABLETS (DICLOFENAC)"
    },
    {
      "code" : "A024104100",
      "display" : "HERSUN TABLETS 40MG (PROPRANOLOL HYDROCHLORIDE)\"F.Y.\""
    },
    {
      "code" : "A024107212",
      "display" : "KOMETIN INJECTION (SULPIRIDE) \"N.K.\""
    },
    {
      "code" : "A024113209",
      "display" : "DEXTROSE AND SODIUM CHLORIDE INJECTION 5％/0.9％ \"Y.F.\""
    },
    {
      "code" : "A024113265",
      "display" : "DEXTROSE AND SODIUM CHLORIDE INJECTION 5％/0.9％ \"Y.F.\""
    },
    {
      "code" : "A024113277",
      "display" : "DEXTROSE AND SODIUM CHLORIDE INJECTION 5％/0.9％ \"Y.F.\""
    },
    {
      "code" : "A024114221",
      "display" : "PISANTA INJECTION (PIRACETAM) \"ROYAL\""
    },
    {
      "code" : "A024115100",
      "display" : "DICLOFENAC E.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A024127100",
      "display" : "DICLOFEN TABLETS (DICLOFENAC)"
    },
    {
      "code" : "A024132100",
      "display" : "AMOXICILLIN CAPSULES 500MG"
    },
    {
      "code" : "A0241321G0",
      "display" : "AMOXICILLIN CAPSULES 500MG"
    },
    {
      "code" : "A024135100",
      "display" : "GENYAN S.C. TABLETS (ANETHOLE) \"SHOU CHAN\""
    },
    {
      "code" : "A024142100",
      "display" : "BRENCO TABLETS"
    },
    {
      "code" : "A0241421G0",
      "display" : "BRENCO TABLETS"
    },
    {
      "code" : "A024149100",
      "display" : "METROSONE TABLETS (TRIAMCINOLONE) \"HETRO\""
    },
    {
      "code" : "A024154100",
      "display" : "SULIN TABLETS 5MG (DIAZEPAM) \"M.T.\""
    },
    {
      "code" : "A024155100",
      "display" : "CHLOPHEDIANOL HCL TABLETS \"S.C.\""
    },
    {
      "code" : "A024159100",
      "display" : "YANLI CAPSULES \"TW\""
    },
    {
      "code" : "A024165421",
      "display" : "DEXASON EYE SOLUTION \"SHITEH\""
    },
    {
      "code" : "A024175100",
      "display" : "REAZONE TABLETS \"Y.C.\""
    },
    {
      "code" : "A024182100",
      "display" : "ROXSON TABLETS \"Y.Y\" (PRIDINOL)"
    },
    {
      "code" : "A024183277",
      "display" : "CEPHAZOLIN INJECTION 0.5GM \"CHIPHAR\""
    },
    {
      "code" : "A024185100",
      "display" : "AMOXICILLIN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A024187100",
      "display" : "TRENTAL DRAGEE 100MG (PENTOXIFYLLINE)"
    },
    {
      "code" : "A024192221",
      "display" : "REPACIN LYO-INJECTION (BETA-AESCIN)"
    },
    {
      "code" : "A024193100",
      "display" : "METOBRIUM CAPSULES (CHLORDIAZEPOXIDE HYDROCHLORIDE) \"MOTRO\""
    },
    {
      "code" : "A024195100",
      "display" : "ULOPINE TABLETS (PIRENZEPINE DIHYDROCHLORIDE) \"PANHIOTIC\""
    },
    {
      "code" : "A024196100",
      "display" : "PIPEMID TABLETS 250mg \"Y.C.\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A024197100",
      "display" : "DICLOFENAC E.F.C. TABLETS 25MG \"CHINTENG\""
    },
    {
      "code" : "A0241971G0",
      "display" : "DICLOFENAC E.F.C. TABLETS 25MG \"CHINTENG\""
    },
    {
      "code" : "A024198212",
      "display" : "AMIKACIN INJECTION 125MG/ML \"N.K.\""
    },
    {
      "code" : "A024198229",
      "display" : "AMIKACIN INJECTION 125MG/ML \"N.K.\""
    },
    {
      "code" : "A024198299",
      "display" : "AMIKACIN INJECTION 125MG/ML \"N.K.\""
    },
    {
      "code" : "A024199100",
      "display" : "NAROXIN TABLETS 250mg \"H.L.\""
    },
    {
      "code" : "A024203216",
      "display" : "ACETYLCYSTEINE INJECTION 100MG/ML \"LITA\""
    },
    {
      "code" : "A024208100",
      "display" : "MEDACON S.C. TABLETS 250MG (METRONIDAZOLE)"
    },
    {
      "code" : "A024211100",
      "display" : "DEXAMETHASONE TABLETS 0.5MG \"KODAK\""
    },
    {
      "code" : "A024212238",
      "display" : "SODIUM CHLORIDE INJECTION 0.45％ \"TBC\""
    },
    {
      "code" : "A024212277",
      "display" : "SODIUM CHLORIDE INJECTION 0.45％ \"TBC\""
    },
    {
      "code" : "A0242122D9",
      "display" : "SODIUM CHLORIDE INJECTION 0.45％ \"TBC\""
    },
    {
      "code" : "A024214335",
      "display" : "SALIPHENO EXTERNAL SOLUTION"
    },
    {
      "code" : "A024216100",
      "display" : "PROWEL S.C. TABLETS 10MG (METOCLOPRAMIDE)"
    },
    {
      "code" : "A024225338",
      "display" : "WHITE CLOUD OINTMENT \"C.H.\" (FLUOCINONIDE)"
    },
    {
      "code" : "A024225377",
      "display" : "WHITE CLOUD OINTMENT \"C.H.\" (FLUOCINONIDE)"
    },
    {
      "code" : "A024225399",
      "display" : "WHITE CLOUD OINTMENT \"C.H.\" (FLUOCINONIDE)"
    },
    {
      "code" : "A024227100",
      "display" : "IBUPROFEN S.C. TABLETS \"C.H.\""
    },
    {
      "code" : "A024229100",
      "display" : "PRIMRAM S.C. TABLETS \"C.H.\" (METOCLOPRAMIDE)"
    },
    {
      "code" : "A024236100",
      "display" : "CARBETAN F.C. TABLETS 30MG \"CHINTENG\""
    },
    {
      "code" : "A024237209",
      "display" : "CEPHALORIDINE INJECTION 1GM \"SINPHAR\""
    },
    {
      "code" : "A024239100",
      "display" : "NEWTASE TABLETS \"CHINTENG\""
    },
    {
      "code" : "A024242100",
      "display" : "METROFEN TABLETS"
    },
    {
      "code" : "A024243209",
      "display" : "CEFAZIN INJECTION 1GM (CEFAZOLIN) \"KINGDOM\""
    },
    {
      "code" : "A024244200",
      "display" : "GENTAMICIN SULFATE INJECTION 60MG/ML \"C.S.P.\""
    },
    {
      "code" : "A024246100",
      "display" : "INOPAO CAPSULES \"C.H.\""
    },
    {
      "code" : "A024247321",
      "display" : "ECOSONE CREAM \"LOTUS\""
    },
    {
      "code" : "A024247377",
      "display" : "ECOSONE CREAM \"LOTUS\""
    },
    {
      "code" : "A024247399",
      "display" : "ECOSONE CREAM \"LOTUS\""
    },
    {
      "code" : "A024250321",
      "display" : "Fubining Cream \"M.D.\""
    },
    {
      "code" : "A024250335",
      "display" : "Fubining Cream \"M.D.\""
    },
    {
      "code" : "A024251100",
      "display" : "LITAZIN CAPSULES (PIPEMIDIC ACID) \"LITA\""
    },
    {
      "code" : "A024256100",
      "display" : "PYRIDOXINE HYDROCHLORIDE TABLETS 25MG \"U.L.\""
    },
    {
      "code" : "A024258277",
      "display" : "Taita No.4 Injection \"Otsuka\""
    },
    {
      "code" : "A024260100",
      "display" : "ELIANINE CAPSULES (SILYMARIN)"
    },
    {
      "code" : "A024261100",
      "display" : "Elikan S.C. TABLETS"
    },
    {
      "code" : "A024265100",
      "display" : "DIALICON TABLETS (GLIBENCLAMIDE) \"C.H.\""
    },
    {
      "code" : "A024266100",
      "display" : "DIYUN TABLETS (DIPHENIDOL) \"S.T.\""
    },
    {
      "code" : "A024269100",
      "display" : "BUSKOBUN S.C. TABLETS \"C.H.\" (HYOSCINE BUTYLBROMIDE)"
    },
    {
      "code" : "A024270100",
      "display" : "PISON CAPSULES \"C.H.\""
    },
    {
      "code" : "A024271100",
      "display" : "ISMEDINE TABLETS \"C.H.\" (GUANETHIDINE SULFATE)"
    },
    {
      "code" : "A024272100",
      "display" : "ERGO-M S.C. TABLETS \"C.H.\"(ERGOMETRINE MALEATE)"
    },
    {
      "code" : "A024277100",
      "display" : "SULYANG CAPSUES 50 mg \"S.D.\" (SULPIRIDE)"
    },
    {
      "code" : "A024279100",
      "display" : "CANTYL TABLETS (MEPENZOLATE) \"TA\""
    },
    {
      "code" : "A024280100",
      "display" : "ANTOXINE TABLETS (DIHYDROERGOTOXINE METHANESULFONATE)"
    },
    {
      "code" : "A024282100",
      "display" : "TREN CAPSULES 250MG (TRANEXAMIC ACID) \"YUNG SHIN\""
    },
    {
      "code" : "A024283212",
      "display" : "CLEOCIN PHOSPHATE INJECTION (CLINDAMYCIN)"
    },
    {
      "code" : "A024291100",
      "display" : "LYSOZYME TABLETS 50MG \"F.S.\""
    },
    {
      "code" : "A024301100",
      "display" : "FIMEPON S.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A024302100",
      "display" : "DIABECON TABLETS (CHLORPROPAMIDE)"
    },
    {
      "code" : "A024304100",
      "display" : "PEGIEN TABLETS \"F.S.\""
    },
    {
      "code" : "A024305100",
      "display" : "ULSPAN CAPSULES (SULPIRIDE)"
    },
    {
      "code" : "A024306100",
      "display" : "CLOFON FILM COATED TABLETS (DICLOFENAC)"
    },
    {
      "code" : "A024309100",
      "display" : "DARAFFIN TABLETETS \"S.C.\""
    },
    {
      "code" : "A024310100",
      "display" : "RESERZIDE S.C. TABLETS"
    },
    {
      "code" : "A0243101G0",
      "display" : "RESERZIDE S.C. TABLETS"
    },
    {
      "code" : "A024313100",
      "display" : "FRUFE CAPSULES (GRISEOFULVIN) \"Y.Y.\""
    },
    {
      "code" : "A024316100",
      "display" : "EASIFON CAPSULES 400MG (IBUPROFEN) \"Y.F.\""
    },
    {
      "code" : "A024317100",
      "display" : "SIMETHICONE TABLETS \"SINPHAR\""
    },
    {
      "code" : "A024318100",
      "display" : "LORAZEPAM TABLETS 2MG \"LITA\""
    },
    {
      "code" : "A024319221",
      "display" : "TREN INJECTION 100MG (TRANEXAMIC ACID) \"YUNG SHIN\""
    },
    {
      "code" : "A024320100",
      "display" : "CLEOCIN HCL CAPSULES 150MG (CLINDAMYCIN HCL HYDRATE)"
    },
    {
      "code" : "A024329100",
      "display" : "LIROCAM CAPSULE (PIROXICAM) \"LITA\""
    },
    {
      "code" : "A024330100",
      "display" : "PIROCAM CAPSULES \"J.L.\""
    },
    {
      "code" : "A024335100",
      "display" : "SALBUTAMO TABLETS 4MG (SALBUTAMOL)"
    },
    {
      "code" : "A024336100",
      "display" : "AMITRIPTYLINE HYDROCHLORIDE S.C. TABLLETS \"C.H.\""
    },
    {
      "code" : "A024338321",
      "display" : "TRISONE CREAM"
    },
    {
      "code" : "A024338329",
      "display" : "TRISONE CREAM"
    },
    {
      "code" : "A024338335",
      "display" : "TRISONE CREAM"
    },
    {
      "code" : "A024338372",
      "display" : "TRISONE CREAM"
    },
    {
      "code" : "A024338399",
      "display" : "TRISONE CREAM"
    },
    {
      "code" : "A024350100",
      "display" : "RELCON CAPSULES 250MG \"YUNG CHI\""
    },
    {
      "code" : "A024356100",
      "display" : "CORODIL S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A024359118",
      "display" : "ANPIMINE ELIXIR"
    },
    {
      "code" : "A024359199",
      "display" : "ANPIMINE ELIXIR"
    },
    {
      "code" : "A024362100",
      "display" : "BI AUI AN LINN TABLETS \"NCP\""
    },
    {
      "code" : "A024366100",
      "display" : "SYNOPHY TABLETS \"C.H.\""
    },
    {
      "code" : "A024369100",
      "display" : "FELVITEN S.C. TABLETS \"C.H.\" (ANETHOLE)"
    },
    {
      "code" : "A024372100",
      "display" : "DEXAMETHASONE TABLETS 0.5MG (DEXAMETHASONE) \"L.S.\""
    },
    {
      "code" : "A024373100",
      "display" : "INDOTHIN CAPSULES (INDOMETHACIN)"
    },
    {
      "code" : "A024374100",
      "display" : "THIAMPHENICOL CAPSULES 250MG \"C.L.\""
    },
    {
      "code" : "A024375100",
      "display" : "GRISEOFULVIN TABLETS 250MG"
    },
    {
      "code" : "A024376100",
      "display" : "AENOMI TABLETS \"Y.Y.\""
    },
    {
      "code" : "A024379100",
      "display" : "CONFULIN-H TABLETS \"K.B.\""
    },
    {
      "code" : "A024381229",
      "display" : "LINCOCIN INJECTION 300MG/ML (LINCOMYCIN HYDROCHLORIDE)"
    },
    {
      "code" : "A024381299",
      "display" : "LINCOCIN INJECTION 300MG/ML (LINCOMYCIN HYDROCHLORIDE)"
    },
    {
      "code" : "A024384100",
      "display" : "LORAZEPAM TABLETS 1MG"
    },
    {
      "code" : "A0243841G0",
      "display" : "LORAZEPAM TABLETS 1MG"
    },
    {
      "code" : "A024385100",
      "display" : "LOPERAMIDE CAPSULES"
    },
    {
      "code" : "A024387100",
      "display" : "DECAS S.C. TABLETS (LEVAMISOLE) \"SHOU CHAN\""
    },
    {
      "code" : "A024388100",
      "display" : "HALCION TABLETS 0.25MG (TRIAZOLAM)"
    },
    {
      "code" : "A024390100",
      "display" : "CHLORAMPHENICAL CAPSULES \"K.T.\""
    },
    {
      "code" : "A024395100",
      "display" : "VANINE TABLETS (DIAZEPAM) \"METRO\""
    },
    {
      "code" : "A024398100",
      "display" : "ANAPROX TABLETS (NAPROXEN SODIUM)"
    },
    {
      "code" : "A024431100",
      "display" : "PAOWEIAN TABLETS 200mg \"C.H.\""
    },
    {
      "code" : "A024433100",
      "display" : "FUBININ TABLETS"
    },
    {
      "code" : "A024437238",
      "display" : "SODIUM CHLORIDE INJECTION 10％ \"S.T.\""
    },
    {
      "code" : "A024440100",
      "display" : "IKODIN CAPSULES 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A024441100",
      "display" : "CODEM CAPSULES \"C.H.\""
    },
    {
      "code" : "A024443100",
      "display" : "ANCOUGLIN TABLETS"
    },
    {
      "code" : "A024451155",
      "display" : "WEISUN GRANULES"
    },
    {
      "code" : "A024451180",
      "display" : "WEISUN GRANULES"
    },
    {
      "code" : "A024456100",
      "display" : "MEDONIN CAPSULES 10MG \"CHEN TA\" (SEAPROSE S)"
    },
    {
      "code" : "A024463100",
      "display" : "ANXIEDIN TABLETS 0.5MG (LORAZEPAM)"
    },
    {
      "code" : "A0244631G0",
      "display" : "ANXIEDIN TABLETS 0.5MG (LORAZEPAM)"
    },
    {
      "code" : "A024464100",
      "display" : "SUGIN CAPSULES \"Y.S.\""
    },
    {
      "code" : "A024465100",
      "display" : "ASPIRIN F.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A024466100",
      "display" : "RIBOFLAVIN TABLETS 10MG"
    },
    {
      "code" : "A024469119",
      "display" : "CLEOCIN PALMITATE GRANULES 37.5MG/GM (CLINDAMYCIN)"
    },
    {
      "code" : "A024474100",
      "display" : "LIDIN TABLETS 300MG (LITHIUM CARBONATE)"
    },
    {
      "code" : "A024477100",
      "display" : "ANETHONE CAPSULES 25MG (ANETHOLE) \"HONG YA\""
    },
    {
      "code" : "A024483100",
      "display" : "NEPHRIN TABLETS"
    },
    {
      "code" : "A024486100",
      "display" : "DEAMINE CAPSULES \"N.C.P\""
    },
    {
      "code" : "A024487100",
      "display" : "TARGIN TABLETS 500MG (TINIDAZOLE)\"YU SHENG\""
    },
    {
      "code" : "A024488100",
      "display" : "PROAZINE TABLETS (PROCHLORPERAZINE MALEATE)"
    },
    {
      "code" : "A024490100",
      "display" : "PIPERAN CAPSULES\"YU SHENG\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A024493100",
      "display" : "TEANLANG TABLETS 0.75MG"
    },
    {
      "code" : "A024494100",
      "display" : "LISOME TABLETS 30MG (LYSOZYME) \"HONTEN\""
    },
    {
      "code" : "A024509100",
      "display" : "FLURAZINE F.C. TABLETS 5MG (TRIFLUOPERAZINE) \"VPP\""
    },
    {
      "code" : "A024514100",
      "display" : "CONICA CAPSULES 400MG"
    },
    {
      "code" : "A024515100",
      "display" : "TANPHYLATE TABLETS \"S.T.\""
    },
    {
      "code" : "A024516209",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516210",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516212",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516216",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516238",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516248",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516255",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516265",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516277",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024516309",
      "display" : "SODIUM CHLORIDE INJECTION 0.9％ \"TAI YU\""
    },
    {
      "code" : "A024519343",
      "display" : "Sinpharderm A.D.E. CREAM"
    },
    {
      "code" : "A024519377",
      "display" : "Sinpharderm A.D.E. CREAM"
    },
    {
      "code" : "A024519399",
      "display" : "Sinpharderm A.D.E. CREAM"
    },
    {
      "code" : "A024521343",
      "display" : "ANESIN OINTMENT 1％ (DIBUCAINE)"
    },
    {
      "code" : "A024523100",
      "display" : "COLDTEX TABLETS"
    },
    {
      "code" : "A024532100",
      "display" : "LYSOZYME TABLETS 30MG"
    },
    {
      "code" : "A024536100",
      "display" : "PROPRANOLOL HYDROCHLORIDE  TABLETS \"C.H.\""
    },
    {
      "code" : "A024557277",
      "display" : "XYTAMIN INJECTION \"S.Y.\""
    },
    {
      "code" : "A024571321",
      "display" : "EPARCORT CREAM"
    },
    {
      "code" : "A024571329",
      "display" : "EPARCORT CREAM"
    },
    {
      "code" : "A024571338",
      "display" : "EPARCORT CREAM"
    },
    {
      "code" : "A024571355",
      "display" : "EPARCORT CREAM"
    },
    {
      "code" : "A024571372",
      "display" : "EPARCORT CREAM"
    },
    {
      "code" : "A024572100",
      "display" : "GUSERVIN TABLETS 500MG \"UNION\""
    },
    {
      "code" : "A024588100",
      "display" : "SALUPEN TABLETS \"Y.K.\""
    },
    {
      "code" : "A024592100",
      "display" : "SULMIN TABLETS"
    },
    {
      "code" : "A024593277",
      "display" : "DEXTROSAN INJECTION"
    },
    {
      "code" : "A024594212",
      "display" : "HEPADOCK INJECTION"
    },
    {
      "code" : "A024596209",
      "display" : "ALLERCON INJECTION"
    },
    {
      "code" : "A024597100",
      "display" : "ALLERCON TABLETS"
    },
    {
      "code" : "A024598100",
      "display" : "SIULON TABLETS"
    },
    {
      "code" : "A024599100",
      "display" : "ANTI TABLETS"
    },
    {
      "code" : "A024601100",
      "display" : "KOMIAN TABLETS"
    },
    {
      "code" : "A024602100",
      "display" : "LIFONLO CAPSULES\"H.S.\""
    },
    {
      "code" : "A024609100",
      "display" : "AMIPHEN TABLETS 500MG (Acetaminophen) \"SPC\""
    },
    {
      "code" : "A024610321",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024610329",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024610335",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024610338",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024610372",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024610399",
      "display" : "ECONIN CREAM"
    },
    {
      "code" : "A024611100",
      "display" : "ANCOMINE S.C.TABLETS 1MG \"N.C.P.\" (HYDROXOCOBALAMINE)"
    },
    {
      "code" : "A024612100",
      "display" : "E-AND S.C TABLETS 100MG (DL-ALPHA-TOCOPHERYL ACETATE)\"AND\""
    },
    {
      "code" : "A024613129",
      "display" : "OXEIN SUSPESION \"ROYAL\""
    },
    {
      "code" : "A024615100",
      "display" : "PICOL F.C. TABLETS (PIPEMIDIC ACID) \"ROYAL\""
    },
    {
      "code" : "A024616100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"ASTAR\""
    },
    {
      "code" : "A024619212",
      "display" : "AMIKACIN SULFATE INJECTION 250MG \"Y.Y.\""
    },
    {
      "code" : "A024620212",
      "display" : "MULTIVITA INJECTION"
    },
    {
      "code" : "A024620221",
      "display" : "MULTIVITA INJECTION"
    },
    {
      "code" : "A024621100",
      "display" : "POLYTAB FC TABLETS \"VPP\""
    },
    {
      "code" : "A024622100",
      "display" : "ACETAMINOPHEN TABLETS 325MG \"C.T.\""
    },
    {
      "code" : "A024623100",
      "display" : "ACETAMINOPHEN TABLETS 325MG \"ASTAR\""
    },
    {
      "code" : "A024625100",
      "display" : "CODANIN TABLETS \"AND\""
    },
    {
      "code" : "A024644100",
      "display" : "WUNTON  TABLETS\"W.P.\""
    },
    {
      "code" : "A024652100",
      "display" : "PROX TABLETS \"W.P.\" (NAPROXEN)"
    },
    {
      "code" : "A024660212",
      "display" : "PAPASTIN INJECTION"
    },
    {
      "code" : "A024663100",
      "display" : "YOCARO TABLETS"
    },
    {
      "code" : "A024667265",
      "display" : "RINGER INJECTION"
    },
    {
      "code" : "A024667277",
      "display" : "RINGER INJECTION"
    },
    {
      "code" : "A024673265",
      "display" : "RINGER INJECTION \"S.Y.\""
    },
    {
      "code" : "A024673277",
      "display" : "RINGER INJECTION \"S.Y.\""
    },
    {
      "code" : "A024674209",
      "display" : "ERGOCIN INJECTION"
    },
    {
      "code" : "A024675221",
      "display" : "GALLUCAN INJECTION"
    },
    {
      "code" : "A024678100",
      "display" : "GALLUCON TABLETS"
    },
    {
      "code" : "A024679100",
      "display" : "ATRO TABLETS"
    },
    {
      "code" : "A024691100",
      "display" : "AMPICILLIN CAPSULES 250MG \"K.T.\""
    },
    {
      "code" : "A024692100",
      "display" : "AN SUN TON CAPSULES 250MG (MEFENAMIC ACID) \"K.T\""
    },
    {
      "code" : "A024695100",
      "display" : "FUDELLINE TABLETS"
    },
    {
      "code" : "A024696216",
      "display" : "DICLOFENAC INJECTION 25MG \"TAI YU\""
    },
    {
      "code" : "A024703100",
      "display" : "SULPI CAPSULES 50MG (SULPIRIDE) \"WINSTON\""
    },
    {
      "code" : "A0247031G0",
      "display" : "SULPI CAPSULES 50MG (SULPIRIDE) \"WINSTON\""
    },
    {
      "code" : "A024706100",
      "display" : "SUPIAN TABLETS \"F.B\""
    },
    {
      "code" : "A0247061G0",
      "display" : "SUPIAN TABLETS \"F.B\""
    },
    {
      "code" : "A024708100",
      "display" : "SORIN TABLETS 200MG (CHLORZOXAZONE) \"YUNG SHIN\""
    },
    {
      "code" : "A024710100",
      "display" : "CIMETIDINE TABLETS 200MG \"SOURIREE\""
    },
    {
      "code" : "A0247101G0",
      "display" : "CIMETIDINE TABLETS 200MG \"SOURIREE\""
    },
    {
      "code" : "A024714100",
      "display" : "BIODASE TABLETS \"H.S.\""
    },
    {
      "code" : "A024718100",
      "display" : "HEPAGEN S.C. TABLETS \"JOHNSON\""
    },
    {
      "code" : "A024722212",
      "display" : "GRIPCIDINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A024726100",
      "display" : "PARAS TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A024729212",
      "display" : "GASZEPIN INJECTION (PIRENZEPINE 2HCL)"
    },
    {
      "code" : "A024730500",
      "display" : "FUCODINE VAGINAL TABLETS 100MG \"Y.K.\""
    },
    {
      "code" : "A024735100",
      "display" : "SUCANON CAPSULES 25MG \"L.S.\"(ANETHOLE)"
    },
    {
      "code" : "A024736100",
      "display" : "GASOLE TABLETS 25MG (PIRENZEPINE DIHYDROCHLORIDE) \"SHIN FONG\""
    },
    {
      "code" : "A024738212",
      "display" : "DICYCLOMINE INJECTION 10MG/ML \"SINTON\""
    },
    {
      "code" : "A024740100",
      "display" : "LYSOZYME TABLETS 100MG \"M.T.\""
    },
    {
      "code" : "A024741229",
      "display" : "LINCOMYCIN INJECTION 300MG \"KINGDOM\""
    },
    {
      "code" : "A024742100",
      "display" : "MILISHER TABLETS 100MG \"H.S.\" (LYSOZYME)"
    },
    {
      "code" : "A024746100",
      "display" : "RIFA CAPSULES 150MG (RIFAMPICIN)"
    },
    {
      "code" : "A024749100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"ORIENTAL\""
    },
    {
      "code" : "A024750212",
      "display" : "CIMETIDINE INJECTION 100MG \"ORIENTAL\""
    },
    {
      "code" : "A024751221",
      "display" : "POTASSIUM CHLORIDE INJECTION 15％ \"SYNMOSA\""
    },
    {
      "code" : "A024752321",
      "display" : "TOSEN OINTMENT \"M.S.\""
    },
    {
      "code" : "A024752372",
      "display" : "TOSEN OINTMENT \"M.S.\""
    },
    {
      "code" : "A024752399",
      "display" : "TOSEN OINTMENT \"M.S.\""
    },
    {
      "code" : "A024754100",
      "display" : "ZECOLIN TABLETS 250MG"
    },
    {
      "code" : "A024756277",
      "display" : "DEXTROSE INJECTION 10％ \"TAI YU\""
    },
    {
      "code" : "A024757100",
      "display" : "Suitone F.C. Tablets 500mg \"Y.K.\""
    },
    {
      "code" : "A024758100",
      "display" : "Lysozyme Tablets 90 mg \"SPC\""
    },
    {
      "code" : "A024765100",
      "display" : "LYSOZYME TABLETS 30MG"
    },
    {
      "code" : "A024766100",
      "display" : "HETEL CAPSULES (CLOMIPHENE)\"M.T.\""
    },
    {
      "code" : "A024769100",
      "display" : "COTINE SUGAR COATED TABLETS \"TK&A\""
    },
    {
      "code" : "A024772212",
      "display" : "ORISANTIN INJECTION 5MG/ML (DIPYRIDAMOLE) \"ORIENTAL\""
    },
    {
      "code" : "A024789100",
      "display" : "ERYMYCIN CAPSULES 250MG"
    },
    {
      "code" : "A0247891G0",
      "display" : "ERYMYCIN CAPSULES 250MG"
    },
    {
      "code" : "A024790100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"LIN CHEMICAL\""
    },
    {
      "code" : "A024807100",
      "display" : "SALBUTAMOL TABLETS 4MG \"Y.S.\""
    },
    {
      "code" : "A024810100",
      "display" : "WEIZAIN TABLETS \"HONTEN\""
    },
    {
      "code" : "A024814118",
      "display" : "GE TONG SOLUTION 24MG/ML (ACETAMINOPHEN) \"HONG YA\""
    },
    {
      "code" : "A024817100",
      "display" : "BROTHINE TABLETS 2.5MG (TERBUTALINE SULFATE)"
    },
    {
      "code" : "A024832100",
      "display" : "HYPOLAX TABLETS 0.1MG (CLONIDINE) \"JINUP\""
    },
    {
      "code" : "A024833100",
      "display" : "FLURAZINE S.C. TABLETS 2MG (TRIFLUOPERAZINE) \"VPP\""
    },
    {
      "code" : "A024834100",
      "display" : "MECOTAN TABLETS 100MG (L-METHYLCYSTEINE) \"N.W\""
    },
    {
      "code" : "A024837100",
      "display" : "TONIFEN F.C. TABLETS 500MG (MEFENAMIC ACID) \" ROYAL \""
    },
    {
      "code" : "A0248371G0",
      "display" : "TONIFEN F.C. TABLETS 500MG (MEFENAMIC ACID) \" ROYAL \""
    },
    {
      "code" : "A024838100",
      "display" : "RIFAMPICIN CAPSULES"
    },
    {
      "code" : "A024840209",
      "display" : "CEMANDOLE INJECTION (CEFAMANDOLE)"
    },
    {
      "code" : "A024840277",
      "display" : "CEMANDOLE INJECTION (CEFAMANDOLE)"
    },
    {
      "code" : "A024841100",
      "display" : "CLOMIPHENE CAPSULES 50MG \"Y.C.\""
    },
    {
      "code" : "A024842100",
      "display" : "ANTICOLD CAPAULES"
    },
    {
      "code" : "A024843100",
      "display" : "CHIMIN TABLETS 0.5MG \"Y.C.\"(BETAMETHASONE)"
    },
    {
      "code" : "A024845100",
      "display" : "AZUMON S.C. TABLETS 1.25MG \"CHEN TA\" (CONJUGATED ESTROGENS)"
    },
    {
      "code" : "A024854100",
      "display" : "COTRANLIN CAPSULES \"F.S.\""
    },
    {
      "code" : "A024856100",
      "display" : "CEFLEXIN CAPSULES 250MG (CEPHALEXIN) \"VPP\""
    },
    {
      "code" : "A024857118",
      "display" : "ORNADIN SOLUTION"
    },
    {
      "code" : "A024857199",
      "display" : "ORNADIN SOLUTION"
    },
    {
      "code" : "A024862100",
      "display" : "Olimin S.C. Tablets \"C.H.\""
    },
    {
      "code" : "A024864500",
      "display" : "TINTEN SUPPOSITORIES 125MG"
    },
    {
      "code" : "A024866100",
      "display" : "Hytergen Tablets 1.5mg \"Y.C.\""
    },
    {
      "code" : "A024867100",
      "display" : "RISCO TABLETS \"Y.S.\" (EPRAZINONE)"
    },
    {
      "code" : "A024870238",
      "display" : "SULOKERON INJECTION"
    },
    {
      "code" : "A024873100",
      "display" : "UROPINE S.C. TABLETS \"MEIDER\""
    },
    {
      "code" : "A024877100",
      "display" : "STANOZOLOL TABLETS 2MG \"C.H.\""
    },
    {
      "code" : "A024878321",
      "display" : "PERICON CREAM \"F.B\""
    },
    {
      "code" : "A024878335",
      "display" : "PERICON CREAM \"F.B\""
    },
    {
      "code" : "A024878377",
      "display" : "PERICON CREAM \"F.B\""
    },
    {
      "code" : "A024878399",
      "display" : "PERICON CREAM \"F.B\""
    },
    {
      "code" : "A024881100",
      "display" : "KIDNIN CAPSULES 250MG (PIPEMIDIC ACID) \"WINSTON\""
    },
    {
      "code" : "A024883212",
      "display" : "DICOLOFENAC INJECTION 25MG/ML \"H.S.\""
    },
    {
      "code" : "A024883216",
      "display" : "DICOLOFENAC INJECTION 25MG/ML \"H.S.\""
    },
    {
      "code" : "A024885100",
      "display" : "ANXIEDIN TABLETS 1MG (LORAZEPAM)"
    },
    {
      "code" : "A0248851G0",
      "display" : "ANXIEDIN TABLETS 1MG (LORAZEPAM)"
    },
    {
      "code" : "A024888100",
      "display" : "CEFLEXIN CAPSULES 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A024889151",
      "display" : "CASTEINE SYRUP"
    },
    {
      "code" : "A024894100",
      "display" : "E-BUTOL F.C. TABLETS 400MG"
    },
    {
      "code" : "A024913100",
      "display" : "DRAMAMINE TABLETS 50MG"
    },
    {
      "code" : "A024916277",
      "display" : "HESTA INJECTION \"N.K.\""
    },
    {
      "code" : "A024921100",
      "display" : "LEPOTIN TABLETS 1MG \"WELCAN\" (CLEMASTINE)"
    },
    {
      "code" : "A024922265",
      "display" : "AMPICLOXACIN FOR INJECTION"
    },
    {
      "code" : "A024922277",
      "display" : "AMPICLOXACIN FOR INJECTION"
    },
    {
      "code" : "A024924216",
      "display" : "DICLOFENAC SODIUM INJECTION 25MG/ML \"S.Y.\""
    },
    {
      "code" : "A024932100",
      "display" : "FLOMINE S.C. TABLETS \"C.R.\""
    },
    {
      "code" : "A024935100",
      "display" : "SUWEILIN TABLETS 200MG \"SINTON\""
    },
    {
      "code" : "A024936100",
      "display" : "ERGODAN F.C. TABLETS"
    },
    {
      "code" : "A024937100",
      "display" : "ENBRAIN TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A024942209",
      "display" : "SALTOLIN INJECTION (SALBUTAMOL) \"GENTLE\""
    },
    {
      "code" : "A024943100",
      "display" : "LORAPAM TABLETS 1MG"
    },
    {
      "code" : "A024944100",
      "display" : "SPIRZIDE TABLETS"
    },
    {
      "code" : "A024946100",
      "display" : "LEVASOL TABLETS 50MG \"SHIN FONG\""
    },
    {
      "code" : "A024952209",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"Y.Y.\""
    },
    {
      "code" : "A024952229",
      "display" : "DEXAMETHASONE INJECTION 4MG/ML \"Y.Y.\""
    },
    {
      "code" : "A024953209",
      "display" : "PROGESTERONE INJECTION 25MG \"Y.Y.\""
    },
    {
      "code" : "A024953212",
      "display" : "PROGESTERONE INJECTION 25MG \"Y.Y.\""
    },
    {
      "code" : "A024953229",
      "display" : "PROGESTERONE INJECTION 25MG \"Y.Y.\""
    },
    {
      "code" : "A024954277",
      "display" : "CEFAMANDOLE INJECTION 500MG \"PRINCE\""
    },
    {
      "code" : "A024957100",
      "display" : "ISCAN F.C. TABLETS 200MG (CIMETIDINE) \"SPC\""
    },
    {
      "code" : "A024958100",
      "display" : "MINLICK TABLETS (CLEMASTINE) \"SPC\""
    },
    {
      "code" : "A024961212",
      "display" : "T.T.Y. COLIMYCIN INJECTION 2000000 U (COLISTIN METHANESULFONATE)"
    },
    {
      "code" : "A024963209",
      "display" : "SINCLOCILLIN INJECTION 1GM \"SINPHAR\""
    },
    {
      "code" : "A024964100",
      "display" : "MORCASIN TABLETS \"SINPHAR\""
    },
    {
      "code" : "A0249641G0",
      "display" : "MORCASIN TABLETS \"SINPHAR\""
    },
    {
      "code" : "A024974100",
      "display" : "MERIS S.C. TABLETS \"C.H.\""
    },
    {
      "code" : "A024981100",
      "display" : "ANPOLIN S.C. TABLETS 25MG (HYDRALAZINE)"
    },
    {
      "code" : "A024982100",
      "display" : "JUWEILON TABLETS \"M.T.\""
    },
    {
      "code" : "A024986209",
      "display" : "GLYCEROL INJECTION \"N.K.\""
    },
    {
      "code" : "A024986265",
      "display" : "GLYCEROL INJECTION \"N.K.\""
    },
    {
      "code" : "A024986266",
      "display" : "GLYCEROL INJECTION \"N.K.\""
    },
    {
      "code" : "A024986277",
      "display" : "GLYCEROL INJECTION \"N.K.\""
    },
    {
      "code" : "A024987100",
      "display" : "Cendmycin  Capsules  500mg (Cefadroxil)"
    },
    {
      "code" : "A024990209",
      "display" : "TBC NO.8B INJECTION"
    },
    {
      "code" : "A024990271",
      "display" : "TBC NO.8B INJECTION"
    },
    {
      "code" : "A024991100",
      "display" : "DIPHENIDOL S.C. TABLETS 25MG \"C.H.\""
    },
    {
      "code" : "A024992100",
      "display" : "DICLOFENAC TABLETS"
    },
    {
      "code" : "A024993321",
      "display" : "CAN-PEI-LEEN CREAM 0.5MG"
    },
    {
      "code" : "A024993372",
      "display" : "CAN-PEI-LEEN CREAM 0.5MG"
    },
    {
      "code" : "A024993399",
      "display" : "CAN-PEI-LEEN CREAM 0.5MG"
    },
    {
      "code" : "A024995100",
      "display" : "TACRETON TABLETS 200MG \"H.L.\""
    },
    {
      "code" : "A025002321",
      "display" : "EPICORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A025002329",
      "display" : "EPICORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A025002372",
      "display" : "EPICORT CREAM \"VEIMIN\""
    },
    {
      "code" : "A025015238",
      "display" : "SANVITA INJECTION \"ASTAR\""
    },
    {
      "code" : "A025017100",
      "display" : "YULANTYL TABLETS \"TAI YU\""
    },
    {
      "code" : "A025018100",
      "display" : "FELDENE CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A025020100",
      "display" : "ERYSTAC CAPSULES 250MG (ERYTHROMYCIN STEARATE)"
    },
    {
      "code" : "A025022100",
      "display" : "KERSUTON TABLETS 100MG (CHLORMEZANONE)"
    },
    {
      "code" : "A025025100",
      "display" : "NYSTATIN TABLETS 500000 units \"Y.C.\""
    },
    {
      "code" : "A025027100",
      "display" : "DEXCHLORPHENIRAMINE MALEATE TABLETS 2MG \"Y.K.\""
    },
    {
      "code" : "A025028100",
      "display" : "TRIROGIN TABLETS 1.5MG (DIHYDROERGOTOXINE)"
    },
    {
      "code" : "A025031100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"SINTON\""
    },
    {
      "code" : "A025034118",
      "display" : "KAOPECTIN SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A025034199",
      "display" : "KAOPECTIN SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A025039109",
      "display" : "BIODASE POWDER \"H.S.\""
    },
    {
      "code" : "A025039199",
      "display" : "BIODASE POWDER \"H.S.\""
    },
    {
      "code" : "A025054100",
      "display" : "TENOBEC TABLETS 5MG (FENOTEROL) \"PANBIOTIC\""
    },
    {
      "code" : "A025055100",
      "display" : "ANLITON TABLETS \"F.S.\""
    },
    {
      "code" : "A025057100",
      "display" : "KANSAMIN CAPSULES 250MG (TRANEXAMIC ACID) \"SINTON\""
    },
    {
      "code" : "A025058100",
      "display" : "VANCONIN TABLETS 2MG (DIAZEPAM) \"VPP\""
    },
    {
      "code" : "A0250581G0",
      "display" : "VANCONIN TABLETS 2MG (DIAZEPAM) \"VPP\""
    },
    {
      "code" : "A025060221",
      "display" : "KANSAMIN INJECTION 100MG/ML (ERANEXAMIC ACID)\"SINTON\""
    },
    {
      "code" : "A025061100",
      "display" : "MEPENATE TABLETS 25MG"
    },
    {
      "code" : "A025070100",
      "display" : "MORI CAPSUELS 2MG (LOPERAMIDE) \"W.P.\""
    },
    {
      "code" : "A025077100",
      "display" : "UNIVITA S.C. TABLETS"
    },
    {
      "code" : "A025079100",
      "display" : "COMBICILLIN CAPSULES \"C.R.\""
    },
    {
      "code" : "A025081100",
      "display" : "RECOUGH TABLETS 20MG \"S.C.\" (EPRAZINONE)"
    },
    {
      "code" : "A025083100",
      "display" : "UCEFA CAPSULES 500MG (CEFADROXIL)"
    },
    {
      "code" : "A025086100",
      "display" : "GAIN-VITA S.C. TABLETS"
    },
    {
      "code" : "A025089100",
      "display" : "VITACOMB S.C. TABLETS"
    },
    {
      "code" : "A025091100",
      "display" : "MAGOCAIN TABLETS"
    },
    {
      "code" : "A025095100",
      "display" : "Wintidine Tablets 200mg"
    },
    {
      "code" : "A025096100",
      "display" : "DIAZEPAM TABLETS 2MG"
    },
    {
      "code" : "A025104266",
      "display" : "FRUCERINTONE INTECTION \"TAI YU\""
    },
    {
      "code" : "A025104277",
      "display" : "FRUCERINTONE INTECTION \"TAI YU\""
    },
    {
      "code" : "A025108100",
      "display" : "NOSCAPINE TABLETS \"UNION\""
    },
    {
      "code" : "A025110100",
      "display" : "DEXTROLAMINE CAPSULES \"S.C.\""
    },
    {
      "code" : "A025118100",
      "display" : "NEUROPAM TABLETS 2MG (LORAZEPAM) \"PANBIOTIC\""
    },
    {
      "code" : "A0251181G0",
      "display" : "NEUROPAM TABLETS 2MG (LORAZEPAM) \"PANBIOTIC\""
    },
    {
      "code" : "A025121100",
      "display" : "BISCO TABLETS 12MG (BROMHEXINE)"
    },
    {
      "code" : "A025123100",
      "display" : "TRANEXAMIC CAPSULES 250MG \"JINUP\""
    },
    {
      "code" : "A025124100",
      "display" : "ZINC TABLETS 15MG \"GCPC\""
    },
    {
      "code" : "A025125209",
      "display" : "CEFAMANDOLE FOR INJECTION 1GM"
    },
    {
      "code" : "A025128417",
      "display" : "GENTAMYCIN OPHTH. OINTMENT 3MG/GM \"GCPC\""
    },
    {
      "code" : "A025128421",
      "display" : "GENTAMYCIN OPHTH. OINTMENT 3MG/GM \"GCPC\""
    },
    {
      "code" : "A025129100",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"GCPC\""
    },
    {
      "code" : "A025130100",
      "display" : "NOFLAGMA CAPSULES 50MG (LYSOZYME) \"YUNG SHIN\""
    },
    {
      "code" : "A025131100",
      "display" : "AZEPIN TABLETS 2MG (DIAZEPAM) \"S.H.\""
    },
    {
      "code" : "A025132209",
      "display" : "DESTANE INJECTION \"PANBIOTIC\""
    },
    {
      "code" : "A025136321",
      "display" : "MYCOSTEN CREAM 10MG/GM \"SINPHAR\"(CLOTRIMAZOLE)"
    },
    {
      "code" : "A025136329",
      "display" : "MYCOSTEN CREAM 10MG/GM \"SINPHAR\"(CLOTRIMAZOLE)"
    },
    {
      "code" : "A025139100",
      "display" : "COAN TABLETS \"H.H.\""
    },
    {
      "code" : "A025142100",
      "display" : "CLOXACILLIN CAPSULES 250MG \"C.R.\""
    },
    {
      "code" : "A025149100",
      "display" : "LICHANYU TABLETS \"HONTEN\""
    },
    {
      "code" : "A025155100",
      "display" : "CHINOZEN TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE) \"SHITEH\""
    },
    {
      "code" : "A025159100",
      "display" : "GRIFUCIN TABLETS 500MG"
    },
    {
      "code" : "A025160100",
      "display" : "ASPIRIN F.C. TABLETS 500MG \"TAI YU\""
    },
    {
      "code" : "A025163100",
      "display" : "DECA TABLETS 0.75MG (DEXAMETHASONE) \"CHEN SING\""
    },
    {
      "code" : "A025170100",
      "display" : "DEPAIN TABLETS 500MG (ACETAMINOPHEN) \"W.P.\""
    },
    {
      "code" : "A025172100",
      "display" : "PERAN TABLETS 5MG (METOCLOPRAMIDE 2HCL)"
    },
    {
      "code" : "A025181100",
      "display" : "FUANTIN TABLETS 1MG (DIHYDROERGOTOXINE MESYLATE"
    },
    {
      "code" : "A025182100",
      "display" : "WORMSPIN TABLETS 100MG (MEBENDAZOLE) \"METRO\""
    },
    {
      "code" : "A025185174",
      "display" : "ALUGEL SUSPENSION"
    },
    {
      "code" : "A025191100",
      "display" : "WINSUMIN F.C. TABLETS 50MG (CHLORPROMAZINE HCL)"
    },
    {
      "code" : "A025194157",
      "display" : "KOSOLIN SYRUP"
    },
    {
      "code" : "A025194199",
      "display" : "KOSOLIN SYRUP"
    },
    {
      "code" : "A025195100",
      "display" : "DYPHACOL TABLETS"
    },
    {
      "code" : "A025196100",
      "display" : "Easygo Tablets \"S.D.\""
    },
    {
      "code" : "A025201100",
      "display" : "TECON CAPSULES 10MG (PIROXICAM) \"PANBIOTIC\""
    },
    {
      "code" : "A025202100",
      "display" : "FELCAM CAPSULES 10MG (PIROXICAM)"
    },
    {
      "code" : "A0252021G0",
      "display" : "FELCAM CAPSULES 10MG (PIROXICAM)"
    },
    {
      "code" : "A025209100",
      "display" : "COMFORT CAPSULES \"S.C.\""
    },
    {
      "code" : "A025214100",
      "display" : "CHLORPHENIRAMINE MALEATE TABLETS 4MG \"W.P.\""
    },
    {
      "code" : "A025215100",
      "display" : "DAIPINE TABLETS 1MG (N-METHYLSCOPOLAMINE METHYL SULFATE)"
    },
    {
      "code" : "A025216229",
      "display" : "POLIMIN-B12 INJECTION \"Y.Y.\""
    },
    {
      "code" : "A025216238",
      "display" : "POLIMIN-B12 INJECTION \"Y.Y.\""
    },
    {
      "code" : "A025217500",
      "display" : "ANTIFUNGAL VAGINAL TABLETS 100MG \"S.C.\" (MICONAZOLE)"
    },
    {
      "code" : "A025218329",
      "display" : "Konazole Ointment \"Y.Y.\" (Miconazole nitrate)"
    },
    {
      "code" : "A025221100",
      "display" : "AMOXICILLIN CAPSULES 250MG \"LIN CHEMICAL\""
    },
    {
      "code" : "A025223100",
      "display" : "TOEEFON FILM COATED TABLETS 250MG  \"T.F.\""
    },
    {
      "code" : "A025224100",
      "display" : "Oribira Tablets"
    },
    {
      "code" : "A025228335",
      "display" : "BINCON OINTMENT (INDOMETHACIN)"
    },
    {
      "code" : "A025230100",
      "display" : "DOGWEISU CAPSULES 50MG (SULPIRIDE)"
    },
    {
      "code" : "A025231100",
      "display" : "KETOEN CAPSULES 50MG (KETOPROFEN) \"SPC\""
    },
    {
      "code" : "A025237321",
      "display" : "TRETINOIN CREAM 0.1％"
    },
    {
      "code" : "A025240100",
      "display" : "TAGNESON CAPSULES 50MG (SULPIRIDE) \"JINUP\""
    },
    {
      "code" : "A025241100",
      "display" : "SOTASIN TABLETS 8MG (BROMHEXINE)"
    },
    {
      "code" : "A025243100",
      "display" : "ERGOXIN TABLETS 1.5MG (DIHYDROERGOTOXINE METHANESULFONATE) \"S.C.\""
    },
    {
      "code" : "A025244100",
      "display" : "LIKODIN CAPSULES 500MG  \"SWISS\"(CEFADROXIL)"
    },
    {
      "code" : "A025245209",
      "display" : "APRELAZINE INJECTION 20MG/ML (HYDRALAZINE)"
    },
    {
      "code" : "A025245277",
      "display" : "APRELAZINE INJECTION 20MG/ML (HYDRALAZINE)"
    },
    {
      "code" : "A025250100",
      "display" : "HAO PI TUNG CAPSULES"
    },
    {
      "code" : "A025253100",
      "display" : "DESPUTUM TABLETS 30MG (IODOPROPYLIDENE GLYCEROL) \"S.C.\""
    },
    {
      "code" : "A025254100",
      "display" : "LYSOZYME TABLETS 90MG \"S.C.\""
    },
    {
      "code" : "A025260100",
      "display" : "TINIZOLE TABLETS 150MG (TINIDAZOLE)"
    },
    {
      "code" : "A025261119",
      "display" : "CYPROHEPTADINE SYRUP 0.4MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A025261199",
      "display" : "CYPROHEPTADINE SYRUP 0.4MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A025264100",
      "display" : "FUDAGYN F.C. TABLETS 500MG (TINIDAZOLE)"
    },
    {
      "code" : "A025272100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS 25MG \"C.H.\""
    },
    {
      "code" : "A025273100",
      "display" : "Docoler Tablets 250mg \"Y.Y.\""
    },
    {
      "code" : "A025275100",
      "display" : "NORSETOA CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A025279100",
      "display" : "SUPERZYME TABLETS 90MG"
    },
    {
      "code" : "A025284100",
      "display" : "CHINOCON TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A025287277",
      "display" : "CEFAMANDOLE FOR INJECTION 500MG"
    },
    {
      "code" : "A025290100",
      "display" : "PIROX CAPSULES 10MG \"Y.C.\" (PIROXICAM)"
    },
    {
      "code" : "A025291321",
      "display" : "SEEDO-SANIN CREAM"
    },
    {
      "code" : "A025291325",
      "display" : "SEEDO-SANIN CREAM"
    },
    {
      "code" : "A025291329",
      "display" : "SEEDO-SANIN CREAM"
    },
    {
      "code" : "A025291372",
      "display" : "SEEDO-SANIN CREAM"
    },
    {
      "code" : "A025291399",
      "display" : "SEEDO-SANIN CREAM"
    },
    {
      "code" : "A025292100",
      "display" : "NAGCID TABLETS 500MG (NALIDIXIC ACID)"
    },
    {
      "code" : "A025301100",
      "display" : "OXO CAPSULES (OXOLAMINE CITRATE) \"YUNG SHIN\""
    },
    {
      "code" : "A025304100",
      "display" : "COSTAN TABLETS 20MG  \"T.F.\""
    },
    {
      "code" : "A025305100",
      "display" : "ANBITONG TABLETS 500MG (ACETAMINOPHEN)"
    },
    {
      "code" : "A025306100",
      "display" : "CEPHALEXIN CAPSULES 250MG"
    },
    {
      "code" : "A025309157",
      "display" : "CARSTIN SYRUP 20MG/ML \"STANDARD\" (S-CARBOXYMETHYLCYSTEINE)"
    },
    {
      "code" : "A025310100",
      "display" : "FUROKAN CAPSULES (PIROXICAM)"
    },
    {
      "code" : "A025314100",
      "display" : "NIFLUCIL CAPSULES 250MG \"Y.C.\" (NIFLUMIC ACID)"
    },
    {
      "code" : "A025316100",
      "display" : "TRANEXMIN CAPSULES 250MG \"CHINTENG\" (TRANEXAMIC ACID)"
    },
    {
      "code" : "A0253161G0",
      "display" : "TRANEXMIN CAPSULES 250MG \"CHINTENG\" (TRANEXAMIC ACID)"
    },
    {
      "code" : "A025320100",
      "display" : "LONZEPIN TABLETS 25MG (PIRENZEPINE HCL)"
    },
    {
      "code" : "A025322100",
      "display" : "CAPIN TABLETS 10MG \"METRO\" (NOSCAPINE)"
    },
    {
      "code" : "A025323209",
      "display" : "BETAMETHASONE INJECTION 4MG/ML \"Y.J.\""
    },
    {
      "code" : "A025323229",
      "display" : "BETAMETHASONE INJECTION 4MG/ML \"Y.J.\""
    },
    {
      "code" : "A025325209",
      "display" : "CEFOBID FOR IM.IV. INJECTION 1.0GM (CEFOPERAZONE)"
    },
    {
      "code" : "A025325277",
      "display" : "CEFOBID FOR IM.IV. INJECTION 1.0GM (CEFOPERAZONE)"
    },
    {
      "code" : "A025349100",
      "display" : "LICOTIN-A CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A025355266",
      "display" : "FRUCEROL INJECTION"
    },
    {
      "code" : "A025355277",
      "display" : "FRUCEROL INJECTION"
    },
    {
      "code" : "A025365100",
      "display" : "ESIDAR S.C. TABLETS \"M.T.\""
    },
    {
      "code" : "A0253651G0",
      "display" : "ESIDAR S.C. TABLETS \"M.T.\""
    },
    {
      "code" : "A025377100",
      "display" : "TIOPRONIN S.C. TABLETS 100MG \"H.S.\""
    },
    {
      "code" : "A025381100",
      "display" : "POSDAN CAPSULES 250MG \"K.S.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A025395100",
      "display" : "TRANCOL TABLETS 100MG (CHLORMEZANONE)"
    },
    {
      "code" : "A025396100",
      "display" : "MEFETON F.C. TABLETS 500MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A0253961G0",
      "display" : "MEFETON F.C. TABLETS 500MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A025398277",
      "display" : "CEFOBID FOR IM.IV. INJECTION 0.5GM"
    },
    {
      "code" : "A025402100",
      "display" : "SOLACON TABLETS 200MG (CHLORZOXAZONE) \"STANDARD\""
    },
    {
      "code" : "A0254021G0",
      "display" : "SOLACON TABLETS 200MG (CHLORZOXAZONE) \"STANDARD\""
    },
    {
      "code" : "A025406100",
      "display" : "PERANSIN F.C. TABLETS 75MG \"C.H.\""
    },
    {
      "code" : "A025419100",
      "display" : "REZINON TABLETS 20MG \"JOHNSON\" (EPRAZINONE)"
    },
    {
      "code" : "A025420100",
      "display" : "DEXAMETHASONE TABLETS 1 mg \"K.S.\""
    },
    {
      "code" : "A025426212",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION 10MG/ML \"Y.Y.\""
    },
    {
      "code" : "A025426216",
      "display" : "PYRIDOXAL PHOSPHATE INJECTION 10MG/ML \"Y.Y.\""
    },
    {
      "code" : "A025427100",
      "display" : "DISOPYRAMIDE CAPSULES 100MG \"F.Y.\""
    },
    {
      "code" : "A025428416",
      "display" : "RUCOS ORAL BASE 0.1％ (TRIAMCINOLONE)"
    },
    {
      "code" : "A025428421",
      "display" : "RUCOS ORAL BASE 0.1％ (TRIAMCINOLONE)"
    },
    {
      "code" : "A025430209",
      "display" : "NEUROPAM INJECTION 2MG/ML (LORAZEPAM)"
    },
    {
      "code" : "A025430212",
      "display" : "NEUROPAM INJECTION 2MG/ML (LORAZEPAM)"
    },
    {
      "code" : "A025431100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS 75MG\"Oriental\""
    },
    {
      "code" : "A025433100",
      "display" : "KINDOCID CAPSULES 25MG (INDOMETHACIN) \"KINGDOM\""
    },
    {
      "code" : "A025436100",
      "display" : "DICLOTON TABLETS 25MG (DICLOFENAC)"
    },
    {
      "code" : "A025437100",
      "display" : "CAFERGOT TABLETS \"Y.S.\""
    },
    {
      "code" : "A025442109",
      "display" : "DESPLEN GRANULES (EPRAZINONE)"
    },
    {
      "code" : "A025442177",
      "display" : "DESPLEN GRANULES (EPRAZINONE)"
    },
    {
      "code" : "A025442199",
      "display" : "DESPLEN GRANULES (EPRAZINONE)"
    },
    {
      "code" : "A025443100",
      "display" : "KONSHIEN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A025445100",
      "display" : "NORUOLU TABLETS 5MG (NORETHISTERONE)"
    },
    {
      "code" : "A025446100",
      "display" : "PIROXIM CAPSULES 10MG \"STANDARD\" (PIROXICAM)"
    },
    {
      "code" : "A0254461G0",
      "display" : "PIROXIM CAPSULES 10MG \"STANDARD\" (PIROXICAM)"
    },
    {
      "code" : "A025447100",
      "display" : "ANSRON FILM COATED TABLETS 100MG"
    },
    {
      "code" : "A025449114",
      "display" : "AMIYU GRANULES"
    },
    {
      "code" : "A025452100",
      "display" : "ZUCON TABLETS 25MG (DICLOFENAC) \"Y.Y.\""
    },
    {
      "code" : "A025454318",
      "display" : "POVIDONE-IODINE SOLUTION 10％ \"ORIENTAL\""
    },
    {
      "code" : "A025456100",
      "display" : "HOWELL TABLETS 100MG \"WELCAN\" (DIHYDROXY ALUMINUM ALLANTOINATE)"
    },
    {
      "code" : "A025460100",
      "display" : "TRANEXAMIC ACID 250MG CAPSULES"
    },
    {
      "code" : "A025462100",
      "display" : "SULPIRIDE TABLETS 100MG \"Y.S.C.\""
    },
    {
      "code" : "A025466100",
      "display" : "LEVAZOL TABLETS 40MG \"CHEN TA\" (LEVAMISOLE)"
    },
    {
      "code" : "A025467100",
      "display" : "LYZINE TABLETS 50MG \"T.F.\""
    },
    {
      "code" : "A025469100",
      "display" : "BILO CAPSULES \"N.K.\""
    },
    {
      "code" : "A025471100",
      "display" : "MUSZEPIN TABLETS 25MG (PIRENZEPINE HYDROCHLORIDE)"
    },
    {
      "code" : "A025477100",
      "display" : "WINBETA TABLETS 0.5MG (BETAMETHASONE) \"WINSTON\""
    },
    {
      "code" : "A025478100",
      "display" : "VILECON CAPSULES 30MG (PYRIDOXALPHOSPHATE) \"F.S.\""
    },
    {
      "code" : "A025479100",
      "display" : "PUSTON CAPSULES 500MG (MEFENAMIC ACID) \"HONG YA\""
    },
    {
      "code" : "A025482209",
      "display" : "ATROPINE SULFATE INJECTION 2MG/ML \"VPP\""
    },
    {
      "code" : "A025483100",
      "display" : "SHOUCA TABLETS 100MG (MEBENDAZOLE) \"S.C.\""
    },
    {
      "code" : "A025484100",
      "display" : "NEPHZEN TABLETS \"AND\""
    },
    {
      "code" : "A025485209",
      "display" : "DEXTROSE 5％ AND SODIUM CHLORIDE 0.225％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A025485265",
      "display" : "DEXTROSE 5％ AND SODIUM CHLORIDE 0.225％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A025485277",
      "display" : "DEXTROSE 5％ AND SODIUM CHLORIDE 0.225％ INJECTION \"Y.F.\""
    },
    {
      "code" : "A025487100",
      "display" : "LONDEC TABLETS \"K.S.\""
    },
    {
      "code" : "A025492212",
      "display" : "BITAS-H INJECTION \"Y.Y.\""
    },
    {
      "code" : "A025495100",
      "display" : "NAPROXEN TABLETS 250MG"
    },
    {
      "code" : "A025504421",
      "display" : "YECOLON ORABASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A025504423",
      "display" : "YECOLON ORABASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A025504477",
      "display" : "YECOLON ORABASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A025504499",
      "display" : "YECOLON ORABASE (TRIAMCINOLONE)"
    },
    {
      "code" : "A025505100",
      "display" : "INSTAMIN-C TABLETS 500MG (ASCORBIC ACID)"
    },
    {
      "code" : "A025507277",
      "display" : "AMINOL INFUSION \"S.T.\""
    },
    {
      "code" : "A025509100",
      "display" : "RIBO TABLETS 5MG (RIBOFLAVIN)"
    },
    {
      "code" : "A025512100",
      "display" : "FUMINCON S.C. TABLET \"F.S.\""
    },
    {
      "code" : "A025517100",
      "display" : "THECOUGHEN TABLETS \"T.F.\""
    },
    {
      "code" : "A025520100",
      "display" : "METHOPTERIN TABLETS 2.5MG (METHOTREXATE)"
    },
    {
      "code" : "A025524100",
      "display" : "VOREN ENTERIC COATED TABLETS 50MG \"YUNG SHIN\"(Diclofenac)"
    },
    {
      "code" : "A0255241G0",
      "display" : "VOREN ENTERIC COATED TABLETS 50MG \"YUNG SHIN\"(Diclofenac)"
    },
    {
      "code" : "A025525100",
      "display" : "KODERLIN TABLETS \"MEIDER\""
    },
    {
      "code" : "A025528209",
      "display" : "KALTOSE INJECTION \"N.K.\""
    },
    {
      "code" : "A025528265",
      "display" : "KALTOSE INJECTION \"N.K.\""
    },
    {
      "code" : "A025528277",
      "display" : "KALTOSE INJECTION \"N.K.\""
    },
    {
      "code" : "A025539212",
      "display" : "LINCOMYCIN INJECTION 300MG \"Y.Y.\""
    },
    {
      "code" : "A025539229",
      "display" : "LINCOMYCIN INJECTION 300MG \"Y.Y.\""
    },
    {
      "code" : "A025541100",
      "display" : "SILYMARIN F.C. TABLETS 35MG"
    },
    {
      "code" : "A025546100",
      "display" : "PIROXIM CAP. 10MG"
    },
    {
      "code" : "A025547100",
      "display" : "REMEXIN TABLETS"
    },
    {
      "code" : "A025548100",
      "display" : "PIZEPINE TABLETS 25MG (PIRENZEPINE DIHYDROCHLORIDE)"
    },
    {
      "code" : "A025549100",
      "display" : "TOLMETIN TABLETS 200MG \"LITA\""
    },
    {
      "code" : "A025550263",
      "display" : "AMIYU INJECTION"
    },
    {
      "code" : "A025552212",
      "display" : "SOCOTRIM INJECTION \"N.K.\""
    },
    {
      "code" : "A025552221",
      "display" : "SOCOTRIM INJECTION \"N.K.\""
    },
    {
      "code" : "A025552229",
      "display" : "SOCOTRIM INJECTION \"N.K.\""
    },
    {
      "code" : "A025554100",
      "display" : "SUTON TABLETS \"K.T.\""
    },
    {
      "code" : "A025555100",
      "display" : "BAKTSIN TABLETS \"Y.S.\""
    },
    {
      "code" : "A025556100",
      "display" : "LORAZEPAM TABLETS 1MG \"C.S.\""
    },
    {
      "code" : "A025557100",
      "display" : "SULPIRIDE CAPSULES 50MG \"C.S.\""
    },
    {
      "code" : "A025563212",
      "display" : "SINICORT IM. INJECTION 10MG/ML(TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A025563221",
      "display" : "SINICORT IM. INJECTION 10MG/ML(TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A025564100",
      "display" : "PIREPINE TABLETS 25MG \"YU SHENG\""
    },
    {
      "code" : "A025567309",
      "display" : "ECONALONE CREAM \"SINPHAR\""
    },
    {
      "code" : "A025567321",
      "display" : "ECONALONE CREAM \"SINPHAR\""
    },
    {
      "code" : "A025567329",
      "display" : "ECONALONE CREAM \"SINPHAR\""
    },
    {
      "code" : "A025567372",
      "display" : "ECONALONE CREAM \"SINPHAR\""
    },
    {
      "code" : "A025567399",
      "display" : "ECONALONE CREAM \"SINPHAR\""
    },
    {
      "code" : "A025570100",
      "display" : "LYSOZYME TABLETS 50MG"
    },
    {
      "code" : "A025571100",
      "display" : "SPANTON TABLETS"
    },
    {
      "code" : "A025574100",
      "display" : "FU LAO SHU CAPSULES 10MG \"T.L.B\""
    },
    {
      "code" : "A025577100",
      "display" : "COMFONIN CAPSULES"
    },
    {
      "code" : "A025581100",
      "display" : "RICO CAPSULES \"H.H.\""
    },
    {
      "code" : "A025582100",
      "display" : "Epranone Tablets 20mg \"H.S.\""
    },
    {
      "code" : "A025586100",
      "display" : "LORAZEPAM TABLETS 1MG \"C.H.\""
    },
    {
      "code" : "A025587100",
      "display" : "ALLILACK TABLETS 500MG \"PATRON\" (DIHYDROXYALUMINUM AMINOACETATE)"
    },
    {
      "code" : "A025588100",
      "display" : "MAXOLONE TABLETS 10MG \"Y.Y.\" (METOCLOPRAMIDE)"
    },
    {
      "code" : "A025589100",
      "display" : "LORAZEPAM TABLETS 1MG \"CHEN TA\""
    },
    {
      "code" : "A025590100",
      "display" : "LYSOZYME CHLORIDE TABLETS 50MG \"CHINTENG\""
    },
    {
      "code" : "A0255901G0",
      "display" : "LYSOZYME CHLORIDE TABLETS 50MG \"CHINTENG\""
    },
    {
      "code" : "A025592100",
      "display" : "VINCPAIN TABLETS \"GRAPE\""
    },
    {
      "code" : "A025595229",
      "display" : "LINCOMYCIN HCL INJECTION 300MG/ML \"T.F.\""
    },
    {
      "code" : "A025595238",
      "display" : "LINCOMYCIN HCL INJECTION 300MG/ML \"T.F.\""
    },
    {
      "code" : "A025596100",
      "display" : "TOFOANIN TABLETS 25MG (INDOMETHACIN)"
    },
    {
      "code" : "A025601100",
      "display" : "EPRAZINONE TABLETS 30MG \"CHINTENG\""
    },
    {
      "code" : "A025604100",
      "display" : "BERODIN TABLETS 2.5MG \"N.C.P.\" (FENOTEROL)"
    },
    {
      "code" : "A025608100",
      "display" : "CENTRUM FILM COATED TABLETS"
    },
    {
      "code" : "A025610100",
      "display" : "LORAZEPAM TABLETS 1MG \"S.Y.\""
    },
    {
      "code" : "A025613100",
      "display" : "PITONIN CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A025614100",
      "display" : "COLIN TABLETS 20MG (EPRAZINONE)\"M.S.\""
    },
    {
      "code" : "A025617100",
      "display" : "CEFADROXIL CAPSULES 500MG \"Y.S.\""
    },
    {
      "code" : "A025621209",
      "display" : "TOBRA INJECTION 40MG/ML (TOBRAMYCIN)"
    },
    {
      "code" : "A025621212",
      "display" : "TOBRA INJECTION 40MG/ML (TOBRAMYCIN)"
    },
    {
      "code" : "A025623100",
      "display" : "Lovamin Tablets 1mg \"T.F.\""
    },
    {
      "code" : "A025624100",
      "display" : "PLOCON TABLETS 3MG \"Y.Y.\" (PIPRINHYDRINATE)"
    },
    {
      "code" : "A025628100",
      "display" : "CIMETIDINE TABLETS 200MG"
    },
    {
      "code" : "A025629100",
      "display" : "DICYCLOMINE TABLETS 10MG \"Y.Y.\""
    },
    {
      "code" : "A025630100",
      "display" : "NEPHALAX TABLETS \"JINUP\""
    },
    {
      "code" : "A025631209",
      "display" : "TOBRA INJECTION 10MG/ML (TOBRAMYCIN)"
    },
    {
      "code" : "A025631212",
      "display" : "TOBRA INJECTION 10MG/ML (TOBRAMYCIN)"
    },
    {
      "code" : "A025631229",
      "display" : "TOBRA INJECTION 10MG/ML (TOBRAMYCIN)"
    },
    {
      "code" : "A025632100",
      "display" : "PIROCAM CAPSULES 20MG  \"Y.K.\""
    },
    {
      "code" : "A025633100",
      "display" : "KANETOL CAPSULES 25MG (ANETHOLE) \"C.M.\""
    },
    {
      "code" : "A025640100",
      "display" : "HONSTRONG TABLETS"
    },
    {
      "code" : "A025643100",
      "display" : "SIGAMET F.C. TABLETS 200MG (CIMETIDINE) \"SINPHAR\""
    },
    {
      "code" : "A0256431G0",
      "display" : "SIGAMET F.C. TABLETS 200MG (CIMETIDINE) \"SINPHAR\""
    },
    {
      "code" : "A025644100",
      "display" : "PRIMLAN TABLETS 10MG \"P.L.\" (METOCLOPRAMIDE)"
    },
    {
      "code" : "A025645421",
      "display" : "GENAMYCIN OPTHALMIC"
    },
    {
      "code" : "A025648100",
      "display" : "LILIPIN CAPSULES 150MG"
    },
    {
      "code" : "A025654212",
      "display" : "Metoperon Injection 5mg/ml \"K.S.\""
    },
    {
      "code" : "A025657277",
      "display" : "AMOXICILLIN FOR INJECTION 500MG"
    },
    {
      "code" : "A025658209",
      "display" : "AMOXICILLIN FOR INJECTION 1GM"
    },
    {
      "code" : "A025659100",
      "display" : "CEFADROXIL CAPSULES 500MG \"TBC\""
    },
    {
      "code" : "A025660100",
      "display" : "CLONIDINE TABLETS 0.2MG \"Y.S.\""
    },
    {
      "code" : "A025662100",
      "display" : "SEMINCON CAPSULES 10MG (PIROXICAM) \"F.S.\""
    },
    {
      "code" : "A025663100",
      "display" : "SUSOUCON CAPSULES 30MG (DEXTROMETHORPHAN) \"ORIENTAL\""
    },
    {
      "code" : "A025667100",
      "display" : "V E S.C. TABLETS 50MG (DL-ALPHA-TOCOPHEROL ACETATE)"
    },
    {
      "code" : "A025671100",
      "display" : "Anmin Tablets 2.5mg \"N.C.P.\" (Triprolidine Hydrochloride)"
    },
    {
      "code" : "A025673100",
      "display" : "ZINTAMIN F.C. TABLETS \"GCPC\""
    },
    {
      "code" : "A025674100",
      "display" : "NOSEZYM CAPSULES \"GCPC\""
    },
    {
      "code" : "A025675209",
      "display" : "MALTOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A025675265",
      "display" : "MALTOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A025675277",
      "display" : "MALTOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A025676100",
      "display" : "MEZOLE TABLETS 100MG (MEBENDAZOLE)"
    },
    {
      "code" : "A025679100",
      "display" : "MOZAL TABLETS 4MG (SALBUTAMOL)"
    },
    {
      "code" : "A025681212",
      "display" : "LIDOCAINE INJECTION 2％ \"Y.F.\""
    },
    {
      "code" : "A025681248",
      "display" : "LIDOCAINE INJECTION 2％ \"Y.F.\""
    },
    {
      "code" : "A025682500",
      "display" : "ECONAZOLE NITRATE SUPPOSITORIES 150MG \"YUNG SHIN\""
    },
    {
      "code" : "A025683100",
      "display" : "PINSANIDINE TABLETS 0.15MG (CLANIDINE) \"Y.S.\""
    },
    {
      "code" : "A025685100",
      "display" : "BO-WEIKON TABLETS 25MG (PIRENZEPINE 2HCL)"
    },
    {
      "code" : "A025686100",
      "display" : "Poshinlen F.C. Tablets 25mg\"H.S.\""
    },
    {
      "code" : "A0256861G0",
      "display" : "Poshinlen F.C. Tablets 25mg\"H.S.\""
    },
    {
      "code" : "A025688100",
      "display" : "Anticon tablets 15 mg (Dextromethorphan Hydrobromide)"
    },
    {
      "code" : "A025692100",
      "display" : "Shubico Capsules \"S.C.\""
    },
    {
      "code" : "A025698100",
      "display" : "PIPEMIDON CAPSULES 250MG \"T.F.\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A025699100",
      "display" : "ANBEELOU CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A025706100",
      "display" : "STARGEN S.C. TABLETS 100MG (TIOPRONIN) \"S.T.\""
    },
    {
      "code" : "A025707100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"N.W.\""
    },
    {
      "code" : "A025709155",
      "display" : "CODERNIN POWDER"
    },
    {
      "code" : "A025709199",
      "display" : "CODERNIN POWDER"
    },
    {
      "code" : "A025711100",
      "display" : "CEFADROXIL CAPSULES 500MG \"Y.Y.\""
    },
    {
      "code" : "A025714100",
      "display" : "CIWIDINE TABLETS 200MG"
    },
    {
      "code" : "A025715100",
      "display" : "ACTIZYME TABLETS 30MG\"PANBIOTIC\"(LYSOZYME)"
    },
    {
      "code" : "A025716100",
      "display" : "TRANEXAMIN CAPSULES 250MG (TRANEXAMIC ACID) \"S.C.\""
    },
    {
      "code" : "A025717309",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717317",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717321",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717329",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717335",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717377",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025717399",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A0257173B9",
      "display" : "ECONOL-T CREAM \"GCPC\""
    },
    {
      "code" : "A025718100",
      "display" : "FUNTONNON TABLETS"
    },
    {
      "code" : "A025720100",
      "display" : "KETOPROFEN CAPSULES 50MG"
    },
    {
      "code" : "A025723100",
      "display" : "IBUPROFEN S.C. TABLETS 200MG \"MEIDER\""
    },
    {
      "code" : "A025725100",
      "display" : "TAKERIES TABLETS 50MG \"N.C.P.\" (LEVAMISOLE)"
    },
    {
      "code" : "A025726100",
      "display" : "BEROGIN TABLETS 2.5MG (FENOTEROL) \"HONTEN\""
    },
    {
      "code" : "A025732100",
      "display" : "DICENS TABLETS 25MG (DICLOFENAC)"
    },
    {
      "code" : "A025737100",
      "display" : "LINCOMYCIN CAPSULES 500MG \"N.W.\""
    },
    {
      "code" : "A025739100",
      "display" : "ERYTHROMYCIN STEARATE FILM COATED TABLETS 250MG \"SHITEH\""
    },
    {
      "code" : "A025740100",
      "display" : "PIROXICAM CAPSULES 10MG \"L.S.\""
    },
    {
      "code" : "A025747100",
      "display" : "SIDOMON CAPSULES 5MG (FLUOXYMESTERONE) \"K.B.\""
    },
    {
      "code" : "A025748221",
      "display" : "FORSTRONG LYO-INJECTION 5000IU (CHORIONIC GONADOTROPIN)"
    },
    {
      "code" : "A025753329",
      "display" : "TRAVOCORT CREAM"
    },
    {
      "code" : "A025754100",
      "display" : "PICOTAM CAPSULES 400MG (PIPEMIDIC ACID) \"GENTLE\""
    },
    {
      "code" : "A025760109",
      "display" : "CYSTIN POWDER 40MG/GM \"LITA\""
    },
    {
      "code" : "A025761118",
      "display" : "COLIMAL SOLUTION \"L.S.\""
    },
    {
      "code" : "A025762151",
      "display" : "COLIMAL WITH CODEINE SYRUP \"L.S.\""
    },
    {
      "code" : "A025762199",
      "display" : "COLIMAL WITH CODEINE SYRUP \"L.S.\""
    },
    {
      "code" : "A025764329",
      "display" : "TRAVOGEN CREAM 10MG (ISOCONAZOLE NITRATE)"
    },
    {
      "code" : "A025767100",
      "display" : "TABRON CAPSULES \"Y.K.\""
    },
    {
      "code" : "A025768100",
      "display" : "COUGHTININ TABLETS 100MG \"PANBIOTIC\" (OXOLAMINE CITRATE)"
    },
    {
      "code" : "A025770100",
      "display" : "IBUPROFEN TABLETS 100MG"
    },
    {
      "code" : "A025772212",
      "display" : "CIMEDINE INJECTION 100MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A025773100",
      "display" : "ES MYCIN F.C. TABLETS 500MG (ERYTHROMYCIN STEARATE) \"W.P.\""
    },
    {
      "code" : "A025778100",
      "display" : "Tri-Zyme Tablets \"CHEN TA\""
    },
    {
      "code" : "A025785100",
      "display" : "PULINPELIN TABLETS"
    },
    {
      "code" : "A025789100",
      "display" : "ACTIZYME 90MG CAPSULES (LYSOZYME)"
    },
    {
      "code" : "A025790216",
      "display" : "CLOFON INJECTION 25MG/ML (DICLOFENAC)"
    },
    {
      "code" : "A025792216",
      "display" : "DICLOFEN INJECTION 25MG/ML (DICLOFENAC)"
    },
    {
      "code" : "A025793100",
      "display" : "FEDNE CAPSULES 10MG (PIROXICAM) \"SHITEH\""
    },
    {
      "code" : "A025800209",
      "display" : "AMOCILLIN FOR INJECTION 1 GM (AMOXICILLIN) \"CHI SHENG\""
    },
    {
      "code" : "A025801500",
      "display" : "ECOZOL SUPPOSITORY 150MG (ECONAZOLE)"
    },
    {
      "code" : "A025802265",
      "display" : "CEFURO INJECTION 250MG"
    },
    {
      "code" : "A025803209",
      "display" : "PROGESTON DEPOT INTRAMUSCULAR 125MG"
    },
    {
      "code" : "A025806100",
      "display" : "SINDELIN S.C. TABLETS"
    },
    {
      "code" : "A025810209",
      "display" : "Cepha for Injection 1 Gm\"K.S.\""
    },
    {
      "code" : "A025812100",
      "display" : "MADURIN CAPSULES 70MG \"SHIN FONG\""
    },
    {
      "code" : "A025816329",
      "display" : "YEAFULIN CREAM \"Y.S.\""
    },
    {
      "code" : "A025816338",
      "display" : "YEAFULIN CREAM \"Y.S.\""
    },
    {
      "code" : "A025816377",
      "display" : "YEAFULIN CREAM \"Y.S.\""
    },
    {
      "code" : "A025817100",
      "display" : "GOODGEN CAPSULES 10MG \"PATRON\" (PIROXICAM)"
    },
    {
      "code" : "A025818416",
      "display" : "EAR RINDERON-A SOLUTION"
    },
    {
      "code" : "A025821100",
      "display" : "ANBILO CAPSULES \"C.L.\""
    },
    {
      "code" : "A025824100",
      "display" : "GASZEPIN TABLETS 25MG (PIRENZEPINE HCL)"
    },
    {
      "code" : "A025828100",
      "display" : "PITOCAM CAPSULES 10MG (PIROXICAM) \"SPC\""
    },
    {
      "code" : "A0258281G0",
      "display" : "PITOCAM CAPSULES 10MG (PIROXICAM) \"SPC\""
    },
    {
      "code" : "A025829100",
      "display" : "PONAKATON S.C. TABLETS \"Y.S.\""
    },
    {
      "code" : "A025830100",
      "display" : "LYSO TABLETS 50MG (LYSOZYME) \"MEDRAY\""
    },
    {
      "code" : "A025832329",
      "display" : "ANSUSEN CREAM"
    },
    {
      "code" : "A025832372",
      "display" : "ANSUSEN CREAM"
    },
    {
      "code" : "A025833100",
      "display" : "SUSTON CAPSULES 250MG\"H.S.\""
    },
    {
      "code" : "A025835100",
      "display" : "SEIZYME TABLETS 60MG \"Y.Y.\""
    },
    {
      "code" : "A025836100",
      "display" : "TONLIAN TABLETS"
    },
    {
      "code" : "A025838338",
      "display" : "METHATON OINTMENT 1％ (INDOMETHACIN) \"CHIPHAR\""
    },
    {
      "code" : "A025840100",
      "display" : "ATENOL F.C. TABLETS 100MG (ATENOLOL)"
    },
    {
      "code" : "A025841100",
      "display" : "ANTIMIGRAINE FILM COATED TABLETS \"T.F.\""
    },
    {
      "code" : "A0258411G0",
      "display" : "ANTIMIGRAINE FILM COATED TABLETS \"T.F.\""
    },
    {
      "code" : "A025842100",
      "display" : "TRANEXIC TABLETS 250MG \"P.L.\""
    },
    {
      "code" : "A025844209",
      "display" : "ETHYLERGONOVINE MALEATE INJECTION 0.2MG/ML \"Y.Y.\""
    },
    {
      "code" : "A025845329",
      "display" : "EIOFILINO CREAM \"T.L.\""
    },
    {
      "code" : "A025845399",
      "display" : "EIOFILINO CREAM \"T.L.\""
    },
    {
      "code" : "A025847100",
      "display" : "AISOPENT TABLETS 20MG\"T.F.\" (ORCIPRENALINE)"
    },
    {
      "code" : "A025848100",
      "display" : "ASPIRIN CHEWABLE TABLET 150MG \"SINPHAR\""
    },
    {
      "code" : "A025849212",
      "display" : "METOCLOPRAMIDE INJECTION \"Y.Y.\""
    },
    {
      "code" : "A025851100",
      "display" : "UNISIN S.C. TABLETS 25MG (DIPYRIDAMOLE) \"UNION\""
    },
    {
      "code" : "A025854100",
      "display" : "GAZEPIN TABLETS 25MG \"N.C.P.\" (PIRENZEPINE 2HCL)"
    },
    {
      "code" : "A025855500",
      "display" : "ASPIRIN SUPPOSITORIES 325MG \"Y.C.\""
    },
    {
      "code" : "A025856100",
      "display" : "RESCO TABLETS 20MG (EPRAZINONE) \"GENTLE\""
    },
    {
      "code" : "A025857100",
      "display" : "PARACETAMOL TABLETS 500MG \"D.M.\""
    },
    {
      "code" : "A025860343",
      "display" : "LIDO JELLY 2％ (LIDOCAINE HCL) \"GCPC\""
    },
    {
      "code" : "A025865100",
      "display" : "LYSOZYME TABLETS"
    },
    {
      "code" : "A025866100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"YUNG SHIN\""
    },
    {
      "code" : "A025870100",
      "display" : "Subefon Tablets \"C.L.\""
    },
    {
      "code" : "A025871100",
      "display" : "PIROXICAM CAPSULES 10MG \"Y.Y.\""
    },
    {
      "code" : "A025874100",
      "display" : "LISOZYME TABLETS 30MG (LYSOZYME) \"C.I.\""
    },
    {
      "code" : "A025875212",
      "display" : "KETOPROFEN INJECTION 50MG/ML \"T.S.\""
    },
    {
      "code" : "A025882100",
      "display" : "LYCOSU TABLETS 50MG"
    },
    {
      "code" : "A025883321",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025883329",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025883335",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025883338",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025883377",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025883399",
      "display" : "Nail Fungus FAPG Cream \"M.D.\""
    },
    {
      "code" : "A025887100",
      "display" : "LIKANG CAPSULES \"TAI YU\""
    },
    {
      "code" : "A025890216",
      "display" : "DICLOFENAC INJECTION 25MG/ML \"CYC\""
    },
    {
      "code" : "A025897216",
      "display" : "MUCOCIL INJECTION 100MG/ML (ACETYLCYSTEINE) \"GENTLE\""
    },
    {
      "code" : "A025900177",
      "display" : "ERYTHROMYCIN ESTOLATE POWDER FOR ORAL SUSPENSION 25MG/ML \"SINPHAR\""
    },
    {
      "code" : "A025900199",
      "display" : "ERYTHROMYCIN ESTOLATE POWDER FOR ORAL SUSPENSION 25MG/ML \"SINPHAR\""
    },
    {
      "code" : "A025902265",
      "display" : "MALTOSE INJECTION 10％"
    },
    {
      "code" : "A025902277",
      "display" : "MALTOSE INJECTION 10％"
    },
    {
      "code" : "A025905100",
      "display" : "KODAPIN F.C. TABLETS"
    },
    {
      "code" : "A025908209",
      "display" : "SENIDOL INJECTION 20MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A025908212",
      "display" : "SENIDOL INJECTION 20MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A025911100",
      "display" : "TAGAMET F.C. TABLETS 400MG (CIMETIDINE)"
    },
    {
      "code" : "A025918212",
      "display" : "DICYCLOMINE INJECTION 10MG/ML \"Y.Y.\""
    },
    {
      "code" : "A025921100",
      "display" : "REPRACON TABLETS 20MG (EPRAZINONE DIHYDROCHLORIDE)"
    },
    {
      "code" : "A025924100",
      "display" : "DAMIN CAPSULES 2MG (PRAZOSIN) \"S.C.\""
    },
    {
      "code" : "A025925100",
      "display" : "ANCOGEN TABLETS \"H.H.\""
    },
    {
      "code" : "A0259251G0",
      "display" : "ANCOGEN TABLETS \"H.H.\""
    },
    {
      "code" : "A025928100",
      "display" : "KALIDAN CAPSULES 25MG (ANETHOLE)"
    },
    {
      "code" : "A025937100",
      "display" : "COEN TABLETS 20MG \"YU SHENG\"(EPRAZINONE)"
    },
    {
      "code" : "A025939100",
      "display" : "ACETIN CAPSULES 200MG (ACETYLCYSTEINE) \"MAYER\""
    },
    {
      "code" : "A025941100",
      "display" : "DECAMIN TABLETS 4MG (CYPROHEPTADINE HCL)"
    },
    {
      "code" : "A025942100",
      "display" : "COMGAMET TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A025944100",
      "display" : "ESMYCIN F.C. TABLETS 250MG (ERYTHROMYCIN) \"W.P.\""
    },
    {
      "code" : "A025948121",
      "display" : "CYSTENON GRANULES 20MG/GM (ACETYLCYSTEINE) \"N.K.\""
    },
    {
      "code" : "A025949100",
      "display" : "CYPROHEPTADINE HCL TABLETS 4MG"
    },
    {
      "code" : "A025952100",
      "display" : "TIBIDIN TABLETS 500MG (TINIDAZOLE)"
    },
    {
      "code" : "A025956100",
      "display" : "NORETONE TABLETS 5MG (NORETHINDRONE ACETATE) \"SHIN FONG\""
    },
    {
      "code" : "A025959277",
      "display" : "CEFAZOLIN FOR INJECTION 500MG \"ORIENTAL\""
    },
    {
      "code" : "A025960100",
      "display" : "DEXCHLORPHENIRAMINE TABLETS"
    },
    {
      "code" : "A025961100",
      "display" : "WEIPERAN F.C. TABLETS"
    },
    {
      "code" : "A025963100",
      "display" : "DICLOREN E.C TABLETS 50MG (DICLOFENAC)"
    },
    {
      "code" : "A025965100",
      "display" : "SHYYLOUH TABLETS 25MG (SPIRONOLACTONE) \"Y.S.\""
    },
    {
      "code" : "A025967500",
      "display" : "PHEPIX VAGINAL SUPPOSITORY 150MG (ECONAZOLE)"
    },
    {
      "code" : "A025969421",
      "display" : "MESONE EYE SUSPENSION 1MG/ML (DEXAMETHASONE)\"GCPC\""
    },
    {
      "code" : "A025970100",
      "display" : "ULCERPIN TABLETS 25MG (PIRENZEPINE) \"GCPC\""
    },
    {
      "code" : "A025971100",
      "display" : "PIROXICAM CAPSULES 10MG \"Y.S.\""
    },
    {
      "code" : "A025973100",
      "display" : "TANDIN TABLETS 30MG \"Y.Y\" (IODOPROPYLIDENE GLYCEROL"
    },
    {
      "code" : "A025975100",
      "display" : "LYCOUGH CAPSULES \"M.S.\""
    },
    {
      "code" : "A025976100",
      "display" : "LYSOZYME CHLORIDE TABLETS 30MG \"PFOSHEN\""
    },
    {
      "code" : "A025977109",
      "display" : "AMOXICILLIN GRANULES 200MG/GM \"YUNG SHIN\""
    },
    {
      "code" : "A025977125",
      "display" : "AMOXICILLIN GRANULES 200MG/GM \"YUNG SHIN\""
    },
    {
      "code" : "A025977199",
      "display" : "AMOXICILLIN GRANULES 200MG/GM \"YUNG SHIN\""
    },
    {
      "code" : "A025979100",
      "display" : "PIROCAM CAPSULES 10MG (PIROXICAM)"
    },
    {
      "code" : "A025983277",
      "display" : "FRUCTOSE INJECTION 5％ \"CHI SHENG\""
    },
    {
      "code" : "A025985100",
      "display" : "SUDOGAN S.C. TABLETS \"CHEN TA\""
    },
    {
      "code" : "A025987100",
      "display" : "GASTROIE TABLETS 25MG \"CHEN TA\" (PIRENZEPINE)"
    },
    {
      "code" : "A025996289",
      "display" : "CEKONIN FOR INJECTION (CEFUROXIME)\"SWISS\""
    },
    {
      "code" : "A026002100",
      "display" : "CODEMIN CAPSULES \"S.T.\""
    },
    {
      "code" : "A026006100",
      "display" : "TETRACYCLINE HYDROCHLORIDE CAPSULES"
    },
    {
      "code" : "A026007100",
      "display" : "NOFLAGMA TABLETS 90MG (LYSOZYME) \"YUNG SHIN\""
    },
    {
      "code" : "A026008100",
      "display" : "PENSALINE S.C. TABLETS 25MG  \"S.T.\"(DIPYRIDAMOLE)"
    },
    {
      "code" : "A026010100",
      "display" : "PANACON RHINOLAX CAPSULES"
    },
    {
      "code" : "A026011100",
      "display" : "METHYLTESTOSTERONE S.C. TABLETS \"YU SHENG\""
    },
    {
      "code" : "A026012100",
      "display" : "SHULYLA TABLETS"
    },
    {
      "code" : "A026013100",
      "display" : "BOURKON TABLETS 10MG (RIBOFLAVIN) \"K.B.\""
    },
    {
      "code" : "A026016109",
      "display" : "COSTAN GRANULES 100MG/GM (EPRAZINONE HCL) \"S.T.\""
    },
    {
      "code" : "A026016177",
      "display" : "COSTAN GRANULES 100MG/GM (EPRAZINONE HCL) \"S.T.\""
    },
    {
      "code" : "A026016199",
      "display" : "COSTAN GRANULES 100MG/GM (EPRAZINONE HCL) \"S.T.\""
    },
    {
      "code" : "A026018100",
      "display" : "GASDIMET TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A026019100",
      "display" : "CHLORPHENIRAMINE MALEATE TABLETS 4MG"
    },
    {
      "code" : "A026021212",
      "display" : "ANTISAMIN INJECTION 100MG/ML (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026021214",
      "display" : "ANTISAMIN INJECTION 100MG/ML (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026021221",
      "display" : "ANTISAMIN INJECTION 100MG/ML (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026022100",
      "display" : "KEJIME ANTHELMINTIC TABLETS 100MG \"Y.S.\""
    },
    {
      "code" : "A026025100",
      "display" : "BININ F.C. TABLETS"
    },
    {
      "code" : "A026026100",
      "display" : "TRAXEMIN CAPSULES 250MG (TRANEXAMIC ACID) \"CHEN TA\""
    },
    {
      "code" : "A026027100",
      "display" : "HEMIDOL TABLETS 2.5MG (INDAPAMIDE)"
    },
    {
      "code" : "A026028238",
      "display" : "CONBIHOL INJECTION \"LITA\""
    },
    {
      "code" : "A026032100",
      "display" : "ALMEDOPA TABLETS 250MG (L-ALPHA-METHYL DOPA) \"UNION\""
    },
    {
      "code" : "A026033100",
      "display" : "SORIN TABLETS 20MG (EPRAZINONE) \"LITA\""
    },
    {
      "code" : "A026039100",
      "display" : "LOPERAMIDE CAPSULES 2MG"
    },
    {
      "code" : "A026041100",
      "display" : "CHUSELIN CAPSULES 250MG (TRANEXAMIC ACID) \"Y.S.\""
    },
    {
      "code" : "A026043100",
      "display" : "MOJUNE TABLETS 25MG (DIPHENIDOL) \"K.B.\""
    },
    {
      "code" : "A026045100",
      "display" : "CEFADROXIL CAPSULES 500MG \"Y.C.\""
    },
    {
      "code" : "A026046100",
      "display" : "SUSOUCON TABLETS 15MG"
    },
    {
      "code" : "A026056100",
      "display" : "A.T. TABLETS 500MG (ACETAMINOPHEN) \"LITA\""
    },
    {
      "code" : "A026058209",
      "display" : "ALLERMIN INJECTION 3MG/ML (PIPRINHYDRINATE)\"Y.Y.\""
    },
    {
      "code" : "A026060100",
      "display" : "CHANDARLING CAPSULES 100MG (DL-ALPHA-TOCOPHEROL NICOTINATE)\"Y.S.\""
    },
    {
      "code" : "A026062100",
      "display" : "SUIT CAPSULES 20MG (PIROXICAM) \"KINK\""
    },
    {
      "code" : "A026067100",
      "display" : "OLUPENT TABLETS 20MG \"C.H.\" (ORCIPRENALINE)"
    },
    {
      "code" : "A026072100",
      "display" : "CINOPAL*F.C. TABLETS 200MG (FENBUFEN)"
    },
    {
      "code" : "A026073100",
      "display" : "COBACIDE TABLETS"
    },
    {
      "code" : "A026078100",
      "display" : "NOSEMIN TABLETS"
    },
    {
      "code" : "A026079100",
      "display" : "BROMAZIN TABLETS 6MG (BROMAZEPAM)"
    },
    {
      "code" : "A026080100",
      "display" : "BROMAZIN TABLETS 3MG \"Johnson\"(BROMAZEPAM)"
    },
    {
      "code" : "A026082212",
      "display" : "KACILEN INJECTION"
    },
    {
      "code" : "A026082238",
      "display" : "KACILEN INJECTION"
    },
    {
      "code" : "A026082255",
      "display" : "KACILEN INJECTION"
    },
    {
      "code" : "A026084100",
      "display" : "COTRAN TABLETS 4MG (SALBUTAMOL) \"YU SHENG\""
    },
    {
      "code" : "A026086100",
      "display" : "YI-CO TABLETS 20MG (EPRIAZINONE HYDROCHLORIDE) \"K.B.\""
    },
    {
      "code" : "A026089100",
      "display" : "SU-FU-DOU TABLETS 500MG (TINIDAZOLE)\"M.T.\""
    },
    {
      "code" : "A026090100",
      "display" : "NAPROXEN TABLETS 250MG \"N.C.P\""
    },
    {
      "code" : "A026093100",
      "display" : "TRANEXAMIC ACID 500MG TABLETS \"C.L.\""
    },
    {
      "code" : "A026098100",
      "display" : "LOPERAMIDE CAPSULES 2MG \"ASTAR\""
    },
    {
      "code" : "A026101100",
      "display" : "WEICOULIN TABLETS \"K.S.\""
    },
    {
      "code" : "A026102100",
      "display" : "IBUPROFEN CAPSULES 200MG"
    },
    {
      "code" : "A026103100",
      "display" : "BISUTON CAPSULES \"C.M.\""
    },
    {
      "code" : "A026105100",
      "display" : "ELISTIN TABLETS 1.5MG \"STANDARD\" (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A026106100",
      "display" : "DICLOFENAC ENTERIC SUGAR COATED TABLETS 25MG \"Y.S.\""
    },
    {
      "code" : "A026107100",
      "display" : "ASTHMA TABLETS \"MAYER\""
    },
    {
      "code" : "A026113100",
      "display" : "LOLICON TABLETS \"F.S.\""
    },
    {
      "code" : "A026114100",
      "display" : "EMODINE CAPSULES"
    },
    {
      "code" : "A026115100",
      "display" : "IRIDINE CAPSULES 2MG (LOPERAMIDE) \"Y.S.\""
    },
    {
      "code" : "A026118209",
      "display" : "SOON INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A026121100",
      "display" : "COBICIN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A026123157",
      "display" : "ANTICA SYRUP"
    },
    {
      "code" : "A026123199",
      "display" : "ANTICA SYRUP"
    },
    {
      "code" : "A026124100",
      "display" : "GAWEI TABLETS 200MG \"YU SHENG\"(CIMETIDINE)"
    },
    {
      "code" : "A0261241G0",
      "display" : "GAWEI TABLETS 200MG \"YU SHENG\"(CIMETIDINE)"
    },
    {
      "code" : "A026125100",
      "display" : "NASOL CAPSULES \"M.S.\""
    },
    {
      "code" : "A026127100",
      "display" : "NAPOXEN TABLETS 250MG"
    },
    {
      "code" : "A026128340",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128348",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128363",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128365",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128371",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128377",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026128399",
      "display" : "SULFASIL CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A026131100",
      "display" : "TAWEMET TABLETS"
    },
    {
      "code" : "A026133100",
      "display" : "SUCAFATE TABLETS 500MG (BASIC ALUMINUM SUCROSE SULFATE)"
    },
    {
      "code" : "A026136100",
      "display" : "POMIAN CAPSULES"
    },
    {
      "code" : "A026138100",
      "display" : "TOLPERISONE TABLETS 100MG \"S.C.\""
    },
    {
      "code" : "A026143100",
      "display" : "SOOTRAN TABLETS \"CHEN TA\""
    },
    {
      "code" : "A026144100",
      "display" : "CLONIDINE TABLETS 0.15MG \"C.H.\""
    },
    {
      "code" : "A026153100",
      "display" : "EMOSE CAPSULES 2MG (LOPERAMIDE)"
    },
    {
      "code" : "A026154100",
      "display" : "BUDEMA TABLETS 1MG \"CHEN TA\" (BUMETANIDE)"
    },
    {
      "code" : "A026155329",
      "display" : "ECONAT CREAM \"WINSTON\""
    },
    {
      "code" : "A026155372",
      "display" : "ECONAT CREAM \"WINSTON\""
    },
    {
      "code" : "A026155399",
      "display" : "ECONAT CREAM \"WINSTON\""
    },
    {
      "code" : "A026157100",
      "display" : "DE-PAIN TABLETS 20MG (DIMETHOTHIAZINE) \"S.C.\""
    },
    {
      "code" : "A026158100",
      "display" : "BRISCOL TABLETS 25MG \"H.S.\""
    },
    {
      "code" : "A026162100",
      "display" : "LISEMIN CAPSULES 250MG (TRANEXAMIC ACID) \"C.M"
    },
    {
      "code" : "A026164100",
      "display" : "ASPIRIN CAFFEINE TABLETS \"LITA\""
    },
    {
      "code" : "A026165229",
      "display" : "DEXAMETHASONE INJECTION"
    },
    {
      "code" : "A026171100",
      "display" : "SEDES-A TABLETS"
    },
    {
      "code" : "A026173212",
      "display" : "TRANEXAMIC ACID INJECTION 50MG \"TAI YU\""
    },
    {
      "code" : "A026173221",
      "display" : "TRANEXAMIC ACID INJECTION 50MG \"TAI YU\""
    },
    {
      "code" : "A026175100",
      "display" : "URODINE F.C. TABLETS 100MG \"T.F.\""
    },
    {
      "code" : "A026176100",
      "display" : "PESUGEN CAPSULES 10MG (PIROXICAM) \"S.T.\""
    },
    {
      "code" : "A026177329",
      "display" : "SMELON CREAM \"Y.K.\""
    },
    {
      "code" : "A026177372",
      "display" : "SMELON CREAM \"Y.K.\""
    },
    {
      "code" : "A026177399",
      "display" : "SMELON CREAM \"Y.K.\""
    },
    {
      "code" : "A026185100",
      "display" : "METHINOL TABLETS 500MG \" PANBIOTIC \""
    },
    {
      "code" : "A026188100",
      "display" : "WINPRESS TABLETS 0.15MG (CLONIDINE) \"WINSTON\""
    },
    {
      "code" : "A026189100",
      "display" : "PIMILAM CAPSULES \"T.L.\""
    },
    {
      "code" : "A026192100",
      "display" : "AMPICILLIN CAPSULES 500MG \"Y.Y.\""
    },
    {
      "code" : "A026195100",
      "display" : "TANCOCIN TABLETS 200MG (GLYCEROL GUAIACOLATE)\"F.S.\""
    },
    {
      "code" : "A026199100",
      "display" : "RIVAPRESS TABLETS 250MG (METHYLDOPA) \"PANBIOTIC\""
    },
    {
      "code" : "A026205100",
      "display" : "SULFAMETHOXAZOLE TABLETS 500MG \"SPC\""
    },
    {
      "code" : "A026208212",
      "display" : "TIOPRONIN INJECTION 50MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A026208221",
      "display" : "TIOPRONIN INJECTION 50MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A026209100",
      "display" : "AZUMOL TABLETS 2MG (GUAIAZULENE) \"EAYUNG\""
    },
    {
      "code" : "A026225100",
      "display" : "ATHEROSIN F.C. TABLETS 250MG (PYRIDINOL CARBAMATE) \"W.P.\""
    },
    {
      "code" : "A026228500",
      "display" : "ECONAZOLE VAGINAL SUPPOSITORY 50MG \"SINPHAR\""
    },
    {
      "code" : "A026231421",
      "display" : "SHINOLON ORABASE 1MG/GM (TRIAMCINOLONE ACETONIDE) \"SHITEH\""
    },
    {
      "code" : "A026232421",
      "display" : "CARBOXE ORABASE 20MG (CARBENOXOLONE) \"SHITEH\""
    },
    {
      "code" : "A026233100",
      "display" : "FLUNAZON CAPSULES 5MG \"N.K.\""
    },
    {
      "code" : "A026234100",
      "display" : "KANEZIN VAGINAL TABLETS 100MG \"SWISS\" (CLOTRIMAZOLE)"
    },
    {
      "code" : "A026234500",
      "display" : "KANEZIN VAGINAL TABLETS 100MG \"SWISS\" (CLOTRIMAZOLE)"
    },
    {
      "code" : "A026243100",
      "display" : "LICOLIN CAPSULES 2MG (LOPERAMIDE) \"SINTON\""
    },
    {
      "code" : "A026244212",
      "display" : "VANINE INJECTION 5MG/ML \"METRO\""
    },
    {
      "code" : "A026251200",
      "display" : "ESTRADIOL BENZOATE INJECTION 5MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026251209",
      "display" : "ESTRADIOL BENZOATE INJECTION 5MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026251229",
      "display" : "ESTRADIOL BENZOATE INJECTION 5MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026256100",
      "display" : "FUTON E.C. TABLETS 25MG"
    },
    {
      "code" : "A0262561G0",
      "display" : "FUTON E.C. TABLETS 25MG"
    },
    {
      "code" : "A026257100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"Y.C.\""
    },
    {
      "code" : "A026259100",
      "display" : "TININ TABLETS 500MG (TINIDAZOLE) \"S.C.\""
    },
    {
      "code" : "A026261100",
      "display" : "Soprinol Tablets ''H.S.''"
    },
    {
      "code" : "A026263100",
      "display" : "VIRUX TABLETS 500MG (METHISOPRINOL)"
    },
    {
      "code" : "A026265209",
      "display" : "AVTON INJECTION \"N.K.\"20MG/ML (NEFOPAM)"
    },
    {
      "code" : "A026266209",
      "display" : "ANOPAIN INJECTION 20MG/ML (NEFOPAM) \"GENTLE\""
    },
    {
      "code" : "A026269209",
      "display" : "KETOPEN INJECTION 20MG/ML (NEFOPAM)"
    },
    {
      "code" : "A026270209",
      "display" : "KOLIPAN INJECTION 20MG/ML (MEFOPAM)\"S.T.\""
    },
    {
      "code" : "A026272100",
      "display" : "CAPAIN F.C. TABLETS 30MG (NEFOPAM)"
    },
    {
      "code" : "A026273209",
      "display" : "ACUPAINLEX INJECTION 20MG/ML (NEFOPAM) \"PANBIOTIC\""
    },
    {
      "code" : "A026275209",
      "display" : "Stopain Injection 20mg/ml \"T.F.\""
    },
    {
      "code" : "A026276100",
      "display" : "LYSOZYME CAPSULES 90MG \"T.F.\""
    },
    {
      "code" : "A026277100",
      "display" : "MONSTAN TABLETS 250MG"
    },
    {
      "code" : "A026278100",
      "display" : "NOSCAPINE TABLETS 15MG \"SINPHAR\""
    },
    {
      "code" : "A026280100",
      "display" : "EACOUG TABLETS 20MG \"N.C.P.\" (EPRAZINONE HCL)"
    },
    {
      "code" : "A026281100",
      "display" : "CHI-BIOTIN TABLETS"
    },
    {
      "code" : "A026284100",
      "display" : "CEPIN TABLETS 25MG (DIPHENIDOL) \"SPC\""
    },
    {
      "code" : "A026287100",
      "display" : "Noma Tablets \"H.S.\""
    },
    {
      "code" : "A026289100",
      "display" : "P.P.C. CAPSULES"
    },
    {
      "code" : "A026293100",
      "display" : "FONGANSOPIN CAPSULES \"C.T.\""
    },
    {
      "code" : "A026299100",
      "display" : "TSUFONLOL TABLETS \"S.T.\""
    },
    {
      "code" : "A026301100",
      "display" : "SEROTON S.C. TABLETS 20MG \"SHIN FONG\""
    },
    {
      "code" : "A026303100",
      "display" : "ZUCERINE TABLETS 250MG (TRANEXAMIC ACID) \"LITA\""
    },
    {
      "code" : "A026308321",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308340",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308348",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308365",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308372",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308377",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026308399",
      "display" : "CANFLAME CREAM \"WINSTON\""
    },
    {
      "code" : "A026314100",
      "display" : "FUROKAN CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A026319212",
      "display" : "DICYCLOMINE HCL INJECTION 10MG/ML \"S.Y.\""
    },
    {
      "code" : "A026322216",
      "display" : "Difenac Injection 25mg/ml \"K.S.\""
    },
    {
      "code" : "A026323100",
      "display" : "A.H. BUTON TABLETS 500MG \"YU SHENG\""
    },
    {
      "code" : "A026324100",
      "display" : "PIROCAM CAPSULES 10MG (PIROXICAM)\"M.T.\""
    },
    {
      "code" : "A0263241G0",
      "display" : "PIROCAM CAPSULES 10MG (PIROXICAM)\"M.T.\""
    },
    {
      "code" : "A026327100",
      "display" : "Anti-Cough NDX Capsules \"M.D.\""
    },
    {
      "code" : "A026328100",
      "display" : "NEWMAZOLE TABLETS 10MG (CARBIMAZOLE)"
    },
    {
      "code" : "A0263281G0",
      "display" : "NEWMAZOLE TABLETS 10MG (CARBIMAZOLE)"
    },
    {
      "code" : "A026329100",
      "display" : "AMMONIUM CHLORIDE E.F.C. TABLETS 500MG \"W.P.\""
    },
    {
      "code" : "A026330100",
      "display" : "TRANEXAM TABLETS 250MG (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026338329",
      "display" : "CEFUL CREAM \"S.C.\""
    },
    {
      "code" : "A026339100",
      "display" : "YOURGEN TABLETS"
    },
    {
      "code" : "A026341212",
      "display" : "PINTAN INJECTION 2MG/ML \"METRO\""
    },
    {
      "code" : "A026343321",
      "display" : "ECONOL CREAM 1％ (ECONAZOLE) \"GCPC\""
    },
    {
      "code" : "A026343329",
      "display" : "ECONOL CREAM 1％ (ECONAZOLE) \"GCPC\""
    },
    {
      "code" : "A026343377",
      "display" : "ECONOL CREAM 1％ (ECONAZOLE) \"GCPC\""
    },
    {
      "code" : "A026343399",
      "display" : "ECONOL CREAM 1％ (ECONAZOLE) \"GCPC\""
    },
    {
      "code" : "A0263433B9",
      "display" : "ECONOL CREAM 1％ (ECONAZOLE) \"GCPC\""
    },
    {
      "code" : "A026346100",
      "display" : "BIMINING TABLETS \"Y.S.\""
    },
    {
      "code" : "A026348100",
      "display" : "NIFEPINE CAPSULES 10MG (NIFEDIPINE) \"S.T.\""
    },
    {
      "code" : "A026349118",
      "display" : "ALLERGNON ELIXIR \"Y.Y\""
    },
    {
      "code" : "A026349157",
      "display" : "ALLERGNON ELIXIR \"Y.Y\""
    },
    {
      "code" : "A026356100",
      "display" : "WINCEF CAPSULES 500MG (CEFADROXIL) \"WINSTON\""
    },
    {
      "code" : "A026357265",
      "display" : "DEXTROSE-SALINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A026357277",
      "display" : "DEXTROSE-SALINE INJECTION \"TAI YU\""
    },
    {
      "code" : "A026361100",
      "display" : "PIROCAM CAPSULES 10MG"
    },
    {
      "code" : "A026363100",
      "display" : "MUSCONE TABLETS 50MG (TOPERISONE) \"SHIN FONG\""
    },
    {
      "code" : "A026365100",
      "display" : "ENODONE TABLETS \"W.P.\""
    },
    {
      "code" : "A026369100",
      "display" : "WAROMOM F.C. TABLETS 5MG (FLUOXYMESTERONE) \"W.P.\""
    },
    {
      "code" : "A026372100",
      "display" : "SINLAX TABLETS 100MG (CHLORMEZANONE) \"SINPHAR\""
    },
    {
      "code" : "A026374100",
      "display" : "NAPROXEN TABLETS 250MG \"Y.Y.\""
    },
    {
      "code" : "A026377100",
      "display" : "COUTON TABLETS \"M.S.\""
    },
    {
      "code" : "A026380216",
      "display" : "FORMIN INJECTION 25MG/ML (DICLOFENAC) \"PZNBIOTIC\""
    },
    {
      "code" : "A026384100",
      "display" : "REUCAM CAPSULES 10MG (PIROXICAM) \"WINSTON\""
    },
    {
      "code" : "A026385100",
      "display" : "NEFOPAM TABLETS 30MG \"S.D.\""
    },
    {
      "code" : "A026390100",
      "display" : "ANTIEXPECT TABLETS 20MG \"JINUP\" (EPRAZINONE HCL)"
    },
    {
      "code" : "A026400265",
      "display" : "TBC NO.2 INJECTION"
    },
    {
      "code" : "A026400277",
      "display" : "TBC NO.2 INJECTION"
    },
    {
      "code" : "A026401265",
      "display" : "TBC No.4 Injection"
    },
    {
      "code" : "A026401277",
      "display" : "TBC No.4 Injection"
    },
    {
      "code" : "A026402265",
      "display" : "TBC No.3 Injection"
    },
    {
      "code" : "A026402277",
      "display" : "TBC No.3 Injection"
    },
    {
      "code" : "A026405100",
      "display" : "RELIZINE TABLETS \"S.C.\""
    },
    {
      "code" : "A026407100",
      "display" : "DIUREN TABLETS \"GCPC\""
    },
    {
      "code" : "A026409100",
      "display" : "COSUGAR TABLETS 5MG (GLIBENCLAMIDE)"
    },
    {
      "code" : "A026410216",
      "display" : "DICLODENAC INJECTION 25MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026412214",
      "display" : "BIOSAREN INJECTION 100MG/ML (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026412221",
      "display" : "BIOSAREN INJECTION 100MG/ML (TRANEXAMIC ACID)"
    },
    {
      "code" : "A026416118",
      "display" : "KODER-G SYRUP \"STANDARD\""
    },
    {
      "code" : "A026416199",
      "display" : "KODER-G SYRUP \"STANDARD\""
    },
    {
      "code" : "A026420265",
      "display" : "TBC NO.1 INJECTION"
    },
    {
      "code" : "A026420277",
      "display" : "TBC NO.1 INJECTION"
    },
    {
      "code" : "A026425100",
      "display" : "ININ TABLETS 2MG \"YU SHENG\""
    },
    {
      "code" : "A026428100",
      "display" : "PERTANZIN TABLETS 5MG (GLIBENCLAMIDE) \"S.T.\""
    },
    {
      "code" : "A026430100",
      "display" : "METICON-A CAPSULES \"K.S.\""
    },
    {
      "code" : "A026439100",
      "display" : "Lonfadroxil Capsules 500 mg"
    },
    {
      "code" : "A026440100",
      "display" : "ERGOTIN TABLETS 1.5MG \"C.H.\" (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A026441277",
      "display" : "RINGER'S SOLUTION \"S.H.\""
    },
    {
      "code" : "A026442100",
      "display" : "Anpin Capsules 15mg(Seaprose-S)"
    },
    {
      "code" : "A026445209",
      "display" : "ANWINTO INJECTION 50MG/ML \"T.F.\""
    },
    {
      "code" : "A026447212",
      "display" : "WINACORT INJECTION 40MG/ML (TRIAMCINOLONE ACETONIDE) \"WINSTON\""
    },
    {
      "code" : "A026447221",
      "display" : "WINACORT INJECTION 40MG/ML (TRIAMCINOLONE ACETONIDE) \"WINSTON\""
    },
    {
      "code" : "A026448216",
      "display" : "DICLOFEN INJECTION 25MG/ML (DICLOFENAC) \"CHI SHENG\""
    },
    {
      "code" : "A026454100",
      "display" : "DEASTHMA TABLETS 2.5MG (FENOTEROL) \"S.T.\""
    },
    {
      "code" : "A026456100",
      "display" : "UPANTA TABLETS 25MG (BUCLIZINE) \"JINUP\""
    },
    {
      "code" : "A026457100",
      "display" : "DIMELON TABLETS 20MG (DIMETHOTHIAZINE) \"H.H.\""
    },
    {
      "code" : "A026461100",
      "display" : "PIROXIM CAPSULES 20MG  \"STANDARD\" (PIROXICAM)"
    },
    {
      "code" : "A026462209",
      "display" : "PROGESTERONE INJECTION 50MG/ML \"TAI YU\""
    },
    {
      "code" : "A026462229",
      "display" : "PROGESTERONE INJECTION 50MG/ML \"TAI YU\""
    },
    {
      "code" : "A026465100",
      "display" : "UPMIDIC TABLETS 250MG (PIPEMIDIC ACID) \"JINUP\""
    },
    {
      "code" : "A026467100",
      "display" : "CIYANLIN TABLETS 200MG (CIMETIDINE) \"S.T.\""
    },
    {
      "code" : "A026468429",
      "display" : "PILOCARPINE HCL OPHTHALMIC SOLUTION 2％ \"WU-FU\""
    },
    {
      "code" : "A026472100",
      "display" : "FEREN CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A026476100",
      "display" : "EPRACOUGH TABLETS 20MG (EPRAZINONE HCL)\"HONTEN\""
    },
    {
      "code" : "A026478100",
      "display" : "NABERINE CAPSULES \"MAY SEE\""
    },
    {
      "code" : "A026484100",
      "display" : "SOCHIN TABLETS \"M.S.\""
    },
    {
      "code" : "A026485212",
      "display" : "ASCORBIC ACID INJECTION 250MG/ML \"S.Y.\""
    },
    {
      "code" : "A026485221",
      "display" : "ASCORBIC ACID INJECTION 250MG/ML \"S.Y.\""
    },
    {
      "code" : "A026485238",
      "display" : "ASCORBIC ACID INJECTION 250MG/ML \"S.Y.\""
    },
    {
      "code" : "A026487100",
      "display" : "LONFADROXIL CAPSULES 250MG (CEFADROXIL) \"UNION\""
    },
    {
      "code" : "A026489209",
      "display" : "NEFOPAM INJECTION 20MG/ML \"S.Y.\""
    },
    {
      "code" : "A026490100",
      "display" : "PITA-E. S.C. TABLETS 100MG (DL-ALPHA-TOCOPHEROL ACETATE) \"PRINCE\""
    },
    {
      "code" : "A026491100",
      "display" : "PITON CAPSULES 10MG (PIROXICAM) \"N.C.P.\""
    },
    {
      "code" : "A026499100",
      "display" : "DICLOFENAC TABLETS 25MG \"L.L.\""
    },
    {
      "code" : "A026500100",
      "display" : "BOLTONIN TABLETS 25MG (DICLOFENAC) \"CHI SHENG"
    },
    {
      "code" : "A026503229",
      "display" : "POTASSIUM CHLORIDE INJECTION 150MG/ML \"S.H.\""
    },
    {
      "code" : "A026504123",
      "display" : "LYSOZYME GRANULE FOR ORAL SYRUP 10％ \"SINPHAR\""
    },
    {
      "code" : "A026506212",
      "display" : "CIMEWEI INJECTION 100MG/ML (CIMETIDINE) \"LITA"
    },
    {
      "code" : "A026509277",
      "display" : "LONFAMANDOLE INJECTIN 500MG (CEFAMANDOLE)\"UNION\""
    },
    {
      "code" : "A026511100",
      "display" : "LICOU TABLETS \"S.Y.\""
    },
    {
      "code" : "A026514209",
      "display" : "ANTON INJECTION 20MG/ML \"Honten\""
    },
    {
      "code" : "A026521100",
      "display" : "SUNCIN TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A026523500",
      "display" : "ASPIRIN SUPPOSITORY 200MG \"TAI YU\""
    },
    {
      "code" : "A026523563",
      "display" : "ASPIRIN SUPPOSITORY 200MG \"TAI YU\""
    },
    {
      "code" : "A026526100",
      "display" : "DOGMATYL F.C. TABLETS 50MG (SULPIRIDE)"
    },
    {
      "code" : "A026530100",
      "display" : "MENDAZE TABLETS 100MG (MEBENDAZOLE) \"SHITEH\""
    },
    {
      "code" : "A026532100",
      "display" : "BECTON F.C. TABLETS \"W.P.\""
    },
    {
      "code" : "A026533100",
      "display" : "FUTON TABLETS 30MG \"K.S.\"(NEFOPAM)"
    },
    {
      "code" : "A026535209",
      "display" : "SINFLIN INJECTION 1GM (CEPHALOTHIN) \"SINPHAR\""
    },
    {
      "code" : "A026543100",
      "display" : "PIPEDIC TABLETS 250MG (PIPEMIDIC ACID) \"HONTEN\""
    },
    {
      "code" : "A026545238",
      "display" : "KANACLINE INJECTION 250MG/ML \"SHITEH\" (KANAMYCIN)"
    },
    {
      "code" : "A026547100",
      "display" : "KOPIDIN TABLETS \"CHEN TA\""
    },
    {
      "code" : "A026549100",
      "display" : "KOUMIN TABLETS 2MG"
    },
    {
      "code" : "A026550100",
      "display" : "LYSOZYME TABLETS 90MG \"W.P.\""
    },
    {
      "code" : "A026551121",
      "display" : "FLUTAFIN GRANULES 20MG/GM \"SHITEH\" (ACETYLCYSTEINE)"
    },
    {
      "code" : "A026552212",
      "display" : "HYCOMIN-S INJECTION 5MG/ML \"S.Y.\"(HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A026554321",
      "display" : "STADERM CREAM \"STANDARD\""
    },
    {
      "code" : "A026554329",
      "display" : "STADERM CREAM \"STANDARD\""
    },
    {
      "code" : "A026554335",
      "display" : "STADERM CREAM \"STANDARD\""
    },
    {
      "code" : "A026554372",
      "display" : "STADERM CREAM \"STANDARD\""
    },
    {
      "code" : "A026554399",
      "display" : "STADERM CREAM \"STANDARD\""
    },
    {
      "code" : "A026556100",
      "display" : "SULFINPYRAZONE CAPSULES 100MG \"S.C.\""
    },
    {
      "code" : "A026557277",
      "display" : "CEFAZOLIN FOR INJECTION 500MG \"SINTON\""
    },
    {
      "code" : "A026559100",
      "display" : "DELAMIN TABLETS 2MG \"STANDARD\" (DEXCHLORPHENIRAMINE MALEATE)"
    },
    {
      "code" : "A026560212",
      "display" : "NEOTUSIN INJECTION"
    },
    {
      "code" : "A026562212",
      "display" : "NURODIN INJECTION 150MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A026563500",
      "display" : "FASTIN VAGINAL TABLETS 200MG (CLOTRIMAZOLE)"
    },
    {
      "code" : "A026566100",
      "display" : "TONLIPIN TABLETS 20MG (DIMETHOTHIAZINE)"
    },
    {
      "code" : "A026572212",
      "display" : "HYDROXOBAM INJECTION 2.5MG/ML (HYDROXOCOBALAMIN) \"TAI YU\""
    },
    {
      "code" : "A026572229",
      "display" : "HYDROXOBAM INJECTION 2.5MG/ML (HYDROXOCOBALAMIN) \"TAI YU\""
    },
    {
      "code" : "A026573209",
      "display" : "Hycomine Injection 5mg/ml"
    },
    {
      "code" : "A026573212",
      "display" : "Hycomine Injection 5mg/ml"
    },
    {
      "code" : "A026576209",
      "display" : "HI-OHB12 INJECTION 5MG/ML (HYDROXOCOBALAMIN)\"GENTLE\""
    },
    {
      "code" : "A026583100",
      "display" : "TIBICAN TABLETS 500MG (TINIDAZOLE)"
    },
    {
      "code" : "A026586100",
      "display" : "LANCAN S.C. TABLETS 100MG (TIOPRONIN)"
    },
    {
      "code" : "A026588100",
      "display" : "SPAGASGEL TABLETS"
    },
    {
      "code" : "A026595100",
      "display" : "NONANTICOLD S.C. TABLETS"
    },
    {
      "code" : "A026604429",
      "display" : "PILOCARPINE OPHTHALMIC SOLUTION 1％ \"WU-FU\""
    },
    {
      "code" : "A026613100",
      "display" : "NIDOMATE CAPSULES 10MG (NIFEDIPINE) \"H.H.\""
    },
    {
      "code" : "A026630100",
      "display" : "CARBO CAPSULES 375MG (CARBOCISTEINE)\"M.S.\""
    },
    {
      "code" : "A026631209",
      "display" : "Lonfamandole powder for Injection 1g \"Union\" (Cefamandole)"
    },
    {
      "code" : "A026633229",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION 300MG/ML\"ASTAR\""
    },
    {
      "code" : "A026633238",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION 300MG/ML\"ASTAR\""
    },
    {
      "code" : "A026633299",
      "display" : "LINCOMYCIN HYDROCHLORIDE INJECTION 300MG/ML\"ASTAR\""
    },
    {
      "code" : "A026636321",
      "display" : "ULEX CREAM \"SINPHAR\""
    },
    {
      "code" : "A026636329",
      "display" : "ULEX CREAM \"SINPHAR\""
    },
    {
      "code" : "A026636372",
      "display" : "ULEX CREAM \"SINPHAR\""
    },
    {
      "code" : "A026636399",
      "display" : "ULEX CREAM \"SINPHAR\""
    },
    {
      "code" : "A026642212",
      "display" : "BROMHEXINE INJECTION 2MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026643100",
      "display" : "RESPININE TABLETS 30MG \"H.L.\""
    },
    {
      "code" : "A026644100",
      "display" : "DICOK E.C. TABLETS 25MG (DICLOFENAC)\"M.T.\""
    },
    {
      "code" : "A0266441G0",
      "display" : "DICOK E.C. TABLETS 25MG (DICLOFENAC)\"M.T.\""
    },
    {
      "code" : "A026646100",
      "display" : "GLICON TABLETS 5MG (GLIBENCLAMIDE)"
    },
    {
      "code" : "A026647100",
      "display" : "WEISU-S TABLETS \"S.Y.\""
    },
    {
      "code" : "A026648100",
      "display" : "SIDOZINE TABLETS 5MG (TRIFLUOPERAZINE HCL) \"SHITEH\""
    },
    {
      "code" : "A026649100",
      "display" : "HELOSON CAPSULES (ERYTHROMYCIN) \"HEALTH\""
    },
    {
      "code" : "A026651100",
      "display" : "WEISU TABLETS \"S.Y.\""
    },
    {
      "code" : "A026653100",
      "display" : "DIFENA ENTERIC F.C. TABLETS 25MG (DICLOFENAC) \"STANDARD\""
    },
    {
      "code" : "A026661100",
      "display" : "BETASONE TABLETS 0.5MG (BETAMETHASONE)\"Y.Y.\""
    },
    {
      "code" : "A026664229",
      "display" : "PAMCL INJECTION 50MG/ML \"ORIENTAL\""
    },
    {
      "code" : "A026673100",
      "display" : "RESPIRID CAPSULES 40MG \"SHIN FONG\""
    },
    {
      "code" : "A026675277",
      "display" : "MALTON INFUSION 10％ (MALTOSE)"
    },
    {
      "code" : "A026676100",
      "display" : "ARTHRICID TABLETS 100MG (SULINDAC) \"SHIN FONG\""
    },
    {
      "code" : "A026677100",
      "display" : "SULINDEC TABLETS 200MG \"T.F.\""
    },
    {
      "code" : "A026678100",
      "display" : "SULINDAC TABLETS 100MG \"W.P.\""
    },
    {
      "code" : "A026679100",
      "display" : "SULIC TABLETS 200MG (SULINDAC)"
    },
    {
      "code" : "A026681100",
      "display" : "TUSUTON TABLETS 100MG (SULINDAC)"
    },
    {
      "code" : "A026682100",
      "display" : "KORES TABLETS 200MG (SULINDAC)\"M.T.\""
    },
    {
      "code" : "A026683100",
      "display" : "SULINDA TABLETS 100MG (SULINDAC)"
    },
    {
      "code" : "A026686209",
      "display" : "LICOPAM INJECTION 20MG/ML (NEFOPAM)\"Y.Y.\""
    },
    {
      "code" : "A026703338",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703340",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703348",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703363",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703365",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703371",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703372",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703377",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026703399",
      "display" : "SILVA-SULFA 1％ CREAM (SILVER SULFADIAZINE) \"GCPC\""
    },
    {
      "code" : "A026707100",
      "display" : "NAPOSIN TABLETS 500MG (NAPROXEN)"
    },
    {
      "code" : "A026710277",
      "display" : "VITAPLEX-B INJECTION \"S.Y.\""
    },
    {
      "code" : "A026711100",
      "display" : "TANNALBIN TABLETS 500MG \"SYNMOSA\""
    },
    {
      "code" : "A026717100",
      "display" : "MUCO CAPSULES 375MG \"PATRON\" (CARBOCISTEINE)"
    },
    {
      "code" : "A026722277",
      "display" : "CEFADOLE FOR INJECTION 500MG (CEFAMANDOL) \"WINSTON\""
    },
    {
      "code" : "A026724100",
      "display" : "ANTIDIARRHEAL TABLETS \"C.S.\""
    },
    {
      "code" : "A026728100",
      "display" : "ZONON E.S.C. TABLETS 50MG (BROMELAIN) \"C.A.\""
    },
    {
      "code" : "A026736100",
      "display" : "UNICOL TABLETS 250MG (PIPEMIDIC ACID)"
    },
    {
      "code" : "A026737100",
      "display" : "VITAMIN E CAPSULES 100MG"
    },
    {
      "code" : "A026738238",
      "display" : "POTASSIUM CHLORIDE INJECTION \"GCPC\""
    },
    {
      "code" : "A026741100",
      "display" : "DAMIN TABLETS 1MG (PRAZOSIN)"
    },
    {
      "code" : "A0267411G0",
      "display" : "DAMIN TABLETS 1MG (PRAZOSIN)"
    },
    {
      "code" : "A026742100",
      "display" : "UCOL TABLETS"
    },
    {
      "code" : "A026747500",
      "display" : "ACETA SUPPOSITORY 100MG\"P.L.\""
    },
    {
      "code" : "A026750100",
      "display" : "RIFAINA CAPSULES \"CYC\""
    },
    {
      "code" : "A026756100",
      "display" : "COROLAX TABLETS 5MG (ISOSORBIDE DINITRATE) \"GCPC\""
    },
    {
      "code" : "A026757100",
      "display" : "WEILIN TABLETS"
    },
    {
      "code" : "A026763100",
      "display" : "NICE SUGAR COATED TABLETS 100MG (NITROXOLINE) \"YUNG SHIN\""
    },
    {
      "code" : "A026770100",
      "display" : "PERSANTINE S.C. TABLETS 25MG"
    },
    {
      "code" : "A026772238",
      "display" : "SODIUM BICARBONATE INJECTION 70MG/ML \"TAI YU\""
    },
    {
      "code" : "A026781100",
      "display" : "CEFADROXIL CAPSULES 500MG \"YU SHENG\""
    },
    {
      "code" : "A026782212",
      "display" : "DIARRIKE INJECTION 6MG/ML \"PATRON\""
    },
    {
      "code" : "A026787216",
      "display" : "DICLOFENAC INJECTION 25MG/ML \"SINTON\""
    },
    {
      "code" : "A026788100",
      "display" : "MECLOMEN CAPSULE 100MG (SODIUM MECLOFENAMATE)"
    },
    {
      "code" : "A026793265",
      "display" : "GLYCEROL INJECTION \"S.Y.\""
    },
    {
      "code" : "A026793266",
      "display" : "GLYCEROL INJECTION \"S.Y.\""
    },
    {
      "code" : "A026793277",
      "display" : "GLYCEROL INJECTION \"S.Y.\""
    },
    {
      "code" : "A026798100",
      "display" : "FUCOLE BISLAN TABLETS 12MG"
    },
    {
      "code" : "A026804209",
      "display" : "METHASONE INJECTION 5MG/ML (DEXAMETHASONE PHOSPHATE) \"VPP\""
    },
    {
      "code" : "A026805100",
      "display" : "SUNCHISU TABLETS 2.5 MG"
    },
    {
      "code" : "A026809100",
      "display" : "POLYWE TABLETS \"N.C.P.\""
    },
    {
      "code" : "A026817255",
      "display" : "SABS INJECTION FOR IV INFUSION 5MG/ML"
    },
    {
      "code" : "A026817266",
      "display" : "SABS INJECTION FOR IV INFUSION 5MG/ML"
    },
    {
      "code" : "A026820100",
      "display" : "E-LIVER S.C. TABLETS"
    },
    {
      "code" : "A026833100",
      "display" : "TRANEXAMIN CAPSULES 250MG  \"HENG AN\"(TRANEXAMIC ACID)"
    },
    {
      "code" : "A026834100",
      "display" : "PHYLLINTAL TABLETS \"T.F.\""
    },
    {
      "code" : "A0268341G0",
      "display" : "PHYLLINTAL TABLETS \"T.F.\""
    },
    {
      "code" : "A026835100",
      "display" : "TINIZOL TABLETS 500MG \"K.S.\""
    },
    {
      "code" : "A026838100",
      "display" : "DELOTON TABLETS \"CHEMYI\""
    },
    {
      "code" : "A026839100",
      "display" : "CYPROHEPTADINE HC1"
    },
    {
      "code" : "A026841212",
      "display" : "DAIZIN INJECTION 5MG/ML (DIAZEPAM)\"Renly.\""
    },
    {
      "code" : "A026849100",
      "display" : "PYRUDON TABLETS 300MG  \"T.F.\""
    },
    {
      "code" : "A026851209",
      "display" : "Formax Injection 20mg/ml\"K.S.\""
    },
    {
      "code" : "A026858321",
      "display" : "PROPADOM CREAM 0.25MG/GM (BECLOMETHASONE)\"N.C.P.\""
    },
    {
      "code" : "A026858329",
      "display" : "PROPADOM CREAM 0.25MG/GM (BECLOMETHASONE)\"N.C.P.\""
    },
    {
      "code" : "A026858335",
      "display" : "PROPADOM CREAM 0.25MG/GM (BECLOMETHASONE)\"N.C.P.\""
    },
    {
      "code" : "A026861321",
      "display" : "Pecigen Cream"
    },
    {
      "code" : "A026861329",
      "display" : "Pecigen Cream"
    },
    {
      "code" : "A026861338",
      "display" : "Pecigen Cream"
    },
    {
      "code" : "A026870100",
      "display" : "FELCAM CAPSULES 10MG (PIROXICAM) \"VPP\""
    },
    {
      "code" : "A026872100",
      "display" : "BENDOL F.C. TABLETS"
    },
    {
      "code" : "A026873100",
      "display" : "CENLOPER CAPSULES 2MG (LOPERAMIDE)"
    },
    {
      "code" : "A026874209",
      "display" : "METHORPHAN INJECTION 5MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026874212",
      "display" : "METHORPHAN INJECTION 5MG/ML \"Y.Y.\""
    },
    {
      "code" : "A026875100",
      "display" : "RIYAZINE CAPSULES\"H.S.\""
    },
    {
      "code" : "A026880100",
      "display" : "INOSINE TABLETS 500MG (METHISOPRINOL) \"H.S.\""
    },
    {
      "code" : "A026881100",
      "display" : "REGASTRIC TABLETS 25MG \"JINUP\" (PIRENZEPINE)"
    },
    {
      "code" : "A026883100",
      "display" : "CODEPINE TABLETS"
    },
    {
      "code" : "A026888221",
      "display" : "TRANEXAMIN INJECTION 10％ (TRANEXAMIC ACID) \"CHI SHENG\""
    },
    {
      "code" : "A026894100",
      "display" : "GASTROTRINE TABLETS 25MG (PIRENZEPINE HCL) \"S.C.\""
    },
    {
      "code" : "A026897100",
      "display" : "POLI TABLETS 20MG"
    },
    {
      "code" : "A026899209",
      "display" : "BEROCOL INJECTION 0.2MG/ML (TERBUTALINE) \"PANBIOTIC\""
    },
    {
      "code" : "A026901100",
      "display" : "QUINIDINE SULFATE TABLETS 200MG \"N.Y.\""
    },
    {
      "code" : "A026905100",
      "display" : "NONGOUT TABLETS 50MG \"Y.Y\" (BENZBROMARONE)"
    },
    {
      "code" : "A026906321",
      "display" : "EPISONE CREAM"
    },
    {
      "code" : "A026906329",
      "display" : "EPISONE CREAM"
    },
    {
      "code" : "A026906335",
      "display" : "EPISONE CREAM"
    },
    {
      "code" : "A026906372",
      "display" : "EPISONE CREAM"
    },
    {
      "code" : "A026906399",
      "display" : "EPISONE CREAM"
    },
    {
      "code" : "A026908100",
      "display" : "RERTOXIN TABLETS 1.5MG (DIHYDROERGOTOXINE) \"UNION\""
    },
    {
      "code" : "A026921209",
      "display" : "DEMINE INJECTION 5MG/ML (CHLORPHENIRAMINE MALEATE)\"Y.Y.\""
    },
    {
      "code" : "A026922100",
      "display" : "MUCORPIN CAPSULES 375MG \"Y.Y.\"(CARBOCYSTEINE)"
    },
    {
      "code" : "A026926216",
      "display" : "ENCORE INJECTION 100MG/ML (ACETYLCYSTEINE)"
    },
    {
      "code" : "A026927100",
      "display" : "LOTAL S.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A026935100",
      "display" : "THIAMINE TABLETS 100MG \"S.Y.\""
    },
    {
      "code" : "A026936209",
      "display" : "LISAIMIN INJECTION 5MG/ML \"SINTON\""
    },
    {
      "code" : "A026936212",
      "display" : "LISAIMIN INJECTION 5MG/ML \"SINTON\""
    },
    {
      "code" : "A026937209",
      "display" : "CEFADOLE INJECTION 1GM (CEFAMANDOLE) \"WINSTON\""
    },
    {
      "code" : "A026941100",
      "display" : "PIROCON CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A026946100",
      "display" : "PIROCAM CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A0269461G0",
      "display" : "PIROCAM CAPSULES 20MG (PIROXICAM)"
    },
    {
      "code" : "A026954100",
      "display" : "WINVITIN TABLETS"
    },
    {
      "code" : "A026955100",
      "display" : "TOLSON CAPSULE 100MG (TOLPERISONE) \"Y.Y.\""
    },
    {
      "code" : "A026957109",
      "display" : "COUTAN SYRUP \"M.S.\""
    },
    {
      "code" : "A026957151",
      "display" : "COUTAN SYRUP \"M.S.\""
    },
    {
      "code" : "A026957157",
      "display" : "COUTAN SYRUP \"M.S.\""
    },
    {
      "code" : "A026957199",
      "display" : "COUTAN SYRUP \"M.S.\""
    },
    {
      "code" : "A026959109",
      "display" : "SINFLEX POWDER FOR ORAL SUSPENSION 25MG/ML \"SINPHAR\""
    },
    {
      "code" : "A026959199",
      "display" : "SINFLEX POWDER FOR ORAL SUSPENSION 25MG/ML \"SINPHAR\""
    },
    {
      "code" : "A026960212",
      "display" : "METROSEMIDE INJECTION 10MG/ML (FUROSEMIDE)"
    },
    {
      "code" : "A026961265",
      "display" : "SALINE-TROSE INJECTION \"TAI YU\""
    },
    {
      "code" : "A026961277",
      "display" : "SALINE-TROSE INJECTION \"TAI YU\""
    },
    {
      "code" : "A026963100",
      "display" : "KUSO TABLETS"
    },
    {
      "code" : "A026967123",
      "display" : "HERA GRANULES"
    },
    {
      "code" : "A026973209",
      "display" : "CEPHAPIRIN FOR INJECTION \"LITA\""
    },
    {
      "code" : "A026973277",
      "display" : "CEPHAPIRIN FOR INJECTION \"LITA\""
    },
    {
      "code" : "A026974100",
      "display" : "PYDINOL TABLETS (PRIDINOL)"
    },
    {
      "code" : "A026975100",
      "display" : "DOXEPIN CAPSULES 25MG \"S.C.\""
    },
    {
      "code" : "A026976100",
      "display" : "DOGMATYL F.C. TABLETS 200MG (SULPIRIDE)"
    },
    {
      "code" : "A026977229",
      "display" : "POPHYRIN INJECTION 1MG/ML \"Y.Y.\" (PROTOPORPHYRIN)"
    },
    {
      "code" : "A026981100",
      "display" : "BISUMIN TABLETS \"O.Y.\""
    },
    {
      "code" : "A026982100",
      "display" : "PISUTON FILM COATED TABLETS 250MG \"MEDRAY\""
    },
    {
      "code" : "A026984100",
      "display" : "PEACE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A026986110",
      "display" : "UCEFA FOR ORAL SUSPENSION 125MG/5ML (CEFADROXIL)\"U.L.\""
    },
    {
      "code" : "A026990209",
      "display" : "BETASON INJECTION 4MG/ML (BETAMETHASONE) \"LITA\""
    },
    {
      "code" : "A026990229",
      "display" : "BETASON INJECTION 4MG/ML (BETAMETHASONE) \"LITA\""
    },
    {
      "code" : "A026994321",
      "display" : "FUTALIN CREAM 0.025％ (BECLOMETHASONE)"
    },
    {
      "code" : "A026994329",
      "display" : "FUTALIN CREAM 0.025％ (BECLOMETHASONE)"
    },
    {
      "code" : "A026994335",
      "display" : "FUTALIN CREAM 0.025％ (BECLOMETHASONE)"
    },
    {
      "code" : "A027001100",
      "display" : "SUBELIN CAPSULES \"YU SHENG\""
    },
    {
      "code" : "A027003221",
      "display" : "SALINE INJECTION 0.9％ \"S.Y.\"(SODIUM CHLORIDE)"
    },
    {
      "code" : "A027003238",
      "display" : "SALINE INJECTION 0.9％ \"S.Y.\"(SODIUM CHLORIDE)"
    },
    {
      "code" : "A027003265",
      "display" : "SALINE INJECTION 0.9％ \"S.Y.\"(SODIUM CHLORIDE)"
    },
    {
      "code" : "A027003277",
      "display" : "SALINE INJECTION 0.9％ \"S.Y.\"(SODIUM CHLORIDE)"
    },
    {
      "code" : "A027007100",
      "display" : "Sweet Tablets 50mg (Sulpiride)"
    },
    {
      "code" : "A027011100",
      "display" : "THRONE ENTERIC SUGAR COATED TABLETS 100MG \"YUNG SHIN\"(PNETOXIFYLLINE)"
    },
    {
      "code" : "A027013100",
      "display" : "R.H.H. TABLETS \"Y.Y.\""
    },
    {
      "code" : "A027016209",
      "display" : "VITAMIN C INJECTION 100MG/ML \"TAI YU\""
    },
    {
      "code" : "A027016221",
      "display" : "VITAMIN C INJECTION 100MG/ML \"TAI YU\""
    },
    {
      "code" : "A027019100",
      "display" : "DISTOP TABLETS \"H.S.\""
    },
    {
      "code" : "A027021214",
      "display" : "SIKACIN INJECTION 100MG/ML \"SHITEH\""
    },
    {
      "code" : "A027022100",
      "display" : "TETRACYCLINE HCL 250MG CAPSULES \"UNIVERSAL\""
    },
    {
      "code" : "A027024100",
      "display" : "RECOUGH TABLETS 30MG (EPRAZINONE) \"S.C.\""
    },
    {
      "code" : "A027027100",
      "display" : "SINULIN CAPSULES"
    },
    {
      "code" : "A027032100",
      "display" : "NIFEPINE TABLETS 10MG (NIFEDIPINE) \"GCPC\""
    },
    {
      "code" : "A027033100",
      "display" : "FELCON CAPSULES"
    },
    {
      "code" : "A027034100",
      "display" : "DICLOFEN E.C. TABLETS 50MG (DICLOFENAC) \"H.H.\""
    },
    {
      "code" : "A027035100",
      "display" : "ALUFIBRATE CAPSULES 500MG \"Y.Y.\""
    },
    {
      "code" : "A027036372",
      "display" : "ANTIFUNG CREAM \"SINPHAR\""
    },
    {
      "code" : "A027036399",
      "display" : "ANTIFUNG CREAM \"SINPHAR\""
    },
    {
      "code" : "A027038100",
      "display" : "DELMINT TABLETS \"J.S.\""
    },
    {
      "code" : "A027040100",
      "display" : "DEX-CTM TABLETS 2MG"
    },
    {
      "code" : "A027044100",
      "display" : "ANTIBLEED CAPSULES 250MG  \"T.F.\""
    },
    {
      "code" : "A0270441G0",
      "display" : "ANTIBLEED CAPSULES 250MG  \"T.F.\""
    },
    {
      "code" : "A027049212",
      "display" : "HYCOBAMIN INJECTION 2.5MG \"Y.Y.\""
    },
    {
      "code" : "A027050100",
      "display" : "LOLOMIT TABLETS 5MG (TIMOLOL) \"SHIN FONG\""
    },
    {
      "code" : "A027051100",
      "display" : "LOLOPRES TABLETS 10MG (TIMOLOL) \"SHIN FONG\""
    },
    {
      "code" : "A027055100",
      "display" : "CURRENT TABLETS \"H.S.\""
    },
    {
      "code" : "A027060100",
      "display" : "NASALCON TABLETS \"N.C.P.\""
    },
    {
      "code" : "A027061100",
      "display" : "NIFEDIPINE CAPSULES 10MG"
    },
    {
      "code" : "A027068100",
      "display" : "SUZYME TABLETS 90MG \"YU SHENG\" (LYSOZYME)"
    },
    {
      "code" : "A027082100",
      "display" : "SECORIN CAPSULES 10MG \"STANDARD\" (OXAZOLAM)"
    },
    {
      "code" : "A0270821G0",
      "display" : "SECORIN CAPSULES 10MG \"STANDARD\" (OXAZOLAM)"
    },
    {
      "code" : "A027087100",
      "display" : "PROBUCOL TABLETS 250MG \"PANBIOTIC\""
    },
    {
      "code" : "A027088100",
      "display" : "DICLOPHEN TABLETS 25MG\"D.T.S\""
    },
    {
      "code" : "A027090263",
      "display" : "AMINOL-RF INJECTION \"S.T.\""
    },
    {
      "code" : "A027093100",
      "display" : "CEFAXIL CAPSULES 500MG \"STANDARD\" (CEFADROXIL)"
    },
    {
      "code" : "A027098100",
      "display" : "SUFEPIN CAPSULES 10MG (NIFEDIPINE)"
    },
    {
      "code" : "A027102100",
      "display" : "ACETAMINOPHEN TABLETS 500MG \"YUNG CHI\""
    },
    {
      "code" : "A027109100",
      "display" : "GRIFULCIN TABLETS 500MG (GRISEOFULVIN) \"C.M.\""
    },
    {
      "code" : "A027110100",
      "display" : "RHINOX CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A0271101G0",
      "display" : "RHINOX CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A027122100",
      "display" : "SUTON TABLETS"
    },
    {
      "code" : "A027123100",
      "display" : "AMOCILLIN CAPSULES 500MG (AMOXICILLIN) \"CHI SHENG\""
    },
    {
      "code" : "A027125100",
      "display" : "WEICHICON TABLETS 40MG (DIMETHICONE) \"KODAK\""
    },
    {
      "code" : "A027126100",
      "display" : "LYSOZYME TABLETS 50MG\"EAYUNG\""
    },
    {
      "code" : "A027131100",
      "display" : "FONING CAPUSLES \"UNION\""
    },
    {
      "code" : "A027133100",
      "display" : "CHUTANG TABLETS 5MG (GLIBENCLAMIDE) \"H.H.P.\""
    },
    {
      "code" : "A027137255",
      "display" : "RINGER'S SOLUTION FOR INJECTION \"TAI YU\""
    },
    {
      "code" : "A027137265",
      "display" : "RINGER'S SOLUTION FOR INJECTION \"TAI YU\""
    },
    {
      "code" : "A027137277",
      "display" : "RINGER'S SOLUTION FOR INJECTION \"TAI YU\""
    },
    {
      "code" : "A027142118",
      "display" : "KO-AN SYRUP \"UNIVERSAL\""
    },
    {
      "code" : "A027142151",
      "display" : "KO-AN SYRUP \"UNIVERSAL\""
    },
    {
      "code" : "A027142157",
      "display" : "KO-AN SYRUP \"UNIVERSAL\""
    },
    {
      "code" : "A027142199",
      "display" : "KO-AN SYRUP \"UNIVERSAL\""
    },
    {
      "code" : "A027144118",
      "display" : "PEACE SYRUP \"YUNG SHIN\""
    },
    {
      "code" : "A027144151",
      "display" : "PEACE SYRUP \"YUNG SHIN\""
    },
    {
      "code" : "A027144199",
      "display" : "PEACE SYRUP \"YUNG SHIN\""
    },
    {
      "code" : "A027145100",
      "display" : "PEPECON CAPSULES \"C.R.\""
    },
    {
      "code" : "A027146321",
      "display" : "FU-KONG CREAM \"T.L.B\""
    },
    {
      "code" : "A027146335",
      "display" : "FU-KONG CREAM \"T.L.B\""
    },
    {
      "code" : "A027146372",
      "display" : "FU-KONG CREAM \"T.L.B\""
    },
    {
      "code" : "A027157100",
      "display" : "WINTOHOW TABLETS 500MG (NALIDIXIC ACID)"
    },
    {
      "code" : "A027162212",
      "display" : "KAWAIPIN INJECTION 5MG/ML  \"S.Y.\"(PIRENZEPINE)"
    },
    {
      "code" : "A027163100",
      "display" : "TRANEX CAPSULES 250MG (TRANEXAMIC ACID)"
    },
    {
      "code" : "A027164100",
      "display" : "TON-PASS FILM COATED TABLETS 500MG (MEFENAMIC ACID) \"TAI YU\""
    },
    {
      "code" : "A027170209",
      "display" : "CEFADIN INJECTION \"STANDARD\" (CEPHRADINE)"
    },
    {
      "code" : "A027170277",
      "display" : "CEFADIN INJECTION \"STANDARD\" (CEPHRADINE)"
    },
    {
      "code" : "A027172100",
      "display" : "QUINIDINE SULFATE TABLETS 200MG \"U-LIANG\""
    },
    {
      "code" : "A027174100",
      "display" : "LYSOZYME TABLETS 60MG\"H.S.\""
    },
    {
      "code" : "A027177121",
      "display" : "ACTEIN GRANULES 20MG/GM"
    },
    {
      "code" : "A027180216",
      "display" : "OXYTETRACYCLINE INTRAVENOUS INJECTION 250MG/3ML \"N.K.\""
    },
    {
      "code" : "A027181238",
      "display" : "AMINE INJECTION \"N.K.\""
    },
    {
      "code" : "A027193321",
      "display" : "ECONAZOLE LOTION 1％ \"MAYER\""
    },
    {
      "code" : "A027196100",
      "display" : "KOCAT TABLETS"
    },
    {
      "code" : "A027199277",
      "display" : "MALTOSE-10 INJECTION 100MG/ML \"S.T.\""
    },
    {
      "code" : "A027206100",
      "display" : "ISHUTIN TABLETS 500MG (ISOPRINOSINE)"
    },
    {
      "code" : "A027210212",
      "display" : "SURSO INJECTION \"S.Y.\""
    },
    {
      "code" : "A027213100",
      "display" : "GELUSIL PLUS TABLETS"
    },
    {
      "code" : "A027221100",
      "display" : "LEUCOMYCIN CAPSULES 250MG \"CENTER\""
    },
    {
      "code" : "A027229221",
      "display" : "EUMOCIL INJECTION 8MG/ML (FENSPIRIDE)"
    },
    {
      "code" : "A027233500",
      "display" : "SAINT-IODINE VAGINAL SUPPOSITORIES 200MG \"PATRON\" (POVIDONE-IODINE)"
    },
    {
      "code" : "A027234100",
      "display" : "TRIMETHOPRIM TABLETS 100MG \"PATRON\""
    },
    {
      "code" : "A027236100",
      "display" : "TENGAM CAPSULES \"M.T.\""
    },
    {
      "code" : "A0272361G0",
      "display" : "TENGAM CAPSULES \"M.T.\""
    },
    {
      "code" : "A027244100",
      "display" : "BUMETA TABLETS 1MG (BUMETANIDE) \"H.H.\""
    },
    {
      "code" : "A027246277",
      "display" : "HARTMANN-SORBITOL INJECTION \"S.T.\""
    },
    {
      "code" : "A027254100",
      "display" : "ANOPAIN TABLETS 30MG (NEFOPAM) \"GENTLE\""
    },
    {
      "code" : "A027257100",
      "display" : "ANNETON TABLETS 30MG (NEFOPAM) \"H.H.\""
    },
    {
      "code" : "A027262100",
      "display" : "ACUTON TABLETS 30MG (NEFOPAM) \"M.S.\""
    },
    {
      "code" : "A027267212",
      "display" : "DILANTIN INJECTION 50MG/ML (PHENYTOIN)"
    },
    {
      "code" : "A027275100",
      "display" : "BLOCKLIN TABLETS 5MG (PINDOLOL) \"SHIONOGI\""
    },
    {
      "code" : "A027280212",
      "display" : "HUSTEN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A027287100",
      "display" : "UPROFEN TABLETS 200MG (IBUPROFEN)"
    },
    {
      "code" : "A027288109",
      "display" : "CHEMIX GRANULES \"YUNG SHIN\""
    },
    {
      "code" : "A027288199",
      "display" : "CHEMIX GRANULES \"YUNG SHIN\""
    },
    {
      "code" : "A027289338",
      "display" : "WINSOLVE UREA CREAM"
    },
    {
      "code" : "A027297100",
      "display" : "DOMILIUM TABLETS 10MG (TRIFLUOPERAZINE)"
    },
    {
      "code" : "A027298100",
      "display" : "MEFENA F.C. TABLETS 500MG (MEFENAMIC ACID) \"GCPC\""
    },
    {
      "code" : "A027300100",
      "display" : "SEZEN TABLETS 30MG (NEFOPAM)\"CBC\""
    },
    {
      "code" : "A027304500",
      "display" : "ASPIRIN SUPPOSITORIES"
    },
    {
      "code" : "A027307212",
      "display" : "U-SODIN INJECTION 2.5MG/ML (VERAPAMIL)"
    },
    {
      "code" : "A027312100",
      "display" : "METOCLOPRAMIDE S.C. TABLETS 7.67MG \"EAYUNG\""
    },
    {
      "code" : "A027313100",
      "display" : "METHYLSCOPOLAMINE TABLETS 1MG \"Y.Y.\""
    },
    {
      "code" : "A027315100",
      "display" : "ERYC CAPSULES 250MG (ERYTHROMYCIN)"
    },
    {
      "code" : "A027317100",
      "display" : "ESUSIN S.C. TABLETS 20MG \"M.T.\""
    },
    {
      "code" : "A027324100",
      "display" : "TONLISU CAPSULES"
    },
    {
      "code" : "A027325209",
      "display" : "Loforan for Injection 1Gm、2Gm \"Gentle\"(Cefotaxime Sodium)"
    },
    {
      "code" : "A027328277",
      "display" : "KEYAMIN-S INJECTION"
    },
    {
      "code" : "A027329277",
      "display" : "LACTATED RINGER'S INJECTION \"S.H.\""
    },
    {
      "code" : "A027330100",
      "display" : "Sin Fun Le CAPSULES \"N.C.P.\""
    },
    {
      "code" : "A027332209",
      "display" : "PROASMA INJECTION 100MG/ML (METHOXYPHENAMINE)\"Y.Y.\""
    },
    {
      "code" : "A027333100",
      "display" : "LITON TABLETS"
    },
    {
      "code" : "A027335100",
      "display" : "UNIAN COLD CAPSULES"
    },
    {
      "code" : "A027338100",
      "display" : "CLOMIPHENE TABLET 50MG \"YUNG SHIN\""
    },
    {
      "code" : "A027346100",
      "display" : "NEOPROXEN TABLETS 275MG (NAPROXEN)\"SHIN FONG\""
    },
    {
      "code" : "A027356221",
      "display" : "HEMOCLOT INJECTIONS 10％ (TRANEXAMIC ACID)"
    },
    {
      "code" : "A027361100",
      "display" : "DITROPAN TABLETS 5MG (OXYBUTYNIN)"
    },
    {
      "code" : "A027368100",
      "display" : "Asgin F.C. Tablets"
    },
    {
      "code" : "A027369109",
      "display" : "ANCORIN GRANULES FOR ORAL SUSPENSION 25MG/ML (AMOXICILLIN)"
    },
    {
      "code" : "A027372238",
      "display" : "KALIMINE-A INJECTION \"UNION\""
    },
    {
      "code" : "A027373349",
      "display" : "CALAMOL LOTION \"VPP\""
    },
    {
      "code" : "A027374100",
      "display" : "ARTINE TABLETS 2MG \"H.L.\""
    },
    {
      "code" : "A027375100",
      "display" : "PAMFENTAM TABLETS 30MG (NEFOPAM)"
    },
    {
      "code" : "A027405100",
      "display" : "Curgan Capsules 70mg \"C.M.\" (Silymarin)"
    },
    {
      "code" : "A027407100",
      "display" : "SILUMA CAPSULE \"M.T.\""
    },
    {
      "code" : "A027409100",
      "display" : "SILYVITA CAPSULES"
    },
    {
      "code" : "A027412100",
      "display" : "BRONPHYLAT TABLETS \"WEIDAR\""
    },
    {
      "code" : "A027413100",
      "display" : "CAPETAN TABLETS 30MG \"WEIDAR\"(CARBETAPENTANE)"
    },
    {
      "code" : "A027418100",
      "display" : "PRO FILM COATED TABLETS 200MG \"YUNG SHIN\"(Proglumide)"
    },
    {
      "code" : "A027427321",
      "display" : "TERRAMYCIN OINTMENT"
    },
    {
      "code" : "A027432100",
      "display" : "DARVINE TABLETS 1.34MG (CLEMASTINE FUMARATE) \"WEIDAR\""
    },
    {
      "code" : "A027433100",
      "display" : "COTINOL TABLETS \"WEIDAR\""
    },
    {
      "code" : "A027434100",
      "display" : "BETASONE TABLETS 0.6MG  \"WEIDAR\"(BETAMETHASONE)"
    },
    {
      "code" : "A027435100",
      "display" : "SADAMOL TABLETS 4MG \"WEIDAR\" (SALBUTAMOL)"
    },
    {
      "code" : "A027436100",
      "display" : "Lopam Tablets 1mg \"Weidar\""
    },
    {
      "code" : "A0274361G0",
      "display" : "Lopam Tablets 1mg \"Weidar\""
    },
    {
      "code" : "A027437100",
      "display" : "METHOCON TABLETS 30MG \"WEIDAR\" (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A027438100",
      "display" : "ISOBIDE TABLETS 10MG \"WEIDAR\""
    },
    {
      "code" : "A0274381G0",
      "display" : "ISOBIDE TABLETS 10MG \"WEIDAR\""
    },
    {
      "code" : "A027439100",
      "display" : "NEDIPIN CAPSULES 10MG \"WEIDAR\""
    },
    {
      "code" : "A027440100",
      "display" : "ETHAVIN TABLETS 100MG \"WEIDAR\" (ETHAVERINE)"
    },
    {
      "code" : "A027443100",
      "display" : "PIRODENE CAPSULES 20MG \"WEIDAR\" (PIROXICAM)"
    },
    {
      "code" : "A027444100",
      "display" : "CARBOTIN CAPSULES 375MG \"WEIDAR\" (S-CARBOXYMETHYLCYSTEINE)"
    },
    {
      "code" : "A027445100",
      "display" : "SANDEL S.C. TABLETS 50MG \"WEIDAR\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A027446100",
      "display" : "BENOTON TABLETS 30MG \"WEIDAR\" (NEFOPAM)"
    },
    {
      "code" : "A027448100",
      "display" : "SLOSAT TABLETS \"WEIDAR\""
    },
    {
      "code" : "A027449100",
      "display" : "LOPICOL F.C. TABLETS 250MG \"WEIDAR\" (PROBUCOL)"
    },
    {
      "code" : "A027450100",
      "display" : "PROLAX TABLETS 250MG \"WEIDAR\" (CHLORZOXAZONE)"
    },
    {
      "code" : "A027451100",
      "display" : "SULORIL TABLETS 100MG \"WEIDAR\" (SULINDAC)"
    },
    {
      "code" : "A027452100",
      "display" : "ATENOL TABLETS 50MG \"WEIDAR\" (ATENOLOL)"
    },
    {
      "code" : "A027456238",
      "display" : "ROLIKAN INJECTION (SODIUM BICARBONATE)"
    },
    {
      "code" : "A027456263",
      "display" : "ROLIKAN INJECTION (SODIUM BICARBONATE)"
    },
    {
      "code" : "A027456265",
      "display" : "ROLIKAN INJECTION (SODIUM BICARBONATE)"
    },
    {
      "code" : "A027457100",
      "display" : "Lipolar Capsules 10mg  \"Royal\"(Bromopride)"
    },
    {
      "code" : "A027459100",
      "display" : "DEPROLAC TABLETS 2.87MG \"WEIDAR\""
    },
    {
      "code" : "A027474100",
      "display" : "TRIALAM TABLETS 0.25MG (TRIAZOLAM) \"H.S.\""
    },
    {
      "code" : "A027476100",
      "display" : "SCRAT TABLETS 500MG"
    },
    {
      "code" : "A027477100",
      "display" : "BALUNA TAB. 350MG (DIHYDROXY ALUMINUM SOD. CARBONATE)"
    },
    {
      "code" : "A027479421",
      "display" : "MEI-LIAN EYE SOLUTION"
    },
    {
      "code" : "A027479435",
      "display" : "MEI-LIAN EYE SOLUTION"
    },
    {
      "code" : "A027484100",
      "display" : "NEUER CAPSULES 200MG (CETRAXATE HCL)"
    },
    {
      "code" : "A027486209",
      "display" : "KATIV-N INJECTION"
    },
    {
      "code" : "A027491100",
      "display" : "KALIMINE-FS.C. TABLETS 100MG \"UNION\""
    },
    {
      "code" : "A027492100",
      "display" : "KALIMINE-A.S.C. TABLETS 50MG \"UNION\""
    },
    {
      "code" : "A0274921G0",
      "display" : "KALIMINE-A.S.C. TABLETS 50MG \"UNION\""
    },
    {
      "code" : "A027496100",
      "display" : "WINMARIN LIVER-PROTECTED CAPSULES 70MG \"WINSTON\" (SILYMARIN)"
    },
    {
      "code" : "A027498100",
      "display" : "ECONLIN CAPSULES 70MG (SILYMARIN)"
    },
    {
      "code" : "A027499100",
      "display" : "SILYME-V CAPSULES \"Y.Y.\""
    },
    {
      "code" : "A027501100",
      "display" : "SILIGEN CAPSULES"
    },
    {
      "code" : "A027504100",
      "display" : "POULICAN CAPSULES"
    },
    {
      "code" : "A027505100",
      "display" : "TALCAN CAPSULES \"CHEN TA\""
    },
    {
      "code" : "A027506100",
      "display" : "KANPIAN CAPSULES \"C.H.\""
    },
    {
      "code" : "A027508100",
      "display" : "SIMALON CAPSULES"
    },
    {
      "code" : "A027509100",
      "display" : "WEI KUNG CAPSULES \"CBC\""
    },
    {
      "code" : "A027510100",
      "display" : "LICOGNE CAPSULES"
    },
    {
      "code" : "A027511100",
      "display" : "ANGINAL S.C. TABLETS 12.5MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A027512100",
      "display" : "ANGINAL S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A027513100",
      "display" : "U-CLOR CAPSULES 250MG (CEFACLOR) \"U.L.\""
    },
    {
      "code" : "A027514100",
      "display" : "U-CLOR CAPSULES 500MG (CEFACLOR)"
    },
    {
      "code" : "A027519399",
      "display" : "BETAGEN CREAM"
    },
    {
      "code" : "A027520100",
      "display" : "DOMETON TABLETS 200MG (SULINDAC) \"N.K.\""
    },
    {
      "code" : "A027521100",
      "display" : "BOMECON TABLETS 500MG \"C.L.\""
    },
    {
      "code" : "A027528100",
      "display" : "METHON TABLETS 30MG (DEXTROMETHORPHAN) \"C.C.P.\""
    },
    {
      "code" : "A027531100",
      "display" : "PROMETIN S.C. TABLETS 5 (METOCLOPRAMIDE)"
    },
    {
      "code" : "A0275311G0",
      "display" : "PROMETIN S.C. TABLETS 5 (METOCLOPRAMIDE)"
    },
    {
      "code" : "A027536100",
      "display" : "VIOMENT TABLETS \"VPP\""
    },
    {
      "code" : "A027544100",
      "display" : "LEUCOVORIN CALCIUM TABLETS 15MG"
    },
    {
      "code" : "A027546100",
      "display" : "DIFUTON TABLETS 250MG (DIFLUNISAL) \"SHIN FONG\""
    },
    {
      "code" : "A027549100",
      "display" : "SIMECO TABLETS \"KINGDOM\""
    },
    {
      "code" : "A027551100",
      "display" : "MUCAINE TABLETS \"KINGDOM\""
    },
    {
      "code" : "A027554277",
      "display" : "PANSPORIN INTRAVENOUS 0.5GM (CEFOTIAM)"
    },
    {
      "code" : "A027555100",
      "display" : "VITANEURIN CAPSULES"
    },
    {
      "code" : "A027557500",
      "display" : "STATIN VAGINAL TABLETS 100000 UNITS \"STANDARD\" (NYSTATIN)"
    },
    {
      "code" : "A027558100",
      "display" : "SELADIN TABLETS 250MG (NAPROXEN) \"YUNG SHIN\""
    },
    {
      "code" : "A027559277",
      "display" : "PROSTAPHLIN PARENTERAL 500MG (OXACILLIN)"
    },
    {
      "code" : "A027566100",
      "display" : "TETROX TABLET M.S."
    },
    {
      "code" : "A027568100",
      "display" : "ZIMARON TABLETS 50MG (BENZBROMARONE) \"S.T.\""
    },
    {
      "code" : "A0275681G0",
      "display" : "ZIMARON TABLETS 50MG (BENZBROMARONE) \"S.T.\""
    },
    {
      "code" : "A027569100",
      "display" : "SOMIN TABLETS 2MG (DEXCHLORPHENIRAMINE) \"YUNG SHIN\""
    },
    {
      "code" : "A027576100",
      "display" : "PONIKAN CAPSULES"
    },
    {
      "code" : "A027577212",
      "display" : "BUSIX INJECTION 0.25MG/ML (BUMETANIDE) \"S.T.\""
    },
    {
      "code" : "A027579100",
      "display" : "MERIOL TABLETS 5MG"
    },
    {
      "code" : "A027584212",
      "display" : "ACANINE-S INJECTION"
    },
    {
      "code" : "A027584216",
      "display" : "ACANINE-S INJECTION"
    },
    {
      "code" : "A027584219",
      "display" : "ACANINE-S INJECTION"
    },
    {
      "code" : "A027598100",
      "display" : "FUCOU CAPSULES \"H.S.\""
    },
    {
      "code" : "A0275981G0",
      "display" : "FUCOU CAPSULES \"H.S.\""
    },
    {
      "code" : "A027599100",
      "display" : "GAREPIN TABLETS (PIRENZEPINE) \"H.H.\""
    },
    {
      "code" : "A027604100",
      "display" : "KAIZOLE TABLETS 10MG (MEBENDAZOLE) \"SYNMOSA\""
    },
    {
      "code" : "A027605100",
      "display" : "Bromhexine Tablets \"S.D.\""
    },
    {
      "code" : "A027615100",
      "display" : "MYLANTA II TABLETS"
    },
    {
      "code" : "A027623100",
      "display" : "GEVRINE* CAPSULES"
    },
    {
      "code" : "A027624100",
      "display" : "LITA BAO CAPSULES"
    },
    {
      "code" : "A027629100",
      "display" : "VOLBRO CAPSULES 2.5MG (BROMOCRIPTINE)"
    },
    {
      "code" : "A027638209",
      "display" : "CLAVOX FOR INJECTION \"S.T.\" (CEFOTAXIME)"
    },
    {
      "code" : "A027638277",
      "display" : "CLAVOX FOR INJECTION \"S.T.\" (CEFOTAXIME)"
    },
    {
      "code" : "A027639277",
      "display" : "CLAVOX FOR INJECTION 0.5GM (CEFOTAXIME)"
    },
    {
      "code" : "A027646216",
      "display" : "FUKAN INJECTION \"Y.Y.\""
    },
    {
      "code" : "A027658100",
      "display" : "LICON S.C. TABLETS"
    },
    {
      "code" : "A027667321",
      "display" : "FOURACT CREAM"
    },
    {
      "code" : "A027676100",
      "display" : "LOPID CAPSULES 300MG (GEMFIBROZIL)"
    },
    {
      "code" : "A027687216",
      "display" : "LIBAAMIN INJECTION"
    },
    {
      "code" : "A027701212",
      "display" : "LYSIGEN B12 INJECTION \"T.S.\""
    },
    {
      "code" : "A027706100",
      "display" : "CLODNIN TABLETS \"MEIDER\""
    },
    {
      "code" : "A027716209",
      "display" : "NOVAMIN INJECTION 5MG/ML (PROCHLORPERAZINE)"
    },
    {
      "code" : "A027717206",
      "display" : "RINDERON SUSPENSION 5MG/ML"
    },
    {
      "code" : "A027717221",
      "display" : "RINDERON SUSPENSION 5MG/ML"
    },
    {
      "code" : "A027717277",
      "display" : "RINDERON SUSPENSION 5MG/ML"
    },
    {
      "code" : "A027718206",
      "display" : "RINDERON INJECTION 4MG/ML (BETAMETHASONE)"
    },
    {
      "code" : "A027718209",
      "display" : "RINDERON INJECTION 4MG/ML (BETAMETHASONE)"
    },
    {
      "code" : "A027718277",
      "display" : "RINDERON INJECTION 4MG/ML (BETAMETHASONE)"
    },
    {
      "code" : "A027736209",
      "display" : "PYRETHIA INJECTION 25MG/ML (PROMETHAZINE)"
    },
    {
      "code" : "A027737216",
      "display" : "CITRUGEN INJECTION \"STANDARD\""
    },
    {
      "code" : "A027775100",
      "display" : "SINROX F.C TABLETS 40MG (VERAPAMIL)"
    },
    {
      "code" : "A027776100",
      "display" : "GRISEN TABLETS 500MG (GRISEOFULVIN) \"VPP\""
    },
    {
      "code" : "A027792100",
      "display" : "B-COMPLEX TABLETS"
    },
    {
      "code" : "A027812100",
      "display" : "TAMEDIN INJECTION 100MG/ML \"STANDARD\" (CIMETIDINE)"
    },
    {
      "code" : "A027812212",
      "display" : "TAMEDIN INJECTION 100MG/ML \"STANDARD\" (CIMETIDINE)"
    },
    {
      "code" : "A027818100",
      "display" : "DEPERMIDE S.C. TABLETS (INDAPAMIDE)"
    },
    {
      "code" : "A027833100",
      "display" : "BUSECON CAPSULES"
    },
    {
      "code" : "A027834100",
      "display" : "PIDOL TABLETS 5MG \"STANDARD\" (PINDOLOL)"
    },
    {
      "code" : "A027836100",
      "display" : "VITAMIN E CHEWABLE TABLETS 200MG \"C.C.P.C.\""
    },
    {
      "code" : "A027846100",
      "display" : "MEPIZOL F.C. TABLETS 100MG \"STANDARD\""
    },
    {
      "code" : "A027847100",
      "display" : "ILOSONE TABLETS 500MG (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A027849100",
      "display" : "LOWEN TABLETS 0.5MG (LORAZEPAM) \"C.C.P.\""
    },
    {
      "code" : "A0278491G0",
      "display" : "LOWEN TABLETS 0.5MG (LORAZEPAM) \"C.C.P.\""
    },
    {
      "code" : "A027850212",
      "display" : "DUPIN INJECTION 5MG/ML (DIAZEPAM) \"C.C.P.\""
    },
    {
      "code" : "A027851255",
      "display" : "MEDAZOLE INJECTION FOR INTRAVENOUS INFUSION 0.5％ (METRONIDAZOLE)"
    },
    {
      "code" : "A027856277",
      "display" : "BLUTON-SALINE INJECTION 5％"
    },
    {
      "code" : "A027857100",
      "display" : "PROLAN F.C. TABLETS 40MG (PROPRANOLOL)"
    },
    {
      "code" : "A027864212",
      "display" : "AMIKACIN INJECTION 250MG/ML \"N.K.\""
    },
    {
      "code" : "A027864229",
      "display" : "AMIKACIN INJECTION 250MG/ML \"N.K.\""
    },
    {
      "code" : "A027870100",
      "display" : "ALUPHOSGEL TABLETS (ALUMINUM PHOSPHOTE)"
    },
    {
      "code" : "A027871100",
      "display" : "SUSING TABLET (PROXYPHYLLINE) \"Y.S.\""
    },
    {
      "code" : "A027872138",
      "display" : "ALUPHOSGEL (ALUMINUM PHOSPHATE) \"KINGDOM\""
    },
    {
      "code" : "A027874100",
      "display" : "YANG LI NENG CAPSULES 110MG \"T.L.B\""
    },
    {
      "code" : "A027876100",
      "display" : "LIVORIN CAPSULES 70MG \"WEIDAR\" (SILYMARIN)"
    },
    {
      "code" : "A027882277",
      "display" : "CIDOL FOR INJECTION 500MG(CEFAMANDOLE)"
    },
    {
      "code" : "A027886263",
      "display" : "UNIKIN INJECTION 200MG (AMIKACIN) \"UNION\""
    },
    {
      "code" : "A027887100",
      "display" : "Vertizine Tablets 5mg \"Y.Y.\""
    },
    {
      "code" : "A027888100",
      "display" : "METHYLTESTOSTERONE TABLETS \"HONTEN\""
    },
    {
      "code" : "A027924212",
      "display" : "OXYTETRACYCLINE HCL INJECTION \"N.K.\""
    },
    {
      "code" : "A027924229",
      "display" : "OXYTETRACYCLINE HCL INJECTION \"N.K.\""
    },
    {
      "code" : "A027926100",
      "display" : "FU LI HORMONE CAPSULES \"WELCAN\""
    },
    {
      "code" : "A027928212",
      "display" : "ROSIS IV INJECTION  \"VPP\""
    },
    {
      "code" : "A027930221",
      "display" : "LYOPLEX-L INJECTION"
    },
    {
      "code" : "A027934100",
      "display" : "DECOFEN TABLETS \"VPP\""
    },
    {
      "code" : "A027936100",
      "display" : "BENAMINE CAPSULES 50MG"
    },
    {
      "code" : "A027939221",
      "display" : "BEESIX INJECTION 100MG/ML (PYRIDOXINE HCL) \"VPP\""
    },
    {
      "code" : "A027940100",
      "display" : "BEESIX TABLETS 50MG"
    },
    {
      "code" : "A027941212",
      "display" : "BEESIX INJECTION 50MG/ML (PYRIDOXINE HCL) \"VPP\""
    },
    {
      "code" : "A027942399",
      "display" : "NITROFURAZONE OINTMENT \"VPP\""
    },
    {
      "code" : "A0279423CH",
      "display" : "NITROFURAZONE OINTMENT \"VPP\""
    },
    {
      "code" : "A027943100",
      "display" : "VANCONIN TABLETS 5MG"
    },
    {
      "code" : "A0279431G0",
      "display" : "VANCONIN TABLETS 5MG"
    },
    {
      "code" : "A027946100",
      "display" : "METHASONE TABLETS 0.25MG (DEXAMETHASONE) \"VPP"
    },
    {
      "code" : "A027948212",
      "display" : "VANCONIN INJECTION 5MG/ML (DIAZEPAM) \"VPP\""
    },
    {
      "code" : "A027950100",
      "display" : "LIPOTRIN TABLETS"
    },
    {
      "code" : "A027956209",
      "display" : "CECONINE FOR INJECTION 1G (CEPHALORIDINE) \"VPP\""
    },
    {
      "code" : "A027957277",
      "display" : "CECONINE FOR INJECTION 0.5G (CEPHALORIDINE) \"VPP\""
    },
    {
      "code" : "A027958100",
      "display" : "DAZID TABLETS"
    },
    {
      "code" : "A027970100",
      "display" : "TALAM CAPSULES 250MG (TALAMPICILLIN)"
    },
    {
      "code" : "A027971100",
      "display" : "MISPANTON CAPSULES 500MG (MEFENAMIC ACID) \"C.M.\""
    },
    {
      "code" : "A027973289",
      "display" : "CEFURO INJECTION 750MG"
    },
    {
      "code" : "A027977100",
      "display" : "STILBESTROL ECT 5MG (DIETHYLSTILBESTROL) \"NYSCO\""
    },
    {
      "code" : "A027978100",
      "display" : "STILBESTOL ECT 1MG (DIETHYLSTILBESTROL) \"NYSCO\""
    },
    {
      "code" : "A027979209",
      "display" : "PAMOXICILLIN INJECTION 1GM (AMOXICILLIN) \"UNION\""
    },
    {
      "code" : "A027989118",
      "display" : "CHLORPHENIRAMINE SOLUTION 0.4MG/ML"
    },
    {
      "code" : "A027989199",
      "display" : "CHLORPHENIRAMINE SOLUTION 0.4MG/ML"
    },
    {
      "code" : "A027991100",
      "display" : "BROMPHENIRAMINE TABLETS"
    },
    {
      "code" : "A027992100",
      "display" : "JIKOTON TABLETS"
    },
    {
      "code" : "A027998118",
      "display" : "FUDOLON SOLUTION 24MG/ML (ACETAMINOPHEN) \"BOWLIN\""
    },
    {
      "code" : "A027998151",
      "display" : "FUDOLON SOLUTION 24MG/ML (ACETAMINOPHEN) \"BOWLIN\""
    },
    {
      "code" : "A027998199",
      "display" : "FUDOLON SOLUTION 24MG/ML (ACETAMINOPHEN) \"BOWLIN\""
    },
    {
      "code" : "A028000100",
      "display" : "WELOAN TABLETS"
    },
    {
      "code" : "A028001100",
      "display" : "PUKO TABLETS (MEBENDAZOLE)"
    },
    {
      "code" : "A028009100",
      "display" : "DE SEN TABLET \"SHITEH\""
    },
    {
      "code" : "A028013100",
      "display" : "CLOMID TABLETS 50MG (CLOMIFENE) \"SHIONOGI\""
    },
    {
      "code" : "A028014100",
      "display" : "PIPERA CAPSULES 200MG \"WEIDAR\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A028015100",
      "display" : "TRIPRIM TABLETS 100MG  \"WEIDAR\"(TRIMETHOPRIM)"
    },
    {
      "code" : "A028016100",
      "display" : "TINIZOL TABLETS 500MG \"WEIDAR\" (TINIDAZOLE)"
    },
    {
      "code" : "A028017100",
      "display" : "DICLOREN E.C. TABLETS 50MG  \"WEIDAR\" (DICLOFENAC)"
    },
    {
      "code" : "A028020118",
      "display" : "KAOTIN SUSPENSION"
    },
    {
      "code" : "A028020199",
      "display" : "KAOTIN SUSPENSION"
    },
    {
      "code" : "A028021321",
      "display" : "AIRFUL CREAM 1MG/GM (TRETINOIN)"
    },
    {
      "code" : "A028027212",
      "display" : "LICATAN INJECTION \"N.K.\""
    },
    {
      "code" : "A028027221",
      "display" : "LICATAN INJECTION \"N.K.\""
    },
    {
      "code" : "A028029100",
      "display" : "DIMENHYDRINATE TABLETS"
    },
    {
      "code" : "A028032100",
      "display" : "VETRIMIL S.C. TABLETS 40MG (VERAPAMIL)"
    },
    {
      "code" : "A0280321G0",
      "display" : "VETRIMIL S.C. TABLETS 40MG (VERAPAMIL)"
    },
    {
      "code" : "A028033100",
      "display" : "SUCWAY TABLETS 500MG (SUCRALFATE)"
    },
    {
      "code" : "A028034100",
      "display" : "PANALDINE F.C. TABLETS 100MG (TICLOPIDINE)"
    },
    {
      "code" : "A028041100",
      "display" : "Amiorone Tablets 200mg"
    },
    {
      "code" : "A028047212",
      "display" : "SAVOX INJECTION 125MG/ML (AMIKACIN)"
    },
    {
      "code" : "A028047229",
      "display" : "SAVOX INJECTION 125MG/ML (AMIKACIN)"
    },
    {
      "code" : "A028048100",
      "display" : "COSPANON S.C. TABLETS 80MG (FLOPROPIONE)"
    },
    {
      "code" : "A028054100",
      "display" : "FUYOU TABLETS"
    },
    {
      "code" : "A028055100",
      "display" : "FUYOU TABLETS 500MG"
    },
    {
      "code" : "A028056100",
      "display" : "NISIMLONE CAPSULES 10MG (NIFEDIPINE)"
    },
    {
      "code" : "A028066100",
      "display" : "HEBOVITA TABLETS"
    },
    {
      "code" : "A028069100",
      "display" : "KYOPINAL F.C. TABLETS (ALCLOFENAC)"
    },
    {
      "code" : "A028072100",
      "display" : "IODOL TABLETS 30MG (IODOPROPYLIDENE GLYCEROL) \"WEIDAR\""
    },
    {
      "code" : "A028078100",
      "display" : "SULPIN F.C. TABLETS 200MG (SULPIRIDE) \"S.T.\""
    },
    {
      "code" : "A028079100",
      "display" : "BUSIX TABLETS 1.0MG"
    },
    {
      "code" : "A028080100",
      "display" : "LEBUFEN F.C. TABLETS 200MG (FENBUFEN)"
    },
    {
      "code" : "A028085100",
      "display" : "IPG TABLETS 30MG (IODOPROPYLIDENE GLYCEROL) \""
    },
    {
      "code" : "A028089177",
      "display" : "MAGALATE SUSENSION \"CHEN TA\""
    },
    {
      "code" : "A028089199",
      "display" : "MAGALATE SUSENSION \"CHEN TA\""
    },
    {
      "code" : "A028091100",
      "display" : "FLUFEN CAPSULES 125MG (ALUMINUM FLUFENAMATE)\"P.L.\""
    },
    {
      "code" : "A028098100",
      "display" : "ACETAMOL TABLETS 500MG \"WEIDAR\" (ACETAMINOPHEN)"
    },
    {
      "code" : "A028099210",
      "display" : "FUROXIME FOR INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A028099265",
      "display" : "FUROXIME FOR INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A028099277",
      "display" : "FUROXIME FOR INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A028099289",
      "display" : "FUROXIME FOR INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A028108100",
      "display" : "MIDOL TABLETS"
    },
    {
      "code" : "A028115321",
      "display" : "PICOSONE CREAM \"C.M.\""
    },
    {
      "code" : "A028115377",
      "display" : "PICOSONE CREAM \"C.M.\""
    },
    {
      "code" : "A028122100",
      "display" : "RIFAMPIN CAPSULES 150MG \"VPP\""
    },
    {
      "code" : "A028128100",
      "display" : "LITANIN TABLETS \"Y.K.\""
    },
    {
      "code" : "A028130100",
      "display" : "AN-SU TABLETS 500MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A028131100",
      "display" : "ALAT CAPSULES 5MG (NIFEDIPINE) \"YUNG SHIN\""
    },
    {
      "code" : "A028133100",
      "display" : "IPG TABLETS 60MG (IODOPROPYLIDENE GLYCEROL) \" S.T.\""
    },
    {
      "code" : "A028136100",
      "display" : "SELADIN TABLETS 500MG (NAPROXEN) \"YUNG SHIN\""
    },
    {
      "code" : "A028140100",
      "display" : "RIPIN CAPSULE 300MG"
    },
    {
      "code" : "A028141329",
      "display" : "FLUGEN OINTMENT 10MG (SILVER SULFADIAZINE \"YUNG SHIN\""
    },
    {
      "code" : "A028141338",
      "display" : "FLUGEN OINTMENT 10MG (SILVER SULFADIAZINE \"YUNG SHIN\""
    },
    {
      "code" : "A028141377",
      "display" : "FLUGEN OINTMENT 10MG (SILVER SULFADIAZINE \"YUNG SHIN\""
    },
    {
      "code" : "A028141399",
      "display" : "FLUGEN OINTMENT 10MG (SILVER SULFADIAZINE \"YUNG SHIN\""
    },
    {
      "code" : "A028142100",
      "display" : "KASTEINE TABLETS 375MG (S-CARBOXYMETHYLCYSTEINE \"YUNG SHIN\""
    },
    {
      "code" : "A028146100",
      "display" : "ORIENTRIN TABLETS"
    },
    {
      "code" : "A028149100",
      "display" : "TIALAM TABLETS 0.25MG (TRIAZOLAM)"
    },
    {
      "code" : "A028150212",
      "display" : "UNIKIN INJECJION 500MG \"UNION\" (AMIKACIN SULFATE)"
    },
    {
      "code" : "A028151212",
      "display" : "UNIKIN INJECTION 250MG (AMIKACIN SULFATE) \"UNION\""
    },
    {
      "code" : "A028151229",
      "display" : "UNIKIN INJECTION 250MG (AMIKACIN SULFATE) \"UNION\""
    },
    {
      "code" : "A028153129",
      "display" : "ULCERIN-M GEL"
    },
    {
      "code" : "A028154209",
      "display" : "CIDOL FOR INJECTION 1GM (CEFAMANDOLE)"
    },
    {
      "code" : "A028155209",
      "display" : "MEISIN FOR INJECTION 1GM(CEFAZOLIN)"
    },
    {
      "code" : "A028158277",
      "display" : "KINFOMYCIN INJECTION 500MG (FOSFOMYCIN) \"KINGDOM\""
    },
    {
      "code" : "A028160100",
      "display" : "ANDIZA FILM COATED TABLETS 25MG"
    },
    {
      "code" : "A0281601G0",
      "display" : "ANDIZA FILM COATED TABLETS 25MG"
    },
    {
      "code" : "A028168329",
      "display" : "SILVADENE CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A028168338",
      "display" : "SILVADENE CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A028168348",
      "display" : "SILVADENE CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A028168371",
      "display" : "SILVADENE CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A028168399",
      "display" : "SILVADENE CREAM 1％ (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A028169321",
      "display" : "BATRAFEN CREAM 10MG/GM (CICLOPIROX OLAMINE)"
    },
    {
      "code" : "A028169348",
      "display" : "BATRAFEN CREAM 10MG/GM (CICLOPIROX OLAMINE)"
    },
    {
      "code" : "A028171100",
      "display" : "SOOTHER TABLETS 1MG (KETOTIFEN)"
    },
    {
      "code" : "A0281711G0",
      "display" : "SOOTHER TABLETS 1MG (KETOTIFEN)"
    },
    {
      "code" : "A028172100",
      "display" : "PSUTARIN F.C. TABLETS 50MG (DICLOFENAC)\"PRINCE\""
    },
    {
      "code" : "A028200100",
      "display" : "WINMIDE S.C. TABLETS 2.5MG (INDAPAMIDE) \"WINSTON\""
    },
    {
      "code" : "A028206100",
      "display" : "OHMINASE S.C. TABLETS"
    },
    {
      "code" : "A028208100",
      "display" : "VEMEICY TROCHES \"T.F.\""
    },
    {
      "code" : "A028210100",
      "display" : "INFLAMNIL TABLETS 100MG (TRIMETHOPRIM)"
    },
    {
      "code" : "A0282101G0",
      "display" : "INFLAMNIL TABLETS 100MG (TRIMETHOPRIM)"
    },
    {
      "code" : "A028218100",
      "display" : "LOPELA CAPSULES 2MG \"WEIDAR\" (LOPERAMIDE)"
    },
    {
      "code" : "A028220100",
      "display" : "GPIN TABLETS (PIRENZEPIN DIHYDROCHLORIDE)\"M.S.\""
    },
    {
      "code" : "A028243100",
      "display" : "ISONIN TABLETS 100MG"
    },
    {
      "code" : "A028244100",
      "display" : "DEPOVITA CAPSULES \"C.H.\""
    },
    {
      "code" : "A028245100",
      "display" : "GLIBIDE TABLETS 5MG \"WEIDAR\" (GLIBENCLAMIDE)"
    },
    {
      "code" : "A0282451G0",
      "display" : "GLIBIDE TABLETS 5MG \"WEIDAR\" (GLIBENCLAMIDE)"
    },
    {
      "code" : "A028249100",
      "display" : "TAKE-C TABLETS"
    },
    {
      "code" : "A028254309",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254321",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254329",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254335",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254338",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254373",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028254399",
      "display" : "LOSUCON CREAM"
    },
    {
      "code" : "A028258335",
      "display" : "STRI-DEX B.P. EMULSION 10％ (BENZOYL PEROXIDE)"
    },
    {
      "code" : "A028283100",
      "display" : "SUFUNI CAPSULES 5MG (FLUNARIZINE)"
    },
    {
      "code" : "A028284100",
      "display" : "COCOBITA F.C. TABLETS 30MG \"T.F.\"(CARBETAPENTANE)"
    },
    {
      "code" : "A028302100",
      "display" : "PIMICID F.C. TABLETS 250MG (PIPEMIDIC ACID)"
    },
    {
      "code" : "A028307100",
      "display" : "NINIOL CAPSULES 100MG \"CHEN TA\"（NITROXOLINE）"
    },
    {
      "code" : "A028313100",
      "display" : "TIARAMIDE TABLETS 100MG (TIARAMIDE) \"MEIDER\""
    },
    {
      "code" : "A028314277",
      "display" : "SORBILAC RINGER'S INJECTION"
    },
    {
      "code" : "A028315500",
      "display" : "HEMOTHOL SUPPOSITORIES"
    },
    {
      "code" : "A028318100",
      "display" : "TEGANSIA TABLETS 40MG (FENSPIRIDE) \"MEIDER\""
    },
    {
      "code" : "A028321100",
      "display" : "UPROFEN TABLETS 400MG (IBUPROFEN)"
    },
    {
      "code" : "A028324100",
      "display" : "DICLOF E.C. TABLETS 50MG \"CHEN TA\"(DICLOFENAC)"
    },
    {
      "code" : "A028332100",
      "display" : "GAIN-TONIN TABLETS 10MG (DOMPERIDONE)\"MEIDER\""
    },
    {
      "code" : "A028333100",
      "display" : "LUCKYHEPA CAPSULES"
    },
    {
      "code" : "A028337277",
      "display" : "CEFOTAXIME SODIUM POWER FOR INJECTION C.C.P."
    },
    {
      "code" : "A028341500",
      "display" : "GYNOMYCODERIN VAGINAL TABLETS 100MG (MICONAZOE NITRATE)"
    },
    {
      "code" : "A028342100",
      "display" : "MECLOMEN CAPSULES 50MG (SODIUM MECLOFENAMATE)"
    },
    {
      "code" : "A028343209",
      "display" : "KEFZOL INJECTION 1GM (CEFAZOLIN)"
    },
    {
      "code" : "A028344277",
      "display" : "KEFZOL INJECTION 500MG (CEFAZOLIN)"
    },
    {
      "code" : "A028347289",
      "display" : "CFU FOR INJECTION 750MG (CEFUROXIME)"
    },
    {
      "code" : "A028350212",
      "display" : "ACEMYCIN INJECTION 100MG/ML (AMIKACIN) \"YUNG SHIN\""
    },
    {
      "code" : "A028371100",
      "display" : "SAFEWAY F.C. TABLETS 200MG (CIMETIDINE) \"VPP\""
    },
    {
      "code" : "A028374100",
      "display" : "SEDES TABLETS"
    },
    {
      "code" : "A0283741G0",
      "display" : "SEDES TABLETS"
    },
    {
      "code" : "A028375100",
      "display" : "CO-PYRONIL 2 PULVULES"
    },
    {
      "code" : "A028379100",
      "display" : "PIROXICAM CAPSULES 20MG \"YUNG CHI\""
    },
    {
      "code" : "A028380100",
      "display" : "SULINDAC TABLETS 100MG \"Y.S.\""
    },
    {
      "code" : "A028441212",
      "display" : "SISOMICIN INJECTION 50MG/ML \"YUNG SHIN\""
    },
    {
      "code" : "A028451100",
      "display" : "BISOLVON TABLETS 8MG (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A028452100",
      "display" : "BUSCOPAN S.C. TABLETS 10MG (HYOSCINE-N-BUTYL BROMIDE)"
    },
    {
      "code" : "A0284521G0",
      "display" : "BUSCOPAN S.C. TABLETS 10MG (HYOSCINE-N-BUTYL BROMIDE)"
    },
    {
      "code" : "A028453100",
      "display" : "MUCOSOLVAN TABLETS 30MG (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A0284531G0",
      "display" : "MUCOSOLVAN TABLETS 30MG (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A028454100",
      "display" : "PERSANTIN S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A0284541G0",
      "display" : "PERSANTIN S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A028458100",
      "display" : "PIRACETAM CAPASULES 400MG \"Y.S.\""
    },
    {
      "code" : "A028461100",
      "display" : "DOMPE TABLETS 10MG \"H.S.\""
    },
    {
      "code" : "A0284611G0",
      "display" : "DOMPE TABLETS 10MG \"H.S.\""
    },
    {
      "code" : "A028462100",
      "display" : "CRIP CAPSULES 2.5MG (BROMOCRIPTINE)\"H.H.\""
    },
    {
      "code" : "A028468100",
      "display" : "OS-CAL CAPSULES 250MG (CALCIUM CARBONATE)"
    },
    {
      "code" : "A028470100",
      "display" : "TRENTAL DRAGEE 400MG (PENTOXIFYLLINE)"
    },
    {
      "code" : "A028474100",
      "display" : "PANADOL TABLETS FOR CHILDREN 80MG (ACETAMINOPHEN)"
    },
    {
      "code" : "A028475265",
      "display" : "GLYBRAIN INJECTION"
    },
    {
      "code" : "A028475277",
      "display" : "GLYBRAIN INJECTION"
    },
    {
      "code" : "A028476100",
      "display" : "ANTITUSSIVE TABLETS 30MG (DEXTROMETHORPHAN) \"TAI YU\""
    },
    {
      "code" : "A028477212",
      "display" : "ACEMYCIN INJECTION 250MG/ML (AMIKACIN) \"YUNG SHIN\""
    },
    {
      "code" : "A028477229",
      "display" : "ACEMYCIN INJECTION 250MG/ML (AMIKACIN) \"YUNG SHIN\""
    },
    {
      "code" : "A028478209",
      "display" : "CHLORPHENIRAMINE INJECTION 5MG/ML \"TAI YU\""
    },
    {
      "code" : "A028482100",
      "display" : "VILIABES S.C. TABALETS \"JOHNSON\""
    },
    {
      "code" : "A028483100",
      "display" : "KEFLEX TABLETS 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A028499100",
      "display" : "A.E.S.C. TABLETS \"KINGDOM\""
    },
    {
      "code" : "A028501100",
      "display" : "BEROTEC TABLETS 2.5MG (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A028502151",
      "display" : "BEROTEC LIQUID 0.5MG/ML (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A028502155",
      "display" : "BEROTEC LIQUID 0.5MG/ML (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A028502199",
      "display" : "BEROTEC LIQUID 0.5MG/ML (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A028503100",
      "display" : "DULCOLAX E.S.C. TABLETS 5MG (BISACODYL)"
    },
    {
      "code" : "A0285031G0",
      "display" : "DULCOLAX E.S.C. TABLETS 5MG (BISACODYL)"
    },
    {
      "code" : "A028504100",
      "display" : "CATAPRES TABLETS 75UG (CLONIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A028505151",
      "display" : "MUCOSOLVAN LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A028505155",
      "display" : "MUCOSOLVAN LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A028505199",
      "display" : "MUCOSOLVAN LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A028506100",
      "display" : "GASTROZEPIN TABLETS 25MG (PIRENZEPINE DIHYDROCHLORIDE)"
    },
    {
      "code" : "A028507100",
      "display" : "PERSANTIN S.C. TABLETS 75MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A028515100",
      "display" : "ALUPENT TABLETS 20MG (ORCIPRENALINE SULFATE)"
    },
    {
      "code" : "A028517100",
      "display" : "PLOTON TABLETS"
    },
    {
      "code" : "A028518209",
      "display" : "PLOTON INJECTION"
    },
    {
      "code" : "A028519151",
      "display" : "CARTEINE SOLUTION 50MG/ML \"C.M\""
    },
    {
      "code" : "A028519199",
      "display" : "CARTEINE SOLUTION 50MG/ML \"C.M\""
    },
    {
      "code" : "A028533100",
      "display" : "NOOBICA CAPSULES 400MG \"YU SHENG\" (PIRACETAM)"
    },
    {
      "code" : "A0285331G0",
      "display" : "NOOBICA CAPSULES 400MG \"YU SHENG\" (PIRACETAM)"
    },
    {
      "code" : "A028535265",
      "display" : "POTACOL-R INJECTION"
    },
    {
      "code" : "A028535277",
      "display" : "POTACOL-R INJECTION"
    },
    {
      "code" : "A028538209",
      "display" : "C.P.Z. INJECTION 1GM \"STANDARD\" (CEFOPERAZONE)"
    },
    {
      "code" : "A028539277",
      "display" : "C.P.Z. INJECTION 500MG \"STANDARD\" (CEFOPERAZONE)"
    },
    {
      "code" : "A028542265",
      "display" : "PANTOGEN INJECTION \"SINTONG\""
    },
    {
      "code" : "A028542277",
      "display" : "PANTOGEN INJECTION \"SINTONG\""
    },
    {
      "code" : "A028543263",
      "display" : "KANENDOMYCIN FOR INJECTION 400MG (POTENCY)"
    },
    {
      "code" : "A028543271",
      "display" : "KANENDOMYCIN FOR INJECTION 400MG (POTENCY)"
    },
    {
      "code" : "A028545100",
      "display" : "IPOL TABLETS 30MG (IODOPROPYLIDENE GLYCEROL)\"Y.S.\""
    },
    {
      "code" : "A028546321",
      "display" : "TOPSYM (R) EMOLLIENT 0.5MG/GM (FLUOCINONIDE)"
    },
    {
      "code" : "A028560255",
      "display" : "METRONIDAZOLE INJECTION 5MG/ML"
    },
    {
      "code" : "A028560263",
      "display" : "METRONIDAZOLE INJECTION 5MG/ML"
    },
    {
      "code" : "A028560277",
      "display" : "METRONIDAZOLE INJECTION 5MG/ML"
    },
    {
      "code" : "A028561100",
      "display" : "MELEX CAPSULES 250MG (CEPHALEXIN)"
    },
    {
      "code" : "A028562309",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028562321",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028562324",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028562329",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028562372",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028562399",
      "display" : "CLOBETASOL OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A028563100",
      "display" : "VITAMIN A S.C. TABLETS 10.000I.U."
    },
    {
      "code" : "A028576216",
      "display" : "DIFENA INJECTION 25MG/ML \"STANDARD\" (DICLOFENAC)"
    },
    {
      "code" : "A028578329",
      "display" : "PIRIGEN CREAM 0.5MG/MG (CLOBETASOL)"
    },
    {
      "code" : "A028578399",
      "display" : "PIRIGEN CREAM 0.5MG/MG (CLOBETASOL)"
    },
    {
      "code" : "A028581100",
      "display" : "FLUNAZINE TABLETS 5MG (FLUNARIZINE)"
    },
    {
      "code" : "A0285811G0",
      "display" : "FLUNAZINE TABLETS 5MG (FLUNARIZINE)"
    },
    {
      "code" : "A028587209",
      "display" : "VENOCEF INJECTION (CEPHALOTHIN)\"CHIU PO\""
    },
    {
      "code" : "A028587212",
      "display" : "VENOCEF INJECTION (CEPHALOTHIN)\"CHIU PO\""
    },
    {
      "code" : "A028591100",
      "display" : "PAIN OFF ENTERIC-MICROENCAPSULATED CAPSULE 500MG\"SHITEH\"(ASPIRIN)"
    },
    {
      "code" : "A028592100",
      "display" : "PAROTIN F.C. TABLETS 75MG \"Y.S.\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A0285921G0",
      "display" : "PAROTIN F.C. TABLETS 75MG \"Y.S.\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A028594100",
      "display" : "COPHEDRIN TABLETS \"WEIDAR\""
    },
    {
      "code" : "A028595329",
      "display" : "ALITON CREAM 30MG/GM \"C.M.\"(NIFLUMIC ACID)"
    },
    {
      "code" : "A028604116",
      "display" : "ENCORE GRANULES 200MG/3G (ACETYLCYSTEINE)"
    },
    {
      "code" : "A028605216",
      "display" : "VETIN INJECTION 25MG/ML (DICLOFENAC)"
    },
    {
      "code" : "A028606118",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606138",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606155",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606157",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606159",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606163",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028606199",
      "display" : "COMPOUND GLYCYRRHIZA ANTI-COUGH MIXTURE \"HEALTH\""
    },
    {
      "code" : "A028607329",
      "display" : "DERMOCURE CREAM 0.5MG/GM\"WEIDAR\""
    },
    {
      "code" : "A028609100",
      "display" : "ISCOTIN TABLETS"
    },
    {
      "code" : "A028610100",
      "display" : "PYRUDON TABLETS 500MG \"T.F.\""
    },
    {
      "code" : "A028613148",
      "display" : "BISOLVON SOLUTION 2MG/ML (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A028613199",
      "display" : "BISOLVON SOLUTION 2MG/ML (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A028614100",
      "display" : "MEXITIL CAPSULES 100MG (MEXILETINE HYDROCHLORIDE)"
    },
    {
      "code" : "A028615500",
      "display" : "ECOZOL VAGINAL TABLETS 150MG \"WEIDAR\" (ECONAZOLE)"
    },
    {
      "code" : "A028616329",
      "display" : "PIFUSION CREAM 0.5MG/GM \"T.F.\"(FLUOCINONIDE)"
    },
    {
      "code" : "A028616330",
      "display" : "PIFUSION CREAM 0.5MG/GM \"T.F.\"(FLUOCINONIDE)"
    },
    {
      "code" : "A028618100",
      "display" : "SUTONLEN TABLETS"
    },
    {
      "code" : "A028619100",
      "display" : "ANTIRHEUMATIC CAPSULES 200MG \"T.F.\"(FLUFENAMIC ACID)"
    },
    {
      "code" : "A028623100",
      "display" : "Toeefon Capsules 500mg \"T.F.\""
    },
    {
      "code" : "A0286231G0",
      "display" : "Toeefon Capsules 500mg \"T.F.\""
    },
    {
      "code" : "A028642100",
      "display" : "CRIPTINE TABLETS 2.5MG (BROMOCRIPTINE)"
    },
    {
      "code" : "A028645157",
      "display" : "CENTRUM SYRUP \"LEDERLE\""
    },
    {
      "code" : "A028648100",
      "display" : "KETIBRON CAPSULES 1MG \"WEIDAR\" (KETOTIFEN)"
    },
    {
      "code" : "A0286481G0",
      "display" : "KETIBRON CAPSULES 1MG \"WEIDAR\" (KETOTIFEN)"
    },
    {
      "code" : "A028649100",
      "display" : "SECORIN S.C.TABLET 10MG \"STANDARD\" (OXAZOLAM)"
    },
    {
      "code" : "A0286491G0",
      "display" : "SECORIN S.C.TABLET 10MG \"STANDARD\" (OXAZOLAM)"
    },
    {
      "code" : "A028650209",
      "display" : "CETAX INJECTION \"STANDARD\" (CEFOTAXIME)"
    },
    {
      "code" : "A028650265",
      "display" : "CETAX INJECTION \"STANDARD\" (CEFOTAXIME)"
    },
    {
      "code" : "A028650277",
      "display" : "CETAX INJECTION \"STANDARD\" (CEFOTAXIME)"
    },
    {
      "code" : "A028656500",
      "display" : "VOREN SUPPOSITORIES 12.5MG (DICLOFENAC)"
    },
    {
      "code" : "A028657100",
      "display" : "PANCREATIN E.C. TABLETS 250MG \"CYANAMID\""
    },
    {
      "code" : "A028757100",
      "display" : "WINLIDON TABLETS \"WINSTON\""
    },
    {
      "code" : "A0287571G0",
      "display" : "WINLIDON TABLETS \"WINSTON\""
    },
    {
      "code" : "A028762100",
      "display" : "RIPOTRIN TABLETS 100MG (CYCLOBUTYROL)"
    },
    {
      "code" : "A028779100",
      "display" : "MEROLIN TABLETS 50MG \"H.S.\" (Mebhydroline)"
    },
    {
      "code" : "A0287791G0",
      "display" : "MEROLIN TABLETS 50MG \"H.S.\" (Mebhydroline)"
    },
    {
      "code" : "A028799100",
      "display" : "PYRAZEN TABLETS 500MG \"SINPHAR\"(PYRAZINAMIDE)"
    },
    {
      "code" : "A028800100",
      "display" : "MUCORA TABLETS 30MG  (IODOPROPYLIDROL GLYCEROL)\"YUNG SHIN\""
    },
    {
      "code" : "A028801100",
      "display" : "HALDOLIN TABLETS 5MG \"WEIDAR\" (HALOPERIDOL)"
    },
    {
      "code" : "A028803100",
      "display" : "YIAUKE TABLETS 100mg\"T.F.\""
    },
    {
      "code" : "A028804500",
      "display" : "MULTIDON SUPPOSITORY 25MG (DICLOFENAC)"
    },
    {
      "code" : "A028805500",
      "display" : "MULTIDON SUPPOSITORY 12.5MG (DICLOFENAC)"
    },
    {
      "code" : "A028814100",
      "display" : "BOCONGEN OUTWORM TABLETS 10MG (MEBENDAZOLE)\"C.M.\""
    },
    {
      "code" : "A028921100",
      "display" : "PICETAM CAPSULES 400MG \"STANDARD\" (PIRACETAM)"
    },
    {
      "code" : "A0289211G0",
      "display" : "PICETAM CAPSULES 400MG \"STANDARD\" (PIRACETAM)"
    },
    {
      "code" : "A028922100",
      "display" : "FUNOW CAPSULES 400MG (PIRACETAM)\"SPC\""
    },
    {
      "code" : "A028923377",
      "display" : "EUROTECH EUBAR OINTMENT"
    },
    {
      "code" : "A028923399",
      "display" : "EUROTECH EUBAR OINTMENT"
    },
    {
      "code" : "A028924377",
      "display" : "WINSOLVE FLARZON OINTMENT"
    },
    {
      "code" : "A028924399",
      "display" : "WINSOLVE FLARZON OINTMENT"
    },
    {
      "code" : "A028925321",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028925329",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028925335",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028925338",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028925377",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028925399",
      "display" : "WINSOLVE ECONAZINE CREAM"
    },
    {
      "code" : "A028927100",
      "display" : "LIPITIN TABLETS \"T.F.\""
    },
    {
      "code" : "A028928100",
      "display" : "CYANAMID TANNALBIN CAPSULES 500MG \"CYANAMID\" (ALBUMIN TANNATE)"
    },
    {
      "code" : "A028929500",
      "display" : "ANTI-ITCHING VAGINAL SUPOSITORY 200MG (POVIDONE IODINE)"
    },
    {
      "code" : "A028930417",
      "display" : "OXYTETRACYCLINE HCL WITH POLYMYXIN B SULFATE OPHTHALMIC OINTMENT"
    },
    {
      "code" : "A028930421",
      "display" : "OXYTETRACYCLINE HCL WITH POLYMYXIN B SULFATE OPHTHALMIC OINTMENT"
    },
    {
      "code" : "A028933100",
      "display" : "NIZORAL TABLETS 200MG (KETOCONAZOLE)"
    },
    {
      "code" : "A028934100",
      "display" : "ATROPINE SULFATE TABLETS 0.2MG \"U.L.\""
    },
    {
      "code" : "A028936100",
      "display" : "ASPIRIN TABLETS 300MG \"U.L.\""
    },
    {
      "code" : "A028938100",
      "display" : "PHENOBARBITAL TABLETS 30MG \"U.L.\""
    },
    {
      "code" : "A0289381G0",
      "display" : "PHENOBARBITAL TABLETS 30MG \"U.L.\""
    },
    {
      "code" : "A028939100",
      "display" : "CALCIUM CARBONATE TABLETS 500MG \"U.L.\""
    },
    {
      "code" : "A028940100",
      "display" : "FENBUPOL TABLETS 200MG (FENBUFEN)"
    },
    {
      "code" : "A028942100",
      "display" : "METHYLEPHEDRINE HCL TABLETS 25MG \"U.L.\""
    },
    {
      "code" : "A0289421G0",
      "display" : "METHYLEPHEDRINE HCL TABLETS 25MG \"U.L.\""
    },
    {
      "code" : "A028943100",
      "display" : "L.A. TABLET \"U.L.\""
    },
    {
      "code" : "A028944100",
      "display" : "PYRIDOXINE HCL TABLETS 5MG \"U.L.\""
    },
    {
      "code" : "A028945100",
      "display" : "AMINOPHYLLINE TABLETS 100MG \"U.L.\""
    },
    {
      "code" : "A0289451G0",
      "display" : "AMINOPHYLLINE TABLETS 100MG \"U.L.\""
    },
    {
      "code" : "A028947212",
      "display" : "G,T, INJECTION 140MG (GENTAMICIN)\"KINGDON\""
    },
    {
      "code" : "A028952343",
      "display" : "ULEX LOTION 10％(CROTAMITON)"
    },
    {
      "code" : "A028953329",
      "display" : "BEN GEL 0.025％ (BETAMETHASONE)"
    },
    {
      "code" : "A028954100",
      "display" : "PROGENA SUGAR COATED TABLETS 250MG  \"SINPHAR\"(PROTHIONAMIDE)"
    },
    {
      "code" : "A028955100",
      "display" : "SIBELIUM CAPSULES 5MG (FLUNARIZINE)"
    },
    {
      "code" : "A028956109",
      "display" : "DETICON GRANULES \"S.D.\""
    },
    {
      "code" : "A028956177",
      "display" : "DETICON GRANULES \"S.D.\""
    },
    {
      "code" : "A028956199",
      "display" : "DETICON GRANULES \"S.D.\""
    },
    {
      "code" : "A028957100",
      "display" : "DETICON TABLETS 25MG \"T.F.\""
    },
    {
      "code" : "A028958100",
      "display" : "CHOLEXAMIN TABLETS 200MG (NICOMOL)"
    },
    {
      "code" : "A028960212",
      "display" : "YESAMYCIN INJECTION 50MG/ML (SISOMYCIN)"
    },
    {
      "code" : "A028964318",
      "display" : "MEI DIM SOLUTION 10％(POVIDONE IODINE)\"C.M.\""
    },
    {
      "code" : "A028964399",
      "display" : "MEI DIM SOLUTION 10％(POVIDONE IODINE)\"C.M.\""
    },
    {
      "code" : "A028965100",
      "display" : "SUTA CAPSULES 300MG (FENBUFEN)\"C.M.\""
    },
    {
      "code" : "A028976100",
      "display" : "NEO-FLU CAPSULES"
    },
    {
      "code" : "A028982110",
      "display" : "ERYMYCIN (ERYTHROMYCIN ESTOLATE) FOR ORAL SUSPENSION \"VPP\""
    },
    {
      "code" : "A028983100",
      "display" : "METECOL TABLETS"
    },
    {
      "code" : "A028984100",
      "display" : "PARAFON FORTE TABLETS"
    },
    {
      "code" : "A028986100",
      "display" : "IMODIUM CAPSULES 2MG (LOPERAMIDE)"
    },
    {
      "code" : "A028990100",
      "display" : "PROFIT TABLETS 100MG (ATENOLOL)"
    },
    {
      "code" : "A028992221",
      "display" : "EUCTRIM INJECTION"
    },
    {
      "code" : "A029005417",
      "display" : "MYROSONE OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A029005421",
      "display" : "MYROSONE OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A029005423",
      "display" : "MYROSONE OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A029005455",
      "display" : "MYROSONE OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A029008100",
      "display" : "DICLOFENAC SODIUM TABLETS 25MG \"S.C.\""
    },
    {
      "code" : "A029011138",
      "display" : "BEROTEC SOLUTION 5MG/ML (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A029011199",
      "display" : "BEROTEC SOLUTION 5MG/ML (FENOTEROL HYDROBROMIDE)"
    },
    {
      "code" : "A029014435",
      "display" : "SINAZOL LONG-ACTING NASAL SPRAY"
    },
    {
      "code" : "A029033100",
      "display" : "REPICON CAPSULES"
    },
    {
      "code" : "A029034100",
      "display" : "METHYCOBAL CAPSULES 250UG \"EISAI\"(MECOBALAMIN)"
    },
    {
      "code" : "A0290341G0",
      "display" : "METHYCOBAL CAPSULES 250UG \"EISAI\"(MECOBALAMIN)"
    },
    {
      "code" : "A029036100",
      "display" : "AMANTADINE CAPSULES 100MG (AMANTADINE)\"GENTLE\""
    },
    {
      "code" : "A029037100",
      "display" : "RELAX CAPSULES"
    },
    {
      "code" : "A029039100",
      "display" : "TALACIN CAPSULES 250MG \"N.K.\"(TALAMPICILLIN)"
    },
    {
      "code" : "A029041112",
      "display" : "FEVER OFF GRANULES"
    },
    {
      "code" : "A029059100",
      "display" : "POSIPIN CAPSULES 10MG \"N.K.\"(NIFEDIPINE)"
    },
    {
      "code" : "A029060255",
      "display" : "SALZEN INJECTION 5MG\\ML \"N.K.\"(METRONIDAZOLE)"
    },
    {
      "code" : "A029060266",
      "display" : "SALZEN INJECTION 5MG\\ML \"N.K.\"(METRONIDAZOLE)"
    },
    {
      "code" : "A029061209",
      "display" : "HATERMAS INJECTION \"N.K.\""
    },
    {
      "code" : "A029061255",
      "display" : "HATERMAS INJECTION \"N.K.\""
    },
    {
      "code" : "A029061265",
      "display" : "HATERMAS INJECTION \"N.K.\""
    },
    {
      "code" : "A029061266",
      "display" : "HATERMAS INJECTION \"N.K.\""
    },
    {
      "code" : "A029061277",
      "display" : "HATERMAS INJECTION \"N.K.\""
    },
    {
      "code" : "A029063100",
      "display" : "GIPRIM TABLETS 100MG \"N.K.\" (TRIMETHOPRIM)"
    },
    {
      "code" : "A029065100",
      "display" : "SUFEN CAPSULE 1MG \"N.k.\" (KETOTIFEN)"
    },
    {
      "code" : "A029071209",
      "display" : "CEPOR INJECTION 1000MG \"N.K.\" (CEFOTAXIME)"
    },
    {
      "code" : "A029072277",
      "display" : "CEPOR INJECTION 500MG \"N.K.\"(CEFOTAXIME)"
    },
    {
      "code" : "A029073209",
      "display" : "NAKACEF A INJECTION 1000MG \"N.K.\"(CEPHRADINE)"
    },
    {
      "code" : "A029074277",
      "display" : "NAKACEF-A INJECTION 500MG \"N.K.\" (CEPHRADINE)"
    },
    {
      "code" : "A029076126",
      "display" : "COMFORT GRANULES \"N.K.\""
    },
    {
      "code" : "A029077100",
      "display" : "HELLON FILM COATED TABLETS 250MG (PROBUCOL)"
    },
    {
      "code" : "A029078209",
      "display" : "SHINFOMYCIN INJECTION  (CEFOPERAZONE)"
    },
    {
      "code" : "A029079100",
      "display" : "ZIEFMYCIN CAPSULES 250MG (DICLOXACILLIN)"
    },
    {
      "code" : "A029080100",
      "display" : "BROBEN S.C. TABLETS 400MG \"Y.S.\" (IBUPROFEN)"
    },
    {
      "code" : "A029084277",
      "display" : "MEDASON FOR INJECTION 500MG (METHYLPREDNISOLONE)\"N.K.\""
    },
    {
      "code" : "A029085245",
      "display" : "MEDASON FOR INJECTION"
    },
    {
      "code" : "A029085258",
      "display" : "MEDASON FOR INJECTION"
    },
    {
      "code" : "A029085265",
      "display" : "MEDASON FOR INJECTION"
    },
    {
      "code" : "A029085277",
      "display" : "MEDASON FOR INJECTION"
    },
    {
      "code" : "A029086100",
      "display" : "SOFTIN TABLETS 10MG \"Y.S.\" (BROMOPRIDE)"
    },
    {
      "code" : "A029089100",
      "display" : "ACETAMINOPHEN 500MG TABLETS"
    },
    {
      "code" : "A029090100",
      "display" : "TONFUL TABLETS"
    },
    {
      "code" : "A029091277",
      "display" : "CEFOTIN INJECTION 500MG (CEFOXITIN)\"N.K.\""
    },
    {
      "code" : "A029093277",
      "display" : "CEZONE INJECTION 500MG \"CEFOPERAZONE\""
    },
    {
      "code" : "A029106100",
      "display" : "BEHYD RA TABLETS"
    },
    {
      "code" : "A029108209",
      "display" : "BABYSALT INJECTION \"N.K.\""
    },
    {
      "code" : "A029108255",
      "display" : "BABYSALT INJECTION \"N.K.\""
    },
    {
      "code" : "A029108265",
      "display" : "BABYSALT INJECTION \"N.K.\""
    },
    {
      "code" : "A029108266",
      "display" : "BABYSALT INJECTION \"N.K.\""
    },
    {
      "code" : "A029108277",
      "display" : "BABYSALT INJECTION \"N.K.\""
    },
    {
      "code" : "A029117221",
      "display" : "CERECON INJECTION 1GM/5ML (PIRACETAM) \"KINGDOM\""
    },
    {
      "code" : "A029122100",
      "display" : "BAOJEN CAPSULES 5MG \"T.F.\" (FLUOXYMESTERONE)"
    },
    {
      "code" : "A029123109",
      "display" : "GOODMIN GRANULES \"T.F.\""
    },
    {
      "code" : "A029123157",
      "display" : "GOODMIN GRANULES \"T.F.\""
    },
    {
      "code" : "A029123199",
      "display" : "GOODMIN GRANULES \"T.F.\""
    },
    {
      "code" : "A029127321",
      "display" : "PEVARYL CREAM 1％ (ECONAZOLE)"
    },
    {
      "code" : "A029131100",
      "display" : "BLOODICON CAPSULES \"T.F.\""
    },
    {
      "code" : "A029132100",
      "display" : "ENSOQONE CAPSULES 50MG \"T.F.\""
    },
    {
      "code" : "A029133100",
      "display" : "MOTILIUM TABLETS 10MG (DOMPERIDONE)"
    },
    {
      "code" : "A029139100",
      "display" : "KETOZOL TABLETS 200MG (KETOCONAZOLE)\"WEIDER\""
    },
    {
      "code" : "A029141100",
      "display" : "SUTONY CAPSULES 250MG (NAPROXEN)\"C.M.\""
    },
    {
      "code" : "A029143100",
      "display" : "KONI CAPSULES \"C.M.\""
    },
    {
      "code" : "A029171100",
      "display" : "SERRA E.C. TABLETS (SERRATIOPEPTIDASE)\"H.H.\""
    },
    {
      "code" : "A0291711G0",
      "display" : "SERRA E.C. TABLETS (SERRATIOPEPTIDASE)\"H.H.\""
    },
    {
      "code" : "A029172100",
      "display" : "CEPHANMYCIN (R) CAPSULES 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A029173321",
      "display" : "HANDLIFE CREAM"
    },
    {
      "code" : "A029182338",
      "display" : "FUPAOKAN OINTMENT \"T.F.\" (FLUOCINOLONE)"
    },
    {
      "code" : "A029201135",
      "display" : "BERODUAL METERED AEROSOL"
    },
    {
      "code" : "A029202135",
      "display" : "ALUPENT METERED AEROSOL (ORCIPRENALINE SULFATE)"
    },
    {
      "code" : "A029207218",
      "display" : "HEMODIALYSIS SOLUTION NO.360 GA"
    },
    {
      "code" : "A029210100",
      "display" : "TRIDIGESTS TABLETS \"T.F.\""
    },
    {
      "code" : "A029213500",
      "display" : "Fungicidon Vaginal Suppositories 150mg \"T.F.\""
    },
    {
      "code" : "A029216100",
      "display" : "VITABUTYRIMIN TABLETS \"T.F.\""
    },
    {
      "code" : "A029217321",
      "display" : "ANTIFUNGUO CREAM \"T.F.\""
    },
    {
      "code" : "A029217329",
      "display" : "ANTIFUNGUO CREAM \"T.F.\""
    },
    {
      "code" : "A029217338",
      "display" : "ANTIFUNGUO CREAM \"T.F.\""
    },
    {
      "code" : "A029217377",
      "display" : "ANTIFUNGUO CREAM \"T.F.\""
    },
    {
      "code" : "A029217399",
      "display" : "ANTIFUNGUO CREAM \"T.F.\""
    },
    {
      "code" : "A029219500",
      "display" : "ANPISOL SUPPOSITORIES 325MG \"T.F.\" (ASPIRIN)"
    },
    {
      "code" : "A029220100",
      "display" : "FENSPIRIDE TABLETS 40MG \"P.L.\""
    },
    {
      "code" : "A029222500",
      "display" : "NAPOSIN SUPPOSITORIES 500MG (NAPROXEN)"
    },
    {
      "code" : "A029226100",
      "display" : "FUCOLE COLD CAPSULES"
    },
    {
      "code" : "A029227100",
      "display" : "DEXADROL TABLETS \"T.F.\""
    },
    {
      "code" : "A029231277",
      "display" : "ANOPIRIN INJECTION 500MG \"GENTLE\" (ACETYLSALICYLIC ACID)"
    },
    {
      "code" : "A029244421",
      "display" : "TROPICAMIDE OPHTHALMIC SOLUTION 0.5％ \"WU FU\""
    },
    {
      "code" : "A029244455",
      "display" : "TROPICAMIDE OPHTHALMIC SOLUTION 0.5％ \"WU FU\""
    },
    {
      "code" : "A029245209",
      "display" : "AMCEF FOR INJECTION 1000MG  (CEPHRADINE) \"TAI YU\""
    },
    {
      "code" : "A029247100",
      "display" : "SOURIREE COMCIDIN S.C. TABLETS"
    },
    {
      "code" : "A029249100",
      "display" : "U-PIRIDE TABLETS 200MG (SULPIRIDE)"
    },
    {
      "code" : "A029250100",
      "display" : "\"U-Liang\" U-PIRIDE TABLETS 50MG (SULPIRIDE)"
    },
    {
      "code" : "A0292501G0",
      "display" : "\"U-Liang\" U-PIRIDE TABLETS 50MG (SULPIRIDE)"
    },
    {
      "code" : "A029251100",
      "display" : "SERENIN TABLETS 10MG \"CHEN TA\" (OXAZOLAM)"
    },
    {
      "code" : "A029252100",
      "display" : "LIDONIN E.C. TABLETS 50MG  (DICLOFENAC)\"TAI YU\""
    },
    {
      "code" : "A029253100",
      "display" : "SOURIREE COM-COLD CO. CAPSULES"
    },
    {
      "code" : "A029254100",
      "display" : "TRIACTION F.C. TABLETS \"BOWLIN\""
    },
    {
      "code" : "A029255100",
      "display" : "FINA TABLETS"
    },
    {
      "code" : "A029273100",
      "display" : "ERADACIL CAPSULE 150MG (ROSOXACIN)"
    },
    {
      "code" : "A029274100",
      "display" : "LODOGAL CAPSULES 200MG (DANAZOL)"
    },
    {
      "code" : "A029276277",
      "display" : "AMINOPOLY-H INJECTION"
    },
    {
      "code" : "A029278216",
      "display" : "CIDIX INJECTION \"N.K.\""
    },
    {
      "code" : "A029279309",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279321",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279324",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279329",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279335",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279338",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279377",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029279399",
      "display" : "BESTASOL CREAM (CLOBETASOL)"
    },
    {
      "code" : "A029285100",
      "display" : "RESCOR TABLETS 20MG (EPRAZINONE HCL) \"YUNG CHI\""
    },
    {
      "code" : "A029286329",
      "display" : "\"C.B.\" BIODYNE OINTMENT (POVIDONE IODINE)"
    },
    {
      "code" : "A029287209",
      "display" : "PAPAVERINE HYDROCHLORIDE INJECTION 30MG/ML\"TWi\""
    },
    {
      "code" : "A029292209",
      "display" : "ULOTHIN NEUTRAL INJECTION (CEPHALOTHIN)"
    },
    {
      "code" : "A029292212",
      "display" : "ULOTHIN NEUTRAL INJECTION (CEPHALOTHIN)"
    },
    {
      "code" : "A029293212",
      "display" : "ULOTHIN NEUTRAL INJECTION 2.0GM (CEPHALOTHIN)"
    },
    {
      "code" : "A029295100",
      "display" : "ENDASE E.C. TABLETS 5MG \"H.K.\" (SERRATIOPEPTIDASE)"
    },
    {
      "code" : "A029297277",
      "display" : "FORAMIN INJECTION \"N.K.\""
    },
    {
      "code" : "A029298338",
      "display" : "LEEZE CREAM 50MG/G (BENZOYL PEROXIDE) \"ROYAL\""
    },
    {
      "code" : "A029301100",
      "display" : "CANCLIOL TABLETS 100MG (METOPROLOL) \"MEIDER\""
    },
    {
      "code" : "A029313100",
      "display" : "BETAPRESS TABLETS 100MG \"CHEN TA\" (METOPROLOL)"
    },
    {
      "code" : "A029316100",
      "display" : "SUGEN TABLETS 200MG (KETOCONAZOLE)\"C.M.\""
    },
    {
      "code" : "A029317118",
      "display" : "PORO (R) SOLUTION 24MG/ML (ACETAMINOPHEN)"
    },
    {
      "code" : "A029317199",
      "display" : "PORO (R) SOLUTION 24MG/ML (ACETAMINOPHEN)"
    },
    {
      "code" : "A029320100",
      "display" : "AMIZIDE TABLETS \"STANDARD\""
    },
    {
      "code" : "A029322209",
      "display" : "AMOCIL INJECTION 1000MG \"N.K.\" (AMOXYCILLIN)"
    },
    {
      "code" : "A029323277",
      "display" : "ASPARIN INJECTION 500MG \"N.K.\" (ASPIRIN)"
    },
    {
      "code" : "A029325100",
      "display" : "ESULIN TABLETS 100MG TOLAZAMIDE \"C.M.\""
    },
    {
      "code" : "A029327100",
      "display" : "WEISDIN F.C. TABLETS 400MG \"WEIDAR\" (CIMETIDINE)"
    },
    {
      "code" : "A0293271G0",
      "display" : "WEISDIN F.C. TABLETS 400MG \"WEIDAR\" (CIMETIDINE)"
    },
    {
      "code" : "A029328100",
      "display" : "HALDOLIN TABLETS 3MG \"WEIDAR\" (HALOPERIDOL)"
    },
    {
      "code" : "A029330277",
      "display" : "NAKO NO.4 INJECTION \"N.K.\""
    },
    {
      "code" : "A029331277",
      "display" : "NAKO NO.2 INJECTION \"N.K.\""
    },
    {
      "code" : "A029332277",
      "display" : "NAKO NO.3 INJECTION \"N.K.\""
    },
    {
      "code" : "A029333265",
      "display" : "NAKO NO.1 INJECTION \"N.K.\""
    },
    {
      "code" : "A029333277",
      "display" : "NAKO NO.1 INJECTION \"N.K.\""
    },
    {
      "code" : "A029334271",
      "display" : "NAKO NO.5 INJECTION \"N.K.\""
    },
    {
      "code" : "A029334277",
      "display" : "NAKO NO.5 INJECTION \"N.K.\""
    },
    {
      "code" : "A029337100",
      "display" : "DICLAZIDE TABLETS 80MG \"WEIDAR\" (GLICLAZIDE)"
    },
    {
      "code" : "A0293371G0",
      "display" : "DICLAZIDE TABLETS 80MG \"WEIDAR\" (GLICLAZIDE)"
    },
    {
      "code" : "A029341429",
      "display" : "PILOCARPINE HCL OPTHALMIC SOLRTION (O.P.D.) 4％"
    },
    {
      "code" : "A029342429",
      "display" : "PILOCARPINE HCL OPTHALMIC SOLUTION (O.P.D.) 2％"
    },
    {
      "code" : "A029343429",
      "display" : "NEOSTIGMINE METHYLSULFATE OPHTHALMIC SOLUTION (O.N.S.D.) 0.01％"
    },
    {
      "code" : "A029344429",
      "display" : "PILOCARPINE HCL OPHTHALMIC SOLUTION (O.P.D.) 1％"
    },
    {
      "code" : "A029345100",
      "display" : "FLAGYL ORAL TABLETS 250MG (METRONIDAZOLE)"
    },
    {
      "code" : "A029349100",
      "display" : "CIWETIN TABLETS 400 MG"
    },
    {
      "code" : "A0293491G0",
      "display" : "CIWETIN TABLETS 400 MG"
    },
    {
      "code" : "A029351209",
      "display" : "URAZONE INJECTION 1GM (CEFOPERAZONE)"
    },
    {
      "code" : "A029352100",
      "display" : "SUTENTEN TABLETS \"CHEN TA\""
    },
    {
      "code" : "A029353209",
      "display" : "LOFALIN INJECTION 1000MG (CEFAZOLIN SODIUM) \"GENTLE\""
    },
    {
      "code" : "A029354319",
      "display" : "CLOBESOL CREAM 0.5MG \"GENTLE\" (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A029354321",
      "display" : "CLOBESOL CREAM 0.5MG \"GENTLE\" (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A029354324",
      "display" : "CLOBESOL CREAM 0.5MG \"GENTLE\" (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A029354329",
      "display" : "CLOBESOL CREAM 0.5MG \"GENTLE\" (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A029355100",
      "display" : "STACAINE TABLETS \"STANDARD\""
    },
    {
      "code" : "A0293551G0",
      "display" : "STACAINE TABLETS \"STANDARD\""
    },
    {
      "code" : "A029356100",
      "display" : "MERISLON TABLETS 12MG (BETAHISTINE MESYLATE)"
    },
    {
      "code" : "A0293561G0",
      "display" : "MERISLON TABLETS 12MG (BETAHISTINE MESYLATE)"
    },
    {
      "code" : "A029357100",
      "display" : "COLIOPAN TABLETS 10MG (BUTROPIUM BROMIDE)"
    },
    {
      "code" : "A029362100",
      "display" : "TAGADIN TABLETS 200MG (CIMETIDINE)"
    },
    {
      "code" : "A029363209",
      "display" : "SHIOMARIN FOR INJECTION 0.5GM,0.1GM I.M. I.V. (LATAMOXEF)"
    },
    {
      "code" : "A029363277",
      "display" : "SHIOMARIN FOR INJECTION 0.5GM,0.1GM I.M. I.V. (LATAMOXEF)"
    },
    {
      "code" : "A029365100",
      "display" : "KEFLEX TABLETS 250MG (CEPHALEXIN)"
    },
    {
      "code" : "A029366216",
      "display" : "DICLOFENAC INJECTION 25MG/ML \"G.C.\" (DICLOFENAC)"
    },
    {
      "code" : "A029370100",
      "display" : "NIDEPIN CAPSULES \"UNION\" (NIFEDIPINE)"
    },
    {
      "code" : "A029371100",
      "display" : "THIAMCOL CAPSULES 250MG \"UNION\" (THIAMPHENICOL)"
    },
    {
      "code" : "A029372100",
      "display" : "SELITAN TABLETS 2MG (BROMAZEPAM)"
    },
    {
      "code" : "A029374100",
      "display" : "DIEN E.C. TABLETS 50MG \"S.T.\" (DICLOFENAC)"
    },
    {
      "code" : "A029375100",
      "display" : "CAMAPINE TABLETS 200MG \"P.L.\" (CARBAMAZEPINE)"
    },
    {
      "code" : "A029376100",
      "display" : "HISMANAL TABLETS 10MG (ASTEMIZOLE)"
    },
    {
      "code" : "A029378100",
      "display" : "SUMOFEN E.C. TABLETS 50MG (DICLOFENAC)"
    },
    {
      "code" : "A029379100",
      "display" : "MAXZIDE TABLETS \"MEIDER\""
    },
    {
      "code" : "A029417263",
      "display" : "TALAMIN-E INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029417277",
      "display" : "TALAMIN-E INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029418100",
      "display" : "PIECHAN TABLETS \"T.F.\""
    },
    {
      "code" : "A029422100",
      "display" : "VERMOX TABLETS 100MG (MEBENDAZOLE)"
    },
    {
      "code" : "A029427100",
      "display" : "STUGERON TABLETS 25MG (CINNARIZINE)"
    },
    {
      "code" : "A029432100",
      "display" : "PERSANTIN S.C. TABLETS 50MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A029435100",
      "display" : "AMINSUTA TABLETS \"C.M.\""
    },
    {
      "code" : "A029436100",
      "display" : "SINDIPINE MICROENCAPSULATED CAPSULE 10MG \"Y.S.\"(NIFEDIPINE)"
    },
    {
      "code" : "A029437100",
      "display" : "FENSCIN TABLETS 40MG \"YU SHENG\" (FENSPIRIDE)"
    },
    {
      "code" : "A029440100",
      "display" : "FUNAZINE TABLETS 10MG \"WEIDAR\" (FLUNARIZINE)"
    },
    {
      "code" : "A029441172",
      "display" : "COLDES GRANULES \"T.F.\""
    },
    {
      "code" : "A029442100",
      "display" : "AMANDIN CAPSULES 100MG \"YU SHENG\" (AMANTADIN)"
    },
    {
      "code" : "A029443100",
      "display" : "TENOL TABLETS 100MG \"Y.S.\" (ATENOLOL)"
    },
    {
      "code" : "A029447209",
      "display" : "Cefa Injection"
    },
    {
      "code" : "A029447212",
      "display" : "Cefa Injection"
    },
    {
      "code" : "A029447277",
      "display" : "Cefa Injection"
    },
    {
      "code" : "A029454100",
      "display" : "SUBOSHIN TABLETS 30MG \"C.M.\" (DILTIAZEM)"
    },
    {
      "code" : "A029455210",
      "display" : "PAREN-AID NO. 1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029455265",
      "display" : "PAREN-AID NO. 1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029455266",
      "display" : "PAREN-AID NO. 1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029455280",
      "display" : "PAREN-AID NO. 1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029455297",
      "display" : "PAREN-AID NO. 1 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029457212",
      "display" : "PAREN-AID NO. 2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029457265",
      "display" : "PAREN-AID NO. 2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029457271",
      "display" : "PAREN-AID NO. 2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029457283",
      "display" : "PAREN-AID NO. 2 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029458212",
      "display" : "PAREN-AID NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029458265",
      "display" : "PAREN-AID NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029458271",
      "display" : "PAREN-AID NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029458283",
      "display" : "PAREN-AID NO.3 INJECTION \"OTSUKA\""
    },
    {
      "code" : "A029465100",
      "display" : "METISONE TABLETS 2MG \"CHEN TA\" (METHYLPREDNISOLONE)"
    },
    {
      "code" : "A029470100",
      "display" : "DANAZOL CAPSULE 200MG \"TAI YU\""
    },
    {
      "code" : "A029473100",
      "display" : "ASO TABLETS 500MG (SUCRALFATE)"
    },
    {
      "code" : "A029474255",
      "display" : "METROCIN INJECTION (METRONIDAZOLE) \"CHI SENG\""
    },
    {
      "code" : "A029475265",
      "display" : "FRUCEOL INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029475266",
      "display" : "FRUCEOL INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029475277",
      "display" : "FRUCEOL INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029476100",
      "display" : "LUTIN R CAPSULES 10MG (OXAZOLAM)"
    },
    {
      "code" : "A0294761G0",
      "display" : "LUTIN R CAPSULES 10MG (OXAZOLAM)"
    },
    {
      "code" : "A029478100",
      "display" : "UROSIN FILM COATED TABLETS 100MG (ATENOLOL)"
    },
    {
      "code" : "A029482500",
      "display" : "BENLY SUPPOSITORIES 10MG \"T.F.\""
    },
    {
      "code" : "A029483118",
      "display" : "COMINDI ELIXIR"
    },
    {
      "code" : "A029483199",
      "display" : "COMINDI ELIXIR"
    },
    {
      "code" : "A029484100",
      "display" : "ALUFATE CHEWING TABLETS 1000 \"C.M.\" (SUCRALFATE)"
    },
    {
      "code" : "A029485100",
      "display" : "FANTASY CAPSULES 25MG \"C.M.\" (PHENYLPROPANOLAMINE)"
    },
    {
      "code" : "A029486100",
      "display" : "DACOTON TABLET \"STANDARD\""
    },
    {
      "code" : "A029496209",
      "display" : "PU-I NO.2 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029496265",
      "display" : "PU-I NO.2 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029496277",
      "display" : "PU-I NO.2 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029498100",
      "display" : "CLEAR TABLETS 200MG \"MEIDER\" (KETOCONAZOLE)"
    },
    {
      "code" : "A029499100",
      "display" : "TERSULTRAN TABLETS 2.5MG (TERBUTALINE) \"Lita\""
    },
    {
      "code" : "A029500100",
      "display" : "TRIMETHOPRIM TABLETS 100MG \"Y.S.\""
    },
    {
      "code" : "A029503100",
      "display" : "BROPAN TABLETS 3MG \"GENTLE\" (BROMAZEPAM)"
    },
    {
      "code" : "A029504209",
      "display" : "LOFADINE INJECTION 1000MG \"GENTLE\" (CEPHRADINE)"
    },
    {
      "code" : "A029506309",
      "display" : "PERITONEAL DIALYSIS SOLUTION-A \"S.T.\""
    },
    {
      "code" : "A029509100",
      "display" : "MOTRIN FCT 400MG (IBUPROFEN)"
    },
    {
      "code" : "A029510100",
      "display" : "BACCIDAL F.C. TABLETS 100mg (NORFLOXACIN)"
    },
    {
      "code" : "A029511100",
      "display" : "MANLSUN CAPSULES 30MG (FLURAZEPAM)"
    },
    {
      "code" : "A029513100",
      "display" : "ANTIGLUCON TABLETS 5MG \"T.F.\""
    },
    {
      "code" : "A0295131G0",
      "display" : "ANTIGLUCON TABLETS 5MG \"T.F.\""
    },
    {
      "code" : "A029514177",
      "display" : "AN-WENIN ORAL SUSPENSION \"CHI SHENG\""
    },
    {
      "code" : "A029514199",
      "display" : "AN-WENIN ORAL SUSPENSION \"CHI SHENG\""
    },
    {
      "code" : "A029515100",
      "display" : "SUCRA TABLETS 500 MG \"H.S.\" (SUCRALFATE)"
    },
    {
      "code" : "A029517277",
      "display" : "ELECTROSE INJECTION \"TAI YU\""
    },
    {
      "code" : "A029518100",
      "display" : "GOLD-SILVER CAPSULES"
    },
    {
      "code" : "A029521100",
      "display" : "C.M.T. TABLETS 400MG (CIMETIDINE)"
    },
    {
      "code" : "A029522209",
      "display" : "PRODIOL INJECTION \"TAI YU\""
    },
    {
      "code" : "A029523289",
      "display" : "MENIMYCIN INJECTION 750MG \"TAI YU\" (CEFUROXIME)"
    },
    {
      "code" : "A029524100",
      "display" : "TRIZIN CAPSULES 250MG \"TAI YU\" (CEFATRIZINE)"
    },
    {
      "code" : "A029525100",
      "display" : "NAKACEF CAPSULE 500MG \"N.K.\" (CEPHRADINE)"
    },
    {
      "code" : "A029526100",
      "display" : "NAKACEF CAPSULE 250MG \"N.K.\" (CEPHRADINE)"
    },
    {
      "code" : "A029528212",
      "display" : "JESOMYCIN INJECTION 50MG/ML \"N.K.\" (SISOMICIN)"
    },
    {
      "code" : "A029529209",
      "display" : "LEUKA INJECTION 1MG/ML (VINCRISTINE SULFATE)"
    },
    {
      "code" : "A029531116",
      "display" : "LIPOLYTE GRANULES"
    },
    {
      "code" : "A029535100",
      "display" : "DOQUA TABLETS (TRICHLORMETHIAZIDE)"
    },
    {
      "code" : "A029536100",
      "display" : "ASPIRIN TABLETS 500MG \"Y.C.\""
    },
    {
      "code" : "A029540100",
      "display" : "DAILAN TABLETS 250MG (METRONIDAZOLE) \" M.T.\""
    },
    {
      "code" : "A029541100",
      "display" : "METHYL CYSTEINE S.C. TABLETS 50MG \"M.T.\""
    },
    {
      "code" : "A029544100",
      "display" : "FLUFENAMIC ACID CAPSULES \"M.T.\""
    },
    {
      "code" : "A029545100",
      "display" : "Metoco Tablets \"M.T.\" (Metoclopramide HCl)"
    },
    {
      "code" : "A029546100",
      "display" : "METHYLTESTOSTERONE CAPSULES 10MG \"M.T.\""
    },
    {
      "code" : "A029549100",
      "display" : "SUGENT CAPSULES 10MG (CHLORDIAZEPOXIDE HYDROCHLORIDE )\"M.T.\""
    },
    {
      "code" : "A0295491G0",
      "display" : "SUGENT CAPSULES 10MG (CHLORDIAZEPOXIDE HYDROCHLORIDE )\"M.T.\""
    },
    {
      "code" : "A029550100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"Y.S.\""
    },
    {
      "code" : "A029551100",
      "display" : "YUPIN CAPSULES 10MG \"YU SHENG\"(OXAZOLAM)"
    },
    {
      "code" : "A029552100",
      "display" : "PROCOL TABLETS 250MG \"YU SHENG\" (PROBUCOL)"
    },
    {
      "code" : "A029554100",
      "display" : "BOUSENG-P F.C. TABLETS"
    },
    {
      "code" : "A029555100",
      "display" : "ANSTIN S.C. TABLETS"
    },
    {
      "code" : "A029557100",
      "display" : "KARIMOX TABLETS (MEBENDAZOLE) \"JILLY\""
    },
    {
      "code" : "A029558500",
      "display" : "SHOREN SUPPOSITORIES 12.5MG \"T.F.\" (DICLOFENAC)"
    },
    {
      "code" : "A029559500",
      "display" : "SHOREN SUPPOSITORIES 25MG \"T.F.\" (DICLOFENAC)"
    },
    {
      "code" : "A029562100",
      "display" : "OXY TABLETS 100MG \"T.F.\""
    },
    {
      "code" : "A029563329",
      "display" : "NYSUL CREAM 30MG/GM (NIFLUMIC ACID)"
    },
    {
      "code" : "A029564100",
      "display" : "ANASIN CAPSULES 100MG (AMANTADINE)"
    },
    {
      "code" : "A029572100",
      "display" : "Suzin Capsules 5mg \"Standard\" (Flunarizine)"
    },
    {
      "code" : "A029573329",
      "display" : "PRASONE CREAM \"STANDARD\""
    },
    {
      "code" : "A029574329",
      "display" : "SONGI OINTMENT \"STANDARD\""
    },
    {
      "code" : "A029574371",
      "display" : "SONGI OINTMENT \"STANDARD\""
    },
    {
      "code" : "A029574399",
      "display" : "SONGI OINTMENT \"STANDARD\""
    },
    {
      "code" : "A029575100",
      "display" : "Suzin Capsules 10mg \"Standard\" (Flunarizine)"
    },
    {
      "code" : "A029576100",
      "display" : "SERELAM CAPSULES 10MG \"WEIDAR\" (OXAZOLAM)"
    },
    {
      "code" : "A029580100",
      "display" : "OS-CAL TABLETS 500MG"
    },
    {
      "code" : "A029581100",
      "display" : "DICENS TABLETS 50MG (DICLOFENAC)"
    },
    {
      "code" : "A029584100",
      "display" : "CABAPIN TABLETS 200MG \"GENTLE\" (CARBAMAZEPINE)"
    },
    {
      "code" : "A029587212",
      "display" : "TOGAMYCIN (R) INJECTION 2GM (SPECTINOMYCIN HYDROCHLORIDE)"
    },
    {
      "code" : "A029588212",
      "display" : "NEBCIN INJECTION 40MG/ML"
    },
    {
      "code" : "A029590100",
      "display" : "CANERCON CAPSULES \"T.F.\""
    },
    {
      "code" : "A029594100",
      "display" : "ZECO TABLETS 100MG \"Y.S.\"(OXOLAMINE CITRATE)"
    },
    {
      "code" : "A029595100",
      "display" : "LESYJIA CAPSULES 400MG \"C.M.\" (PIRACETAM)"
    },
    {
      "code" : "A029596212",
      "display" : "NEBCIN INJECTION 10MG/ML"
    },
    {
      "code" : "A029598155",
      "display" : "AMANTA SOLUTION 10MG/ML \"GENTLE\" (AMANTADINE HCL)"
    },
    {
      "code" : "A029598177",
      "display" : "AMANTA SOLUTION 10MG/ML \"GENTLE\" (AMANTADINE HCL)"
    },
    {
      "code" : "A029598199",
      "display" : "AMANTA SOLUTION 10MG/ML \"GENTLE\" (AMANTADINE HCL)"
    },
    {
      "code" : "A029599100",
      "display" : "U-SAVE CAPSULES 250MG (CEPHRADINE)"
    },
    {
      "code" : "A029600209",
      "display" : "U-SAVE FOR INJECTION"
    },
    {
      "code" : "A029601100",
      "display" : "PREDNISOLONE TABLETS  5MG"
    },
    {
      "code" : "A029608500",
      "display" : "SUMOFEN SUPPOSITORY 12.5MG (DICLOFENAC)"
    },
    {
      "code" : "A029609500",
      "display" : "SUMOFEN SUPPOSITORY 25MG (DICLOFENAC)"
    },
    {
      "code" : "A029611100",
      "display" : "MEFENAMIC ACID CAPSULES \"M.T.\""
    },
    {
      "code" : "A029612335",
      "display" : "NIZORAL CREAM 20MG/GM (KETOCONAZOLE)"
    },
    {
      "code" : "A029613100",
      "display" : "MEBENDAZOLE TABLETS 100MG \"CHEN TA\""
    },
    {
      "code" : "A0296131G0",
      "display" : "MEBENDAZOLE TABLETS 100MG \"CHEN TA\""
    },
    {
      "code" : "A029615100",
      "display" : "SALET TABLETS 500MG \"TAI YU\" (SUCRALFATE)"
    },
    {
      "code" : "A029617100",
      "display" : "UROXATE F.C. TABLETS 200MG \"WEIDAR\" (FLAVOXATE)"
    },
    {
      "code" : "A029619100",
      "display" : "VETA-BC TABLETS"
    },
    {
      "code" : "A029620100",
      "display" : "DOGMATYL FILM COATED TABLETS 100MG"
    },
    {
      "code" : "A029623100",
      "display" : "LACEF CAPSULES 500MG \"TAI YU\" (CEPHRADINE)"
    },
    {
      "code" : "A029625100",
      "display" : "FLUENCY (R) CAPSULES"
    },
    {
      "code" : "A029627100",
      "display" : "TINIDAZOLE FILM COATED TABLETS \"YONG SHIN\""
    },
    {
      "code" : "A029628100",
      "display" : "OS-CAL S.C. TABLETS"
    },
    {
      "code" : "A029629100",
      "display" : "BUCOL TABLETS 250MG (PROBUCOL)"
    },
    {
      "code" : "A029630100",
      "display" : "METHYCOBAL CAPSULES 500UG \"EISAI\" (MECOBALAMIN)"
    },
    {
      "code" : "A029631118",
      "display" : "PEDOLIN SYRUP \"STANDARD\""
    },
    {
      "code" : "A029631157",
      "display" : "PEDOLIN SYRUP \"STANDARD\""
    },
    {
      "code" : "A029631199",
      "display" : "PEDOLIN SYRUP \"STANDARD\""
    },
    {
      "code" : "A029634118",
      "display" : "NOCOUGH SYRUP \"SINPHAR\""
    },
    {
      "code" : "A029634151",
      "display" : "NOCOUGH SYRUP \"SINPHAR\""
    },
    {
      "code" : "A029634157",
      "display" : "NOCOUGH SYRUP \"SINPHAR\""
    },
    {
      "code" : "A029634199",
      "display" : "NOCOUGH SYRUP \"SINPHAR\""
    },
    {
      "code" : "A029635100",
      "display" : "CINNARIZINE TABLETS \"YUNG SHIN\""
    },
    {
      "code" : "A029636100",
      "display" : "DIANOL TABLETS 25MG \"SINPHAR\" (CHLOPHEDIANOL HYDROCHLORIDE)"
    },
    {
      "code" : "A029637100",
      "display" : "P AND P CAPSULES 75MG (PHENYLPROPANOLAMINE)"
    },
    {
      "code" : "A029697100",
      "display" : "ULOSINA CAPSULES (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A029701110",
      "display" : "ULOSINA FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A029701139",
      "display" : "ULOSINA FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A029701180",
      "display" : "ULOSINA FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A029701199",
      "display" : "ULOSINA FOR ORAL SUSPENSION (ERYTHROMYCIN ESTOLATE)"
    },
    {
      "code" : "A029702100",
      "display" : "AMANDINE TABLETS 100MG \"H.H.\" (AMANTADINE)"
    },
    {
      "code" : "A029704100",
      "display" : "DOLCID TABLETS 400MG \"SINPHAR\"(PIPEMIDIC ACID)"
    },
    {
      "code" : "A029707427",
      "display" : "TOBISPRAY METERED NASAL SPRAY"
    },
    {
      "code" : "A029714100",
      "display" : "VOLBRO CAPSULES 1.25MG (BROMOCRIPTINE)"
    },
    {
      "code" : "A029715100",
      "display" : "MELON TABLETS (MEPIRIZOLE) \"H.S.C.\""
    },
    {
      "code" : "A029721500",
      "display" : "DICLOFENAC SUPPOSITORY"
    },
    {
      "code" : "A029722309",
      "display" : "FLUCONIN S CREAM 0.5MG/GM"
    },
    {
      "code" : "A029722321",
      "display" : "FLUCONIN S CREAM 0.5MG/GM"
    },
    {
      "code" : "A029722329",
      "display" : "FLUCONIN S CREAM 0.5MG/GM"
    },
    {
      "code" : "A029722399",
      "display" : "FLUCONIN S CREAM 0.5MG/GM"
    },
    {
      "code" : "A029726500",
      "display" : "CHLOTIN VAGINAL SUPPOSITORIES \"YUNG SHIN\""
    },
    {
      "code" : "A029727100",
      "display" : "BECAME TABLETS"
    },
    {
      "code" : "A029728209",
      "display" : "UNITAX INJECTION \"UNION\""
    },
    {
      "code" : "A029728277",
      "display" : "UNITAX INJECTION \"UNION\""
    },
    {
      "code" : "A029729100",
      "display" : "SUCRAL TABLETS 500MG \"VPP\""
    },
    {
      "code" : "A0297291G0",
      "display" : "SUCRAL TABLETS 500MG \"VPP\""
    },
    {
      "code" : "A029730100",
      "display" : "YUCOMY TABLETS 200MG (KETOCONAZOLE)"
    },
    {
      "code" : "A029733100",
      "display" : "ANSUTAL TABLETS 40MG (FENSPIRIDE)"
    },
    {
      "code" : "A029735100",
      "display" : "TIATENOL TABLETS 100MG \"T.F.\""
    },
    {
      "code" : "A029736100",
      "display" : "ULSAWE TABLETS 500MG \"T.F.\"(SUCRALFATE)"
    },
    {
      "code" : "A029737100",
      "display" : "ESKIMON TABLETS 250MG (PROBUCOL)"
    },
    {
      "code" : "A029738209",
      "display" : "SUNTOSE INJECTION 0.45％ \"N.K.\""
    },
    {
      "code" : "A029738255",
      "display" : "SUNTOSE INJECTION 0.45％ \"N.K.\""
    },
    {
      "code" : "A029738265",
      "display" : "SUNTOSE INJECTION 0.45％ \"N.K.\""
    },
    {
      "code" : "A029738277",
      "display" : "SUNTOSE INJECTION 0.45％ \"N.K.\""
    },
    {
      "code" : "A029739329",
      "display" : "TOPSYM LOTION (FLUOCINONIDE)"
    },
    {
      "code" : "A029739338",
      "display" : "TOPSYM LOTION (FLUOCINONIDE)"
    },
    {
      "code" : "A029740100",
      "display" : "A.A.C. TABLETS"
    },
    {
      "code" : "A029742277",
      "display" : "BIOLYTE NO.4 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029743277",
      "display" : "BIOLYTE NO.3 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029744277",
      "display" : "BIOLYTE NO.2 INJECTION \"CHI SHENG\""
    },
    {
      "code" : "A029746209",
      "display" : "EUJUM INJECTION 5MG/ML (PROSTAGLANDIN F2)"
    },
    {
      "code" : "A029747100",
      "display" : "FOCUS CAPSULES 10MG (PIROXICAM)"
    },
    {
      "code" : "A0297471G0",
      "display" : "FOCUS CAPSULES 10MG (PIROXICAM)"
    },
    {
      "code" : "A029748100",
      "display" : "CINCA S.C. TABLETS 50MG \"Y.S.\" (NICAMETATE)"
    },
    {
      "code" : "A029749100",
      "display" : "PEDIC F.C. TABLETS 250MG \"TAI YU\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A029751100",
      "display" : "ANTADIN CAPSULES 100MG (AMANTADINE) \"N.K.\""
    },
    {
      "code" : "A029752100",
      "display" : "ALLERGEN TABLETS 50MG \"CHEN TA\" (MEBHYDROLIN)"
    },
    {
      "code" : "A029753100",
      "display" : "STONE TABLETS 500MG \"UHC.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A029754100",
      "display" : "MUSOLIN TABLETS \"S.D.\""
    },
    {
      "code" : "A029755500",
      "display" : "EKONA VAGINAL SUP. (ECONAZOLE)"
    },
    {
      "code" : "A029758110",
      "display" : "ACETIN GRANULES 66.67MG/GM \"TAI YU\" (ACETYLCYSTEINE)"
    },
    {
      "code" : "A029758116",
      "display" : "ACETIN GRANULES 66.67MG/GM \"TAI YU\" (ACETYLCYSTEINE)"
    },
    {
      "code" : "A029758177",
      "display" : "ACETIN GRANULES 66.67MG/GM \"TAI YU\" (ACETYLCYSTEINE)"
    },
    {
      "code" : "A029758199",
      "display" : "ACETIN GRANULES 66.67MG/GM \"TAI YU\" (ACETYLCYSTEINE)"
    },
    {
      "code" : "A029759100",
      "display" : "MAIYITONG CAPSULES 0.5MG (METHYLCOBALAMIN)\"C.M.\""
    },
    {
      "code" : "A029760421",
      "display" : "GARABETA EYE DROPS \"WINSTON\""
    },
    {
      "code" : "A029761100",
      "display" : "AYLEHNING CAPSULES 250MG \"C.M.\" (CHENODEOXYCHOLIC ACID)"
    },
    {
      "code" : "A029764100",
      "display" : "PENSIN TABLETS \"CURIE\" (ATENOLOL)"
    },
    {
      "code" : "A029765100",
      "display" : "PERDAMOLE F.C. TABLETS 25MG \"T.F.\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A029766100",
      "display" : "PERDAMOLE F.C. TABLETS 75MG \"T.F.\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A029767100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"Y.S.\""
    },
    {
      "code" : "A029768343",
      "display" : "SULON OINTMENT \"L.S.\""
    },
    {
      "code" : "A029774100",
      "display" : "KETAZOLE TABLETS 200MG \"UNION\" (KETOCONAZOLE)"
    },
    {
      "code" : "A029784100",
      "display" : "ERGOMETRINE TABLETS 0.2MG \"YUNG SHIN\""
    },
    {
      "code" : "A029786100",
      "display" : "GLUCOLIN TABLETS (GLICLAZIDE)"
    },
    {
      "code" : "A029788100",
      "display" : "COMFORT E.C. TABLETS 650MG \"MEIDER\""
    },
    {
      "code" : "A029789321",
      "display" : "EXELDERM CREAM (SULCONAZOLE)"
    },
    {
      "code" : "A029789329",
      "display" : "EXELDERM CREAM (SULCONAZOLE)"
    },
    {
      "code" : "A029789338",
      "display" : "EXELDERM CREAM (SULCONAZOLE)"
    },
    {
      "code" : "A029790329",
      "display" : "EXELDERM SOLUTION (SULCONAZOLE)"
    },
    {
      "code" : "A029791209",
      "display" : "PITAMYCIN INJECTION 1GM, 2GM, 4GM, (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A029791212",
      "display" : "PITAMYCIN INJECTION 1GM, 2GM, 4GM, (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A029791219",
      "display" : "PITAMYCIN INJECTION 1GM, 2GM, 4GM, (PIPERACILLIN SODIUM)"
    },
    {
      "code" : "A029793100",
      "display" : "MULER TABLETS 200MG (FENBUFEN) \"GENTLE\""
    },
    {
      "code" : "A029794100",
      "display" : "SENTA TABLETS 250MG (DIFLUNISAL)\"GENTLE\""
    },
    {
      "code" : "A029796100",
      "display" : "ENZIL TABLETS 100MG (AMANTADINE)"
    },
    {
      "code" : "A029797100",
      "display" : "CIWEI TABLETS 200MG \"H.H.\" (CIMETIDINE)"
    },
    {
      "code" : "A0297971G0",
      "display" : "CIWEI TABLETS 200MG \"H.H.\" (CIMETIDINE)"
    },
    {
      "code" : "A029798100",
      "display" : "CIWEI TABLETS 400MG \"H.H.\"(CIMETIDINE)"
    },
    {
      "code" : "A0297981G0",
      "display" : "CIWEI TABLETS 400MG \"H.H.\"(CIMETIDINE)"
    },
    {
      "code" : "A029802100",
      "display" : "CEFADROXIL CAPSULES 500MG"
    },
    {
      "code" : "A029803377",
      "display" : "AUFIZIN CREAM 10MG/GM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A029803399",
      "display" : "AUFIZIN CREAM 10MG/GM (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A029804100",
      "display" : "SHPYNJA TABLETS \"C.M.\""
    },
    {
      "code" : "A029805100",
      "display" : "DEURON TABLETS 50MG \"YU SHENG\" (BENZBROMARONE)"
    },
    {
      "code" : "A0298051G0",
      "display" : "DEURON TABLETS 50MG \"YU SHENG\" (BENZBROMARONE)"
    },
    {
      "code" : "A029806100",
      "display" : "TOPHARDIN TABLETS (AMANTADINE HCL)"
    },
    {
      "code" : "A029809100",
      "display" : "MEBENDAZOLE TABLETS 100MG \"H.S.C.\""
    },
    {
      "code" : "A029810100",
      "display" : "TRILONE TABLETS 4MG \"H.H.\" (TRIAMCINOLONE)"
    },
    {
      "code" : "A0298101G0",
      "display" : "TRILONE TABLETS 4MG \"H.H.\" (TRIAMCINOLONE)"
    },
    {
      "code" : "A029811100",
      "display" : "KALIPION CAPSULES 250MG (CLOFIBRATE) \"YUNG SHIN\""
    },
    {
      "code" : "A029812100",
      "display" : "SCOTON TABLETS 400MG (IBUPROFEN)"
    },
    {
      "code" : "A029813216",
      "display" : "IMIDAKIN VIAL 500MG/3ML(ORNIDAZOLE)"
    },
    {
      "code" : "A029814100",
      "display" : "U-COMPHEN TABLETS"
    },
    {
      "code" : "A029823100",
      "display" : "AMANTEC CAPSULES 100MG (AMANTADINE)"
    },
    {
      "code" : "A029824100",
      "display" : "DIMAX TABLETS 80MG"
    },
    {
      "code" : "A029825321",
      "display" : "Cort. S. Ointment 1％ \"Lotus\" (HYDROCORTISONE ACETATE)"
    },
    {
      "code" : "A029825348",
      "display" : "Cort. S. Ointment 1％ \"Lotus\" (HYDROCORTISONE ACETATE)"
    },
    {
      "code" : "A029826100",
      "display" : "HUA FON LIN CAPSULES 50MG \"TK&A\" (BENZBROMARONE)"
    },
    {
      "code" : "A029827109",
      "display" : "UNIDROXYL POWDER FOR ORAL SUSPENSION (CEFADROXIL)\"UNION\""
    },
    {
      "code" : "A029827110",
      "display" : "UNIDROXYL POWDER FOR ORAL SUSPENSION (CEFADROXIL)\"UNION\""
    },
    {
      "code" : "A029827199",
      "display" : "UNIDROXYL POWDER FOR ORAL SUSPENSION (CEFADROXIL)\"UNION\""
    },
    {
      "code" : "A029828100",
      "display" : "KASCOAL TABLETS 40MG (DIMETHYLPOLYSILOXANE)"
    },
    {
      "code" : "A029833100",
      "display" : "KAICIDE TABLETS 600MG (PRAZIQUANTEL)"
    },
    {
      "code" : "A029834209",
      "display" : "SUNTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029834255",
      "display" : "SUNTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029834265",
      "display" : "SUNTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029834277",
      "display" : "SUNTOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029835209",
      "display" : "GITOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029835238",
      "display" : "GITOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029835255",
      "display" : "GITOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029835265",
      "display" : "GITOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029835277",
      "display" : "GITOSE INJECTION 5％ \"N.K.\""
    },
    {
      "code" : "A029836209",
      "display" : "SALINE INJECTION 0.9％ \"N.K.\""
    },
    {
      "code" : "A029836238",
      "display" : "SALINE INJECTION 0.9％ \"N.K.\""
    },
    {
      "code" : "A029836255",
      "display" : "SALINE INJECTION 0.9％ \"N.K.\""
    },
    {
      "code" : "A029836265",
      "display" : "SALINE INJECTION 0.9％ \"N.K.\""
    },
    {
      "code" : "A029836277",
      "display" : "SALINE INJECTION 0.9％ \"N.K.\""
    },
    {
      "code" : "A029837209",
      "display" : "HAFORMAN  INJECTION \"N.K.\""
    },
    {
      "code" : "A029837238",
      "display" : "HAFORMAN  INJECTION \"N.K.\""
    },
    {
      "code" : "A029837255",
      "display" : "HAFORMAN  INJECTION \"N.K.\""
    },
    {
      "code" : "A029837265",
      "display" : "HAFORMAN  INJECTION \"N.K.\""
    },
    {
      "code" : "A029837277",
      "display" : "HAFORMAN  INJECTION \"N.K.\""
    },
    {
      "code" : "A029838209",
      "display" : "GITOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A029838255",
      "display" : "GITOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A029838265",
      "display" : "GITOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A029838277",
      "display" : "GITOSE INJECTION 10％ \"N.K.\""
    },
    {
      "code" : "A029847157",
      "display" : "ANSOUHAU SYRUP \"H.S.\""
    },
    {
      "code" : "A029849100",
      "display" : "NISAUHOU CAPSULES \"HS\""
    },
    {
      "code" : "A029851100",
      "display" : "GINGTOR TABLETS 5MG (DIAZEPAM) \"HS\""
    },
    {
      "code" : "A029852329",
      "display" : "SFUSONE CREAM 5MG/G (TRIAMCINOLONE ACETONIDE) \"H.S.\""
    },
    {
      "code" : "A029852372",
      "display" : "SFUSONE CREAM 5MG/G (TRIAMCINOLONE ACETONIDE) \"H.S.\""
    },
    {
      "code" : "A029852399",
      "display" : "SFUSONE CREAM 5MG/G (TRIAMCINOLONE ACETONIDE) \"H.S.\""
    },
    {
      "code" : "A029853100",
      "display" : "KANMAU CAPSULES \"HS\""
    },
    {
      "code" : "A029855100",
      "display" : "SIAOYEN TABLETS 500MG (SULFAMETHOXYPYRIDAZINE) \"HS\""
    },
    {
      "code" : "A029859100",
      "display" : "COCHILIN CAPSULES \"HS\""
    },
    {
      "code" : "A0298591G0",
      "display" : "COCHILIN CAPSULES \"HS\""
    },
    {
      "code" : "A029860100",
      "display" : "ISIHTONNIN CAPSULES 50MG (KETOPROFEN) \"HS\""
    },
    {
      "code" : "A0298601G0",
      "display" : "ISIHTONNIN CAPSULES 50MG (KETOPROFEN) \"HS\""
    },
    {
      "code" : "A029863100",
      "display" : "Shikenuoh Tablets 500mg \"H.S.\""
    },
    {
      "code" : "A029865100",
      "display" : "CHIA LO HSIN CAPSULES 200MG (OXTRIPHYLLINE) \"HS\""
    },
    {
      "code" : "A029866100",
      "display" : "HIRANIN CAPSULES 350MG (CARISOPRODOL) \"HS\""
    },
    {
      "code" : "A029867100",
      "display" : "ANTIRHEUMATIC CAPSULES 25MG (INDOMETHACIN) \"HS\""
    },
    {
      "code" : "A0298671G0",
      "display" : "ANTIRHEUMATIC CAPSULES 25MG (INDOMETHACIN) \"HS\""
    },
    {
      "code" : "A029872100",
      "display" : "CHUNGYACHING TABLETS \"HS\""
    },
    {
      "code" : "A029874100",
      "display" : "VOTONNIN CAPSULES 25MG (DICLOFENAC) \"HS\""
    },
    {
      "code" : "A0298741G0",
      "display" : "VOTONNIN CAPSULES 25MG (DICLOFENAC) \"HS\""
    },
    {
      "code" : "A029875100",
      "display" : "HOW NAMIN CAPSULES \"HS\""
    },
    {
      "code" : "A0298751G0",
      "display" : "HOW NAMIN CAPSULES \"HS\""
    },
    {
      "code" : "A029876321",
      "display" : "BETAZOLE CREAM \"KINGDOM\""
    },
    {
      "code" : "A029876329",
      "display" : "BETAZOLE CREAM \"KINGDOM\""
    },
    {
      "code" : "A029876340",
      "display" : "BETAZOLE CREAM \"KINGDOM\""
    },
    {
      "code" : "A029881100",
      "display" : "PROPRANOLOL TABLETS 40MG \"YUNG SHIN\""
    },
    {
      "code" : "A029882100",
      "display" : "SOCHIN FILM COATED TABLETS 60MG (PANTETHINE)"
    },
    {
      "code" : "A029885100",
      "display" : "Toeefon Film Coated Tablets 500mg \"T.F.\""
    },
    {
      "code" : "A029886118",
      "display" : "CHILDREN'S PANACON SOLUTION"
    },
    {
      "code" : "A029886199",
      "display" : "CHILDREN'S PANACON SOLUTION"
    },
    {
      "code" : "A029888100",
      "display" : "ASPIRIN ENTERIC FILM COATED TABLETS 650MG \"T.F.\""
    },
    {
      "code" : "A029889209",
      "display" : "CEDOL FOR INJECTION 500MG (CEFAMANDOLE NAFATE)"
    },
    {
      "code" : "A029889212",
      "display" : "CEDOL FOR INJECTION 500MG (CEFAMANDOLE NAFATE)"
    },
    {
      "code" : "A029889277",
      "display" : "CEDOL FOR INJECTION 500MG (CEFAMANDOLE NAFATE)"
    },
    {
      "code" : "A029903329",
      "display" : "INDECIN CREAM (INDOMETHACIN)"
    },
    {
      "code" : "A029905100",
      "display" : "NOSPAN (R) TABLETS 30MG (DEXTROMETHORPHAN)"
    },
    {
      "code" : "A029906100",
      "display" : "FUCOLE NOSPAN TABLETS 15MG"
    },
    {
      "code" : "A029907118",
      "display" : "CODENIN SYRUP \"H.S.\""
    },
    {
      "code" : "A029907151",
      "display" : "CODENIN SYRUP \"H.S.\""
    },
    {
      "code" : "A029907157",
      "display" : "CODENIN SYRUP \"H.S.\""
    },
    {
      "code" : "A029907199",
      "display" : "CODENIN SYRUP \"H.S.\""
    },
    {
      "code" : "A0299071AV",
      "display" : "CODENIN SYRUP \"H.S.\""
    },
    {
      "code" : "A029911100",
      "display" : "CHINGPAO S.G. TABLETS"
    },
    {
      "code" : "A029912100",
      "display" : "NYSTATIN CAPSULES"
    },
    {
      "code" : "A029913265",
      "display" : "TALAMIN-HEPA INJECTION"
    },
    {
      "code" : "A029913277",
      "display" : "TALAMIN-HEPA INJECTION"
    },
    {
      "code" : "A029917100",
      "display" : "KASCOAL TABLETS 50MG (DIMETHYLPOLYSILOXANE)"
    },
    {
      "code" : "A029919177",
      "display" : "UNIDROXYL GRANULES 200MG/GM (CEFADROXIL)\"UNION\""
    },
    {
      "code" : "A029919199",
      "display" : "UNIDROXYL GRANULES 200MG/GM (CEFADROXIL)\"UNION\""
    },
    {
      "code" : "A029927100",
      "display" : "WEITUNLE TABLETS \"HS\""
    },
    {
      "code" : "A029929100",
      "display" : "METHYLTESTOSTERONE CAPSULES 10MG (METHYLTESTOSTERONE) \"HS\""
    },
    {
      "code" : "A029931100",
      "display" : "CHANSIAN CAPSULES 5MG (PREDNISOLONE) \"HS\""
    },
    {
      "code" : "A029933100",
      "display" : "TIBILIN S.C. TABLETS \"H.S.\""
    },
    {
      "code" : "A029937100",
      "display" : "Malenate Tablets 4mg \"H.S.\"(Chlorpheniramine Maleate)"
    },
    {
      "code" : "A029944100",
      "display" : "HOREMAN (R) TABLETS 150MG (XANTHINOL NICOTINATE)"
    },
    {
      "code" : "A029949324",
      "display" : "AKANA CREAM (BENZOYL PEROXIDE)"
    },
    {
      "code" : "A029951100",
      "display" : "DOTIDONE TABLETS 10MG (DOMPERIDONE)\"CBC\""
    },
    {
      "code" : "A0299511G0",
      "display" : "DOTIDONE TABLETS 10MG (DOMPERIDONE)\"CBC\""
    },
    {
      "code" : "A029960209",
      "display" : "SUNTOSE INJ. \"N.K.\" 2.5％"
    },
    {
      "code" : "A029960255",
      "display" : "SUNTOSE INJ. \"N.K.\" 2.5％"
    },
    {
      "code" : "A029960265",
      "display" : "SUNTOSE INJ. \"N.K.\" 2.5％"
    },
    {
      "code" : "A029960277",
      "display" : "SUNTOSE INJ. \"N.K.\" 2.5％"
    },
    {
      "code" : "A029961100",
      "display" : "MIDE TABLETS 500MG (PYRAZINAMIDE)\"WINSTON\""
    },
    {
      "code" : "A029983100",
      "display" : "CAPOTEN TABLETS 25MG (CAPTOPRIL)"
    },
    {
      "code" : "A029984209",
      "display" : "HARINGER INJ. \"N.K.\""
    },
    {
      "code" : "A029984238",
      "display" : "HARINGER INJ. \"N.K.\""
    },
    {
      "code" : "A029984255",
      "display" : "HARINGER INJ. \"N.K.\""
    },
    {
      "code" : "A029984265",
      "display" : "HARINGER INJ. \"N.K.\""
    },
    {
      "code" : "A029984277",
      "display" : "HARINGER INJ. \"N.K.\""
    },
    {
      "code" : "A029986277",
      "display" : "NESSAMINE-S1 INJ. \"N.K.\""
    },
    {
      "code" : "A029987100",
      "display" : "DOMPEDON F.C. TAB. \"STANDARD\" 10MG(DOMPERIDONE)\""
    },
    {
      "code" : "A029988100",
      "display" : "LICODYNE TABLETS 375MG  \"Y.K.\"(CARBOCISTEINE)"
    },
    {
      "code" : "A030039209",
      "display" : "CEDO INJECTION 1GM"
    },
    {
      "code" : "A030053100",
      "display" : "PANTADIN TABLETS"
    },
    {
      "code" : "A030054212",
      "display" : "ORPHENADRINE INJECTION \"YUNG SHIN\""
    },
    {
      "code" : "A030055100",
      "display" : "PROCANINE CAPSULES \"YUNG CHI\""
    },
    {
      "code" : "A030056100",
      "display" : "TOLECTIN TABLETS 200MG (TOLMETIN)"
    },
    {
      "code" : "A030057100",
      "display" : "NICOGUS TABLETS 200MG (KETOCONAZOLE) \"H.H\""
    },
    {
      "code" : "A030058100",
      "display" : "EROMYCIN F.C. TABLET 250MG \"SHITEH\""
    },
    {
      "code" : "A030118100",
      "display" : "HEPATRIN SUGAR COATED TABLETS"
    },
    {
      "code" : "A030119100",
      "display" : "POTARLON FILM COATED TABLETS 500MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A030120100",
      "display" : "CINTSU SUGAR COATED TABLETS 40MG (VERAPAMIL)\"YUNG SHIN\""
    },
    {
      "code" : "A0301201G0",
      "display" : "CINTSU SUGAR COATED TABLETS 40MG (VERAPAMIL)\"YUNG SHIN\""
    },
    {
      "code" : "A030121100",
      "display" : "KMT TABLETS"
    },
    {
      "code" : "A030122100",
      "display" : "POTARLON CAPSULES 250MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A030123209",
      "display" : "INJECTIO NALORPHINE HYDROCHLORIDI"
    },
    {
      "code" : "A030257100",
      "display" : "AMANDA F.C. TABLETS 100MG \"WEIDAR\" (AMANTADINE)"
    },
    {
      "code" : "A030268212",
      "display" : "DEFENSE (R) INJECTION 150MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A030270335",
      "display" : "Acne Treatment Cream"
    },
    {
      "code" : "A030271335",
      "display" : "ACNIE-10 LOTION (BENZOYL PEROXIDE)"
    },
    {
      "code" : "A030276100",
      "display" : "COUGH CAPSULES"
    },
    {
      "code" : "A030281209",
      "display" : "KOFATOL INJECTION (CEPHAZOLIN)"
    },
    {
      "code" : "A030281277",
      "display" : "KOFATOL INJECTION (CEPHAZOLIN)"
    },
    {
      "code" : "A030302377",
      "display" : "M. C. SKIN LOTION"
    },
    {
      "code" : "A030302399",
      "display" : "M. C. SKIN LOTION"
    },
    {
      "code" : "A030304100",
      "display" : "CHLORPHENIRAMINE MALEATE TABLETS \"M.T.\""
    },
    {
      "code" : "A030305100",
      "display" : "LITANGEN TABLETS 250MG (CHLORPROPAMIDE)\" M.T.\""
    },
    {
      "code" : "A0303051G0",
      "display" : "LITANGEN TABLETS 250MG (CHLORPROPAMIDE)\" M.T.\""
    },
    {
      "code" : "A030307100",
      "display" : "DEXAMETHASONE S.C. TABLETS 0.5MG \"M.T.\""
    },
    {
      "code" : "A0303071G0",
      "display" : "DEXAMETHASONE S.C. TABLETS 0.5MG \"M.T.\""
    },
    {
      "code" : "A030308100",
      "display" : "SULUGEN S.C. TABLETS 100MG (PHENAZOPYRIDINE)\"M.T.\""
    },
    {
      "code" : "A030309100",
      "display" : "NAUEAN TABLETS (CINNARIZINE)\"M.T.\""
    },
    {
      "code" : "A0303091G0",
      "display" : "NAUEAN TABLETS (CINNARIZINE)\"M.T.\""
    },
    {
      "code" : "A030310100",
      "display" : "THINTHIN CAPSULES 10MG (HYOSCINE-N-BUTYL BROMIDE)\"M.T.\""
    },
    {
      "code" : "A030311100",
      "display" : "DEXAMETHASONE TABLETS \"M.T.\""
    },
    {
      "code" : "A030312100",
      "display" : "NITROFURANTOIN CAPSULES 100MG \"M.T.\""
    },
    {
      "code" : "A030319100",
      "display" : "VEKAIN TABLETS (R)"
    },
    {
      "code" : "A030320100",
      "display" : "METASONE TABLETS 0.5MG \"Y.K.\""
    },
    {
      "code" : "A030322100",
      "display" : "WEKLIN TABLETS 500MG \"Y.K.\""
    },
    {
      "code" : "A030323100",
      "display" : "NEKMIN TABLETS 4MG (CYPROHETADINE HCL) \"N.W.\""
    },
    {
      "code" : "A030324277",
      "display" : "KOFATOL INJECTION 0.5GM (CEPHAZOLIN)"
    },
    {
      "code" : "A030327343",
      "display" : "CLEOCIN T TOPICAL SOLUTION 1％ (CLINDAMYCIN)"
    },
    {
      "code" : "A030328100",
      "display" : "FLUMARK F.C. TABLETS 200MG (ENOXACIN)"
    },
    {
      "code" : "A030329100",
      "display" : "FLUMARK F.C. TABLETS 100MG (ENOXACIN)"
    },
    {
      "code" : "A030331100",
      "display" : "TRANSAMIN  TABLETS 500MG"
    },
    {
      "code" : "A030336100",
      "display" : "CORSINTIN S.C.TAB. \"PRINCE\""
    },
    {
      "code" : "A030337100",
      "display" : "TIUSOUPIN TAB. \"PRINCE\""
    },
    {
      "code" : "A030338100",
      "display" : "AMINOPHYLLINE TAB. \"PRINCE\""
    },
    {
      "code" : "A030340100",
      "display" : "ALIDAMIN COMPLX. S.C.T. \"MEDRAY\""
    },
    {
      "code" : "A030341100",
      "display" : "L.A. TAB. \"PRINCE\""
    },
    {
      "code" : "A030343100",
      "display" : "DESERPIN TAB. \"PRINCE\""
    },
    {
      "code" : "A030346100",
      "display" : "VITAMIN B6 TAB. \"PRINCE\""
    },
    {
      "code" : "A030351100",
      "display" : "CYEDA CIN CAP. \"PRINCE\""
    },
    {
      "code" : "A030352100",
      "display" : "PENZIN S.C. TAB.\"PRINCE\""
    },
    {
      "code" : "A030354100",
      "display" : "TENZONINE TAB. \"PRINCE\""
    },
    {
      "code" : "A030358100",
      "display" : "IBUPROFEN 200MG TABLETS \"MEDRAY\""
    },
    {
      "code" : "A030359100",
      "display" : "BUCENIN S.C. TAB. \"PRINCE\""
    },
    {
      "code" : "A030362100",
      "display" : "SAUPINE S.C.TAB. 30MG (DEXTROMETHORPHAN) \"PRINCE\""
    },
    {
      "code" : "A030363100",
      "display" : "TLANCOBALU TABLETS"
    },
    {
      "code" : "A030364100",
      "display" : "THOLITHIN S.C.TAB. \"PRINCE\""
    },
    {
      "code" : "A030365100",
      "display" : "AIFULIN TABLETS \"Y.K.\""
    },
    {
      "code" : "A030376100",
      "display" : "SULORIL 200MG"
    },
    {
      "code" : "A030381100",
      "display" : "ATENOL TABLETS 100MG (ATENOLOL)"
    },
    {
      "code" : "A030382100",
      "display" : "DEGLUCON TABLETS 5MG (GLIBENCLAMIDE)"
    },
    {
      "code" : "A030383135",
      "display" : "HALDOMIN ORAL SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A030383155",
      "display" : "HALDOMIN ORAL SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A030383199",
      "display" : "HALDOMIN ORAL SOLUTION (HALOPERIDOL)"
    },
    {
      "code" : "A030384100",
      "display" : "MELON TABLETS 50MG (MEPIRIZOLE) \"H.S.C.\""
    },
    {
      "code" : "A030385100",
      "display" : "SULPIRIDE TABLETS"
    },
    {
      "code" : "A030387351",
      "display" : "ACNIE WASH (BENZOYL PEROXIDE)"
    },
    {
      "code" : "A030388100",
      "display" : "EDIAN CAP. 10MG (NIFEDIPINE)\"WINSTON\""
    },
    {
      "code" : "A030389100",
      "display" : "COLISTIN CAPSULES \"C.C.P.\""
    },
    {
      "code" : "A030390212",
      "display" : "AMIKACIN INJECTION 125MG/ML"
    },
    {
      "code" : "A030396100",
      "display" : "COLCHICINE TABLETS 0.5MG \"SHIONOGI\""
    },
    {
      "code" : "A0303961G0",
      "display" : "COLCHICINE TABLETS 0.5MG \"SHIONOGI\""
    },
    {
      "code" : "A030415100",
      "display" : "MINISON TABLETS 1MG (PRAZOSIN)"
    },
    {
      "code" : "A030417209",
      "display" : "LYBRILE INJECTION (ACETYLSALICYLIC ACID)"
    },
    {
      "code" : "A030418100",
      "display" : "BUBDEL TABLETS 80MG"
    },
    {
      "code" : "A030437209",
      "display" : "HEADGEN INJECTION 0.3MG/ML (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A030439100",
      "display" : "XANAX TABLETS 0.25MG"
    },
    {
      "code" : "A030441100",
      "display" : "XANAX TABLETS 0.5MG"
    },
    {
      "code" : "A030442212",
      "display" : "KETOPROFEN IM INJECTION 25MG/ML \"ASTAR\""
    },
    {
      "code" : "A030452100",
      "display" : "CAPOMIL TABLETS 25MG \"WEIDAR\" (CAPTOPRIL)"
    },
    {
      "code" : "A030453100",
      "display" : "CHILDRENS ACETA 80 CHEWABLE TABLETS"
    },
    {
      "code" : "A030454100",
      "display" : "MEPHARMIN TABLETS 50MG (AMANTEDINE) \"M.S.\""
    },
    {
      "code" : "A030455100",
      "display" : "TRIAMZIDE CAPSULES \"WEIDAR\""
    },
    {
      "code" : "A030456100",
      "display" : "DIHYDROCHLOROTHIAZIDE TABLETS \"ORIENTAL\""
    },
    {
      "code" : "A030463177",
      "display" : "BENADRYL SYRUP"
    },
    {
      "code" : "A030463199",
      "display" : "BENADRYL SYRUP"
    },
    {
      "code" : "A030464100",
      "display" : "MINDANE TABLETS LONGACTION (TERFENADINE)"
    },
    {
      "code" : "A030465309",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030465321",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030465329",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030465335",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030465338",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030465399",
      "display" : "EPISONE SOLUTION (BETAMETHASONE)"
    },
    {
      "code" : "A030466100",
      "display" : "IBUPROFEN FILM COATED TABLETS 400MG \"YUNG SHIN\""
    },
    {
      "code" : "A0304661G0",
      "display" : "IBUPROFEN FILM COATED TABLETS 400MG \"YUNG SHIN\""
    },
    {
      "code" : "A030467100",
      "display" : "ASUMALIFE CAPSULES 1MG (KETOTIFEN)"
    },
    {
      "code" : "A030507100",
      "display" : "DIAZEPAM TABLETS 2MG \"YUNG SHIN\""
    },
    {
      "code" : "A0305071G0",
      "display" : "DIAZEPAM TABLETS 2MG \"YUNG SHIN\""
    },
    {
      "code" : "A030510100",
      "display" : "DIAZEPAM TABLETS 5MG \"YUNG SHIN\""
    },
    {
      "code" : "A030512100",
      "display" : "GLIAN TABLETS 80MG (GLICLAZIDE)"
    },
    {
      "code" : "A030513100",
      "display" : "MORESAFE TABLETS 5MG (ALLYLESTRENOL)"
    },
    {
      "code" : "A030514100",
      "display" : "MERIGA TABLETS 25MG (CAPTOPRIL) \"C.M.\""
    },
    {
      "code" : "A030521212",
      "display" : "RASITOL INJECTION 10MG/ML (FUROSEMIDE)"
    },
    {
      "code" : "A030523212",
      "display" : "PRO-VITA B12 INJECTION \"N.K.\""
    },
    {
      "code" : "A030525100",
      "display" : "PANTOMIN FILM COATING TABLETS 60MG"
    },
    {
      "code" : "A030526100",
      "display" : "SPIRONOLACTONE TABLETS \"ROYAL\""
    },
    {
      "code" : "A0305261G0",
      "display" : "SPIRONOLACTONE TABLETS \"ROYAL\""
    },
    {
      "code" : "A030528100",
      "display" : "METRO TABLET \"WP\" (METRONIDAZOLE)"
    },
    {
      "code" : "A030529321",
      "display" : "C P Ointment \"Standard\" 10mg/g (Chloramphenicol)\""
    },
    {
      "code" : "A030529348",
      "display" : "C P Ointment \"Standard\" 10mg/g (Chloramphenicol)\""
    },
    {
      "code" : "A030530329",
      "display" : "Salic Ointment \"Standard\" (Salicylic acid)"
    },
    {
      "code" : "A030531343",
      "display" : "FOOTCON OINTMENT \"STANDARD\""
    },
    {
      "code" : "A030532100",
      "display" : "ASTIFEN TABLETS 1MG (KETOTIFEN) \"VPP\""
    },
    {
      "code" : "A030533100",
      "display" : "GOUT TABLETS 50MG \"P.L.\" (BENZBROMARONE)"
    },
    {
      "code" : "A030535209",
      "display" : "LEPHOCIN INJECTION 1GM (CEFOXITIN)"
    },
    {
      "code" : "A030538500",
      "display" : "ECOVAL SUPPOSITORY 50MG \"P.L.\""
    },
    {
      "code" : "A030539212",
      "display" : "MANDOL INJECTION 2G (CEFAMANDOLE)"
    },
    {
      "code" : "A030540209",
      "display" : "MANDOL INJECTION 1G (CEFAMANDOLE)"
    },
    {
      "code" : "A030541277",
      "display" : "MANDOL INJECTION 500MG (CEFAMANDOLE)"
    },
    {
      "code" : "A030545100",
      "display" : "INFLU CAPSULES 100MG (AMANTADINE)"
    },
    {
      "code" : "A030547277",
      "display" : "LEFRUTOSE INJ. \"S.T.\""
    },
    {
      "code" : "A030549100",
      "display" : "ANTIFLAN E.S.C. TABLETS \"C.H.\" 100MG (BROMELAIN)"
    },
    {
      "code" : "A030551500",
      "display" : "ACETA 600 SUPPOSITORY (ACETAMINOPHEN)"
    },
    {
      "code" : "A030556100",
      "display" : "YUNGBENRONE TABLET (BENZBROMARONE) \"Lita\""
    },
    {
      "code" : "A0305561G0",
      "display" : "YUNGBENRONE TABLET (BENZBROMARONE) \"Lita\""
    },
    {
      "code" : "A030557100",
      "display" : "Diclofenac E.S.C. Tablets 50mg \"F.Y.\""
    },
    {
      "code" : "A030559100",
      "display" : "LOFADINE INJECTION 500MG (CEPHRADINE) \"GENTLE\""
    },
    {
      "code" : "A030559277",
      "display" : "LOFADINE INJECTION 500MG (CEPHRADINE) \"GENTLE\""
    },
    {
      "code" : "A030560277",
      "display" : "LOFORAN INJECTION 0.5G (CEFOTAXIME SODIUM) \"GENTLE\""
    },
    {
      "code" : "A030563100",
      "display" : "OROMIN CAPSULES"
    },
    {
      "code" : "A030566100",
      "display" : "THIAMINE HCL TABS 50MG \"W. P.\""
    },
    {
      "code" : "A030572100",
      "display" : "SERADASE E.C. TABLETS 5MG (SERRATIOPEPTIDASE) \"WEIDAR\""
    },
    {
      "code" : "A030573100",
      "display" : "TARIVID FILM COATED TABLETS (OFLOXACIN)"
    },
    {
      "code" : "A030581100",
      "display" : "THIOPHENICOL F.C. TABLET 250mg \"Shiteh\""
    },
    {
      "code" : "A030584209",
      "display" : "LEADERCEF INJECTION 1G (CEPHAZOLIN)"
    },
    {
      "code" : "A030586100",
      "display" : "WECON-II CHEWABLE TABLETS \"YU SHENG\""
    },
    {
      "code" : "A030587100",
      "display" : "TEGOL TABLETS 200MG \"YU SHENG\"(CARBAMAZEPINE)"
    },
    {
      "code" : "A030590100",
      "display" : "CHENOL TABLETS 200MG"
    },
    {
      "code" : "A030591500",
      "display" : "VOTALIN SUPPOSITORY 50MG \"P.L.\" (DICLOFENAC SODIUM)"
    },
    {
      "code" : "A030594100",
      "display" : "KOZEN E.C. TABLETS 5MG (SERRATIOPEPTIDASE) \"S.D.\""
    },
    {
      "code" : "A030601100",
      "display" : "PACOMIN TABLETS 20MG \"PATRON\" (OXELADIN)"
    },
    {
      "code" : "A030605100",
      "display" : "MAMICON CAPSULES 1MG \"PATRON\" (KETOTIFEN)"
    },
    {
      "code" : "A030607100",
      "display" : "ESIDRI S.C. TABLETS (R)"
    },
    {
      "code" : "A030609100",
      "display" : "TIAMIDE TABLETS 100MG (TIARAMIDE) \"M.S.\""
    },
    {
      "code" : "A030610100",
      "display" : "INROLIN TABLETS 50MG \"YU SHENG\" (MEBBYDROLINE)"
    },
    {
      "code" : "A030611100",
      "display" : "KATIFEN TABLETS 1MG \"YU SHENG\" (KETOTIFEN)"
    },
    {
      "code" : "A030612100",
      "display" : "SULINTON TABLETS 200MG \"Y.S.\" (SULINDAC)"
    },
    {
      "code" : "A030614100",
      "display" : "DOPERAN CAPSULES 400MG \"Y.S.\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A030615100",
      "display" : "ISOMIL S.C. TABLETS 40MG \"Y.S.\" (VERAPAMIL)"
    },
    {
      "code" : "A0306151G0",
      "display" : "ISOMIL S.C. TABLETS 40MG \"Y.S.\" (VERAPAMIL)"
    },
    {
      "code" : "A030616100",
      "display" : "SULPYRIDE TAB (SULPIRIDE)"
    },
    {
      "code" : "A030618100",
      "display" : "BROMAZAEPAM TABLETS(BROMAZEPAM)"
    },
    {
      "code" : "A030619100",
      "display" : "D.M.P. TABLETS (DOMPERIDONE)"
    },
    {
      "code" : "A0306191G0",
      "display" : "D.M.P. TABLETS (DOMPERIDONE)"
    },
    {
      "code" : "A030620289",
      "display" : "CEFUROXIME INJECTION 750MG"
    },
    {
      "code" : "A030622321",
      "display" : "LOCASALEN OINTMENT (R)"
    },
    {
      "code" : "A030622335",
      "display" : "LOCASALEN OINTMENT (R)"
    },
    {
      "code" : "A030622355",
      "display" : "LOCASALEN OINTMENT (R)"
    },
    {
      "code" : "A030622399",
      "display" : "LOCASALEN OINTMENT (R)"
    },
    {
      "code" : "A030623329",
      "display" : "COAL TAR AND SALICYLIC ACID OINTMENT"
    },
    {
      "code" : "A030623343",
      "display" : "COAL TAR AND SALICYLIC ACID OINTMENT"
    },
    {
      "code" : "A030624329",
      "display" : "SALICYLIC ACID AND BENZOIC ACID OINTMENT"
    },
    {
      "code" : "A030624343",
      "display" : "SALICYLIC ACID AND BENZOIC ACID OINTMENT"
    },
    {
      "code" : "A030625209",
      "display" : "CEFOZONE INJ. 0.5G,1G \"WINSTON\" (CEFOPERAZONE)"
    },
    {
      "code" : "A030625277",
      "display" : "CEFOZONE INJ. 0.5G,1G \"WINSTON\" (CEFOPERAZONE)"
    },
    {
      "code" : "A030626212",
      "display" : "TAGAMET R INJECTION 200MG/2ML (CIMETIDINE)"
    },
    {
      "code" : "A030627277",
      "display" : "SOLYUGEN NO.2 INJECTION \"N.K.\""
    },
    {
      "code" : "A030628209",
      "display" : "HILAMIN INJECTION 5MG/ML (HYDROXOCOBALAMINE) \"PATRON\""
    },
    {
      "code" : "A030628212",
      "display" : "HILAMIN INJECTION 5MG/ML (HYDROXOCOBALAMINE) \"PATRON\""
    },
    {
      "code" : "A030629100",
      "display" : "NAKASSER TABLET 30MG \"N.K.\"(DILTIAZEM HCL)"
    },
    {
      "code" : "A030632335",
      "display" : "EURAX (R) CREAM 10％ (CROTAMITON)"
    },
    {
      "code" : "A030633100",
      "display" : "MECOZOL TABLET 200MG \"N.K.\" (KETOCONAZOLE)"
    },
    {
      "code" : "A030634329",
      "display" : "RELEX GEL 50MG/G \"N.K.\" (ETOFENAMATE)"
    },
    {
      "code" : "A030634338",
      "display" : "RELEX GEL 50MG/G \"N.K.\" (ETOFENAMATE)"
    },
    {
      "code" : "A030641100",
      "display" : "YUNGKEN FILM COATED TABLETS 200MG (FLAVOXATE)"
    },
    {
      "code" : "A030642100",
      "display" : "Defense Film Coated Tablets 400MG (Cimetidine)"
    },
    {
      "code" : "A030643100",
      "display" : "MUCORA TABLETS 60MG (IODOPROPYLIDENE GLYCEROL) \"YUNG SHIN\""
    },
    {
      "code" : "A030645100",
      "display" : "LISUAN TABLETS 8MG \"H.S.\" (BROMHEXINE HYDROCHLORIDE)"
    },
    {
      "code" : "A030646277",
      "display" : "CEFADIN INJECTION 500MG (CEPHRADINE) \"STANDARD\""
    },
    {
      "code" : "A030647500",
      "display" : "Difena Supp. 12.5mg \"Standard\" (Diclofenac Sodium)"
    },
    {
      "code" : "A030648100",
      "display" : "SUTAN CAPSULES 500MG (MEFENAMIC ACID) \"H.S.\""
    },
    {
      "code" : "A0306481G0",
      "display" : "SUTAN CAPSULES 500MG (MEFENAMIC ACID) \"H.S.\""
    },
    {
      "code" : "A030649100",
      "display" : "DAWEISON TAB. 10MG (DOMPERIDONE) \"H.S.\""
    },
    {
      "code" : "A0306491G0",
      "display" : "DAWEISON TAB. 10MG (DOMPERIDONE) \"H.S.\""
    },
    {
      "code" : "A030650100",
      "display" : "HITOLIN TABLETS 100MG (MEBENDAZOLE) \"H.S.\""
    },
    {
      "code" : "A030651500",
      "display" : "Difena Supp. 25mg \"Standard\" (Diclofenac Sodium)"
    },
    {
      "code" : "A030653100",
      "display" : "RIMACTANE (R) CAPSULES 150MG (RIFAMPICIN)"
    },
    {
      "code" : "A030681100",
      "display" : "YEN TUNG KO TAB. (FENBUFEN) \"TON SIN\""
    },
    {
      "code" : "A030689100",
      "display" : "ALINAMIN-A25 SUGAR COATED TABLETS"
    },
    {
      "code" : "A030693100",
      "display" : "KETOFEN TABLETS\"H.L.\""
    },
    {
      "code" : "A030694100",
      "display" : "DICOKAN TABLETS 30MG \"T.F.\""
    },
    {
      "code" : "A030695100",
      "display" : "CORTICORD TABLETS 4MG \"T.F.\"(TRIAMCINOLONE)"
    },
    {
      "code" : "A030696100",
      "display" : "ASPIRIN TABLETS 162MG \"T.F.\""
    },
    {
      "code" : "A030697100",
      "display" : "LYSIX TABLETS 40MG  \"T.F.\""
    },
    {
      "code" : "A0306971G0",
      "display" : "LYSIX TABLETS 40MG  \"T.F.\""
    },
    {
      "code" : "A030698100",
      "display" : "GLICRON TABLETS 80MG \"YU SHENG\" (GLICLAZIDE)"
    },
    {
      "code" : "A030708100",
      "display" : "KUSELLEO TABLETS (PROBUCOL) \"TON SIN\""
    },
    {
      "code" : "A030709100",
      "display" : "PINCOU TABLETS (CARBETAPENTANE) \"TON SIN\""
    },
    {
      "code" : "A030712100",
      "display" : "LAVOCOHERE TAB. 200MG \"WINSTON\" (LABETALOL)"
    },
    {
      "code" : "A030735100",
      "display" : "MEYUAN ENTERIC COATED TABLET (MEPIRIZOLE) \"YUNG SING\""
    },
    {
      "code" : "A030737100",
      "display" : "RIMACTANE (R) CAPSULES 300MG (RIFAMPICINE)"
    },
    {
      "code" : "A030738323",
      "display" : "EURAX-H CREAM"
    },
    {
      "code" : "A030738355",
      "display" : "EURAX-H CREAM"
    },
    {
      "code" : "A030738399",
      "display" : "EURAX-H CREAM"
    },
    {
      "code" : "A030739100",
      "display" : "ISMELIN (R) TABLETS 10MG (GUANETHIDINE SULFATE)"
    },
    {
      "code" : "A030740100",
      "display" : "RITALIN TABLETS 10MG (METHYLPHENIDATE)"
    },
    {
      "code" : "A030741100",
      "display" : "WEITUL F.C. TABLETS 10MG \"WEIDAR\" (DOMPERIDONE)"
    },
    {
      "code" : "A030742100",
      "display" : "APRESOLINE (R) S.C. TABLETS 25MG (HYDRALAZINE)"
    },
    {
      "code" : "A030743100",
      "display" : "APRESOLINE S.C. TABLETS 50MG (HYDRALAZINE)"
    },
    {
      "code" : "A030748329",
      "display" : "FUDGEN CREAM \"H.S.\""
    },
    {
      "code" : "A030749100",
      "display" : "RASITOL TABLETS 40MG (FUROSEMIDE)"
    },
    {
      "code" : "A0307491G0",
      "display" : "RASITOL TABLETS 40MG (FUROSEMIDE)"
    },
    {
      "code" : "A030753100",
      "display" : "ANZULENE 2MG\"Y.K.\""
    },
    {
      "code" : "A030754321",
      "display" : "HUPICON CREAM \"Y.Y.\""
    },
    {
      "code" : "A030754329",
      "display" : "HUPICON CREAM \"Y.Y.\""
    },
    {
      "code" : "A030754335",
      "display" : "HUPICON CREAM \"Y.Y.\""
    },
    {
      "code" : "A030754399",
      "display" : "HUPICON CREAM \"Y.Y.\""
    },
    {
      "code" : "A030756277",
      "display" : "ACTIT INJECTION"
    },
    {
      "code" : "A030757100",
      "display" : "FORISTAL (R) TABLETS 1MG (DIMETHINDENE)"
    },
    {
      "code" : "A030758143",
      "display" : "EURAX (R) LOTION 10％ \"SWPH.\" (CROTAMITON)"
    },
    {
      "code" : "A030758343",
      "display" : "EURAX (R) LOTION 10％ \"SWPH.\" (CROTAMITON)"
    },
    {
      "code" : "A030759100",
      "display" : "Scanol Tablets 500mg \"Y.K.\""
    },
    {
      "code" : "A030763221",
      "display" : "INFUVITA INJECTION"
    },
    {
      "code" : "A030765277",
      "display" : "VIDOPA INJECTION"
    },
    {
      "code" : "A030766100",
      "display" : "CLOESTIN TABLETS 200MG (BEZAFIBRATE) \"H.S.\""
    },
    {
      "code" : "A030767100",
      "display" : "KANYENING CAPSULES 300MG (FENBUFEN) \"H.S.\""
    },
    {
      "code" : "A030774100",
      "display" : "COTRIZINE TABLETS 200MG(KETOCONAZOLE)"
    },
    {
      "code" : "A030775100",
      "display" : "ASPIRIN TABLETS 500MG \"CHINTENG\""
    },
    {
      "code" : "A030776100",
      "display" : "HALDOL TABLETS 0.5 MG (HALOPERIDOL)"
    },
    {
      "code" : "A030777100",
      "display" : "HALDOL TABLETS 5MG (HALOPERIDOL)"
    },
    {
      "code" : "A030778100",
      "display" : "SPIROPENT TABLETS 20MCG (CLENBUTEROL HYDROCHLORIDE)"
    },
    {
      "code" : "A030780100",
      "display" : "ANTIMIN TABLETS 60MG \"N.K.\" (TERFENADINE)"
    },
    {
      "code" : "A030781209",
      "display" : "UNIZONE INJECTION 0.5GM, 1.0GM, \"UNION\""
    },
    {
      "code" : "A030781277",
      "display" : "UNIZONE INJECTION 0.5GM, 1.0GM, \"UNION\""
    },
    {
      "code" : "A030783338",
      "display" : "MANNIN CREAM 0.5MG/G (CLOBETASOL) \"SHITEH\""
    },
    {
      "code" : "A030783377",
      "display" : "MANNIN CREAM 0.5MG/G (CLOBETASOL) \"SHITEH\""
    },
    {
      "code" : "A030783399",
      "display" : "MANNIN CREAM 0.5MG/G (CLOBETASOL) \"SHITEH\""
    },
    {
      "code" : "A030784100",
      "display" : "SUBILIN ENTERIC-COATED CAPSULES 500MG (ASPIRIN)\"H.S.\""
    },
    {
      "code" : "A030790100",
      "display" : "UCLIDAN-100 TABLET (NICAMETATE)"
    },
    {
      "code" : "A030791209",
      "display" : "CETAXIMA INJECTIIN 0.5GM 1GM (CEFOTAXIME SODIUM)"
    },
    {
      "code" : "A030791277",
      "display" : "CETAXIMA INJECTIIN 0.5GM 1GM (CEFOTAXIME SODIUM)"
    },
    {
      "code" : "A030792429",
      "display" : "OTRIVIN NASLE SOLUTION 0.1％ (XYLOMETAZOLINE)"
    },
    {
      "code" : "A030799209",
      "display" : "MECOMIN INJECTION (MECOBALAMIN)"
    },
    {
      "code" : "A030799212",
      "display" : "MECOMIN INJECTION (MECOBALAMIN)"
    },
    {
      "code" : "A030800221",
      "display" : "NICEWE INJ. 10MG/ML \"N.K.\" (RANITIDINE HCL)"
    },
    {
      "code" : "A030801212",
      "display" : "CHLORAMPHENICOL INJECTION"
    },
    {
      "code" : "A030802100",
      "display" : "ATENOL TABLETS (ATENOLOL)"
    },
    {
      "code" : "A030803100",
      "display" : "DITROPAN TABLETS 2.5MG (OXYBUTYNIN)"
    },
    {
      "code" : "A030804100",
      "display" : "PERDIPINE S.C. TABLETS 20MG (NICARDIPINE)"
    },
    {
      "code" : "A030809209",
      "display" : "EPOCELIN FOR INJECTION (CEFTIZOXIME)"
    },
    {
      "code" : "A030809277",
      "display" : "EPOCELIN FOR INJECTION (CEFTIZOXIME)"
    },
    {
      "code" : "A030810209",
      "display" : "CEFAMEZIN FOR INJECTION (CEFAZOLIN)"
    },
    {
      "code" : "A030810277",
      "display" : "CEFAMEZIN FOR INJECTION (CEFAZOLIN)"
    },
    {
      "code" : "A030811100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"TAI YU\""
    },
    {
      "code" : "A030813100",
      "display" : "E.M. CAPSULES 250MG (ERYTHROMYCIN ESTOLATE) \"DCPC\""
    },
    {
      "code" : "A030816100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"TAI YU\""
    },
    {
      "code" : "A030821212",
      "display" : "BIOMICIN INJECTION 40MG/ML \"WINSTON\" (TOBRAMYCIN)"
    },
    {
      "code" : "A030836157",
      "display" : "MUCO SYRUP 20MG/ML \"PATRON\""
    },
    {
      "code" : "A030837100",
      "display" : "ANRIGIN TABLETS 100MG (AMANTADINE HCL) \"H.S.\""
    },
    {
      "code" : "A030838335",
      "display" : "KOTASON CREAM 0.5MG/G (CLOBETASOL) \"H.S.\""
    },
    {
      "code" : "A030838372",
      "display" : "KOTASON CREAM 0.5MG/G (CLOBETASOL) \"H.S.\""
    },
    {
      "code" : "A030838399",
      "display" : "KOTASON CREAM 0.5MG/G (CLOBETASOL) \"H.S.\""
    },
    {
      "code" : "A030854100",
      "display" : "LEHDUO TABLET (BROMOCRIPTINE) \"TON SIN\""
    },
    {
      "code" : "A030859421",
      "display" : "PHENYLEPRINE HYDROCHLORIDE OPHTHALMIC SOLUTION 10％ \"WU FU\""
    },
    {
      "code" : "A030862118",
      "display" : "COUGH MIXTURE"
    },
    {
      "code" : "A030862157",
      "display" : "COUGH MIXTURE"
    },
    {
      "code" : "A030862199",
      "display" : "COUGH MIXTURE"
    },
    {
      "code" : "A030863100",
      "display" : "SMP TABLETS"
    },
    {
      "code" : "A030864321",
      "display" : "MECO 20L CREAM 20MG/G (KETOCONAZOLE) \"N.K.\""
    },
    {
      "code" : "A030864329",
      "display" : "MECO 20L CREAM 20MG/G (KETOCONAZOLE) \"N.K.\""
    },
    {
      "code" : "A030864335",
      "display" : "MECO 20L CREAM 20MG/G (KETOCONAZOLE) \"N.K.\""
    },
    {
      "code" : "A030864377",
      "display" : "MECO 20L CREAM 20MG/G (KETOCONAZOLE) \"N.K.\""
    },
    {
      "code" : "A030864399",
      "display" : "MECO 20L CREAM 20MG/G (KETOCONAZOLE) \"N.K.\""
    },
    {
      "code" : "A030865100",
      "display" : "LINDAC TABLETS 200MG (SULINDAC) \"S.C.\""
    },
    {
      "code" : "A030871100",
      "display" : "ASKACEF (CEPHRADINE) CAPSULES 500MG \"VPP\""
    },
    {
      "code" : "A030873100",
      "display" : "FLUTAFIN CAPSULE 200MG (ACETYLCYSTEINE)"
    },
    {
      "code" : "A030874100",
      "display" : "ASKACEF (CEPHRADINE) CAPSULES 250MG \"VPP\""
    },
    {
      "code" : "A030879100",
      "display" : "APRESOLINE S.C. TABLETS 10MG (HYDRALAZINE)"
    },
    {
      "code" : "A030881100",
      "display" : "ZADITEN TABLETS 1MG (KETOTIFEN)"
    },
    {
      "code" : "A030882100",
      "display" : "PARLODEL TABLETS 2.5MG (BROMOCRIPTINE)"
    },
    {
      "code" : "A030883100",
      "display" : "BRINERDIN S.C. TABLETS"
    },
    {
      "code" : "A030885100",
      "display" : "MELLERIL S.C. TABLETS 25MG (THIORIDAZINE HYDROCHLORIDE)"
    },
    {
      "code" : "A030887100",
      "display" : "YU SHENG C TABLETS 200MG (VITAMIN C) \"Y.S.\""
    },
    {
      "code" : "A030888100",
      "display" : "TAGAWEI TABLETS 400MG \"Y.S.\" (CIMETIDINE)"
    },
    {
      "code" : "A0308881G0",
      "display" : "TAGAWEI TABLETS 400MG \"Y.S.\" (CIMETIDINE)"
    },
    {
      "code" : "A030889100",
      "display" : "KOBAL CAPSULES 0.5MG \"WEIDAR\" (MECOBALAMIN)"
    },
    {
      "code" : "A030890100",
      "display" : "ULSATE TABLETS 500MG \"WEIDAR\" (SUCRALFATE)"
    },
    {
      "code" : "A030891100",
      "display" : "U-RITIS TABLETS 250MG (NAPROXEN)"
    },
    {
      "code" : "A0308911G0",
      "display" : "U-RITIS TABLETS 250MG (NAPROXEN)"
    },
    {
      "code" : "A030894100",
      "display" : "TOFRANIL S.C. TABLETS 25MG (IMIPRAMINE HYDROCHLORIDE)"
    },
    {
      "code" : "A030895100",
      "display" : "ACTIN TABLETS"
    },
    {
      "code" : "A030896100",
      "display" : "EUMI TABLETS 100MG \"H.S.\" (TRIMETHOPRIM)"
    },
    {
      "code" : "A0308961G0",
      "display" : "EUMI TABLETS 100MG \"H.S.\" (TRIMETHOPRIM)"
    },
    {
      "code" : "A030897209",
      "display" : "CEFIN INJECTION 1GM (CEPHRADINE) \"TAI YU\""
    },
    {
      "code" : "A030898100",
      "display" : "TANLIN TABLETS 375MG (CARBOCISTEINE) \"Y.Y.\""
    },
    {
      "code" : "A030905100",
      "display" : "VOLTAREN ENTERIC COATED TABLETS 50MG (DICLOFENAC)"
    },
    {
      "code" : "A030906100",
      "display" : "VOLTAREN (R) ENTERIC COATED TABLETS 25MG (DICLOFENAC)"
    },
    {
      "code" : "A030908238",
      "display" : "NEFRON INJECTION \"WINSTON\""
    },
    {
      "code" : "A030909100",
      "display" : "NEFRON TABLETS \"WINSTON\""
    },
    {
      "code" : "A0309121AH",
      "display" : "Austin Powder 971.43mg \"Gentle\"（Psyllium husk）"
    },
    {
      "code" : "A0309131AH",
      "display" : "AUSTIN POWDER(C GLUCOSE)523.1MG (PSYLLIUM HUSK) \"GENTLE\""
    },
    {
      "code" : "A030916100",
      "display" : "KOTOGEN TABLETS 50MG \"H.S.\" (BENZBROMARONE)"
    },
    {
      "code" : "A030917100",
      "display" : "DIFENA ENTERIC F.C.TAB. 50MG  \"STANDARD\"(DICLOFENAC)"
    },
    {
      "code" : "A030919100",
      "display" : "SUDAC TAB. 200MG) \"STANDARD\" (SULINDAC"
    },
    {
      "code" : "A030924151",
      "display" : "BESUTON SYRUP \"Y.Y.\""
    },
    {
      "code" : "A030924199",
      "display" : "BESUTON SYRUP \"Y.Y.\""
    },
    {
      "code" : "A030929209",
      "display" : "AMICIN INJECTION 50MG/ML (AMIKACIN)"
    },
    {
      "code" : "A030930212",
      "display" : "AMICIN INJECTION 250MG/ML (AMIKACIN)"
    },
    {
      "code" : "A030931100",
      "display" : "CLOMINS TABLETS (BROMPHENIRAMINE) \"TON SIN\""
    },
    {
      "code" : "A030933100",
      "display" : "LORILSU TABLET (LORAZEPAM) \"TON SIN\""
    },
    {
      "code" : "A030936100",
      "display" : "FOSELIN TABLETS 10MG (DOMPERIDONE)"
    },
    {
      "code" : "A030937100",
      "display" : "DOMPERIDONE TABLETS 10MG \"M.S.\""
    },
    {
      "code" : "A030940100",
      "display" : "YUNGFU CAPSULES 30MG (TIMEPIDIUM BROMIDE)"
    },
    {
      "code" : "A030942100",
      "display" : "PANTOMIN F.C. TABLETS 100MG (PANTETHINE)"
    },
    {
      "code" : "A030944338",
      "display" : "SULON SOLUTION (INDOMETHACIN)"
    },
    {
      "code" : "A030945100",
      "display" : "HYDERGINE TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A030950421",
      "display" : "GETAMIN EYE DROP SOLUTION"
    },
    {
      "code" : "A030950423",
      "display" : "GETAMIN EYE DROP SOLUTION"
    },
    {
      "code" : "A030951421",
      "display" : "DEMORLO EYE DROP 0.5％ (TIMOLOL) \"SHITEN\""
    },
    {
      "code" : "A030952421",
      "display" : "DEMOROL EYE DROP 0.25％ (TIMOLMO)\"SHITEH\""
    },
    {
      "code" : "A030953255",
      "display" : "DIBEKACIN FOR INJECTION 100MG"
    },
    {
      "code" : "A030954100",
      "display" : "HOKURAMINE CAPSULES \"F.Y.\""
    },
    {
      "code" : "A030955100",
      "display" : "YUNGPRIDE CAPSULE 10MG (BROMOPRIDE) \"YUNG SING\""
    },
    {
      "code" : "A030959100",
      "display" : "LICAGEL CAP. \"H.S.\" 25MG (PHENYLPROPANOLAMINE)"
    },
    {
      "code" : "A030961421",
      "display" : "CYPENTOL EYE DROP 1％ (CYCLOPENTOLATE) \"SHITEH\""
    },
    {
      "code" : "A030961429",
      "display" : "CYPENTOL EYE DROP 1％ (CYCLOPENTOLATE) \"SHITEH\""
    },
    {
      "code" : "A030962421",
      "display" : "CYPENTOL EYE DROP 2％ (CYCLOPENTOLATE) \"SHITEH\""
    },
    {
      "code" : "A030963100",
      "display" : "EPILEPTIN CAPSULES 100MG"
    },
    {
      "code" : "A030964100",
      "display" : "SHOREN ENTERIC FILM COATED TABLETS 25MG \"T.F.\""
    },
    {
      "code" : "A030965177",
      "display" : "CEFADROXIL GRANULE FOR SYRUP \"YUNG SHIN\""
    },
    {
      "code" : "A030965199",
      "display" : "CEFADROXIL GRANULE FOR SYRUP \"YUNG SHIN\""
    },
    {
      "code" : "A030967100",
      "display" : "SHOREN ENTERIC FILM COATED TABLETS 50MG \"T.F.\"(DICLOFENAC)"
    },
    {
      "code" : "A030968421",
      "display" : "JOYSUN EYE DROPS"
    },
    {
      "code" : "A030970100",
      "display" : "MEZIDE TABLETS 80MG (GLICLAZIDE) \"M.S.\""
    },
    {
      "code" : "A030972100",
      "display" : "SPASMOPRIV CAPSULE 100mg (FENOVERINE)"
    },
    {
      "code" : "A030974100",
      "display" : "MACGEL TABLETS"
    },
    {
      "code" : "A030975100",
      "display" : "DOMETON TABLET 100MG \"N.K.\" (SULINDAC)"
    },
    {
      "code" : "A030977221",
      "display" : "WINTAC INJ. 10MG/ML (RANITIDINE HYDROCHLORIDE)\"WINSTON\""
    },
    {
      "code" : "A030981212",
      "display" : "BRAXOL INJECTION 2MG/ML \"WINSTON\" (BROMHEXINE)"
    },
    {
      "code" : "A030982100",
      "display" : "PANS CAPSULES  \"PATRON\""
    },
    {
      "code" : "A030984100",
      "display" : "INFAXIL CAPSULES 500MG (CEPHADROXIL)"
    },
    {
      "code" : "A030987100",
      "display" : "REBAMOL TABLETS 500MG (METHOCARBAMOL) \" WINSTON \""
    },
    {
      "code" : "A030988209",
      "display" : "GANTA INJECTION 140MG/ML (GENTAMICIN)\"WINSTON\""
    },
    {
      "code" : "A030988212",
      "display" : "GANTA INJECTION 140MG/ML (GENTAMICIN)\"WINSTON\""
    },
    {
      "code" : "A030988221",
      "display" : "GANTA INJECTION 140MG/ML (GENTAMICIN)\"WINSTON\""
    },
    {
      "code" : "A030988229",
      "display" : "GANTA INJECTION 140MG/ML (GENTAMICIN)\"WINSTON\""
    },
    {
      "code" : "A030989329",
      "display" : "RICH CREAM 20MG/G (KETOCONAZOLE) \"WINSTON\""
    },
    {
      "code" : "A030989335",
      "display" : "RICH CREAM 20MG/G (KETOCONAZOLE) \"WINSTON\""
    },
    {
      "code" : "A030990138",
      "display" : "ANGEL SUSPENSION \"KINGDOM\""
    },
    {
      "code" : "A030994118",
      "display" : "AMTADINE SYRUP 10MG/ML (AMANTADINE)"
    },
    {
      "code" : "A030994151",
      "display" : "AMTADINE SYRUP 10MG/ML (AMANTADINE)"
    },
    {
      "code" : "A030994199",
      "display" : "AMTADINE SYRUP 10MG/ML (AMANTADINE)"
    },
    {
      "code" : "A030996100",
      "display" : "KETIMIN TABLETS 1MG (KETOTIFEN)"
    },
    {
      "code" : "A030997100",
      "display" : "VENTON TABLETS 50MG \"LITA\" (DICLOFENAC)"
    },
    {
      "code" : "A0309971G0",
      "display" : "VENTON TABLETS 50MG \"LITA\" (DICLOFENAC)"
    },
    {
      "code" : "A030999100",
      "display" : "PETHO S.C. TABLETS 10MG (PIPETHANATE ETHOBROMIDE)\"STANDARE\""
    },
    {
      "code" : "A031000100",
      "display" : "INFLAMNIL TABLET 300MG (TRIMETHOPRIM)"
    },
    {
      "code" : "A031001135",
      "display" : "STOMACON SUSPENSION"
    },
    {
      "code" : "A031002212",
      "display" : "SERACIN INJECTION 140MG/ML \"SWISS\"(GENTAMYCIN)"
    },
    {
      "code" : "A031002229",
      "display" : "SERACIN INJECTION 140MG/ML \"SWISS\"(GENTAMYCIN)"
    },
    {
      "code" : "A031003118",
      "display" : "COUGH MIXTURE A SOLUTION \"CHI SHENG\""
    },
    {
      "code" : "A031003151",
      "display" : "COUGH MIXTURE A SOLUTION \"CHI SHENG\""
    },
    {
      "code" : "A031003159",
      "display" : "COUGH MIXTURE A SOLUTION \"CHI SHENG\""
    },
    {
      "code" : "A031003199",
      "display" : "COUGH MIXTURE A SOLUTION \"CHI SHENG\""
    },
    {
      "code" : "A031004118",
      "display" : "COUGH MIXTURE B SYRUP"
    },
    {
      "code" : "A031004151",
      "display" : "COUGH MIXTURE B SYRUP"
    },
    {
      "code" : "A031004159",
      "display" : "COUGH MIXTURE B SYRUP"
    },
    {
      "code" : "A031004199",
      "display" : "COUGH MIXTURE B SYRUP"
    },
    {
      "code" : "A031005100",
      "display" : "FOLIC ACID TABLETS 5MG \"WINSTON\""
    },
    {
      "code" : "A031006100",
      "display" : "TREPIN CAPSULES 250MG (TRANEXAMIC ACID) \"Y.Y\""
    },
    {
      "code" : "A031008421",
      "display" : "ZENICORTINE OPHTHALMIC SUSPENSION \"WINSTON\""
    },
    {
      "code" : "A031009100",
      "display" : "TICAGEL CAPSULES 75MG (PHENYLPROPANOLAMINE) \"H.S.\""
    },
    {
      "code" : "A031010100",
      "display" : "DESPUTUM TABLETS 60MG (TODAPROPYLLDENE GLYCEROL) \"S.C.U.\""
    },
    {
      "code" : "A031011157",
      "display" : "COLIN SOLUTION"
    },
    {
      "code" : "A031017329",
      "display" : "Aczo Anti-Acne Gel 10％ \"Sinphar\""
    },
    {
      "code" : "A031018100",
      "display" : "SOLANOL TABLETS 50MG (TIARAMICLE) \"SINPHAR\""
    },
    {
      "code" : "A031020100",
      "display" : "UNIDAC F.C. TABLETS 200MG \"UNION\""
    },
    {
      "code" : "A031023100",
      "display" : "ANTRAN TABLETS \"DCPC\""
    },
    {
      "code" : "A031024255",
      "display" : "SAXIZON LYOPHILIZATION FOR INJECTION (HYDROCORTISONE SUCCINATE) \"SHUN HWA\""
    },
    {
      "code" : "A031032100",
      "display" : "CARDINOL TABLETS 100MG (METOPROLOL) \"SYNMOSA\""
    },
    {
      "code" : "A031033209",
      "display" : "FRUCTMANIT INJECTION"
    },
    {
      "code" : "A031033255",
      "display" : "FRUCTMANIT INJECTION"
    },
    {
      "code" : "A031033263",
      "display" : "FRUCTMANIT INJECTION"
    },
    {
      "code" : "A031033265",
      "display" : "FRUCTMANIT INJECTION"
    },
    {
      "code" : "A031033277",
      "display" : "FRUCTMANIT INJECTION"
    },
    {
      "code" : "A031034377",
      "display" : "NORMAL SALINE SOLUTION \"OTSUKA\""
    },
    {
      "code" : "A031035265",
      "display" : "LOW MOLECULAR DEXTRAN L INJECTION \"OTSUKA\""
    },
    {
      "code" : "A031035277",
      "display" : "LOW MOLECULAR DEXTRAN L INJECTION \"OTSUKA\""
    },
    {
      "code" : "A031036155",
      "display" : "EA TEN ORAL SOLUTION (TRIHEXYPHENIDYL)"
    },
    {
      "code" : "A031036157",
      "display" : "EA TEN ORAL SOLUTION (TRIHEXYPHENIDYL)"
    },
    {
      "code" : "A031036199",
      "display" : "EA TEN ORAL SOLUTION (TRIHEXYPHENIDYL)"
    },
    {
      "code" : "A031043212",
      "display" : "CIMEFINE INJECTION 150MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A031044100",
      "display" : "SUERTEL F.C.TAB. 50MG (TIARAMIDE) \"MEDRAY\""
    },
    {
      "code" : "A031049118",
      "display" : "COUGEL SYRUP \"H.S.\""
    },
    {
      "code" : "A031049151",
      "display" : "COUGEL SYRUP \"H.S.\""
    },
    {
      "code" : "A031049157",
      "display" : "COUGEL SYRUP \"H.S.\""
    },
    {
      "code" : "A031049199",
      "display" : "COUGEL SYRUP \"H.S.\""
    },
    {
      "code" : "A031050100",
      "display" : "VIRACON TABLETS 100MG  \"Y.Y.\" (AMANTADINE)"
    },
    {
      "code" : "A031052100",
      "display" : "ZOLBEN TABLETS"
    },
    {
      "code" : "A031053100",
      "display" : "HEADGEN TABLETS (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A031054100",
      "display" : "ARRING TABLETS 0.25MG (TRIAZOLAM)"
    },
    {
      "code" : "A031055100",
      "display" : "COSTINE TABLETS 10MG \"K.N.\" (DOMPERIDONE)"
    },
    {
      "code" : "A031056151",
      "display" : "UCOLE SOLUTION \"YUNG SHIN\""
    },
    {
      "code" : "A031058100",
      "display" : "FLUFEN S.C. TABLETS 50MG (FLURBIPROFEN) \"WEIDAR\""
    },
    {
      "code" : "A031059377",
      "display" : "SOCOL CREAM (ISOCONAZOLE)"
    },
    {
      "code" : "A031059399",
      "display" : "SOCOL CREAM (ISOCONAZOLE)"
    },
    {
      "code" : "A031063329",
      "display" : "KANFU CREAM \"C.M.\""
    },
    {
      "code" : "A031064100",
      "display" : "LIDERIIN CAPSULES 10MG (OXAZOLAM) \"C.M.\""
    },
    {
      "code" : "A031068100",
      "display" : "LONGMETON S. C. 400MG (IBUPROFEN) \"LONG DER\""
    },
    {
      "code" : "A031069100",
      "display" : "ATELON TABLETS 100MG (ATENOLOL) \"H.S.\""
    },
    {
      "code" : "A031072100",
      "display" : "UNIFRADINE CAPSULES 250 MG (CEPHRADINE)"
    },
    {
      "code" : "A031073100",
      "display" : "UNIFRADINE CAPSULES 500 MG (CEPHRADINE)"
    },
    {
      "code" : "A031086329",
      "display" : "SEPTON SOL (BETAMETHASONE DIPROPIONATE) \"SHIONOGI\""
    },
    {
      "code" : "A031088100",
      "display" : "SINUDIN TABLETS"
    },
    {
      "code" : "A031090100",
      "display" : "CARMAPINE TABLETS 200MG (CARBAMAZEPINE) \"Y.C.\""
    },
    {
      "code" : "A031094209",
      "display" : "UROXIME INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A031094210",
      "display" : "UROXIME INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A031094265",
      "display" : "UROXIME INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A031094277",
      "display" : "UROXIME INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A031094289",
      "display" : "UROXIME INJECTION (CEFUROXIME)"
    },
    {
      "code" : "A031095100",
      "display" : "Kidolex  Capsules  500mg (Cephalexin)"
    },
    {
      "code" : "A031100100",
      "display" : "U-RITIS TABLETS 500MG (NAPROXEN)"
    },
    {
      "code" : "A031101100",
      "display" : "LOLIAN CAPSULES 150MG \"H.S.\" (SILYBIN)"
    },
    {
      "code" : "A0311011G0",
      "display" : "LOLIAN CAPSULES 150MG \"H.S.\" (SILYBIN)"
    },
    {
      "code" : "A031103100",
      "display" : "OBIRA GEL"
    },
    {
      "code" : "A031104100",
      "display" : "EUCOME CAPSULES 100MG \"U-LIANG\" (MECLOFENAMATE SODIUM)"
    },
    {
      "code" : "A031106209",
      "display" : "UNIFRADINE INJECTION (CEPHRADINE) \"UNION\""
    },
    {
      "code" : "A031106277",
      "display" : "UNIFRADINE INJECTION (CEPHRADINE) \"UNION\""
    },
    {
      "code" : "A031107100",
      "display" : "SENTA ENTERIC COATED TABLETS 5MG (SERRATIOPEPTIDASE)"
    },
    {
      "code" : "A0311071G0",
      "display" : "SENTA ENTERIC COATED TABLETS 5MG (SERRATIOPEPTIDASE)"
    },
    {
      "code" : "A031110100",
      "display" : "RIKAPARIN CAPSULES 500MG (TRANEXAMIC ACID)"
    },
    {
      "code" : "A031113121",
      "display" : "U-CITRA GRANULES"
    },
    {
      "code" : "A031114100",
      "display" : "WEI GEL TABLETS"
    },
    {
      "code" : "A031119100",
      "display" : "AMANTADINE SULFATE CAPSULES 100MG \"HCT\""
    },
    {
      "code" : "A031121100",
      "display" : "HARNIC TABLET 60MG (TERFENADINE) \"WINSTON\""
    },
    {
      "code" : "A031138100",
      "display" : "BEFAT F.C. TAB. 200MG  \"STANDARD\"(BEZAFIBRATE)"
    },
    {
      "code" : "A031141100",
      "display" : "RICH TABLET 200MG (KETOCONAZOLE) \"WINSTON\""
    },
    {
      "code" : "A031142109",
      "display" : "ULEXIN FOR ORAL SUSPENSION 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A031142171",
      "display" : "ULEXIN FOR ORAL SUSPENSION 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A031142199",
      "display" : "ULEXIN FOR ORAL SUSPENSION 500MG (CEPHALEXIN)"
    },
    {
      "code" : "A031150321",
      "display" : "LOCACORTEN OINTMENT"
    },
    {
      "code" : "A031151321",
      "display" : "LOCACORTEN-VIOFORM CREAM"
    },
    {
      "code" : "A031153100",
      "display" : "NOSCAPINE TABLETS \"L.S.\""
    },
    {
      "code" : "A031154212",
      "display" : "HYCOMB INJECTION 10MG (HYDROXOCOBALAMIN)"
    },
    {
      "code" : "A031163119",
      "display" : "DYMEDE SYRUP \"T.F.\""
    },
    {
      "code" : "A031165100",
      "display" : "ATADIN CAP. 100MG  \"STANDARD\"(AMANTADINE)"
    },
    {
      "code" : "A031167212",
      "display" : "URIBRA INJECTION (TOBRAMYCIN) \"UNION\""
    },
    {
      "code" : "A031168100",
      "display" : "ISORMOL TABLET 20MG (ISOSORBIDE)"
    },
    {
      "code" : "A031169100",
      "display" : "EUCOME CAPSULES 50MG \"U-LIANG\" (MECLOFENAMATE SODIUM)"
    },
    {
      "code" : "A031170363",
      "display" : "PARMASON GARGLE SOLUTION"
    },
    {
      "code" : "A031171100",
      "display" : "CLINDAMYCIN CAPSULES 150MG \"SYNMOSA\""
    },
    {
      "code" : "A031172100",
      "display" : "CLOMINE TABLETS 10MG (HOMOCHLORCYCILIZINE) \"PFOSHEN\""
    },
    {
      "code" : "A031173100",
      "display" : "ISONINE S.C. TABLETS 40MG (VERAPAMIL) \"EAYUNG\""
    },
    {
      "code" : "A031174100",
      "display" : "SULPYRONE TABLETS 100MG (SULPIRIDE) \"EAYUNG\""
    },
    {
      "code" : "A031175100",
      "display" : "URININE TABLETS 50MG (BENZBROMARONE) \"EAYUNG\""
    },
    {
      "code" : "A031176500",
      "display" : "VOREN SUPOSITORIES 25MG (DICLOFENAC)"
    },
    {
      "code" : "A031179100",
      "display" : "HYDROCHLOROTHIAZIDE TABLETS 25MG \"JEN SHENG\""
    },
    {
      "code" : "A031180100",
      "display" : "PROCHLORPERAZINE MALEATE TABLETS 8MG \"JEN SHENG\""
    },
    {
      "code" : "A031183100",
      "display" : "CHINSALO TABLETS 200MG (BEZAFIBRATE) \"EAYUNG\""
    },
    {
      "code" : "A031185100",
      "display" : "DIFLUINE F.C.TABLETS 250MG (DIFLUNISAL) \"CHINTENG\""
    },
    {
      "code" : "A031186100",
      "display" : "DEANGER TAABLETS 10MG \"S.C.\"(TRIFLUOPERAZINE)"
    },
    {
      "code" : "A031187100",
      "display" : "SUMIN TABLETS 2MG (DEXCHLORPHENIRAMINE MALEATE) \"CHINTENG\""
    },
    {
      "code" : "A031188329",
      "display" : "VOREN EMULGEL (DICLOFENAC)"
    },
    {
      "code" : "A031188338",
      "display" : "VOREN EMULGEL (DICLOFENAC)"
    },
    {
      "code" : "A031189100",
      "display" : "TRIMCORT TABLETS 100MG (TRIMETHOPRIM) \"YUNG SHIN\""
    },
    {
      "code" : "A031190100",
      "display" : "LICHEIN CAPSULES 0.5MG (MECOBALAMIN) \"CHINTENG\""
    },
    {
      "code" : "A031193118",
      "display" : "SUNSO SYRUP"
    },
    {
      "code" : "A031193151",
      "display" : "SUNSO SYRUP"
    },
    {
      "code" : "A031193199",
      "display" : "SUNSO SYRUP"
    },
    {
      "code" : "A031194100",
      "display" : "RANIDINE F.C.TAB. (RANITIDINE) \"S.T.\""
    },
    {
      "code" : "A031198421",
      "display" : "DIBEKACIN OPHTHALEIC SOLUTION 3MG (POTENCY)/ML \"MEIJI\""
    },
    {
      "code" : "A031201100",
      "display" : "MAXURINE TABLET \"KINGDOM\""
    },
    {
      "code" : "A031203143",
      "display" : "CODIUM GRANULES 30MG \"C.H.\"  (DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A031203199",
      "display" : "CODIUM GRANULES 30MG \"C.H.\"  (DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A031205100",
      "display" : "LENDORMIN TABLETS 250MCG"
    },
    {
      "code" : "A031208229",
      "display" : "LIZEPINE LYOPHILIZED INJECTION (PIRENZEPINE) \"LITA\""
    },
    {
      "code" : "A031209100",
      "display" : "ORGAMUCIL TABLETS 60MG (IODOPROPYLIDENE GLYCEROL) \"LITA\""
    },
    {
      "code" : "A031213209",
      "display" : "LOFATIN INJECTION 1000MG (CEFOXITIN) \"GENTLE\""
    },
    {
      "code" : "A031214212",
      "display" : "CHLOMIM-H INJECTION"
    },
    {
      "code" : "A031219100",
      "display" : "BISTOR CAPSULE (DOXYCYCLINE) \"SHITEH\""
    },
    {
      "code" : "A031223100",
      "display" : "ATENO F.C. TABLETS 100MG (ATENOLOL) \"CHINTENG\""
    },
    {
      "code" : "A031224100",
      "display" : "KETOTIFEN CAPSULES \"EAYUNG\""
    },
    {
      "code" : "A031225100",
      "display" : "ACERINE S.C. TABLETS 5MG \"WEIDAR\" (NICERGOLINE)"
    },
    {
      "code" : "A031226100",
      "display" : "LATOL F.C.TABLET 200MG \"STANDARD\""
    },
    {
      "code" : "A031227100",
      "display" : "PAULIN-C TABLETS (ASCORBIC ACID) \"TAIWAN TUNG YANG\""
    },
    {
      "code" : "A031228100",
      "display" : "EFOSIN S.C. TABLETS 50MG \"KOJAR\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A031234100",
      "display" : "RIFAMPICIN CAPSULES 300MG \"R.T.\""
    },
    {
      "code" : "A031238100",
      "display" : "MEBEN CAPSULES 300MG \"Y.S.\" (FENBUFEN)"
    },
    {
      "code" : "A031257209",
      "display" : "UNIPIRIN INJECTION (CEPHAPIRIN) \"UNION\""
    },
    {
      "code" : "A031257277",
      "display" : "UNIPIRIN INJECTION (CEPHAPIRIN) \"UNION\""
    },
    {
      "code" : "A031258421",
      "display" : "GENTASONE EYE DROPS \"UNION\""
    },
    {
      "code" : "A031259100",
      "display" : "UNITADIN CAPSULES 100MG (AMANTADINE)"
    },
    {
      "code" : "A031260100",
      "display" : "HODRIN TABLETS 1.5MG \"WEIDAR\" (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A031263100",
      "display" : "KETOFEN TABLETS \"H.S.C.\" (KETOTIFENE)"
    },
    {
      "code" : "A031267100",
      "display" : "FOTAN TABLETS 60MG (IODOPROPYLIDENE GLYCEROL) \"M.S.\""
    },
    {
      "code" : "A031270100",
      "display" : "OXYTETRACYCLINE HYDROCHLORIDE CAPSULES 250MG \"R.T\""
    },
    {
      "code" : "A0312701G0",
      "display" : "OXYTETRACYCLINE HYDROCHLORIDE CAPSULES 250MG \"R.T\""
    },
    {
      "code" : "A031274209",
      "display" : "Siuguandexaron Injection 4.37 mg/ml"
    },
    {
      "code" : "A031274212",
      "display" : "Siuguandexaron Injection 4.37 mg/ml"
    },
    {
      "code" : "A031274229",
      "display" : "Siuguandexaron Injection 4.37 mg/ml"
    },
    {
      "code" : "A031275100",
      "display" : "SANICON CAPSULES \"LITA\""
    },
    {
      "code" : "A031276100",
      "display" : "TECYTEINE CAPSULES 375MG \"R.T.\" (CARBOCYSTEINE)"
    },
    {
      "code" : "A031277100",
      "display" : "LIMODER CAPSULES \"R.T.\""
    },
    {
      "code" : "A031279100",
      "display" : "PROZAC 20 PULVULES (FLUOXETINE)"
    },
    {
      "code" : "A031280100",
      "display" : "DANOL CAPSULES 200MG"
    },
    {
      "code" : "A031282100",
      "display" : "MARION TABLETS 10MG \"LITA\""
    },
    {
      "code" : "A031283100",
      "display" : "MARION TABLETS 5MG \"LITA\""
    },
    {
      "code" : "A031284100",
      "display" : "CHAZE F.C. TABLETS 200MG (BEZAFIBRATE) \"CHINTENG\""
    },
    {
      "code" : "A031288100",
      "display" : "CERECON CAPSULE 400MG (PIRACETAM) \"KINGDOM\""
    },
    {
      "code" : "A031289100",
      "display" : "EFACO GRANULES 100MG/GM (EPRAZINONE) \"KOJAR\""
    },
    {
      "code" : "A031289109",
      "display" : "EFACO GRANULES 100MG/GM (EPRAZINONE) \"KOJAR\""
    },
    {
      "code" : "A031289199",
      "display" : "EFACO GRANULES 100MG/GM (EPRAZINONE) \"KOJAR\""
    },
    {
      "code" : "A031290100",
      "display" : "LINCOMYCIN HYDROCHLORIDE CAPSULES 500MG \"R.T\""
    },
    {
      "code" : "A031291100",
      "display" : "KONATON TABLETS 500MG (ACETAMINOPHEN) \"KOJAR\""
    },
    {
      "code" : "A031292100",
      "display" : "SANWELL F.C. TABLETS 200MG (CIMETIDINE) \"KOJAR\""
    },
    {
      "code" : "A0312921G0",
      "display" : "SANWELL F.C. TABLETS 200MG (CIMETIDINE) \"KOJAR\""
    },
    {
      "code" : "A031295100",
      "display" : "SEANTO CAPSULES 10MG (OXAZOLAM) \"KOJAR\""
    },
    {
      "code" : "A0312951G0",
      "display" : "SEANTO CAPSULES 10MG (OXAZOLAM) \"KOJAR\""
    },
    {
      "code" : "A031299100",
      "display" : "FORMAX ENTERIC-MICRO-ENCAPSULED 25MG \"SHITEN\" (DICLOFENAC)"
    },
    {
      "code" : "A031300100",
      "display" : "FORMAX CAPSULE 50MG \"SHITEH\" (DICLOFENAC)"
    },
    {
      "code" : "A031302309",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302319",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302321",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302323",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302324",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302329",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302335",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302338",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302340",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302372",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302377",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031302399",
      "display" : "MULTIGIVE CREAM 0.5MG/G (CLOBETASOL PROPIONATE) \"WINSTON\""
    },
    {
      "code" : "A031303309",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303319",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303321",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303324",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303329",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303335",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303338",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303340",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303355",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303372",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031303399",
      "display" : "MULTIGIVE OINTMENT 0.5MG/G \"WINSTON\""
    },
    {
      "code" : "A031307100",
      "display" : "DECOLD CAPSULES 100MG \"R.T.\" (AMANTADINE)"
    },
    {
      "code" : "A031308100",
      "display" : "TICOQUER TABLETS 100MG (MEBENDANOLE) \"R.T.\""
    },
    {
      "code" : "A0313081G0",
      "display" : "TICOQUER TABLETS 100MG (MEBENDANOLE) \"R.T.\""
    },
    {
      "code" : "A031309100",
      "display" : "IMIN TABLETS (METHISOPRINOL)\"YUNG SHIN\""
    },
    {
      "code" : "A031310100",
      "display" : "TRIAZIDE TABLETS \"DCPC\""
    },
    {
      "code" : "A031312100",
      "display" : "ANSU TABLET 2MG (AZULENE) \"TON SIN\""
    },
    {
      "code" : "A031313100",
      "display" : "SEPU CAPSULE 0.25MG (COBAMAMIDE) \"TON SIN\""
    },
    {
      "code" : "A031314100",
      "display" : "WESON TABLET 25MG (PIRENZEPINE HYDROCHLORIDE) \"TON SIN\""
    },
    {
      "code" : "A031315100",
      "display" : "ZUKEI TABLET 400MG (CIMETIDINE) \"TON SIN\""
    },
    {
      "code" : "A031316100",
      "display" : "DASUN CAPSULE 100MG (DANAZOL)\"TON SIN\""
    },
    {
      "code" : "A031317421",
      "display" : "ACOLON ORABASE 1MG/G (DEXAMETHASONE) \"MEIDER\""
    },
    {
      "code" : "A031317499",
      "display" : "ACOLON ORABASE 1MG/G (DEXAMETHASONE) \"MEIDER\""
    },
    {
      "code" : "A031319209",
      "display" : "FELDENE IM INJECTION 20MG/ML (PIROXICAM)"
    },
    {
      "code" : "A031321399",
      "display" : "SLIKA A CREAM \"MEIDER\""
    },
    {
      "code" : "A0313213AH",
      "display" : "SLIKA A CREAM \"MEIDER\""
    },
    {
      "code" : "A031322100",
      "display" : "DEMECLINE CAPSULES 150MG (DEMECLOCYCLINE) \"WINSTON\""
    },
    {
      "code" : "A031323100",
      "display" : "SOLANTIN S.C. TABLETS (DIPYRIDAMOLE)"
    },
    {
      "code" : "A031325324",
      "display" : "SLIKA B CREAM (ISOCONAZOLE) \"MEIDER\""
    },
    {
      "code" : "A031327212",
      "display" : "VESYCA INJECTION 25MG/ML (RANITIDINE)"
    },
    {
      "code" : "A031345100",
      "display" : "DENPIN CAPSULE 30MG (PHENYTOIN) \"TON SIN\""
    },
    {
      "code" : "A031346100",
      "display" : "KANME S.C. TABLET 100MG (NICAMETATE) \"TON SIN\""
    },
    {
      "code" : "A031347138",
      "display" : "YEEWAY SUSPENSION (ALUMINUM PHOSPHATE) (R)"
    },
    {
      "code" : "A031348100",
      "display" : "ULSTAL TABLETS \"SINPHAR\""
    },
    {
      "code" : "A031349100",
      "display" : "UNEW F.C. TABLETS 2.5MG (BROMOCRIPTINE) \"CHINTENG\""
    },
    {
      "code" : "A031350129",
      "display" : "ULSTAL SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A031350163",
      "display" : "ULSTAL SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A031355100",
      "display" : "Orabreeze F.C. TABLETS 25MG \"UNION\"(CHLOROPHYLLIN SODIUM COPPER)"
    },
    {
      "code" : "A031356129",
      "display" : "CONTRACID SUSPENSION 20MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A031359100",
      "display" : "TIDO TABLETS \"CHINTENG\""
    },
    {
      "code" : "A031360100",
      "display" : "S.W.C. TABLETS \"MIYAMOTO KAMPO\""
    },
    {
      "code" : "A031361100",
      "display" : "P.N.T. CAPSULE \"C.H.\""
    },
    {
      "code" : "A031367100",
      "display" : "DANZEN TABLETS 10MG (SERRATIOPEPTIDASE)"
    },
    {
      "code" : "A031368212",
      "display" : "CLINCIN INJ. \"N.K.\" 150MG/ML (CLINDAMYCIN)"
    },
    {
      "code" : "A031369100",
      "display" : "GASTER S.C. TABLETS 20MG (FAMOTIDINE)"
    },
    {
      "code" : "A031376100",
      "display" : "WESU CAPSULE (BROMOPRIDE) \"TON SIN\""
    },
    {
      "code" : "A031377100",
      "display" : "UCER TABLETS 500MG (SUCRALFATE) \"U-LIANG\""
    },
    {
      "code" : "A031378100",
      "display" : "NAPROXEN TABLETS 250MG \"KINGDOM\""
    },
    {
      "code" : "A031381100",
      "display" : "TAZAC PULVULES 300MG (NIZATIDINE)"
    },
    {
      "code" : "A031382100",
      "display" : "TAZAC PULVULES 150MG (NIZATIDINE)"
    },
    {
      "code" : "A031387238",
      "display" : "MANNITOL INJECTION 200MG/ML \"KINGDOM\""
    },
    {
      "code" : "A031434100",
      "display" : "DECOUZE TABLETS 250MG (PROBUCOL) \"R.T.\""
    },
    {
      "code" : "A031443100",
      "display" : "LYNIAOYU S.C. TAB. 100MG (NITROXOLINE) \"TON SIN\""
    },
    {
      "code" : "A031444100",
      "display" : "HABODU TABL. 5MG (HALOPERIDOL) \"TON SIN\""
    },
    {
      "code" : "A031445100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"R.T\""
    },
    {
      "code" : "A031446324",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446329",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446335",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446338",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446340",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446372",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031446399",
      "display" : "CLOTASOL CREAM 0.5MG/GM \"R.T\" (CLOBETASOL)"
    },
    {
      "code" : "A031447100",
      "display" : "SUPERFECT FILM COATING TABLETS 50MG (DICLOFENAC)"
    },
    {
      "code" : "A031448100",
      "display" : "B.C. CAP \"SHIONOGI\""
    },
    {
      "code" : "A031449255",
      "display" : "TNL INJECTION 5MG/ML (TINIDAZOLE) \"N.K.\""
    },
    {
      "code" : "A031450100",
      "display" : "HALOPIN TABLETS 5MG (HALOPERIDOL) \"JOHNSON\""
    },
    {
      "code" : "A031451100",
      "display" : "BENZHEXOL TABLETS 5MG (TRIHEXYPHENIDYL HCL) \"JOHNSON\""
    },
    {
      "code" : "A031475100",
      "display" : "MELLERIL S.C.T. 50MG(THIORIDAZINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031476100",
      "display" : "ETUMINE TABLETS 40MG (CLOTIAPINE)"
    },
    {
      "code" : "A031477100",
      "display" : "DIGOXIN-SANDOZ TABS 0.25MG"
    },
    {
      "code" : "A031480100",
      "display" : "FULIKAN TABLETS 500MG (TINIDAZOLE) \"R.T.\""
    },
    {
      "code" : "A031481100",
      "display" : "SILIRIN CAPSULES 150MG (SILYMARIR) \"CHINTENG\""
    },
    {
      "code" : "A031482100",
      "display" : "SEROMIN S.C. TABLETS 10MG  \"Y.S.\"(NICERGOLIN)"
    },
    {
      "code" : "A031484100",
      "display" : "TARIVID FILM CONATED TABLETS 200MG (OFLOXACIN)"
    },
    {
      "code" : "A031488100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES 250MG \"R.T.\""
    },
    {
      "code" : "A0314881G0",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES 250MG \"R.T.\""
    },
    {
      "code" : "A031489100",
      "display" : "ANKUMIN TABLETS 6MG  \"R.T.\" (BETAHISTINE)"
    },
    {
      "code" : "A0314891G0",
      "display" : "ANKUMIN TABLETS 6MG  \"R.T.\" (BETAHISTINE)"
    },
    {
      "code" : "A031491100",
      "display" : "WEIDECONE TABLETS \"R.T.\""
    },
    {
      "code" : "A031493100",
      "display" : "CHIPHONE TABLETS 100MG  \"R.T.\" (BENZBROMARONE)"
    },
    {
      "code" : "A031495100",
      "display" : "CENCA TABLETS 950MG (CALCIUM CITRATE) \"U-LIANG\""
    },
    {
      "code" : "A031499100",
      "display" : "NAVIDREX TABLETS 0.25MG (CYCLOPENTHIAZIDE)"
    },
    {
      "code" : "A031500100",
      "display" : "MEPIRON S.C. TABLETS 100MG (MEPIRIAOLE) \"PFOSHEN\""
    },
    {
      "code" : "A031501100",
      "display" : "COLFERIN CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A031502100",
      "display" : "CUTCAL TABLETS 75MG (PHENYLPROPANOLAMINE) \"SIU GUAN\""
    },
    {
      "code" : "A031503100",
      "display" : "TUNCHOW TABLETS 100MG (MEBENDAZOLE) \" W.P.\""
    },
    {
      "code" : "A031505100",
      "display" : "HALIN TABLETS 5MG \"YU SHENG\" (HALOPERIDOL)"
    },
    {
      "code" : "A031507100",
      "display" : "DUORIDONE TABLETS 10MG (DOMPERIDONE) \"LITA\""
    },
    {
      "code" : "A0315071G0",
      "display" : "DUORIDONE TABLETS 10MG (DOMPERIDONE) \"LITA\""
    },
    {
      "code" : "A031508209",
      "display" : "PIROCAN INJECTION 20MG \"SIU GUAN\"(PIROXICAM)"
    },
    {
      "code" : "A031508212",
      "display" : "PIROCAN INJECTION 20MG \"SIU GUAN\"(PIROXICAM)"
    },
    {
      "code" : "A031513100",
      "display" : "ROPECON TABLETS 250MG (PIPEMIDIC ACID) \"YUNG CHI\""
    },
    {
      "code" : "A031514100",
      "display" : "ASMAC TABLETS 2.5MG (FENOTEROL HBR) \"YUNG CHI\""
    },
    {
      "code" : "A031515100",
      "display" : "ELININ TABLETS 20MG \"R.T.\" (OXAZOLAM)"
    },
    {
      "code" : "A031519117",
      "display" : "BECANDINE SOLUTION \"R.T.\""
    },
    {
      "code" : "A031519151",
      "display" : "BECANDINE SOLUTION \"R.T.\""
    },
    {
      "code" : "A031519199",
      "display" : "BECANDINE SOLUTION \"R.T.\""
    },
    {
      "code" : "A031520100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"R.T.\""
    },
    {
      "code" : "A031521221",
      "display" : "PENTAL INJECTION 20MG/ML\"LITA\""
    },
    {
      "code" : "A031525100",
      "display" : "\"SIU GUAN\" LILONTON CAPSULE 400MG (PIRACETAM)"
    },
    {
      "code" : "A031526221",
      "display" : "\"SIU GUAN\" LILONTON INJECTION 200MG (PIRACETAM)"
    },
    {
      "code" : "A031526229",
      "display" : "\"SIU GUAN\" LILONTON INJECTION 200MG (PIRACETAM)"
    },
    {
      "code" : "A031528100",
      "display" : "SUCHINGMIEN TABLETS 0.25MG (TRIAZOLAM) \"TON SIN\""
    },
    {
      "code" : "A031529100",
      "display" : "FELDENE DISPERSIBLE TABLET 20MG (PIROXICAM)"
    },
    {
      "code" : "A031534100",
      "display" : "STABLE TABLETS 25 MG (HYDRALAZINE)"
    },
    {
      "code" : "A0315341G0",
      "display" : "STABLE TABLETS 25 MG (HYDRALAZINE)"
    },
    {
      "code" : "A031535100",
      "display" : "ULSAFE F.C.TABLETS 150MG(RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031536100",
      "display" : "PICOLIN F.C. TABLETS 250MG (PIPEMIDIC ACID) \"KOJAR\""
    },
    {
      "code" : "A031537100",
      "display" : "SINGEN F.C.TABLETS 40MG (VERAPAMIL) \"KOJAR\""
    },
    {
      "code" : "A0315371G0",
      "display" : "SINGEN F.C.TABLETS 40MG (VERAPAMIL) \"KOJAR\""
    },
    {
      "code" : "A031540100",
      "display" : "STABLE (HYDRALAZINE) TABLETS 10MG"
    },
    {
      "code" : "A0315401G0",
      "display" : "STABLE (HYDRALAZINE) TABLETS 10MG"
    },
    {
      "code" : "A031542100",
      "display" : "BASIC TABLETS 500MG (CALCIUM CARBONATE) \"MEIDER\""
    },
    {
      "code" : "A031544100",
      "display" : "KODAZOL CAPSULES 200MG (DANAZOL) \"KOJAR\""
    },
    {
      "code" : "A031545100",
      "display" : "CHLORTETRACYCLINE HYDROCHLORIDE CAPSULES 250MG \"R.T.\""
    },
    {
      "code" : "A031552100",
      "display" : "DEXONE TABLETS 0.5MG (DEXAMETHASONE) \"CENTER\""
    },
    {
      "code" : "A031554100",
      "display" : "KETOFEN CAPSULES 50MG (KETOPROFEN) \"CENTER\""
    },
    {
      "code" : "A031558100",
      "display" : "MEFENAL CAPSULES 250MG (MEFENAMIC ACID) \"CENTER\""
    },
    {
      "code" : "A031559100",
      "display" : "DIZZIN CAPSULE 25MG (DIPHENIDOL) \"CENTRE\""
    },
    {
      "code" : "A031562100",
      "display" : "LOPEMID CAPSULES 2MG (LOPERAMIDE) \"CENTER\""
    },
    {
      "code" : "A031563100",
      "display" : "FADAZOLE CAPSULES 500MG (TINIDAZOLE) \"CENTER\""
    },
    {
      "code" : "A031564100",
      "display" : "BETASONE TABLETS 0.5MG (BETAMETHASONE) \"CENTER\""
    },
    {
      "code" : "A031572100",
      "display" : "DICYMINE TABLETS 20MG (DICYLOMINE HYDROCHLORIDE) \"CENTER\""
    },
    {
      "code" : "A031580100",
      "display" : "ULCERPIN TABLETS \"CENTER\""
    },
    {
      "code" : "A031582100",
      "display" : "SALMOL TABLETS 4MG (SALBUTAMOL) \"CENTER\""
    },
    {
      "code" : "A031585100",
      "display" : "G.G. TABLETS 200MG (GUAIFENESIN) \"CENTER\""
    },
    {
      "code" : "A031586100",
      "display" : "ANTI-COUGH TABLETS \"CENTER\""
    },
    {
      "code" : "A031587100",
      "display" : "AMINOPHYLLINE TABLET 100MG (AMINOPHYLLINE) \"CENTER\""
    },
    {
      "code" : "A031588100",
      "display" : "RIBOFLAVIN TABLETS 10MG \"CENTER\""
    },
    {
      "code" : "A031589100",
      "display" : "CENDALAT CAP. 10MG (NIFEDIPINE) \"CENTER\""
    },
    {
      "code" : "A031592100",
      "display" : "MEWELLIN F.C. TABLETS 10MG (DOMPERIDONE) \"KOJAR\""
    },
    {
      "code" : "A0315921G0",
      "display" : "MEWELLIN F.C. TABLETS 10MG (DOMPERIDONE) \"KOJAR\""
    },
    {
      "code" : "A031593100",
      "display" : "FURNAZM TABLETS 5MG (FLUNARIZINE) \"CHINTENG\""
    },
    {
      "code" : "A0315931G0",
      "display" : "FURNAZM TABLETS 5MG (FLUNARIZINE) \"CHINTENG\""
    },
    {
      "code" : "A031596100",
      "display" : "LICODIN F.C. TABLET 100MG (TICLOPIDINE)"
    },
    {
      "code" : "A031608500",
      "display" : "DOMPEDON SUPPOSITORY 10MG \"STANDARD\"(DOMPERIDONE)"
    },
    {
      "code" : "A031609100",
      "display" : "LIGISIN F.C. TABLETS 200MG (BEZAFIBRATE) \"KOJAR\""
    },
    {
      "code" : "A031614423",
      "display" : "STACORT DENTAL PASTE 1MG/G  \"STANDARD\"(TRIAMCINOLONE)"
    },
    {
      "code" : "A031628277",
      "display" : "AMINOLEBAN R INJECTION"
    },
    {
      "code" : "A031630209",
      "display" : "CETAME FOR INJECTION \"SWISS\"(CEFOTAXIME)"
    },
    {
      "code" : "A031630212",
      "display" : "CETAME FOR INJECTION \"SWISS\"(CEFOTAXIME)"
    },
    {
      "code" : "A031630277",
      "display" : "CETAME FOR INJECTION \"SWISS\"(CEFOTAXIME)"
    },
    {
      "code" : "A031637321",
      "display" : "DIPROGENTA CREAM"
    },
    {
      "code" : "A031637335",
      "display" : "DIPROGENTA CREAM"
    },
    {
      "code" : "A031640212",
      "display" : "DUORIDONE INJECTION 5MG/ML (DOMPERIDONE) \"LITA\""
    },
    {
      "code" : "A031641100",
      "display" : "FEVILON TABLETS 200MG \"LITA\" (BEZAFIBRATE)"
    },
    {
      "code" : "A031649329",
      "display" : "EPELON CREAM \"N.K.\""
    },
    {
      "code" : "A031649338",
      "display" : "EPELON CREAM \"N.K.\""
    },
    {
      "code" : "A031651417",
      "display" : "SCORO ORABASE 1MG/G (TRIAMCINOLONE) \"MEIDER\""
    },
    {
      "code" : "A031651421",
      "display" : "SCORO ORABASE 1MG/G (TRIAMCINOLONE) \"MEIDER\""
    },
    {
      "code" : "A031651423",
      "display" : "SCORO ORABASE 1MG/G (TRIAMCINOLONE) \"MEIDER\""
    },
    {
      "code" : "A031651499",
      "display" : "SCORO ORABASE 1MG/G (TRIAMCINOLONE) \"MEIDER\""
    },
    {
      "code" : "A031656100",
      "display" : "WEISU TABLETS 400MG (CIMETIDINE) \"S.D.\""
    },
    {
      "code" : "A0316561G0",
      "display" : "WEISU TABLETS 400MG (CIMETIDINE) \"S.D.\""
    },
    {
      "code" : "A031658100",
      "display" : "FORKNOW TABLETS 10MG (FLUNARIZINE) \"YUNG SHIN\""
    },
    {
      "code" : "A031659100",
      "display" : "BUTIN TABLETS 2.5MG (BROMOCRIPTINE)"
    },
    {
      "code" : "A031660100",
      "display" : "ANTISSVES CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A0316601G0",
      "display" : "ANTISSVES CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A031662100",
      "display" : "AXOL TABLETS 30MG (AMBROXOL) \"YUNG SHIN\""
    },
    {
      "code" : "A031665100",
      "display" : "IOPIDOL TABLETS 60MG (IODOPROPYLIDENE GLYCEROL) \"KOJAR\""
    },
    {
      "code" : "A031666100",
      "display" : "CATIN TABLETS 100MG (TRIMETHOPRIM) \"KOJAR\""
    },
    {
      "code" : "A0316661G0",
      "display" : "CATIN TABLETS 100MG (TRIMETHOPRIM) \"KOJAR\""
    },
    {
      "code" : "A031667100",
      "display" : "NIFU CAPSULES 250MG (NIFLUMIC ACID) \"KOJAR\""
    },
    {
      "code" : "A031671100",
      "display" : "SUCOUGH S.C. TABLETS"
    },
    {
      "code" : "A031672100",
      "display" : "CO-CHLORPHENIRAMINE"
    },
    {
      "code" : "A031673100",
      "display" : "SOURIREE COM-TRIMETON TABLETS 4MG"
    },
    {
      "code" : "A031675335",
      "display" : "CORN REMOVAL"
    },
    {
      "code" : "A031676100",
      "display" : "Compesolon Tablets 5mg \"Pine Lawer\"(Prednisolone)"
    },
    {
      "code" : "A0316761G0",
      "display" : "Compesolon Tablets 5mg \"Pine Lawer\"(Prednisolone)"
    },
    {
      "code" : "A031679100",
      "display" : "SOURIREE VITAMIN B1 TABLETS 100MG"
    },
    {
      "code" : "A031680100",
      "display" : "Standard Vomiseda Tablets 25mg"
    },
    {
      "code" : "A031681118",
      "display" : "DIAMINE ORAL SOLUTION 4MG/ML \"Center\"(DIPHENHYDRAMINE HCL)"
    },
    {
      "code" : "A031681157",
      "display" : "DIAMINE ORAL SOLUTION 4MG/ML \"Center\"(DIPHENHYDRAMINE HCL)"
    },
    {
      "code" : "A031681172",
      "display" : "DIAMINE ORAL SOLUTION 4MG/ML \"Center\"(DIPHENHYDRAMINE HCL)"
    },
    {
      "code" : "A031681199",
      "display" : "DIAMINE ORAL SOLUTION 4MG/ML \"Center\"(DIPHENHYDRAMINE HCL)"
    },
    {
      "code" : "A031682100",
      "display" : "LYSOMIN TABLETS 50MG (LYSOZYME) \"TCY\""
    },
    {
      "code" : "A031683100",
      "display" : "LINKE KOU TABLETS"
    },
    {
      "code" : "A031688100",
      "display" : "SWINORIN TABLET 100MG (ATENOLOL)"
    },
    {
      "code" : "A031690100",
      "display" : "FETISMA TABLETS 2.5MG (FENOTEROL) \"KOJAR\""
    },
    {
      "code" : "A0316901G0",
      "display" : "FETISMA TABLETS 2.5MG (FENOTEROL) \"KOJAR\""
    },
    {
      "code" : "A031694100",
      "display" : "STOIN TABLETS 10MG (OXETHAZAINE) \"KOJAR\""
    },
    {
      "code" : "A031695209",
      "display" : "BUFENCON INJECTION"
    },
    {
      "code" : "A031695221",
      "display" : "BUFENCON INJECTION"
    },
    {
      "code" : "A031728100",
      "display" : "GASTRODIN TABLETS 400MG (CIMETIDINE) \"U-LIANG\""
    },
    {
      "code" : "A031737151",
      "display" : "SANCOUGH-CO SYRUP"
    },
    {
      "code" : "A031737157",
      "display" : "SANCOUGH-CO SYRUP"
    },
    {
      "code" : "A031737199",
      "display" : "SANCOUGH-CO SYRUP"
    },
    {
      "code" : "A031743100",
      "display" : "AMINOCIN CAPSULES"
    },
    {
      "code" : "A031753100",
      "display" : "B.M.O. TABLETS"
    },
    {
      "code" : "A031757157",
      "display" : "B.M.O. LIQUID"
    },
    {
      "code" : "A031757199",
      "display" : "B.M.O. LIQUID"
    },
    {
      "code" : "A031770100",
      "display" : "LIDONIN TABLETS 10MG (DOMPERIDONE) \"CHEN SING\""
    },
    {
      "code" : "A031771100",
      "display" : "DITOPAX TABLETS"
    },
    {
      "code" : "A031773277",
      "display" : "KEFADIM INJECTION 500MG (CEFTAZIDIME)"
    },
    {
      "code" : "A031774209",
      "display" : "KEFADIM INJECTION 1G (CEFTAZIDIME)"
    },
    {
      "code" : "A031776100",
      "display" : "NAXEN TABLETS 100MG \"TAIWAN TANABE\""
    },
    {
      "code" : "A031778100",
      "display" : "PROXEN TABLETS 375MG (NAPROXEN) \"TAIWAN TANABE\""
    },
    {
      "code" : "A031796100",
      "display" : "OXOLA TABLETS 100MG (OXOLAMINE CITRATE) \"KOJAR\""
    },
    {
      "code" : "A0317961G0",
      "display" : "OXOLA TABLETS 100MG (OXOLAMINE CITRATE) \"KOJAR\""
    },
    {
      "code" : "A031797100",
      "display" : "ANLINA CAPSULES 75MG (PHENYLPROPANOLAMINE) \"KOJAR\""
    },
    {
      "code" : "A031799100",
      "display" : "GASCON TABLET 40MG (DIMETHICONE)"
    },
    {
      "code" : "A031800100",
      "display" : "Algitab Chewable Tablets"
    },
    {
      "code" : "A031801100",
      "display" : "KETOSMA CAPSULES 1MG (KETOTIFEN) \"KOJAR\""
    },
    {
      "code" : "A0318011G0",
      "display" : "KETOSMA CAPSULES 1MG (KETOTIFEN) \"KOJAR\""
    },
    {
      "code" : "A031802100",
      "display" : "NISIPIN CAPSULE 10MG \"C.H.\" (NIFEDIPINE)"
    },
    {
      "code" : "A031807100",
      "display" : "CHINSA TABLETS 200MG \"Y.C.\" (BEZAFIBRATE)"
    },
    {
      "code" : "A031808100",
      "display" : "MENYAN S.C. TABLETS 50MG (MEDHYDROLINE) \"EAYUNG\""
    },
    {
      "code" : "A031809100",
      "display" : "CATON TAB \"C.H.\""
    },
    {
      "code" : "A031820100",
      "display" : "SIMON CAPSULES 100MG \"Y.C.\" (AMANTADINE)"
    },
    {
      "code" : "A031821177",
      "display" : "SIMON SOLUTION 10MG/ML \"Y.C.\" (AMANTADINE)"
    },
    {
      "code" : "A031823100",
      "display" : "BENZSIN TABLETS 50MG (BENZBROMARONE) \"KOJAR\""
    },
    {
      "code" : "A0318231G0",
      "display" : "BENZSIN TABLETS 50MG (BENZBROMARONE) \"KOJAR\""
    },
    {
      "code" : "A031824100",
      "display" : "CIMEWELL F.C. TABLETS 400MG (CIMETIDINE) \"KOJAR\""
    },
    {
      "code" : "A0318241G0",
      "display" : "CIMEWELL F.C. TABLETS 400MG (CIMETIDINE) \"KOJAR\""
    },
    {
      "code" : "A031825100",
      "display" : "BECASONE TABLETS 0.6MG (BETAMETHASONE) \"KOJAR\""
    },
    {
      "code" : "A031826100",
      "display" : "MINOCIN TABLETS (MINOCYCLINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031828100",
      "display" : "CALTRATE CHEWABLE TABLETS"
    },
    {
      "code" : "A031829135",
      "display" : "LEDERSCON SUSPENSION"
    },
    {
      "code" : "A031829177",
      "display" : "LEDERSCON SUSPENSION"
    },
    {
      "code" : "A031829199",
      "display" : "LEDERSCON SUSPENSION"
    },
    {
      "code" : "A031830100",
      "display" : "ACHROMYCIN CAPSULES 500MG (TETRACYCLINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031832100",
      "display" : "UNAZOL CAPSULES 200MG (DANAZOL) \"UNION\""
    },
    {
      "code" : "A031833100",
      "display" : "TRANXAMIDE CAPSULES \"H.S.\""
    },
    {
      "code" : "A031835289",
      "display" : "Ceflour Injection 0.75gm \"Yung Shin\" (Cefuroxime)"
    },
    {
      "code" : "A031837100",
      "display" : "PORO TABLETS 80MG (ACETAMINOPHEN)"
    },
    {
      "code" : "A031838100",
      "display" : "SEDON TABLETS \"PFOSHEN\""
    },
    {
      "code" : "A031839100",
      "display" : "FERDIN TABLETS 60MG (TERFENADINE) \"WEIDAR\""
    },
    {
      "code" : "A031840421",
      "display" : "FLULON EYE DROPS 1MG/ML (FLUOROMETOLONE) \"UNION\""
    },
    {
      "code" : "A031841100",
      "display" : "METHACOLIMYCIN CAPSULES 1,000,000 UNITS (COLISTIMETHATE SODIUM) \"DCPC\""
    },
    {
      "code" : "A031842100",
      "display" : "METHACOLIMYCIN CAPSULES 2,000,000 UNITS (COLISTMETHATE SODIUM)"
    },
    {
      "code" : "A031842148",
      "display" : "METHACOLIMYCIN CAPSULES 2,000,000 UNITS (COLISTMETHATE SODIUM)"
    },
    {
      "code" : "A031842199",
      "display" : "METHACOLIMYCIN CAPSULES 2,000,000 UNITS (COLISTMETHATE SODIUM)"
    },
    {
      "code" : "A031844100",
      "display" : "RIOPAN TABLETS 400MG (MAGALDRATE)"
    },
    {
      "code" : "A031846212",
      "display" : "Ulecin Injection 150mg/ml(Clindamycin)\"Astar\""
    },
    {
      "code" : "A031847100",
      "display" : "DORINK CAPSULES 200MG (DANAZOL)\"DCPC\""
    },
    {
      "code" : "A031853100",
      "display" : "GENXATE F.C. TABLETS 200MG \"Y.S.\" (FLAVOXATE)"
    },
    {
      "code" : "A031878209",
      "display" : "DIMEN INJECTION 50MG/ML (DIMENHYDRINATE) \"UNION\""
    },
    {
      "code" : "A031878221",
      "display" : "DIMEN INJECTION 50MG/ML (DIMENHYDRINATE) \"UNION\""
    },
    {
      "code" : "A031881500",
      "display" : "VOTALIN SUPPOSITORY 12.5MG (DICLOFENAC SODIUM) \"P.L.\""
    },
    {
      "code" : "A031882209",
      "display" : "U-SAVE-A FOR INJECTION (CEPHRADINE)"
    },
    {
      "code" : "A031882212",
      "display" : "U-SAVE-A FOR INJECTION (CEPHRADINE)"
    },
    {
      "code" : "A031882277",
      "display" : "U-SAVE-A FOR INJECTION (CEPHRADINE)"
    },
    {
      "code" : "A031889100",
      "display" : "HESOR TABLETS 30MG  \"YU SHENG\" (DILTIAZEM HYDROCHLORIDE)"
    },
    {
      "code" : "A031890127",
      "display" : "SEMIDE POWDER (CHOLESTYRAMINE RESIN) \"S.S.P\""
    },
    {
      "code" : "A031892100",
      "display" : "ZANTAC TABLETS 150MG (RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031893100",
      "display" : "ZANTAC TABLETS 300MG (RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031894100",
      "display" : "ASTHAN TABLETS 1MG \"P.L\" (KETOTIFEN)"
    },
    {
      "code" : "A0318941G0",
      "display" : "ASTHAN TABLETS 1MG \"P.L\" (KETOTIFEN)"
    },
    {
      "code" : "A031895100",
      "display" : "MELLERZIN S.C. TABLETS 50MG \"P.L\" (THIORIDAZINE)"
    },
    {
      "code" : "A031896100",
      "display" : "MUSCO TABLETS 3OMG \"STANDARD\"(AMBROXOL HYDROCHLORlDE)"
    },
    {
      "code" : "A0318961G0",
      "display" : "MUSCO TABLETS 3OMG \"STANDARD\"(AMBROXOL HYDROCHLORlDE)"
    },
    {
      "code" : "A031906100",
      "display" : "BARLOLIN CAPSULE 2.5MG \"SWISS\" (BROMOCRIPTINE)"
    },
    {
      "code" : "A031907100",
      "display" : "NEOBA CAPSULES 500MCG  \"S.Y.\" (METHYL COBALAMINE)"
    },
    {
      "code" : "A031908255",
      "display" : "FLUGEN INJECTION 5MG \"SIU GUAN\" (TINIDAZOLE)"
    },
    {
      "code" : "A031908277",
      "display" : "FLUGEN INJECTION 5MG \"SIU GUAN\" (TINIDAZOLE)"
    },
    {
      "code" : "A031909100",
      "display" : "MAXPRESS TABLET"
    },
    {
      "code" : "A031911100",
      "display" : "DARGEN E.S.C. TABLETS 5MG (SERRATIOPEPTIDASE) \"EAYUNG\""
    },
    {
      "code" : "A031912100",
      "display" : "AMBROXOL TABLETS 30MG \"CHINTENG\""
    },
    {
      "code" : "A0319121G0",
      "display" : "AMBROXOL TABLETS 30MG \"CHINTENG\""
    },
    {
      "code" : "A031922338",
      "display" : "INDOCIN CREAM 10MG/GM  \"S.Y.\"(INDOMETHACIN)"
    },
    {
      "code" : "A031927138",
      "display" : "OCTA-VITA DROPS \"SOURIREE\""
    },
    {
      "code" : "A031930435",
      "display" : "COMPHEDRINE SOLUTION (PHENYLEPHEDRINE HCL) \"COMFORT\""
    },
    {
      "code" : "A031931100",
      "display" : "Multivitamin S.C. Tablets \"Pine Lawer\""
    },
    {
      "code" : "A031932100",
      "display" : "Diamine Capsules 25mg \"SOURIREE\"(Diphenhydramine HCl)"
    },
    {
      "code" : "A031933100",
      "display" : "SOURIREE COMCEB CAPSULES 1MG (CYANOCOBALAMIN)"
    },
    {
      "code" : "A0319331G0",
      "display" : "SOURIREE COMCEB CAPSULES 1MG (CYANOCOBALAMIN)"
    },
    {
      "code" : "A031934118",
      "display" : "SUCAROL SYRUP \"SOURIREE\""
    },
    {
      "code" : "A031934199",
      "display" : "SUCAROL SYRUP \"SOURIREE\""
    },
    {
      "code" : "A031938118",
      "display" : "COMPOUND GLYCYRRHIZA MIXTURE ORAL SOLUTION \"CENTER\""
    },
    {
      "code" : "A031938157",
      "display" : "COMPOUND GLYCYRRHIZA MIXTURE ORAL SOLUTION \"CENTER\""
    },
    {
      "code" : "A031938163",
      "display" : "COMPOUND GLYCYRRHIZA MIXTURE ORAL SOLUTION \"CENTER\""
    },
    {
      "code" : "A031938172",
      "display" : "COMPOUND GLYCYRRHIZA MIXTURE ORAL SOLUTION \"CENTER\""
    },
    {
      "code" : "A031938199",
      "display" : "COMPOUND GLYCYRRHIZA MIXTURE ORAL SOLUTION \"CENTER\""
    },
    {
      "code" : "A031939118",
      "display" : "CO-SUCAROL SYRUP \"SOURIREE\""
    },
    {
      "code" : "A031939199",
      "display" : "CO-SUCAROL SYRUP \"SOURIREE\""
    },
    {
      "code" : "A031940100",
      "display" : "BELLADONNA-P TABLETS"
    },
    {
      "code" : "A031941100",
      "display" : "AMINOPHYLLINE AND PHENOBARBITAL TABLETS \"COMFORT\""
    },
    {
      "code" : "A031942100",
      "display" : "SOURIREE ASCORBIC ACID TABLETS 100MG"
    },
    {
      "code" : "A031943100",
      "display" : "SOURIREE RIBOFIAVIN TABLETS"
    },
    {
      "code" : "A031948100",
      "display" : "DICOMTRIDE TABLETS 50MG (HYDROCHLOROTHIAZIDE)\"COMFORT\""
    },
    {
      "code" : "A031951100",
      "display" : "DIOMIN TABLETS \"KOJAR\" (GLIBENCLAMIDE)"
    },
    {
      "code" : "A031952100",
      "display" : "FUNASIN CAPSULES 5MG \"KOJAR\" (FLUNARIZINE)"
    },
    {
      "code" : "A0319521G0",
      "display" : "FUNASIN CAPSULES 5MG \"KOJAR\" (FLUNARIZINE)"
    },
    {
      "code" : "A031953100",
      "display" : "CHENO CAPSULES 250MG \"KOJAR\" (CHENODEOXYCHOLIC ACID)"
    },
    {
      "code" : "A031954100",
      "display" : "BEZIN TABLETS 200MG (BEZAFIBRATE) \"S.D.\""
    },
    {
      "code" : "A031961100",
      "display" : "CARBOCYS TABLETS 250MG (CARBOCYSTEINE) \"SINPHAR\""
    },
    {
      "code" : "A031962100",
      "display" : "SUTON TABLETS"
    },
    {
      "code" : "A031964100",
      "display" : "DOXABEN TABLT 1MG (DOXAZOSIN MESYLATE)"
    },
    {
      "code" : "A031965100",
      "display" : "DOXABEN TAbLETS 2MG (DOXAZOSIN MESYLATE)"
    },
    {
      "code" : "A031966100",
      "display" : "DOXABEN TABLETS 4MG (DOXAZOSIN MESYLATE)"
    },
    {
      "code" : "A031976500",
      "display" : "STAZOL VAG. SUPP. 150MG \"STANDARD\"(ECONAZOLE)"
    },
    {
      "code" : "A031977100",
      "display" : "FLUOXYMESTERONE CAPSULES 5MG \"C.H.\" (FLUOXYMESTERONE)"
    },
    {
      "code" : "A031978329",
      "display" : "TRINAZOLE CREAM \"YUNG CHI\""
    },
    {
      "code" : "A031979100",
      "display" : "ANTADINE TABLETS 100MG (AMANTADINE) \"YUNG CHI\""
    },
    {
      "code" : "A031983238",
      "display" : "DITROSE INJECTION 5％ \"S.Y.\" (DEXTROSE)"
    },
    {
      "code" : "A031983265",
      "display" : "DITROSE INJECTION 5％ \"S.Y.\" (DEXTROSE)"
    },
    {
      "code" : "A031983277",
      "display" : "DITROSE INJECTION 5％ \"S.Y.\" (DEXTROSE)"
    },
    {
      "code" : "A031988100",
      "display" : "MOTURIN TALBETS 10MG \"Y.S.\" (DOMPERIDONE)"
    },
    {
      "code" : "A031989100",
      "display" : "MELZIN S.C. TALBETS 25MG \"Y.S.\" (THIORIDAZINE)"
    },
    {
      "code" : "A031990100",
      "display" : "FENCAINE TABLETS 10MG \"Y.S.\"(OXETHAZAINE)"
    },
    {
      "code" : "A0319901G0",
      "display" : "FENCAINE TABLETS 10MG \"Y.S.\"(OXETHAZAINE)"
    },
    {
      "code" : "A031991100",
      "display" : "UTELAX TABLETS 10MG \"WEIDAR\"(RITODRINE HYDROCHLORIDE)"
    },
    {
      "code" : "A031993100",
      "display" : "BESUTIN TABLETS 6MG \"Y.S.\" (BETAHISTINE)"
    },
    {
      "code" : "A031999100",
      "display" : "MUCOBRON TAbLETS 30MG (AMBROXOL HYDROCHLORIDE) \"WEIDAR\""
    },
    {
      "code" : "A0319991G0",
      "display" : "MUCOBRON TAbLETS 30MG (AMBROXOL HYDROCHLORIDE) \"WEIDAR\""
    },
    {
      "code" : "A032000100",
      "display" : "PENTOSIN E.S.C.TABLETS 100MG (PENTOXIFYLLINE) \"KOJAR\""
    },
    {
      "code" : "A0320001G0",
      "display" : "PENTOSIN E.S.C.TABLETS 100MG (PENTOXIFYLLINE) \"KOJAR\""
    },
    {
      "code" : "A032001100",
      "display" : "COSIN TABLETS 20MG \"KOJAR\" (NOSCAPINE)"
    },
    {
      "code" : "A0320011G0",
      "display" : "COSIN TABLETS 20MG \"KOJAR\" (NOSCAPINE)"
    },
    {
      "code" : "A032002100",
      "display" : "MEBLIN TABLETS  50MG \"KOJAR\" (MEBHYDROLIN)"
    },
    {
      "code" : "A0320021G0",
      "display" : "MEBLIN TABLETS  50MG \"KOJAR\" (MEBHYDROLIN)"
    },
    {
      "code" : "A032003100",
      "display" : "NAPOSIN TABLETS 250MG \"KOJAR\" (NAPROXEN)"
    },
    {
      "code" : "A0320031G0",
      "display" : "NAPOSIN TABLETS 250MG \"KOJAR\" (NAPROXEN)"
    },
    {
      "code" : "A032004100",
      "display" : "MITON F.C.TABLETS 100MG \"KOJAR\""
    },
    {
      "code" : "A032005348",
      "display" : "BIFIDER POWDER (BIFIDOBACTERIUM)"
    },
    {
      "code" : "A032006321",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032006324",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032006329",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032006335",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032006372",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032006399",
      "display" : "COBESONE CREAM 0.5MG/G \"P.J.\""
    },
    {
      "code" : "A032007100",
      "display" : "ETOSCOL TABLETS 0.5MG (HEXOPRENALINE)"
    },
    {
      "code" : "A032009100",
      "display" : "METOPELAN TABLETS 5MG (METOCLOPRAMIDE) \"P.J.\""
    },
    {
      "code" : "A032011100",
      "display" : "BROMOTINE TABLETS 2.87MG (BROMOCRIPTINE) \"P.J.\""
    },
    {
      "code" : "A032014100",
      "display" : "EUZIP TABLETS 50MG (NICAMETATE)"
    },
    {
      "code" : "A0320141G0",
      "display" : "EUZIP TABLETS 50MG (NICAMETATE)"
    },
    {
      "code" : "A032015100",
      "display" : "CLONIDINE TABLETS 0.15MG \"CHINTENG\""
    },
    {
      "code" : "A032018100",
      "display" : "TRANLO TABLETS 15MG\"D.T.S\""
    },
    {
      "code" : "A032027338",
      "display" : "TORICAM GEL 5MG/G (PIROXICAM)"
    },
    {
      "code" : "A032028100",
      "display" : "VITAMIN B12 TALBETS 1MG \"JOHNSON\""
    },
    {
      "code" : "A032029100",
      "display" : "FLURAZIN F.C. TALBETS 5MG (TRIFLUOPERAZINE) \"JOHNSON\""
    },
    {
      "code" : "A032030100",
      "display" : "HALOPIN TABLETS 10MG (HALOPERIDOL) \"JOHNSON\""
    },
    {
      "code" : "A032042100",
      "display" : "TRIALAM TALBETS 0.25MG \"WEIDAR\" (TRIAZOLAM)"
    },
    {
      "code" : "A032045100",
      "display" : "ASPIRIN E.F.C.TABLETS 650MG \"KOJAR\""
    },
    {
      "code" : "A032046100",
      "display" : "DIPYRIDAMOLE S.C. TABLETS 75MG \"YUNG SHIN\""
    },
    {
      "code" : "A0320461G0",
      "display" : "DIPYRIDAMOLE S.C. TABLETS 75MG \"YUNG SHIN\""
    },
    {
      "code" : "A032047100",
      "display" : "YUREN E.F.C.TABLETS 50MG \"Y.S.\"(DICLOFENAC SODIUM)"
    },
    {
      "code" : "A032048100",
      "display" : "FELDINE CAPSULES 10MG (PIROXOCAM)\"KINGDOM\""
    },
    {
      "code" : "A032049100",
      "display" : "AMANTADINE HYDROCHLORIDE CAPSULES 100MG \"KINGDOM\""
    },
    {
      "code" : "A032050429",
      "display" : "ATROPINE SULPHATE OPHTHALMIC SOLUTION 1％ \"WU FU\""
    },
    {
      "code" : "A032051309",
      "display" : "BETAMETHASONE OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A032051321",
      "display" : "BETAMETHASONE OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A032051372",
      "display" : "BETAMETHASONE OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A032051399",
      "display" : "BETAMETHASONE OINTMENT 0.5MG/GM \"SINPHAR\""
    },
    {
      "code" : "A032052100",
      "display" : "TENNON TABLETS 100MG (ATENOLOL) \"PFOSHEN\""
    },
    {
      "code" : "A032053100",
      "display" : "PENTAL S.C.TABLETS 100MG (PENTOXIFYLLINE) \"JOHNSON\""
    },
    {
      "code" : "A032054100",
      "display" : "LICOS TABLETS 50MG (PIPERIDOLATE) \"MEIDER\""
    },
    {
      "code" : "A032056100",
      "display" : "SERRALO E.F.C.TABLETS 5MG (SERRATIOPEPTIDASE) \"KOJAR\""
    },
    {
      "code" : "A0320561G0",
      "display" : "SERRALO E.F.C.TABLETS 5MG (SERRATIOPEPTIDASE) \"KOJAR\""
    },
    {
      "code" : "A032057100",
      "display" : "VOLTAREN F.C.T. SR 100MG (DICLOFENAC SODIUM)"
    },
    {
      "code" : "A032058421",
      "display" : "ATROPINE SULPHATE OPHTHALMIC SOLUTION 0.5％ \"WU FU\""
    },
    {
      "code" : "A032058429",
      "display" : "ATROPINE SULPHATE OPHTHALMIC SOLUTION 0.5％ \"WU FU\""
    },
    {
      "code" : "A032059209",
      "display" : "KLAFORM FOR INJECTION (CEFOTAXIME) \"WINSTON\""
    },
    {
      "code" : "A032059212",
      "display" : "KLAFORM FOR INJECTION (CEFOTAXIME) \"WINSTON\""
    },
    {
      "code" : "A032059277",
      "display" : "KLAFORM FOR INJECTION (CEFOTAXIME) \"WINSTON\""
    },
    {
      "code" : "A032060323",
      "display" : "VOLTAREN EMULGEL 1％ (DICLOFENAC)"
    },
    {
      "code" : "A032060329",
      "display" : "VOLTAREN EMULGEL 1％ (DICLOFENAC)"
    },
    {
      "code" : "A032060338",
      "display" : "VOLTAREN EMUGEL 1％ 20GM"
    },
    {
      "code" : "A032060345",
      "display" : "VOLTAREN EMUGEL 1％ (DICLOFENAC)"
    },
    {
      "code" : "A032061209",
      "display" : "CEFOZONE INJECTION (CEFOPERAZONE) \"Y.F.\""
    },
    {
      "code" : "A032061277",
      "display" : "CEFOZONE INJECTION (CEFOPERAZONE) \"Y.F.\""
    },
    {
      "code" : "A032064100",
      "display" : "WINTIDINE F.C. TALBET 400MG (CIMETIDINE) \"WINSTON\""
    },
    {
      "code" : "A0320641G0",
      "display" : "WINTIDINE F.C. TALBET 400MG (CIMETIDINE) \"WINSTON\""
    },
    {
      "code" : "A032065100",
      "display" : "CLINCIN CAP. 150MG (CLINDAMYCIN) \"N.K.\""
    },
    {
      "code" : "A032066321",
      "display" : "DERMOVATE CREAM 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032066340",
      "display" : "DERMOVATE CREAM 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032066355",
      "display" : "DERMOVATE CREAM 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032066399",
      "display" : "DERMOVATE CREAM 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032067100",
      "display" : "VENTOLIN TABLETS 2MG (SALBUTAMOL SULPHATE)"
    },
    {
      "code" : "A032068100",
      "display" : "TRANDATE TABLETS 200MG (LABETALOL HYDROCHLORIDE)"
    },
    {
      "code" : "A032069321",
      "display" : "DERMOVATE OINTMENT 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032069340",
      "display" : "DERMOVATE OINTMENT 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032069355",
      "display" : "DERMOVATE OINTMENT 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032069399",
      "display" : "DERMOVATE OINTMENT 0.05％ (CLOBETASOL PROPIONATE)"
    },
    {
      "code" : "A032070321",
      "display" : "EYME CREAM \"CHINTENG\""
    },
    {
      "code" : "A032070329",
      "display" : "EYME CREAM \"CHINTENG\""
    },
    {
      "code" : "A032070399",
      "display" : "EYME CREAM \"CHINTENG\""
    },
    {
      "code" : "A032072329",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A032072335",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A032072338",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A032072377",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A032072399",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A0320723AK",
      "display" : "U-CHU SOLBETA CREAM 0.5MG/GM (CLOBETASOL)"
    },
    {
      "code" : "A032105321",
      "display" : "FUCON CREAM \"S.Y.\""
    },
    {
      "code" : "A032105329",
      "display" : "FUCON CREAM \"S.Y.\""
    },
    {
      "code" : "A032105335",
      "display" : "FUCON CREAM \"S.Y.\""
    },
    {
      "code" : "A032105372",
      "display" : "FUCON CREAM \"S.Y.\""
    },
    {
      "code" : "A032105399",
      "display" : "FUCON CREAM \"S.Y.\""
    },
    {
      "code" : "A032111100",
      "display" : "ACTIRIN TABLETS \"SINPHAR\""
    },
    {
      "code" : "A032112100",
      "display" : "COLIMAN S.C. TABLETS 100MG \"P.L.\" (CHLORPROMAZINE)"
    },
    {
      "code" : "A032113100",
      "display" : "TOSUMIN TABLETS \"WEIDAR\""
    },
    {
      "code" : "A032114100",
      "display" : "BENZBROMARONE TABLETS 50MG \"CHIN TENG\""
    },
    {
      "code" : "A032116100",
      "display" : "SERENIN S.C. TABLETS 10MG (OXAZOLAM) \"EAYUNG\""
    },
    {
      "code" : "A032117100",
      "display" : "APOLIN TABLETS 25MG \"Y.S.\" (HYDRALAZINE)"
    },
    {
      "code" : "A0321171G0",
      "display" : "APOLIN TABLETS 25MG \"Y.S.\" (HYDRALAZINE)"
    },
    {
      "code" : "A032118212",
      "display" : "EUKACIN INJECTION 250MG/ML \"U-LIANG\"(AMIKACIN)"
    },
    {
      "code" : "A032118229",
      "display" : "EUKACIN INJECTION 250MG/ML \"U-LIANG\"(AMIKACIN)"
    },
    {
      "code" : "A032119212",
      "display" : "EUKACIN INJECTION 125MG/ML  \"U-LIANG\"(AMIKACIN)"
    },
    {
      "code" : "A032122255",
      "display" : "SATA INJECTION FOR INTRAVENOUS INFUSION 5MG/ML (TINIDAZOLE) \"S.T.\""
    },
    {
      "code" : "A032123100",
      "display" : "UTTA CAPSULES 200MG (DANAZOL) \"TAIWAN TUNG YUNG\""
    },
    {
      "code" : "A032124100",
      "display" : "C.A.P. CAPSULES"
    },
    {
      "code" : "A032125209",
      "display" : "PIXTIM INJECTION 20MG/ML (PIROXICAM) \"UNION\""
    },
    {
      "code" : "A032125212",
      "display" : "PIXTIM INJECTION 20MG/ML (PIROXICAM) \"UNION\""
    },
    {
      "code" : "A032135421",
      "display" : "TIMOLOL OPHTHALMIC SOLUTION 0.5％ \"WU-FU\""
    },
    {
      "code" : "A032136421",
      "display" : "TIMOLOL OPHTHALMIC SOLUTION 0.25％ \"WU-FU\""
    },
    {
      "code" : "A032137100",
      "display" : "TIDACT CAPSULES 150MG (CLINDAMYCIN)"
    },
    {
      "code" : "A032143329",
      "display" : "KETOPIN OINTMENT 30MG (KETOPROFEN)\"H.S.C.\""
    },
    {
      "code" : "A032150100",
      "display" : "ANTICOLD CAPSULE \"C.J.\""
    },
    {
      "code" : "A032153100",
      "display" : "VOLYER Capsules \"F.M.\"(LOPERAMIDE)"
    },
    {
      "code" : "A032154100",
      "display" : "NIFEDIPINE F.C. TABLETS 10MG \"CHINTENG\""
    },
    {
      "code" : "A032156335",
      "display" : "PIRON OINTMENT 5MG (PIROXICAM) \"H.S.C.\""
    },
    {
      "code" : "A032158177",
      "display" : "MUCOCIL GRANULES 40MG/GM (ACETYLCYSTEINE) \"SINPHAR\""
    },
    {
      "code" : "A032158199",
      "display" : "MUCOCIL GRANULES 40MG/GM (ACETYLCYSTEINE) \"SINPHAR\""
    },
    {
      "code" : "A032160100",
      "display" : "COMCERPINE TABLETS 0.25MG (RESERPINE) \"COMFORT\""
    },
    {
      "code" : "A032161100",
      "display" : "SOURIREE ENISOMNIA TABLETS 5MG"
    },
    {
      "code" : "A032162100",
      "display" : "SOURIREE COMTON TABLETS"
    },
    {
      "code" : "A032163100",
      "display" : "SOURIREE GLIBENCLAMIDE TABLETS 5MG"
    },
    {
      "code" : "A032164100",
      "display" : "SOURIREE COM-DIASTASE-P S.C. TABLET"
    },
    {
      "code" : "A032166100",
      "display" : "SOURIREE GLYCYRRHIZA AND OPIUM COMPOUND TABLETS"
    },
    {
      "code" : "A032169100",
      "display" : "HOSTACYCLINE CAPSULE 250MG (TETRACYCLINE HCL)"
    },
    {
      "code" : "A032170335",
      "display" : "ALLERCURE CREAM \"SHITEH\""
    },
    {
      "code" : "A032171221",
      "display" : "Agglutex Injection 1000U./ml (Heparin Sodium)"
    },
    {
      "code" : "A032171299",
      "display" : "Agglutex Injection 1000U./ml (Heparin Sodium)"
    },
    {
      "code" : "A032172221",
      "display" : "AGGLUTEX INJECTION 5000U./ML (HEPARIN SODIUM)"
    },
    {
      "code" : "A032172240",
      "display" : "AGGLUTEX INJECTION 5000U./ML (HEPARIN SODIUM)"
    },
    {
      "code" : "A032172248",
      "display" : "AGGLUTEX INJECTION 5000U./ML (HEPARIN SODIUM)"
    },
    {
      "code" : "A032172299",
      "display" : "AGGLUTEX INJECTION 5000U./ML (HEPARIN SODIUM)"
    },
    {
      "code" : "A032173329",
      "display" : "B&N TRIECO CREAM \"Shiteh\""
    },
    {
      "code" : "A032173338",
      "display" : "B&N TRIECO CREAM \"Shiteh\""
    },
    {
      "code" : "A032173372",
      "display" : "B&N TRIECO CREAM \"Shiteh\""
    },
    {
      "code" : "A032175329",
      "display" : "INDO CREAM 10MG/GM (INDOMETHACIN) \"H.S.\""
    },
    {
      "code" : "A032175340",
      "display" : "INDO CREAM 10MG/GM (INDOMETHACIN) \"H.S.\""
    },
    {
      "code" : "A032181329",
      "display" : "C.P.P. CREAM 500MCG/G \"SWISS\" (CLOBETASOL)"
    },
    {
      "code" : "A032181335",
      "display" : "C.P.P. CREAM 500MCG/G \"SWISS\" (CLOBETASOL)"
    },
    {
      "code" : "A032181399",
      "display" : "C.P.P. CREAM 500MCG/G \"SWISS\" (CLOBETASOL)"
    },
    {
      "code" : "A032182100",
      "display" : "DANAZOL CAPSULES 200MG \"SWISS\"(DANAZOL)"
    },
    {
      "code" : "A032208100",
      "display" : "EQUSIL GRANULES 20MG/GM (ACETYLCYSTEINE) \"LITA\""
    },
    {
      "code" : "A032208121",
      "display" : "EQUSIL GRANULES 20MG/GM (ACETYLCYSTEINE) \"LITA\""
    },
    {
      "code" : "A032210100",
      "display" : "PHENOBARBITAL TABLETS 10MG \"P.L.\""
    },
    {
      "code" : "A032217372",
      "display" : "SHIN-SHIN CREAM \"SWISS\" 0.5MG (BETAMETHASONE)"
    },
    {
      "code" : "A032217399",
      "display" : "SHIN-SHIN CREAM \"SWISS\" 0.5MG (BETAMETHASONE)"
    },
    {
      "code" : "A032221100",
      "display" : "BOLTAMIN TABLETS 25MG (DICLOFENAC)"
    },
    {
      "code" : "A032223151",
      "display" : "ACETAMINOPHEN LIQUID 12MG/ML (ACETAMINOPHEN) \"STANDARD\""
    },
    {
      "code" : "A032226100",
      "display" : "NALIDAN TABLETS 500MG (NALIDIXIC ACID)"
    },
    {
      "code" : "A032233100",
      "display" : "IFUSE S.C. TABLETS 5MG (METOCLOPRAMIDE)"
    },
    {
      "code" : "A032249100",
      "display" : "ANILENE TABLETS 2MG"
    },
    {
      "code" : "A032250100",
      "display" : "Supertidine F.C. Tablets 20mg"
    },
    {
      "code" : "A032251212",
      "display" : "AMIKACIN INJECTION 250MG/ML \"TAI YU\""
    },
    {
      "code" : "A032251229",
      "display" : "AMIKACIN INJECTION 250MG/ML \"TAI YU\""
    },
    {
      "code" : "A032256100",
      "display" : "WEIPIN TABLETS"
    },
    {
      "code" : "A032259500",
      "display" : "SUZOTON SUPPOSITORIES 25MG (DICLOFENAC) \"Y.C\""
    },
    {
      "code" : "A032260500",
      "display" : "SUZOTON SUPPOSITORIES 12.5MG (DICLOFENAC) \"Y.C\""
    },
    {
      "code" : "A032261100",
      "display" : "LOPER CAPSULES 2MG (LOPERAMIDE) \"H.S.\""
    },
    {
      "code" : "A032263212",
      "display" : "Gentamycin Injection 40mg/mL \"S.Y.\" (Gentamycin)"
    },
    {
      "code" : "A032263221",
      "display" : "Gentamycin Injection 40mg/mL \"S.Y.\" (Gentamycin)"
    },
    {
      "code" : "A032263229",
      "display" : "Gentamycin Injection 40mg/mL \"S.Y.\" (Gentamycin)"
    },
    {
      "code" : "A032263238",
      "display" : "Gentamycin Injection 40mg/mL \"S.Y.\" (Gentamycin)"
    },
    {
      "code" : "A032264309",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264321",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264324",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264329",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264335",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264338",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264372",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032264399",
      "display" : "CLOBETA CREAM 500MCG  \"S.Y.\"(CLOBETASOL 17-PROPIONATE)"
    },
    {
      "code" : "A032265100",
      "display" : "FLUNEPAN TABLET 2MG \"PANBIOTIC\" (FLUNITRAZEPAM)"
    },
    {
      "code" : "A032266100",
      "display" : "SUAROLOL TABLETS 100MG (ATENOLOL) \"Y.S.\""
    },
    {
      "code" : "A032267500",
      "display" : "CLOTRIMAZOLE VAG. TAB. (CLOTRIMAZOLE) \"PANBIOTIC\""
    },
    {
      "code" : "A032268100",
      "display" : "DOMPERIDONE 10MG TABLETS \"Y.S.\"(DOMPERIDONE)"
    },
    {
      "code" : "A032270100",
      "display" : "FOR-CHI OAINE TABLETS"
    },
    {
      "code" : "A032273100",
      "display" : "SHINGLUCON TABLETS"
    },
    {
      "code" : "A032275100",
      "display" : "CEPORIN TABLETS 25MG"
    },
    {
      "code" : "A032277100",
      "display" : "PEESU TABLETS \"KOJAR\""
    },
    {
      "code" : "A032278100",
      "display" : "CLOZENE CAPSULES 7.5MG \"WEIDAR\" (CLORAZEPATE)"
    },
    {
      "code" : "A032279500",
      "display" : "DICLOFENAC SUPPOSITORIES 50MG \"CHINTENG\""
    },
    {
      "code" : "A032280100",
      "display" : "FLAVOXE S.C. TABLETS 200MG (FLAVOXATE) \"EAYUNG\""
    },
    {
      "code" : "A032282421",
      "display" : "CHLORAMPHENICOL OPHTHALMIC SOLUTION 0.25％ \"SYNMOSA\""
    },
    {
      "code" : "A032282429",
      "display" : "CHLORAMPHENICOL OPHTHALMIC SOLUTION 0.25％ \"SYNMOSA\""
    },
    {
      "code" : "A032283429",
      "display" : "PILOCARPINE OPHTHALMIC SOLUTION 2％ \"SYNMOSA\""
    },
    {
      "code" : "A032283435",
      "display" : "PILOCARPINE OPHTHALMIC SOLUTION 2％ \"SYNMOSA\""
    },
    {
      "code" : "A032284429",
      "display" : "PILOCARPINE OPHTHALMIC SOLUTION 1％ \"Synmosa\""
    },
    {
      "code" : "A032284435",
      "display" : "PILOCARPINE OPHTHALMIC SOLUTION 1％ \"Synmosa\""
    },
    {
      "code" : "A032286100",
      "display" : "ANTIASTH SLOW RELEASE TABLETS 225MG (AMINOPHYLLINE)"
    },
    {
      "code" : "A032287100",
      "display" : "SENIDOL TAB. 25MG (DIPHENIDOL) \"PANBIOTIC\""
    },
    {
      "code" : "A032288309",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032288321",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032288329",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032288338",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032288372",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032288399",
      "display" : "FUTUSOA CREAM \"S.Y.\""
    },
    {
      "code" : "A032292100",
      "display" : "PANCOBAMIN CAPSULE 500MCG (MECOBALAMIN) \"PANBIOTIC\""
    },
    {
      "code" : "A032295100",
      "display" : "CEFADIN CAP 500MG \"STANDARD\"(CEPHRADINE)"
    },
    {
      "code" : "A032296100",
      "display" : "IMOMIDE CAPSULES 2MG (LOPERAMIDE)"
    },
    {
      "code" : "A032298100",
      "display" : "CLEMIN TABLETS 1MG (CLEMASTINE)"
    },
    {
      "code" : "A032299100",
      "display" : "CHLOXISIN TABLETS"
    },
    {
      "code" : "A032300100",
      "display" : "ZUQUENE CAPSULES 50MG (SULPIRIDE) \"T.C.Y\""
    },
    {
      "code" : "A032301100",
      "display" : "NITROFAN TABLET 100MG (NITROFURANTOIN)"
    },
    {
      "code" : "A032302100",
      "display" : "PAROMIDE TABLETS 40MG (FUROSEMIDE)"
    },
    {
      "code" : "A032304100",
      "display" : "PHYNADIN K TABLETS 10MG (PHYTONADION)"
    },
    {
      "code" : "A032309100",
      "display" : "SOCAINE TABLET"
    },
    {
      "code" : "A0323091G0",
      "display" : "SOCAINE TABLET"
    },
    {
      "code" : "A032310100",
      "display" : "MAGACID TABLET 200MG (MAGALDRATE) \"PURZER\""
    },
    {
      "code" : "A032311100",
      "display" : "DANALOL CAPSULE 200MG (DANAZOL) \"PURZER\""
    },
    {
      "code" : "A032312100",
      "display" : "PURFEN F.C. TABLET 400MG (IBUPROFEN) \"PURZER\""
    },
    {
      "code" : "A0323121G0",
      "display" : "PURFEN F.C. TABLET 400MG (IBUPROFEN) \"PURZER\""
    },
    {
      "code" : "A032313100",
      "display" : "REFEXIN CAPSULE 500MG (CEPHALEXIN) \"PURZER\""
    },
    {
      "code" : "A032314100",
      "display" : "DUOCER F.C TABLET 400MG (CIMETIDINE) \"PURZER\""
    },
    {
      "code" : "A0323141G0",
      "display" : "DUOCER F.C TABLET 400MG (CIMETIDINE) \"PURZER\""
    },
    {
      "code" : "A032315100",
      "display" : "DUOCER F.C TABLET 200MG (CIMETIDINE) \"PURZER\""
    },
    {
      "code" : "A0323151G0",
      "display" : "DUOCER F.C TABLET 200MG (CIMETIDINE) \"PURZER\""
    },
    {
      "code" : "A032316209",
      "display" : "ASDOL FOR INJECTION 1GM (CEFAMANDOL) \"PURZER\""
    },
    {
      "code" : "A032316277",
      "display" : "ASDOL FOR INJECTION 1GM (CEFAMANDOL) \"PURZER\""
    },
    {
      "code" : "A032317209",
      "display" : "SEZOLIN FOR INJECTION (CEFAZOLIN) \"PURZER\""
    },
    {
      "code" : "A032317277",
      "display" : "SEZOLIN FOR INJECTION (CEFAZOLIN) \"PURZER\""
    },
    {
      "code" : "A032318229",
      "display" : "RELIN INJECTION 300MG/ML (LINCOMYCIN) \"PURZER\""
    },
    {
      "code" : "A032319321",
      "display" : "GENTADERM CREAM"
    },
    {
      "code" : "A032320100",
      "display" : "ACETAL TABLET 500MG (ACETAMINOPHEN) \"PURZER\""
    },
    {
      "code" : "A0323201G0",
      "display" : "ACETAL TABLET 500MG (ACETAMINOPHEN) \"PURZER\""
    },
    {
      "code" : "A032322100",
      "display" : "TENOLOL F.C TABLET 100MG (ATENOLOL) \"PURZER\""
    },
    {
      "code" : "A032323114",
      "display" : "ACTEIN GRANULES 40MG/GM"
    },
    {
      "code" : "A032323121",
      "display" : "ACTEIN GRANULES 40MG/GM"
    },
    {
      "code" : "A032323177",
      "display" : "ACTEIN GRANULES 40MG/GM"
    },
    {
      "code" : "A032324100",
      "display" : "RECEF CAPSULE 500MG (CEPHRADINE) \"PURZER\""
    },
    {
      "code" : "A032325321",
      "display" : "METHACIN GEL 10 MG/G \"PURZER\" (INDOMETHACIN)"
    },
    {
      "code" : "A032325325",
      "display" : "METHACIN GEL 10 MG/G \"PURZER\" (INDOMETHACIN)"
    },
    {
      "code" : "A032325329",
      "display" : "METHACIN GEL 10 MG/G \"PURZER\" (INDOMETHACIN)"
    },
    {
      "code" : "A032325335",
      "display" : "METHACIN GEL 10 MG/G \"PURZER\" (INDOMETHACIN)"
    },
    {
      "code" : "A032325338",
      "display" : "METHACIN GEL 10 MG/G \"PURZER\" (INDOMETHACIN)"
    },
    {
      "code" : "A032327100",
      "display" : "LONINE CAPSULES 200MG (ETODOLAC)"
    },
    {
      "code" : "A032331100",
      "display" : "COSSONIL COUGH TABLETS \"DR. WALLMUELLER'S\""
    },
    {
      "code" : "A032332100",
      "display" : "TIARAM TABLETS 100MG (TIARAMIDE) \"H.H.\""
    },
    {
      "code" : "A032333100",
      "display" : "Panacon Cold Capsules"
    },
    {
      "code" : "A032334209",
      "display" : "RECEF-A FOR INJECTION 1000MG (CEPHRADINE)"
    },
    {
      "code" : "A032334277",
      "display" : "RECEF-A FOR INJECTION 1000MG (CEPHRADINE)"
    },
    {
      "code" : "A032335100",
      "display" : "GASTER 10 S.C. TABLETS (FAMOTIDINE)"
    },
    {
      "code" : "A032336100",
      "display" : "HOMOMIN TABLETS 10MG \"Y.Y.\"(HOMOCHLORCYCLIZINE)"
    },
    {
      "code" : "A0323361G0",
      "display" : "HOMOMIN TABLETS 10MG \"Y.Y.\"(HOMOCHLORCYCLIZINE)"
    },
    {
      "code" : "A032338337",
      "display" : "JELINDO OINTMENT 10MG/GM (INDOMETHACIN)"
    },
    {
      "code" : "A032340100",
      "display" : "NIXO TABLETS 5MG (NICERGOLINE) \"H.H.\""
    },
    {
      "code" : "A032343265",
      "display" : "ZINACEF FOR INJECTION 250MG (CEFUROXIME)"
    },
    {
      "code" : "A032343289",
      "display" : "ZINACEF FOR INJECTION 250MG (CEFUROXIME)"
    },
    {
      "code" : "A032344277",
      "display" : "FORTUM FOR INJECTION 500MG (CEFTAZIDIME)"
    },
    {
      "code" : "A032349209",
      "display" : "FORTUM FOR INJECTION 1GM (CEFTAZIDIME)"
    },
    {
      "code" : "A032349212",
      "display" : "FORTUM FOR INJECTION 1GM (CEFTAZIDIME)"
    },
    {
      "code" : "A032350221",
      "display" : "TRANDATE INJECTION 5MG/ML (LABETALOL)"
    },
    {
      "code" : "A032352100",
      "display" : "PHENYTOIN TABLETS 20MG \"PL\""
    },
    {
      "code" : "A032353100",
      "display" : "NICAN F.C. TABLETS 50MG (NICAMETATE) \"CHIN TENG\""
    },
    {
      "code" : "A0323531G0",
      "display" : "NICAN F.C. TABLETS 50MG (NICAMETATE) \"CHIN TENG\""
    },
    {
      "code" : "A032355100",
      "display" : "TERFENADINE TABLETS 60MG \"CHIN TENG\""
    },
    {
      "code" : "A032356212",
      "display" : "ZANTAC INJECTION 25MG/ML (RANITIDINE)"
    },
    {
      "code" : "A032357289",
      "display" : "ZINACEF FOR INJECTION 750MG (CEFUROXIME)"
    },
    {
      "code" : "A032358100",
      "display" : "DOMPER TABLETS 10MG (DOMPERIDONE)"
    },
    {
      "code" : "A032361100",
      "display" : "UROL TABLETS 200MG (FLAVOXATE) \"H.H\""
    },
    {
      "code" : "A032363100",
      "display" : "COPU TABLETS 50MG \"WINSTON\" (CARBENOXOLONE)"
    },
    {
      "code" : "A032364100",
      "display" : "BEMIDON F.C. TALBETS 50MG (TIARAMIDE) \"KOJAR\""
    },
    {
      "code" : "A032367100",
      "display" : "WEICHILIN TABLETS 150MG"
    },
    {
      "code" : "A032368100",
      "display" : "KETOTI TABLETS 1MG (KETOTIFEN) \"YUNG CHI\""
    },
    {
      "code" : "A032369209",
      "display" : "MECOBAL INJECTION 500MCG/ML (MECOBALAMIN) \"Gentle\""
    },
    {
      "code" : "A032369212",
      "display" : "MECOBAL INJECTION 500MCG/ML (MECOBALAMIN) \"Gentle\""
    },
    {
      "code" : "A032371100",
      "display" : "TRANLEN TABLETS 1MG (KETOTIFEN) \"M.S.\""
    },
    {
      "code" : "A032372100",
      "display" : "CONSLIFE SUGAR COATED TABLETS"
    },
    {
      "code" : "A0323721G0",
      "display" : "CONSLIFE SUGAR COATED TABLETS"
    },
    {
      "code" : "A032373100",
      "display" : "QUICRAN F.C.TABLETS 150MG (RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A032375100",
      "display" : "MEFENAL TABLET 250MG (MEFENAMIC ACID)"
    },
    {
      "code" : "A032376329",
      "display" : "NISOLON GEL 50MG/G (ETOFENAMATE)"
    },
    {
      "code" : "A032378500",
      "display" : "FEMSTAT VAGINAL SUPPOSITORY"
    },
    {
      "code" : "A032379238",
      "display" : "WATER FOR INJECTION \"TBC\""
    },
    {
      "code" : "A032380100",
      "display" : "TERLAM CAPSULES 10MG"
    },
    {
      "code" : "A032381238",
      "display" : "DOBUTREX INJECTION 12.5MG/ML (DOBUTAMINE)"
    },
    {
      "code" : "A032382174",
      "display" : "CO-PYRONIL 2 LIQUID"
    },
    {
      "code" : "A032383100",
      "display" : "PELIDONE TABLET 10MG (DOMPERIDONE) \"Chen Ta\""
    },
    {
      "code" : "A032389100",
      "display" : "ANTICOUGH CAPSULE"
    },
    {
      "code" : "A032390100",
      "display" : "Conclomin Tablet 10mg(Homochlorcyclizine)\"M.D.\""
    },
    {
      "code" : "A032413100",
      "display" : "MEFEN F.C TABLETS 500MG (MEFENAMIC ACID) \"CHINTENG\""
    },
    {
      "code" : "A0324131G0",
      "display" : "MEFEN F.C TABLETS 500MG (MEFENAMIC ACID) \"CHINTENG\""
    },
    {
      "code" : "A032414100",
      "display" : "TANBITIN TABLET 60MG (IODOPROPYLIDENE GLYCEROL) \"YUNG SINE\""
    },
    {
      "code" : "A032416209",
      "display" : "PIROCAM INJECTION 20MG/ML (PIROXICAM)"
    },
    {
      "code" : "A032419329",
      "display" : "Sinbeta derm cream"
    },
    {
      "code" : "A032427100",
      "display" : "TANDATE F.C. TABLETS 100MG (ATENOLOL)"
    },
    {
      "code" : "A032437100",
      "display" : "NORMABRAIN F.C. TABLETS 800MG (PIRACETAM)"
    },
    {
      "code" : "A032438100",
      "display" : "NORMABRAIN CAPSULES 400MG (PIRACETAM)"
    },
    {
      "code" : "A032439151",
      "display" : "FANTA PLUS SUSPENSION"
    },
    {
      "code" : "A032442100",
      "display" : "NILACHE CAPSULES 250MG (MEFENAMIC ACID) \"KUAI KUAI\""
    },
    {
      "code" : "A032443118",
      "display" : "SOVACOD LIQUID 0.8MG/ML (BUTAMIRATE CITRATE) \"KUAI KUAI\""
    },
    {
      "code" : "A032443199",
      "display" : "SOVACOD LIQUID 0.8MG/ML (BUTAMIRATE CITRATE) \"KUAI KUAI\""
    },
    {
      "code" : "A032449100",
      "display" : "TRANMIN F.C. TABLETS 100MG (LABETALOL)"
    },
    {
      "code" : "A032450100",
      "display" : "NILACHE F.C. TABLETS 500MG (MEFENAMIC ACID) \"KUAI KUAI\""
    },
    {
      "code" : "A032458118",
      "display" : "COKE SOLUTION"
    },
    {
      "code" : "A032458199",
      "display" : "COKE SOLUTION"
    },
    {
      "code" : "A032460100",
      "display" : "CINHO TABLETS 2MG (FLUNITRAZEPAM)"
    },
    {
      "code" : "A032463100",
      "display" : "GROOVY CAPSULES 375MG(CARBOCYSTEINE)"
    },
    {
      "code" : "A032464100",
      "display" : "NILGRAINE S.C. TABLETS 100MG (PROXIBARBAL)"
    },
    {
      "code" : "A032465100",
      "display" : "MASONY TABLETS 30MG (AMBROXOL)"
    },
    {
      "code" : "A032466100",
      "display" : "HERZEN F.C. TABLETS, 30MG (DILTIAZEM)"
    },
    {
      "code" : "A032468355",
      "display" : "I.S.A. SPIRIT"
    },
    {
      "code" : "A032469100",
      "display" : "LONGIAN TABLETS 25MG (BUCLIZINE)"
    },
    {
      "code" : "A032472100",
      "display" : "INDOMECIN CAPSULES 25MG (INDOMETHACIN)"
    },
    {
      "code" : "A032474100",
      "display" : "SAPIA TABLETS"
    },
    {
      "code" : "A032475100",
      "display" : "CARBEDANE S.C. TABLETS 25MG (CARBETAPENTANE)"
    },
    {
      "code" : "A032476126",
      "display" : "SUKIT SUSPENSION"
    },
    {
      "code" : "A032476129",
      "display" : "SUKIT SUSPENSION"
    },
    {
      "code" : "A032477100",
      "display" : "TRANMIN F.C. TABLETS 200MG (LABETALOL)"
    },
    {
      "code" : "A032479100",
      "display" : "RESURGE CAPSULES 200MG (TEGAFUR)"
    },
    {
      "code" : "A032480355",
      "display" : "P.Z.L. LOTION"
    },
    {
      "code" : "A032483355",
      "display" : "M.Z.L. LOTION 80MG/ML (ZINC OXIDE)"
    },
    {
      "code" : "A032485355",
      "display" : "CALAMINE LOTION"
    },
    {
      "code" : "A032487166",
      "display" : "FANTAR T SUSPENSION"
    },
    {
      "code" : "A032488100",
      "display" : "SEZEAM CAPSULES 10MG (OXAZOLAM) \"S.L.\""
    },
    {
      "code" : "A032489100",
      "display" : "TENOLIN TABLETS 100MG (ATENOLOL) \"S.L.\""
    },
    {
      "code" : "A032490100",
      "display" : "WYEANIN F.C. TABLETS 10MG (DOMPERIDONE) \"S.L.\""
    },
    {
      "code" : "A032492100",
      "display" : "TOMIN TABLETS 2MG (DEXCHLORPHENIRAMINE) \"KOJAR\""
    },
    {
      "code" : "A032493100",
      "display" : "L.A TABLETS"
    },
    {
      "code" : "A032494100",
      "display" : "FLUBEN S.C. TABLETS 40MG (FLURBIPROFEN) \"EAYUNG\""
    },
    {
      "code" : "A032495100",
      "display" : "COWBALIN TABLETS 100MG (MEBENDAZOLE) \"KOJAR\""
    },
    {
      "code" : "A0324951G0",
      "display" : "COWBALIN TABLETS 100MG (MEBENDAZOLE) \"KOJAR\""
    },
    {
      "code" : "A032496100",
      "display" : "ALDIN F.C. TABLETS 250MG (METHYLDOPA) \"KOJAR\""
    },
    {
      "code" : "A032498277",
      "display" : "AMINOPOLY-N INJECTION"
    },
    {
      "code" : "A032499100",
      "display" : "SINWELL TABLETS \"KOJAR\""
    },
    {
      "code" : "A032500100",
      "display" : "DEBRONC TABLETS 50MG \"LITA\""
    },
    {
      "code" : "A032504100",
      "display" : "ANTADINE CAPSULES 100MG (AMANTADINE) \"S.L.\""
    },
    {
      "code" : "A032505372",
      "display" : "SHIN-SHIN OINTMENT. 500MCG/GM \"SWISS\"(BETAMETHASONE)"
    },
    {
      "code" : "A032505399",
      "display" : "SHIN-SHIN OINTMENT. 500MCG/GM \"SWISS\"(BETAMETHASONE)"
    },
    {
      "code" : "A032506100",
      "display" : "PIPETO F.C. TAB. 10MG \"STANDARD\" (PIPERILATE ETHOBROMIDE)"
    },
    {
      "code" : "A032514421",
      "display" : "TOBEYESON OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A032514423",
      "display" : "TOBEYESON OPHTHALMIC SOLUTION"
    },
    {
      "code" : "A032516100",
      "display" : "FANTA TABLETS 400MG"
    },
    {
      "code" : "A032517329",
      "display" : "ACNE H OINTMENT"
    },
    {
      "code" : "A032520118",
      "display" : "FANTA SUSPENSION"
    },
    {
      "code" : "A032520138",
      "display" : "FANTA SUSPENSION"
    },
    {
      "code" : "A032520177",
      "display" : "FANTA SUSPENSION"
    },
    {
      "code" : "A032520199",
      "display" : "FANTA SUSPENSION"
    },
    {
      "code" : "A032524100",
      "display" : "MOKOTAM TABLETS 30MG \"Y.S.\" (AMBROXOL)"
    },
    {
      "code" : "A032526100",
      "display" : "NUNMINE TABLETS 60MG (TERFENADINE) \"YUNG SHIN\""
    },
    {
      "code" : "A032527100",
      "display" : "ANDERIN TABLETS"
    },
    {
      "code" : "A032528151",
      "display" : "TRIMERIN SYRUP"
    },
    {
      "code" : "A032528177",
      "display" : "TRIMERIN SYRUP"
    },
    {
      "code" : "A032528199",
      "display" : "TRIMERIN SYRUP"
    },
    {
      "code" : "A032530100",
      "display" : "SOLANTIN S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A0325301G0",
      "display" : "SOLANTIN S.C. TABLETS 25MG (DIPYRIDAMOLE)"
    },
    {
      "code" : "A032531100",
      "display" : "HYDERTOSIN TABLETS 1.5MG (DIHYDROERGOTOXINE MESYLATE)"
    },
    {
      "code" : "A032535100",
      "display" : "TRIMERIN TABLETS"
    },
    {
      "code" : "A032549209",
      "display" : "STAZOLIN INJ. \"STANDARD\" (CEFAZOLIN)"
    },
    {
      "code" : "A032549277",
      "display" : "STAZOLIN INJ. \"STANDARD\" (CEFAZOLIN)"
    },
    {
      "code" : "A032561100",
      "display" : "Urinol Tablets 200mg \"Royal\" (Flavoxate)"
    },
    {
      "code" : "A032562309",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562319",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562321",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562324",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562329",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562338",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562340",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562372",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032562399",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A0325623B9",
      "display" : "CLEOSOL CREAM 0.5MG/GM (CLOBETASOL) \"GCPC\""
    },
    {
      "code" : "A032563100",
      "display" : "URAGEM CAPSULES 300MG (GEMFIBROZIL) \"U-LIANG\""
    },
    {
      "code" : "A0325631G0",
      "display" : "URAGEM CAPSULES 300MG (GEMFIBROZIL) \"U-LIANG\""
    },
    {
      "code" : "A032568338",
      "display" : "RETIN-A CREAM 0.5MG/GM (TRETINOIN)"
    },
    {
      "code" : "A032569100",
      "display" : "HALDOL TABLET 10MG (HALOPERIDOL)"
    },
    {
      "code" : "A032570138",
      "display" : "WILLWIN GEL 130MG/GM \"SINPHAR\" (ALUMINUM PHOSPHATE)"
    },
    {
      "code" : "A032571338",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571343",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571351",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571363",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571371",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571372",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571377",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032571399",
      "display" : "\"SINPHAR\" SILIVERZINE CREAM 10MG/GM（SULFADIAZINE SILVER）"
    },
    {
      "code" : "A032572100",
      "display" : "SACLONAL TABLETS 10MG (HOMOCHLORCYCLIZINE) \"P.J.\""
    },
    {
      "code" : "A032573100",
      "display" : "MERANOM S.C. TABLETS 25MG (DIPHENIDOL) \"P.J.\""
    },
    {
      "code" : "A032574335",
      "display" : "PROPADERM CREAM 0.25MG/GM (BECLOMETHASONE)"
    },
    {
      "code" : "A032576216",
      "display" : "PAINSTOP INJECTION 25MG/ML (DICLOFENAC)"
    },
    {
      "code" : "A032579100",
      "display" : "DEBLEEDING CAPSULES 250MG \"C.L.\""
    },
    {
      "code" : "A032583100",
      "display" : "ANTICOLD CAPSULES \"KOJAR\""
    },
    {
      "code" : "A032584100",
      "display" : "BININ-U TABLETS 5MG (HALOPERIDOL)"
    },
    {
      "code" : "A032586338",
      "display" : "RETIN-A CREAM 0.25MG/GM (TRETINOIN)"
    },
    {
      "code" : "A032590100",
      "display" : "WEYFULEN TABLET 25MG (PIRENZEPINE) \"T.C.Y.\""
    },
    {
      "code" : "A032594100",
      "display" : "ATROPINE TABLET 0.5MG \"T.C.Y.\""
    },
    {
      "code" : "A032597100",
      "display" : "DIAZEAM TABLETS 5MG (DIAZEPAM) \"T.C.Y.\""
    },
    {
      "code" : "A032600100",
      "display" : "DANNETHOL S.C. TABLETS 12.5MG (ANETHOLE) \"T.C.Y.\""
    },
    {
      "code" : "A032601329",
      "display" : "MYCOCIN CREAM"
    },
    {
      "code" : "A032601335",
      "display" : "MYCOCIN CREAM"
    },
    {
      "code" : "A032601372",
      "display" : "MYCOCIN CREAM"
    },
    {
      "code" : "A032601399",
      "display" : "MYCOCIN CREAM"
    },
    {
      "code" : "A032608229",
      "display" : "LINCOMYCIN INJ. 300MG/ML \"TAIWAN TUNG YANG\""
    },
    {
      "code" : "A032609100",
      "display" : "DICLOFENAC SODIUM ENTERIC S.C. TABLETS 25MG \"SYNMOSA\""
    },
    {
      "code" : "A032610212",
      "display" : "DOMPERAN INJECTION 5MG/ML (DOMPERIDONE)"
    },
    {
      "code" : "A032611100",
      "display" : "PREPULSID TABLET 5MG (CISAPRIDE)"
    },
    {
      "code" : "A032612100",
      "display" : "DELTA-CORTEF TABLETS 5MG (PREDNISOLONE)"
    },
    {
      "code" : "A032617100",
      "display" : "CANCIDIN FILM COATING TABLET 500MG (TINIDAZOLE) \"B&F\""
    },
    {
      "code" : "A032618100",
      "display" : "DIUMIDE-S TABLETS \"P.J.\""
    },
    {
      "code" : "A032619100",
      "display" : "NIDOLIUM TABLETS 10MG \"SINPHAR\"(DOMPERIDONE)"
    },
    {
      "code" : "A0326191G0",
      "display" : "NIDOLIUM TABLETS 10MG \"SINPHAR\"(DOMPERIDONE)"
    },
    {
      "code" : "A032620248",
      "display" : "LEUCOVORIN CALCIUM INJECTION 50MG"
    },
    {
      "code" : "A032623100",
      "display" : "BADIPINE CAPSULES 10MG \"T.F.\" (NIFEDIPINE)"
    },
    {
      "code" : "A032624212",
      "display" : "EUDAMYCIN INJECTION 150MG/ML (CLINDAMYCIN) \"U-LIANG\""
    },
    {
      "code" : "A032624219",
      "display" : "EUDAMYCIN INJECTION 150MG/ML (CLINDAMYCIN) \"U-LIANG\""
    },
    {
      "code" : "A032625151",
      "display" : "COSILY LIQUID 650MG/ML (LACTULOSE) \"MEIDER\""
    },
    {
      "code" : "A032625157",
      "display" : "COSILY LIQUID 650MG/ML (LACTULOSE) \"MEIDER\""
    },
    {
      "code" : "A032625166",
      "display" : "COSILY LIQUID 650MG/ML (LACTULOSE) \"MEIDER\""
    },
    {
      "code" : "A032625177",
      "display" : "COSILY LIQUID 650MG/ML (LACTULOSE) \"MEIDER\""
    },
    {
      "code" : "A032625199",
      "display" : "COSILY LIQUID 650MG/ML (LACTULOSE) \"MEIDER\""
    },
    {
      "code" : "A032631100",
      "display" : "CIMETIDINE TABLETS 400MG \"R.T.\""
    },
    {
      "code" : "A0326311G0",
      "display" : "CIMETIDINE TABLETS 400MG \"R.T.\""
    },
    {
      "code" : "A032632100",
      "display" : "SPINAX TABLETS 10.0MG \"HEMONY\" (BACLOFEN)"
    },
    {
      "code" : "A0326321G0",
      "display" : "SPINAX TABLETS 10.0MG \"HEMONY\" (BACLOFEN)"
    },
    {
      "code" : "A032634338",
      "display" : "TONDONAC GEL 10MG/GM (DICLOFENAC SODIUM)"
    },
    {
      "code" : "A032638500",
      "display" : "DICLOFENAC SUPPOSITORIES 12.5MG \"CHINTENG\""
    },
    {
      "code" : "A032640212",
      "display" : "TIDACT INJECTION 150MG/ML (CLINDAMYCIN)"
    },
    {
      "code" : "A032641100",
      "display" : "GUERTON TABLETS 250MG (DIFLUNISAL)"
    },
    {
      "code" : "A032642100",
      "display" : "GIKO FILM-COATED TABLETS 9.6MG (GINKGOFLAVONGLYCOSIDES)\"H.S.\""
    },
    {
      "code" : "A032643100",
      "display" : "DIFLUCAN CAPSULE 150MG (FLUCONAZOLE)"
    },
    {
      "code" : "A032644100",
      "display" : "DIFLUCAN CAPSULE 50MG (FLUCONAZOLE)"
    },
    {
      "code" : "A032648100",
      "display" : "VESYCA FILM COATED TABLETS 150MG (RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A032649100",
      "display" : "SWEGA TABLETS 400MG (CIMETIDINE) \"H.S.\""
    },
    {
      "code" : "A0326491G0",
      "display" : "SWEGA TABLETS 400MG (CIMETIDINE) \"H.S.\""
    },
    {
      "code" : "A032650118",
      "display" : "HOSGEL SUSPENSION \"YU SHENG\""
    },
    {
      "code" : "A032650199",
      "display" : "HOSGEL SUSPENSION \"YU SHENG\""
    },
    {
      "code" : "A032651100",
      "display" : "KETIFEN TABLETS 1MG (KETOTIFEN) \"H.S.\""
    },
    {
      "code" : "A032652100",
      "display" : "TENADINE TABLETS 60MG (TERFENADINE) \"Y.S.\""
    },
    {
      "code" : "A032653100",
      "display" : "TERFEMINE TABLETS 60MG (TERFENADINE) \"H.H.\""
    },
    {
      "code" : "A032679100",
      "display" : "TINSET TABLET 30MG (OXATOMIDE)"
    },
    {
      "code" : "A032680100",
      "display" : "DIANE 35 S.C. TABLET"
    },
    {
      "code" : "A032681100",
      "display" : "DANTASE E.C. TABLETS 5MG \"Y.S.\"(SERRATIOPEPTIDASE)"
    },
    {
      "code" : "A032684321",
      "display" : "Winsolve VIRLESS Cream"
    },
    {
      "code" : "A032684343",
      "display" : "Winsolve VIRLESS Cream"
    },
    {
      "code" : "A032684399",
      "display" : "Winsolve VIRLESS Cream"
    },
    {
      "code" : "A032695212",
      "display" : "CIKETIN INJ. 150MG/ML (CIMETIDINE) \"UNION\""
    },
    {
      "code" : "A032702100",
      "display" : "BIPERIDEN TABLET 2MG \"K.Y.\""
    },
    {
      "code" : "A032704221",
      "display" : "DOPAMIN INJECTION 40MG/ML \"VPC\""
    },
    {
      "code" : "A032705221",
      "display" : "DOPAMIN INJECTION 10MG/ML (DOPAMINE) \"VPP\""
    },
    {
      "code" : "A032706100",
      "display" : "CAPTOPRI TABLETS 25MG (CAPTOPRIL)"
    },
    {
      "code" : "A032710100",
      "display" : "MECON TABLETS 30MG (DEXTROMETHORPHAN) \"H.S.\""
    },
    {
      "code" : "A032711100",
      "display" : "CAPTOPRI TABLETS 12.5MG (CAPTOPRIL)"
    },
    {
      "code" : "A032712100",
      "display" : "ENDASE E.C. TABLETS 10MG (SERRATIOPEPTIDASE) \"N.K.\""
    },
    {
      "code" : "A032714435",
      "display" : "DAR-LING EYE DROPS"
    },
    {
      "code" : "A032715221",
      "display" : "SODIUM CHLORIDE INJECTION 200MG/ML \"U-LIANG\""
    },
    {
      "code" : "A032715229",
      "display" : "SODIUM CHLORIDE INJECTION 200MG/ML \"U-LIANG\""
    },
    {
      "code" : "A032715238",
      "display" : "SODIUM CHLORIDE INJECTION 200MG/ML \"U-LIANG\""
    },
    {
      "code" : "A032716100",
      "display" : "DOMPERAN TABLETS 10MG \"SWISS\"(DOMPERIDONE)"
    },
    {
      "code" : "A0327161G0",
      "display" : "DOMPERAN TABLETS 10MG \"SWISS\"(DOMPERIDONE)"
    },
    {
      "code" : "A032722177",
      "display" : "YIAUKE GRANULES 100MG/GM  \"T.F.\""
    },
    {
      "code" : "A032723100",
      "display" : "PAPIROR E.C. TABLETS 100MG (PENTOXYFYLLINE) \"KYORIN\""
    },
    {
      "code" : "A032724100",
      "display" : "JEFRON S.C. TABLETS 25MG (DIPHENIDOL) \"KLORIN\""
    },
    {
      "code" : "A032729100",
      "display" : "SHERY E.C. TABLETS 100MG (PENTOXIFYLLINE) \"H.S.\""
    },
    {
      "code" : "A0327291G0",
      "display" : "SHERY E.C. TABLETS 100MG (PENTOXIFYLLINE) \"H.S.\""
    },
    {
      "code" : "A032733100",
      "display" : "SURGEM TABLETS 200MG (TIAPROFENIC ACID)"
    },
    {
      "code" : "A032736238",
      "display" : "WILCON LYO-INJECTION 20MG (FAMOTIDINE) \"UNION\""
    },
    {
      "code" : "A032737118",
      "display" : "TECOSIN SOLUTION"
    },
    {
      "code" : "A032737199",
      "display" : "TECOSIN SOLUTION"
    },
    {
      "code" : "A032739162",
      "display" : "SALI LUBE SALIVA SUBSTITUTE \"SINPHAR\""
    },
    {
      "code" : "A032743335",
      "display" : "NEO-TONFONRIN GEL 10MG/G (INDOMETHACIN) \"SWISS\""
    },
    {
      "code" : "A032745100",
      "display" : "DEPAIN X CAPSULES 65MG (PROPOXYPHEN) \"B&F\""
    },
    {
      "code" : "A032760114",
      "display" : "ACETYLEINE GRANULES 40MG/GM \"H.S.\""
    },
    {
      "code" : "A032760155",
      "display" : "ACETYLEINE GRANULES 40MG/GM \"H.S.\""
    },
    {
      "code" : "A032761100",
      "display" : "MINOCYCLINE CAPSULE 100MG \"PANBIOTIC\""
    },
    {
      "code" : "A032770100",
      "display" : "ANTERIN E.F.C TABLETS 50MG (DICLOFENAC SODIUM) \"F.S\""
    },
    {
      "code" : "A032772100",
      "display" : "MUCOXOL TABLETS. 30MG (AMBROXOL) \"H.S.C.\""
    },
    {
      "code" : "A032774100",
      "display" : "SUWEL TABLETS 500MG (SUCRALFATE)"
    },
    {
      "code" : "A032783100",
      "display" : "PEDERCON TABLETS 200MG (FLAVOXATE) \"YUNG CHI\""
    },
    {
      "code" : "A032785321",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032785329",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032785355",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032785365",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032785377",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032785399",
      "display" : "U-Chu Acyclovir Cream 50 mg/gm"
    },
    {
      "code" : "A032786100",
      "display" : "SIMEGEL CHEWABLE TABLET"
    },
    {
      "code" : "A032789221",
      "display" : "UTIDINE INJECTION 10MG/ML (RANITIDINE) \"U-LIANG\""
    },
    {
      "code" : "A032792229",
      "display" : "Dopamin (Dopamine) Injection 20 mg/mL \"VPP\""
    },
    {
      "code" : "A032800500",
      "display" : "Dicloren Suppositories 12.5mg \"Weidar\""
    },
    {
      "code" : "A032801100",
      "display" : "ALAT CAPSULES 10MG (NIFEDIPINE)"
    },
    {
      "code" : "A032803100",
      "display" : "SLEEPING-DEPOT 0.25MG (TRIAZOLAM) \"JINUP\""
    },
    {
      "code" : "A032804100",
      "display" : "HARWELL CAPSULE 10MG (NIFEDIPINE) \"JINUP\""
    },
    {
      "code" : "A032805100",
      "display" : "BUTANIDE TABLET 1MG (BUMETANIDE) \"Lita\""
    },
    {
      "code" : "A032807238",
      "display" : "SODIUM ACETATE INJECTION 2MEQ/ML \"U-LIANG\""
    },
    {
      "code" : "A032808100",
      "display" : "JITA TABLET 500MG (TINIDAZOLE) \"YUNG SINE\""
    },
    {
      "code" : "A032809500",
      "display" : "NOTAREN SUPPOSITORIED 25MG \"PATRON\" (DICLOFENAC)"
    },
    {
      "code" : "A032811100",
      "display" : "VERAPAM S.C. TABLETS 40MG (VERAPAMIL) \"AND\""
    },
    {
      "code" : "A032812338",
      "display" : "Clomold Cream 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A032812372",
      "display" : "Clomold Cream 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A032812399",
      "display" : "Clomold Cream 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A032813100",
      "display" : "SHITONS TABLETS 500MG \"G.T.\" (NAPROXEN)"
    },
    {
      "code" : "A032814100",
      "display" : "MERO TABLETS 30MG"
    },
    {
      "code" : "A032815100",
      "display" : "DEPRESS TABLETS \"CHINTENG\""
    },
    {
      "code" : "A032816100",
      "display" : "NASCO TABLETS \"H.S.\""
    },
    {
      "code" : "A0328161G0",
      "display" : "NASCO TABLETS \"H.S.\""
    },
    {
      "code" : "A032821100",
      "display" : "EULICHAN S.C. TABLET 50MG \"YUNG SINE\""
    },
    {
      "code" : "A032825100",
      "display" : "MENTONG TABLETS \"CHINTENG\""
    },
    {
      "code" : "A032826338",
      "display" : "LAIFU CREAM 30MG/GM \"Y.K.\" (NIFLUMIC ACID)"
    },
    {
      "code" : "A032826343",
      "display" : "LAIFU CREAM 30MG/GM \"Y.K.\" (NIFLUMIC ACID)"
    },
    {
      "code" : "A032828338",
      "display" : "SIGEL CREAM 10MG/G \"C.H.\" (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A032828377",
      "display" : "SIGEL CREAM 10MG/G \"C.H.\" (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A032828399",
      "display" : "SIGEL CREAM 10MG/G \"C.H.\" (SILVER SULFADIAZINE)"
    },
    {
      "code" : "A032829209",
      "display" : "NAFATHIN INJ. 1000MG (CEPHALOTHIN) \"N.K.\""
    },
    {
      "code" : "A032830100",
      "display" : "BETAPID TABLET 200MG (BEZAFIBRATE)"
    },
    {
      "code" : "A032831100",
      "display" : "DESUMIDE TABLETS 100MG (TOLAZAMIDE) \"H.S.\""
    },
    {
      "code" : "A032833100",
      "display" : "GEMD CAPSULES 300MG (GEMFIBROZIL) \"YUNG SHIN\""
    },
    {
      "code" : "A032834100",
      "display" : "MOLIN TABLETS 10MG \"T.F.\"(DOMPERIDONE)"
    },
    {
      "code" : "A032837255",
      "display" : "DEXTROSE INJECTION 0.5G/ML \"OTSUKA\""
    },
    {
      "code" : "A032837265",
      "display" : "DEXTROSE INJECTION 0.5G/ML \"OTSUKA\""
    },
    {
      "code" : "A032837277",
      "display" : "DEXTROSE INJECTION 0.5G/ML \"OTSUKA\""
    },
    {
      "code" : "A032846100",
      "display" : "ATENON F.C. TAB. 100MG (ATENOLOL) \"WINSTON\""
    },
    {
      "code" : "A032848324",
      "display" : "DERMOSOL CREAM 0.5MG/G \"PATRON\" (CLOBETASOL)"
    },
    {
      "code" : "A032848329",
      "display" : "DERMOSOL CREAM 0.5MG/G \"PATRON\" (CLOBETASOL)"
    },
    {
      "code" : "A032848335",
      "display" : "DERMOSOL CREAM 0.5MG/G \"PATRON\" (CLOBETASOL)"
    },
    {
      "code" : "A032848338",
      "display" : "DERMOSOL CREAM 0.5MG/G \"PATRON\" (CLOBETASOL)"
    },
    {
      "code" : "A032848399",
      "display" : "DERMOSOL CREAM 0.5MG/G \"PATRON\" (CLOBETASOL)"
    },
    {
      "code" : "A032849100",
      "display" : "MEZAIN TABLET 5MG  \"STANDARD\"(OXETHAZAINE)"
    },
    {
      "code" : "A032851100",
      "display" : "ADERNAN TABLETS 50MG (HYDRALAZINE)"
    },
    {
      "code" : "A032856329",
      "display" : "WEICORT-N CREAM \"WEIDAR\""
    },
    {
      "code" : "A032856372",
      "display" : "WEICORT-N CREAM \"WEIDAR\""
    },
    {
      "code" : "A032856399",
      "display" : "WEICORT-N CREAM \"WEIDAR\""
    },
    {
      "code" : "A032876100",
      "display" : "HERBESSER TABLETS 60MG"
    },
    {
      "code" : "A032877100",
      "display" : "VOLEN E.C. TABLET 50MG (DICLOFENAC) \"WINSTON\""
    },
    {
      "code" : "A032879100",
      "display" : "TYFUSU CAPSULES 250MG (METRONIDAZOLE) \"F.S.\""
    },
    {
      "code" : "A032880100",
      "display" : "AMBROXOL TABLETS 30MG \"KOJAR\""
    },
    {
      "code" : "A0328801G0",
      "display" : "AMBROXOL TABLETS 30MG \"KOJAR\""
    },
    {
      "code" : "A032881321",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881329",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881330",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881335",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881338",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881372",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032881399",
      "display" : "E.F. CREAM"
    },
    {
      "code" : "A032882309",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882321",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882329",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882335",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882338",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882340",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882343",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882372",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032882399",
      "display" : "SALIC OINTMENT"
    },
    {
      "code" : "A032884109",
      "display" : "CASEMYCIN GRANULES 500MG/GN \"T.F.\"(CEPHALEXIN)"
    },
    {
      "code" : "A032884177",
      "display" : "CASEMYCIN GRANULES 500MG/GN \"T.F.\"(CEPHALEXIN)"
    },
    {
      "code" : "A032884199",
      "display" : "CASEMYCIN GRANULES 500MG/GN \"T.F.\"(CEPHALEXIN)"
    },
    {
      "code" : "A032885500",
      "display" : "VAZOLE VAGINAL TABLETS 250MG (METRONIDAZOLE)\"H.S.\""
    },
    {
      "code" : "A032886100",
      "display" : "UPDOPA TABLETS 2.5MG (BROMOCRIPTINE) \"JINUP\""
    },
    {
      "code" : "A032891100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"T.F.\""
    },
    {
      "code" : "A032892500",
      "display" : "Molin Suppository 10mg \"T.F.\""
    },
    {
      "code" : "A032893100",
      "display" : "ERYMYCIN FILM COATED TABLETS 500MG \"T.F\""
    },
    {
      "code" : "A032898300",
      "display" : "GOODLUCK CREAM 0.5MG/GM (CLOBETASONE)"
    },
    {
      "code" : "A032898330",
      "display" : "GOODLUCK CREAM 0.5MG/GM (CLOBETASONE)"
    },
    {
      "code" : "A032898338",
      "display" : "GOODLUCK CREAM 0.5MG/GM (CLOBETASONE)"
    },
    {
      "code" : "A032898377",
      "display" : "GOODLUCK CREAM 0.5MG/GM (CLOBETASONE)"
    },
    {
      "code" : "A032898399",
      "display" : "GOODLUCK CREAM 0.5MG/GM (CLOBETASONE)"
    },
    {
      "code" : "A032917209",
      "display" : "PIROCAM INJ. \"N.K\" 20MG/ML (PIROXICAM)"
    },
    {
      "code" : "A032917212",
      "display" : "PIROCAM INJ. \"N.K\" 20MG/ML (PIROXICAM)"
    },
    {
      "code" : "A032918100",
      "display" : "Culcer DAILY F.C. Tablet 300mg"
    },
    {
      "code" : "A032924100",
      "display" : "SILENAL TABLETS 20MG \"N.C.P.\" (OXAZOLAM)"
    },
    {
      "code" : "A032925118",
      "display" : "KALA SOLUTION \"YU SHENG\""
    },
    {
      "code" : "A032925157",
      "display" : "KALA SOLUTION \"YU SHENG\""
    },
    {
      "code" : "A032925199",
      "display" : "KALA SOLUTION \"YU SHENG\""
    },
    {
      "code" : "A032926100",
      "display" : "DICLOFENAC E.F.C. TABLETS 50MG \"CHINTENG\""
    },
    {
      "code" : "A0329261G0",
      "display" : "DICLOFENAC E.F.C. TABLETS 50MG \"CHINTENG\""
    },
    {
      "code" : "A032927100",
      "display" : "NOSCAPINE TABLETS 20MG \"ROOT\""
    },
    {
      "code" : "A032928161",
      "display" : "VENTOLIN LIQUID 0.4MG/ML (SALBUTAMOL SULPHATE)"
    },
    {
      "code" : "A032928197",
      "display" : "VENTOLIN LIQUID 0.4MG/ML (SALBUTAMOL SULPHATE)"
    },
    {
      "code" : "A032928199",
      "display" : "VENTOLIN LIQUID 0.4MG/ML (SALBUTAMOL SULPHATE)"
    },
    {
      "code" : "A032933100",
      "display" : "ASIR TABLETS \"YU SHENG\""
    },
    {
      "code" : "A032934151",
      "display" : "LIKANCOUHG LIQUID"
    },
    {
      "code" : "A032934157",
      "display" : "LIKANCOUHG LIQUID"
    },
    {
      "code" : "A032934199",
      "display" : "LIKANCOUHG LIQUID"
    },
    {
      "code" : "A032935163",
      "display" : "WEIGEN LIQUID \"ROOT\""
    },
    {
      "code" : "A032936100",
      "display" : "CEPHRADINE CAPSULES 500MG \"ROOT\""
    },
    {
      "code" : "A032937500",
      "display" : "DICLOFEN SUPPOSITORY 25MG (DICLOFENAC) \"H.S.\""
    },
    {
      "code" : "A032938323",
      "display" : "CHEMIN OINTMENT 0.25％ \"H.S.\""
    },
    {
      "code" : "A032938329",
      "display" : "CHEMIN OINTMENT 0.25％ \"H.S.\""
    },
    {
      "code" : "A032938365",
      "display" : "CHEMIN OINTMENT 0.25％ \"H.S.\""
    },
    {
      "code" : "A032938399",
      "display" : "CHEMIN OINTMENT 0.25％ \"H.S.\""
    },
    {
      "code" : "A032939100",
      "display" : "SINFLEX CAPSULE 500MG (CEPHALEXIN) \"SINPHAR\""
    },
    {
      "code" : "A032940100",
      "display" : "SINFLEX CAPSULE 250MG (CEPHALEXIN) \"SINPHAR\""
    },
    {
      "code" : "A032942100",
      "display" : "DEMIL TABLETS 2.5MG (BROMOCRIPTINE) \"KOJAR\""
    },
    {
      "code" : "A032943100",
      "display" : "NIFAN CAPSULES 250MG (NIFLUMIC ACID) \"H.S.\""
    },
    {
      "code" : "A032945100",
      "display" : "TUENSILIN TABLETS 2.5MG \"ROOT\" (FENOTEROL)"
    },
    {
      "code" : "A032946100",
      "display" : "MINCON CAPSULES \"ROOT\""
    },
    {
      "code" : "A032948100",
      "display" : "KOBEN CAPSULES \"ROOT\""
    },
    {
      "code" : "A032949100",
      "display" : "SUCROXINE TABLETS \"ROOT\""
    },
    {
      "code" : "A032950100",
      "display" : "POUWEPIN TABLETS 200MG \"ROOT\" (CIMETIDINE)"
    },
    {
      "code" : "A032951100",
      "display" : "COYENPIN TABLETS 25MG \"ROOT\" (DICLOFENAC)"
    },
    {
      "code" : "A032952100",
      "display" : "PANMITIN TABLETS 100MG \"ROOT\" (TRIMETHOPRIM)"
    },
    {
      "code" : "A032956100",
      "display" : "CAPTOPRIL TABLETS 25MG \"CHINTENG\""
    },
    {
      "code" : "A032957100",
      "display" : "NITROLIR S.C. TABLETS 50MG (NITROXOLINE) \"Y.Y\""
    },
    {
      "code" : "A032958329",
      "display" : "BIFONAZOLE CREAM 10MG/GM"
    },
    {
      "code" : "A032969100",
      "display" : "DEANTRAN TABLETS 1MG \"R.T.\""
    },
    {
      "code" : "A0329691G0",
      "display" : "DEANTRAN TABLETS 1MG \"R.T.\""
    },
    {
      "code" : "A032970100",
      "display" : "SANTITEN TABLETS 1MG(KETOTIFEN)\"CHEN TA\""
    },
    {
      "code" : "A032971329",
      "display" : "YIHFU OINTMENT 0.5MG/GM (CLOBETASOL PROPIONATE)\"S.D.\""
    },
    {
      "code" : "A032971372",
      "display" : "YIHFU OINTMENT 0.5MG/GM (CLOBETASOL PROPIONATE)\"S.D.\""
    },
    {
      "code" : "A032971399",
      "display" : "YIHFU OINTMENT 0.5MG/GM (CLOBETASOL PROPIONATE)\"S.D.\""
    },
    {
      "code" : "A032985100",
      "display" : "COLIBRATE TABLET 200MG"
    },
    {
      "code" : "A032988329",
      "display" : "ECORT CREAM \"WEIDAR\""
    },
    {
      "code" : "A032988372",
      "display" : "ECORT CREAM \"WEIDAR\""
    },
    {
      "code" : "A032988399",
      "display" : "ECORT CREAM \"WEIDAR\""
    },
    {
      "code" : "A032989209",
      "display" : "MECOBAL INJECTION 0.5 MG/ML \"T.F\""
    },
    {
      "code" : "A032989221",
      "display" : "MECOBAL INJECTION 0.5 MG/ML \"T.F\""
    },
    {
      "code" : "A032990238",
      "display" : "FADIN LYO-INJECTION 20MG STANDARD\"(FAMOTIDINE)\""
    },
    {
      "code" : "A033006321",
      "display" : "Betamethasone Cream \"F.Y.\""
    },
    {
      "code" : "A033006371",
      "display" : "Betamethasone Cream \"F.Y.\""
    },
    {
      "code" : "A033006399",
      "display" : "Betamethasone Cream \"F.Y.\""
    },
    {
      "code" : "A033007321",
      "display" : "LESUMIN OINTMENT \"FUSENG\" (FLUOCINOLONE ACETONIDE)"
    },
    {
      "code" : "A033007371",
      "display" : "LESUMIN OINTMENT \"FUSENG\" (FLUOCINOLONE ACETONIDE)"
    },
    {
      "code" : "A033007399",
      "display" : "LESUMIN OINTMENT \"FUSENG\" (FLUOCINOLONE ACETONIDE)"
    },
    {
      "code" : "A033009212",
      "display" : "MOLIN INJECTION 5MG/ML (DOMPERIDONE)\"T.F\""
    },
    {
      "code" : "A033022100",
      "display" : "SUYANLEN CAPSULES 100MG \"F.S.\" (FLUFENAMIC ACID)"
    },
    {
      "code" : "A033023100",
      "display" : "SULOWEILIN TABLETS \"ROOT\""
    },
    {
      "code" : "A0330231G0",
      "display" : "SULOWEILIN TABLETS \"ROOT\""
    },
    {
      "code" : "A033024100",
      "display" : "INDERSHIN CAPSULES 25MG \"F.S.\" (INDOMETHACIN)"
    },
    {
      "code" : "A033025100",
      "display" : "S.S.T.E.S.C. TABLETS 100MG  (METHYLCYSTEINE)\"C.H.\""
    },
    {
      "code" : "A033027100",
      "display" : "TRICOLINE TABLETS 3MG \"CHEN TA\" (TRIMETOQUINO)"
    },
    {
      "code" : "A033029100",
      "display" : "Ateol F.C. Tab. 100mg \"Standard\" (Atenolol)"
    },
    {
      "code" : "A033048100",
      "display" : "NAPTON S.R. TABLETS 750MG (NAPROXEN) \"B&F\""
    },
    {
      "code" : "A033049100",
      "display" : "TALIPIN TABLET 30MG \"SWISS\" (AMBROXOL)"
    },
    {
      "code" : "A0330491G0",
      "display" : "TALIPIN TABLET 30MG \"SWISS\" (AMBROXOL)"
    },
    {
      "code" : "A033051118",
      "display" : "OUTCOLD SOLUTION \"CHINTENG\""
    },
    {
      "code" : "A033051199",
      "display" : "OUTCOLD SOLUTION \"CHINTENG\""
    },
    {
      "code" : "A033052100",
      "display" : "ANCOUGH TABLETS 100MG \"ROOT\" (OXOLAMINE CITRATE)"
    },
    {
      "code" : "A033053155",
      "display" : "ASIR POWDER 100MG/GM (TIPEPIDINE)\"Y.S\""
    },
    {
      "code" : "A033053177",
      "display" : "ASIR POWDER 100MG/GM (TIPEPIDINE)\"Y.S\""
    },
    {
      "code" : "A033053199",
      "display" : "ASIR POWDER 100MG/GM (TIPEPIDINE)\"Y.S\""
    },
    {
      "code" : "A033054100",
      "display" : "BROMA-DEL TABLETS 2.5MG (BROMOCRIPITINE) \"CCPC\""
    },
    {
      "code" : "A033056100",
      "display" : "BELOTON TABLETS 60MG (TERFENADINE)"
    },
    {
      "code" : "A033063321",
      "display" : "JINRIH CREAM 50MG/GM (ACYCLOVIR) \"CHINTENG\""
    },
    {
      "code" : "A033063365",
      "display" : "JINRIH CREAM 50MG/GM (ACYCLOVIR) \"CHINTENG\""
    },
    {
      "code" : "A033063372",
      "display" : "JINRIH CREAM 50MG/GM (ACYCLOVIR) \"CHINTENG\""
    },
    {
      "code" : "A033063399",
      "display" : "JINRIH CREAM 50MG/GM (ACYCLOVIR) \"CHINTENG\""
    },
    {
      "code" : "A033064100",
      "display" : "IBUPROFEN F.C. TABLETS 400MG \"KOJAR\""
    },
    {
      "code" : "A0330641G0",
      "display" : "IBUPROFEN F.C. TABLETS 400MG \"KOJAR\""
    },
    {
      "code" : "A033067100",
      "display" : "ADALAT RETARD  20MG (NIFEDIPINE)F.C.T."
    },
    {
      "code" : "A033068321",
      "display" : "CANESTEN CREAM 0.01GM/GM (CLOTRIMAZOLE)"
    },
    {
      "code" : "A033068338",
      "display" : "CANESTEN CREAM 0.01GM/GM (CLOTRIMAZOLE)"
    },
    {
      "code" : "A033068399",
      "display" : "CANESTEN CREAM 0.01GM/GM (CLOTRIMAZOLE)"
    },
    {
      "code" : "A033072212",
      "display" : "FAMODINE INJECTION 10MG/ML \"N.K.\"(FAMOTIDINE)"
    },
    {
      "code" : "A033072229",
      "display" : "FAMODINE INJECTION 10MG/ML \"N.K.\"(FAMOTIDINE)"
    },
    {
      "code" : "A033073100",
      "display" : "CASEMYCIN CAPSULES 500MG (CEPHALEXIN) \"T.F.\""
    },
    {
      "code" : "A033074321",
      "display" : "KENALON CREAM \"T.F.\""
    },
    {
      "code" : "A033074338",
      "display" : "KENALON CREAM \"T.F.\""
    },
    {
      "code" : "A033074372",
      "display" : "KENALON CREAM \"T.F.\""
    },
    {
      "code" : "A033074399",
      "display" : "KENALON CREAM \"T.F.\""
    },
    {
      "code" : "A033075421",
      "display" : "HIMITAN OPHTHALMIC SOLUTION 0.25％(TIMOLOL)"
    },
    {
      "code" : "A033078329",
      "display" : "KETOSONE CREAM 20MG/GM (KETOCONAZOLE) \"B&F\""
    },
    {
      "code" : "A033079100",
      "display" : "PIROXICAM TABLETS 20MG \"H.S.\""
    },
    {
      "code" : "A0330791G0",
      "display" : "PIROXICAM TABLETS 20MG \"H.S.\""
    },
    {
      "code" : "A033080100",
      "display" : "PROTANON TABLETS 5MG \"Y.S.\"(ALLYLESTRENOL)"
    },
    {
      "code" : "A033081100",
      "display" : "KEFEN TABLETS 1MG (KETOTIFEN) \"H.S\""
    },
    {
      "code" : "A0330811G0",
      "display" : "KEFEN TABLETS 1MG (KETOTIFEN) \"H.S\""
    },
    {
      "code" : "A033082100",
      "display" : "ULCERBAN TABLETS 500MG (SUCRALFATE)"
    },
    {
      "code" : "A033086197",
      "display" : "KEFLOR FOR ORAL SUSPENSION 187MG/5ML (CEFACLOR)"
    },
    {
      "code" : "A033090100",
      "display" : "BIO-CAL CHEWABLE TABLETS"
    },
    {
      "code" : "A033091100",
      "display" : "LICODIN F.C.Tablet 250MG (TICLOPIDINE)"
    },
    {
      "code" : "A033092100",
      "display" : "CIPROXIN  250MG (CIPROFLOXACIN)F.C.T."
    },
    {
      "code" : "A033093209",
      "display" : "METACIN FOR INJECTION (CEFMETAZOLE)"
    },
    {
      "code" : "A033093277",
      "display" : "METACIN FOR INJECTION (CEFMETAZOLE)"
    },
    {
      "code" : "A033097177",
      "display" : "AMOXICILLIN GRANULES 200MG \"C.C.P.\""
    },
    {
      "code" : "A033097199",
      "display" : "AMOXICILLIN GRANULES 200MG \"C.C.P.\""
    },
    {
      "code" : "A033098100",
      "display" : "CIKETIN TABLETS 400MG (CIMETIDINE) \"UNION\""
    },
    {
      "code" : "A0330981G0",
      "display" : "CIKETIN TABLETS 400MG (CIMETIDINE) \"UNION\""
    },
    {
      "code" : "A033099100",
      "display" : "PINRU CAPSULES 50MG (PHENYLPROPANOLAMINE HCL) \"JOHNSON\""
    },
    {
      "code" : "A033108100",
      "display" : "TEXO TABLET 30MG (AMBROXOL) \"C.H.\""
    },
    {
      "code" : "A033109100",
      "display" : "T.F TABLET 60MG (TERFENADINE)\"C.H\""
    },
    {
      "code" : "A033115100",
      "display" : "ADAPIN CAPSULES 10MG (NIFEDIPINE)\"C.T.\""
    },
    {
      "code" : "A033122100",
      "display" : "DICLOFEN ENTERIC FILM COATING TABLETS 50MG ( DICOLFENAC) \"KOJAR\""
    },
    {
      "code" : "A0331221G0",
      "display" : "DICLOFEN ENTERIC FILM COATING TABLETS 50MG ( DICOLFENAC) \"KOJAR\""
    },
    {
      "code" : "A033123100",
      "display" : "SEZOLAM CAPSULE 10MG (OXAZOLAM)\"CURIE\""
    },
    {
      "code" : "A033124100",
      "display" : "ANLIPIN F.C. TABLETS 100MG (ATENOLOL) \"KOJAR\""
    },
    {
      "code" : "A033125100",
      "display" : "FUCOTIN F.C. TABLETS 200MG (FLAVOXATE) \"KOJAR\""
    },
    {
      "code" : "A033126100",
      "display" : "FUROL CAPSULES 10MG (BROMOPRIDE) \"KOJAR\""
    },
    {
      "code" : "A033127100",
      "display" : "ANWELL TABLETS 500MG (HYDROTALCITE)\"KOJAR\""
    },
    {
      "code" : "A033128100",
      "display" : "MEFENA F.C. TABLETS 500MG \"KOJAR\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A0331281G0",
      "display" : "MEFENA F.C. TABLETS 500MG \"KOJAR\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A033134100",
      "display" : "BEZAFITE TABLETS 200MG (BEZAFIBRATE)\"M.S.\""
    },
    {
      "code" : "A033138100",
      "display" : "DIMELOR TABLETS 500MG (ACETOHEXAMIDE)"
    },
    {
      "code" : "A033139100",
      "display" : "ENERGY S.C. TABLETS 50MG \"MEIDER\" (DL-ALPHA TOCOPHERYL ACETATE)"
    },
    {
      "code" : "A033140100",
      "display" : "FREE S.C. TABLETS"
    },
    {
      "code" : "A033142100",
      "display" : "DEPUTUM TABLETS 30MG (AMBROXOL) \"P.L.\""
    },
    {
      "code" : "A033148100",
      "display" : "SPORANOX CAPSULE 100MG (ITRACONAZOLE)"
    },
    {
      "code" : "A033149209",
      "display" : "S-60 INJECTION (CEPHRADINE)"
    },
    {
      "code" : "A033149277",
      "display" : "S-60 INJECTION (CEPHRADINE)"
    },
    {
      "code" : "A033153343",
      "display" : "BIOFUR ACNE LOTION 50MG/GM \"SINPHAR\"(SULFUR PRCIPITATED)"
    },
    {
      "code" : "A033153355",
      "display" : "BIOFUR ACNE LOTION 50MG/GM \"SINPHAR\"(SULFUR PRCIPITATED)"
    },
    {
      "code" : "A033157100",
      "display" : "WEISUFU TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A0331571G0",
      "display" : "WEISUFU TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A033161100",
      "display" : "SELININ TABLETS 100MG (ATENOLOL) \"Y.C.\""
    },
    {
      "code" : "A033163100",
      "display" : "CO-TRIZOL TABLETS \"Y.C.\""
    },
    {
      "code" : "A033165100",
      "display" : "VITAMIN B6 TABLETS 25MG \"Y.C.\""
    },
    {
      "code" : "A033166100",
      "display" : "BROMPHENIRAMINE MALEATE TABLETS \"Y.C.\""
    },
    {
      "code" : "A033168100",
      "display" : "CENIN-E CAPSULES 200MG \"Y.C.\""
    },
    {
      "code" : "A033170100",
      "display" : "SHUAYAN TABLETS 0.5MG (DEXAMETHASONE)\"Y.C.\""
    },
    {
      "code" : "A033171100",
      "display" : "ANSWET TABLETS 5MG (NITRAZEPAM) \"Y.C.\""
    },
    {
      "code" : "A033172100",
      "display" : "HEITOMIN S.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A033174100",
      "display" : "ASUTAF S.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A033175100",
      "display" : "MENICON TABLETS 30MG (DEXTROMETHORPHAN)\"Y.C.\""
    },
    {
      "code" : "A033176100",
      "display" : "FLOUOXYMESTERONE CAPSULES 5MG (FLUOXYMESTERINE)\"Y.C.\""
    },
    {
      "code" : "A033178100",
      "display" : "MEZOLE TABLETS 100MG (MEBENDAZOLE) \"Y.C.\""
    },
    {
      "code" : "A033179100",
      "display" : "IODOLECITHIN S.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A033180100",
      "display" : "SU KU TA TABLETS \"Y.C.\""
    },
    {
      "code" : "A033182100",
      "display" : "VITAMIN B COMPLEX S.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A033184100",
      "display" : "PRITHMOW TABLETS 5MG (PREDNISOLONE)\"Y.C.\""
    },
    {
      "code" : "A033185100",
      "display" : "Terico-S. Tablets 250mg\"Y.C.\"(Metronidazole)"
    },
    {
      "code" : "A033187100",
      "display" : "TRIAMCINOLONE TABLETS 4MG (TRIAMCINOLONE)\"Y.C.\""
    },
    {
      "code" : "A033190100",
      "display" : "SONZIN TABLETS 250MG \"Y.C.\" (CHLORZOXAZONE)"
    },
    {
      "code" : "A033191100",
      "display" : "Parker Tablets\"Y.C.\""
    },
    {
      "code" : "A033194100",
      "display" : "OROLISIN F.C. TABLETS \"Y.C.\""
    },
    {
      "code" : "A033195100",
      "display" : "Meramin Tablets \"Y. C.\""
    },
    {
      "code" : "A033196100",
      "display" : "HOUNOW TABLETS 15MG (CINNARIZINE)\"Y.C.\""
    },
    {
      "code" : "A033197100",
      "display" : "NALIDIXIC ACID TABLETS 500MG (NALIDIXIC ACID )\"Y.C.\""
    },
    {
      "code" : "A033200109",
      "display" : "GURORPAN POWDER \"Y.C.\""
    },
    {
      "code" : "A033201100",
      "display" : "SEPHYLLINE TABLETS 100MG (PENTOXIFYLLINE)"
    },
    {
      "code" : "A033202100",
      "display" : "ARZDANE TABLETS 60MG (TERFENADINE)\"LITA\""
    },
    {
      "code" : "A033203100",
      "display" : "YUETAN TABLETS 30MG (AMBROXOL)\"Synmosa.\""
    },
    {
      "code" : "A033204100",
      "display" : "AMBROXOL TABLETS 30MG \"R.T.\""
    },
    {
      "code" : "A0332041G0",
      "display" : "AMBROXOL TABLETS 30MG \"R.T.\""
    },
    {
      "code" : "A033205100",
      "display" : "VINNA TABLETS 60MG (TERFENADINE)"
    },
    {
      "code" : "A033207100",
      "display" : "PIANT TABLETS 500MG \"ROOT\" (ACETAMINOPHEN)"
    },
    {
      "code" : "A033208100",
      "display" : "HEXOPAL TABLETS 100MG (PENTOXIFYLLINE)\"R.T.\""
    },
    {
      "code" : "A033209100",
      "display" : "CONLO COLD SOLUTION \"CHIN TERG\""
    },
    {
      "code" : "A033213100",
      "display" : "DECOMINE TABLETS 60MG (TERFENADINE)\"R.T.\""
    },
    {
      "code" : "A033214100",
      "display" : "UMINON CAPSULES 100MG (MINOCYCLINE) \"UNION\""
    },
    {
      "code" : "A033215212",
      "display" : "TOBUCIN INJECTION 40MG/ML (TOBRAMYCIN SULFATE) \"Y.F.\""
    },
    {
      "code" : "A033215219",
      "display" : "TOBUCIN INJECTION 40MG/ML (TOBRAMYCIN SULFATE) \"Y.F.\""
    },
    {
      "code" : "A033219100",
      "display" : "DICLOFENAC E.C.F. TABLETS 25MG \"C.H.\""
    },
    {
      "code" : "A033220100",
      "display" : "Actirin capsules 10mg \"Y.C.\"（Oxazolam）"
    },
    {
      "code" : "A033223229",
      "display" : "TRACE ELEMENT INJECTION \"C.C.P.C\""
    },
    {
      "code" : "A033224100",
      "display" : "DILTISSER TABLETS 30MG (DILTIAZEM HYDROCHLORIDE) \"C.C.C.P.\""
    },
    {
      "code" : "A0332241G0",
      "display" : "DILTISSER TABLETS 30MG (DILTIAZEM HYDROCHLORIDE) \"C.C.C.P.\""
    },
    {
      "code" : "A033225100",
      "display" : "CEFSPAN CAPSULE 100MG (CEFIXIME)"
    },
    {
      "code" : "A033226329",
      "display" : "JINFSONE CREAM 0.5MG/GM \"O.Y.\" (CLOBETASOL)"
    },
    {
      "code" : "A033227118",
      "display" : "PRJITUSSIN SYRUP 20MG/ML (GUAIFENESIN)\"ATOBI\""
    },
    {
      "code" : "A033227157",
      "display" : "PRJITUSSIN SYRUP 20MG/ML (GUAIFENESIN)\"ATOBI\""
    },
    {
      "code" : "A033227199",
      "display" : "PRJITUSSIN SYRUP 20MG/ML (GUAIFENESIN)\"ATOBI\""
    },
    {
      "code" : "A033229100",
      "display" : "DIXARIT S.C.TABLETS 25MCG (CLONIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A033237100",
      "display" : "PREDNISOLONE S.C. TABLETS 5NG \"F.S.\""
    },
    {
      "code" : "A033238100",
      "display" : "VITABONIN TABLETS \"M.S.\""
    },
    {
      "code" : "A033240100",
      "display" : "SUBILIN TABLETS 60MG (PSEUDOEPHEDRINE)\"M.S.\""
    },
    {
      "code" : "A033242100",
      "display" : "PINRIJIN S.C. TABLETS 10MG (CHLORDIAZEPOXIDE)\"M.S.\""
    },
    {
      "code" : "A033243100",
      "display" : "INSHEL S.C. TABLETS \"M.S.\""
    },
    {
      "code" : "A033246100",
      "display" : "CINRIZIN TABLETS 25MG (CINNARIZINE)\"M.S.\""
    },
    {
      "code" : "A033247100",
      "display" : "SON COUGH TABLETS 30MG (DEXTROMETHORPHAN)\"M.S.\""
    },
    {
      "code" : "A033253329",
      "display" : "E-FLOW CREAM \"M.T.\""
    },
    {
      "code" : "A033253335",
      "display" : "E-FLOW CREAM \"M.T.\""
    },
    {
      "code" : "A033253372",
      "display" : "E-FLOW CREAM \"M.T.\""
    },
    {
      "code" : "A033253399",
      "display" : "E-FLOW CREAM \"M.T.\""
    },
    {
      "code" : "A033258309",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258321",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258329",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258335",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258338",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258372",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033258399",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A0332583B9",
      "display" : "BETAMAZOLE CREAM \"GCPC\""
    },
    {
      "code" : "A033259100",
      "display" : "TAICOPIN TABLETS 1MG (HEXO-PRENALINE)"
    },
    {
      "code" : "A033260211",
      "display" : "TRANEXAMIC ACID INJECTION 100MG/ML \"ASTAR\""
    },
    {
      "code" : "A033260221",
      "display" : "TRANEXAMIC ACID INJECTION 100MG/ML \"ASTAR\""
    },
    {
      "code" : "A033260229",
      "display" : "TRANEXAMIC ACID INJECTION 100MG/ML \"ASTAR\""
    },
    {
      "code" : "A033261209",
      "display" : "PROGESTERONE INJECTION 50MG/ML \"ASTAR\""
    },
    {
      "code" : "A033261229",
      "display" : "PROGESTERONE INJECTION 50MG/ML \"ASTAR\""
    },
    {
      "code" : "A033264100",
      "display" : "FUNSPAN TABLETS \"DAU CHI\""
    },
    {
      "code" : "A033265100",
      "display" : "TEI KAO TABLETS \"DAU CHI\""
    },
    {
      "code" : "A033267100",
      "display" : "CAN HONG CAPSULES \"DAU CHI\""
    },
    {
      "code" : "A033268100",
      "display" : "E-LICON CAPSULES"
    },
    {
      "code" : "A033269100",
      "display" : "BUZETIN CAPSULES"
    },
    {
      "code" : "A033270100",
      "display" : "KOPIN TABLETS"
    },
    {
      "code" : "A033271100",
      "display" : "BISUMIN-G TABLETS"
    },
    {
      "code" : "A033272100",
      "display" : "IPRON TABLETS"
    },
    {
      "code" : "A033274100",
      "display" : "ANCOUGH CAPSULES"
    },
    {
      "code" : "A033276100",
      "display" : "ANTHTON-P CAPSULES"
    },
    {
      "code" : "A033277100",
      "display" : "CHUPYMIN CAPSULES"
    },
    {
      "code" : "A033282338",
      "display" : "LIFULIN OINTMENT \"M.T.\""
    },
    {
      "code" : "A033285119",
      "display" : "FUSOSHU SYRUP \"M.T.\""
    },
    {
      "code" : "A033285151",
      "display" : "FUSOSHU SYRUP \"M.T.\""
    },
    {
      "code" : "A033285199",
      "display" : "FUSOSHU SYRUP \"M.T.\""
    },
    {
      "code" : "A033288329",
      "display" : "FLUSIN CREAM 0.05％ \"M.T.\" (FLUOCINONIDE)"
    },
    {
      "code" : "A033288355",
      "display" : "FLUSIN CREAM 0.05％ \"M.T.\" (FLUOCINONIDE)"
    },
    {
      "code" : "A033291321",
      "display" : "MYCOSPOR CREAM 10MG/GM (BIFONAZOLE)"
    },
    {
      "code" : "A033291329",
      "display" : "MYCOSPOR CREAM 10MG/GM (BIFONAZOLE)"
    },
    {
      "code" : "A033292100",
      "display" : "COMFORT TABLETS 500MG (ASPIRIN)\"MEIDER\""
    },
    {
      "code" : "A033303100",
      "display" : "SERIL-K S.C. TABLETS"
    },
    {
      "code" : "A033304100",
      "display" : "\"HC NORITLE\" JOINT PAIN RELIEF F.C. TABLETS 400MG (IBUPROFEN)"
    },
    {
      "code" : "A033321212",
      "display" : "NICEWE INJECTION 25MG/ML \"N.K.\" (RANITIDINE HYDROCHLORIDE)"
    },
    {
      "code" : "A033347100",
      "display" : "FULBIYEN TABLETS 4MG (TRIAMICINOLONE)\"M.S.\""
    },
    {
      "code" : "A033349100",
      "display" : "POUSTARN CAPSULES 250MG (MEFENAMIC ACID)\"M.S.\""
    },
    {
      "code" : "A033350100",
      "display" : "DIURECIDE TABLETS 40MG (FUROSEMIDE)\"M.S.\""
    },
    {
      "code" : "A033351100",
      "display" : "COLDAN CAPSULES \"M.S.\""
    },
    {
      "code" : "A033353100",
      "display" : "REGITAN TABLETS 10MG (YALETHAMATE BROMIDE)\"M.S.\""
    },
    {
      "code" : "A033356100",
      "display" : "TETRACYCLINE HCL CAPSULES 500MG \"M.S.\""
    },
    {
      "code" : "A033357100",
      "display" : "AMADINE CAPSULES 100MG (AMANTADINE) \"M.S.\""
    },
    {
      "code" : "A033358100",
      "display" : "JUYEN JEN TABLETS \"M.S.\""
    },
    {
      "code" : "A033359100",
      "display" : "DERGINPIN TABLETS 5MG (DIAZEPAM)\"M.S.\""
    },
    {
      "code" : "A033360100",
      "display" : "ANEDANE CAPSULES 25MG (ANETHOLE) \"M.S.\""
    },
    {
      "code" : "A033362100",
      "display" : "KANPO CAPSULES 50MG (SULPIRIDE) \"M.S.\""
    },
    {
      "code" : "A033363100",
      "display" : "TRANSAMIN CAPSULES 250MG (TRANEXAMIC ACID)\"M.S.\""
    },
    {
      "code" : "A033364100",
      "display" : "ERYTHROMYCIN ESTOLATE CAPSULES 250MG \"M.S.\""
    },
    {
      "code" : "A033365100",
      "display" : "ANZERTON TABLETS 500MG (ACETAMINOPHEN)\"M.S.\""
    },
    {
      "code" : "A033366321",
      "display" : "ICOUFU CREAM \"M.S.\""
    },
    {
      "code" : "A033367100",
      "display" : "CEFADROXIL CAPSULES 500MG \"M.S.\""
    },
    {
      "code" : "A033371100",
      "display" : "SUKEYEN CAPSULES 50MG (KETOPROFEN)"
    },
    {
      "code" : "A033372100",
      "display" : "PIPEMIDIC  ACID TABLETS 250MG \"M.S.\""
    },
    {
      "code" : "A033373100",
      "display" : "LYSOZYME TABLETS 90MG \"M.S.\""
    },
    {
      "code" : "A033374100",
      "display" : "CYSMIN TABLETS 100MG (L-METHYLCYSTEINE) \"M.S.\""
    },
    {
      "code" : "A033375100",
      "display" : "CEPHRADINE CAPSULES 500MG \"M.S.\""
    },
    {
      "code" : "A033376212",
      "display" : "GENTAMYCIN INJECTION 140MG/ML \"T.F\""
    },
    {
      "code" : "A033376229",
      "display" : "GENTAMYCIN INJECTION 140MG/ML \"T.F\""
    },
    {
      "code" : "A033377321",
      "display" : "URESON CREAM"
    },
    {
      "code" : "A033377329",
      "display" : "URESON CREAM"
    },
    {
      "code" : "A033377335",
      "display" : "URESON CREAM"
    },
    {
      "code" : "A033377336",
      "display" : "URESON CREAM"
    },
    {
      "code" : "A033377399",
      "display" : "URESON CREAM"
    },
    {
      "code" : "A033379329",
      "display" : "YUCOMY CREAM 20MG/GM (KETOCONAZOLE)"
    },
    {
      "code" : "A033379355",
      "display" : "YUCOMY CREAM 20MG/GM (KETOCONAZOLE)"
    },
    {
      "code" : "A033380100",
      "display" : "FUCON TABLETS 100MG (PENTOXIFYLLINE) \"Y.C.\""
    },
    {
      "code" : "A033381321",
      "display" : "CAINA CREAM \"YUNG SHIN\""
    },
    {
      "code" : "A033381329",
      "display" : "CAINA CREAM \"YUNG SHIN\""
    },
    {
      "code" : "A033382100",
      "display" : "CLINDAMYCIN CAPSULES 150MG \"T.F\""
    },
    {
      "code" : "A033383335",
      "display" : "ETOFEN CREAM 100MG/GM (ETOFENAMATE)\"Y.S\""
    },
    {
      "code" : "A033385100",
      "display" : "TENOLMIN TABLETS 100MG (ATENOLOL)\"J.C.S.\""
    },
    {
      "code" : "A033387100",
      "display" : "SURIN TABLETS 200MG \"YU SHENG\" (SULPIRIDE)"
    },
    {
      "code" : "A033388100",
      "display" : "EUGEN TABLETS \"YU SHENG\""
    },
    {
      "code" : "A033389100",
      "display" : "DANTERLENE CAPSULES 25MG \"KOJAR\""
    },
    {
      "code" : "A033390100",
      "display" : "SOMILIN TABLETS 0.25MG (TRIAZOLAM)\"KOJAR\""
    },
    {
      "code" : "A033391100",
      "display" : "ANCOU TABLETS 15MG\"KOJAR\"(DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A033392100",
      "display" : "SILYCON CAPSULES 150MG (SILYMARIN)\"EAYUNG\""
    },
    {
      "code" : "A033411100",
      "display" : "ANCOU TABLETS 30MG (DEXTROMETHORPHAN)\"KOJAR\""
    },
    {
      "code" : "A0334111G0",
      "display" : "ANCOU TABLETS 30MG (DEXTROMETHORPHAN)\"KOJAR\""
    },
    {
      "code" : "A033414100",
      "display" : "TELFEN TABLETS 60MG (TERFENADINE) \"SINPHAR\""
    },
    {
      "code" : "A033415100",
      "display" : "AMBROXOL TABLETS 30MG \"SINPHAR\""
    },
    {
      "code" : "A0334151G0",
      "display" : "AMBROXOL TABLETS 30MG \"SINPHAR\""
    },
    {
      "code" : "A033416100",
      "display" : "SELTAIN TABLET 30MG (AMBROXOL) \"YUNG SINE\""
    },
    {
      "code" : "A033423100",
      "display" : "TOFILLINE 100MG S.C. TABLETS \"S.L.\""
    },
    {
      "code" : "A033425266",
      "display" : "SUNNYTOL INFUSION 20％ \"N.K.\" (MANNITOL)"
    },
    {
      "code" : "A033426100",
      "display" : "IBUPROFEN S.C. TABLET 200MG \"WINSTON\""
    },
    {
      "code" : "A033427164",
      "display" : "STAFOS SUSPENSION 110MG \"STANDARD\""
    },
    {
      "code" : "A033427199",
      "display" : "STAFOS SUSPENSION 110MG \"STANDARD\""
    },
    {
      "code" : "A033429238",
      "display" : "PITRESSIN INJECTION 20 UNITS/ML (ARGININE VASOPRESSIN)"
    },
    {
      "code" : "A033429255",
      "display" : "PITRESSIN INJECTION 20 UNITS/ML (ARGININE VASOPRESSIN)"
    },
    {
      "code" : "A033431100",
      "display" : "DC-STUFFY TABLETS 60MG (PSEUDOEPHEDRINE HCL) \"DCPC\""
    },
    {
      "code" : "A033432100",
      "display" : "LEDERPROFEN F.C. TABLETS 200MG (IBUPROFEN)"
    },
    {
      "code" : "A033433100",
      "display" : "SINSULIN CAPSULES 10MG \"ASTAR\""
    },
    {
      "code" : "A033434100",
      "display" : "KETOFEN CAPSULES 50MG (KETOPROFEN) \"SINTON\""
    },
    {
      "code" : "A033435100",
      "display" : "CIMETIDINE TABLETS 200MG \"ASTAR\""
    },
    {
      "code" : "A033436212",
      "display" : "CIMETIDINE INJECTION 100MG/ML \"ASTAR\""
    },
    {
      "code" : "A033445229",
      "display" : "MITOXANTRONE INJECTION 2MG/ML \"SYNMOSA\""
    },
    {
      "code" : "A033445299",
      "display" : "MITOXANTRONE INJECTION 2MG/ML \"SYNMOSA\""
    },
    {
      "code" : "A033447338",
      "display" : "PIROCAN 0.5％ GEL \"S.Y.\""
    },
    {
      "code" : "A033448100",
      "display" : "COSIN CAPSULES \"W.P.\""
    },
    {
      "code" : "A033449100",
      "display" : "NAPROXEN 250MG TABLETS \"Y.S.\""
    },
    {
      "code" : "A033453100",
      "display" : "MECOMIN CAPSULES 0.5MG (MECOBALAMIN)\"Y.C.\""
    },
    {
      "code" : "A033456209",
      "display" : "UZOLIN INJECTION (CEPHAZOLIN SODIUM)\"UNION\""
    },
    {
      "code" : "A033456212",
      "display" : "UZOLIN INJECTION (CEPHAZOLIN SODIUM)\"UNION\""
    },
    {
      "code" : "A033457100",
      "display" : "CLINDAMYCIN CAPSULES 150MG \"C.C.P.\""
    },
    {
      "code" : "A033459100",
      "display" : "NOXACIN CAPSULE 100MG \"GENTLE\" (NORFLOXACIN)"
    },
    {
      "code" : "A033460100",
      "display" : "NOXACIN CAPSULE 400MG \"GENTLE\" (NORFLOXACIN)"
    },
    {
      "code" : "A033461100",
      "display" : "FENOTIN TABLETS 2.5MG (FENOTEROL HYDROBROMIDE) \"S.L.\""
    },
    {
      "code" : "A033463100",
      "display" : "TERDINE TABLETS 60MG (TERFENADINE)\"M.S.\""
    },
    {
      "code" : "A033468100",
      "display" : "SILIMIN CAPSULES 150MG (SILYMARIN) \"KOJAR\""
    },
    {
      "code" : "A033470100",
      "display" : "AMANTADINE TABLETS 100MG \"T.A.\""
    },
    {
      "code" : "A033471100",
      "display" : "BORYMYCIN CAPSULES 100MG (MINOCYCLINE)"
    },
    {
      "code" : "A033472329",
      "display" : "YUREA CREAM \"YU SHENG\""
    },
    {
      "code" : "A033474221",
      "display" : "GETWAY 10MG INJ. (RANITIDINE)"
    },
    {
      "code" : "A033476100",
      "display" : "GEMNPID CAPSULE 300MG (GEMFIBROZIL) \"C.C.P.C\""
    },
    {
      "code" : "A033480100",
      "display" : "CLINCIN CAPSULES 150MG \"TAIWAN TUNG YANG\" (CLINDAMYCIN)"
    },
    {
      "code" : "A033483435",
      "display" : "BISTON NASAL SOLUTION \"T.F.\""
    },
    {
      "code" : "A033484100",
      "display" : "PUMIRO TABLETS 60MG (TERFENADINE)\"KOJAR\""
    },
    {
      "code" : "A033485151",
      "display" : "SUTAN LIQUID 3MG/ML (AMBROXOL)\"C.M.\""
    },
    {
      "code" : "A033487212",
      "display" : "KETOPROFEN IM INJECTION 50MG/ML \"ASTAR\""
    },
    {
      "code" : "A033489100",
      "display" : "COFEDENIN TABLETS \"Y.C.\" (TIPEPIDINE HIBENZATE)"
    },
    {
      "code" : "A033490100",
      "display" : "DANAZOL CAPSULES 200MG \"SINTON\""
    },
    {
      "code" : "A033491177",
      "display" : "CEPHALIN GRANULES 500MG (CEPHALEXIN MONOHYDRATE)"
    },
    {
      "code" : "A033491199",
      "display" : "CEPHALIN GRANULES 500MG (CEPHALEXIN MONOHYDRATE)"
    },
    {
      "code" : "A033493100",
      "display" : "GENUPROXIN TABLETS 250MG (NAPROXEN) \"GCPC\""
    },
    {
      "code" : "A033494100",
      "display" : "BENZYRIN S.C. TABLETS 25MG (BANZYDAMINE)\"SINPHAR\""
    },
    {
      "code" : "A033495100",
      "display" : "SALBUTAMOL TABLETS 4MG \"SINPHAR\""
    },
    {
      "code" : "A033496100",
      "display" : "UCOLAR CAPSULES 100MG \"SINPHAR\" (TOCOPHEROL NICOTINATE)"
    },
    {
      "code" : "A033497100",
      "display" : "COLD CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A033498100",
      "display" : "CINNARIZINE CAPSULES 25MG \"SINPHAR\""
    },
    {
      "code" : "A033501100",
      "display" : "CHLORPROPAMIDE TABLETS 250MG \"SINPHAR\""
    },
    {
      "code" : "A033502100",
      "display" : "RONGIFENE TABLETS 50MG (BUCLIZINE)\"SINPHAR\""
    },
    {
      "code" : "A033504100",
      "display" : "IBUPROFEN TABLETS 400MG \"SINPHAR\""
    },
    {
      "code" : "A0335041G0",
      "display" : "IBUPROFEN TABLETS 400MG \"SINPHAR\""
    },
    {
      "code" : "A033505100",
      "display" : "MEBENDAZOLE TABLETS 100MG \"SINPHAR\""
    },
    {
      "code" : "A033506100",
      "display" : "OXELADINE TABLETS 20MG \"SINPHAR\""
    },
    {
      "code" : "A033509100",
      "display" : "ANETHOLE S.C. TABLETS 25MG (ANETHOLE TRITHIONE)\"SINPHAR\""
    },
    {
      "code" : "A033510100",
      "display" : "RIBRIN CAPSULES 10MG (CHLORDIAZEPOXIDE HCL)\"SINPHAR\""
    },
    {
      "code" : "A033511100",
      "display" : "TSUNG YAN S.C. TABLETS \"SINPHAR\""
    },
    {
      "code" : "A033512100",
      "display" : "A.D. VITAMIN S.C. TABLETS \"SINPHAR\""
    },
    {
      "code" : "A033513100",
      "display" : "CIPHMIN TABLETS \"SINPHAR \""
    },
    {
      "code" : "A033518100",
      "display" : "AN ANTLER HORMON CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A033520329",
      "display" : "RINA OINTMENT \"SINPHAR\""
    },
    {
      "code" : "A033521180",
      "display" : "COUGH POWDER \"SINPHAR\""
    },
    {
      "code" : "A033522100",
      "display" : "PYRITON CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A033525100",
      "display" : "PU RI SU CAPSULE \"SINPHAR\""
    },
    {
      "code" : "A033529100",
      "display" : "ANETHOLE CAPSULES 25MG \"SINPHAR\""
    },
    {
      "code" : "A033531100",
      "display" : "LYSOZYME TABLETS 90MG \"SINPHAR\""
    },
    {
      "code" : "A033532100",
      "display" : "ANPIRIN TABLETS \"SINPHAR\""
    },
    {
      "code" : "A033533100",
      "display" : "ETHAVERINE CAPSULES 100MG (ETHAVERINE HCL)\"SINPHAR\""
    },
    {
      "code" : "A033534100",
      "display" : "N-METHYLSCOPOLAMINE METHYLSULFATE S.C TABLETS 1MG \"SINPHAR\""
    },
    {
      "code" : "A033536372",
      "display" : "NITROFURAZONE OINTMENT 2MG/GM \"SINPHAR\""
    },
    {
      "code" : "A033536399",
      "display" : "NITROFURAZONE OINTMENT 2MG/GM \"SINPHAR\""
    },
    {
      "code" : "A0335363CH",
      "display" : "NITROFURAZONE OINTMENT 2MG/GM \"SINPHAR\""
    },
    {
      "code" : "A033537100",
      "display" : "PROHEPAM CAPSULES \"SINPHAR\""
    },
    {
      "code" : "A033539212",
      "display" : "SAGEMYCIN INJECTION 50MG/ML (SISOMICIN)\"PURZER\""
    },
    {
      "code" : "A033540100",
      "display" : "RECEF CAPSULE 250MG (CEPHRADINE)\"PURZER\""
    },
    {
      "code" : "A033541421",
      "display" : "Oralog Orabase 1mg/g \"Purzer\" (Triamcinolone)"
    },
    {
      "code" : "A033541423",
      "display" : "Oralog Orabase 1mg/g \"Purzer\" (Triamcinolone)"
    },
    {
      "code" : "A033544100",
      "display" : "MEPHAN TABLET 30MG (DEXTROMETHORPHAN) \"PURZER\""
    },
    {
      "code" : "A033545100",
      "display" : "CLOFEN E.C TABLET 50MG (DICLOFENAC)\"PURZER\""
    },
    {
      "code" : "A033546100",
      "display" : "CLOFEN E.C TABLET 25MG (DICLOFENAC)\"PURZER\""
    },
    {
      "code" : "A033547212",
      "display" : "ANTHIMIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033548212",
      "display" : "C-B COMPLEX INJECTION \"T.F.\""
    },
    {
      "code" : "A033549238",
      "display" : "NEO METHION B INJECTION \"T.F.\""
    },
    {
      "code" : "A033550100",
      "display" : "ACETAMINOPHEN CAPSULES 500MG \"SINPHAR\""
    },
    {
      "code" : "A033551100",
      "display" : "DIAZEPAM TABLETS 2MG \"SINPHAR\""
    },
    {
      "code" : "A033552100",
      "display" : "SHADES TABLETS \"SINPHAR\""
    },
    {
      "code" : "A033553100",
      "display" : "PRIPERIM S.C. TABLETS 10MG \"SINPHAR\" (METOCLOPRAMIDE HCL)"
    },
    {
      "code" : "A033554100",
      "display" : "INDOMETHACIN CAPSULES 25MG \"SINPHAR\""
    },
    {
      "code" : "A033557100",
      "display" : "METRONIDAZOLE TABLETS 250MG \"SINPHAR\""
    },
    {
      "code" : "A0335571G0",
      "display" : "METRONIDAZOLE TABLETS 250MG \"SINPHAR\""
    },
    {
      "code" : "A033558212",
      "display" : "NEO HUSTEN INJECTION \"T. F.\""
    },
    {
      "code" : "A033559212",
      "display" : "DIAPYRIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033560212",
      "display" : "BERBENOL INJECTION \"T.F.\""
    },
    {
      "code" : "A033561221",
      "display" : "ANTI-ULCER INJECTION \"T.F.\""
    },
    {
      "code" : "A033562238",
      "display" : "GLUCURON DEXTROSE INJECTION \"T.F.\""
    },
    {
      "code" : "A033563212",
      "display" : "Antico Injection 5mg/ml \"T.F.\""
    },
    {
      "code" : "A033564212",
      "display" : "OBALLERGEN-H INJECTION \"T.F.\""
    },
    {
      "code" : "A033565212",
      "display" : "REHISTAPYRIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033566209",
      "display" : "RE-HISTAMIN INJECTION 30MG/ML (DIPHENHYDRAMINE)\"T.F.\""
    },
    {
      "code" : "A033567209",
      "display" : "PHENOATO INJECTION \"T.F.\""
    },
    {
      "code" : "A033568209",
      "display" : "EMETINE HYDROCHLORIDE INJECTION 40MG/ML \"T.F.\""
    },
    {
      "code" : "A033569212",
      "display" : "DIPHYLLIN-M INJECTION 150MG/ML \"T.F.\""
    },
    {
      "code" : "A033570238",
      "display" : "STOPAIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033571248",
      "display" : "RND Lyo-Injection 50mg \"Standard\" (Ranitidine)"
    },
    {
      "code" : "A033572212",
      "display" : "CLINDAMYCIN INJECTION 150MG/ML \"CCPC\""
    },
    {
      "code" : "A033573100",
      "display" : "TERFEDANE TABLETS 60MG (TERFENADINE)\"H.S.C.\""
    },
    {
      "code" : "A033575129",
      "display" : "DEFENSE SUSPENSION 20MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A033575177",
      "display" : "DEFENSE SUSPENSION 20MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A033575199",
      "display" : "DEFENSE SUSPENSION 20MG/ML (CIMETIDINE)"
    },
    {
      "code" : "A033577100",
      "display" : "TOEY TABLETS 10MG (OXETHAZAINE) \"CHIN TENG\""
    },
    {
      "code" : "A033578338",
      "display" : "Clomold Ointment 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A033578372",
      "display" : "Clomold Ointment 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A033578399",
      "display" : "Clomold Ointment 0.5mg/gm\"T.F.\""
    },
    {
      "code" : "A033579100",
      "display" : "CALCIUM CARBONATE TABLETS 500MG \"CHIN TENG\""
    },
    {
      "code" : "A033582238",
      "display" : "SODIUM ACETATE INJECTION 4MEQ/ML \"SYNMOSA\""
    },
    {
      "code" : "A033583229",
      "display" : "PROPOR INJECTION 0.1％ (PROTOPORPHYRIN)\"T.F.\""
    },
    {
      "code" : "A033584212",
      "display" : "MYANESIN INJECTION 100MG/ML \"T.F.\""
    },
    {
      "code" : "A033585209",
      "display" : "OBNAUSEANT INJECTION 5MG/ML (PERPHENAZINE)\"T.F.\""
    },
    {
      "code" : "A033586238",
      "display" : "SALSOBROCAROSE INJECTION \"T.F.\""
    },
    {
      "code" : "A033587109",
      "display" : "VITAFONCAL GRANULES"
    },
    {
      "code" : "A033587157",
      "display" : "VITAFONCAL GRANULES"
    },
    {
      "code" : "A033587199",
      "display" : "VITAFONCAL GRANULES"
    },
    {
      "code" : "A033588100",
      "display" : "URIBRONE TABELETS 50MG \"W.P.\""
    },
    {
      "code" : "A033589212",
      "display" : "RANNINE INJECTION 25MG/ML (RANITIDINE)\"S.Y.\""
    },
    {
      "code" : "A033590312",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590316",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590317",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590319",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590321",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590323",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590325",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590326",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590329",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590355",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590372",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590377",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033590399",
      "display" : "DEVIRUS CREAM 50MG/G (ACYCLOVIR) \"WINSTON\""
    },
    {
      "code" : "A033591100",
      "display" : "THIAMPHENICOL CAPSULES 250MG \"Y.C.\""
    },
    {
      "code" : "A033592100",
      "display" : "HINICOL CAPSULES 250MG"
    },
    {
      "code" : "A033593211",
      "display" : "TRANEXAMIC ACID INJECTION 50MG/ML \"T.F.\""
    },
    {
      "code" : "A033593221",
      "display" : "TRANEXAMIC ACID INJECTION 50MG/ML \"T.F.\""
    },
    {
      "code" : "A033594212",
      "display" : "METOPERAN INJECTION 5MG/ML (METOCLOPRAMIDE)\"T.F.\""
    },
    {
      "code" : "A033595212",
      "display" : "FUROSEMIDE IV INJECTION 10MG/ML \"T.F.\""
    },
    {
      "code" : "A033596212",
      "display" : "LIDOCAINE HYDROCHLORIDE INJECTION 2％ \"T.F.\""
    },
    {
      "code" : "A033596238",
      "display" : "LIDOCAINE HYDROCHLORIDE INJECTION 2％ \"T.F.\""
    },
    {
      "code" : "A033597212",
      "display" : "DIAZEPAM INJECTION 5MG/ML \"T.F.\""
    },
    {
      "code" : "A033598209",
      "display" : "PAOSU COAN INJECTION 20MG/ML \"T.F.\""
    },
    {
      "code" : "A033599100",
      "display" : "CHIYUANPIN E.C. TABLETS (CHYMOTRYPSIN)"
    },
    {
      "code" : "A033600100",
      "display" : "ANEDANE S.C. TABLETS 12.5MG (ANETHOLE)\"M.S.\""
    },
    {
      "code" : "A033601100",
      "display" : "CHIFONCON TABLETS 50MG (DIMETHICONE)\"M.S.\""
    },
    {
      "code" : "A033603100",
      "display" : "BENZYDAMIN CAPSULE 50MG \"M.S.\""
    },
    {
      "code" : "A033605329",
      "display" : "FUSHUNDER OINTMENT \"M.S.\""
    },
    {
      "code" : "A033605372",
      "display" : "FUSHUNDER OINTMENT \"M.S.\""
    },
    {
      "code" : "A033606100",
      "display" : "RIFAMPICIN CAPSULES 150MG \"M.S.\""
    },
    {
      "code" : "A033609100",
      "display" : "KEZINTEA TABLETS \"M.S.\""
    },
    {
      "code" : "A033610100",
      "display" : "PEBENTEA CAPSULES \"M.S.\""
    },
    {
      "code" : "A033613100",
      "display" : "AZUNOL TABLETS 2MG \"M.S.\""
    },
    {
      "code" : "A033614100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"M.S.\""
    },
    {
      "code" : "A033615100",
      "display" : "ATENOL TABLETS 100MG (ATENOLOL) \"M.S.\""
    },
    {
      "code" : "A033618100",
      "display" : "PRIPRAM TABLETS 5MG (METOCLOPRAMIDE)\"M.S.\""
    },
    {
      "code" : "A033619100",
      "display" : "KUETONBILY TABLETS 10MG (DICYCLOMINE) \"M.S.\""
    },
    {
      "code" : "A033621100",
      "display" : "KANYEN CAPSULES 200MG (FLUFENAMIC ACID)\"M.S.\""
    },
    {
      "code" : "A033622100",
      "display" : "FULCIN S.C. TABLETS 12.5MG (DIPYRIDAMOLE)\"M.S.\""
    },
    {
      "code" : "A033625100",
      "display" : "INTESTICIN TABLETS \"M.S.\""
    },
    {
      "code" : "A033628100",
      "display" : "SUCOPANLIN CAPSULES 10MG (HYOSEINE-N-BUTYL BROMIDE)\"M.S.\""
    },
    {
      "code" : "A033630100",
      "display" : "UROPYRIN S.C. TABLETS 100MG (PHENAZOPYRIDINE)\"M.S.\""
    },
    {
      "code" : "A033631100",
      "display" : "MEKEZOLE TABLETS 100MG (MEBENDAZOLE)\"M.S.\""
    },
    {
      "code" : "A033664100",
      "display" : "MESYREL TABLETS 50MG \"LOTUS\""
    },
    {
      "code" : "A033665100",
      "display" : "GYM-NOR CAPSULES 75MG (PHENYLPROPANOLAMINE) \"M.S.\""
    },
    {
      "code" : "A033675100",
      "display" : "DECLOT F.C. TABLETS 100MG  \"WEIDAR\" (TICLOPIDINE)"
    },
    {
      "code" : "A033676100",
      "display" : "MULAX TABLETS 10MG (BACLOFEN)"
    },
    {
      "code" : "A033677329",
      "display" : "FORMAX GEL 10MG/GM (DICLOFENAC SODIUM) \"SHITEH\""
    },
    {
      "code" : "A033677335",
      "display" : "FORMAX GEL 10MG/GM (DICLOFENAC SODIUM) \"SHITEH\""
    },
    {
      "code" : "A033677338",
      "display" : "FORMAX GEL 10MG/GM (DICLOFENAC SODIUM) \"SHITEH\""
    },
    {
      "code" : "A033677343",
      "display" : "FORMAX GEL 10MG/GM (DICLOFENAC SODIUM) \"SHITEH\""
    },
    {
      "code" : "A033683277",
      "display" : "SORBITOL INJECTION 5％ \"S.Y.\""
    },
    {
      "code" : "A033684190",
      "display" : "TINCOUGH POWDER \"DAU CHI\""
    },
    {
      "code" : "A033686100",
      "display" : "CALCIUM CARBONATE TABLETS 500MG \"Y.S\""
    },
    {
      "code" : "A033691100",
      "display" : "ANULCUS TABLETS 400MG (CIMETIDINE) \"T.A.\""
    },
    {
      "code" : "A033695212",
      "display" : "LIDOCAINE HCL INJECTION \"WINSTON\""
    },
    {
      "code" : "A033698209",
      "display" : "VETERIN (CEFAZOLIN) FOR INJECTION \"VPP\""
    },
    {
      "code" : "A033698265",
      "display" : "VETERIN (CEFAZOLIN) FOR INJECTION \"VPP\""
    },
    {
      "code" : "A033698277",
      "display" : "VETERIN (CEFAZOLIN) FOR INJECTION \"VPP\""
    },
    {
      "code" : "A033699100",
      "display" : "VOREN ENTERIC-MICROENCAPSULATED CAPSULES 50MG (DICLOFENAC)"
    },
    {
      "code" : "A0336991G0",
      "display" : "VOREN ENTERIC-MICROENCAPSULATED CAPSULES 50MG (DICLOFENAC)"
    },
    {
      "code" : "A033700238",
      "display" : "PLUSAMIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033701100",
      "display" : "MEFENA CAPSULES 250MG (MEFENAMIC ACID) \"KOJAR\""
    },
    {
      "code" : "A0337011G0",
      "display" : "MEFENA CAPSULES 250MG (MEFENAMIC ACID) \"KOJAR\""
    },
    {
      "code" : "A033729329",
      "display" : "ISORADIN CREAM  \"YUNG SHIN\""
    },
    {
      "code" : "A033729355",
      "display" : "ISORADIN CREAM  \"YUNG SHIN\""
    },
    {
      "code" : "A033729399",
      "display" : "ISORADIN CREAM  \"YUNG SHIN\""
    },
    {
      "code" : "A033730309",
      "display" : "MYCOSON CREAM 10MG/G \"S.Y.\" (BIFONAZOLE)"
    },
    {
      "code" : "A033730329",
      "display" : "MYCOSON CREAM 10MG/G \"S.Y.\" (BIFONAZOLE)"
    },
    {
      "code" : "A033730372",
      "display" : "MYCOSON CREAM 10MG/G \"S.Y.\" (BIFONAZOLE)"
    },
    {
      "code" : "A033730399",
      "display" : "MYCOSON CREAM 10MG/G \"S.Y.\" (BIFONAZOLE)"
    },
    {
      "code" : "A033733100",
      "display" : "CEGELIN TABLETS 200MG (BEZAFIBRATE) \"YUNG CHI\""
    },
    {
      "code" : "A033735100",
      "display" : "BAYPRESS TABLET 10MG (NITRENDIPINE)"
    },
    {
      "code" : "A033737100",
      "display" : "LEDERPROFEN F.C. TABLETS 400MG (IBUPROFEN)"
    },
    {
      "code" : "A033738320",
      "display" : "DEVIRO OPHTHALMIC OINTMENT 3％ (ACYCLOVIR)"
    },
    {
      "code" : "A033738321",
      "display" : "DEVIRO OPHTHALMIC OINTMENT 3％ (ACYCLOVIR)"
    },
    {
      "code" : "A033740219",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033740226",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033740230",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033740236",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033740238",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033740299",
      "display" : "HINICOL INJECTION"
    },
    {
      "code" : "A033757238",
      "display" : "GLUCOSE INJECTION 50％ \"T.F.\""
    },
    {
      "code" : "A033758212",
      "display" : "TAURINE B INJECTION \"T.F.\""
    },
    {
      "code" : "A033760212",
      "display" : "ANTIDOTALGEN INJECTION \"T.F.\""
    },
    {
      "code" : "A033761209",
      "display" : "EPIRENAMIN HYDROCHLORIDE INJECTION 1MG/ML (EPINEPHRINE)\"T.F.\""
    },
    {
      "code" : "A033763209",
      "display" : "ATROPINE SULFATE INJECTION 1MG/ML \"T.F.\""
    },
    {
      "code" : "A033765209",
      "display" : "ASTHNARIN-O INJECTION \"T.F.\""
    },
    {
      "code" : "A033766212",
      "display" : "CAFFEINE & SODIUM BENZOATE INJECTION 100MG/ML \"T.F.\""
    },
    {
      "code" : "A033767209",
      "display" : "METHYLEPHEDRINE HYDROCHLORIDE INJECTION 40MG/ML \"T.F.\""
    },
    {
      "code" : "A033768209",
      "display" : "NICORAMIN INJECTION 250MG/ML (NIKETHAMIDE)\"T.F.\""
    },
    {
      "code" : "A033769209",
      "display" : "ERGOSPA INJECTION \"T.F.\""
    },
    {
      "code" : "A033771209",
      "display" : "OUABAIN INJECTION 0.075MG/ML \"T.F.\""
    },
    {
      "code" : "A033773209",
      "display" : "Tunnacort Injection 40mg/ml \"T.F.\""
    },
    {
      "code" : "A033773229",
      "display" : "Tunnacort Injection 40mg/ml \"T.F.\""
    },
    {
      "code" : "A033773271",
      "display" : "Tunnacort Injection 40mg/ml \"T.F.\""
    },
    {
      "code" : "A033774100",
      "display" : "DAILY-PLUS CHEWABLE TABLET 0.5MG (HYDROXOCOBALAMIN ACETATE )\"SHITEH\""
    },
    {
      "code" : "A033820100",
      "display" : "KERMINE TABLETS 60MG (TERFENADINE)\"Y.C.\""
    },
    {
      "code" : "A033821100",
      "display" : "AMBROXOL TABLETS 30MG \"SINTON\""
    },
    {
      "code" : "A033822100",
      "display" : "ISOPERDINE TABLETS 40MG \"S.L.\""
    },
    {
      "code" : "A033823100",
      "display" : "PREDNISOLONE 5MG TABLETS \"Y.Y.\""
    },
    {
      "code" : "A0338231G0",
      "display" : "PREDNISOLONE 5MG TABLETS \"Y.Y.\""
    },
    {
      "code" : "A0338231G5",
      "display" : "PREDNISOLONE 5MG TABLETS \"Y.Y.\""
    },
    {
      "code" : "A033825100",
      "display" : "NIGOLINE TABLETS 10MG (NICERGOLINE) \"Y.C.\""
    },
    {
      "code" : "A033827151",
      "display" : "POLIAN LIQUID"
    },
    {
      "code" : "A033827199",
      "display" : "POLIAN LIQUID"
    },
    {
      "code" : "A033828100",
      "display" : "AIRCRIT TABLETS 100MG (ATENOLOL) \"H.S.\""
    },
    {
      "code" : "A033829100",
      "display" : "MOTON TABLETS 500MG \"YU SHENG\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A033830329",
      "display" : "HUAN HSI CREAM 0.6MG/GM (ESTRADIOL) \"CHINTENG\""
    },
    {
      "code" : "A033830372",
      "display" : "HUAN HSI CREAM 0.6MG/GM (ESTRADIOL) \"CHINTENG\""
    },
    {
      "code" : "A033830399",
      "display" : "HUAN HSI CREAM 0.6MG/GM (ESTRADIOL) \"CHINTENG\""
    },
    {
      "code" : "A033831100",
      "display" : "SONILIN CAPSULES"
    },
    {
      "code" : "A033832100",
      "display" : "LOPUNING TABLETS 100MG \"G.T.\" (ALLOPURINOL)"
    },
    {
      "code" : "A033854100",
      "display" : "NOSCAPINE HYDROCHLORIDE TABLETS 20MG \"T.F.\""
    },
    {
      "code" : "A033855100",
      "display" : "MUDAMIN TABLETS"
    },
    {
      "code" : "A033856100",
      "display" : "DIAZEJIN TABLETS"
    },
    {
      "code" : "A033858100",
      "display" : "NUGACHENIN TABLETS"
    },
    {
      "code" : "A033861100",
      "display" : "PAPAVERINE HCL CAPSULES \"B.C.\""
    },
    {
      "code" : "A033862100",
      "display" : "METROCIDE CAPSULES 250MG  \"T.F.\"(METRONIDAZOLE)"
    },
    {
      "code" : "A033864277",
      "display" : "SUDERIN INJECTION 0.9GM (LYSINE ACETYLSALICYLATE)\"UNION\""
    },
    {
      "code" : "A033866221",
      "display" : "OBALLERCAL INJECTION \"T.F.\""
    },
    {
      "code" : "A033867209",
      "display" : "EPHEDRINE INJECTION 40MG/ML \"T.F.\""
    },
    {
      "code" : "A033868100",
      "display" : "ORULIN CAPSULES \"F.Y.\""
    },
    {
      "code" : "A033869100",
      "display" : "SLITONIN TABLETS"
    },
    {
      "code" : "A033870100",
      "display" : "VIPEINS CAPSULE"
    },
    {
      "code" : "A033871100",
      "display" : "FORLIVER CAPSULES 150MG \"ROOT\" (SILYBIN)"
    },
    {
      "code" : "A0338711G0",
      "display" : "FORLIVER CAPSULES 150MG \"ROOT\" (SILYBIN)"
    },
    {
      "code" : "A033872100",
      "display" : "CIKETIN TABLETS 200MG (CIMETIDINE) \"UNION\""
    },
    {
      "code" : "A0338721G0",
      "display" : "CIKETIN TABLETS 200MG (CIMETIDINE) \"UNION\""
    },
    {
      "code" : "A033873209",
      "display" : "Oxocin Injection 10IU/ml \"T.F.\""
    },
    {
      "code" : "A033873229",
      "display" : "Oxocin Injection 10IU/ml \"T.F.\""
    },
    {
      "code" : "A033875209",
      "display" : "ERCIN INJECTION \"T.F.\""
    },
    {
      "code" : "A033876221",
      "display" : "REHISTACAL B6 INJECTION \"T.F.\""
    },
    {
      "code" : "A033877221",
      "display" : "VITA. K INJECTION 20MG/ML (MENADIONE)\"T.F.\""
    },
    {
      "code" : "A033881100",
      "display" : "ANNA-FRIEND CAPSULES 200MG \"TAIWAN TUNG YANG\" (IBUPROFEN)"
    },
    {
      "code" : "A033882100",
      "display" : "ANACIN-3 F.C. TABLET 500MG (ACETAMINOPHEN)"
    },
    {
      "code" : "A033883100",
      "display" : "EXSOL CAPSULES 100MG (OXOLAMINE CITRATE) \"Y.Y.\""
    },
    {
      "code" : "A0338831G0",
      "display" : "EXSOL CAPSULES 100MG (OXOLAMINE CITRATE) \"Y.Y.\""
    },
    {
      "code" : "A033884100",
      "display" : "MEYUAN TABLET 100MG (MEPIRIZOLE) \"YUNG SINE\""
    },
    {
      "code" : "A033885100",
      "display" : "U-CAL TABLETS 500MG (CALCIUM CARBONATE)"
    },
    {
      "code" : "A033886209",
      "display" : "HEMAFALL INJECTION 2.5MG/ML (BENDROFLUMETHIAZIDE)\"T.F.\""
    },
    {
      "code" : "A033887309",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887321",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887329",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887338",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887343",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887372",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033887399",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A0338873B9",
      "display" : "ENFULON CREAM 1MG/GM (DIFLUCORTOLONE) \"GCPC\""
    },
    {
      "code" : "A033888100",
      "display" : "TEMPTE TABLETS 500MG (ACETAMINOPHEN)"
    },
    {
      "code" : "A033889100",
      "display" : "SUSHEU TABLETS 200MG (BEZAFIBRATE) \"SINTON\""
    },
    {
      "code" : "A033890100",
      "display" : "LIGAT TABLETS 100MG (URSODEOXYCHOLIC ACID)"
    },
    {
      "code" : "A033891109",
      "display" : "ACETYLCYSTEINE GRANULES 66.67MG/GM \"T.F.\""
    },
    {
      "code" : "A033891116",
      "display" : "ACETYLCYSTEINE GRANULES 66.67MG/GM \"T.F.\""
    },
    {
      "code" : "A033892100",
      "display" : "TRANEXAMIC ACID TABLETS 250MG \"ASTAR\""
    },
    {
      "code" : "A033894100",
      "display" : "DECA TABLETS 0.75MG (DEXAMETHASONE)\"KOJAR\""
    },
    {
      "code" : "A0338941G0",
      "display" : "DECA TABLETS 0.75MG (DEXAMETHASONE)\"KOJAR\""
    },
    {
      "code" : "A033896100",
      "display" : "SUWEIDA TABLETS 10MG (DOMPERIDONE)\"S.C.\""
    },
    {
      "code" : "A033897100",
      "display" : "VASODIL TABLET 25MG (CAPTORIL) \"TAIWAN TUNG YANG\""
    },
    {
      "code" : "A033899100",
      "display" : "INOLIM TABLETS 3MG (TRIMETOQUINOL) \"M.S\""
    },
    {
      "code" : "A033900100",
      "display" : "SINLIHAUL TABLETS 40MG (PROPRANOLOL) \"H.S.\""
    },
    {
      "code" : "A0339001G0",
      "display" : "SINLIHAUL TABLETS 40MG (PROPRANOLOL) \"H.S.\""
    },
    {
      "code" : "A033901100",
      "display" : "POTAN TABLETS 500MG \"H.S.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A0339011G0",
      "display" : "POTAN TABLETS 500MG \"H.S.\" (MEFENAMIC ACID)"
    },
    {
      "code" : "A033902100",
      "display" : "BIESCON CAPSULES"
    },
    {
      "code" : "A033907209",
      "display" : "LYO-HINICOL INJECTION 1GM"
    },
    {
      "code" : "A033910100",
      "display" : "CAPTOPIN TABLETS 25MG (CAPTOPRIL) \"B & F\""
    },
    {
      "code" : "A033912163",
      "display" : "GASTRACIN LIQUID"
    },
    {
      "code" : "A033913100",
      "display" : "ANLESO TABLETS 30MG (AMBROXOL) \"YUNG CHI\""
    },
    {
      "code" : "A033914277",
      "display" : "MALTOSE INJECTION 10％ \"S.Y.\""
    },
    {
      "code" : "A033915100",
      "display" : "CAPTOPIN TABLETS 12.5MG (CAPTOPRIL) \"B & F\""
    },
    {
      "code" : "A033920209",
      "display" : "PHENOBITAL INJECTION 100MG/ML \"T.F.\""
    },
    {
      "code" : "A033921100",
      "display" : "Culcer Extra F.C. Tablets 150mg"
    },
    {
      "code" : "A033922277",
      "display" : "LACT-RINGER INJECTION \"S.Y.\""
    },
    {
      "code" : "A033924100",
      "display" : "SILZEM TABLETS 30MG (DILTIAZEM HCL) \"S.L.\""
    },
    {
      "code" : "A033925216",
      "display" : "DICLOFENAC INJECTION 25MG/ML \"ASTAR\""
    },
    {
      "code" : "A033926118",
      "display" : "AMSOLVON LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A033926151",
      "display" : "AMSOLVON LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A033926157",
      "display" : "AMSOLVON LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A033926199",
      "display" : "AMSOLVON LIQUID 3MG/ML (AMBROXOL HYDROCHLORIDE)"
    },
    {
      "code" : "A033927100",
      "display" : "L.K.T E.C.TABLETS 50MG \"C.H.\""
    },
    {
      "code" : "A033929100",
      "display" : "LARPAM TABLETS 2MG (LORAZEPAM) \"CHEN TA\""
    },
    {
      "code" : "A0339291G0",
      "display" : "LARPAM TABLETS 2MG (LORAZEPAM) \"CHEN TA\""
    },
    {
      "code" : "A033930330",
      "display" : "ENUEN CREAM 0.05％ (CLOBETASONE)"
    },
    {
      "code" : "A033930399",
      "display" : "ENUEN CREAM 0.05％ (CLOBETASONE)"
    },
    {
      "code" : "A033932100",
      "display" : "TETRACYCLINE HYDROCHLORIDE CAPSULES 500MG \"ROOT\""
    },
    {
      "code" : "A0339321G0",
      "display" : "TETRACYCLINE HYDROCHLORIDE CAPSULES 500MG \"ROOT\""
    },
    {
      "code" : "A033933100",
      "display" : "CARBIZO TABLETS 10MG \"YU SHENG\" (CARBIMAZOLE)"
    },
    {
      "code" : "A033935209",
      "display" : "CEFTAM INJECTION 0.5GM,1GM,2GM (CEFOTAXIME SODIUM) \"LITA\""
    },
    {
      "code" : "A033935212",
      "display" : "CEFTAM INJECTION 0.5GM,1GM,2GM (CEFOTAXIME SODIUM) \"LITA\""
    },
    {
      "code" : "A033935277",
      "display" : "CEFTAM INJECTION 0.5GM,1GM,2GM (CEFOTAXIME SODIUM) \"LITA\""
    },
    {
      "code" : "A033936100",
      "display" : "ILOMYCIN CAPSULES 250MG (ERYTHROMYCIN ESTOLATE) \"Y.C\""
    },
    {
      "code" : "A033938329",
      "display" : "FUNGIN CREAM 10MG/GM \"SWISS\" (BIFONAZOLE)"
    },
    {
      "code" : "A033938335",
      "display" : "FUNGIN CREAM 10MG/GM \"SWISS\" (BIFONAZOLE)"
    },
    {
      "code" : "A033938372",
      "display" : "FUNGIN CREAM 10MG/GM \"SWISS\" (BIFONAZOLE)"
    },
    {
      "code" : "A033938399",
      "display" : "FUNGIN CREAM 10MG/GM \"SWISS\" (BIFONAZOLE)"
    },
    {
      "code" : "A033939100",
      "display" : "ABROXOL TABLETS 30MG (AMBROXOL HYDROCHLORIDE) \"JOHNSON\""
    },
    {
      "code" : "A033940277",
      "display" : "UZOLIN INJECTION 500MG (CEPHAZOLIN) \"UNION\""
    },
    {
      "code" : "A033942212",
      "display" : "TOPRAMYCIN INJECTION 40MG/ML (TOBRAMYCIN) \"PANBIOTIC\""
    },
    {
      "code" : "A033942221",
      "display" : "TOPRAMYCIN INJECTION 40MG/ML (TOBRAMYCIN) \"PANBIOTIC\""
    },
    {
      "code" : "A033943329",
      "display" : "CHENG HOU CREAM \"C.T\""
    },
    {
      "code" : "A033943372",
      "display" : "CHENG HOU CREAM \"C.T\""
    },
    {
      "code" : "A033943399",
      "display" : "CHENG HOU CREAM \"C.T\""
    },
    {
      "code" : "A033945216",
      "display" : "VOTAN INJECTION 25MG/ML"
    },
    {
      "code" : "A033947100",
      "display" : "EMETROL TABLET 10MG (DOMPERIDONE)"
    },
    {
      "code" : "A0339471G0",
      "display" : "EMETROL TABLET 10MG (DOMPERIDONE)"
    },
    {
      "code" : "A033949118",
      "display" : "BISUHOW SOLUTION \"CHINTENG\""
    },
    {
      "code" : "A033949199",
      "display" : "BISUHOW SOLUTION \"CHINTENG\""
    },
    {
      "code" : "A033950100",
      "display" : "N.F.S. F.C.T. 100MG  \"C.H.\" (NORFLOXACIN)"
    },
    {
      "code" : "A033959100",
      "display" : "DROWSY TABLETS 0.25MG  \"H.S\""
    },
    {
      "code" : "A033960100",
      "display" : "CLEDOMYCIN CAPSULES 150MG \"ASTAR\" (CLINDAMYCIN)"
    },
    {
      "code" : "A033961100",
      "display" : "IPUFEN F.C. TABLETS 400MG \"CHINTENG\"(IBUPROFEN)"
    },
    {
      "code" : "A0339611G0",
      "display" : "IPUFEN F.C. TABLETS 400MG \"CHINTENG\"(IBUPROFEN)"
    },
    {
      "code" : "A033962100",
      "display" : "COTAZYM CAPSULES"
    },
    {
      "code" : "A033964100",
      "display" : "TAIMAC TABLETS 480MG (MAGALDRATE)"
    },
    {
      "code" : "A033966229",
      "display" : "LINCOMYCIN INJECTION 300MG/ML \"SINTON\""
    },
    {
      "code" : "A033966238",
      "display" : "LINCOMYCIN INJECTION 300MG/ML \"SINTON\""
    },
    {
      "code" : "A033968417",
      "display" : "CLEO EYE DROP 3MG/ML (TOBRAMYCIN) \"PURZER\""
    },
    {
      "code" : "A033969100",
      "display" : "SHEUAN TABLET 200MG (FLAVOXATE) \"SINTON\""
    },
    {
      "code" : "A033970100",
      "display" : "FLUNARCA TABLET 10MG (FLUNARIZINE) \"SINTON\""
    },
    {
      "code" : "A033971100",
      "display" : "LEDOLIUM \"C.L.\""
    },
    {
      "code" : "A033973109",
      "display" : "TIDACT GRANULES 37.5MG/GM (CLINDAMYCIN)"
    },
    {
      "code" : "A033973199",
      "display" : "TIDACT GRANULES 37.5MG/GM (CLINDAMYCIN)"
    },
    {
      "code" : "A033990100",
      "display" : "GASAFE F.C. TABLETS 20MG (FAMOTIDINE)"
    },
    {
      "code" : "A033991100",
      "display" : "BRUFEN S.C. TABLETS 400MG (IBUPROFEN)"
    },
    {
      "code" : "A033992209",
      "display" : "TESTOMON DEPOT INJECTION \"T.F.\""
    },
    {
      "code" : "A033993209",
      "display" : "TESTODIOL INJECTION \"T.F.\""
    },
    {
      "code" : "A033994209",
      "display" : "TESTODIOL DEPOT INJECTION \"T.F.\""
    },
    {
      "code" : "A033997118",
      "display" : "ANTI-PHEN INFANTS' DROPS 100MG/ML \"CENTER\""
    },
    {
      "code" : "A033997199",
      "display" : "ANTI-PHEN INFANTS' DROPS 100MG/ML \"CENTER\""
    },
    {
      "code" : "A033998165",
      "display" : "MAGVAC ORAL SOLUTION"
    },
    {
      "code" : "A033999100",
      "display" : "USOMONO TABLETS 20MG (ISOSORBIDE) \"U-LIANG\""
    },
    {
      "code" : "A0339991G0",
      "display" : "USOMONO TABLETS 20MG (ISOSORBIDE) \"U-LIANG\""
    },
    {
      "code" : "A034000118",
      "display" : "AXOL LIQUID 3MG/ML (AMBROXOL) \"YUNG SHIN\""
    },
    {
      "code" : "A034000151",
      "display" : "AXOL LIQUID 3MG/ML (AMBROXOL) \"YUNG SHIN\""
    },
    {
      "code" : "A034000199",
      "display" : "AXOL LIQUID 3MG/ML (AMBROXOL) \"YUNG SHIN\""
    },
    {
      "code" : "A034001335",
      "display" : "ANSILIN OINTMENT 5MG/GM (PIROXICAM)"
    },
    {
      "code" : "A034002100",
      "display" : "Cousel Tablets 20mg \"KOJAR\"(Tipepidine Hibenzate)"
    },
    {
      "code" : "A034003100",
      "display" : "WANIDINE CAPSULES 200MG (QUINIDINE SULFATE) \"WASHINGTON\""
    },
    {
      "code" : "A034004321",
      "display" : "ISOCORT CREAM"
    },
    {
      "code" : "A034004329",
      "display" : "ISOCORT CREAM"
    },
    {
      "code" : "A034004372",
      "display" : "ISOCORT CREAM"
    },
    {
      "code" : "A034004399",
      "display" : "ISOCORT CREAM"
    },
    {
      "code" : "A034005417",
      "display" : "OPTISONE EYE DROP"
    },
    {
      "code" : "A034005421",
      "display" : "OPTISONE EYE DROP"
    },
    {
      "code" : "A034008329",
      "display" : "BESOL CREAM 0.05％ \"C.H.\"  (CLOBETASOL)"
    },
    {
      "code" : "A034008377",
      "display" : "BESOL CREAM 0.05％ \"C.H.\"  (CLOBETASOL)"
    },
    {
      "code" : "A034008399",
      "display" : "BESOL CREAM 0.05％ \"C.H.\"  (CLOBETASOL)"
    },
    {
      "code" : "A034009100",
      "display" : "WAMIN TABLETS 60MG (TERFENADINE) \"W.P.\""
    },
    {
      "code" : "A034010238",
      "display" : "DEXTROSE 50％ INJECTION \"S.Y\""
    },
    {
      "code" : "A034011421",
      "display" : "LENSPURE EYE DROPS \"SINPHAR\""
    },
    {
      "code" : "A034013177",
      "display" : "ULWYCON SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A034013199",
      "display" : "ULWYCON SUSPENSION \"SINPHAR\""
    },
    {
      "code" : "A034014100",
      "display" : "NOYAN TABLETS 375MG \"WEIDAR\"(NAPROXEN)"
    },
    {
      "code" : "A034015317",
      "display" : "ANCLOZIN CREAM 50MG/GM \"ROOT\" (ACYCLOVIR)"
    },
    {
      "code" : "A034015321",
      "display" : "ANCLOZIN CREAM 50MG/GM \"ROOT\" (ACYCLOVIR)"
    },
    {
      "code" : "A034015365",
      "display" : "ANCLOZIN CREAM 50MG/GM \"ROOT\" (ACYCLOVIR)"
    },
    {
      "code" : "A034015372",
      "display" : "ANCLOZIN CREAM 50MG/GM \"ROOT\" (ACYCLOVIR)"
    },
    {
      "code" : "A034015399",
      "display" : "ANCLOZIN CREAM 50MG/GM \"ROOT\" (ACYCLOVIR)"
    },
    {
      "code" : "A034016100",
      "display" : "TICLOPINE S.C. TABLETS 100MG (TICLOPIDINE)\"EAYUNG\""
    },
    {
      "code" : "A034017100",
      "display" : "CABOTIN TABLETS 375MG (CARBOCYSTEINE) \"KOJAR\""
    },
    {
      "code" : "A034018100",
      "display" : "DECA TABLETS 0.5MG (DEXAMETHASONE) \"KOJAR\""
    },
    {
      "code" : "A0340181G0",
      "display" : "DECA TABLETS 0.5MG (DEXAMETHASONE) \"KOJAR\""
    },
    {
      "code" : "A034021100",
      "display" : "FLAVON TABLETS 200MG (FLAVOXATE) \"AND\""
    },
    {
      "code" : "A034022100",
      "display" : "MINMEN TABLET 60MG (TERFENADINE) \"SINTON\""
    },
    {
      "code" : "A034023100",
      "display" : "BRUFEN S.C. TABLETS 200MG (IBUPROFEN)"
    },
    {
      "code" : "A034028500",
      "display" : "PEDICOL SUPPOSITORIES 130MG (ASPIRIN) \"WEIDAR\""
    },
    {
      "code" : "A034029100",
      "display" : "BIO-BALANCE S.C. TABLETS 100MG (TIOPRONIN)\"SHITCH\""
    },
    {
      "code" : "A034032209",
      "display" : "CHEF FOR INJECTION (CEFTRIAXONE) \"PURZER\""
    },
    {
      "code" : "A034032277",
      "display" : "CHEF FOR INJECTION (CEFTRIAXONE) \"PURZER\""
    },
    {
      "code" : "A034033100",
      "display" : "RULID 150MG FILM COATED TABLET (ROXITHROMYCIN)"
    },
    {
      "code" : "A034036100",
      "display" : "VOLTAR E.C. TABLETS 50MG (DICLOFENAC) \"M.S\""
    },
    {
      "code" : "A034037100",
      "display" : "CEKODIN CAPSULES 250MG(CEPHRADINE)"
    },
    {
      "code" : "A034038100",
      "display" : "CEKODIN CAPSULES 500MG(CEPHRADINE)"
    },
    {
      "code" : "A034040321",
      "display" : "S.S. CREAM"
    },
    {
      "code" : "A034040324",
      "display" : "S.S. CREAM"
    },
    {
      "code" : "A034040329",
      "display" : "S.S. CREAM"
    },
    {
      "code" : "A034040399",
      "display" : "S.S. CREAM"
    },
    {
      "code" : "A034041500",
      "display" : "WEITUL SUPPOSITORIES 10MG (DOMPERIDONE) \"WEIDAR\""
    },
    {
      "code" : "A034044119",
      "display" : "COSICA LIQUID"
    },
    {
      "code" : "A034044151",
      "display" : "COSICA LIQUID"
    },
    {
      "code" : "A034044199",
      "display" : "COSICA LIQUID"
    },
    {
      "code" : "A034047109",
      "display" : "CEPHALEXIN GRANULE FOR SYRUP 200MG/GM \"SINTON\""
    },
    {
      "code" : "A034047177",
      "display" : "CEPHALEXIN GRANULE FOR SYRUP 200MG/GM \"SINTON\""
    },
    {
      "code" : "A034047199",
      "display" : "CEPHALEXIN GRANULE FOR SYRUP 200MG/GM \"SINTON\""
    },
    {
      "code" : "A034048500",
      "display" : "VOLTAR SUPPOSITORIES 12.5MG (DICLOFENAC) \"M.S\""
    },
    {
      "code" : "A034050109",
      "display" : "NEWTASE POWDER \"CHIN TENG\""
    },
    {
      "code" : "A034050157",
      "display" : "NEWTASE POWDER \"CHIN TENG\""
    },
    {
      "code" : "A034050199",
      "display" : "NEWTASE POWDER \"CHIN TENG\""
    },
    {
      "code" : "A034059100",
      "display" : "CIMEFINE F.C. TABLETS 400MG (CIMETIDINE)"
    },
    {
      "code" : "A0340591G0",
      "display" : "CIMEFINE F.C. TABLETS 400MG (CIMETIDINE)"
    },
    {
      "code" : "A034060100",
      "display" : "SUMON CAPSULES 100GM (AMANTADINE) \"SINTON\""
    },
    {
      "code" : "A034061500",
      "display" : "ISOGEN VAG. TABLET 100MG (ISOCONAZOLE) \"PURZER\""
    },
    {
      "code" : "A034062100",
      "display" : "SINTONFON TABLET 50MG (BENZBROMARONE) \"SINTON\""
    },
    {
      "code" : "A034065100",
      "display" : "MUCOSOLDIN TABLETS 30MG (AMBROXOL) \"P.J.\""
    },
    {
      "code" : "A034067277",
      "display" : "KLINITAMIN INJECTION"
    },
    {
      "code" : "A034068321",
      "display" : "BETNOVATE-N OINTMENT"
    },
    {
      "code" : "A034068335",
      "display" : "BETNOVATE-N OINTMENT"
    },
    {
      "code" : "A034069321",
      "display" : "BETNOVATE-N CREAM"
    },
    {
      "code" : "A034070421",
      "display" : "GENTAMYCIN OPHTHALMIC SOLUTION 3MG/ML \"WU-FU\""
    },
    {
      "code" : "A034071421",
      "display" : "TOBRAMYCIN OPHTHALMIC SOLUTION 3MG/ML \"WU-FU\""
    },
    {
      "code" : "A034072100",
      "display" : "Cimefine F.C. Tablets 200mg (cimetidine)"
    },
    {
      "code" : "A034073100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"TAIWAN TUNG YANG\""
    },
    {
      "code" : "A034074100",
      "display" : "DECADLIN TABLETS 0.5mg (DEXAMETHASONE) \"M.S\""
    },
    {
      "code" : "A034075100",
      "display" : "SOONANSIN TABLETS \"M.S\""
    },
    {
      "code" : "A034076212",
      "display" : "FORGAS INJECTION 10MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A034076219",
      "display" : "FORGAS INJECTION 10MG/ML \"PANBIOTIC\""
    },
    {
      "code" : "A034078100",
      "display" : "NYSIN S.C. TABLETS 100MG (NITROXOLINE) \"CHINTENG\""
    },
    {
      "code" : "A034079100",
      "display" : "VESUTON F.C. TABLETS 10MG \"CHINTENG\"(SCOPLAMINE)"
    },
    {
      "code" : "A0340791G0",
      "display" : "VESUTON F.C. TABLETS 10MG \"CHINTENG\"(SCOPLAMINE)"
    },
    {
      "code" : "A034080118",
      "display" : "EUGEN LIQUID \"YU SHENG\""
    },
    {
      "code" : "A034080157",
      "display" : "EUGEN LIQUID \"YU SHENG\""
    },
    {
      "code" : "A034080199",
      "display" : "EUGEN LIQUID \"YU SHENG\""
    },
    {
      "code" : "A034082100",
      "display" : "FUROFEN TABLETS 50MG \"Lotus\" (FLURBIPROFEN)"
    },
    {
      "code" : "A034087100",
      "display" : "RND F. C. Tablets 150mg \"Standard\" (Ranitidine)"
    },
    {
      "code" : "A034088100",
      "display" : "KANTUU TABLETS 10MG \"CHINTENG\"(DOMPERIDONE)"
    },
    {
      "code" : "A0340881G0",
      "display" : "KANTUU TABLETS 10MG \"CHINTENG\"(DOMPERIDONE)"
    },
    {
      "code" : "A034089417",
      "display" : "AYCO IN ORABASE 1MG/GM \"ROOT\" (TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A034089421",
      "display" : "AYCO IN ORABASE 1MG/GM \"ROOT\" (TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A034089423",
      "display" : "AYCO IN ORABASE 1MG/GM \"ROOT\" (TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A034089499",
      "display" : "AYCO IN ORABASE 1MG/GM \"ROOT\" (TRIAMCINOLONE ACETONIDE)"
    },
    {
      "code" : "A034090100",
      "display" : "MILIX CAPSULES 2.5MG (INDAPAMIDE) \"M.S.\""
    },
    {
      "code" : "A034096100",
      "display" : "GLUCOMINE F.C. TABLETS 500MG \"P.L\" (METFORMIN)"
    },
    {
      "code" : "A0340961G0",
      "display" : "GLUCOMINE F.C. TABLETS 500MG \"P.L\" (METFORMIN)"
    },
    {
      "code" : "A034097100",
      "display" : "INCIDAL F.C.T. 50MG (MEBHYDROLINE)"
    },
    {
      "code" : "A034098100",
      "display" : "SOTOCON TABLETS 20MG \"CHINTENG\"(DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A0340981G0",
      "display" : "SOTOCON TABLETS 20MG \"CHINTENG\"(DEXTROMETHORPHAN HYDROBROMIDE)"
    },
    {
      "code" : "A034100100",
      "display" : "TERNG SO TABLETS \"CHIN TENG\""
    },
    {
      "code" : "A034103100",
      "display" : "PROLIVRIN CAPSULES \"ROOT\""
    },
    {
      "code" : "A0341031G0",
      "display" : "PROLIVRIN CAPSULES \"ROOT\""
    },
    {
      "code" : "A034105100",
      "display" : "SINTON TABLETS 375MG (NAPROXEN) \"CHIN TENG\""
    },
    {
      "code" : "A034107329",
      "display" : "SOFULUN Cream \"F.M.\""
    },
    {
      "code" : "A034108209",
      "display" : "PIROCAM INJECTION 20MG/ML (PIROXICAM) \"GENTLE\""
    },
    {
      "code" : "A034110100",
      "display" : "AMANTADINE F.C. TABLETS 100MG \"KOJAR\""
    },
    {
      "code" : "A034111100",
      "display" : "BETAHISTANE TABLETS 6MG (BETAHISTINE) \"EAYUNG\""
    },
    {
      "code" : "A034112100",
      "display" : "LOPETIN CAPSULES 2MG (LOPERAMIDE) \"KOJAR\""
    },
    {
      "code" : "A0341121G0",
      "display" : "LOPETIN CAPSULES 2MG (LOPERAMIDE) \"KOJAR\""
    },
    {
      "code" : "A034114212",
      "display" : "META C-B INJECTION \"T.F.\""
    },
    {
      "code" : "A034115100",
      "display" : "HI-CAL CAPSULES 250MG (CALCIUM CARBONATE) \"S.S.P.\""
    },
    {
      "code" : "A034118100",
      "display" : "MAX-CAL CHEWABLE TABLETS 500MG (CALCIUM CARBONATE) \"S.S.P.\""
    },
    {
      "code" : "A034119100",
      "display" : "POULI CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A034120100",
      "display" : "WEIZIP TABLETS 500MG (SUCRALFATE)"
    },
    {
      "code" : "A034122100",
      "display" : "PHITRIM TABLET 25MG (PHENYLPROPANOLAMINE HCL) \"PURZER\""
    },
    {
      "code" : "A034123100",
      "display" : "YUTODIN TABLET 10MG (RITODRINE HCL) \"PURZER\""
    },
    {
      "code" : "A034124321",
      "display" : "GENTAMYCIN CREAM 1MG/GM \"SINPHAR\""
    },
    {
      "code" : "A034124335",
      "display" : "GENTAMYCIN CREAM 1MG/GM \"SINPHAR\""
    },
    {
      "code" : "A034124372",
      "display" : "GENTAMYCIN CREAM 1MG/GM \"SINPHAR\""
    },
    {
      "code" : "A034124399",
      "display" : "GENTAMYCIN CREAM 1MG/GM \"SINPHAR\""
    },
    {
      "code" : "A0341261B4",
      "display" : "KEFLOR FOR ORAL SUSPENSION 75MG/ML (CEFACLOR)"
    },
    {
      "code" : "A034127329",
      "display" : "ACZO GEL 50MG/GM \"SINPHAR\"(BENZOYL PEROXIDE)"
    },
    {
      "code" : "A034128309",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128321",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128329",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128335",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128338",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128372",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034128399",
      "display" : "CLOTRISONE CREAM"
    },
    {
      "code" : "A034129212",
      "display" : "LINCOMYCIN 300MG/ML INJECTION \"S.Y.\""
    },
    {
      "code" : "A034129229",
      "display" : "LINCOMYCIN 300MG/ML INJECTION \"S.Y.\""
    },
    {
      "code" : "A034129238",
      "display" : "LINCOMYCIN 300MG/ML INJECTION \"S.Y.\""
    },
    {
      "code" : "A034130500",
      "display" : "CANESTEN VAGINAL TABLET 100MG (CLOTRIMAZOLE)"
    },
    {
      "code" : "A034134100",
      "display" : "TINMIN TABLETS 60MG (TERFENADINE) \"DCPC\""
    },
    {
      "code" : "A034141100",
      "display" : "PRECONIN TABLETS 5MG (PREDNISOLONE)\"M.S.\""
    },
    {
      "code" : "A034142100",
      "display" : "SWOMINE TABLETS 60MG (TERFENADINE) \"S.D.\""
    },
    {
      "code" : "A034144100",
      "display" : "Noca Tablets 15mg\"H.S.\""
    },
    {
      "code" : "A034145100",
      "display" : "PAINIL TABLETS 50MG (FLURBIPROFEN)"
    },
    {
      "code" : "A034146329",
      "display" : "PIROXIM GEL 0.5％ \"STANDARD\" (PIROXICAM)"
    },
    {
      "code" : "A034147118",
      "display" : "ACETAMINOPHEN SOLUTION 24MG/ML \"S.Y\""
    },
    {
      "code" : "A034147119",
      "display" : "ACETAMINOPHEN SOLUTION 24MG/ML \"S.Y\""
    },
    {
      "code" : "A034147199",
      "display" : "ACETAMINOPHEN SOLUTION 24MG/ML \"S.Y\""
    },
    {
      "code" : "A034148277",
      "display" : "SAILINA INJECTION \"S.Y.\""
    },
    {
      "code" : "A034150277",
      "display" : "LEVO INJECTION 100MG/ML (FRUCTOSE)"
    },
    {
      "code" : "A034151100",
      "display" : "VILLFULL TABLETS 5MG (NORETHINDRONE)"
    },
    {
      "code" : "A034153100",
      "display" : "SEFREE CAPSULES 500MG (CEPHRADINE) \"PANBIOTIC\""
    },
    {
      "code" : "A034154119",
      "display" : "SPIDEL ELIXIR \"TK&A\""
    },
    {
      "code" : "A034154199",
      "display" : "SPIDEL ELIXIR \"TK&A\""
    },
    {
      "code" : "A034157100",
      "display" : "CERETAL S.C. TAB. 400MG (PENTOXIFYLLINE) \"S.T.\""
    },
    {
      "code" : "A034158100",
      "display" : "AMOXICILLIN CAPSULES 500MG \"ASTAR\""
    },
    {
      "code" : "A034159338",
      "display" : "TEIRIA GEL 50MG/GM(ETOFENAMATE)"
    },
    {
      "code" : "A034159345",
      "display" : "TEIRIA GEL 50MG/GM(ETOFENAMATE)"
    },
    {
      "code" : "A034160100",
      "display" : "LURECO TABLETS 250MG (PROBUCOL) \"CURIE\""
    },
    {
      "code" : "A034161100",
      "display" : "ULIDAN S.C. TABLETS 50MG (NICAMETATE CITRATE) \"CENTURY\""
    },
    {
      "code" : "A034162100",
      "display" : "BENARONE TABLETS 50MG (BENZBROMARONE) \"M.S.\""
    },
    {
      "code" : "A034165265",
      "display" : "NEPHROCARE INJECTION 5.4％ \"N.K.\""
    },
    {
      "code" : "A034166255",
      "display" : "HEPACARE INJECTION 8％ \"N.K.\""
    },
    {
      "code" : "A034166277",
      "display" : "HEPACARE INJECTION 8％ \"N.K.\""
    },
    {
      "code" : "A034168321",
      "display" : "ISO CREAM 10MG/GM \"S.D\""
    },
    {
      "code" : "A034169321",
      "display" : "EFU CREAM \"Y.C\""
    },
    {
      "code" : "A034169330",
      "display" : "EFU CREAM \"Y.C\""
    },
    {
      "code" : "A034169372",
      "display" : "EFU CREAM \"Y.C\""
    },
    {
      "code" : "A034169399",
      "display" : "EFU CREAM \"Y.C\""
    },
    {
      "code" : "A034170100",
      "display" : "ANCONIN TABLETS 60MG (TERFENADINE) \"S.C\""
    },
    {
      "code" : "A034171100",
      "display" : "FOAN CAPSULES 10MG (OXAZOLAM) \"S.C\""
    },
    {
      "code" : "A0341711G0",
      "display" : "FOAN CAPSULES 10MG (OXAZOLAM) \"S.C\""
    },
    {
      "code" : "A034172277",
      "display" : "KELIN FOR INJECTION (CEFAZOLIN) \"TAI YU\""
    },
    {
      "code" : "A034173329",
      "display" : "FELTEN GEL. 5MG/GM (PIROXICAM)"
    },
    {
      "code" : "A034174329",
      "display" : "NISOLON GEL 100MG/G (ETOFENAMATE)"
    },
    {
      "code" : "A034174335",
      "display" : "NISOLON GEL 100MG/G (ETOFENAMATE)"
    },
    {
      "code" : "A034179100",
      "display" : "IBUFEN TABLETS 400MG (IBUPROFEN) \"CURIE\""
    },
    {
      "code" : "A0341791G0",
      "display" : "IBUFEN TABLETS 400MG (IBUPROFEN) \"CURIE\""
    },
    {
      "code" : "A034203100",
      "display" : "TUSOLVAN TABLETS 30MG (AMBROXOL) \"S.S.P.\""
    },
    {
      "code" : "A034222113",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222129",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222151",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222157",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222177",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222197",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034222199",
      "display" : "MAC SAFE ORAL SUSPENSION 20MG/ML (IBUPROFEN)"
    },
    {
      "code" : "A034223119",
      "display" : "\"Kojar\" Ambroxol Solution 3mg/mL"
    },
    {
      "code" : "A034223151",
      "display" : "\"Kojar\" Ambroxol Solution 3mg/mL"
    },
    {
      "code" : "A034223199",
      "display" : "\"Kojar\" Ambroxol Solution 3mg/mL"
    },
    {
      "code" : "A034224312",
      "display" : "DEVIRO CREAM 50MG/GM \"HEALTH\""
    },
    {
      "code" : "A034224321",
      "display" : "DEVIRO CREAM 50MG/GM \"HEALTH\""
    },
    {
      "code" : "A034224372",
      "display" : "DEVIRO CREAM 50MG/GM \"HEALTH\""
    },
    {
      "code" : "A034236100",
      "display" : "SERRA E.C TABLETS 10MG (SERRATIOPEPTIDASE) \"H.S.\""
    },
    {
      "code" : "A0342361G0",
      "display" : "SERRA E.C TABLETS 10MG (SERRATIOPEPTIDASE) \"H.S.\""
    },
    {
      "code" : "A034237100",
      "display" : "SUNPYLON TABLETS 200MG (SULPIRIDE) \"S.S.P.\""
    },
    {
      "code" : "A034238100",
      "display" : "MACLOFEN TABLETS 10MG (BACLOFEN) \"S.S.P.\""
    },
    {
      "code" : "A0342381G0",
      "display" : "MACLOFEN TABLETS 10MG (BACLOFEN) \"S.S.P.\""
    },
    {
      "code" : "A034240100",
      "display" : "SUSA TABLETS 2.5MG (FENOTEROL) \"H.S.\""
    },
    {
      "code" : "A0342401G0",
      "display" : "SUSA TABLETS 2.5MG (FENOTEROL) \"H.S.\""
    },
    {
      "code" : "A034241100",
      "display" : "DACON TABLETS 500MG (CALCIUM CARBONATE) \"CHEN TA\""
    },
    {
      "code" : "A034242100",
      "display" : "CHENONINE CAPSULES 125MG (CHENODEOXYCHOLIC ACID) \"PFOSHEN\""
    },
    {
      "code" : "A034243100",
      "display" : "TON LIN CAPSULES 10MG (FLUOXYMESTERONE) \"CHINTENG\""
    },
    {
      "code" : "A034244100",
      "display" : "CORIN TABLETS 100MG (OXOLAMINE CITRATE) \"CHINTENG\""
    },
    {
      "code" : "A034245100",
      "display" : "INITON TABLETS 20MG (PIROXICAM) \"C.M.\""
    },
    {
      "code" : "A034255356",
      "display" : "EVAC ENEMA"
    },
    {
      "code" : "A034270321",
      "display" : "BETACLOSONE CREAM \"UNION\""
    },
    {
      "code" : "A034270329",
      "display" : "BETACLOSONE CREAM \"UNION\""
    },
    {
      "code" : "A034270335",
      "display" : "BETACLOSONE CREAM \"UNION\""
    },
    {
      "code" : "A034270372",
      "display" : "BETACLOSONE CREAM \"UNION\""
    },
    {
      "code" : "A034272100",
      "display" : "SEMPER Tablets 25mg"
    },
    {
      "code" : "A034274100",
      "display" : "TECAPRIL TABLETS 25MG (CAPTOPRIL) \"ROOT\""
    },
    {
      "code" : "A034275100",
      "display" : "WEAN TABLETS 400MG (ALUMINIUM PHOSPHATE) \"Y.C\""
    },
    {
      "code" : "A034283100",
      "display" : "URENIDE TABLETS 1MG  \"ROOT\"(BUMETANIDE)"
    },
    {
      "code" : "A0342831G0",
      "display" : "URENIDE TABLETS 1MG  \"ROOT\"(BUMETANIDE)"
    },
    {
      "code" : "A034285100",
      "display" : "VILI TABLETS \"CHEN TA\""
    },
    {
      "code" : "A034286100",
      "display" : "NORVASC TABLETS 5MG (AMLODIPINE)"
    },
    {
      "code" : "A034288209",
      "display" : "CEPIN FOR INECTION (CEPHRADINE)\"TAIWAN TUNG YANG\""
    },
    {
      "code" : "A034289229",
      "display" : "GAUSS-C 200MG/ML INJECTION  \"SWISS\"(ASCORBIC ACID)"
    },
    {
      "code" : "A034290138",
      "display" : "\"HCT\" Golden GI Plus Suspension 130mg/gm"
    },
    {
      "code" : "A034300100",
      "display" : "TENSOLIN TABLETS \"T.F.\""
    },
    {
      "code" : "A034301209",
      "display" : "U-DOLAN DECANOATE INJ. 50MG/ML \"U-LIANG\" (HALOPERIDOL)"
    },
    {
      "code" : "A034301212",
      "display" : "U-DOLAN DECANOATE INJ. 50MG/ML \"U-LIANG\" (HALOPERIDOL)"
    },
    {
      "code" : "A034301216",
      "display" : "U-DOLAN DECANOATE INJ. 50MG/ML \"U-LIANG\" (HALOPERIDOL)"
    },
    {
      "code" : "A034302100",
      "display" : "SUMIN TABLETS \"H.S.\""
    },
    {
      "code" : "A034304100",
      "display" : "PERIDON TABLETS 10MG (DOMPERIDONE) \"EAYUNG\""
    },
    {
      "code" : "A034306329",
      "display" : "KEC. JEN OINTMENT 0.05％ (CLOBETASOL PROPIONATE) \"CHINTENG\""
    },
    {
      "code" : "A034307336",
      "display" : "\"O.Y.\" VIVICOME CREAM"
    },
    {
      "code" : "A034307372",
      "display" : "\"O.Y.\" VIVICOME CREAM"
    },
    {
      "code" : "A034308100",
      "display" : "TONLIN TABLETS 200MG (FLAVOXATE) \"S.D.\""
    },
    {
      "code" : "A034310100",
      "display" : "DERMIN TABLETS 0.25MG (TRIAZOLAM) \"ROOT\""
    },
    {
      "code" : "A034312100",
      "display" : "ISOSORBIDE TABLETS 40MG \"TWi\""
    },
    {
      "code" : "A034314100",
      "display" : "RECALM TABLETS \"STANDARD\""
    },
    {
      "code" : "A034315100",
      "display" : "AMBROXOL 30MG TABLETS \"W.P.\""
    },
    {
      "code" : "A034317229",
      "display" : "KANAMYCIN 250MG/ML INJECTION \"S.Y\""
    },
    {
      "code" : "A034317238",
      "display" : "KANAMYCIN 250MG/ML INJECTION \"S.Y\""
    },
    {
      "code" : "A034323100",
      "display" : "COWEMIN TABLETS 300MG (CIMETIDINE) \"CHINTENG\""
    },
    {
      "code" : "A0343231G0",
      "display" : "COWEMIN TABLETS 300MG (CIMETIDINE) \"CHINTENG\""
    },
    {
      "code" : "A034325500",
      "display" : "DEFEVER   SUPPOSITORIES 100MG \"S.D.\""
    },
    {
      "code" : "A034325555",
      "display" : "DEFEVER   SUPPOSITORIES 100MG \"S.D.\""
    },
    {
      "code" : "A034326100",
      "display" : "URICIN TABLETS 50MG (BENZBROMARONE) \"GENTLE\""
    },
    {
      "code" : "A034327151",
      "display" : "CODEPINE SYRUP \"J.C.S\""
    },
    {
      "code" : "A034327199",
      "display" : "CODEPINE SYRUP \"J.C.S\""
    },
    {
      "code" : "A034328100",
      "display" : "PROCHIAMIAO CAPSULES 75MG (PHENYLPROPANOLAMINE) \"J.C.S.\""
    },
    {
      "code" : "A034329209",
      "display" : "UFIN FOR IV INJECTION (CEFTRIAXONE) \"UNION\""
    },
    {
      "code" : "A034329212",
      "display" : "UFIN FOR IV INJECTION (CEFTRIAXONE) \"UNION\""
    },
    {
      "code" : "A034329265",
      "display" : "UFIN FOR IV INJECTION (CEFTRIAXONE) \"UNION\""
    },
    {
      "code" : "A034329277",
      "display" : "UFIN FOR IV INJECTION (CEFTRIAXONE) \"UNION\""
    },
    {
      "code" : "A034330100",
      "display" : "ANCOUGH TABLETS 20MG (TIPEPIDINE) \"SINTON\""
    },
    {
      "code" : "A034331209",
      "display" : "CEBID FOR INJECTION (CEFOPERAZONE) \"PURZER\""
    },
    {
      "code" : "A034331277",
      "display" : "CEBID FOR INJECTION (CEFOPERAZONE) \"PURZER\""
    },
    {
      "code" : "A034332100",
      "display" : "CEPHALEXIN CAPSULES 500MG \"ASTAR\""
    },
    {
      "code" : "A034333100",
      "display" : "PANADOL FILM COATED CAPLETS 500MG"
    },
    {
      "code" : "A034340100",
      "display" : "ASTEMIN 10MG TABLETS (ASTEMIZOLE) \"STANDARD\""
    },
    {
      "code" : "A034343100",
      "display" : "TERNAMIN TABLETS 60MG (TERFENADINE) \"T.F\""
    },
    {
      "code" : "A034346100",
      "display" : "SUTONIN TABLET 10MG (DOMPERIDONE) \"SINTON\""
    },
    {
      "code" : "A034347100",
      "display" : "TAIMACON TABLETS"
    },
    {
      "code" : "A034348100",
      "display" : "ANNEUTON TABLETS 80MG  \"ROOT\"(GLICLAZIDE)"
    },
    {
      "code" : "A0343481G0",
      "display" : "ANNEUTON TABLETS 80MG  \"ROOT\"(GLICLAZIDE)"
    },
    {
      "code" : "A034350100",
      "display" : "DAIL TABLET 80MG (GLICLAZIDE) \"SINTON\""
    },
    {
      "code" : "A034351100",
      "display" : "PADAZOLE 100MG TABLETS \"PATRON\" (MEBENDAZOLE)"
    },
    {
      "code" : "A034352255",
      "display" : "MIROSIN 100MG FOR INJECTION (MINOCYCLINE) \"PANBIOTIC\""
    },
    {
      "code" : "A034354100",
      "display" : "YURO F.C. TABLETS 100MG \"YU SHENG\"(NITROXOLINE)"
    },
    {
      "code" : "A034355321",
      "display" : "CYCLOUIR CREAM 50MG/GM \"T.F.\""
    },
    {
      "code" : "A034355377",
      "display" : "CYCLOUIR CREAM 50MG/GM \"T.F.\""
    },
    {
      "code" : "A034356100",
      "display" : "DICLOFENAC TABLET 25MG \"SINTON\""
    },
    {
      "code" : "A034357100",
      "display" : "CEPHALEXIN CAPSULES 250MG \"ASTAR\""
    },
    {
      "code" : "A034358100",
      "display" : "DEFEN CAPSULE 1MG (KETOTIFEN) \"PURZER\""
    },
    {
      "code" : "A0343581G0",
      "display" : "DEFEN CAPSULE 1MG (KETOTIFEN) \"PURZER\""
    },
    {
      "code" : "A034359100",
      "display" : "STERMIN F.C. TABLETS 100MG (ATENOLOL) \"S.T.\""
    },
    {
      "code" : "A034362109",
      "display" : "SWEET BABY COLD GRANULES"
    },
    {
      "code" : "A034362180",
      "display" : "SWEET BABY COLD GRANULES"
    },
    {
      "code" : "A034362199",
      "display" : "SWEET BABY COLD GRANULES"
    },
    {
      "code" : "A034363212",
      "display" : "AMIKACIN INJECTION 250MG/ML (AMIKACIN) \"C.C.P.C.\""
    },
    {
      "code" : "A034363229",
      "display" : "AMIKACIN INJECTION 250MG/ML (AMIKACIN) \"C.C.P.C.\""
    },
    {
      "code" : "A034364100",
      "display" : "PENTOP S.C. TABLETS 100MG \"Y.S\" (PENTOXIFYLLINE)"
    },
    {
      "code" : "A034366100",
      "display" : "OXYBAN TABLETS 5MG \"WEIDAR\" (OXYBUTYNIN)"
    },
    {
      "code" : "A034372329",
      "display" : "FUCON 0.05％ CREAM (CLOBETASOL PROPIONATE) \"Y.Y.\""
    },
    {
      "code" : "A034373100",
      "display" : "AERISIN TABLETS 30MG (DILTIAZEM) \"YUAN CHOU\""
    },
    {
      "code" : "A034375100",
      "display" : "TIMEN CAPSULES 30MG \"WEIDAR\" (TIMEPIDIUM BROMIDE)"
    },
    {
      "code" : "A034378119",
      "display" : "WAINUDAR SUSPENSION \"J.C.S.\""
    },
    {
      "code" : "A034378129",
      "display" : "WAINUDAR SUSPENSION \"J.C.S.\""
    },
    {
      "code" : "A034501255",
      "display" : "KETOR IM LYO-INJECTION 100MG/VIAL \"UNION\" (KETOPROFEN)"
    },
    {
      "code" : "A034503429",
      "display" : "ARTIFICIAL TEAR \"WU-FU\""
    },
    {
      "code" : "A034504100",
      "display" : "PAWEGON 200MG TABLETS (CIMETIDINE) \"EVEREST\""
    },
    {
      "code" : "A034505100",
      "display" : "DI-GEL TABLETS"
    },
    {
      "code" : "A034507277",
      "display" : "BABYNNA INJECTION \"S.Y\""
    },
    {
      "code" : "A034508309",
      "display" : "CLOPAIN GEL 10MG/GM (DICLOFENAC SODIUM) \"B & F\""
    },
    {
      "code" : "A034508338",
      "display" : "CLOPAIN GEL 10MG/GM (DICLOFENAC SODIUM) \"B & F\""
    },
    {
      "code" : "A034508343",
      "display" : "CLOPAIN GEL 10MG/GM (DICLOFENAC SODIUM) \"B & F\""
    },
    {
      "code" : "A034508345",
      "display" : "CLOPAIN GEL 10MG/GM (DICLOFENAC SODIUM) \"B & F\""
    },
    {
      "code" : "A034511100",
      "display" : "LISUMEN CAPSULE 30MG \"ASTAR\""
    },
    {
      "code" : "A034518100",
      "display" : "COFEN 1MG TABLETS \"C.H.\" (KETOTIFEN)"
    },
    {
      "code" : "A034523100",
      "display" : "AMOXICILLIN 500MG CAPSULES \"PANBIOTIC\""
    },
    {
      "code" : "A0345231G0",
      "display" : "AMOXICILLIN 500MG CAPSULES \"PANBIOTIC\""
    },
    {
      "code" : "A034524100",
      "display" : "BACLOFEN 10MG \"S.Y.\""
    },
    {
      "code" : "A034526100",
      "display" : "A MAY CAPSULE 25MG (PHENYLPROPANOLAMINE)\" TON SIN \""
    },
    {
      "code" : "A034527212",
      "display" : "DAILY REBORN INJECTION 25MG (NANDROLONE PHENYLPROPIONATE)\"SHITEH\""
    },
    {
      "code" : "A034528100",
      "display" : "ERY-B E.C. CAPSULES 250MG (ERYTHROMYCIN) \"KINGDOM\""
    },
    {
      "code" : "A034529229",
      "display" : "KACIN INJECTION 250MG/ML (AMIKACIN) \"PURZER\""
    },
    {
      "code" : "A034530100",
      "display" : "DAIPIN FILM COATED TABLETS 1MG (N-METHYLSCOPOLAMINE   METHYLSULFATE)"
    },
    {
      "code" : "A034531321",
      "display" : "SUGENFU CREAM 10MG/GM (BIFONAZOLE)"
    },
    {
      "code" : "A034532100",
      "display" : "ENAGYN TABLETS 500MG \"TK&A\" (TINIDAZOLE)"
    },
    {
      "code" : "A034534100",
      "display" : "SOLOFEN TABLETS 10MG (BACLOFEN)"
    },
    {
      "code" : "A034535100",
      "display" : "SUPELI CAPSULES \"KOJAR\""
    },
    {
      "code" : "A034537100",
      "display" : "CALCIUM CARBONATE TABLETS 500MG  \"Yihhaw\""
    },
    {
      "code" : "A034539100",
      "display" : "AMBROXOL TABLETS 30MG \"AND\""
    },
    {
      "code" : "A034540100",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034540106",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034540109",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034540155",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034540177",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034540199",
      "display" : "IBUTEN GRANULES 400MG/G \"PANBIOTIC\""
    },
    {
      "code" : "A034541100",
      "display" : "BEROTIN TABLETS 2.5MG \"CL\""
    },
    {
      "code" : "A034542100",
      "display" : "NEWEDON TABLETS 10MG \"Y.K.\""
    },
    {
      "code" : "A034545329",
      "display" : "WIEPOIDO CREAM 0.06％ (ESTRADIOL) \"H.S.\""
    },
    {
      "code" : "A034545340",
      "display" : "WIEPOIDO CREAM 0.06％ (ESTRADIOL) \"H.S.\""
    },
    {
      "code" : "A034547100",
      "display" : "MEFENAMIC ACID TABLETS 500MG \"M.T\""
    },
    {
      "code" : "A0345471G0",
      "display" : "MEFENAMIC ACID TABLETS 500MG \"M.T\""
    },
    {
      "code" : "A034549100",
      "display" : "LOFORMIN TABLETS 500MG \"ENSAFE\" (METFORMIN)"
    },
    {
      "code" : "A034550100",
      "display" : "GLUPIZIDE TABLETS 5MG (GLIPIZIDE) \"K.P.L.\""
    },
    {
      "code" : "A0345501G0",
      "display" : "GLUPIZIDE TABLETS 5MG (GLIPIZIDE) \"K.P.L.\""
    },
    {
      "code" : "A034551100",
      "display" : "SULIMEN TABLETS 100MG (SULINDAC) \"KOJAR\""
    },
    {
      "code" : "A034553100",
      "display" : "NICARPINE S.C. TABLETS 20MG \"P.L\" (NICARDIPINE)"
    },
    {
      "code" : "A034556100",
      "display" : "SOU-AN CAPSULES \"CHINTENG\""
    },
    {
      "code" : "A034557100",
      "display" : "ZU-U TABLETS 100MG (BENZARONE) \"CHINTENG\""
    },
    {
      "code" : "A034558100",
      "display" : "BROSOU TABLETS 20MG \"CHINTENG\" (TIPEPIDINE HIBENZATE)"
    },
    {
      "code" : "A034559100",
      "display" : "KETOTIFEN TABLETS 1MG \"CHINTENG\""
    },
    {
      "code" : "A0345591G0",
      "display" : "KETOTIFEN TABLETS 1MG \"CHINTENG\""
    },
    {
      "code" : "A034562100",
      "display" : "UROSEPT CAPSULE 400MG \"GCPC\" (PIPEMIDIC ACID)"
    },
    {
      "code" : "A034563100",
      "display" : "PADAZOLE 10MG TABLETS \"PATRON\" (MEBENDAZOLE)"
    },
    {
      "code" : "A034564100",
      "display" : "LIVER CHOLINE S.C. TABLETS \"EVEREST\""
    },
    {
      "code" : "A0345641G0",
      "display" : "LIVER CHOLINE S.C. TABLETS \"EVEREST\""
    },
    {
      "code" : "A034565100",
      "display" : "ULCERMINE TABLETS \"EVEREST\""
    },
    {
      "code" : "A034567209",
      "display" : "GOODGEN INJECTION 20MG/ML \"T.F.\""
    },
    {
      "code" : "A034568118",
      "display" : "CANACOFF SYRUP"
    },
    {
      "code" : "A034568151",
      "display" : "CANACOFF SYRUP"
    },
    {
      "code" : "A034568157",
      "display" : "CANACOFF SYRUP"
    },
    {
      "code" : "A034568199",
      "display" : "CANACOFF SYRUP"
    },
    {
      "code" : "A034569335",
      "display" : "BESONG SCALP SOLUTION 1MG/ML ''SINPHAR''(BETAMETHASONE)"
    },
    {
      "code" : "A034569340",
      "display" : "BESONG SCALP SOLUTION 1MG/ML ''SINPHAR''(BETAMETHASONE)"
    },
    {
      "code" : "A034569399",
      "display" : "BESONG SCALP SOLUTION 1MG/ML ''SINPHAR''(BETAMETHASONE)"
    },
    {
      "code" : "A034573329",
      "display" : "SALOSON 1％ EMUGEL \"MEY SEE\" (DICLOFENAC)"
    },
    {
      "code" : "A034573335",
      "display" : "SALOSON 1％ EMUGEL \"MEY SEE\" (DICLOFENAC)"
    },
    {
      "code" : "A034573338",
      "display" : "SALOSON 1％ EMUGEL \"MEY SEE\" (DICLOFENAC)"
    },
    {
      "code" : "A034573343",
      "display" : "SALOSON 1％ EMUGEL \"MEY SEE\" (DICLOFENAC)"
    },
    {
      "code" : "A034574277",
      "display" : "DITROSE 10％ INJECTION \"S.Y.\" (DEXTROSE)"
    },
    {
      "code" : "A034575100",
      "display" : "SUCRATE TABLETS 500MG (SUCRALFATE) \"KOJAR\""
    },
    {
      "code" : "A034577212",
      "display" : "AMIKACIN INJECTION 125MG/ML \"S.Y.\""
    },
    {
      "code" : "A034577229",
      "display" : "AMIKACIN INJECTION 125MG/ML \"S.Y.\""
    },
    {
      "code" : "A034579216",
      "display" : "GARA INJECTION 40MG /ML (GENTAMYCIN SULFATE)"
    },
    {
      "code" : "A034579229",
      "display" : "GARA INJECTION 40MG /ML (GENTAMYCIN SULFATE)"
    },
    {
      "code" : "A034579299",
      "display" : "GARA INJECTION 40MG /ML (GENTAMYCIN SULFATE)"
    },
    {
      "code" : "A034583100",
      "display" : "VIRLESS TABLETS 200MG (ACYCLOVIR) \"YUNG SHIN\""
    },
    {
      "code" : "A034584100",
      "display" : "EASYING FILM COATED TABLETS 25MG \"ROOT\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A0345841G0",
      "display" : "EASYING FILM COATED TABLETS 25MG \"ROOT\" (DIPYRIDAMOLE)"
    },
    {
      "code" : "A034585500",
      "display" : "NYDASIN VAGINAL SUPPOSITORIES \"WEIDAR\""
    },
    {
      "code" : "A034587100",
      "display" : "B.Z.F. F.C. TABLETS 200MG (BEZAFIBRATE)"
    },
    {
      "code" : "A034589100",
      "display" : "SERELAM CAPSULES 10MG \"Y.K.\""
    },
    {
      "code" : "A034595321",
      "display" : "SILVER CREAM 10MG/GM (SILVER SULFADIAZINE) \"MEIDER\""
    },
    {
      "code" : "A034595338",
      "display" : "SILVER CREAM 10MG/GM (SILVER SULFADIAZINE) \"MEIDER\""
    },
    {
      "code" : "A034597100",
      "display" : "KENERLIN TABLET 1MG (KETOTIFEN) \"SINTON\""
    },
    {
      "code" : "A034598100",
      "display" : "CAPTROL TABLET 25MG (CAPTOPRIL) \"PURZER\""
    },
    {
      "code" : "A034603100",
      "display" : "FENBUTA CAPSULES 300MG (FENBUFEN) \"J.C.S.\""
    },
    {
      "code" : "A034604100",
      "display" : "TANAZOLE CAPSULES 200MG (DANAZOL) \"PFOSHEN\""
    },
    {
      "code" : "A034606100",
      "display" : "ATENOLOL TABLETS 100MG \"M.S.\""
    },
    {
      "code" : "A034608100",
      "display" : "EULICA TABLETS 50MG (NICAMETATE) \"C.L.\""
    },
    {
      "code" : "A034609109",
      "display" : "DECOUGH GRANULES 100MG/GM (EPRAZINONE) \"S.C.\""
    },
    {
      "code" : "A034609177",
      "display" : "DECOUGH GRANULES 100MG/GM (EPRAZINONE) \"S.C.\""
    },
    {
      "code" : "A034609199",
      "display" : "DECOUGH GRANULES 100MG/GM (EPRAZINONE) \"S.C.\""
    },
    {
      "code" : "A034610100",
      "display" : "RELAC TABLETS 5MG (BUSPIRONE) \"UNION\""
    },
    {
      "code" : "A034611100",
      "display" : "RELAC TABLETS 10MG (BUSPIRONE) \"UNION\""
    },
    {
      "code" : "A034613100",
      "display" : "MODRON TABLETS 50MG (ORPHENADRINE) \"TAI YU\""
    },
    {
      "code" : "A034614209",
      "display" : "KELIN FOR INJECTION \"TAI YU\" (CEFAZOLIN)"
    },
    {
      "code" : "A034614212",
      "display" : "KELIN FOR INJECTION \"TAI YU\" (CEFAZOLIN)"
    },
    {
      "code" : "A034614221",
      "display" : "KELIN FOR INJECTION \"TAI YU\" (CEFAZOLIN)"
    },
    {
      "code" : "A034618340",
      "display" : "UNDACID OINTMENT \"VPP\""
    },
    {
      "code" : "A034618343",
      "display" : "UNDACID OINTMENT \"VPP\""
    },
    {
      "code" : "A034619209",
      "display" : "BATONSU INJECTION 4MG/ML (BETAMETHASONE) \"SINTON\""
    },
    {
      "code" : "A034621100",
      "display" : "GLUTROL TABLET 5MG (GLIPIZIDE