# 免疫製劑事前審查 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **免疫製劑事前審查**

## Example Claim: 免疫製劑事前審查

Profile: [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md)

**ClaimEncounter**: [Encounter: status = planned; class = ambulatory (ActCode#AMB); serviceType = 胸腔暨重症加護](Encounter-enc-min.md)

**status**: Active

**type**: Institutional

**subType**: 送核

**use**: Preauthorization

**patient**: [王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))](Patient-pat-min.md)

**created**: 2024-05-30

**enterer**: [Practitioner: identifier = National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code,Medical License number](Practitioner-pra-min.md)

**provider**: [Organization 臺北市立聯合醫院](Organization-org-hosp-example.md)

**priority**: 一般事前審查申請

> **supportingInfo****sequence**: 1**category**:病人體重**value**: 59.65 kg(Details: UCUM codekg = 'kg')

> **supportingInfo****sequence**: 2**category**:病人身高**value**: 170 cm(Details: UCUM codecm = 'cm')

> **supportingInfo****sequence**: 3**category**:病人血型**value**:[Observation ABO and Rh group [Type] in Blood](Observation-obs-blood-group.md)

> **supportingInfo****sequence**: 4**category**:影像報告**value**:[Diagnostic Report for 'B34JZZ3' for '->王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))'](DiagnosticReport-diaRep-ima-min.md)

> **supportingInfo****sequence**: 6**category**:檢查報告**value**:[Diagnostic Report for 'Prostate Pathology biopsy report' for '->王大明 Male, DoB: 2001-01-01 ( Medical record number (use: official, ))'](DiagnosticReport-diaRep-min.md)

> **supportingInfo****sequence**: 8**category**:檢驗(查)**value**:[Observation Platelets [#/volume] in Blood by Automated count](Observation-obs-lab-min.md)

> **supportingInfo****sequence**: 9**category**:檢驗(查)**value**:[Observation CBC panel - Blood by Automated count](Observation-obs-lab-cbc.md)

> **supportingInfo****sequence**: 10**category**:病人狀態評估**value**:[Observation Functional capacity NYHA](Observation-obs-pat-nyha.md)

> **supportingInfo****sequence**: 11**category**:用藥品項**value**:[MedicationRequest: status = completed; statusReason = Try another treatment first; intent = order; category = 健保; medication[x] = ANTI-COUGH SYRUP "WASHINGTON"](MedicationRequest-medReq-treat.md)

> **supportingInfo****sequence**: 12**category**:放射/照光治療**value**:[Procedure D7Y08ZZ](Procedure-pro-min.md)

> **supportingInfo****sequence**: 13**category**:治療計畫文件**value**:[DocumentReference: status = current; category = 治療計畫文件](DocumentReference-doc-careplan-min.md)

> **supportingInfo****sequence**: 14**category**:病歷資料**value**:[DocumentReference: status = current; category = 病歷資料](DocumentReference-doc-medicalRecord-min.md)

> **supportingInfo****sequence**: 15**category**:結果資訊**value**:[Observation International Working Group(IWG) Consensus Criteria](Observation-obs-tx-min.md)

> **supportingInfo****sequence**: 16**category**:門診病歷**value**:[Encounter: extension = ->Observation Subjective Narrative,->Observation Objective Narrative,->ClinicalImpression: status = completed; summary = Right knee . arthritis . active,->CarePlan: status = completed; intent = plan; category = Assessment and Plan of Treatment; description = 1.Arrenge Arthrocentesis of Right knee and synovial fluid analysis (routine, culture and crystal analysis) after patient consent. 2.Analgesics. 3.Bed rest with ice packing if necessary.; status = finished; class = ambulatory (ActCode#AMB); serviceType = Family practice (qualifier value); period = 2025-11-11 --> (ongoing)](Encounter-enc-opd.md)

> **supportingInfo****sequence**: 17**category**:過敏史**value**:[AllergyIntolerance](AllergyIntolerance-all-min.md)

### Diagnoses

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Extension** | **Sequence** | **Diagnosis[x]** | **Type** |
| * |  | 1 | I50.812 | Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI |

### Procedures

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Date** | **Procedure[x]** |
| * | 1 | 2024-01-01 | 3E0Y704 |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: status = active](Coverage-cov-min.md) |

> **item****RequestedService**:[MedicationRequest: status = on-hold; intent = plan; medication[x] = Alunbrig film-coated tablets 30mg](MedicationRequest-medReq-apply.md)**sequence**: 1**productOrService**:藥品**modifier**:初次使用,第一線治療**programCode**:ALK陽性的晚期非小細胞肺癌第一線治療**quantity**: 52 {tbl}(Details: UCUM code{tbl} = '{tbl}')

> **item****RequestedService**:[MedicationRequest: status = on-hold; intent = plan; medication[x] = Herzuma Inj. 440mg, Lyophilized powder for injection](MedicationRequest-medReq-apply-2.md)**sequence**: 2**productOrService**:藥品**modifier**:初次使用,第一線治療**programCode**:早期乳癌-未發生腋下淋巴結轉移**quantity**: 70 {tbl}(Details: UCUM code{tbl} = '{tbl}')



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "cla-imm",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-immunologic-agent-twpas"
    ]
  },
  "extension" : [
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter",
      "valueReference" : {
        "reference" : "Encounter/enc-min"
      }
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional"
      }
    ]
  },
  "subType" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-type",
        "code" : "1",
        "display" : "送核"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/pat-min"
  },
  "created" : "2024-05-30",
  "enterer" : {
    "reference" : "Practitioner/pra-min"
  },
  "provider" : {
    "reference" : "Organization/org-hosp-example"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-tmhb-type",
        "code" : "1",
        "display" : "一般事前審查申請"
      }
    ]
  },
  "supportingInfo" : [
    {
      "sequence" : 1,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "weight"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 59.65,
        "system" : "http://unitsofmeasure.org",
        "code" : "kg"
      }
    },
    {
      "sequence" : 2,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "height"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 170,
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "sequence" : 3,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "bloodgroup"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-blood-group"
      }
    },
    {
      "sequence" : 4,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "imagingReport"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DiagnosticReport/diaRep-ima-min"
      }
    },
    {
      "sequence" : 6,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "examinationReport"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DiagnosticReport/diaRep-min"
      }
    },
    {
      "sequence" : 8,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "tests"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-lab-min"
      }
    },
    {
      "sequence" : 9,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "tests"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-lab-cbc"
      }
    },
    {
      "sequence" : 10,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "patientAssessment"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-pat-nyha"
      }
    },
    {
      "sequence" : 11,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "medicationRequest"
          }
        ]
      },
      "valueReference" : {
        "reference" : "MedicationRequest/medReq-treat"
      }
    },
    {
      "sequence" : 12,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "radiotherapy"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Procedure/pro-min"
      }
    },
    {
      "sequence" : 13,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "carePlanDocument"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DocumentReference/doc-careplan-min"
      }
    },
    {
      "sequence" : 14,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "medicalRecord"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DocumentReference/doc-medicalRecord-min"
      }
    },
    {
      "sequence" : 15,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "treatmentAssessment"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-tx-min"
      }
    },
    {
      "sequence" : 16,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "opd"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Encounter/enc-opd"
      }
    },
    {
      "sequence" : 17,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "allergy"
          }
        ]
      },
      "valueReference" : {
        "reference" : "AllergyIntolerance/all-min"
      }
    }
  ],
  "diagnosis" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate",
          "valueDate" : "2024-01-01"
        }
      ],
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
            "code" : "I50.812"
          }
        ]
      },
      "type" : [
        {
          "text" : "Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI"
        }
      ]
    }
  ],
  "procedure" : [
    {
      "sequence" : 1,
      "date" : "2024-01-01",
      "procedureCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
            "code" : "3E0Y704"
          }
        ]
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/cov-min"
      }
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
          "valueReference" : {
            "reference" : "MedicationRequest/medReq-apply"
          }
        }
      ],
      "sequence" : 1,
      "productOrService" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
            "code" : "1",
            "display" : "藥品"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
              "code" : "1",
              "display" : "初次使用"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
              "code" : "1",
              "display" : "第一線治療"
            }
          ]
        }
      ],
      "programCode" : [
        {
          "text" : "ALK陽性的晚期非小細胞肺癌第一線治療"
        }
      ],
      "quantity" : {
        "value" : 52,
        "system" : "http://unitsofmeasure.org",
        "code" : "{tbl}"
      }
    },
    {
      "extension" : [
        {
          "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
          "valueReference" : {
            "reference" : "MedicationRequest/medReq-apply-2"
          }
        }
      ],
      "sequence" : 2,
      "productOrService" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
            "code" : "1",
            "display" : "藥品"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
              "code" : "1",
              "display" : "初次使用"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
              "code" : "1",
              "display" : "第一線治療"
            }
          ]
        }
      ],
      "programCode" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason",
              "code" : "C50P1"
            }
          ]
        }
      ],
      "quantity" : {
        "value" : 70,
        "system" : "http://unitsofmeasure.org",
        "code" : "{tbl}"
      }
    }
  ]
}

```
