# 事前審查-送核、套組檢驗、多事前審查癌藥品項 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **事前審查-送核、套組檢驗、多事前審查癌藥品項**

## Example Claim: 事前審查-送核、套組檢驗、多事前審查癌藥品項

Profile: [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)

**狀態**：Active

**類型**：Institutional([ClaimTypeCodes](http://terminology.hl7.org/CodeSystem/claim-type)#institutional)

**就醫科別**：[Encounter/enc-min](Encounter-enc-min.md) "胸腔暨重症加護"

**申報類別**：送核([NHI-申報類別值集](CodeSystem-nhi-apply-type.md)#1)

**目的**：Preauthorization

**病人**：[Patient/pat-min](Patient-pat-min.md) "王大明"

**申請日期**：2024-05-30

**申請醫師**：[Practitioner/pra-min](Practitioner-pra-min.md)

**醫事機構代碼**：[Organization/org-hosp-example](Organization-org-hosp-example.md)

**申請案件類別**：一般事前審查申請([NHI-申請案件類別值集](CodeSystem-nhi-tmhb-type.md)#1)

> **supportingInfo****sequence**：1**category**：病人體重**value**：59.65 kg(Details: UCUM codekg = 'kg')

> **supportingInfo****sequence**：2**category**：病人身高**value**：170 cm(Details: UCUM codecm = 'cm')

> **supportingInfo****sequence**：3**category**：是否懷孕或哺乳**value**：false

> **supportingInfo****sequence**：4**category**：影像報告**value**：[DiagnosticReport/diaRep-ima-min](DiagnosticReport-diaRep-ima-min.md)

> **supportingInfo****sequence**：5**category**：癌症分期量表**value**：[Observation/obs-cancer-figo](Observation-obs-cancer-figo.md)

> **supportingInfo****sequence**：6**category**：檢查報告**value**：[DiagnosticReport/diaRep-min](DiagnosticReport-diaRep-min.md)

> **supportingInfo****sequence**：7**category**：基因資訊**value**：[Observation/obs-diagnostic-min](Observation-obs-diagnostic-min.md)

> **supportingInfo****sequence**：8**category**：檢驗檢查-單項**value**：[Observation/obs-lab-min](Observation-obs-lab-min.md)

> **supportingInfo****sequence**：9**category**：檢驗檢查-套組(全套血液檢查)**value**：[Observation/obs-lab-cbc](Observation-obs-lab-cbc.md)

> **supportingInfo****sequence**：10**category**：病人狀態評估**value**：[Observation/obs-pat-nyha](Observation-obs-pat-nyha.md)

> **supportingInfo****sequence**：11**category**：用藥品項**value**：[MedicationRequest/medReq-treat](MedicationRequest-medReq-treat.md)

> **supportingInfo****sequence**：12**category**：放射/照光治療**value**：[Procedure/pro-min](Procedure-pro-min.md)

> **supportingInfo****sequence**：13**category**：治療計畫文件**value**：[DocumentReference/doc-careplan-min](DocumentReference-doc-careplan-min.md)

> **supportingInfo****sequence**：14**category**：病歷資料**value**：[DocumentReference/doc-medicalRecord-min](DocumentReference-doc-medicalRecord-min.md)

> **supportingInfo****sequence**：15**category**：結果資訊**value**：[Observation/obs-tx-min](Observation-obs-tx-min.md)

### Diagnoses

**診斷日期**：2024-01-01

**國際疾病分類代碼**：慢性右心臟衰竭([臺灣健保署2023年中文版ICD-10-CM值集](https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw)#I50.812)

**簡要病摘**：Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI

### Procedures

**手術(或其他處置)日期**：2024-01-01

**手術(或其他處置)項目**：經由自體開口或人工造口心包腔近接放射性同位素抗腫瘤液態藥劑輸入([臺灣健保署2023年中文版ICD-10-PCS值集](https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw)#3E0Y704)

### Insurances

**sequence**：1

**coverage**：[Coverage/cov-min](Coverage-cov-min.md)

### 申請項目

> **事前審查品項**：[MedicationRequest/medReq-apply](MedicationRequest-medReq-apply.md)**事前審查申請數量(單位)**：52 (tablets([Common UCUM units](https://hl7.org/fhir/R4/valueset-ucum-common.html)#{tbl}))**醫令類別**：藥品([NHI-健保事前審查-醫令類別值集](CodeSystem-nhi-order-type.md)#1)**續用註記**：初次使用([NHI-續用註記值集](CodeSystem-nhi-continuation-status.md)#1)**用藥線別**：第一線治療([NHI-用藥線別值集](CodeSystem-nhi-line-of-therapy.md)#1)**給付適應症**：ALK陽性的晚期非小細胞肺癌第一線治療

> **事前審查品項**：[MedicationRequest/medReq-apply-2](MedicationRequest-medReq-apply-2.md)**事前審查申請數量(單位)**：70 (tablets([Common UCUM units](https://hl7.org/fhir/R4/valueset-ucum-common.html)#{tbl}))**醫令類別**：藥品([NHI-健保事前審查-醫令類別值集](CodeSystem-nhi-order-type.md)#1)**續用註記**：初次使用([NHI-續用註記值集](CodeSystem-nhi-continuation-status.md)#1)**用藥線別**：第一線治療([NHI-用藥線別值集](CodeSystem-nhi-line-of-therapy.md)#1)**給付適應症**：C50P1([NHI-給付適應症值集](CodeSystem-nhi-apply-reason.md)#C50P1)



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "cla-1",
  "meta" : {
    "profile" : [
      "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-twpas"
    ]
  },
  "extension" : [
    {
      "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-claim-encounter",
      "valueReference" : {
        "reference" : "Encounter/enc-min"
      }
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional"
      }
    ]
  },
  "subType" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-type",
        "code" : "1",
        "display" : "送核"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/pat-min"
  },
  "created" : "2024-05-30",
  "enterer" : {
    "reference" : "Practitioner/pra-min"
  },
  "provider" : {
    "reference" : "Organization/org-hosp-example"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-tmhb-type",
        "code" : "1",
        "display" : "一般事前審查申請"
      }
    ]
  },
  "supportingInfo" : [
    {
      "sequence" : 1,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "weight"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 59.65,
        "system" : "http://unitsofmeasure.org",
        "code" : "kg"
      }
    },
    {
      "sequence" : 2,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "height"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 170,
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "sequence" : 3,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "pregnancyBreastfeedingStatus"
          }
        ]
      },
      "valueBoolean" : false
    },
    {
      "sequence" : 4,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "imagingReport"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DiagnosticReport/diaRep-ima-min"
      }
    },
    {
      "sequence" : 5,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "cancerStage"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-cancer-figo"
      }
    },
    {
      "sequence" : 6,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "examinationReport"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DiagnosticReport/diaRep-min"
      }
    },
    {
      "sequence" : 7,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "geneInfo"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-diagnostic-min"
      }
    },
    {
      "sequence" : 8,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "tests"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-lab-min"
      }
    },
    {
      "sequence" : 9,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "tests"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-lab-cbc"
      }
    },
    {
      "sequence" : 10,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "patientAssessment"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-pat-nyha"
      }
    },
    {
      "sequence" : 11,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "medicationRequest"
          }
        ]
      },
      "valueReference" : {
        "reference" : "MedicationRequest/medReq-treat"
      }
    },
    {
      "sequence" : 12,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "radiotherapy"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Procedure/pro-min"
      }
    },
    {
      "sequence" : 13,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "carePlanDocument"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DocumentReference/doc-careplan-min"
      }
    },
    {
      "sequence" : 14,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "medicalRecord"
          }
        ]
      },
      "valueReference" : {
        "reference" : "DocumentReference/doc-medicalRecord-min"
      }
    },
    {
      "sequence" : 15,
      "category" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-supporting-info-type",
            "code" : "treatmentAssessment"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/obs-tx-min"
      }
    }
  ],
  "diagnosis" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pas/StructureDefinition/extension-diagnosisRecordedDate",
          "valueDate" : "2024-01-01"
        }
      ],
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2023-tw",
            "code" : "I50.812"
          }
        ]
      },
      "type" : [
        {
          "text" : "Adenocarcinoma, descending colon, cT3N2M1a, cStage IVA, KRAS G12V, with multiple liver metastases, status post FOLFIRI"
        }
      ]
    }
  ],
  "procedure" : [
    {
      "sequence" : 1,
      "date" : "2024-01-01",
      "procedureCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
            "code" : "3E0Y704"
          }
        ]
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/cov-min"
      }
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
          "valueReference" : {
            "reference" : "MedicationRequest/medReq-apply"
          }
        }
      ],
      "sequence" : 1,
      "productOrService" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
            "code" : "1",
            "display" : "藥品"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
              "code" : "1",
              "display" : "初次使用"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
              "code" : "1",
              "display" : "第一線治療"
            }
          ]
        }
      ],
      "programCode" : [
        {
          "text" : "ALK陽性的晚期非小細胞肺癌第一線治療"
        }
      ],
      "quantity" : {
        "value" : 52,
        "system" : "http://unitsofmeasure.org",
        "code" : "{tbl}"
      }
    },
    {
      "extension" : [
        {
          "url" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/extension-requestedService",
          "valueReference" : {
            "reference" : "MedicationRequest/medReq-apply-2"
          }
        }
      ],
      "sequence" : 2,
      "productOrService" : {
        "coding" : [
          {
            "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-order-type",
            "code" : "1",
            "display" : "藥品"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-continuation-status",
              "code" : "1",
              "display" : "初次使用"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-line-of-therapy",
              "code" : "1",
              "display" : "第一線治療"
            }
          ]
        }
      ],
      "programCode" : [
        {
          "coding" : [
            {
              "system" : "https://nhicore.nhi.gov.tw/pas/CodeSystem/nhi-apply-reason",
              "code" : "C50P1"
            }
          ]
        }
      ],
      "quantity" : {
        "value" : 70,
        "system" : "http://unitsofmeasure.org",
        "code" : "{tbl}"
      }
    }
  ]
}

```
