# 臺灣事前審查-用戶端(TWPAS Client) - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **臺灣事前審查-用戶端(TWPAS Client)**

## CapabilityStatement: 臺灣事前審查-用戶端(TWPAS Client) 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/CapabilityStatement/CapabilityStatementTWPASClient | *Version*:1.1.0 |
| Active as of 2025-10-01 | *Computable Name*:CapabilityStatementTWPASClient |

 
臺灣健保事前審查實作指引(TWPAS IG)用戶端(Client)之能力聲明 

 [Raw OpenAPI-Swagger Definition file](CapabilityStatementTWPASClient.openapi.json) | [Download](CapabilityStatementTWPASClient.openapi.json) 

## 臺灣事前審查-用戶端(TWPAS Client)

* 實作指引版本：1.1.0
* FHIR版本：4.0.1
* 支援格式：`json`
* 發佈日：2025-10-01
* 發佈者：衛生福利部中央健康保險署

### 建議應該（SHOULD）支援以下實作指引

* [臺灣健保事前審查實作指引(TWPAS IG)](index.md)

## Client的FHIR RESTful功能要求

### 模式: client

臺灣事前審查-用戶端(TWPAS Client)**必須(SHALL)**：
(1)使用臺灣事前審查伺服端（TWPAS Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣事前審查Profile（s）

安全性：
(1)有關要求和建議，請參閱[安全性](security.md)。

### Resources或Profiles的RESTful功能

#### Summary

共有二十二類Resources支援查詢，查詢參數如表列：

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Bundle](#Bundle1-1) | 支援的Profiles  [癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)  [事前審查回覆-Bundle Response TWPAS](StructureDefinition-Bundle-response-twpas.md)  [免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md) | y | y | y |  | y | _id |
| [Claim](#Claim1-2) | 支援的Profiles  [癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)  [免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md) | y | y | y |  | y | identifier, patient, func-type |
| [ClaimResponse](#ClaimResponse) | 支援的Profiles  [事前審查回覆-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md)  [自主審查-ClaimResponse Self Assessment TWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md) | y | y | y |  | y | adjudication-reason, request.patient.name, request.patient.identifier, request.identifier, request.func-type.service-type, created, disposition |
| [AllergyIntolerance](#AllergyIntolerance) | [過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md) | y | y | y |  | y |  |
| [Organization](#Organization1-3) | 支援的Profiles  [機構-Organization TWPAS](StructureDefinition-Organization-twpas.md)  [基因檢測機構-Organization Genetic Testing TWPAS](StructureDefinition-Organization-genetic-testing-twpas.md)  [TW Core Organization Government](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/StructureDefinition-Organization-govt-twcore.html) | y | y | y |  | y |  |
| [Encounter](#Encounter1-4) | 支援的Profiles  [就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md)  [門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md) | y | y | y |  | y | service-type |
| [Patient](#Patient1-5) | [病人資訊-Patient TWPAS](StructureDefinition-Patient-twpas.md) | y | y | y |  | y | name, identifier |
| [Practitioner](#Practitioner1-6) | [醫事人員-Practitioner TWPAS](StructureDefinition-Practitioner-twpas.md) | y | y | y |  | y |  |
| [ImagingStudy](#ImagingStudy1-7) | [DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md) | y | y | y |  | y |  |
| [Media](#Media1-8) | [非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md) | y | y | y |  | y |  |
| [DiagnosticReport](#DiagnosticReport1-9) | 支援的Profiles  [影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md)(疾病資訊)  [檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md)(疾病資訊) | y | y | y |  | y |  |
| [Observation](#Observation1-10) | 支援的Profiles  [癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md)(疾病資訊)  [基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)  [檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md)(評估資訊)  [病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)(評估資訊)  [治療後疾病狀態評估-Observation Treatment Assessment TWPAS](StructureDefinition-Observation-tx-assessment-twpas.md)(結果資訊)  [血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md)(病人資訊)  [主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md)(門診病歷)  [客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md)(門診病歷) | y | y | y |  | y |  |
| [ClinicalImpression](#ClinicalImpression) | [評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md)(門診病歷) | y | y | y |  | y |  |
| [CarePlan](#CarePlan) | [計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md)(門診病歷) | y | y | y |  | y |  |
| [Condition](#Condition) | [診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md)(門診病歷) | y | y | y |  | y |  |
| [MedicationRequest](#MedicationRequest1-11) | 支援的Profiles  [用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)(治療資訊)  [事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md)(申請項目) | y | y | y |  | y |  |
| [Procedure](#Procedure1-12) | [放射/照光治療-Procedure TWPAS](StructureDefinition-Procedure-twpas.md) | y | y | y |  | y |  |
| [Substance](#Substance1-13) | [放射/照光治療總劑量-Substance TWPAS](StructureDefinition-Substance-twpas.md) | y | y | y |  | y |  |
| [Specimen](#Specimen1-14) | [基因檢測檢體-Specimen TWPAS](StructureDefinition-Specimen-twpas.md) | y | y | y |  | y |  |
| [DocumentReference](#DocumentReference1-15) | [文件參照-DocumentReference](StructureDefinition-DocumentReference-twpas.md) | y | y | y |  | y |  |
| [Coverage](#Coverage1-16) | [健保事前審查計畫-Coverage](StructureDefinition-Coverage-twpas.md) | y | y | y |  | y |  |
| [OperationOutcome](#Operationoutcome1-18) | [系統回應訊息-OperationOutcome TWPAS](StructureDefinition-Operationoutcome-twpas.md) | y | y | y |  | y |  |

-------

#### 預期的遵從度： 必須（SHALL） Bundle

Core FHIR Resource

[Bundle](https://hl7.org/fhir/R4/Bundle.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[癌藥事前審查-Bundle TWPAS](StructureDefinition-Bundle-twpas.md)
[事前審查回覆-Bundle Response TWPAS](StructureDefinition-Bundle-response-twpas.md)
[免疫製劑事前審查-Bundle Immunologic Aagent TWPAS](StructureDefinition-Bundle-immunologic-agent-twpas.md)

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Claim

Core FHIR Resource

[Claim](https://hl7.org/fhir/R4/Claim.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[癌藥事前審查-Claim TWPAS](StructureDefinition-Claim-twpas.md)
[免疫製劑事前審查-Claim Immunologic Aagent TWPAS](StructureDefinition-Claim-immunologic-agent-twpas.md)

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） ClaimResponse

Core FHIR Resource

[ClaimResponse](https://hl7.org/fhir/R4/claimresponse.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[自主審查-ClaimResponse Self Assessment TWPAS](StructureDefinition-ClaimResponse-self-assessment-twpas.md)
[事前審查結果-ClaimResponse TWPAS](StructureDefinition-ClaimResponse-twpas.md)

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） AllergyIntolerance

Profile

[過敏史-AllergyIntolerance TWPAS](StructureDefinition-AllergyIntolerance-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Organization

Core FHIR Resource

[Organization](http://hl7.org/fhir/R4/organization.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[機構-Organization TWPAS](StructureDefinition-Organization-twpas.md)
[基因檢測機構-Organization Genetic Testing TWPAS](StructureDefinition-Organization-genetic-testing-twpas.md)
[TW Core Organization Government](https://twcore.mohw.gov.tw/ig/twcore/0.3.2/StructureDefinition-Organization-govt-twcore.html)

#### 預期的遵從度： 必須（SHALL） Encounter

Core FHIR Resource

[Encounter](https://hl7.org/fhir/R4/Encounter.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[就醫科別-Encounter TWPAS](StructureDefinition-Encounter-twpas.md)
[門診病歷-Encounter OPD TWPAS](StructureDefinition-Encounter-opd-twpas.md) (門診病歷)

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Patient

Profile

[病人資訊-Patient TWPAS](StructureDefinition-Patient-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

Search Parameters


 

#### 預期的遵從度： 必須（SHALL） Practitioner

Profile

[醫事人員-Practitioner TWPAS](StructureDefinition-Practitioner-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） ImagingStudy

Profile

[DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Media

Profile

[非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） DiagnosticReport

Core FHIR Resource

[DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[影像報告-DiagnosticReport Image TWPAS](StructureDefinition-DiagnosticReport-image-twpas.md)
[檢查報告-DiagnosticReport TWPAS](StructureDefinition-DiagnosticReport-twpas.md)

#### 預期的遵從度： 必須（SHALL） Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[癌症分期量表-Observation Cancer Stage TWPAS](StructureDefinition-Observation-cancer-stage-twpas.md)
[基因資訊-Observation Diagnostic TWPAS](StructureDefinition-Observation-diagnostic-twpas.md)
[檢驗檢查-Observation Laboratory Result TWPAS](StructureDefinition-Observation-laboratory-result-twpas.md)
[病人狀態評估-Observation Patient Assessment TWPAS](StructureDefinition-Observation-pat-assessment-twpas.md)
[治療後疾病狀態評估-Observation Treatment Assessment TWPAS](StructureDefinition-Observation-tx-assessment-twpas.md)
[血型-Observation Blood Group TWPAS](StructureDefinition-Observation-blood-group-twpas.md)
[主觀描述-Observation Subjective TWPAS](StructureDefinition-Observation-subjective-twpas.md)
[客觀描述-Observation Objective TWPAS](StructureDefinition-Observation-objective-twpas.md)

#### 預期的遵從度： 必須（SHALL） ClinicalImpression

Profile

[評估-ClinicalImpression TWPAS](StructureDefinition-ClinicalImpression-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） CarePlan

Profile

[計畫-CarePlan TWPAS](StructureDefinition-CarePlan-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Condition

Profile

[診斷-Condition TWPAS](StructureDefinition-Condition-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） MedicationRequest

Core FHIR Resource

[MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

支援的Profiles
[用藥品項-MedicationRequest Treat TWPAS](StructureDefinition-MedicationRequest-treat-twpas.md)
[事前審查品項-MedicationRequest Apply TWPAS](StructureDefinition-MedicationRequest-apply-twpas.md)

#### 預期的遵從度： 必須（SHALL） Procedure

Profile

[放射/照光治療-Procedure TWPAS](StructureDefinition-Procedure-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Substance

Profile

[放射/照光治療總劑量-Substance TWPAS](StructureDefinition-Substance-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Specimen

Profile

[基因檢測檢體-Specimen TWPAS](StructureDefinition-Specimen-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） DocumentReference

Profile

[文件參照-DocumentReference TWPAS](StructureDefinition-DocumentReference-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Coverage

Profile

[健保事前審查計畫-Coverage TWPAS](StructureDefinition-Coverage-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.

#### 預期的遵從度： 必須（SHALL） Operationoutcome

Profile

[系統回應訊息-OperationOutcome TWPAS](StructureDefinition-Operationoutcome-twpas.md)

支援的參照政策（Reference policy）

`resolves`

能力摘要

* **必須（SHALL）**支援 `create`, `read`, `vread`, `update`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CapabilityStatementTWPASClient",
  "url" : "https://nhicore.nhi.gov.tw/pas/CapabilityStatement/CapabilityStatementTWPASClient",
  "version" : "1.1.0",
  "name" : "CapabilityStatementTWPASClient",
  "title" : "臺灣事前審查-用戶端(TWPAS Client)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-01",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保事前審查實作指引(TWPAS IG)用戶端(Client)之能力聲明",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+json", "application/fhir+xml"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "https://nhicore.nhi.gov.tw/pas/ImplementationGuide/tw.gov.mohw.nhi.pas"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "臺灣事前審查-用戶端(TWPAS Client)必須（SHALL）使用臺灣事前審查伺服端（TWPAS Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣事前審查Profile(s)。",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "有關要求和建議，請參閱[安全性](security.html)。"
      },
      "resource" : [
        {
          "type" : "Bundle",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-response-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Bundle-immunologic-agent-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Bundle-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Claim",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Claim-immunologic-agent-twpass"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Claim-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Claim-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "func-type",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Claim-func-type",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "ClaimResponse",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-self-assessment-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClaimResponse-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "request",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/ClaimResponse-request",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "created",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/ClaimResponse-created",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "disposition",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/ClaimResponse-disposition",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "adjudication-reason",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/ClaimResponse-adjudication-reason",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "AllergyIntolerance",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/AllergyIntolerance-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Organization",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Organization-genetic-testing-twpas",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Encounter",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Encounter-opd-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "service-type",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Encounter-service-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Patient",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Patient-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Patient-name",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "https://nhicore.nhi.gov.tw/pas/SearchParameter/Patient-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Practitioner-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "ImagingStudy",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ImagingStudy-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Media",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Media-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "DiagnosticReport",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-image-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DiagnosticReport-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Observation",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-cancer-stage-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-diagnostic-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-laboratory-result-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-pat-assessment-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-tx-assessment-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-blood-group-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-subjective-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Observation-objective-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "ClinicalImpression",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/ClinicalImpression-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "CarePlan",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/CarePlan-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Condition",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Condition-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "MedicationRequest",
          "supportedProfile" : [
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-treat-twpas",
            "https://nhicore.nhi.gov.tw/pas/StructureDefinition/MedicationRequest-apply-twpas"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Procedure",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Procedure-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Substance",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Substance-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Specimen",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Specimen-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "DocumentReference",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/DocumentReference-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "Coverage",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/Coverage-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "OperationOutcome",
          "profile" : "https://nhicore.nhi.gov.tw/pas/StructureDefinition/OperationOutcome-twpas",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "referencePolicy" : ["resolves"]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "transaction"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "batch"
        }
      ]
    }
  ]
}

```
