# SNOMEDCT-健保事前審查-身體部位值集 - 臺灣健保事前審查實作指引 v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SNOMEDCT-健保事前審查-身體部位值集**

## ValueSet: SNOMEDCT-健保事前審查-身體部位值集 

| | |
| :--- | :--- |
| *Official URL*:https://nhicore.nhi.gov.tw/pas/ValueSet/sct-body-site | *Version*:1.1.0 |
| Active as of 2025-10-01 | *Computable Name*:SNOMEDCTBodySite |

 
SNOMEDCT-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.md)。 

 **References** 

* [DICOM影像-ImagingStudy TWPAS](StructureDefinition-ImagingStudy-twpas.md)
* [非DICOM影像-Media TWPAS](StructureDefinition-Media-twpas.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sct-body-site",
  "url" : "https://nhicore.nhi.gov.tw/pas/ValueSet/sct-body-site",
  "version" : "1.1.0",
  "name" : "SNOMEDCTBodySite",
  "title" : "SNOMEDCT-健保事前審查-身體部位值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-01",
  "publisher" : "衛生福利部中央健康保險署",
  "contact" : [
    {
      "name" : "衛生福利部中央健康保險署",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nhi.gov.tw"
        }
      ]
    }
  ],
  "description" : "SNOMEDCT-健保事前審查-身體部位值集，代碼對應請參考[臺灣健保署身體部位代碼對應SNOMED CT](ConceptMap-nhi-sct-body-site.html)。",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "69536005"
          },
          {
            "code" : "45048000"
          },
          {
            "code" : "774007"
          },
          {
            "code" : "43799004"
          },
          {
            "code" : "122494005"
          },
          {
            "code" : "122495006"
          },
          {
            "code" : "122496007"
          },
          {
            "code" : "416550000"
          },
          {
            "code" : "80581009"
          },
          {
            "code" : "818987002"
          },
          {
            "code" : "816991004"
          },
          {
            "code" : "66019005"
          },
          {
            "code" : "36582005"
          },
          {
            "code" : "26107004"
          },
          {
            "code" : "113257007"
          },
          {
            "code" : "87141009"
          },
          {
            "code" : "3058005"
          },
          {
            "code" : "243928005"
          }
        ]
      }
    ]
  }
}

```
